<?php
/**
 * 前台用户model控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\front\model;
use think\Model;
use think\Session;

class Mem extends Model{
    /**
     * 用户注册数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function regist ($data) {
 
       $d = [
        'sex'          => $data['sex'],
        'brithday'     => $data['brithday'],
        'username'     => $data['username'],
        'create_time'  => date('Y-m-d H:i:s',time()),
        'user_number'  => $data['use_number'],
        ];
        if($data['growth_value']){
           $d['growth_value'] = $data['growth_value'];
        }
        if($data['total_score']){
           $d['total_score'] = $data['total_score'];
        }
        $data = db('m_users')
            ->where('openid','=',Session::get('openid'))
            ->update($d);

        return $data;
    }
    /**
     * 用户注册数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public static function memData ($openid) {
        $data = db('m_users')->where('openid','=',$openid)->find();
        return $data;
    }
    /**
     * 用户微信数据处理入库
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memPut ($data) {
        if(!$data['openid']){
            return false;
        }
        $res = db('m_users')->insert($data);
        if($res){
            $userId = db()->getLastInsID();
            return $userId;
        }else{
            return false;
        }
    }
    /**
     * 用户openid获取用户数据
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memOne ($openid) {
        $memid = db('m_users')
            ->alias('u')
            ->field(
                'u.create_time,u.user_number,u.money,p.phone,
                ifnull(u.growth_value,p.growth_value) as growth_value,
                u.username,u.total_score,u.update_time,u.id,u.openid,u.brithday,u.merryday'
                )
            ->join('m_users_phone p','p.userid=u.id','left')
            ->where('u.openid','=',$openid)
            ->find();
        return $memid;
    }
    
    /**
     * 修改积分    首次登陆或者每日登陆
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function addMemScore ($userid,$score,$typeid=0,$phoneid=0){
        $d = [
            'm_title'=> $typeid==1?'首次登陆':'每日登陆',
            'm_type' => 1,
            'm_time' => date('Y-m-d H:i:s')
        ];    

        if($typeid==1){

            $res = AddScore($userid,$phoneid,$score,$d['m_type'],$d['m_title']);
            //$res = addScoreLog($userid,'',$score,$d['m_type'],$d['m_title'],2);//新的积分日志
            if($res === false){
                return false;
            }

        }else{
            $lasttime = db('m_users')->where(['id'=>$userid,'last_land_time'=>['>=',$d['m_time']]])->find();

            if(!$lasttime){
                db()->startTrans();
                try{
                    $data = db("minute_log")->where("m_executor",$userid)->where("m_time",">",date("Y-m-d 0:0:0",time()))->where("m_title","like","%每日登陆%")->find();
                    if($data){
                        db()->rollback();
                        return false;
                    }
                    $res = AddScore($userid,$phoneid,$score,$d['m_type'],$d['m_title']);
                    //$res = addScoreLog($userid,'',$score,$d['m_type'],$d['m_title'],2);//新的积分日志
                    if($res === false){
                        db()->rollback();
                        return false;
                    }

                    db()->commit();
                    return true;
                }
                catch(\Exception $e){
                    db()->rollback();
                    return false;
                }
            }
        }
        return true;
    }
}