<?php
/**
* 会员接口中心
*
* ============================================================================
* 版权所有 2017北京素玄科技，并保留所有权利。
*
* 网站地址: http://www.suxuantech.com
* ----------------------------------------------------------------------------
* 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
* 不允许对程序代码以任何形式任何目的的再发布。
* 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
* ============================================================================
* Author: Yan Lipeng <Yan Lipeng@suxuantech.cn>  2017年11月16日 下午3:48:53
*/
namespace app\index\api;

use think\Cache;
use think\Session;
use app\vip\controller\User;
class Erpapi{
    /**
     * ERP成单、发送模板消息
     * @param  [type] $template_id [description] 模板id
     * @param  [type] $phone       [description] 手机号
     * @param  [type] $data        [description] 传递的数据
     * @return [type]              [description]
     */
    public function template($data,$appid){
        $template_id = $data['template_id'];
        $phone = $data['phone'];
        $data  = $data['data'];
        if(!$template_id){
            return array('code'=>203,'msg'=>"template_id为必传参数，请传参！",'error'=>1);
        }
        if(!$phone){
            return array('code'=>204,'msg'=>"phone为必传参数，请传参！",'error'=>1);
        }
        if(!$data){
            return array('code'=>205,'msg'=>"data为必传参数，请传参！",'error'=>1);
        } 
        $data = json_decode($data,true);
        if(strpos($phone,",") !== false){
            $phoneArr = explode(',',$phone);
            foreach ($phoneArr as $key => $value) {
                $Userdata[] = db("m_users_phone")->alias('p')->join("m_users u",'p.userid=u.id')->where("p.phone",$value)->field("u.openid,p.phone")->find();
            }
            $temp = [];
            foreach ($Userdata as $key => $value) {
                $res = $this->Wxtemplate($Userdata[$key]['openid'],$template_id,$data,$phoneArr[$key]);
                if($res){
                    $temp[] = $res;
                }
            }
        }else{
            $Userdata = db("m_users_phone")->alias('p')->join("m_users u",'p.userid=u.id')->where("p.phone",$phone)->field("u.openid,p.phone")->find();
            $temp = $this->Wxtemplate($Userdata['openid'],$template_id,$data,$phone);
        }
        if(!$temp){
            return array('code' => 200, 'msg' => '发送成功');
        }else{
            if(is_array($temp)){
                $temp = implode(',', $temp);
                return array('code'=>202,'msg'=>$temp.'发送失败','error'=>1);
            }else{
                return array('code'=>202,'msg'=>$temp.'发送失败','error'=>1);
            }
        }
    }
    /**
     * 发送模板消息
     * @param [type] $openid      [description]
     * @param [type] $template_id [description]
     * @param [type] $data        [description]
     * @param [type] $phone        [description]
     */
    protected function Wxtemplate($openid,$template_id,$data,$phone,$brandid){
        $content = [
                    'touser' => $openid,
                    'template_id' => $template_id,
                    'data'=> $data['data'],
                ];
                $send_data['content'] = json_encode($content);
                $send_data['brandclass_id'] = $brandid;
                $res = sendMemberWxMsg($send_data);
                if($res['code'] != 200){
                    return $phone;
                }
    }
    /**
     * 评价生成二维码 
     * (
     *  接口调用成功：
     *     1、返回二维码的url，
     *     2、直接访问地址可获取二维码，
     *     3、扫码二维码进入公众号，
     *     4、公众号自动推一条信息链接，
     *     5、点击信息链接进入评价页面
     *  )
     * @param [type] $brandid [description]
     */
    public function AppraiseQr($data,$appid){
        if($data['orderId']){
            $scene = 'brandid'.$data['brandid'].'-PJ_'.$data['orderId'];
        }else{
            $scene = 'brandid'.$data['brandid'].'-PJ';    
        }
        $qrdata = [
            'brandclass_id'=>$data['brandid'],
            'type'=>1,//永久二维码
            'scene'=>$scene,
        ];
        $res = sx_call('5a73d4f13a9eb',$qrdata);
        if(!$res['data']['ticket']){
           return array('code'=>202,'msg'=>'二维码生成失败','error'=>1);
        }else{
            $url = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=".$res['data']['ticket'];
            return array('code'=>200,'msg'=>'二维码生成成功','data'=>$url);
        }
    }


    /*
     * 获取订单先睹为快中 对摄影师的评价
     */
    public function getOrderCameramanScore($params){

        $orderId = $params['orderId'];
        $fc = $params['fc'];

        if(!$orderId){
            return ['code'=>201,'msg'=>'请传参orderId'];
        }

        if(!$fc){
            return ['code'=>201,'msg'=>'请传参fc'];
        }

        $detail = db('m_order_cameraman_score')->where(['orderId'=>$orderId,'fc'=>$fc])->find();

        if($detail){
            return $detail;
        }else{
            return ['code'=>203,'msg'=>'顾客还没有评价'];
        }

    }

    /**
     * erp充值时，获取会员信息，
     * @param [type] $phone [description] 会员手机号
     */
    public function Getuserinfo($params){

        if(!$params['phone']){
            return array('code'=>203,'msg'=>"phone为必传参数，请传参！",'error'=>1);
        }

        $userInfo = db("m_users")->where("phone",$params['phone'])->find();
        if(!$userInfo){
            return array('code'=>204,'msg'=>"该手机号还没有注册会员哦~",'error'=>1);   
        }else{
            return array('code'=>200,'msg'=>'查询成功','data'=>$userInfo);
        }


    }
    /**
     * [operationMoney Erp扣款/充值接口]
     * @param  [type] payclass      [1 充值 2 扣款]
     * @param  [type] payment_money [实收金额]
     * @param  [type] charge_money  [充入金额]
     * @param  [type] cashierman    [收银员]
     * @param  [type] card          [会员卡号]
     * @param  [type] paytype       [付款类型（现金、刷卡、微信、支付宝）]
     * @param  [type] shop_code     [店面简码]
     * @param  [type] shop_name     [店面名称]
     * @param  [type] brandid       [事业部id]
     * @param  [type] orderid       [单号]
     * @param  [type] phone         [手机号]
     * @param  [type] create_time   [创建时间]
     */
    public function operationMoney($params){
        if(!$params['payclass']){
            return array('code'=>202,'msg'=>'payclass值为必传！','error'=>1);
        }
        if(!$params['phone']){
            return array('code'=>202,'msg'=>'phone值为必传！','error'=>1);
        }
        $userinfo = db('m_users')->where('phone',$params['phone'])->find();
        if(!$userinfo){
            return array('code'=>203,'msg'=>'该手机号还没有注册会员哦~','error'=>1);
        }
        if($params['payclass'] != 1 && $params['payclass'] != 2){
            return array('code'=>202,'msg'=>'payclass值错误！','error'=>1);
        }
        db()->startTrans();
        try{
            $charge_money = $params['charge_money'];
            if($params['payclass'] == 1){
                $res = db("m_users")->where('phone',$params['phone'])->update(['money'=>['exp',"money + $charge_money"]]);
                if($res === false){
                    db()->rollback();
                    return array('code'=>202,'msg'=>'充值失败','error'=>1);      
                }
            }elseif($params['payclass'] == 2){
                if(!$params['password']){
                    return ['code'=>202,'msg'=>'密码不能为空！','error'=>1];
                }
                if(!$userinfo['password']){
                    return ['code'=>202,'msg'=>'您还未设置密码，请设置~！','error'=>1];   
                }
                if(think_encrypt($params['password']) !== $userinfo['password']){
                    return ['code'=>202,'msg'=>'密码输入不正确！','error'=>1];
                }
                if($userinfo['money'] < $charge_money){
                    return array('code'=>202,'msg'=>'余额不足，请先充值~','error'=>1);    
                }
                $res = db("m_users")->where('phone',$params['phone'])->update(['money'=>['exp',"money - $charge_money"]]);
                if($res === false){
                    db()->rollback();
                    return array('code'=>202,'msg'=>'扣款失败','error'=>1);      
                }
            }
            $data = [
                'payclass'      => $params['payclass'],
                'payment_money' => $params['payment_money'],
                'charge_money'  => $params['charge_money'],
                'cashierman'    => $params['cashierman'],
                'card'          => $params['card'],
                'paytype'       => $params['paytype'],
                'shop_code'     => $params['shop_code'],
                'shop_name'     => $params['shop_name'],
                'brandid'       => $params['brandid'],
                'orderid'       => $params['orderid'],
                'phone'         => $params['phone'],
                'create_time'   => date('Y-m-d H:i:s',time()),
            ];
            $addres = db('p_payment')->insert($data);
            if($addres){
                db()->commit();
                $msg = $params['payclass'] == 1?'充值':'扣款';
                return array('code'=>200,'msg'=>$msg.'成功');                   
            }
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>202,'msg'=>$e);
        }

    }

    /*
     * 获取用户线上交易记录
     * @param  [type] $params['phone'] [手机号]
     */
    public function getUserPayLog($params){
        if(!$params['phone']){
            return ['error'=>1,'code'=>102,'msg'=>'请输入手机号'];
        }
        $userinfo = db('m_users')->where('phone',$params['phone'])->find();
        if(!$userinfo){
            return array('code'=>203,'msg'=>'该手机号还没有注册会员哦~','error'=>1);
        }
        $data = db('s_package_order')
                ->where('user_id',$userinfo['id'])
                ->where('payment_status',2)
                ->select();
        if($data){
            return $data;
        }else{
            return ['error'=>1,'msg'=>'该用户没有交易记录','code'=>202];
        }
    }

    /*
     * erp线下会员卡充值，奖励绑定了此会员卡的线上会员积分
     */
    public function erpVipCardChargeMoneyReward($params){

        $cardid = $params['cardid'];
        $money  = $params['money'];

        if(!$cardid){
            return ['code'=>201,'msg'=>'请传会员卡号（cardid）','error'=>1];
        }

        if (!is_numeric($money)) {
            return ['code'=>202,'msg'=>'请传有效的充值金额，必须为数字（money）','error'=>1];
        }

        $userInfo = db('m_users')->where('erp_vipcard',$cardid)->find();
        if($userInfo){

            $sys = db('c_sysconfig')->where('ckey',SX_CHARGE)->value('cvalue');
            $rule = json_decode($sys,true);
            $pay = $rule['charge_money'];  //充值多少金额
            $score = $rule['score'];       //奖励多少积分
            $addScore = ($score/$pay) * $money; //获取积分

            db()->startTrans();
            try{
                $updateData['total_score']  = ['exp',"total_score + $addScore"];
                db('m_users')->where('id',$userInfo['id'])->update($updateData);

                //积分记录
                $addLog = addScoreLog ('erp线下会员卡充值',$addScore,$userInfo['id'],21,'',1,'');
                if($addLog === false){
                    db()->rollback();
                    return ['code'=>204,'msg'=>'插入充值记录失败','error'=>1];
                }
                db()->commit();
                return ['msg'=>'success'];

            }catch (\Exception $e){

                db()->rollback();
                return ['code'=>204,'msg'=>'充值奖励失败-'.$e->getMessage(),'error'=>1];
            }

        }else{
            return ['code'=>203,'msg'=>'没有线上会员绑定此卡号','error'=>1];
        }

    }

}