<?php
/**
 * {文件功能描述} 获取用户信息的接口
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2018年1月2日 下午8:13:11
 */
namespace app\index\api;
class Order {

    /**
    * 方法描述: 订单支付状态通知 并erp开单
    *
    */
    public function setErpOrder($params){
        $order_no = $params["order_no"];  //单号
        $pay_fee = $params["pay_fee"];  //支付金额
        $pay_status = $params["pay_status"];  //支付状态

        //$id       = input("id");//套系主键id
        if(!$order_no){
            payment_log("mc回调支付未接收到单号");
            return array('error'=>1,'code'=>204,'msg'=>'mc回调支付未接收到单号');
        }

        //$data['payment_order_sn'] = $order_no;

        //订单详情
        //$orderInfoData = controller($this->libname,'lib')->orderinfoList($data);
        $orderInfoData = db('s_order_serial')
            ->where('serial_number',$order_no)
            ->alias('a')
            ->join('s_order_info b','a.order_number = b.payment_order_sn','left')
            ->find();

        //套系详情
        $packageData   = controller('front/Jgqvip','lib')->getPackageData($orderInfoData['pid']);

        //优惠券详情
        $coupon = db('c_coupon_list')->where('id',$orderInfoData['coupon_id'])->find();
        if($coupon['discount_type'] == 3){
            $productInfo = $coupon['product_info'];
        }

        //确认支付成功
        //$paymentJudge  = controller("Payment","lib")->paymentJudge($order_no,$packageData['package_price']);
        if($pay_status == "PAYED" && $pay_fee == $orderInfoData['pay_money'] * 100){//判断支付成功

            //同步ERP开单
            $erp     = config('ext.app_config');  //读取erp配置文件
            $addr    = $erp['sx_erp']['addr'];    //调用url
            $url     = $addr."/SXWebErpAppStaff/SX_OpenOrderVIPJGQ?Token=^******^";
            

            $brandid = $orderInfoData["brand_id"];
            $userData = db('m_users_phone')->where('userid',$orderInfoData['user_id'])->find();

            //推荐人信息
            $recommend = db('recommend')->where('r_phone',$userData['phone'])
                ->alias('a')
                ->join('m_users_phone b','a.userid = b.userid','lef t')
                ->field('b.id,b.phone,b.real_name,b.username')
                ->find();

            if($userData['sex'] == 1){
                $sex = "男";
            }else{
                $sex = "女";
            }
            $dataN = [
                'wname'                      => $orderInfoData['user_name'],
                'wphone'                     => $orderInfoData['user_tel'],
                'wwechat'                    => $orderInfoData['user_wechat'],
                'address'                    => $orderInfoData['user_address'],
                'cssname'                    => '',
                'area'                       => '',
                'shop_code'                  => $packageData['shop_code'],
                'shop_name'                  => $packageData['shop_name'],
                'Consumption_type'           => XFLX_NAME,
                //'Package_name'               => $packageData['package_name'],
                'Package_name'               => $packageData['erp_package_name'],//erp套系名称
                'Acceptor_address'           => '',
                'Brandid'                    => $brandid,
                'BrandidConsumption_type_id' => '',
                'Consumption_type_id'        => XFLX_ID,
                'Cssname_id'                 => '',
                'Area_id'                    => '',
                'Sex'                        => $sex,
                'PayMoney'                   => $orderInfoData['pay_money'],//实际支付金额
                'Taoxijine'                  => $packageData['package_price'] - $orderInfoData['preferential_money'],//套系金额=实际套系金额-优惠金额
                'SN'                         => $packageData['shop_sn'],
                'vip_order_sn'               => $orderInfoData['payment_order_sn'],
                'recommend_phone'            => $recommend['phone'], //推荐人手机号
                'recommend_name'             => $recommend['real_name'] ? $recommend['real_name']:$recommend['username'], //推荐人姓名
                'productinfo'                => $productInfo,
            ];
            $dataN    = json_encode($dataN);
            $response = requestERP($url, $dataN);  //调用erp接口
            if (!$response['Code'] == 200) {
                payment_log("同步ERP开单失败",$newdata.json_encode($response));
                return array('error'=>1,'code'=>201,'msg'=>'同步ERP开单失败');
            }

            //修改订单状态
            $erp_order_sn = $response['Data'];
            $where['id'] = $orderInfoData['id'];
            $res = controller("front/Jgqvip","lib")->paymentStatus($order_no,$erp_order_sn);
            if(!$res){
                $newdata = "流水单号=".$order_no."<br>ERP单号=".$erp_order_sn."<br>金额=".$packageData['package_price'];
                payment_log("订单支付状态修改失败",$newdata);
                return array('error'=>1,'code'=>202,'msg'=>'订单支付状态修改失败');
            }

            return array('msg'=>'success');

        }else{
            $newdata = "单号=".$order_no."<br>金额".$orderInfoData['price'];
            payment_log("支付失败或支付金额不符",$newdata);
            return array('error'=>1,'code'=>203,'msg'=>'支付失败或支付金额不符');
        }


    }


    /*
     * 更改99会员支付状态
     */
    public function jgqVip($params){
        $order_no = $params["order_no"];  //单号
        $pay_fee  = $params["pay_fee"];  //支付金额
        $pay_status = $params["pay_status"];  //支付状态
        $attach   = $params["attach"];  //用于区分订单类型


        //99会员订单详情
        $orderInfoData = db('jgq_vip_list')->where('order_sn',$order_no)->find();

        //确认支付成功
        if($pay_status == "PAYED" && $pay_fee == $orderInfoData['price'] * 100){//判断支付成功

            db()->startTrans();

            $res = db('jgq_vip_list')->where('order_sn',$order_no)->update(['pay_status'=>2,'pay_time'=>date('Y-m-d H:i:s')]);

            if($res === false){
                db()->rollback();
                return array('error'=>1,'code'=>204,'msg'=>'更改99会员支付状态失败');
            }

            $couponid = json_decode($orderInfoData['coupon_data'],true);
            foreach ($couponid as $k => $v) {
                $c = [
                    'userid' => $orderInfoData['user_id'],
                    'coupon_num' => $v['couponid'],
                    'is_shareholder' => 1  //不验证优惠券的领取限制
                ];
                if ($c['userid'] && $c['coupon_num']) {
                    for($i=1;$i<=$v['num'];$i++){
                        $d = controller('front/index', 'lib')->getReceive($c);

                        $resData =  json_decode($d,true);
                        $status = $resData['status'];

                        textlog($d);
                        textlog($status.'========'.$resData['msg']);

                        if(!$d || $status != 1){
                            db()->rollback();
                            return array('error'=>1,'code'=>202,'msg'=>'添加优惠券失败');
                        }
                    }
                }
            }

            db()->commit();
            return array('msg'=>'success');

        }else{
            return array('error'=>1,'code'=>201,'msg'=>'支付失败或支付金额不符');
        }
    }



    /*
     * 上门拍活动订单
     */
    public function activeSmp($params){
        $order_no = $params["order_no"];  //单号
        $pay_fee = $params["pay_fee"];  //支付金额
        $pay_status = $params["pay_status"];  //支付状态

        //活动报名订单详情
        $orderInfoData = db('a_activity_smp')->where('order_sn',$order_no)->find();

        //确认支付成功
        if($pay_status == "PAYED" && $pay_fee == $orderInfoData['price'] * 100){//判断支付成功
            $res = db('a_activity_smp')->where('order_sn',$order_no)->update(['pay_status'=>2,'pay_time'=>date('Y-m-d H:i:s')]);
            if($res === false){
                return array('error'=>1,'code'=>202,'msg'=>'更改上门拍活动订单支付状态失败');
            }else{
                return array('msg'=>'success');
            }
        }else{
            return array('error'=>1,'code'=>201,'msg'=>'支付失败或支付金额不符');
        }
    }



    /*
     * erp线下订单的支付
     */
    public function paymentErpOrder($params){


        if(!$params["order_no"]){
            payment_log("mc回调支付未接收到支付单号");
            return array('error'=>1,'code'=>204,'msg'=>'mc回调支付未接收到支付单号');
        }

        $res = controller('Index/Order','lib')->paymentErpOrder($params);
        return $res;
    }


    /*
     * 儿童套系，修改vip订单状态，erp下单
     */
    public function setChildPackageOrder($params){

        if(!$params["order_no"]){
            payment_log("mc回调支付未接收到单号",'','');
            return array('error'=>1,'code'=>204,'msg'=>'mc回调支付未接收到单号');
        }

        $res = controller('Order','lib')->setChildPackageOrder($params);
        return $res;

    }


    /*
     * 6+1先睹为快打赏礼物，礼物购买状态
     */
    public function checkGiftBuy($params){

        if(!$params["order_no"]){
            payment_log("mc回调支付未接收到单号",'','');
            return array('error'=>1,'code'=>204,'msg'=>'mc回调支付未接收到单号');
        }

        $res = controller('Order','lib')->checkGiftBuy($params);
        return $res;

    }


    /*
     * 会员卡充值
     */
    public function setcharge($params){
        $order_no = $params["order_no"];  //单号
        $pay_fee = $params["pay_fee"];  //支付金额
        $pay_status = $params["pay_status"];  //支付状态

        //活动报名订单详情
        $chargeData = db('c_charge_log')->where('order_sn',$order_no)->find();

        //确认支付成功
        if($pay_status == "PAYED" && $pay_fee == $chargeData['price']){//判断支付成功
            $res = db('c_charge_log')->where('order_sn',$order_no)->update(['pay_status'=>2,'pay_time'=>date('Y-m-d H:i:s')]);
            if($res === false){
                return array('error'=>1,'code'=>202,'msg'=>'更改会员卡充值支付状态失败');
            }else{
                $userRes = db('m_users')->where('id',$chargeData['userid'])->update(["total_score + $pay_fee/100"]);
                if(!$userRes === false){
                    return array('error'=>1,'code'=>202,'msg'=>'添加金额失败');  
                }
                return array('msg'=>'success');
            }
        }else{
            return array('error'=>1,'code'=>201,'msg'=>'支付失败或支付金额不符');
        }
    }


}