<?php
/**
* 会员接口中心
*
* ============================================================================
* 版权所有 2017北京素玄科技，并保留所有权利。
*
* 网站地址: http://www.suxuantech.com
* ----------------------------------------------------------------------------
* 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
* 不允许对程序代码以任何形式任何目的的再发布。
* 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
* ============================================================================
* Author: Yan Lipeng <Yan Lipeng@suxuantech.cn>  2017年11月16日 下午3:48:53
*/
namespace app\index\api;

use think\Cache;
use think\image\Exception;
use think\Session;
use app\vip\controller\User;
class Port{

    /*
     * erp新增订单
     * （若手机号用户不存在，则订单表中记录手机号，没有user_id，也没有其他任何表用户id）
     */
    public function addOrder ($params,$appId) {
        $tel = trim($params['tel']);         //女士手机号优先
        $brandId = $params['brand_id'];      //品牌id
        $orderTime = $params['order_time'];  //订单时间
        $orderCode = $params['order_code'];  //传入的订单编号id
        $oneMoney = $params['one_money'];    //一销金额
        $twoMoney = $params['two_money'];    //二销金额
        $oneDetail = $params['one_detail'];  //一销明细
        $twoDetail = $params['two_detail'];  //二销明细
        $totalMoney = $params['total_money'];//订单总金额
        $package_name = $params['package_name'];//套系名称
        //$vip_order_sn = $params['vip_order_sn'];

        if (!is_numeric($brandId)) {
            return array('code'=>212,'msg'=>'请确保输入的事业部id正确且只能为数字','error'=>1);
        }

        $orderTime = date('Y-m-d',strtotime($orderTime));

        /*
        $checkTime = self::isDateTime($orderTime);
        if ($checkTime == 2) {
            return array('code'=>211,'msg'=>'请确保日期格式正确','error'=>1);
        }
        if ($checkTime == false) {
            return array('code'=>210,'msg'=>'请输入正确的时间(请确保格式正确.例如2017-01-02)','error'=>1);
        }
        */

        if (empty($brandId) && empty($orderCode)) {
            return array('code'=>208,'msg'=>'请确保事业部id不为空','error'=>1);
        }

        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel); //验证手机号
        if (!$checkTel) {
            return array('code'=>207,'msg'=>'请输入正确手机号','error'=>1);
        }
        if (!is_numeric($oneMoney) && !is_numeric($twoMoney) && !is_numeric($oneDetail) && !is_numeric($twoDetail)) {
            return array('code'=>209,'msg'=>'请输入有效的金额且必须为数字','error'=>1);
        }


        //读取配置集团事业部
        $conf_brandid = db_config('sx_brand');
        if($conf_brandid == $brandId){
            $user_brand_id = 0;
        }else{
            $user_brand_id = $brandId;
        }

        //用户信息
        $userData = db("m_users")->where("phone",$tel)->where("brandid",$user_brand_id)->find();

        //return ['sql'=>db()->getLastSql(),'brand_id'=>$user_brand_id,'data'=>$userData];

        $user_id = $userData['id'];

        //新增订单数据
        $orderData = [
            'order_time'   => $orderTime,
            'order_number' => $orderCode,
            'one_money'    => $oneMoney,
            'two_money'    => $twoMoney,
            'one_detail'   => $oneDetail,
            'two_detail'   => $twoDetail,
            'phone'        => $tel,
            'brandid'      => $brandId,
            'total_money'  => $totalMoney,
            'package_name' => $package_name,
            'create_time'  => date('Y-m-d H:i:s'),
            'user_id'      => $user_id,
        ];

        //只要收款有金额，则可审核给推荐人奖励
        if($oneDetail > 0 || $twoDetail > 0){
            $orderData['can_check'] = 1;//订单，可审核，奖励
        }elseif($oneDetail == 0 && $twoDetail == 0){
            $orderData['can_check'] = 2;//不可审核
        }

        //检测推荐人表里是否有人推荐此用户，推荐通过，未领取过奖励，推荐手机号为成单手机号
        $recommend = db('recommend')->where(['status'=>2,'r_phone'=>$tel,'is_get'=>2])->find();
        if(!empty($recommend)){
            $orderData['recommend_id'] = $recommend['id'];
        }

        $orderCheck = db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->find();  //看当前用户在订单表中是否有此订单
        if (!$orderCheck) {

            //检测vip订单表里是否存在此订单，是否使用优惠券
            //if($vip_order_sn){
            //    $vipOrder = db('s_order_info')->where('payment_order_sn',$vip_order_sn)->find();
            //}

            //user_phone表id
            //$orderData['order_type']   = $vipOrder ? 1 : 2;
            //$orderData['coupon_id']    = $vipOrder['coupon_id'];
            $res = db('m_order')->insert($orderData);
            if($res === false){
                return array('error'=>1,'code'=>204,'msg'=>'vip绑定订单失败');
            }

        }else{
            $upRes = db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->update($orderData);
            if($upRes === false){
                return array('error'=>1,'code'=>204,'msg'=>'vip更新绑定订单失败');
            }
        }

        return array('msg'=>'success');

    }

    public function defaultVip ($params,$appId) {
        $tel = trim($params['tel']);         //女士手机号优先
        $brandId = $params['brand_id'];      //品牌id
        $orderTime = $params['order_time'];  //订单时间
        $orderCode = $params['order_code'];  //传入的订单编号id
        $oneMoney = $params['one_money'];    //一销金额
        $twoMoney = $params['two_money'];    //二销金额
        $oneDetail = $params['one_detail'];  //一销明细
        $twoDetail = $params['two_detail'];  //二销明细
        $totalMoney = $params['total_money'];//订单总金额
        $package_name = $params['package_name'];//套系名称
        //$vip_order_sn = $params['vip_order_sn'];

        if (!is_numeric($brandId)) {
            return array('code'=>212,'msg'=>'请确保输入的事业部id正确且只能为数字','error'=>1);
        }

        $orderTime = date('Y-m-d',strtotime($orderTime));

        /*
        $checkTime = self::isDateTime($orderTime);
        if ($checkTime == 2) {
            return array('code'=>211,'msg'=>'请确保日期格式正确','error'=>1);
        }
        if ($checkTime == false) {
            return array('code'=>210,'msg'=>'请输入正确的时间(请确保格式正确.例如2017-01-02)','error'=>1);
        }
        */

        if (empty($brandId) && empty($orderCode)) {
            return array('code'=>208,'msg'=>'请确保事业部id不为空','error'=>1);
        }

        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel); //验证手机号
        if (!$checkTel) {
            return array('code'=>207,'msg'=>'请输入正确手机号','error'=>1);
        }
        if (!is_numeric($oneMoney) && !is_numeric($twoMoney) && !is_numeric($oneDetail) && !is_numeric($twoDetail)) {
            return array('code'=>209,'msg'=>'请输入有效的金额且必须为数字','error'=>1);
        }


        //读取配置集团事业部
        $conf_brandid = db_config('sx_brand');
        if($conf_brandid == $brandId){
            $user_brand_id = 0;
        }else{
            $user_brand_id = $brandId;
        }

        //用户信息
        $userData = db("m_users")->where("phone",$tel)->where("brandid",$user_brand_id)->find();

        //return ['sql'=>db()->getLastSql(),'brand_id'=>$user_brand_id,'data'=>$userData];

        $user_id = $userData['id'];

        //新增订单数据
        $orderData = [
            'order_time'   => $orderTime,
            'order_number' => $orderCode,
            'one_money'    => $oneMoney,
            'two_money'    => $twoMoney,
            'one_detail'   => $oneDetail,
            'two_detail'   => $twoDetail,
            'phone'        => $tel,
            'brandid'      => $brandId,
            'total_money'  => $totalMoney,
            'package_name' => $package_name,
            'create_time'  => date('Y-m-d H:i:s'),
            'user_id'      => $user_id,
        ];

        //只要收款有金额，则可审核给推荐人奖励
        if($oneDetail > 0 || $twoDetail > 0){
            $orderData['can_check'] = 1;//订单，可审核，奖励
        }elseif($oneDetail == 0 && $twoDetail == 0){
            $orderData['can_check'] = 2;//不可审核
        }

        //检测推荐人表里是否有人推荐此用户，推荐通过，未领取过奖励，推荐手机号为成单手机号
        $recommend = db('recommend')->where(['status'=>2,'r_phone'=>$tel,'is_get'=>2])->find();
        if(!empty($recommend)){
            $orderData['recommend_id'] = $recommend['id'];
        }

        $orderCheck = db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->find();  //看当前用户在订单表中是否有此订单
        if (!$orderCheck) {

            //检测vip订单表里是否存在此订单，是否使用优惠券
            //if($vip_order_sn){
            //    $vipOrder = db('s_order_info')->where('payment_order_sn',$vip_order_sn)->find();
            //}

            //user_phone表id
            //$orderData['order_type']   = $vipOrder ? 1 : 2;
            //$orderData['coupon_id']    = $vipOrder['coupon_id'];
            $res = db('m_order')->insert($orderData);
            if($res === false){
                return array('error'=>1,'code'=>204,'msg'=>'vip绑定订单失败');
            }

        }else{
            $upRes = db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->update($orderData);
            if($upRes === false){
                return array('error'=>1,'code'=>204,'msg'=>'vip更新绑定订单失败');
            }
        }

        return array('msg'=>'success');
    }


    /*
     * erp订单完成，积分变动 等级变动
     * （若手机号用户不存在，则在user_phone表记录用户手机号、等级、积分，order表只记录手机号，绑定手机时 根据手机号同步数据）
     */
    public function endOrder ($params,$appId) {
        $tel = trim($params['tel']);         //女士手机号优先
        $brandId = $params['brand_id'];      //品牌id
        $orderTime = $params['order_time'];  //订单时间
        $orderCode = $params['order_code'];  //传入的订单编号id
        $oneMoney = $params['one_money'];    //一销金额
        $twoMoney = $params['two_money'];    //二销金额
        $oneDetail = $params['one_detail'];  //一销明细
        $twoDetail = $params['two_detail'];  //二销明细
        $totalMoney = $params['total_money'];//订单总金额
        $package_name = $params['package_name'];//套系名称
        $vip_order_sn = $params['vip_order_sn'];

        if (!is_numeric($brandId)) {
            return array('code'=>212,'msg'=>'请确保输入的事业部id正确且只能为数字','error'=>1);
        }

        $orderTime = date('Y-m-d',strtotime($orderTime));
        /*
        $checkTime = self::isDateTime($orderTime);
        if ($checkTime == 2) {
            return array('code'=>211,'msg'=>'请确保日期格式正确','error'=>1);
        }
        if ($checkTime == false) {
            return array('code'=>210,'msg'=>'请输入正确的时间(请确保格式正确.例如2017-01-02)','error'=>1);
        }
        */
        if (empty($brandId) && empty($orderCode)) {
            return array('code'=>208,'msg'=>'请确保事业部id不为空','error'=>1);
        }

        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel); //验证手机号
        if (!$checkTel) {
            return array('code'=>207,'msg'=>'请输入正确手机号','error'=>1);
        }
        if (!is_numeric($oneMoney) && !is_numeric($twoMoney) && !is_numeric($oneDetail) && !is_numeric($twoDetail)) {
            return array('code'=>209,'msg'=>'请输入有效的金额且必须为数字','error'=>1);
        }

        //读取配置集团事业部
        $conf_brandid = db_config('sx_brand');
        if($conf_brandid == $brandId){
            $user_brand_id = 0;
        }else{
            $user_brand_id = $brandId;
        }

        //用户信息
        $userData = db("m_users")->where("phone",$tel)->where("brandid",$user_brand_id)->find();

        if($userData){
            $user_id = $userData['id'];
            //会员等级
            $level_id = $userData['level'];

        }else{
            //会员不存在，按照最低等级积分规则
            $level_id = getLowestLevel()['id'];
        }

        //检测是否存在订单
        $orderCheck = db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->find();  //看当前用户在订单表中是否有此订单

        $orderData = [
            'one_money'    => $oneMoney,
            'two_money'    => $twoMoney,
            'one_detail'   => $oneDetail,
            'two_detail'   => $twoDetail,
            'total_money'  => $totalMoney,
            'can_check'    => 1,//订单，可审核，奖励
            'is_end'       => 1,//1订单已完成，2未完成
        ];

        db()->startTrans();
        try{
            if ($orderCheck) {

                //修改订单信息
                db('m_order')->where('order_number',$orderCode)->where('user_id',$user_id)->where('delete_time is null')->update($orderData);

            }else{

                //没有订单信息，新增订单数据
                $orderData['order_time']   = $orderTime;
                $orderData['order_number'] = $orderCode;
                $orderData['phone']   = $tel;
                $orderData['brandid'] = $brandId;
                $orderData['package_name'] = $package_name;
                $orderData['create_time']  = date('Y-m-d H:i:s');
                $orderData['user_id']      = $user_id;

                //检测推荐人表里是否有人推荐此用户，推荐通过，未领取过奖励，推荐手机号为成单手机号
                $recommend = db('recommend')->where(['status'=>2,'r_phone'=>$tel,'is_get'=>2])->find();
                if(!empty($recommend)){
                    $orderData['recommend_id'] = $recommend['id'];
                }

                db('m_order')->insert($orderData);
            }


            //订单没标记完成的情况下才加积分，标记完成后再也不加
            if($orderCheck['is_end'] != 1){
                //积分规则
                $scoreRule = getLevelRule($level_id);


                $onePay = $scoreRule['fristbuy'];            //一销花费
                $oneScore = $scoreRule['fristbuy_score'];    //奖励
                $secondPay = $scoreRule['secondbuy'];        //二销花费
                $secondScore = $scoreRule['secondbuy_score'];//奖励

                $firstScore = ($oneScore/$onePay) * $oneDetail;       //一销获取积分
                $secondScore = ($secondPay/$secondScore) * $twoDetail;//二销获取积分
                $addScore = $firstScore + $secondScore;

                //新等级
                $newLevel = getLevelByOnce($level_id,$oneDetail);

                $updateData['total_score']  = ['exp',"total_score + $addScore"];
                $updateData['growth_value'] = ['exp',"growth_value + $addScore"];
                $addMoney = $oneDetail + $twoDetail;
                $updateData['total_consumption'] = ['exp',"total_consumption + $addMoney"];

                //修改会员积分和等级
                if($userData){

                    if($newLevel != $level_id)   $updateData['level'] = $newLevel;

                    db('m_users')->where('id',$user_id)->update($updateData);

                }else{
                    //手机号导入表内是否存在此手机号信息
                    $is_phone=db('m_users_phone')->where(['phone'=>$tel,'brandid'=>$user_brand_id])->find();
                    //return ['sql'=>db()->getLastSql(),'data'=>$is_phone];
                    if($is_phone){
                        //存在 修改积分 等级
                        if($newLevel != $is_phone['level_id'])  $updateData['level_id'] = $newLevel;

                        db('m_users_phone')->where(['phone'=>$tel,'brandid'=>$user_brand_id])->update($updateData);

                        $user_phone_id = $is_phone['id'];

                    }else{
                        //没有会员信息 暂存在手机号导入表
                        $addData = [
                            'phone'       => $tel,
                            'brandid'     => $user_brand_id,
                            'level_id'    => $newLevel,
                            'total_score' => $addScore,
                            'growth_value'=> $addScore,
                            'total_consumption' => $addMoney,
                            'create_time' => date('Y-m-d H:i:s')
                        ];

                        $user_phone_id = db('m_users_phone')->insertGetId($addData);
                    }

                }

                //积分记录
                addScoreLog ('线下订单积分',$addScore,$user_id,14,$user_phone_id,1,$orderCode);
            }

            db()->commit();

            return ['rule'=>$scoreRule,'level'=>$level_id,'oneDetail'=>$oneDetail,'twoDetail'=>$twoDetail,'firstScore'=>$firstScore,'secondScore'=>$secondScore,'addScore'=>$addScore];

            //return array('msg'=>'success');

        }catch (Exception $e){
            db()->rollback();

            return array('error'=>1,'code'=>204,'msg'=>'vip标记订单完成相关操作失败！'.$e->getMessage());
        }


    }


    /*
    * 解除订单绑定
    * order_number 订单号
    * phone        手机号，若有女士手机号 以女士为主
    * brand_id
    */
    public function removeBindOrder($params){
        $order_number = $params['order_number'];
        $phone = $params['phone'];
        $brand_id = $params['brand_id'];

        if(empty($order_number)){
            return array('error'=>1,'code'=>201,'msg'=>'缺少订单号');
        }

        /*
        if(empty($params['wphone'])){
            return array('error'=>1,'code'=>202,'msg'=>'缺少手机号wphone');
        }

        if(empty($params['mphone'])){
            return array('error'=>1,'code'=>203,'msg'=>'缺少手机号mphone');
        }
        */
        /*
        $orderData = db('m_order')
            ->alias('order')
            ->join('m_users user','order.user_id = user.id','left')
            ->where('order.order_number',$order_number)
            ->field('order.*,user.level,user.total_score')
            ->find();
        */
        $orderData = db('m_order')->where('order_number',$order_number)->find();
        $money = $orderData['one_detail'] + $orderData['two_detail'];


        //读取配置集团事业部
        $conf_brandid = db_config('sx_brand');
        if($conf_brandid == $brand_id){
            $user_brand_id = 0;
        }else{
            $user_brand_id = $brand_id;
        }

        //$userData = db("m_users")->where("phone",$phone)->where("brandid",$user_brand_id)->find();
        $userData = db('m_users')->where(['phone'=>$phone,'brandid'=>$user_brand_id])->find();

        if(!$userData){
            $userData = db('m_users_phone')->where(['phone'=>$phone,'brandid'=>$user_brand_id])->find();

            $user_phone_id = $userData['id'];

            $where['users_phone_id'] = $user_phone_id; //查积分记录

            $table = 'm_users_phone'; //更改积分的表

        }else{
            $user_id = $userData['id'];

            $where['m_executor'] = $user_id;//查积分记录

            $table = 'm_users';//更改积分的表
        }

        db()->startTrans();
        try{
            db('m_order')
                ->where('order_number',$order_number)
                //->where('phone',$params['phone'])
                ->update(['delete_time'=>date('Y-m-d H:i:s')]);

            $score = db('minute_log')->where('create_id',$order_number)->where($where)->sum('m_num');

            //总积分
            if($userData['total_score'] >= $score){
                $delScore = -$score;
            }else{
                $delScore = -$userData['total_score'];
            }

            //总消费金额
            if($userData['total_consumption'] >= $money){
                $delMoney = -$money;
            }else{
                $delMoney = -$userData['total_consumption'];
            }

            $updateData['total_score']  = ['exp',"total_score + $delScore"];
            $updateData['growth_value'] = ['exp',"growth_value + $delScore"];
            $updateData['total_consumption'] = ['exp',"total_consumption + $delMoney"];
            db($table)->where('id',$userData['id'])->update($updateData);

            addScoreLog ('取消订单',$delScore,$user_id,18,$user_phone_id,1,$order_number);

            db()->commit();
            return array('msg'=>'success');

        }catch (Exception $e){

            db()->rollback();
            return array('error'=>1,'code'=>203,'msg'=>'删除订单失败');
        }

    }


    /*
     * 更换订单手机号
     */
    public function orderPhoneChange($params){
        $order_number = $params['order_number'];
        $phone = $params['phone'];

        if(!$order_number){
            return ['error'=>1,'code'=>201,'msg'=>'单号不能为空'];
        }

        if(!$phone){
            return ['error'=>1,'code'=>202,'msg'=>'手机号不能为空'];
        }

        $orderInfo = db('m_order')->where('order_number',$order_number)->find();

        if(!$orderInfo){
            return ['error'=>1,'code'=>203,'msg'=>'不存在此订单'];
        }

        $upData['phone'] = $phone;
        $users = db('m_users')->where('phone',$phone)->find();
        if($users){
            $upData['user_id'] = $users['id'];
        }

        $res = db('m_order')->where('order_number',$order_number)->update($upData);
        if($res !== false){
            return ['msg'=>'success'];
        }else{
            return ['error'=>1,'code'=>203,'msg'=>'更换订单手机号失败'];
        }

    }





    /**
     * 方法描述: ERP反回用户等级
     * @return mixed
     * @$pamers 数据参数
     * @$appId 验证唯一id
     * @author yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function popUserGrade ($pamers,$appId) {
        $tel = input('post.tel');
        $brandId = input('post.brand_id');
        $parameter = ['phone'   => trim($tel),'brandid' => (int)$brandId,];
        if (!is_numeric($brandId)) {
            return array('code'=>212,'msg'=>'请输入正确的事业部id且只能为数字','error'=>1);
        }
        if (empty($brandId)) {
            return array('code'=>208,'msg'=>'请确保事业部id不为空','error'=>1);
        }
        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel); //验证手机号
        if (!$checkTel) {
            return array('code'=>207,'msg'=>'请输入正确手机号','error'=>1);
        }
        $arr = ['phone'=>$tel,'brandid'=>(int)$brandId,'fields'=>'name,discount'];
//        $getArr = ['phone'=>$tel,'brandid'=>(int)$brandId,'fields'=>'user_number'];
        $returnData = getLevel($arr);  //调用公共等级方法反回名称和折扣
        $userInfo = getUserInfo($parameter);
//        return array(db()->getLastSql());
        $res = db('m_users_phone')->where('phone',$tel)->where('brandid',$brandId)->find();
        $userData = [
            'level_name' => $returnData['name'],
            'user_number' =>  $res['user_number'],
            'user_openid' =>  $userInfo['openid'],
            'level_discount' => $returnData['discount'],
        ];
        if ($returnData ===false) {
            return  $returnData = array('code'=>203,'msg'=>'该用户不是会员','error'=>1);
        } else{
            return array($userData);
        }
    }
    /**
     * 方法描述: 全局错误信息反回
     * @return mixed
     * @author yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private static function errorMsg ($code,$msg) {
        $errorData = array('code'=>$code,'msg'=>$msg,'error'=>1);
        return $errorData;
    }
    /**
     * 方法描述: 验证是否是日期
     * @return mixed
     * @$pamers 数据参数
     * @$appId 验证唯一id
     * @author yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private static  function isDateTime($str ,$format = "Y-m-d"){
        $time = strtotime($str);  //转换为时间戳
        $checkstr = date($format, $time); //在转换为时间格式
        if(strpos($str,$checkstr) === 0){
            return 1;
        }else{
            return 2;
        }
    }
    /**
     * 方法描述: 订单默认成为会员
     * @return mixed
     * @$pamers 数据参数
     * @$appId 验证唯一id
     * @author yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function defaultVip2 ($pamers,$appId) {//之前的erp接口
        $tel = trim(input('post.tel'));
        $brandId = input('post.brand_id');  //品牌id
        $orderTime = input('post.order_time');
        $orderCode = input('post.order_code');   //传入的订单编号id
        $oneMoney = input('post.one_money');  //一销金额
        $twoMoney = input('post.two_money');  //二销金额
        $oneDetail = input('post.one_detail');  //一销明细
        $twoDetail = input('post.two_detail');  //二销明细

        $sb_code = input('post.sb_code');  //转档唯一码
        $parameter = ['phone'   => trim($tel),'brandid' => (int)$brandId,];
        $checkTime = self::isDateTime($orderTime);
        if (!is_numeric($brandId)) {
            return array('code'=>212,'msg'=>'请确保输入的事业部id正确且只能为数字','error'=>1);
        }
        if ($checkTime == 2) {
            return array('code'=>211,'msg'=>'请确保日期格式正确','error'=>1);
        }
        if ($checkTime == false) {
            return array('code'=>210,'msg'=>'请输入正确的时间(请确保格式正确.例如2017-01-02)','error'=>1);
        }
        if (empty($brandId) && empty($orderCode)) {
            return array('code'=>208,'msg'=>'请确保事业部id不为空','error'=>1);
        }
        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel); //验证手机号
        if (!$checkTel) {
            return array('code'=>207,'msg'=>'请输入正确手机号','error'=>1);
        }
        if (!is_numeric($oneMoney) && !is_numeric($twoMoney) && !is_numeric($oneDetail) && !is_numeric($twoDetail)) {
            return array('code'=>209,'msg'=>'请输入有效的金额且必须为数字','error'=>1);
        }
        $arr = ['phone'=>$tel,'brandid'=>(int)$brandId];
        $oneData = getUserInfo($arr);   //调用验证获取是否是会员信息
//        $res = db('m_users_phone')->where('phone',$tel)->find();
//        if ($res) {
//            return array('code'=>205,'msg'=>'该用户已有数据,请勿重复添加');
//        }
        if (!$oneData) {
            //没有数据
            $data = [
                'phone'=>$tel,
                'brandid'=>$brandId,
            ];
            $userOneData = db("m_users_phone")->where("phone",$tel)->where("brandid",$brandId)->find();
            $user_phone_id=$userOneData['id'];
            if (!$userOneData) {
                $res = db('m_users_phone')->insert($data);  //将当前用户信息入库后反回自增id
                $user_phone_id = db()->getLastInsID();
                $number = self::memCardNum('',$tel,$brandId);
                $oneDa = db('m_users_phone')->where('id',$user_phone_id)->update(['user_number'=>$number]);
            }

            if ($userOneData) {
                $rule = getScoreRule($arr);  //获取积分规则数组
                $moneyRuleOne = $rule['fristbuy'];  //一销积分规则金额
                $moneyScoreOne = $rule['fristbuy_score'];  //一销积分
                $moneyRuleTwo = $rule['secondbuy'];  //二销积分规则金额
                $moneyScoreTwo = $rule['secondbuy_score']; //二销积分
                //新增订单数据
                $orderData = [
                    'order_time'=>$orderTime,
                    'order_number'=>$orderCode,
                    'one_money'=>$oneMoney,
                    'two_money'=>$twoMoney,
                    'one_detail'=>$oneDetail,
                    'two_detail'=>$twoDetail,
                    'order_userid'=>$user_phone_id
                ];
                $orderCheckOne = db("m_order")->insert($orderData);  //将数据插入订单表
                if ($orderCheckOne) {
                    //处理积分
                    $newScoreOne = ($moneyScoreOne/$moneyRuleOne)*$oneMoney;
                    $newScoreTwo = ($moneyScoreTwo/$moneyRuleTwo)*$twoMoney;
                    $newThisScore = $newScoreOne + $newScoreTwo;
                   // $res = db('m_users_phone')->where('id',$userOneData['id'])->update(['total_score'=>$newThisScore]);  //给当前会员表中增加积分
                    $res = db('m_users_phone')->where('id',$userOneData['id'])->update(['total_score'=>['exp',"total_score + $newThisScore"]]);
//                    if (!$res) {
//                        return array('code'=>205,'msg'=>'会员积分错误','error'=>1);
//                    }
                }
            }
        } else {
            $rule = getScoreRule($arr);  //获取积分规则数组
//            $oneMoney = (int)input('post.one_money');
//            $twoMoney = (int)input('post.two_money');
            $moneyRuleOne = $rule['fristbuy '];  //一销积分规则金额
            $moneyScoreOne = $rule['fristbuy_score'];  //一销积分
            $moneyRuleTwo = $rule['secondbuy'];  //二销积分规则金额
            $moneyScoreTwo = $rule['secondbuy_score']; //二销积分
            //有数据
            $orderData = [
                'order_time'=>$orderTime,
                'order_number'=>$orderCode,
                'one_money'=>$oneMoney,
                'two_money'=>$twoMoney,
                'one_detail'=>$oneDetail,
                'two_detail'=>$twoDetail,
            ];
            $orderNumber = input('post.order_code');
            $orderCheck = db('m_order')->where('order_userid',$oneData['id'])->where('order_number',$orderNumber)->where('delete_time is null')->find();   //看当前用户在订单表中是否有数据
            $newScoreBadOne =  $oneMoney - $orderCheck['one_money'];
            $newScoreBadTwo =  $twoMoney - $orderCheck['two_money'];
            if ($orderCheck) {
                $orderRes = db('m_order')->where("order_userid",$oneData['id'])->where('order_number',$orderNumber)->update($orderData);  //有数据进行更改
                if ($orderRes) {
                    //处理积分一销金额与二销金额处理完成
                    $newScoreOne = ($moneyScoreOne/$moneyRuleOne)*$newScoreBadOne; //计算第一次积分
                    $newScoreTwo = ($moneyScoreTwo/$moneyRuleTwo)*$newScoreBadTwo; //计算第二次积分
                    $newThisScore = $newScoreOne + $newScoreTwo; //计算总积分
                    //$res = db('m_users_phone')->where('id',$oneData['id'])->update(['total_score'=>$newThisScore]);
                    $res = db('m_users_phone')->where('id',$oneData['id'])->update(['total_score'=>['exp',"total_score + $newThisScore"]]);
                }
            } else {
                if ($oneData['pid'] == '') {
                    $orderId = $oneData['id'];
                } else {
                    $orderId = $oneData['pid'];
                }
                $orderData = [
                    'order_time'=>$orderTime,
                    'order_number'=>$orderCode,
                    'one_money'=>$oneMoney,
                    'two_money'=>$twoMoney,
                    'one_detail'=>$oneDetail,
                    'two_detail'=>$twoDetail,
                    'order_userid'=>$orderId
                ];
                $orderCheckOne = db("m_order")->insert($orderData);  //将数据插入订单表
                if ($orderCheckOne) {
                    //处理积分
                    $newScoreOne = ($moneyScoreOne/$moneyRuleOne)*$oneMoney;  //计算第一次积分
                    $newScoreTwo = ($moneyScoreTwo/$moneyRuleTwo)*$twoMoney;  //计算第二次积分
                    $newThisScore = $newScoreOne + $newScoreTwo;  //计算总积分
                    //$res = db('m_users_phone')->where('id',$oneData['id'])->update(['total_score'=>$newThisScore]);  //给当前会员表中增加积分
                    $res = db('m_users_phone')->where('id',$oneData['id'])->update(['total_score'=>['exp',"total_score + $newThisScore"]]);
                }
            }
        }
        $returnData = getLevel($arr);  //调用公共等级方法反回名称和折扣
        $userInfo = getUserInfo($parameter);
        $res = db('m_users_phone')->where('phone',$tel)->where('brandid',$brandId)->find();
        $userData = [
            'level_name' => $returnData['name'],
            'level_discount' => $returnData['discount'],
            'user_number' =>  $res['user_number'],
            'user_openid' =>  $userInfo['openid'],
        ];
        return array($userData);
        //--
    } 

    public function defaultVipOld ($params,$appId) {
        $tel = trim($params['tel']);
        $brandId = $params['brand_id'];           //品牌id
        $orderTime = $params['order_time'];
        $orderCode = $params['order_code'];       //传入的订单编号id
        $oneMoney = $params['one_money'];    //一销金额
        $twoMoney = $params['two_money'];    //二销金额
        $oneDetail = $params['one_detail'];  //一销明细
        $twoDetail = $params['two_detail'];  //二销明细
        $totalMoney = $params['total_money'];//订单总金额
        $package_name = $params['package_name'];//套系名称
        $vip_order_sn = $params['vip_order_sn'];

        $checkTime = self::isDateTime($orderTime);
        if (!is_numeric($brandId)) {
            return array('code'=>212,'msg'=>'请确保输入的事业部id正确且只能为数字','error'=>1);
        }
        if ($checkTime == 2) {
            return array('code'=>211,'msg'=>'请确保日期格式正确','error'=>1);
        }
        if ($checkTime == false) {
            return array('code'=>210,'msg'=>'请输入正确的时间(请确保格式正确.例如2017-01-02)','error'=>1);
        }
        if (empty($brandId) && empty($orderCode)) {
            return array('code'=>208,'msg'=>'请确保事业部id不为空','error'=>1);
        }
        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel); //验证手机号
        if (!$checkTel) {
            return array('code'=>207,'msg'=>'请输入正确手机号','error'=>1);
        }
        //if (!is_numeric($oneMoney) && !is_numeric($twoMoney) && !is_numeric($oneDetail) && !is_numeric($twoDetail)) {
        if (!is_numeric($oneMoney) && !is_numeric($twoMoney)) {
            return array('code'=>209,'msg'=>'请输入有效的金额且必须为数字','error'=>1);
        }

        $arr = ['phone'=>$tel,'brandid'=>(int)$brandId];

        $userPhoneData = db("m_users_phone")->where("phone",$tel)->where("brandid",$brandId)->find();
        $user_phone_id=$userPhoneData['id'];
        $user_number=$userPhoneData['user_number'];
        if (!$userPhoneData) {
            $user_phone_id=db('m_users_phone')->insertGetId($arr);
            $user_number = self::memCardNum('',$tel,$brandId);
            db('m_users_phone')->where('id',$user_phone_id)->update(['user_number'=>$user_number]);
        }

        $rule = getScoreRule($arr);  //获取积分规则数组
        $moneyRuleOne = $rule['fristbuy'];  //一销积分规则金额
        $moneyScoreOne = $rule['fristbuy_score'];  //一销积分
        $moneyRuleTwo = $rule['secondbuy'];  //二销积分规则金额
        $moneyScoreTwo = $rule['secondbuy_score']; //二销积分
        //新增订单数据
        $orderData = [
            'order_time'   => $orderTime,
            'order_number' => $orderCode,
            'one_money'    => $oneMoney,
            'two_money'    => $twoMoney,
            'one_detail'   => $oneDetail,
            'two_detail'   => $twoDetail,
            'phone'        => $tel,
            'brandid'      =>$brandId,
            'total_money'  => $totalMoney,
            'package_name' => $package_name,

        ];

        //可审核订单 实收款>=总套系金额 且>0
//        if(($oneDetail+$twoDetail)>=($oneMoney+$twoMoney)&&($oneMoney+$twoMoney)>0&&($oneDetail+$twoDetail)>0){
//            $orderData ['can_check'] = 1;
//        }else{
//            $orderData ['can_check'] = 2;
//        }

        $orderCheck = db('m_order')->where('order_userid',$user_phone_id)->where('order_number',$orderCode)->where('delete_time is null')->find();   //看当前用户在订单表中是否有此订单
        if ($orderCheck) {


            //可审核订单 实收款>=总套系金额 且>0
            if(($oneDetail+$orderCheck['one_detail']+$twoDetail+$orderCheck['one_detail'])>=($oneMoney+$twoMoney)){
                $orderData ['can_check'] = 1;
            }else{
                $orderData ['can_check'] = 2;
            }

            $newScoreBadOne =  $oneMoney - $orderCheck['one_money'];
            $newScoreBadTwo =  $twoMoney - $orderCheck['two_money'];

            $orderData['one_detail'] = ['exp',"one_detail + $oneDetail"];
            $orderData['two_detail'] = ['exp',"two_detail + $twoDetail"];

            $orderRes = db('m_order')->where("order_userid",$user_phone_id)->where('order_number',$orderCode)->where('delete_time is null')->update($orderData);  //有数据进行更改
            if ($orderRes) {
                //处理积分一销金额与二销金额处理完成
                $newScoreOne = ($moneyScoreOne/$moneyRuleOne)*$newScoreBadOne; //计算第一次积分
                $newScoreTwo = ($moneyScoreTwo/$moneyRuleTwo)*$newScoreBadTwo; //计算第二次积分
                $newThisScore = $newScoreOne + $newScoreTwo; //计算总积分
                AddScore($userPhoneData['userid'],$user_phone_id,$newThisScore,'14','线下订单积分');
                /*$res = db('m_users_phone')->where('id',$user_phone_id)->update(['total_score'=>['exp',"total_score + $newThisScore"]]);
                if($res!==false){
                    minuteDetailed ('线下订单积分',$newThisScore,'',14,$user_phone_id);
                }*/
            }
        } else {

            //可审核订单 实收款>=总套系金额 且>0
            if(($oneDetail+$twoDetail)>=($oneMoney+$twoMoney)&&($oneMoney+$twoMoney)>0&&($oneDetail+$twoDetail)>0){
                $orderData ['can_check'] = 1;
            }else{
                $orderData ['can_check'] = 2;
            }


            //检测推荐人表里是否有人推荐此用户，推荐通过，未领取过奖励，推荐手机号为成单手机号
            $recommend = db('recommend')->where(['status'=>2,'r_phone'=>$tel,'is_get'=>2])->find();
            if(!empty($recommend)){
                $orderData['recommend_id'] = $recommend['id'];
            }

            //检测vip订单表里是否存在此订单，是否使用优惠券
            if($vip_order_sn){
                $vipOrder = db('s_order_info')->where('payment_order_sn',$vip_order_sn)->find();
            }

            //user_phone表id
            $orderData['order_userid'] = $user_phone_id;
            $orderData['create_time']  = date('Y-m-d H:i:s');
            $orderData['order_type']   = $vipOrder ? 1 : 2;
            $orderData['coupon_id']    = $vipOrder['coupon_id'];

            $orderAdd= db("m_order")->insert($orderData);  //将数据插入订单表
            if ($orderAdd) {
                //处理积分
                $newScoreOne = ($moneyScoreOne/$moneyRuleOne)*$oneMoney;  //计算第一次积分
                $newScoreTwo = ($moneyScoreTwo/$moneyRuleTwo)*$twoMoney;  //计算第二次积分
                $newThisScore = $newScoreOne + $newScoreTwo;  //计算总积分
                AddScore($userPhoneData['userid'],$user_phone_id,$newThisScore,'14','线下订单积分');
                /*$res = db('m_users_phone')->where('id',$user_phone_id)->update(['total_score'=>['exp',"total_score + $newThisScore"]]);
                if($res!==false){
                    minuteDetailed ('线下订单积分',$newThisScore,'',14,$user_phone_id);
                }*/
            }

        }
        $returnData = getLevel($arr);  //调用公共等级方法反回名称和折扣
        $userInfo = getUserInfo($arr);
        $userData = [
            'level_name' => $returnData['name'],
            'level_discount' => $returnData['discount'],
            'user_number' =>  $user_number,
            'user_openid' =>  $userInfo['openid'],
        ];

        return array($userData);

    }



    /**
     * 用户默认生成会员卡号码
     * @param  String  $card_lenght 卡片长度默认13位
     * @return json   返回影响行数，成功或者失败$memid
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    private static function memCardNum ($memid,$tel,$brandid) {
        if (empty($memid)) {
            $res = db('m_users_phone')->where('phone',$tel)->where('brandid',$brandid)->find();
        } else {
            $res = db('m_users')->where('id',$memid)->field('brandid,id')->find();  //获取当前登录人的事业部id
            $userPhone = db('m_users_phone')->where('userid',$res['id'])->find();
        }
        $userData = db('card_rule')->where('brandid',$res['brandid'])->find();  //根据事业部id查询出当前所属卡编号的生成规则
        $mem_number =''; //默认定义卡号为空
        if ($userData['this_phone'] == 1 && !empty($userPhone)) {    //卡号默认使用手机号生成
            $mem_number = $userPhone['phone'];
        }

        if (!empty($userData['card_prefix']) && !empty($userData['card_next'])) {   //带前缀与后缀会员编号
            $num = rand_chars(str_replace(',','',$userData['card_number']),$userData['card_lenght'],true);
            $mem_number = $userData['card_prefix'].$num.$userData['card_next'];
        }
        return $mem_number;
    }
    /**
     * 方法描述: 线下储值
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function popMoney () {
        $phone = input('post.phone');  //获取用户手机号
        $money = (int)input('post.money');  //需要充值的金额
        $brandId = input('post.brand_id');  //事业部id
        $shopName = input('post.shop_name');  //充值店面
        $staffName = input('post.staff_name');  //操作员工
//        $userNumber = input('post.user_number');  //需要充值人的卡号
        $parameter = ['phone'   => trim($phone),'brandid' => (int)$brandId,];
        if (!isset($phone{11})) { return array('code'=>203,'msg'=>'电话长度不足'); }
        if (empty($userNumber) && empty($money)) {
            return array('code'=>201,'mag'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>205,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        db()->startTrans();
        $userPhoneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();  //先查询电话表
        if (!$userPhoneData) {
            db()->rollback();
            //没有数据
           $userWxData = db('m_users')->where('user_number',$userNumber)->find();  //查询微信表
            if (!$userWxData) {
                return array('code'=>202,'msg'=>'该用户不是会员','error'=>1);
            }
            $lastMoney = $userWxData['money'];
            $thisMoney = bcadd($lastMoney,$money);
            $userUpMoney = db('m_users')->where('user_number',$userNumber)->update(['money'=>$thisMoney]);
            if ($userUpMoney) {
                $logData = ['u_money'=>$money,'u_time'=>date('Y-m-d H:i:s'),'shop_name'=>$shopName,'staff_name'=>$staffName,'brand_id'=>$brandId];  //记录充值记录
                $moneyLog = db('m_money_log')->insert($logData); //将数据进入
                if (!$moneyLog) {
                    db()->rollback();
                }
            }
        } else {
            //电话表中有数据
            $lastMoney = $userPhoneData['money'];  //取出原有表数据
            $thisMoney = bcadd($lastMoney,$money);  //计算充值后总金额
            $userUpMoney = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->update(['money'=>$thisMoney]);  //修改充值后用户表中的数据
            if (!$userUpMoney){
                db()->rollback();
            }
            if ($userUpMoney) {
                $logData = ['u_money'=>$money,'u_time'=>date('Y-m-d H:i:s'),'shop_name'=>$shopName,'staff_name'=>$staffName,'phone_id'=>$userPhoneData['id'],'brand_id'=>$brandId];  //记录充值记录
                $moneyLog = db('m_money_log')->insert($logData); //将数据进入
                if (!$moneyLog) {
                    db()->rollback();
                }
            }
        }
        db()->commit();
        $userInfo = getUserInfo($parameter);
        $returnData = [
            'user_money'  => $thisMoney,  //返回金额
            'user_openid' => $userInfo['openid'],  //用户的openid
            'user_number' => $userPhoneData['user_number'],  //用户的会员编号
        ];
        return array($returnData);
    }
    /**
     * 方法描述: 线下储值记录
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function popMoneyRecord () {
        $staffName = input('post.staff_name');
        $brandId = input('post.brand_id');
        $shopName = input('post.shop_name');
//        $staffName = '李清';   //查询数据显示
//        $brandId = 6;
        if (empty($staffName) && empty($brandId)) {
            return array('code'=>201,'msg'=>'参数不可为空','error'=>1);
        }

        //待处理店铺的正确性
        //两表联查并查询出当前店面的信息
        $recordData = db('m_money_log')
            ->alias('a')
            ->join('m_users_phone b','a.phone_id = b.id')
            ->where('staff_name',$staffName)->where('brand_id',$brandId)->where('shop_name',$shopName)
            ->field('a.u_money,a.u_time,a.shop_name,a.staff_name,b.phone')
            ->select();  //反回字段  充值金额 充值时间 充值门店  查询员工名 充值人手机号
        if (!$recordData) {
             return array('code'=>202,'msg'=>'该会员没有该门店的充值信息','error'=>1);
        }
        return $recordData;
    }

    /**
     * 方法描述: 付款码扫描支付
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function codePay () {
//        $phone = input('post.phone');  //获取用户手机号
        $orderCode = input('post.order_code');  //消费单号
        $shopName = input('post.shop_name');  //充值店面
        $brandId = (int)input('post.brand_id');  //事业部id
        $staffName = input('post.staff_name');  //操作员工
        $money = input('post.pay_money');  //支付金额
        $payCode = input('post.code');  //支付码
        $userId = (int)input('post.user_id');  //当前扣款用户
        if (empty($orderCode) && empty($shopName) && empty($brandId) && empty($staffName) && empty($money) && empty($payCode) && empty($userId)) {
            return array('code'=>206,'msg'=>'参数不可为空');
        }

        if (!is_numeric($brandId)) {
            return array('code'=>208,'msg'=>'请输入正确的事业部id','error'=>1);
        }

        if (!is_numeric($userId)) {
            return array('code'=>209,'msg'=>'请输入正确的用户id','error'=>1);
        }
        $cacheCode = Cache::get('user_pay_code_'.$userId);  //从cache中取出支付码
        db()->startTrans();
        if ($payCode != $cacheCode['code']) {
            return array('code'=>203,'msg'=>'该付款码已过期','error'=>1);
        }
        if (!$cacheCode) {
            return array('code'=>203,'msg'=>'请输入正确的付款码','error'=>1);
        }
        if ($cacheCode['status'] == 'success') {
            return array('code'=>205,'msg'=>'该支付码已成功,请勿重复扣款','error'=>1);
        }
        $userPhone = db('m_users_phone')->where('id',$userId)->where('brandid',$brandId)->field('money')->find();  //查询当前用户余额
        $parameter = ['phone'   => trim($userPhone['phone']),'brandid' => (int)$brandId,];
        $thisMoney = bcsub($userPhone['money'],$money);  //扣款余额
        if ($thisMoney <= 0) {
            return array('code'=>202,'msg'=>'卡内余额不足','error'=>1);
        }
        $nextMoney = db('m_users_phone')->where('id',$userId)->update(['money'=>$thisMoney]);  //修改扣款金额
        if (!$nextMoney) {
            db()->rollback();
        }
        if ($nextMoney) {
            $data = ['user_id'=>$userId,'code'=>$payCode,'status'=>'success','deduct_money'=>$money];
            Cache::set('user_pay_code_'.$userId,$data);  //将扣款数据从新写入缓存并改变付款状态

            $logData = [
                'm_id'=>$userId,
                'm_money'=>$money,
                'm_code'=>$payCode,
                'shop_name' => $shopName,
                'staff_name' => $staffName,
                'order_code' => $orderCode,
                'm_time'=>date('Y-m-d H:i:s'),
            ];
            $pushRes = db('m_mp_log')->insert($logData);  //消费记录表
            if (!$pushRes) {
                db()->rollback();
            }
            db()->commit();
            $userInfo = getUserInfo($parameter);
            $returnData = ['pay_money'=>$money,'user_openid'=>$userInfo['openid']];
            return array($returnData);
        }
    }
    /**
     * 方法描述: 会员在门店付款码支付记录查询
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function codePayRecord () {
        $shopName = input('post.shop_name');  //查询门店
        $phone = input('post.phone');  //用户手机号
        $brandId = (int)input('post.brand_id'); //事业部id
        if (empty($phone) && empty($brandId) && empty($shopName)) {
            return array('code'=>201,'msg'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>205,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        $userOneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();
        if (!$userOneData) {
            return array('code'=>202,'msg'=>'没有查询到当前用户信息','error'=>1);
        }
        $recordData = db('m_mp_log')->where('m_id',$userOneData['id'])->field('m_money,m_time,shop_name,staff_name,order_code')->select();
        if (!$recordData) {
            return array('code'=>203,'msg'=>'没有该会员消费信息','error'=>1);
        }
        return array($recordData);
    }


    /**
     * 方法描述: 获取当前登录人拥有卡的列表
     * @return mixed
     * @$pamers 当前会员充值人
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function userCardList () {
        $phone = input('post.tel');  //当前用户电话
        $brandId = (int)input('post.brand_id');  //事业部id
        if (empty($phone) && empty($brandId)) {
            return array('code'=>202,'msg'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>205,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        $userPhoneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();
        if (!$userPhoneData) {
            return array('code'=>203,'msg'=>'该条会员数据没有查询到');
        }
        $userCardData = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->select();  //反回当前人名下有多少卡
        return array($userCardData);
    }
    /**
     * 方法描述: 获取当前登录人余额
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function cardOneBalance () {
        $phone = input('post.tel');  //当前需要查询的用户电话
        $userCode = input('post.user_code');  //会员卡号
        $brandId = (int)input('post.brand_id');  //事业部id
        $parameter = ['phone' => trim($phone),'brandid' => (int)$brandId,];
        if (empty($phone) && empty($brandId) && empty($userCode)) {
            return array('code'=>202,'msg'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>205,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        $userPhoneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();
        $userCardData = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->where('card_no',$userCode)->find();  //查询当前人名下需要查询余额的卡
        $userInfo = getUserInfo($parameter);
        $data = ['user_code'=>$userCode,'code_balance'=>$userCardData['balance'],'user_openid'=>$userInfo['openid']];    //反回会员卡卡号，余额信息
        return array($data);
    }
    /**
     * 方法描述: 根据卡帐号密码扣款
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function cardDebit () {
        $phone = input('post.tel');  //当前需要查询的用户电话
        $money = input('post.money');  //扣款金额
        $shopName = input('post.shop_name'); //消费门店
        $userCode = input('post.user_code');  //会员卡号
        $staffName = input('post.staff_name'); //操作员工的姓名
        $orderCode = input('post.order_code');  //订单单号
        $brandId = (int)input('post.brand_id');  //事业部id
        $orderTitle = input('post.order_title');  //当前单号的标题
        $staffNumber = input('post.staff_number'); //操作员工编号
        $userCodePass = input('post.code_password');  //卡密码
        $parameter = ['phone' => trim($phone),'brandid' => (int)$brandId,];
        db()->startTrans();
        if (empty($phone) && empty($brandId) && empty($userCode) && empty($money)) {
            return array('code'=>202,'msg'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>205,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        $userPhoneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();  //根据电话查询主键id
        $userCardData = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->where('card_no',$userCode)->find();  //查询当前人名下需要扣款的卡
        if (!$userCardData) {
            db()->rollback();
            return array('code'=>203,'msg'=>'没有查询到该会员卡信息','error'=>1);
        }

        $lastMoney = $userCardData['balance'];  //当前卡片余额
        $thisMoney = bcsub($lastMoney,$money);  //扣除后卡余额
        $userOneUp = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->where('card_no',$userCode)->where('card_password',$userCodePass)->update(['balance'=>$thisMoney]);
        if (!$userOneUp) {
            db()->rollback();
        }
        if ($userOneUp) {
            $logData = [
                'brand_id' => $brandId,
                'shop_name' => $shopName,
                'consume_money' => $money,
                'consume_title' => $orderTitle,
                'create_staff_name' => $staffName,
                'consume_order_code' => $orderCode,
                'create_staff_number' => $staffNumber,
                'card_list_id' => $userCardData['id'],
                'user_phone_id' => $userPhoneData['id'],
                'consume_time'  => date('Y-m-d H;i:s'),
            ];
            $logRes = db('c_card_log')->insert($logData);  //将扣款成功的数据写入会员卡消费记录表
            if (!$logRes) {
                db()->rollback();
            }
            db()->commit();
            $userInfo = getUserInfo($parameter);
            $userLevelName = getLevel($parameter);
            $returnData = ['user_code'=>$userCode,'code_balance'=>$thisMoney,'user_openid'=>$userInfo['openid'],'level_name'=>$userLevelName['name']];   //反回当前卡余额，卡号
            return array($returnData);
        }
    }
    /**
     * 方法描述: 当前门店下的卡的消费记录(用户储值卡消费记录)
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function cardDebitRecord () {
        $phone = input('post.phone');   //用户电话
        $shopName = input('post.shop_name');   //店铺名称
        $brandId = (int)input('post.brand_id');  //事业部id
        $userCode = input('post.card_code');  //查询的卡号记录
        if (empty($phone) && empty($brandId) && empty($shopName) && empty($cardCode)) {
            return array('code'=>201,'msg'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>202,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        $userPhoneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();  //根据电话查询主键id
        if (!$userPhoneData) {
            return array('code'=>203,'msg'=>'没有查询到当前会员的数据','error'=>1);
        }
        $userCardData = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->where('card_no',$userCode)->find();  //查询当前人名下需要扣款的卡

        if (!$userCardData) {
            return array('code'=>205,'msg'=>'没有查询到该会员卡信息','error'=>1);
        }
        $recordData = db('c_card_log')->where('card_list_id',$userCardData['id'])->where('shop_name',$shopName)->field('consume_money,consume_time,consume_order_code,shop_name')->select();
        if (!$recordData) {
            return array('code'=>205,'msg'=>'没有查询到该条卡的会员卡信息','error'=>1);
        }
        return array($recordData);   //反回消费卡的支付扣款明细
    }

    /**
     * 方法描述: 延长卡的有效期
     * @return mixed
     * @$pamers 当前会员充值人/
     * @$appId 验证唯一id
     * @author yanlipeng<yanlipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function extendTime () {

        $phone = input('post.tel');  //当前需要查询的用户电话
        $days = (int)input('post.day');  //传过来加多少天
        $userCode = input('post.user_code');  //会员卡号
        $brandId = (int)input('post.brand_id');  //事业部id
        $parameter = ['phone' => trim($phone),'brandid' => (int)$brandId,];
        if (empty($phone) && empty($brandId) && empty($userCode) && empty($days)) {
            return array('code'=>202,'msg'=>'参数不可为空','error'=>1);
        }
        if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
            return array('code'=>205,'msg'=>'请输入正确的手机号码','error'=>1);
        }
        $userPhoneData = db('m_users_phone')->where('phone',$phone)->where('brandid',$brandId)->find();  //根据电话查询出当前用户的主键id
        if (!$userPhoneData) {
            return array('code'=>203,'msg'=>'没有查询到该会员信息','error'=>1);
        }
        $userCardData = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->where('card_no',$userCode)->find();  //查询当前人名下需要延长日期的卡
        if ($userCardData) {
            $expireTime = date('Y-m-d',strtotime($userCardData['expire_time']));   //取出过期的时间
            $thisTime = date('Y-m-d',strtotime("$expireTime + $days day"));  //算出想要延长的有效时间
            $cardOneUpData = db('c_card_list')->where('user_phone_id',$userPhoneData['id'])->where('card_no',$userCode)->update(['expire_time'=>$thisTime]);
            if ($cardOneUpData) {
                $userInfo = getUserInfo($parameter);
                $returnData = ['user_code'=>$userCode,'expire_time'=>$thisTime,'code_balance'=>$userCardData['balance'],'user_openid'=>$userInfo['openid']];  //反回卡号码,过期时间,余额
                return array($returnData);
            }
        }
    }

    /*
     * erp更新推荐人
     * @$pamers  order_number 订单号
     * @$pamers  phone  订单手机号
     * @$pamers  from_phone  推荐人手机号
     * @$pamers  brandid     事业部id
     */
    public function recommendPhone($params){

        $order_numebr = $params['order_number'];
        $phone = $params['phone'];
        $from_phone = $params['from_phone'];
        $branid = $params['brandid'];
        $rusername = $params['r_username'];

        $recommend = db('recommend')
            ->alias('a')
            ->where(['a.brandid'=>$branid,'a.r_phone'=>$phone,'a.status'=>2])
            ->join('m_users_phone b','a.userid = b.userid','left')
            ->field('a.id,a.r_phone,a.r_username,a.status,b.userid,b.id as user_phone_id,b.phone')
            ->find();

        if(!$recommend){
            db()->startTrans();
            try{
                //开单人
                $user = db('m_users_phone')->where('phone',$phone)->find();
                //填写的推荐人
                $fromUser = db('m_users_phone')->where('phone',$from_phone)->find();
                /*
                if(!$fromUser){
                    db()->rollback();
                    return array('error'=>1,'code'=>203,'msg'=>'推荐人不是会员');
                }*/
                $res = db('recommend')->insert([
                    'r_username'=>trim($user['username'])?trim($user['username']):$rusername,
                    'r_phone' => $phone,
                    'user_phone'=>$from_phone,
                    'r_sex'   => $user['sex'],
                    'userid'  => (int)$fromUser['userid'],
                    'create_time' => date('Y-m-d H:i:s'),
                    'brandid' => $branid,
                    'status'  => 2
                ]);
                if($user['userid'] && $fromUser['userid']){
                    db('m_users')->where('id',$user['userid'])->update(['share_userid'=>$fromUser['userid']]);
                }
                db()->commit();
                return array('msg'=>'access');
            }catch (Exception $e){
                db()->rollback();
                return array('error'=>1,'code'=>201,'msg'=>'绑定推荐人失败');
            }

        }

        if($recommend&&$from_phone!==$recommend['phone']){
            return array('error'=>1,'code'=>202,'data'=>$recommend['phone'],'msg'=>'此用户已存在推荐人，推荐手机号为'.$recommend['phone']);
        }

        return array('msg'=>'已绑定成功');

    }
    /*
     * 检测手机号是否绑定微信
     */
    public function checkIsBind($params){

        $phone = $params['phone'];
        if(!$phone){
            return ['error'=>1,'code'=>201,'msg'=>'请传入手机号'];
        }

        $phoneArr = array_filter(explode(',',$phone));

        $users = db('m_users')->where('phone','in',$phoneArr)->select();
        $bindPhone = array_column($users,'phone');

        $returnArr = [];

        foreach($phoneArr as $v){

            if(in_array($v,$bindPhone)){
                $is_bind = 1;
            }else{
                $is_bind = 2;
            }
            $returnArr[] = [
                'phone'  => $v,
                'is_bind'=> $is_bind,
            ];
        }
        return $returnArr;
    }

    /*
     * 根据手机号获取会员信息
     */
    public function getUsersinfo($params){

        $phone = $params['phone'];
        if(!$phone){
            return ['error'=>1,'code'=>201,'msg'=>'请传入手机号'];
        }

        $users = db('m_users')->where('phone',$phone)->find();
        if($users){
            return $users;
        }else{
            return ['error'=>1,'code'=>201,'msg'=>'未获取到该会员信息'];
        }
    }

}