<?php
/**
 * CRM项目模块公共类，所有开发的模块要引用此模块，进行业务公共逻辑处理。
 * 主要处理运行初始化，用户认证，日志，
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-17 $
 */
namespace app\index\controller;
use think\Controller;
use think\Session;
class Base  extends Controller{
    /**
     * API的hash值
     * 
     * @var type String
     */
    protected $apiHash = '';
    protected $apiUrl = '';
    protected $appSecret = '';
    protected $apiParams = array();
    protected $apiStartTime = 0;
    protected $apiEndTime = 0;
    protected $appId = '';
    
    //create leishaoju 用于记录当前用户是否是最大权限，可以查看全部数据，false时根据brandid去查数据
    protected $root      = false;  
    protected $brandId   = false; //create leishaoju 存储登陆的员工的部门id
    protected $staffName = ''; // 当前登陆人的名字
    protected $staffId   = '';  // 当前登录人id
    protected $currentUrl = '';
    function _initialize() {
        $up = new \app\index\lib\Update();
        $up->runUpdate();

        if(defined('IS_API') && IS_API === true){
            $input = input();
            $this->apiHash = $input['action'];
            if(defined('IS_POST') && IS_POST === true){
                //验证接口加密规范 暂时只支持使用hash调用，后期再考虑可以支持url调用。--songdemei
                //if(!isset($input['method']) || empty($input['method'])){
                    //
                    return $this->checkAPI();
                //}else{
                    /*
                    $apiUrl = $input['action'].'/'.$input['method'];
                    $apiList = db('apilist')->find(array('apiUrl'=>$apiUrl));
                    */
                //}
            }
            //ECHO 'base init =-----<<<<<<br/>';
        }else{
            $login = check_login();
            if($login === false){
                if(\think\Request::instance()->isAjax()){
                    //返回未登录错误
                    $this->apiError('用户未登录', ERR_LOGIN_UNLOGIN);
                }else{
                    //跳转到登录
                    $module = \think\Request::instance()->module();
                    $this->redirect(url($module.'/Login/login'));
                }
            }
            //leishaoju  初始化数据
            $this->staffName = Session::get('staffname');
            $this->staffId   = Session::get('staff_id');
            $this->brandId   = Session::get('brandid');
            $this->root      = $this->brandId?false:true;
        }

        // 获取权限使用的菜单列表
        $menuData=getAuth('menu');
        $menuList=treeData($menuData,$fid=0);

        $currentController = strtolower(request()->controller());
        $currentAction = strtolower(request()->action());
        $currentUrl = DS.'vip'.DS.$currentController.DS.$currentAction;
        $this->currentUrl = $currentUrl;

        $workType     = Session::get('work_type');
        $mainWorkType = Session::get('main_work_type');

        $allWorkType = explode(',',trim($mainWorkType.','.$workType,','));

        if($this->brandId){
            if(!in_array(SYSTEM_AUTH_ADMIN,$allWorkType)){
                $ispermission = isPermission($menuList,$currentUrl);
                //var_dump($ispermission); 
                if(!isPermission($menuList,$currentUrl)){
                    if(!$menuList || !$menuList[0]){
                        $this->redirect('vip/index/nopermission');
                    }else{
//                        $this->redirect($menuList[0]['menu_url']);
                    }
                }
            }
        }
//        if($currentController=='coupontype'){
//            $currentController='coupon';
//        }elseif($currentController=='scorerule' || $currentController=='memberq'){
//            $currentController='level';
//        }


        //默认展示模块
        $this_menu = str_replace('\\', '/',$currentUrl);//当前 模块控制器方法名
        $top_menu = getTopMenu($this_menu);  //顶级级模块
        //$default_menu = session('top_menu')?session('top_menu'):$menuList[0]['menu_code'];//默认session里顶级模块
        //$top_menu = $top_menu ? $top_menu : $default_menu;
        $nextList = getNextMenu($top_menu);// 默认展示二级菜单

        $this->assign(['menuList'=>$menuList,'nextList'=>$nextList,'this_menu'=>$this_menu,'top_menu'=>$top_menu,'currentclass'=>$currentController]);

        //网站logo
        $logo = db_config(SX_LOGO);
        $this->assign('index_logo',json_decode($logo,true)['index_logo']);

        //后台检测、创建本月与下月签到表
        //cache('table_all_list',null);
        $theTable = "sign_detail_".date('Ym',time()); //表名
        if(!checkTableExists($theTable)){
            getTable(date('Ym',time()));
        }

        $nextTable = "sign_detail_".date('Ym',strtotime(" +1 month"));
        if(!checkTableExists($nextTable)){
            getTable(date('Ym',strtotime(" +1 month")));
        }

    }
    private function checkAPI() {
        $apiInfo = db('apiList',config('ext.db_api'))
                ->join('api_app', 'api_app.id = api_list.app_id', 'left')
                ->field('api_list.*,api_app.app_name,api_app.app_id,api_app.app_secret,api_app.app_status,api_app.app_type')
                ->where('api_list.hash',  $this->apiHash)
                ->find();
        if(!$apiInfo){
            $this->apiError('接口不存在', -1001); 
        }
        if($apiInfo['status'] != 1){
            $this->apiError('接口被禁用', -1002);
        }
        if($apiInfo['app_status'] != 1){
            $this->apiError('应用已禁用', -1003);
        }
        /*
        if($apiInfo['accessToken'] == 1){
            $accessToken = request()->header('ACCESS-TOKEN');
            if(!$accessToken){
                $this->apiError('当前接口需要token验证。', ERR_ACCESSTOKEN_EMPTY);
            }
            
            if(!checkAccessToken(config('ext.app_secret'),$accessToken)){
                $this->apiError('AccssToken check error。', ERR_ACCESSTOKEN_ERROR);
            }
        }
        */
        if($apiInfo['needLogin'] == 1){
            $sessionId = request()->header('SESSION-ID');
            if(!$sessionId){
                $this->apiError('当前接口需要登录才能使用。', ERR_LOGIN_UNLOGIN);
            }
            if(!api_check_login($sessionId)){
                $this->apiError('用户未登录，或登录信息已过期。', ERR_LOGIN_EXPIRED);
            }
            
        }
        
        $this->apiUrl = $apiInfo['apiUrl'];
        $this->appSecret = $apiInfo['app_secret'];
        $this->apiParams = input('post.');
        $this->appId = $apiInfo['app_id'];
    }
    function actionLog() {
        
        
        
    }
    public function apiReturn ($data) {
        apiLog(array(
            'api_url'=>  $this->apiUrl,
            'hash'=>  $this->apiHash,
            'data'=> json_encode($this->apiParams),
            'api_start_time'=> $this->apiStartTime,//number_format($this->apiStartTime, 4,'.',''),
            'api_end_time'=>  $this->apiEndTime,//number_format($this->apiEndTime,4,'.',''),
            'result_code'=>'200',
        ));
        $ret = array('code'=>200,'msg'=>'','data'=>$data);
        exit(json_encode($ret));
        //return json($data,200);
    }
    public function apiError($msg,$code,$data = []) {
        $ret = array('code'=>$code,'msg'=>$msg,'data'=>$data);
        apiLog(array(
            'api_url'=>  $this->apiUrl,
            'hash'=>  $this->apiHash,
            'data'=> json_encode($this->apiParams),
            'api_start_time'=>  $this->apiStartTime,//number_format($this->apiStartTime,4,'.',''),
            'api_end_time'=>  $this->apiEndTime,//number_format($this->apiEndTime,4,'.',''),
            'result_code'=>$code,
        ));
        send_http_status(500);
        exit(json_encode($ret));
    }

}