<?php

/**
 * 订单相关的API
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya<wangzhenya@suxuantech.cn> 2017-10-28 $
 */

namespace app\index\lib;

use think\image\Exception;

class Order {

    /*
     * erp线下订单的支付
     */
    public function paymentErpOrder($params){

        $serial_number = $params["order_no"];  //支付流水号
        $pay_fee = $params["pay_fee"];  //支付金额
        $pay_status = $params["pay_status"];  //支付状态

        //订单详情
        $orderInfoData = db('erp_pay_serial')
            ->where('a.serial_number',$serial_number)
            ->alias('a')
            ->join('erp_pay b','a.erp_pay_code = b.pay_code','left')
            ->field('a.erp_pay_code,a.serial_number,b.*')
            ->find();

        //确认支付成功
        if($pay_status == "PAYED" && $pay_fee == $orderInfoData['price'] * 100) {//判断支付成功

            db()->startTrans();
            try{

                $nowTime = date('Y-m-d H:i:s');
                //修改订单流水号表状态
                db('erp_pay_serial')->where('serial_number',$serial_number)->update([
                    'pay_status'=>2,
                    'update_time'=>$nowTime
                ]);

                if($orderInfoData['pay_status'] == 1){
                    db('erp_pay')->where('pay_code',$orderInfoData['pay_code'])->update([
                        'pay_status' => 2,
                        'pay_time'   => $nowTime,
                        'pay_money'   => $orderInfoData['price']
                    ]);
                }

                /*
                 * 调erp接口
                 */
                $erp = config('ext.app_config');  //读取erp配置文件
                $addr = $erp['sx_erp']['addr'];  //调用url
                $url = $addr . '/SX_VipApi/Vip_OnLinePaymentOpen?Token=^******^&orderId='.$orderInfoData['order_number'].'&pay_code='.$orderInfoData['pay_code'].'&paystate=1';
                $response = requestERP($url, '');  //调用erp接口
                if ($response['Code'] != 200) {
                    //调取不成功待处理
                    return array('error'=>1,'code'=>203,'msg'=>'通知erp支付结果失败');

                    //controller('front/Order')->errorLog($url, $orderInfoData['pay_code']);
                }

                db()->commit();
                return array('msg'=>'success');
            }catch (Exception $e){

                db()->rollback();
                return array('error'=>1,'code'=>201,'msg'=>$e->getMessage());
            }

        }else{
            return array('error'=>1,'code'=>202,'msg'=>'支付失败或支付金额不符');
        }


    }

    /*
     * 儿童套系，修改vip订单状态，erp下单
     */
    public function setChildPackageOrder($params){

        $order_no = $params["order_no"];  //单号
        $pay_fee = $params["pay_fee"];  //支付金额
        $pay_status = $params["pay_status"];  //支付状态

        //根据支付流水号 查询订单
        $payOrderSerial = db('s_order_serial')->where('serial_number',$order_no)->find();


        $erp   = config('ext.app_config');  //读取erp配置文件
        $addr  = $erp['sx_erp']['addr'];    //调用url

        if($pay_status == "PAYED" && (int)$pay_fee == $payOrderSerial['pay_price'] * 100){//判断支付成功

            // textlog('zltype'.$payOrderSerial['zltype']);
            //判断当前订单 是 “婚纱” 还是 “儿童”

                //textlog('儿童');

                //此次支付中的所有套系订单
                $orderList = db('s_package_order')
                    ->where('payment_order_sn','in',explode(',',$payOrderSerial['order_number']))
                    ->alias('order')
                    ->join('s_package_info package','order.p_id = package.id','left')
                    ->field('order.*,package.erp_package_name,package.consumption_type')
                    ->select();

                $user_id = $orderList[0]['user_id'];

                //获取开单店 开单人
                $all_package = db('c_sysconfig')->where('ckey','all_package')->value('cvalue');
                if($all_package == 1){ //店里展示所有套系
                    //订单推荐人
                    $users_recommend = db('m_users_recommend')->where('user_id',$user_id)->find();
                    if($users_recommend){
                        $shop_code = $users_recommend['recommend_shop_code'];
                        $staff_name = $users_recommend['recommend_staff_name'];
                    }else{
                        //取默认设置
                        $defaultConfig = db('c_sysconfig')->where('ckey','order_default_data')->find();
                        $default = json_decode($defaultConfig['cvalue'],true);
                        $shop_code = $default['shop_code'];
                        $staff_name = $default['staff_name'];
                    }

                    $staffInfo = $this->getStaff(['staffname'=>$staff_name]);
                    $staff_sn = $staffInfo[0]['staff_sn'];
                    $staff_id = $staffInfo[0]['id'];
                    //$shop_code = $staffInfo[0]['shop_code'];

                }else{
                    //不展示所有套系，只展示本店，说明订单中所有套系是同一个店的
                    $shop_code = $orderList[0]['shop_code'];
                }

                $shopData = $this->getShop(['shop_code'=>$shop_code]);
                $shop_name = $shopData[0]['shop_name'];
                $sn = $shopData[0]['sn'];
                $brand_id = $shopData[0]['brandclass_id'];
                $brandclass = $shopData[0]['brandclass'];


                $updateSerial = db('s_order_serial')->where('serial_number',$order_no)->update(['pay_status'=>2,'update_time'=>date('Y-m-d H:i:s')]);
                if($updateSerial === false){
                    payment_log("流水号表修改支付状态失败",$order_no,'');
                    //print_r(array('error'=>1,'code'=>204,'msg'=>'流水号表修改支付状态失败'));die;
                    return array('error'=>1,'code'=>204,'msg'=>'流水号表修改支付状态失败');
                }
                
            if($payOrderSerial['zltype'] == 'ET'){

                $url   = $addr."/SX_ChildErpAppNew/SX_OpenOrderVIPJGQET?Token=^******^";
                foreach($orderList as $k => $orderInfo){

                    //优惠券详情
                    if($orderInfo['coupon_id']){
                        $coupon = db('c_coupon_list')->where('id',$orderInfo['coupon_id'])->find();
                        if($coupon['discount_type'] == 3){//兑换券（赠品）
                            $productInfo = $coupon['product_info'];
                        }
                    }

                    if($orderInfo['erp_vipcard_diff']>0 && $orderInfo['erp_vipcard']){
                        $payMoney = 0;
                    }else{
                        $payMoney = $orderInfo['order_pay_price'];
                    }

                    $dataArray = [
                        'mname'              => '',
                        'mphone'             => '',
                        'wname'              => $orderInfo['wname'],
                        'wphone'             => $orderInfo['wphone'],
                        'bbname'             => $orderInfo['bb_name'],
                        'bbithdate'          => date('Ymd',strtotime($orderInfo['bb_birthday'])),
                        'bbsex'              => $orderInfo['bb_sex']?$orderInfo['bb_sex']:'',
                        'shop_code'          => $shop_code,
                        'shop_name'          => $shop_name,
                        'sn'                 => $sn,
                        'Brandid'            => $brand_id,
                        'brandclass'         => $brandclass,
                        'Targetdate'         => date('Ymd',strtotime($orderInfo['create_time'])),
                        'Package_name'       => $orderInfo['erp_package_name'],
                        'taoxijine'          => $orderInfo['order_package_price'] + $orderInfo['coupon_diff'],//订单中折扣后应付金额
                        'cpzhekou'           => $orderInfo['vip_discount'],//会员折扣 （例：0.95 九五折）
                        'PayMoney'           => $payMoney,//实际支付
                        'PayMoneyYH'         => $orderInfo['coupon_diff'],//优惠券优惠金额
                        'productinfo'        => $productInfo,//优惠券赠品
                        'Yc_day'             => date('Ymd',strtotime($orderInfo['yc_day'])),//预产期（六加一）
                        'StaffSN'            => $staff_sn,  //员工简码（六加一）
                        'Jiandangren'        => $staff_name,//建档人（六加一）
                        'JiandangrenID'      => $staff_id,  //建档人（六加一）
                        'Shop_order_code'    => $shop_code, //开单店面（六加一）
                        'Shop_order_name'    => $shop_name, //开单店面（六加一）
                        'Consumption_type'   => $orderInfo['consumption_type'], //消费类型（六加一）
                        'Package_type'       => '成长包套', //包套类型（六加一）
                        'Customer_channel'   => '商城',//渠道（六加一）
                        'Storeconsuitant1'   => $staff_name,//销售门市（六加一）
                        //'Reservelock'        => '锁定', //一销锁定1（六加一）
                        //'Cameraman'          => $staff_name, //摄影师（六加一）
                    ];


                    $dataJson    = json_encode($dataArray);
                    $response = requestERP($url, $dataJson);  //调用erp接口

                    if ($response['Code'] != 200) {
                        payment_log("同步ERP开单失败".$response['Msg'],$dataJson,json_encode($response));
                        //print_r(array('error'=>1,'code'=>201,'msg'=>'同步ERP开单失败'));die;
                        return array('error'=>1,'code'=>201,'msg'=>'同步ERP开单失败');
                    }
                    payment_log("同步ERP开单成功",$dataJson,json_encode($response));
                    $erp_order_sn = $response['Data'];  //erp订单号

                    //使用了erp线下储值卡的情况，收款方式：微信9，erp卡 4，优惠券7
                    if($orderInfo['erp_vipcard_diff'] > 0 && $orderInfo['erp_vipcard']){

                        $manyPayInfo = '4|'.$orderInfo['erp_vipcard_diff'];
                        if($orderInfo['coupon_diff'] > 0)      $manyPayInfo .= ';7|'.$orderInfo['coupon_diff'];
                        if($orderInfo['order_pay_price'] > 0)  $manyPayInfo .= ';9|'.$orderInfo['order_pay_price'];

                        $couponUrl   = $addr."/SX_ChildErpAppNew/SX_HYOrderPayNewMany?Token=^******^";
                        $couData = [
                            'orderId'    => $erp_order_sn,
                            'customerid' => '',
                            'Suoshu'     => '前期款',
                            'payclass'   => 0,
                            'paytype'    => '',
                            'paymentdate'=> date('Ymd'),
                            'payment_money'=> '',
                            'cashierman' => '线上会员',
                            'fundname'   => '线上会员支付',//款项
                            'remarks'    => '',
                            'shop_code'  => $orderInfo['shop_code'],
                            'shop_name'  => $orderInfo['shop_name'],
                            'sn'         => $sn,
                            'Brandid'    => $orderInfo['brand_id'],
                            'Brandclass' => $brandclass,
                            'Staffname'  => '',
                            'Staffid'    => '',
                            'Customer_from_index' => '',
                            'acceptor_address' => '',
                            'isshow' => '',//发票号
                            'wechat_payment_mcid' => '',
                            'Manypayinfo' => $manyPayInfo,
                            'cardid'      => $orderInfo['erp_vipcard'],
                            'cardtype'    => $orderInfo['erp_cardtype'],
                        ];

                        $conRes = requestERP($couponUrl, json_encode($couData));  //调用erp接口

                        if (!$conRes['Code'] == 200) {
                            payment_log("调用ERP收款失败(多笔收款信息接口)".$conRes['Msg'],json_encode($couData),json_encode($conRes));
                            //print_r(array('error'=>1,'code'=>202,'msg'=>'调用ERP优惠券付款失败'));die;
                            return array('error'=>1,'code'=>202,'msg'=>'调用ERP优惠券付款失败');
                        }
                    }else if($orderInfo['coupon_diff'] && $orderInfo['coupon_diff'] > 0){
                        //单独使用了优惠券，调用erp收款接口
                        $couponUrl   = $addr."/SX_ChildErpAppNew/SX_HYOrderPayNew?Token=^******^";
                        $couData = [
                            'orderId'    => $erp_order_sn,
                            'sn'         => $sn,
                            'shop_code'  => $orderInfo['shop_code'],
                            'shop_name'  => $orderInfo['shop_name'],
                            'Brandid'    => $orderInfo['brand_id'],
                            'brandclass' => $brandclass,
                            'cashierman' => '线上会员',
                            'fundname'   => '线上会员支付',
                            'Suoshu'     => '前期款',
                            'payclass'   => 0,
                            'paytype'    => 7,
                            'remarks'    => '线上会员优惠券付款',
                            'paymentdate'=> date('Ymd'),
                            'payment_money'=> $orderInfo['coupon_diff'],
                        ];

                        $conRes = requestERP($couponUrl, json_encode($couData));  //调用erp接口

                        if (!$conRes['Code'] == 200) {
                            payment_log("调用ERP优惠券付款失败".$conRes['Msg'],json_encode($couData),json_encode($conRes));
                            //print_r(array('error'=>1,'code'=>202,'msg'=>'调用ERP优惠券付款失败'));die;
                            return array('error'=>1,'code'=>202,'msg'=>'调用ERP优惠券付款失败');
                        }
                    }


                    //修改订单状态
                    $res = $this->editOrderStatus($orderInfo,$erp_order_sn);
                    if($res['code'] != 200){
                        $newdata = "流水单号=".$order_no."<br>ERP单号=".$erp_order_sn."<br>总金额=".$payOrderSerial['pay_price'];
                        payment_log("订单支付状态修改失败".$res['msg'],$newdata,'');
                        //print_r(array('error'=>1,'code'=>203,'msg'=>'订单支付状态修改失败'.$res['msg']));die;
                        return array('error'=>1,'code'=>203,'msg'=>'订单支付状态修改失败');
                    }
                }

            }elseif($payOrderSerial['zltype'] == 'HS'){
            
                foreach($orderList as $k => $orderInfo){
                    $url     = $addr."/SXWebErpAppStaff/SX_OpenOrderVIPJGQ?Token=^******^";

                    //优惠券详情
                    if($orderInfo['coupon_id']){
                        $coupon = db('c_coupon_list')->where('id',$orderInfo['coupon_id'])->find();
                        if($coupon['discount_type'] == 3){//兑换券（赠品）
                            $productInfo = $coupon['product_info'];
                        }
                    }
                    
                    $dataArray = [
                        'wname'                      => $orderInfo['wsname'],
                        'wphone'                     => $orderInfo['wsphone'],
                        'wwechat'                    => $orderInfo['wwechat'],
                        'address'                    => $orderInfo['address'],
                        'cssname'                    => '',
                        'area'                       => '',
                        'shop_code'                  => $shop_code,
                        'shop_name'                  => $shop_name,
                        'Consumption_type'           => XFLX_NAME,
                        //'Package_name'               => $packageData['package_name'],
                        'Package_name'               => $orderInfo['erp_package_name'], //套系名称
                        'Acceptor_address'           => '',
                        'Brandid'                    => $brand_id,
                        'BrandidConsumption_type_id' => '',
                        'Consumption_type_id'        => XFLX_ID,
                        'Cssname_id'                 => '',
                        'Area_id'                    => '',
                        'Sex'                        => '',
                        'PayMoney'                   => $orderInfo['order_pay_price'],//实际支付金额
                        'Taoxijine'                  => $orderInfo['order_package_price'] + $orderInfo['coupon_diff'],//套系金额
                        'SN'                         => $sn,
                        'vip_order_sn'               => $orderInfo['payment_order_sn'],
                        'recommend_phone'            => '', //推荐人手机号
                        'recommend_name'             => '', //推荐人姓名
                        'productinfo'                => $productInfo,
                    ];

                    $dataJson    = json_encode($dataArray);
                    $response = requestERP($url, $dataJson);  //调用erp接口
                    //return [$response,$dataArray];
                    //print_r($response);die;
                    if ($response['Code'] != 200) {
                        payment_log("同步ERP开单失败".$response['Msg'],$dataJson,json_encode($response));
                        //print_r(array('error'=>1,'code'=>201,'msg'=>'同步ERP开单失败'));die;
                        return array('error'=>1,'code'=>201,'msg'=>'同步ERP开单失败');
                    }
                    //textlog('4--开单成功');

                    $erp_order_sn = $response['Data'];  //erp订单号

                    //使用了优惠券，调用erp收款接口
                    if($orderInfo['coupon_diff'] && $orderInfo['coupon_diff'] > 0){
                        $couponUrl   = $addr."/SX_ChildErpAppNew/SX_HYOrderPayNew?Token=^******^";
                        $couData = [
                            'orderId'    => $erp_order_sn,
                            'sn'         => $sn,
                            'shop_code'  => $orderInfo['shop_code'],
                            'shop_name'  => $orderInfo['shop_name'],
                            'Brandid'    => $orderInfo['brand_id'],
                            'brandclass' => $brandclass,
                            'cashierman' => '线上会员',
                            'fundname'   => '线上会员支付',
                            'Suoshu'     => '前期款',
                            'payclass'   => 0,
                            'paytype'    => 7,
                            'remarks'    => '线上会员优惠券付款',
                            'paymentdate'=> date('Ymd'),
                            'payment_money'=> $orderInfo['coupon_diff'],
                        ];
                        //print_r($couponUrl);
                        //print_r($couData);
                        $conRes = requestERP($couponUrl, json_encode($couData));  //调用erp接口
                        //print_r($conRes);
                        if (!$conRes['Code'] == 200) {
                            payment_log("调用ERP优惠券付款失败".$conRes['Msg'],json_encode($couData),json_encode($conRes));
                            //print_r(array('error'=>1,'code'=>202,'msg'=>'调用ERP优惠券付款失败'));die;
                            return array('error'=>1,'code'=>202,'msg'=>'调用ERP优惠券付款失败');
                        }
                    }
                    //textlog('5--erp收款接口成功');

                    //修改订单状态
                    $res = $this->editOrderStatus($orderInfo,$erp_order_sn);
                    if($res['code'] != 200){
                        $newdata = "流水单号=".$order_no."<br>ERP单号=".$erp_order_sn."<br>总金额=".$payOrderSerial['pay_price'];
                        payment_log("订单支付状态修改失败".$res['msg'],$newdata,'');
                        //print_r(array('error'=>1,'code'=>203,'msg'=>'订单支付状态修改失败'.$res['msg']));die;
                        return array('error'=>1,'code'=>203,'msg'=>'订单支付状态修改失败');
                    }

                }
            }
            //textlog('6--反回调成功功');

            //print_r(array('msg'=>'success'));die;
            return array('msg'=>'success');
        }else{
            $newdata = "单号=".$order_no."<br>金额".$payOrderSerial['pay_price'];
            payment_log("支付失败或支付金额不符",$newdata,'');
            //print_r(array('error'=>1,'code'=>205,'msg'=>'支付失败或支付金额不符'));die;
            return array('error'=>1,'code'=>205,'msg'=>'支付失败或支付金额不符');
        }
    }

    /*
     * 事业部查询
     */
    public function getBrand($data){
        $hash = '5a38840b15ba9';
        $res = sx_call($hash,$data,'sx_mc');

        if($res['code'] == 200){
            return $res['data'];
        }else{
            return [];
        }
    }

    /*
    * 店面查询
    */
    public function getShop($data){
        $hash = '5a005e0038270';
        $res = sx_call($hash,$data,'sx_mc');

        if($res['code'] == 200){
            return $res['data'];
        }else{
            return [];
        }
    }

    /*
    * 人员详情
    */
    public function getStaff($data){
        $hash = '5a01766b4a3dd';
        $res = sx_call($hash,$data,'sx_mc');

        if($res['code'] == 200){
            return $res['data'];
        }else{
            return [];
        }
    }

    /*
     * 修改订单状态 选购清单状态
     */
    public function editOrderStatus($orderInfo,$erp_order_sn){

        db()->startTrans();
        try{
            //vip线上订单表
            db('s_package_order')->where('id',$orderInfo['id'])->update([
                'payment_status'=>2,
                'payment_time'=>date('Y-m-d H:i:s'),
                'erp_order_sn'=>$erp_order_sn
            ]);

            //选购清单表
            db('s_package_cart')->where(['id'=>$orderInfo['cart_id']])->update(['pay_time'=>date('Y-m-d H:i:s')]);

            db()->commit();
            return ['code'=>200,'msg'=>'success'];
        }catch (\Exception $e){
            db()->rollback();
            return ['code'=>201,'msg'=>$e->getMessage()];
        }

    }

    /*
     * 6+1先睹为快打赏礼物，礼物购买状态
     */
    public function checkGiftBuy($params){

        $pay_number = $params['order_no'];

        $giftOrder = db('m_order_gift')->where('pay_number',$pay_number)->find();

        $orderId = $giftOrder['orderId'];
        $fc = $giftOrder['fc'];
        $gift_money = $giftOrder['gift_money'];

        //若状态未支付，则修改支付状态，充值会员卡
        if(!$giftOrder['pay_time']){

            db()->startTrans();
            try{
                $gift = db('m_order_gift')->where('pay_number',$pay_number)->update(['pay_time'=>date('Y-m-d H:i:s')]);

                //操作赠送的人获得积分
                AddScore($gift['give_userid'],'',$gift['gift_score'],20,'打赏礼物积分');

                //礼物支付金额直接进到erp会员卡
                $erp = config('ext.app_config');
                $apiUrl = $erp['sx_erp']['addr'];
                $url = $apiUrl . '/SX_ChildVipApi/SX_VIPDaShang?Token=^******^&OrderId='.$orderId.'&Money='.$gift_money.'&currentfc='.$fc;

                $response = requestERP($url, '');  //调用erp接口

                //调取不成功待处理
                if ($response['Code'] != 200) {
                    payment_log('送礼物到会员卡余额','orderId-'.$orderId.'&fc-'.$fc.'&money-'.$gift_money,json_encode($response));
                }

                db()->commit();
                return ['msg'=>'success'];

            }catch (Exception $e){

                db()->rollback();
                return ['error'=>1,'code'=>201,'msg'=>'修改支付状态失败'];
            }

        }

        return ['msg'=>'success'];
    }



}