<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
namespace app\vip\command;
use think\console\Command;
use think\console\Input;
use think\console\Output;

class Importerporder extends Command{

    protected function configure()
    {
        $this->setName('erporder')->setDescription('Suxuan system service:erporder');
    }

    protected function execute(Input $input, Output $output)
    {


        $data = db('erp_order')->where('is_cl', '2')->find();

        while ($data)
        {
            $this->endOrder();
            sleep(180);

            //$data = db('erp_order')->where('is_cl', '2')->find();
        }

    }


    private function endOrder () {

        print_r('关');die;
        //set_time_limit(0);
        //ini_set("max_execution_time", 0);
        $data = db('erp_order')->where('is_cl', '2')->limit(10000)->select();

        //最低等级积分规则
        $mix_level_id = getLowestLevel()['id'];
        $num = 1;
        foreach($data as $k => $v){

            $tel = $v['wphone'] ? $v['wphone'] : $v['mphone']; //女士手机号优先
            $brandId = 0;      //品牌id
            $orderTime = $v['order_date'];  //订单时间
            $orderCode = $v['orderId'];  //传入的订单编号id
            $oneMoney  = $v['yixiao'];    //一销金额
            $twoMoney  = $v['erxiao'];    //二销金额
            $oneDetail = $v['yixiao_pay'];  //一销已付
            $twoDetail = $v['erxiao_pay'];  //二销已付
            $totalMoney   = $v['total_money'];//订单总金额
            $package_name = $v['package_name'];//套系名称

            $orderTime = date('Y-m-d',strtotime($orderTime));

            //检测是否存在订单
            $orderCheck = db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->find();  //看当前用户在订单表中是否有此订单

            if($orderCheck){

                if($tel == $orderCheck['phone']){
                    //$userPhone = db('m_users_phone')->where(['phone'=>$tel])->find();
                    $jifen_log = db('minute_log')->where('create_id',$orderCode)->find();
                    if($orderCheck['is_end'] == 1 && $jifen_log && $jifen_log['m_num'] > 0){
                        db('erp_order')->where('id',$v['id'])->update(['is_cl'=>1,'error'=>'近期订单，会员系统内已存在并且已奖励过积分']);
                        continue;
                    }
                }else{
                    db('erp_order')->where('id',$v['id'])->update(['is_cl'=>1,'error'=>'会员系统内已存在此单号,单号重复']);
                    continue;
                }

            }


            //验证手机号
            $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$tel);
            if (!$checkTel) {
                db('erp_order')->where('id',$v['id'])->update(['is_cl'=>1,'error'=>'手机号错误']);
                continue;
            }

            $user_id = 0;
            $user_phone_id = 0;
            $level_id = $mix_level_id;

            //用户信息
            $userData = db("m_users")->where("phone",$tel)->find();
            if($userData){
                $user_id = $userData['id'];
                //会员等级
                $level_id = $userData['level'];
            }

            $orderData = [
                'order_number' => $orderCode,
                'phone'        => $tel,
                'one_money'    => $oneMoney,
                'two_money'    => $twoMoney,
                'one_detail'   => $oneDetail,
                'two_detail'   => $twoDetail,
                'total_money'  => $totalMoney,
                'order_time'   => $orderTime,
                'package_name' => $package_name,
                'brandid'      => $brandId,
                'create_time'  => date('Y-m-d H:i:s'),
                'user_id'      => $user_id,

                'can_check'    => 1,//订单，可审核，奖励
                'is_end'       => 1,//1订单已完成，2未完成
                'zltype'       => 'HS',
            ];


            db()->startTrans();
            try{

                //放开
                if(!$orderCheck){
                    db('m_order')->insert($orderData);
                }else{
                    db('m_order')->where('order_number',$orderCode)->where('delete_time is null')->update(['is_end'=>1,'can_check'=>1,'zltype'=>'HS']);
                }


                //积分规则
                /*
                $scoreRule = getLevelRule($level_id);

                $onePay = $scoreRule['fristbuy'];            //一销花费
                $oneScore = $scoreRule['fristbuy_score'];    //奖励
                $secondPay = $scoreRule['secondbuy'];        //二销花费
                $secondScore = $scoreRule['secondbuy_score'];//奖励
                */
                $firstScore = round((1/100) * $oneDetail);  //一销获取积分(四舍五入)
                $secondScore = round((1/100) * $twoDetail); //二销获取积分
                $addScore = round($firstScore + $secondScore);


                //新等级
                $newLevel = getLevelByOnce($level_id,$oneDetail);

                $updateData = [];
                $updateData['total_score']  = ['exp',"total_score + $addScore"];
                $updateData['growth_value'] = ['exp',"growth_value + $addScore"];
                $addMoney = $oneDetail + $twoDetail;
                $updateData['total_consumption'] = ['exp',"total_consumption + $addMoney"];

                //放开
                //修改会员积分和等级
                if($userData){

                    if($newLevel != $level_id)   $updateData['level'] = $newLevel;

                    db('m_users')->where('id',$user_id)->update($updateData);

                }else{

                    //手机号导入表内是否存在此手机号信息
                    $is_phone=db('m_users_phone')->where(['phone'=>$tel])->find();

                    if($is_phone){
                        //存在 修改积分 等级
                        if($newLevel != $is_phone['level_id'])  $updateData['level_id'] = $newLevel;

                        $updateData['update_time'] = date('Y-m-d H:i:s');
                        db('m_users_phone')->where(['phone'=>$tel])->update($updateData);

                        $user_phone_id = $is_phone['id'];

                    }else{
                        //没有会员信息 暂存在手机号导入表
                        $addData = [
                            'phone'       => $tel,
                            'brandid'     => $brandId,
                            'level_id'    => $newLevel,
                            'total_score' => $addScore,
                            'growth_value'=> $addScore,
                            'total_consumption' => $addMoney,
                            'create_time' => date('Y-m-d H:i:s')
                        ];


                        $user_phone_id = db('m_users_phone')->insertGetId($addData);

                    }

                }
                unset($updateData);


                //更改此条数据处理状态
                /*
                $arr = [
                    'is_cl'        => 1,
                    'yixiao_jifen' => $firstScore,
                    'erxiao_jifen' => $secondScore,
                    'jifen'        => $addScore,
                    'is_user'      => $userData ? 1 : 2
                ];
                db('erp_order')->where('id',$v['id'])->update($arr);
                */

                $is_user = $userData ? 1 : 2;
                db()->query('update erp_order set is_cl = 1,yixiao_jifen="'.$firstScore.'",erxiao_jifen="'.$secondScore.'",jifen="'.$addScore.'",is_user="'.$is_user.'" where id="'.$v['id'].'"');


                //放开
                //积分记录
                addScoreLog ('erp线下订单积分',$addScore,$user_id,14,$user_phone_id,1,$orderCode);

                db()->commit();


            }catch (\Exception $e){


                db()->rollback();
                db('erp_order')->where('id',$v['id'])->update(['is_cl'=>1,'error'=>$e->getMessage()]);

                $this->textlog(date('H:i:s').'---'.$e->getMessage());

            }

            if($num%500==0){
                $this->textlog(date('H:i:s').'---'.$num);
            }

            $num++;

        }


    }


    private function textlog($log){
        file_put_contents(ROOT_PATH."/turnlogs.txt",$log."\r\n",FILE_APPEND);
    }


}