<?php
/**
 * 品牌信息
 * User: zhaibaoming
 * Date: 2018/8/7 0007
 * Time: 9:18
 */

namespace app\vip\controller;

use app\index\controller\Base;

class Brandinformation extends Base
{
    /**
     * 一级列表
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function index()
    {
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');
            $limit = isset($limit) ? $limit : 10;
            $page = isset($page) ? ($page - 1) * $limit : 0;
            $list['data'] = controller('McBrandInformation', 'model')->getLimit($page, $limit);
            $list['count'] = controller('McBrandInformation', 'model')->getCount();
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'品牌设定'
            ]
        ]);
        return $this->fetch('Brandinformation/index');
    }

    /**
     * 子集列表
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function subsetList()
    {
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');
            $id = request()->get('id');
            $limit = isset($limit) ? $limit : 10;
            $page = isset($page) ? ($page - 1) * $limit : 0;
            $list['data'] = controller('McBrandInformation', 'model')->getSubsetLimit($page, $limit, $id);
            $list['count'] = controller('McBrandInformation', 'model')->getSubsetCount($id);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $id = request()->get('id');
        $this->assign('id', $id);
        return $this->fetch('Brandinformation/subsetList');
    }

    /**
     * 添加数据
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function add()
    {
        if (request()->isAjax()) {
            $res = $this->handleData(1, 0);
            if ($res['code'] == 200) {
                $this->msg = ['status' => 1, 'msg' => '添加成功'];
            } else {
                $this->msg = ['status' => 0, 'msg' => $res['msg']];
            }
            return json($this->msg);
        }
        return $this->fetch('Brandinformation/add');
    }

    /**
     * 添加子集数据
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function subsetadd()
    {
        if (request()->isAjax()) {
            $id = request()->post('id', 0, 'intval');
            if ($id < 1) {
                $this->msg = ['status' => 0, 'msg' => '参数错误'];
                return json($this->msg);
            }
            $res = $this->handleData(1, $id);
            if ($res['code'] == 200) {
                $this->msg = ['status' => 1, 'msg' => '添加成功'];
            } else {
                $this->msg = ['status' => 0, 'msg' => $res['msg']];
            }
            return json($this->msg);
        }
        $id = request()->get('id', 0, 'intval');
        $this->assign('id', $id);
        return $this->fetch('Brandinformation/subsetadd');
    }
    /**
     * 修改子集数据
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function subsetedit(){
        if (request()->isAjax()) {
            //$res = $this->handleData(2, $id);
            $acdata = request()->post();
            $id = $acdata['id'];
            $data['name'] =$acdata['name'];
            $data['url']  =$acdata['url'];
            $data['sort'] =$acdata['sort'];
            
            $res = db('McBrandInformation')->where('id',$id)->update($data);
            if ($res || $res === 0) {
                $this->msg = ['status' => 1, 'msg' => '修改成功'];
            } else {
                $this->msg = ['status' => 0, 'msg' => $res['msg']];
            }
            return json($this->msg);
        }
        $id = request()->get('id', 0, 'intval');
        $sid = request()->get('sid', 0, 'intval');
        if ($id < 1) {
            $this->error('参数错误');
        }
        $this->assign('id',$id);
        $this->assign('sid',$sid);
        $data = controller('McBrandInformation', 'model')->getIdData($id);
        $this->assign('data', $data);
        return $this->fetch('Brandinformation/subsetedit');
    }

    /**
     * 修改数据
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function edit()
    {
        if (request()->isAjax()) {
            $res = $this->handleData(2, 0);
            if ($res['code'] == 200) {
                $this->msg = ['status' => 1, 'msg' => '添加成功'];
            } else {
                $this->msg = ['status' => 0, 'msg' => $res['msg']];
            }
            return json($this->msg);
        }
        $id = request()->get('id', 0, 'intval');
        if ($id < 1) {
            $this->error('参数错误');
        }

        $data = controller('McBrandInformation', 'model')->getIdData($id);
        $this->assign('data', $data);
        return $this->fetch('Brandinformation/edit');
    }

    /**
     * 处理数据写入
     * @param $type 1 新增  2修改
     * @param $status parent_id 级别
     * @return mixed
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function handleData($type, $status)
    {
        $acdata = request()->post();
        $id = $acdata['id'];
        $data['name'] = $acdata['name'];
        $resultData = [
            'code' => 0,
            'msg' => '',
        ];
        if (empty($data['name'])) {
            $resultData['msg'] = '名称不能为空!';
            return $resultData;
        }

        if (mb_strlen($data['name'], 'utf-8') > 20) {
            $resultData['msg'] = '名称不能大于20个字!';
            return $resultData;
        }
        $data['sort'] = $acdata['sort'];
        $data['parent_id'] = $status;
        $data['image'] = '';
        $fileimg = request()->file("image");
        if ($fileimg) {
            //$data['image'] = saveImg($fileimg, $this->imgWH[0], $this->imgWH[1]);
            $data['image'] =  save_images($fileimg);
        }


        if ($type == 1) {
            if ($status > 0) {
                $data['url'] = $acdata['url'];
                if (empty($acdata['url'])) {
                    $resultData['msg'] = '链接不能为空!';
                    return $resultData;
                }
                if (strlen($acdata['url']) > 200) {
                    $resultData['msg'] = '链接长度不能大于200个字!';
                    return $resultData;
                }
                $res = controller('McBrandInformation', 'model')->addSubsetData($data);
            } else {
                $res = controller('McBrandInformation', 'model')->addData($data);
            }
        } else {
            if ($data['image'] == '') {
                $res = controller('McBrandInformation', 'model')->editData($data, $id);
            } else {
                $res = controller('McBrandInformation', 'model')->editImageData($data, $id);
            }
        }

        if ($res) {
            $resultData['code'] = 200;
            return $resultData;
        }
        $resultData['msg'] = '操作失败!';
        return $resultData;
    }

    /**
     * 删除
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function del()
    {
        $resultData = [
            'code' => 0,
            'msg' => '',
        ];
        $id = request()->post('id', 0, 'intval');
        if ($id < 1) {
            $resultData['code'] = 301;
            $resultData['msg'] = '参数错误';
            return json($resultData);
        }

        $res = controller('McBrandInformation', 'model')->del($id);
        if ($res) {
            $resultData = ['code' => 200, 'msg' => '删除成功'];
        } else {
            $resultData = ['status' => 302, 'msg' => '删除失败'];
        }
        return json($resultData);
    }
}