<?php
/**
 * 投诉建议控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月22日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Session;

class Commend extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'commend';

    function _initialize() {
        //如果是API接口，需要在此处定义is_api为true
        if(!defined('IS_POST')){
            define('IS_POST', \think\Request::instance()->isPost());
        }
        parent::_initialize();
    }
    /**
     * 方法描述: 获取列表
     * @return array 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
                'typeid' => (int)input('get.typeid'),
            ];
            $data['data']  = controller($this->libname,'lib')->getList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'投诉建议管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
   
    
    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $arr = db('user_commend')->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id);
        if($res){
        	action_log($arr);          //写日志
        }
        return json(['status'=>$res?1:0]);
    }
    
    /**
     * 方法描述     查看投诉详情
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function view(){
        $id  = request()->get('id');
        if($id){
            $res = controller($this->libname,'lib')->getOne($id);
        }else{
            $this->error('无法获取您要查看的信息');
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'查看投诉\建议详情'
            ]
        ]);
        $this->getTopMenu();
        $this->assign('data',$res);
        return $this->fetch();
    }
    
    /**
     * 方法描述     设置状态
     * @param  int $id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id     = request()->post('id');
        $status = 1;
        $res = controller($this->libname,'lib')->setStatus($id,$status);
        if($res){
        	action_log($res);
        }
        return json(['status'=>$res?1:0]);
    
    }

    public function kf(){

        if( IS_POST ){
            $detail = input('post.');

            if(trim($detail['url'])){
                $matches = parse_url(trim($detail['url']));
                $scheme = empty($matches['scheme'])?'http://':'';
                $data['url']=$scheme.trim($detail['url']);
            }else{
                $data['url']='';
            }

            $data['kf_key'] = trim($detail['kf_key']);
//            $data['info_key'] = trim($detail['info_key']);//udesk用
            $data['phone'] = $detail['phone'];

            if(db('c_kf')->where('brandid',Session::get('brandid'))->find()){
                $res = db('c_kf')->where(array('id'=>$detail['id']))->update($data);
                if( $res === false ){
                    $arr = array('status'=>0,'msg'=>"修改失败");
                }else{
                    $arr = array('code'=>1,'msg'=>"修改成功");
                }
            }else{
                $data['brandid']=Session::get('brandid');
                $data['create_time']=date("Y-m-d H:i:s");
                $res = db('c_kf')->insert($data);
                if( $res === false ){
                    $arr = array('status'=>0,'msg'=>"设置失败");
                }else{
                    $arr = array('code'=>1,'msg'=>"设置成功");
                }
            }
            return json($arr);
        }else{
            $kf=db('c_kf')->where('brandid',Session::get('brandid'))->find();
            $this->assign('data',$kf);
            $this->getTopMenu();
            return $this->fetch();
        }


    }
    
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/commend/';
        //print_r($menuList);
        $indexurl    = $currentUrlStart.'index';
        $setstatus   = $currentUrlStart.'setstatus';
        $view        = $currentUrlStart.'view';
        $del         = $currentUrlStart.'del';
    
        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        
        $typeid = (int)input('get.typeid');
        
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $indexurl){
                $class = '';
                if($currentUrl == $indexurl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.($typeid!=2?'mactive':'').'" ><a href="'.$indexurl.'">投诉管理</a></div>';
                $topmenu .= '<div class="layui-btn '.($typeid==2?'mactive':'').'" ><a href="'.$indexurl.'?typeid=2">建议管理</a></div>';
                $topmenu .='<div class="layui-btn '.($typeid==3?'mactive':'').'" ><a href="/vip/commend/kf">咨询方式配置</a></div>';
            }else if($menuUrl == $setstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }else if($menuUrl == $view){
                $this->assign('view',1);
            }
        }
        $this->assign('topmenu',$topmenu);
    }
    


}