<?php
/**
 * 优惠券控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\session;
class Coupon extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $imgWH   = [500,300];
    /**
     * 方法描述:优惠券列表
     * @return array 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            $data['data']  = controller('coupon','lib')->getList($c);
            unset($c['limit'],$c['page']);
            $data['count'] = controller('coupon','lib')->getCouponCount($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'优惠券管理'
            ],

        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
   
    /**
     * 添加优惠券
     */
    public function addCoupon(){
        if(IS_POST && request()->isAjax()){
            $fileimg = request()->file("img");
            $upimg = false;
            if($fileimg){
                $upimg  = saveImg($fileimg,$this->imgWH[0],$this->imgWH[1]);
            }else{
                return json(['status'=>0,'msg'=>'请上传优惠券图片']);
            }

            if(($fileimg && $upimg) || !$fileimg){
                $data = [
                    'title' => request()->post('title'),
                    'coupon_typeid'=> request()->post('typeid'),
                    'money' => request()->post('money'),
                    'content'   => request()->post('content'),
                    'total_num' => request()->post('totalnum'),
                    'coupon_num'=> request()->post('couponnum'),
                    'start_time'=> request()->post('starttime'),
                    'end_time'  => request()->post('endtime'),
                    'status'    => request()->post('status'),
                    'img'       => $upimg,
                    'order_num' => request()->post('ordernum'),
                    'min_consume' => request()->post('minconsume'),
                    'each_max_total' => (int)request()->post('eachmaxtotal'),
                    'expire_time' => (int)request()->post('expiretime'),
                    'discount_type' => (int)request()->post('discounttype'),
                    'is_show' => (int)request()->post('is_show'),
                    //'convert_money'=> request()->post('convert_money'),
                    'can_share'=> request()->post('can_share'),
                    'product_info'=> request()->post('product_info'),//产品名称|数量;
                    'package_ids'=> input('package_ids/a') ? implode(',',input('package_ids/a')) : '', //适用套系
                ];
                $a = controller('coupon','lib')->add($data);
                if($a){
                    action_log($data);      //写日志
                    $this->msg = ['status'=>1,'msg'=>'添加成功'];
                }else{
                    // 上传失败获取错误信息
                    $this->msg = ['status'=>0,'msg'=>'添加失败'];
                }
 
            }else{
                 $this->msg = ['status'=>0,'msg'=>'图片上传失败,请确认是图片类型'];
            }
            
            return json($this->msg);
            
        }else{   
            $this->assign([
                'headinfo'=>[
                    'title'=>'发布新优惠券'
                ],
                'imgsize'=>$this->imgWH
            ]);

            $param['brand_id'] = (int)$this->brandId;
            $shop_list = controller('vip/Package', 'lib')->getShopList($param);

            //全部系统内已设定套系(未删除)
            $package = db('s_package_info')->where('brand_id',$this->brandId)->where('is_del',1)->select();

            $this->getTopMenu();
            $this->assign('types',controller('coupon','lib')->getCouponType());
            $this->assign(['shop_list'=>$shop_list,'package'=>$package]);
            return $this->fetch();
        }
    }

    /*
     * 获取产品列表
     */
    public function getProductList(){
        $shop_code = input('shop_code');
        if(!$shop_code){
            return array('code'=>201,'msg'=>'没有shop_code');
        }

        //读取erp配置文件
        $erp = config('ext.app_config');
        $addr = $erp['sx_erp']['addr'];

        if (!$addr) {
            return array('code'=>202,'msg'=>'请配置ERP-API接口地址');
        }

        $url = $addr.'SX_ChildErpAppNew/SX_ConsumptionItmsSet?Token=^******^&Code='.$shop_code;
        $response = requestERP($url, []);
        if ($response['Code'] == 200) {
            $returnData = $response['Data'];
        }else{
            $returnData = [];
        }

        return array('code'=>200,'data'=>$returnData);

    }



    /**
     * 修改优惠券信息
     * @param string
     * @param string
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function editCoupon(){
        
        if(IS_POST && request()->isAjax()){
            // 获取上传的图片信息
            $img = false;
            $fileimg = request()->file("img");
            if($fileimg){
                $img  = saveImg($fileimg,$this->imgWH[0],$this->imgWH[1]);
            }else{
                return json(['status'=>0,'msg'=>'请上传优惠券图片']);
            }

            // 数据信息
            $data = [
                'id'    =>request()->post('id'),
                'title' => request()->post('title'),
                'coupon_typeid'=> request()->post('typeid'),
                'money'     => request()->post('money'),
                'content'   => request()->post('content'),
                'total_num' => request()->post('totalnum'),
                'coupon_num'=> request()->post('couponnum'),
                'start_time'=> request()->post('starttime'),
                'end_time'  => request()->post('endtime'),
                'status'    => request()->post('status'),
                'order_num' => request()->post('ordernum'),
                'min_consume'    => request()->post('minconsume'),
                'each_max_total' => request()->post('eachmaxtotal'),
                'expire_time' => (int)request()->post('expiretime'),
                'discount_type' => (int)request()->post('discounttype'),
                'is_show' => (int)request()->post('is_show'),
                'can_share' => (int)request()->post('can_share'),
                'product_info'=> input('discounttype')==3?request()->post('product_info'):'',//产品名称|数量;
                'package_ids'=> input('package_ids/a') ? implode(',',input('package_ids/a')) : '', //适用套系
            ];
           
            if($img){
                $data['img'] = $img;
            }
            // 处理数据
            $res = controller('coupon','lib')->edit($data);
            if($res){
                action_log($data);          //写日志
                $this->msg = ['status'=>1,'msg'=>'修改成功'];
            }else{
                $this->msg = ['status'=>0,'msg'=>'修改失败'];
            }
            return json($this->msg);
            
        }else{
            
            $id = request()->get('id');
            if($id){
                $coupon = controller('coupon','lib')->getOne($id);
                $types  = controller('coupon','lib')->getCouponType();

                //全部系统内已设定套系
                $package = db('s_package_info')->where('brand_id',$this->brandId)->select();

                //此券适用套系
                $coupon['package_ids'] = $coupon['package_ids'] ? explode(',',$coupon['package_ids']) : [];

                //兑换产品
                $product = explode(';',trim($coupon['product_info'],';'));
                $product_info = [];
                foreach($product as $k => $v){
                    if($v){
                        $arr = explode('|',$v);
                        $product_info[] = ['product'=>$arr[0],'num'=>$arr[1]];
                    }
                }

                $param['brand_id'] = (int)$this->brandId;
                $shop_list = controller('vip/Package', 'lib')->getShopList($param);

                $this->assign(['coupon'=>$coupon,'types'=>$types,'product_info'=>$product_info,'shop_list'=>$shop_list,'package'=>$package]);
                $this->assign([
                    'headinfo'=>[
                        'title'=>'修改优惠券信息'
                    ],
                    'imgsize'=>$this->imgWH
                ]);
                $this->getTopMenu();
                return $this->fetch();
            }else{
                return $this->error('无法获取您要修改的数据！');
            }
            
        }
    }
    
    /**
     * 方法描述:设置优惠券的状态，是否启用
     * @param  int $couponid 优惠券批次的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id = request()->post('id');
        $status = request()->post('status');
        $res = controller('coupon','lib')->setStatus($id,$status);
        return json(['status'=>$res?1:0]);
    }
    
    
    /**
     * 方法描述: 删除优惠券假删除
     * @param  int $id 优惠券批次的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function delCoupon(){
        $id = request()->post('id');
        $arr = db('c_coupon_num')->where('id',$id)->find();
        $res = controller('coupon','lib')->del($id);
        if($res){
        	action_log($arr);      //写日志
        }
        return json(['status'=>$res?1:0]);
    }

    /**
     * 方法描述  所有领养情况
     * @param  array $c 条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function receive(){

        if(request()->isAjax()){

            $end_time = input('get.expire_time_end');
            $end = date("Y-m-d",strtotime("$end_time +1 day"));

            $c = [
                'limit' => (int)input('get.limit'),
                'page'  => (int)input('get.page'),
                'searchtypeid' => (int)input('get.searchtypeid'),
                'searchkey'    => input('get.searchkey'),
                'id'           => (int)input('get.id'),
                'expire_time_start'  => input('get.expire_time_start'),
                'expire_time_end'  => $end,
            ];

            $c = array_filter($c);
            $d['data'] = controller('coupon','lib')->getReceiveDetailList($c);
            unset($c['limit'],$c['page']);
            $d['count'] = controller('coupon','lib')->getReceiveCouponCount($c);
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $this->assign([
            'coupon_num_id' => (int)input('get.id'),
            'headinfo'=>[
                'title'=>'优惠券的领用情况'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }

    //导出
    public function export(){

        $end_time = input('get.expire_time_end');
        $end = date("Y-m-d",strtotime("$end_time +1 day"));

        $c = [
            'limit' => (int)input('get.limit'),
            'page'  => (int)input('get.page'),
            'searchtypeid' => (int)input('get.searchtypeid'),
            'searchkey'    => input('get.searchkey'),
            'id'           => (int)input('get.id'),
            'expire_time_start'  => input('get.expire_time_start'),
            'expire_time_end'  => $end,
            'all' => 1
        ];

        $c = array_filter($c);
        $list = controller('coupon','lib')->getReceiveDetailList($c);

        $data = [];
        foreach($list as $k => $v){

            $data[$k]['title']  = $v['title'];
            $data[$k]['coupon_code']    = $v['coupon_code'];
            $data[$k]['discount_type']  = $v['discount_type'] == 1 ? '直减型' : '折扣型';
            $data[$k]['discount_value'] = $v['discount_value'];
            $data[$k]['username'] = $v['username'];
            $data[$k]['phone']    = $v['phone'];
            $data[$k]['expire_time'] = $v['expire_time'];
            $data[$k]['create_time'] = $v['create_time'];
            $data[$k]['status']    = $v['status'] == 1 ? '已使用' : '未使用';
            $data[$k]['use_time']  = $v['use_time'];

        }


        $title = ['优惠券批次名称','优惠券码','优惠券类型','优惠值','领取的用户名','手机号','过期时间','创建时间','优惠券状态','使用时间'];

        controller('users','lib')->export($title,$data,date('Y-m-d').'_coupon.xlsx');

    }
    
    /**
     * 方法描述  某个券的领用情况
     * @param  array $c 条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function receiveDetail(){
        
        if(request()->isAjax()){

            $end_time = input('get.expire_time_end');
            $end = date("Y-m-d",strtotime("$end_time +1 day"));

            $c = [
                'limit' => (int)input('get.limit'),
                'page'  => (int)input('get.page'),
                'searchtypeid' => (int)input('get.searchtypeid'),
                'searchkey'    => input('get.searchkey'),
                'id'           => (int)input('get.id'),
                'expire_time_start'  => input('get.expire_time_start'),
                'expire_time_end'  => $end,
            ];

            $c = array_filter($c);
            $d['data'] = controller('coupon','lib')->getReceiveDetailList($c);
            unset($c['limit'],$c['page']);
            $d['count'] = controller('coupon','lib')->getReceiveCouponCount($c);
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $this->assign([
            'coupon_num_id' => (int)input('get.id'),
            'headinfo'=>[
                'title'=>'查看优惠券的详情'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    
 
    /**
     * 方法描述     设置优惠券的使用状态
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:34:22
     */
    public function setCouponStatus(){
        $c = [
            'status' => request()->post('status'), // 状态是否使用
            'id'     => request()->post('id'), //要设置的数据id
        ];
        $d = controller('coupon','lib')->setCouponStatus($c);
        if($d){
        	action_log($d);        //写日志
        }
        return json(['status'=>$d?1:0]);
    }


    /*
     * 优惠券到期提醒
     */
    public function config(){

        if(request()->isAjax()){

            $data = input('post.');

            $dyas = array_filter($data['days']);

            if(count($dyas) == 0){
                return ['code'=>201,'msg'=>'请设置提醒时间！'];
            }

            $info = [
                'type' => $data['type'],
                'days' => $dyas,
            ];

            $cvalue = json_encode($info);

            if(db('c_sysconfig')->where('ckey','coupon_expire')->find()){
                $res = db('c_sysconfig')->where('ckey','coupon_expire')->update(['cvalue'=>$cvalue]);
            }else{
                $res = db('c_sysconfig')->insert(['ckey'=>'coupon_expire','cvalue'=>$cvalue]);
            }

            if($res === false){
                return ['code'=>204,'msg'=>'设置失败，请稍后重试！'];
            }else{
                return ['code'=>200,'msg'=>'设置成功！'];
            }

        }else{

            $configInfo = db('c_sysconfig')->where('ckey','coupon_expire')->value('cvalue');
            $coupon_expire = json_decode($configInfo,true);

            $this->assign(['data'=>$coupon_expire]);
            return $this->fetch();

        }

    }

    
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/coupon/';
        //print_r($menuList);
        $indexurl    = $currentUrlStart.'index';
        $setstatus   = $currentUrlStart.'setcouponstatus';
        $del   = $currentUrlStart.'delcoupon';
        $add   = $currentUrlStart.'addcoupon';
        $edit  = $currentUrlStart.'editcoupon';
        $receivedetail  = $currentUrlStart.'receivedetail';

        $current2UrlStart = '/vip/coupontype/';
        $type = $current2UrlStart.'index';
        $typeadd = $current2UrlStart.'add';
        $typedel = $current2UrlStart.'del';
        $typeedit = $current2UrlStart.'edit';

        $indexbag = '/vip/couponbag/index';
        $addbag   = '/vip/couponbag/add';
        $editbag  = '/vip/couponbag/edit';
        $delbag   = '/vip/couponbag/del';
        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);

        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);

            //优惠券页面
            if($currentUrl == $indexurl){
                if($menuUrl == $add){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><a href="'.$add.'"><i class="layui-icon">&#xe654;</i>添加新优惠券</a></div>';
                }

                if($menuUrl == $receivedetail){
                    $topmenu .= '<div class="layui-btn" ><a href="'.$receivedetail.'">优惠券核销</a></div>';
                    $this->assign('receivedetail',1);
                }
            }

            //优惠券类型页面
            if($currentUrl == $type){
                if($menuUrl == $typeadd){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" lay-event="addtypebtn" id="addtypebtn"><i class="layui-icon">&#xe654;</i>新增优惠券类别</div>';
                }
            }

            //卡包
            if($currentUrl == $indexbag){
                if($menuUrl == $addbag){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><a href="'.$addbag.'"><i class="layui-icon">&#xe654;</i>添加卡包</a></div>';
                }
            }

            //新增卡包
            if($currentUrl == $addbag){
                if($menuUrl == $indexbag) {
                    $topmenu .= '<div class="layui-btn"><a href="' . $indexbag . '">卡包管理</a></div>';
                }
            }

            if($menuUrl == $setstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }else if($menuUrl == $edit){
                $this->assign('edit',1);
            }else if($menuUrl == $typeedit){
                $this->assign('typeedit',1);
            }else if($menuUrl == $typedel){
                $this->assign('typedel',1);
            }else if($menuUrl == $delbag){
                $this->assign('delbag',1);
            }else if($menuUrl == $editbag){
                $this->assign('editbag',1);
            }

         }

        $this->assign('topmenu',$topmenu);
    }
    

}