<?php
/**
 * 优惠券控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;

class Coupontype extends Base{
    protected $msg = ['status'=>0,'msg'=>'操作失败'];//用于ajax返回的数据
    /**
     * 方法描述:优惠券类别列表
     * @return array 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit' => request()->get('limit'),
                'page' => request()->get('page'),
            ];
            $d['data'] = controller('coupontype','lib')->getList($c);
            $d['count'] = controller('coupontype','lib')->getTypeCount();
            $d['msg']   = '';
            $d['code']  = 0;
            return json($d);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'优惠券类别管理'
            ]
        ]);
        controller('coupon','controller')->getTopMenu();
        return $this->fetch();
    }
   
    /**
     * 方法描述:添加优惠券类别
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function add(){
        if(IS_POST && request()->isAjax()){
            $data = ['name' => request()->post('name'),
                //'create_time' => request()->post('minconsume'),
                    ];
            if($data['name']){
                $res = controller('coupontype','lib')->add($data);
                if($res){
                    action_log($data);      //写日志
                    $this->msg = ['status'=>1,'msg'=>'添加成功'];
                }else{
                    $this->msg = ['status'=>0,'msg'=>'添加失败'];
                }
            }

            return json($this->msg);
            
        }else{        
            return json(['status'=>0,'msg'=>'非法操作']);
        }
    }
    
    /**
     * 修改优惠券类别信息
     * @param string
     * @param string
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:36
     */
    public function edit(){
        
        if(IS_POST && request()->isAjax()){
            // 数据信息
            $data = [
                'id'    =>request()->post('id'),
                'name' => request()->post('name'),
            ];
            // 处理数据
            if($data['id']){
                $res = controller('coupontype','lib')->edit($data);
                if($res!==false){
                    action_log($data);      //写日志
                    $this->msg = ['status'=>1,'msg'=>'修改成功'];
                }else{
                    $this->msg = ['status'=>0,'msg'=>'修改失败'];
                }
            }
            return json($this->msg);
            
        }else{
            return json(['status'=>0,'msg'=>'无法获取您要修改的数据！']);
        }
    }
 
    /**
     * 方法描述: 删除优惠券类型，假删除
     * @param  int $id 优惠券类型的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id  = request()->post('id');
        $arr = db('c_coupon_type')->where('id',$id)->find();
        $res = controller('coupontype','lib')->del($id);
        if(!$res){
            return json($this->msg = ['status'=>0,'msg'=>'修改失败']);
        }
        action_log($arr);       //写日志
         return json($this->msg = ['status'=>1,'msg'=>'修改成功']);
    }

}