<?php
/**
 * 所有会员管理控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月22日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Db;
use PHPExcel_IOFactory;
use PHPExcel;
use app\vip\lib\RunExcelImport;
use think\Request;
use think\Session;
use think\model\Merge;

class Customer extends Base{
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'users';
    private $numZero = 0;
    private $numOne = 1;
    private $numTwo = 2;
    

    /*
     * 未注册会员的粉丝
     */
    public function notVipCustomer(){

        if(Request::instance()->isAjax()){
            /*
            $customerRes = sx_call('5c6a8c262b8e0',['brandclass_id'=>1],'sx_crm');
            if($customerRes['code'] == 200){
                $customer = $customerRes['data'];
            }
            //过滤掉vip的会员
            foreach($customer as $key => $val){
                if(in_array($vip,$val['customer_tel'])){
                    unset($customer[$key]);
                }
            }
            */

            $data = input('');
            $page = $data['page'] ? $data['page'] : 1;
            $limit = $data['limit'] ? $data['limit'] : 10;
            $offset = ($page - 1) * $limit;

            $vip = db('m_users_phone')->where('brandid',session('brandid'))->column('phone');

            $vipData = [];
            foreach($vip as $k => $v){
                $vipData[] = '"'.$v.'"';
            }

            $where = ' 1=1 ';
            //vip已有会员手机号
            if($vipData){
                $where .= ' and  b.contact not in ('.implode(',',$vipData).')';
            }

            //时间条件
            if($data['time_type']){
                if($data['start_time'])      $where .= ' and a.'.$data['time_type'].' >="'.$data['start_time'].'" ';
                if($data['end_time']){
                    $end_time = $data['end_time'];
                    $data['end_time'] = date("Y-m-d",strtotime("$end_time +1 day"));
                    $where .= ' and a.'.$data['time_type'].' <"'.$data['end_time'].'" ';
                }
            }

            //字段
            $field = 'a.id,a.customer_name,a.customer_sex,a.customer_tel,a.customer_wechat,a.customer_weibo,a.customer_qq,a.consulation_shop,a.customer_channel,a.consultation_type,a.is_valid,a.is_intostore,a.is_success,a.customer_type,a.dj_day,a.is_fp,a.dj_staff,a.sales_staff,a.last_trackday,a.brandclass,a.shop_name,a.add_shop_name';
            //sql
            $sql = 'select '.$field.' from c_customer_contact as b INNER JOIN c_customerinfo as a ON b.c_id = a.id  where '.$where.' limit '.$offset.','.$limit;
            $countSql = 'select COUNT(*) AS tp_count from c_customer_contact as b INNER JOIN c_customerinfo as a ON b.c_id = a.id  where '.$where;
            //跨库查询
            $customer = Db::connect('sx_crm')->query($sql);
            $count = Db::connect('sx_crm')->query($countSql);

            foreach($customer as $key => $val){
                switch($customer[$key]['is_valid']){
                    case 1:$customer[$key]['is_valid'] = '有效';
                        break;
                    case 2:$customer[$key]['is_valid'] = '待定';
                        break;
                    case 3:$customer[$key]['is_valid'] = '无效';
                        break;
                    case 4:$customer[$key]['is_valid'] = '驳回';
                        break;
                    case 5:$customer[$key]['is_valid'] = '反驳回';
                        break;
                }

                switch($customer[$key]['is_intostore']){
                    case 1:$customer[$key]['is_intostore'] = '未进店';
                        break;
                    case 2:$customer[$key]['is_intostore'] = '进店进客';
                        break;
                    case 3:$customer[$key]['is_intostore'] = '进店非进客';
                        break;
                    case 4:$customer[$key]['is_intostore'] = '邀约未进店';
                        break;
                    case 5:$customer[$key]['is_intostore'] = '进店未成交';
                        break;
                }

                switch($customer[$key]['is_success']){
                    case 1:$customer[$key]['is_success'] = '已成交';
                        break;
                    case 2:$customer[$key]['is_success'] = '未成交';
                        break;
                    case 3:$customer[$key]['is_success'] = '已定金';
                        break;
                    case 4:$customer[$key]['is_success'] = '本单作废';
                        break;
                }
            }

            return array('code'=>0,'data'=>$customer,'count'=>$count[0]['tp_count']);
        }else{


            //获取任务列表
            $res = controller('Ai','lib')->getTaskList();
            if($res['code'] == 200){
                $task = $res['data'];
            }

            $this->assign('task',$task);
            return view('notvipcustomer');
        }

    }

    /*
     * 获取配置信息及签名
     */
    public function getConfig(){
        $email = '1551954605@qq.com'; //系统设置
        $secretKey = '6d4958e4613a48caaab568f91c5bc886'; //系统设置
        $timestamp = time();
        $sign = sha1($email.'&'.$secretKey.'&'.$timestamp);

        return ['email'=>$email,'secretKey'=>$secretKey,'timestamp'=>$timestamp,'sign'=>$sign];
    }

    /*
     * 向AI外呼任务 导入客户信息
     */
    public function importCustomerToAi(){

        $data = input('');
        $outboundTaskId = (int)$data['outboundTaskId']; //任务id
        $customerData = $data['customerData'];    //客户信息
        $remark = $data['remark'];//备注

        $customerArray = [];
        foreach($customerData as $key => $val){
            $customerArray[] = [
                'name' =>$val['customer_name'],
                'mobile' =>$val['customer_tel'],
                'remark' =>$remark,
            ];
        }

        $res = controller('Ai','lib')->importCustomerToAi($customerArray,$outboundTaskId);

        return $res;

    }

    /*
     * 获取AI外呼任务列表接口
     */
    public function getTaskList(){

        $res = controller('Ai','lib')->getTaskList();
        print_r($res);die;
        return $res;

    }

}