<?php
/**
 * 评价问卷
 * User: zhaibaoming
 * Date: 2018/8/16 0016
 * Time: 21:06
 */

namespace app\vip\controller;

use app\index\controller\Base;

class Evaluationquestionnaire extends Base
{
    private $titleUpperLimit; // 题目上限
    private $answerUpperLimit; // 答案上限
    private $answerLowerLimit; // 答案下限
    private $editAddSign = 'add_';//修改页面 新增 标识符

    public function __construct()
    {
        parent::__construct();
        $limit = evaluate_limit();
        $this->titleUpperLimit = $limit['titleUpperLimit'];
        $this->answerUpperLimit = $limit['answerUpperLimit'];
        $this->answerLowerLimit = $limit['answerLowerLimit'];
    }

    public function index()
    {
        if (request()->isAjax()) {
            $data = model('McEvaluationQuestionnaire')->getBrandIdData($this->brandId);
            $list = evaluation_questionnaire_list();
            $questionnaireList = [];
            foreach ($list as $key => $val) {
                $flg = 0;
                foreach ($data as $k => $v) {
                    if ($v['type_id'] == $key) {
                        $flg = 1;
                        break;
                    }
                }
                $questionnaireList[$key]['type_id'] = $key;
                $questionnaireList[$key]['is_existence'] = $flg;
                $questionnaireList[$key]['evaluateName'] = $val;
            }
            $list['data'] = $questionnaireList;
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $this->assign([
                'headinfo'=>[
                    'title'=>'评价问卷'
                ]
            ]);
        return $this->fetch('Evaluationquestionnaire/index');
    }

    /**
     * 添加数据
     * @return mixed
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function add()
    {
        if (request()->isGet()) {
            $typeId = intval(input('get.typeid', 0));
            if ($typeId < 1) {
                $this->error('参数错误');
            }
            $this->assign('type_id', $typeId);
            $this->assign('titleUpperLimit', $this->titleUpperLimit);
            $this->assign('answerUpperLimit', $this->answerUpperLimit);
            return $this->fetch('Evaluationquestionnaire/add');
        }

        //接收数据
        $data = request()->post();
        //验证数据
        $res = $this->checkParam($data);
        if ($res['code'] != 200) {
            $this->error($res['msg']);
        }
        $res = $this->addData($res['data']);

        $resultData = ['code' => 0, 'msg' => 0,];
        if ($res) {
            $resultData['code'] = 200;
            return json($resultData);
            $this->success('提交成功!', url('vip/Evaluationquestionnaire/index'));
        }
        $resultData['msg'] = '提交失败';
        return json($resultData);
        $this->error('提交失败');
    }
    /**
     * 修改题目
     */
    public function edit()
    {
        if (request()->isGet()) {
            $typeId = intval(input('get.typeid', 0));
            if ($typeId < 1) {
                $this->error('参数错误');
            }
            $data['titleList'] = model('McEvaluationQuestionnaire')->getBrandIdTypeIdData($this->brandId, $typeId);
            $data['answerList'] = '';
            if (!empty($data['titleList'])) {
                foreach ($data['titleList'] as $k => $v) {
                    $data['answerList'][$k] = model('McEvaluationQuestionnaireAnswer')->getEqIdData($v['id']);
                    foreach ($data['answerList'][$k] as $kk => $vv) {
                        $data['answerList'][$k][$kk]['num'] = model('McEvaluationQuestionnaireUserAnswer')->getCount($vv['id']);
                    }
                }
            }
            $this->assign('editAddSign', $this->editAddSign);
            $this->assign('data', $data);
            $this->assign('type_id', $typeId);
            $this->assign('titleUpperLimit', $this->titleUpperLimit);
            $this->assign('answerUpperLimit', $this->answerUpperLimit);
            return $this->fetch('Evaluationquestionnaire/edit');
        }

        $data = request()->post();//dump($data);die;
        $res = $this->checkParam($data, 1);

        if ($res['code'] != 200) {
            $this->error($res['msg']);
        }
        $res = $this->editDbData($res['data']);
        $resultData = ['code' => 0, 'msg' => 0,];
        if ($res['code'] == 200) {
            $resultData['code'] = 200;
            return json($resultData);
            $this->success('修改成功!', url('vip/Evaluationquestionnaire/index'));
        }
        $resultData['msg'] = '修改失败';
        return json($resultData);
    }
    /**
     * 用户评价详情
     */
    public function userinfo(){

        //类型id 
        $typeid = input('typeid');
        $typeid = 1;

        if (request()->isAjax()) {
            //获取题目
            $data = model('McEvaluationQuestionnaire')->getBrandIdTypeIdData($this->brandId, $typeid);
            foreach ($data as $k => $v) {
                $data[$k]['create_time'] = date('Y-m-d H:i:s',$data[$k]['create_time']);
            }
            // $data['answerList'] = '';
            // if (!empty($data['titleList'])) {
            //     foreach ($data['titleList'] as $k => $v) {
            //         $data['answerList'][$k] = model('McEvaluationQuestionnaireAnswer')->getEqIdData($v['id']);
            //         foreach ($data['answerList'][$k] as $kk => $vv) {
            //             //答案选项总数
            //             $data['answerList'][$k][$kk]['num']  = model('McEvaluationQuestionnaireUserAnswer')->getCount($vv['id']);
            //             //答案选项人员
            //             $data['answerList'][$k][$kk]['data'] = model('McEvaluationQuestionnaireUserAnswer')->getUserData($vv['id']);
            //         }
            //     }
            // }
            $data['data'] = $data;
            $data['count'] = count($data);
            $data['msg']  = '';
            $data['code'] = 0;
            return json($data);
        }
        $this->assign('data',$data);
        return $this->fetch('Evaluationquestionnaire/userinfo');
    }
    /**
     * 获取答案数量
     */
    public function GetAnswer(){
        $id = input('id');
        $data = model('McEvaluationQuestionnaireAnswer')->getEqIdData($id);
        foreach ($data as $kk => $vv) {
            //答案选项总数
            $data[$kk]['num']  = model('McEvaluationQuestionnaireUserAnswer')->getCount($vv['id']);
            //答案选项人员
            $data[$kk]['data'] = model('McEvaluationQuestionnaireUserAnswer')->getUserData($vv['id']);
        }
        return json(['code'=>200,'msg'=>'success','data'=>$data]);
    }
    /**
     * 事物 修改数据
     * 取原数据 与 提交数据 比对  新增 修改 或删除
     * 删除 需要删除用户 评价的 2个表
     * @param $data
     * @return array
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function editDbData($data)
    {
        $model = model('McEvaluationQuestionnaire');
        $resultData = ['code' => 0];
        $Db = model('McEvaluationQuestionnaire');
        $Db->startTrans();
        $originalData = $model->getBrandIdTypeIdData($this->brandId, $data['type_id']);
        $res = $this->delOriginalData($originalData, $data);
        if ($res['code'] != 200) {
            $Db->rollback();
            $resultData['code'] = $res['code'];
            return $resultData;
        }
        foreach ($data['title'] as $key => $val) {
            $list['title'] = $val;
            $list['brand_id'] = $this->brandId;
            $list['type_id'] = $data['type_id'];
            $list['sort'] = $data['sort'][$key];
            $list['id'] = $key;
            $flg = 0;
            foreach ($originalData as $k => $v) {
                if ($key == $v['id']) {
                    $flg = 1;
                    //修改
                    $res = $model->editData($list, $val);
                    $id = $res === false ? 0 : $key;
                    break;
                }
            }
            if ($flg === 0) {
                //新增
                $id = model('McEvaluationQuestionnaire')->addData($list);
            }
            if ($id < 1) {
                $Db->rollback();
                $resultData['code'] = '30' . $key;
                return $resultData;
            }
            $originalAnswerData = model('McEvaluationQuestionnaireAnswer')->getBrandIdTypeIdData($id);
            $res = $this->delAnswerOriginalData($originalAnswerData, $data["answer"][$key]);
            if ($res['code'] != 200) {
                $Db->rollback();
                $resultData['code'] = $res['code'];
                return $resultData;
            }
            $param = [];
            foreach ($data["answer"][$key] as $k => $v) {
                $param[$k]['eq_id'] = $id;
                $param[$k]['text'] = $v;
                $flg = 0;
                foreach ($originalAnswerData as $ks => $vs) {
                    if ($k == $vs['id']) {
                        //修改
                        $res = model('McEvaluationQuestionnaireAnswer')->getEQidEdit($k, $v);
                        if ($res === false) {
                            $Db->rollback();
                            $resultData['code'] = '44440' . $key;
                            return $resultData;
                        }
                        $flg = 1;
                        break;
                    }
                }
                $param['eq_id'] = $id;
                $param['text'] = $v;
                if ($flg === 0) {
                    $res = model('McEvaluationQuestionnaireAnswer')->addData($param);
                    if (empty($res)) {
                        $Db->rollback();
                        $resultData['code'] = '40' . $key;
                        return $resultData;
                    }
                }
            }
        }

        $Db->commit();
        $resultData['code'] = 200;
        return $resultData;
    }

    /**
     * 删除答案原始数据
     */
    private function delAnswerOriginalData($originalData, $data)
    {
        $resultData = ['code' => 0,];
        foreach ($originalData as $key => $val) {
            $flg = 0;
            foreach ($data as $k => $v) {
                if ($val['id'] == $k) {
                    $flg = 1;
                    break;
                }
            }

            if ($flg === 1) {
                continue;
            }
            $res = $this->delData($val['id']);

            if ($res['code'] != 200) {
                $resultData['code'] = $res['code'];
                return $resultData;
            }
        }

        $resultData['code'] = 200;
        return $resultData;
    }


    /**
     * 根据 eqid 删除相应数据
     * @param $id
     * @return mixed
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function delData($id)
    {
        //删除 答案表
        $res = model('McEvaluationQuestionnaireAnswer')->getEQidDel($id);
        if ($res === false) {
            $resultData['code'] = 8882;
            return $resultData;
        }
        //删除 用户 答案表
        $res = model('McEvaluationQuestionnaireUserAnswer')->getEQidDel($id);
        if ($res === false) {
            $resultData['code'] = 8884;
            return $resultData;
        }

        $resultData['code'] = 200;
        return $resultData;
    }

    private function delAnswerData($eqidList, $answerLit)
    {
        $data = model('McEvaluationQuestionnaireAnswer')->getEqIdInData(implode(',', $eqidList));
        $list = [];
        foreach ($answerLit as $val) {
            foreach ($val as $k => $v) {
                $list[$k] = $v;
            }
        }

        foreach ($data as $key => $val) {
            $flg = 1;
            foreach ($list as $k => $v) {
                if ($val['id'] == $k) {
                    $flg = 0;
                    break;
                }
            }
            if ($flg === 0) {
                continue;
            }
            //删除 答案表
            $res = model('McEvaluationQuestionnaireAnswer')->del($val['id']);
            if ($res === false) {
                $resultData['code'] = 8885;
                return $resultData;
            }
            //删除 用户 答案表
            $res = model('McEvaluationQuestionnaireUserAnswer')->getEQaidDel($val['id']);
            if ($res === false) {
                $resultData['code'] = 8886;
                return $resultData;
            }
        }
        $resultData['code'] = 200;
        return $resultData;
    }

    /**
     * 删除原始数据
     */
    private function delOriginalData($originalData, $data)
    {
        $resultData = ['code' => 0,];
        $flag = 0;
        $list = [];
        foreach ($originalData as $key => $val) {
            $flg = 0;
            if (empty($data['title'])) {
                $flg = 1;
            } else {
                foreach ($data['title'] as $k => $v) {
                    if ($val['id'] == $k) {
                        $flg = 0;
                        break;
                    }
                    $flg = 1;
                }
            }

            if ($flg === 1) {
                //删除 评价表
                $res = model('McEvaluationQuestionnaire')->del($val['id']);
                if ($res === false) {
                    $resultData['code'] = 8881;
                    return $resultData;
                }

                $res = $this->delData($val['id']);

                if ($res['code'] != 200) {
                    $resultData['code'] = $res['code'];
                    return $resultData;
                }
            } else {
                $list[] = $val['id'];
            }
        }

        if (empty($list)) {
            $resultData['code'] = 200;
            return $resultData;
        }
        $res = $this->delAnswerData($list, $data['answer']);
        $resultData['code'] = $res['code'];
        return $resultData;
    }

    /**
     * 事物 添加数据
     * @param $data
     * @return array
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function addData($data)
    {

        $resultData = ['code' => 0];
        $Db = model('McEvaluationQuestionnaire');
        $Db->startTrans();
        foreach ($data['title'] as $key => $val) {
            $list['title'] = $val;
            $list['brand_id'] = $this->brandId;
            $list['type_id'] = $data['type_id'];
            $list['sort'] = $data['sort'][$key];
            $id = model('McEvaluationQuestionnaire')->addData($list);
            if ($id < 1) {
                $Db->rollback();
                $resultData['code'] = '30' . $key;
                return $resultData;
            }
            $param = [];
            foreach ($data["answer"][$key] as $k => $v) {
                $param[$k]['eq_id'] = $id;
                $param[$k]['text'] = $v;
            }
            $res = model('McEvaluationQuestionnaireAnswer')->addAllData($param);
            if (empty($res)) {
                $Db->rollback();
                $resultData['code'] = '40' . $key;
                return $resultData;
            }
        }

        $Db->commit();
        $resultData['code'] = 200;
        return $resultData;
    }

    /**
     * 验证数据
     * @param $param
     * @return array
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function checkParam($param, $type = 0)
    {
        $resutlData = ['code' => 0, 'msg' => '', 'data' => ''];

        if ($type === 0) {
            $res = model('McEvaluationQuestionnaire')->getBrandIdTypeIdData($this->brandId, $param['type_id']);
            if (!empty($res)) {
                $resutlData['code'] = '1001';
                $resutlData['msg'] = '当前类型已有数据,请进行修改或删除操作';
                return $resutlData;
            }
        }

        if (intval($param['type_id']) < 1) {
            $resutlData['code'] = '901';
            $resutlData['msg'] = '参数错误_1';
            return $resutlData;
        }

        for ($i = 1; $i <= $this->titleUpperLimit; $i++) {
            if (empty($param['title_' . $i])) {
                continue;
            }
            $data = [];
            if (mb_strlen($param['title_' . $i], 'utf-8') > 50) {
                $resutlData['code'] = '30' . $i;
                $resutlData['msg'] = '题目' . $i . '不能大于50个字';
                return $resutlData;
            }

            if ($type === 1 && $param['title_' . $i . '_id'] < 1 && strpos($param['title_' . $i . '_id'], $this->editAddSign) !== 0) {
                $resutlData['code'] = '450' . $i;
                $resutlData['msg'] = '参数__' . $i . '__错误';
                return $resutlData;
            }

            if (intval($param['sort_' . $i]) < 1 || intval($param['sort_' . $i]) > 100000000) {
               /* $resutlData['code'] = '820' . $i;
                $resutlData['msg'] = '排序' . $param['sort_' . $i] . '错误';
                return $resutlData;*/
                $param['sort_' . $i] = 100;
            }

            foreach ($param['answer_' . $i] as $k => $v) {
                if (empty($v)) {
                    continue;
                }
                if (mb_strlen($v, 'utf-8') > 30) {
                    $resutlData['code'] = '40' . $i;
                    $resutlData['msg'] = '题目' . $i . ',答案' . ++$k . '不能大于30个字';
                    return $resutlData;
                }
                if ($type === 1) {
                    if ($param['answer_' . $i . '_id'][$k] < 1 && strpos($param['answer_' . $i . '_id'][$k], $this->editAddSign) !== 0) {
                        $resutlData['code'] = '46' . $i;
                        $resutlData['msg'] = '题目' . $i . ',答案' . ++$k . '参数错误';
                        return $resutlData;

                    }
                    $data[$param['answer_' . $i . '_id'][$k]] = trim($v);
                } else {
                    $data[] = trim($v);
                }
            }
            $len = count($data);
            if ($len < $this->answerLowerLimit) {
                $resutlData['code'] = '50' . $i;
                $resutlData['msg'] = '题目' . $i . ',答案不能小于' . $this->answerLowerLimit . '个';
                return $resutlData;
            }

            if ($len > $this->answerUpperLimit) {
                $resutlData['code'] = '60' . $i;
                $resutlData['msg'] = '题目' . $i . ',答案不能大于' . $this->answerUpperLimit . '个';
                return $resutlData;
            }
            $page = $type === 1 ? $param['title_' . $i . '_id'] : $i;
            $resutlData['data']['title'][$page] = $param['title_' . $i];
            $resutlData['data']['answer'][$page] = $data;
            $resutlData['data']['sort'][$page] = $param['sort_' . $i];
        }
        $resutlData['data']['type_id'] = $param['type_id'];
        $resutlData['code'] = 200;
        return $resutlData;
    }

    /**
     * 删除
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function del()
    {
        $typeId = intval(input('post.id', 0));
        $resutlData = ['code' => 0, 'msg' => '',];
        if ($typeId < 1) {
            $resutlData['msg'] = '参数错误';
            return json($resutlData);
        }

        $Db = model('vip/McEvaluationQuestionnaire');
        $answerDb = model('vip/McEvaluationQuestionnaireAnswer');
        $answerUserDb = model('vip/McEvaluationQuestionnaireUserAnswer');
        $questionnaireList = $Db->getBrandIdTypeIdData($this->brandId, $typeId);
        if (empty($questionnaireList)) {
            $resutlData['code'] = 200;
            return json($resutlData);
        }
        $Db->startTrans();
        //删问卷表
        $res = $Db->obtainTypeIdDel($typeId, $this->brandId);
        if ($res === false) {
            $Db->rollback();
            $resutlData['code'] = '301';
            return json($resutlData);
        }

        foreach ($questionnaireList as $v) {
            //删答案表
            $res = $answerDb->getEQidDel($v['id']);
            if ($res === false) {
                $Db->rollback();
                $resutlData['code'] = '401_' . $v['id'];
                return json($resutlData);
            }

            //删用户答案表
            $res = $answerUserDb->getEQidDel($v['id']);
            if ($res === false) {
                $Db->rollback();
                $resutlData['code'] = '501_' . $v['id'];
                return json($resutlData);
            }
        }

        $Db->commit();
        $resutlData['code'] = 200;
        return json($resutlData);
    }
}