<?php
/**
 * 客片大少
 * User: Wangyining<Wangyining@suxuantech.cn>
 * Date: 2019/04/22
 */
namespace app\vip\controller;
use app\index\controller\Base;

class Gift extends Base{
	protected $libname = 'Gift';

    /*
     *  后台 店面列表
     */
    public function giftList(){

        if(request()->isAjax()){
            $params = input();
            $limit    = $params['limit']?$params['limit']:10;
            $page  = $params['page']?$params['page']:1;

            $data = db('m_gift')->where(['brand_id'=>session('brandid')])->page($page,$limit)->select();
            $count= db('m_gift')->where(['brand_id'=>session('brandid')])->count();

            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }
        $this->getTopMenu();
        $this->assign([
            'headinfo'=>[
                'title'=>'礼物列表'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 礼物添加
     * @return [type] [description]
     */
    public function giftAdd(){
        if(request()->isAjax()){

            $params = request()->post();

            $data = [

                'img'      => $params['img'],
                'name'     => trim($params['name']),
                'money'    => trim($params['money']),
                'score'    => trim($params['score']),
                'brand_id' => $this->brandId,
                'sort'     => $params['sort']?$params['sort']:99,
                'add_time' => date("Y-m-d H:i:s",time()),
                'add_staff'=> session('staffname'),
            ];

            $res = db('m_gift')->insert($data);
            if($res){
                return ['code'=>200,'msg'=>'添加成功'];
            }else{
                return ['code'=>202,'msg'=>'添加失败'];
            }

        }

        return $this->fetch();
    }

    /*
     * 礼物修改
     */
    public function giftEdit(){
        if(request()->isAjax()){

            $params = request()->post();

            $id = $params['id'];
            if(!$id){
                return ['code'=>201,'msg'=>'未获取到id'];
            }

            $data = [
                'img'      => $params['img'],
                'name'     => trim($params['name']),
                'money'    => trim($params['money']),
                'score'    => trim($params['score']),
                'brand_id' => $this->brandId,
                'sort'     => $params['sort']?$params['sort']:99,
                'add_time' => date("Y-m-d H:i:s",time()),
                'add_staff'=> session('staffname'),
            ];

            $data = db('m_gift')->where('id',$id)->update($data);
            if($data!==false){
                return ['code'=>200,'msg'=>'添加成功'];
            }else{
                return ['code'=>202,'msg'=>'添加失败'];
            }

        }

        $id   = input('id');

        $data = db('m_gift')->where('id',$id)->find();

        $this->assign(['id'=>$id,'data'=>$data]);

        return $this->fetch();
    }

    /*
     * 礼物删除
     */
    public function giftDel(){
        $id = input('id');
        $res = db('m_gift')->where('id',$id)->delete();
        if($res !== false){
            return json(['code'=>200,'msg'=>'删除成功']);
        }else{
            return json(['code'=>202,'msg'=>'删除失败']);
        }
    }

    /*
     * 礼物购买记录
     */
    public function giftBuyList(){

        $id = input('id');
        $getGift = db('m_order_gift')
            ->where('gift.pay_time is not null')
            ->where('gift.gift_id',$id)
            ->alias('gift')
            ->join('m_users user','gift.give_userid = user.id','left')
            ->field('gift.*,user.username,user.simg')
            ->order('gift.add_time desc')
            ->select();
            //print_r($getGift);die;
        $this->assign('data',$getGift);
        return $this->fetch();

    }


    /*
     * 获取用户可使用的页面顶部菜单和操作选项的设置
     */
    public function getTopMenu(){
        $menuList = getAuth('auth');

        $shop_list = '/vip/gift/giftlist';
        $shop_add  = '/vip/gift/giftadd';
        $shop_edit = '/vip/gift/giftedit';
        $shop_del = '/vip/gift/giftdel';
        $buy_list = '/vip/gift/giftbuylist';

        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($currentUrl == $shop_list){
                if($menuUrl == $shop_add){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$shop_add.'">添加礼物</a></div>';
                    $this->assign('add',1);
                }elseif($menuUrl == $shop_edit){
                    $this->assign('edit',1);
                }elseif($menuUrl == $shop_del){
                    $this->assign('del',1);
                }elseif($menuUrl == $buy_list){
                    $this->assign('buy_list',1);
                }
            }
        }

        $this->assign('topmenu',$topmenu);
    }
}