<?php
/**
 * 用户等级设置控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Request;

class Level extends Base{
    protected $msg = ['status'=>0,'msg'=>'操作失败'];//用于ajax返回的数据
    protected $libname = 'level';
    protected $imgWH   = [400,250];
    /**
     * 方法描述     级别列表
     * @return array 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $params = input();
            $res = controller($this->libname,'lib')->getLevelData($params);

            return json($res);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'会员级别管理'
            ],
            'imgsize'=>$this->imgWH
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
   
    /**
     * 方法描述    添加
     * @return mixed
     * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月11日
     */
    public function add(){

        if(IS_POST && request()->isAjax()){
            $fileimg = request()->file("img");
            $upimg = false;
            if($fileimg){
                $upimg  = saveImg($fileimg,$this->imgWH[0],$this->imgWH[1]);
            }
            $data = [
                'name' => request()->post('name'),
                'min_once_pay' => (int)request()->post('min_once_pay'),//一次性消费最低
                'max_once_pay' => (int)request()->post('max_once_pay'),//一次性消费最高
                'total_pay' => (int)request()->post('total_pay'),//累计消费
                'deduct_score' => (int)request()->post('deduct_score'),//抵扣积分
                'img'         => $upimg,
                'discount' => request()->post('discount'),//折扣
                'create_time' => date('Y-m-d H:i:s',time()),
            ];


            $has = db('user_level')->where('min_once_pay',$data['min_once_pay'])->whereOr('total_pay',$data['total_pay'])->find();

            if(!$has){
                $res = controller($this->libname,'lib')->add($data);
                if($res){
                    action_log($data);          //写日志
                    $this->msg = ['status'=>1,'msg'=>'添加成功'];
                }else{
                    $this->msg = ['status'=>0,'msg'=>'添加失败'];
                }
            }else{
                $this->msg = ['status'=>0,'msg'=>'已存在一次性消费最低为：'.$data['min_once_pay'].'或累计消费为'.$data['total_pay'].' 的会员级别了'];
            }

        }else{
            $this->msg = ['status'=>0,'msg'=>'请求失败'];
        }

        return $this->msg;
    }
    
    /**
     * 修改信息
     * @return mixed
     * @author Wangyining<Wangyining@suxuantech.cn>
     */
    public function edit(){
        if(IS_POST && request()->isAjax()){

            // 数据信息
            $data = [
                'id'    => request()->post('id'),
                'name' => request()->post('name'),
                'min_once_pay' => (int)request()->post('min_once_pay'),//一次性消费最低
                'max_once_pay' => (int)request()->post('max_once_pay'),//一次性消费最高
                'total_pay' => (int)request()->post('total_pay'),//累计消费
                'deduct_score' => (int)request()->post('deduct_score'),//抵扣积分
                'discount' => request()->post('discount'),//折扣
                'create_time' => date('Y-m-d H:i:s',time()),
            ];

            $fileimg = request()->file("img");
            if($fileimg){
                $data['img'] = saveImg($fileimg,$this->imgWH[0],$this->imgWH[1]);
            }

            //检测是否重复
            $has = db('user_level')->where('min_once_pay',$data['min_once_pay'])->whereOr('total_pay',$data['total_pay'])->find();

            if($has && $has['id']!=$data['id']){

                $this->msg = ['status'=>0,'msg'=>'已存在一次性消费最低为：'.$data['min_once_pay'].'或累计消费为'.$data['total_pay'].' 的会员级别了'];
                return $this->msg;
            }

            $res = controller($this->libname,'lib')->edit($data);
            if($res!==false){
                action_log($data);
                $this->msg = ['status'=>1,'msg'=>'修改成功'];
            }else{
                $this->msg = ['status'=>0,'msg'=>'修改失败'];
            }

            return $this->msg;
            
        }else{
            $this->msg = ['status'=>0,'msg'=>'请求失败'];

            return $this->msg;
        }
    }
 
    /**
     * 方法描述: 删除类型，假删除
     * @param  int $id 数据的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id  = request()->post('id');
        $res = controller($this->libname,'lib')->del($id);
        if(!$res){
            return json($this->msg = ['status'=>0,'msg'=>'修改失败']);
        }
         return json($this->msg = ['status'=>1,'msg'=>'修改成功']);
    }

    /**
     * 方法描述    设置成长值规则
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午3:55:44
     */
    public function setGrowthRule(){
        if(IS_POST && request()->isAjax()){
            $postdata = request()->post();
            $detail = [
                'erveryday_sign'=> (int)$postdata['erveryday_sign'],
                'everyday_land' => (int)$postdata['everyday_land'],
                'view_activity' => (int)$postdata['view_activity'],
                'receive_task'  => (int)$postdata['receive_task'],
                'do_task'       => (int)$postdata['do_task'],
                'share'         => (int)$postdata['share'],
                'recommend'     => (int)$postdata['recommend'],
                'activity_sign' => (int)$postdata['activity_sign'],
            ];
            if(!$postdata['levelid']){
                return json(['status'=>0,'msg'=>'添加失败,无法获取您要设置的级别id']);
            }
            if($postdata['id']){
                $data['id']     = $postdata['id'];
            }
            if($postdata['id']){
                $data['id']     = $postdata['id'];
            }

            $data['levelid']= $postdata['levelid'];
            $data['detail'] = json_encode($detail);
            $data['create_time'] = date('Y-m-d H:i:s',time());
            $data['create_user'] = $this->staffName;
            $res = controller($this->libname,'lib')->setGrowthRule($data);
            if($res){
                $this->msg = ['status'=>1,'msg'=>'添加成功'];
            }else{
                $this->msg = ['status'=>0,'msg'=>'添加失败'];
            }
            
            return json($this->msg);
        }else{
            $id  = (int)input('get.levelid');
            $res = controller($this->libname,'lib')->getOne($id);
            $this->assign([
                'headinfo'=>[
                    'title'=>'成长值设置管理'
                ]
            ]);
            $this->assign('data',$res);
            return $this->fetch();
        }
    }


    //聚光圈 99会员权益
    public function vipCoupon(){

        if(Request::instance()->isPost()){

            $data = input("post.");
            $id       = $data['id'];

            //优惠券和张数
            $couponData = [];
            foreach($data['couponid'] as $k => $v){
                $couponData[] = ['couponid'=>$v,'num'=>$data['num'][$v]];
            }
            $cid = json_encode($couponData);

            $array = [
                'price' =>$data['price'],
                'coupon_data'  => $cid,
                'brand_id'     => $this->brandId,
                'create_time'  => date('Y-m-d H:i:s'),
                'create_staff_id'   => session('staff_id'),
                'create_staff_name' => session('staffname'),
            ];

            if($id){
                $res = db('jgq_vip_coupon')->where('id',$id)->update($array);
            }else{
                $res = db('jgq_vip_coupon')->insert($array);
            }

            if($res !== false){
                $array['id'] = $data['id'];
                action_log($array);      //写日志
                $this->msg = ['code'=>200,'msg'=>'修改成功'];
            }else{
                $this->msg = ['code'=>202,'msg'=>'修改失败'];
            }
            return json($this->msg);

        }else{


            $brand_id = $this->brandId;
            $detail = db('jgq_vip_coupon')->where('brand_id',$brand_id)->find();

            if($detail&&$detail['coupon_data']){
                $cid = json_decode($detail['coupon_data'],true);
                $coupon_id = array_column($cid,'couponid');

                $num = [];
                foreach($cid as $k => $v){
                    $num[$v['couponid']] = $v['num'];
                }
            }

            //$couponlist = controller('coupon','lib')->getList('','all');
            $couponlist = db('c_coupon_num')->where(["brandid"=>$this->brandId,'end_time'=>['>=',date('Y-m-d H:i:s')]])->select();


            $this->assign(['detail'=>$detail,'cid'=>$cid,'coupon_id'=>$coupon_id,'num'=>$num]);
            $this->assign('couponlist',$couponlist);
            $this->getTopMenu();
            return view('vipcoupon');

        }

    }



    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
        $menuList   = getAuth();

        //print_r($menuList);
        
        $level      = '/vip/level/index';
        $levelEdit  = '/vip/level/edit';
        $levelAdd   = '/vip/level/add';
        $levelDel   = '/vip/level/del';
        // 积分规则 和 成长值规则
        $sorerule       = '/vip/scorerule/index';
        $editScorerule  = '/vip/scorerule/edit';
        $editGrowthrule = '/vip/level/setgrowthrule';
        $makecardRule   = '/vip/scorerule/setcardnumrule';
        $moneyRule = '/vip/scorerule/moneyrule';
        // 权益管理
        $memberq      = '/vip/memberq/index';
        $memberqAdd   = '/vip/memberq/add';
        $memberqEdit  = '/vip/memberq/edit';
        $memberqDel   = '/vip/memberq/del';

        //99会员权益
        $vip_coupon = '/vip/level/vipCoupon';


        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);

            if($menuUrl == $level){
                $class = '';
                if($level == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$level.'">用户级别管理</a></div>';
            }else if($menuUrl == $sorerule){
                //$topmenu .= '<div class="layui-btn" ><a href="'.$sorerule.'">积分规则管理</a></div>';
            }else if($menuUrl == $memberq){
                $class = '';
                if($memberq == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$memberq.'">会员权益管理</a></div>';
            }else if($menuUrl == $makecardRule){
                $class = '';
                if($makecardRule == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$makecardRule.'">会员卡生成规则管理</a></div>';
            }else if($menuUrl == $levelDel){
                $this->assign('leveldel',1);
            }else if($menuUrl == $levelEdit){
                $this->assign('aleveledit',1);
            }else if($menuUrl == $levelAdd){
               if($currentUrl==$level){
                    $topmenu .= '<div class="layui-btn  layui-btn-warm" lay-event="addlevelbtn" id="addlevelbtn"><i class="layui-icon">&#xe654;</i>新增用户级别</div>';
               }
            }else if($menuUrl == $memberqAdd){
                if($currentUrl == $memberq || $currentUrl == $memberqAdd || $currentUrl == $memberqEdit ){
                   $topmenu .= '<div class="layui-btn layui-btn-warm" lay-event="addcardbtn" ><a href="'.$memberqAdd.'"><i class="layui-icon">&#xe654;</i>添加会员权益</a></div>
                ';
                }
                $this->assign('memberqadd',1);
            }else if($menuUrl == $memberqEdit){
                $this->assign('memberqedit',1);
            }else if($menuUrl == $memberqDel){
                $this->assign('memberqdel',1);
            }else if($menuUrl == $editGrowthrule){
                $this->assign('editgrowthrule',1);
            }else if($menuUrl == $editScorerule){
                $this->assign('editscorerule',1);
            }else if($menuUrl == $vip_coupon){

                $class = '';
                if($vip_coupon == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'" ><a href="'.$vip_coupon.'">99会员权益设定</a></div>';
            }

        }

        $this->assign('topmenu',$topmenu);
    }
    
}