<?php
/**
 * 任务控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\TTaskList;
use think\Controller;
use think\Model;

class Memtask extends Base{
    /**
     * 会员任务展示页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memList () {
        $taskData = TTaskList::select();
        $this->assign('taskData',$taskData);
        return view('task_list');
    }
    /**
     * 会员任务添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memTaskAdd () {
        return view('task_add');
    }

    /**
     * 会员任务添加数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memTaskAddAll () {
        $datas = array(
            'title' => request()->post('title'),
            'index_img' => $this->imgDispose(),
            'task_typeid' => request()->post('task_typeid'),
            'reward_score' => request()->post('reward_score'),
            'share_score' => request()->post('share_score'),
            'days' => request()->post('days'),
            'scontent' => request()->post('scontent'),
            'content' => request()->post('content'),
            'create_time' => date('Y-m-d,H:i:s',time()),
        );
        $result = TTaskList::insert($datas);
        if ($result) {
            return $this->apiReturn();
        } else {
            return $this->apiError('任务信息添加失败',204);
        }

    }
    /**
     * 会员任务修改页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memTaskUp () {
        $id = input('get.id');
        $taskData = TTaskList::selectDa($id);
        $this->assign('taskData',$taskData);
        return view('task_update');
    }

    /**
     * 会员任务修改数据
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memTaskUpAll () {

        $id = input('post.id');
        $title = input('post.title');
        $card_img = $this->imgDispose();
        $task_typeid = input('post.task_typeid');
        $reward_score = input('post.reward_score');
        $share_score = input('post.share_score');
        $days = input('post.days');
        $scontent = input('post.scontent');
        $content = input('post.content');
        $result  = TTaskList::updates($id,$title,$card_img,$task_typeid,$reward_score,$share_score,$days,$scontent,$content);
        if ($result) {
            return $this->apiReturn();
        } else {
            return $this->apiError('任务信息修改失败',204);
        }
    }
    /**
     * 会员任务删除
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function delete () {
        $id = input('get.id');
        $result = TTaskList::delete($id);
        if ($result) {
            return $this->apiReturn();
        } else {
            return $this->apiError('删除信息失败',205);
        }
    }
    /**
     * 会员任务图像数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function imgDispose () {
        $file = request()->file('image');
        $info = $file->validate(['size'=>15678,'ext'=>'jpg,png,gif'])->move(ROOT_PATH . 'public' . DS . 'uploads');
        if ($info) {
            $img = $info->getExtension();
        } else {
            echo $file->getError();
        }
        return $img;
    }
    /**
     * 会员列表页搜索数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function searchs () {
        $title = input('post.title');
        $searchData = TTaskList::search($title);
        $this->assign('list',$searchData);
        return view('searchs');
    }
    /**
     * 会员任务执行详情记录
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function taskDetails () {
        $taskId = input('post.taskid');
        $data = TTaskList::taskDetails($taskId);
        $sum = TTaskList::taskNeck($taskId);
        //返回查询信息待处理
        $this->assign('sum',$sum);
        $this->assign('memdata',$data);
        return view('taskDetails');
    }
    /**
     * 会员个人执行记录
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function MemOneTask () {
        $taskId = input('post.taskid');
        $userId = input('post.userid');
        $memData = TTaskList::memTask($taskId,$userId);
        $this->assign('memdata',$memData);
        return view('mem_task');
    }
}
