<?php
/**
 * 会员卡控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\controller;
use app\index\controller\Base;
use think\Controller;
use app\vip\model\CCardType;
use think\Session;

class Memcard extends Base{

    /**
     * 会员卡展示页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function cardList () {
        $cardData = $cardData = db('c_card_type')->where('brandid','=',$this->brandId)->paginate(2);
        $this->assign('carddata',$cardData);
        $this->assign([
            'headinfo'=>[
                'title'=>'会员卡管理'
            ]
        ]);
        return view('list');
    }


    /**
     * 会员卡添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function cardAdd () {
        $this->assign([
            'headinfo'=>[
                'title'=>'添加新会员卡'
            ]
        ]);
        return view('cardadd');
    }

    /**
     * 会员卡添加数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function cardAddAll () {
        $file = request()->file('image');
        $info = $file->validate(['size'=>15678,'ext'=>'jpg,png,gif'])->move(ROOT_PATH . 'public' . DS . 'uploads');
        if ($info) {
            $img = $info->getExtension();
        } else {
            echo $file->getError();
        }
        $data = array(
            'card_name' => request()->post('card_name'),
            'card_img' => $img,
            'business_name'=> Session::get('business_name'),
            'status' => request()->post('status'),
            'price' => request()->post('price'),
            'card_prefix' => request()->post('card_prefix'),
            'discount' => request()->post('discount'),
            'card_description' => request()->post('card_description'),
            'create_time' => date('y-m-d,H-i-s',time()),
            'card_balance' => request()->post('card_balance'),
            'off_time' => request()->post('off_time'),
            'order_num' => request()->post('order_num'),
            'brandid' => $this->brandId,
        );
        $res = CCardType::insert($data);
        if ($res) {
//            $this->apiReturn($data);
            $jsonDate = array(
                'status' => 1,
                'success'=>'添加成功'
            );
            return json_encode($jsonDate);
        } else {
            $jsonDate = array(
                'status' => 0,
                'success'=>'添加失败'
            );
            return json_encode($jsonDate);
        }
    }

    /**
     * 会员卡删除据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function delete () {
        $id = input('get.id');
        $res = CCardType::delete($id);
        return $res;
    }
    /**
     * 会员卡修改页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function updates () {
        $id = input('get.id');
        $cardData = CCardType::selectOne($id);
        $this->assign('carddata',$cardData);
        $this->assign([
            'headinfo'=>[
                'title'=>'修改会员卡信息'
            ]
        ]);
        return view('updates');
    }
    /**
     * 会员卡修改处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function updateAll () {
        $file = request()->file('image');
        $info = $file->validate(['size'=>15678,'ext'=>'jpg,png,gif'])->move(ROOT_PATH . 'public' . DS . 'uploads');
        if ($info) {
            $img = $info->getExtension();
        } else {
            echo $file->getError();
        }
        $id = input('post.id');
        $card_name = input('post.card_name');
        $card_img = $img;
        $status = input('post.status');
        $card_prefix = input('post.card_prefix');
        $price = input('post.price');
        $discount = input('post.discount');
        $card_description = input('post.card_description');
        $update_time = date('y-m-d,H-i-s',time());
        $card_balance = input('post.card_balance');
        $off_time = input('post.off_time');
        $order_num = input('post.order_num');
        $res = CCardType::updates($id,$card_name,$status,$price,$discount,$card_description,$card_balance,$order_num,$update_time,$off_time,$card_img,$card_prefix);
        if ($res) {
            $array =array(
                'status' => 1,
                'msg' => '修改成功'
            );
            return json_encode($array);
        }else{
            $array =array(
                'status' => 1,
                'msg' => '修改失败'
            );
            return json_encode($array);
        }
    }
    /**
     * 会员卡兑消记录页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function record () {
        $recordData = CCardType::record();
        $this->assign('date',$recordData);
        $this->assign([
            'headinfo'=>[
                'title'=>'会员卡兑消记录管理'
            ]
        ]);
        return view('record');
    }
    /**
     * 会员等级添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function add () {
        return view('add');
    }
    /**
     * 会员等级添加数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function addAll () {
        $gradeData = input('post.');
        $res = CCardType::graAdd($gradeData);
        if ($res) {
            $array = array(
                'status' => 1,
                'msg' => '添加成功',
            );
            return json_encode($array);
        } else {
            $array = array(
                'status' => 0,
                'msg' => '添加失败',
            );
            return json_encode($array);
        }
    }
    /**
     * 会员等级展示页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function graList () {
        $graData = CCardType::graSelect();
        $this->assign('graData',$graData);
        return view('gralist');
    }

    /**
     * 会员权益展示页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function equity () {
        $memEq = CCardType::equity();
        $this->assign('memEq',$memEq);
        return view('equity');
    }
    /**
     * 会员权益添加页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function equityAdd () {
        return view('equityadd');
    }
    /**
     * 会员权益添加数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function equityAddAll () {
        $data = array(
            'eq_type' => request()->post('eq_type'),
            'eq_count' => request()->post('eq_count')
        );
        $res = CCardType::eqAll($data);
        if ($res) {
            $array = array(
                'code' => 1,
                'msg' => '添加成功',
            );
            return json_encode($array);
        } else {
            $array = array(
                'code' => 0,
                'msg' => '添加失败',
            );
            return json_encode($array);
        }
    }
}