<?php
/**
 * 套系管理
 * User: 李龙
 * Date: 2018/10/16
 * Time: 
 */

namespace app\vip\controller;

use app\index\controller\Base;
use think\image\Exception;
use think\Session;
use think\Request;

class Package extends Base {
    public function __construct(){
        parent::__construct();
        $this->assign('controller', request()->controller());
    }

    // 套系列表首页
    public function index(){

        // 查看显示权限
        $this->getTopMenu();

        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');

            $param['page']    = isset($page) ? ($page - 1) * $limit : 0;
            $param['limit']   = isset($limit) ? $limit : 10;
            $param['brand_id']= (int)$this->brandId;
            $param['shop_code'] = input('shop_code');
            $param['package_name'] = input('package_name');

            $data = controller('Package', 'model')->getLimit($param);

            foreach ($data as $k => $v) {
                $list['data'][] = $v;
                $list['data'][$k]['title'] = base64_decode($v['title']);
            }
            $list['data'] = $data;
            $list['count']= controller('Package', 'model')->getCount($param);
            $list['msg']  = '';
            $list['code'] = 0;
            return json($list);
        }

        $shop = controller('vip/Package', 'lib')->getShopList(['brand_id'=>$this->brandId]);

        $headinfo['title'] = '套系列表';
        $this->assign('shop',$shop);
        $this->assign('headinfo', $headinfo);
        $this->assign('all_enabled', url('Mcpost/allEnabled'));
        $this->assign('all_discontinuation', url('Mcpost/allDiscontinuation'));
        return $this->fetch();
    }

    /**
     * 新增套系 页面
     * 
     * @param  
     * @return view
     * @author lilong
     */
    public function addPackage(){
        $auth = check_right('menu1555736126');
        if (!$auth) {
            $returnData['code']= 100;
            $returnData['msg'] = '您没有相关权限，请确认。';
            return json($returnData);
        }

        $param['brand_id'] = (int)$this->brandId;
        //这里应该取添加过店面信息的店
        // $shop_list = controller('vip/Package', 'lib')->getShopList($param);
        $shop_list = db('s_shop_info')->field('shop_code,shop_name')->select();
        $shop_list['0']['select'] = 1;
        $this->assign('shop_list', $shop_list);

        //读取erp配置文件
        $erp = config('ext.app_config');
        $addr = $erp['sx_erp']['addr'];
        if (!$addr) {
            $returnData['code']= 101;
            $returnData['msg'] = '请配置ERP-API接口地址。';
            return json($returnData);
        }
        // 调erp获取店下的套系
        $param['addr'] = $addr;
        $param['shop_code'] = $shop_list['0']['shop_code'];
        $package_list = controller('vip/Package', 'lib')->getErpPackage($param);
        $this->assign('package_list', $package_list);
        $headinfo['title'] = '新增套系';
        $this->assign('headinfo', $headinfo);

        //调erp获取消费类型设定
        $consumptionType = controller('Package','lib')->getConsumptionType(['addr'=>$addr]);
        $this->assign('consumptionType', $consumptionType);

        // 获取套系分类列表
        $whereCat['brandclass_id'] = $this->brandId;
        $whereCat['is_delete'] = 1;
        $whereCat['status'] = 1;
        $cList = db('s_cat')->where($whereCat)->select();
        $this->assign('cList', $cList);
        // 获取摄影师列表
        $whereC['brandid'] = $this->brandId;
        $camList = db('cameraman')->where($whereC)->field('id,c_name')->select();
        $this->assign('camList', $camList);
        // 获取产品列表
        $whereP['brandid'] = $this->brandId;
        $proList = db('s_styleproduction')->where($whereP)->field('id,title')->select();
        $this->assign('proList', $proList);
        return $this->fetch();
    }

    /**
     * 新增套系 方法
     * 
     * @param  
     * @return view
     * @author lilong
     */
    public function addPackageAction(){
        // $auth = check_right('menu1542851011');
        // if (!$auth) {
        //     $returnData['code']= 100;
        //     $returnData['msg'] = '您没有相关权限，请确认。';
        //     return json($returnData);
        // }
        $data = input('post.');
        
        // 套系封面图片
        $temp = save_clips_to_file(trim($data['package_title_img']),'public/uploads/'.date('Ymd',time()));
        preg_match('/<img.*?src="(.*?)".*?>/is',$temp,$array);
        $data['package_title_img'] = $array[1];
        $data['package_contents'] = save_clips_to_file(trim($data['package_contents']),'public/uploads/'.date('Ymd',time()));
        // 店长推荐封面
        $temp = save_clips_to_file(trim($data['rec_img']),'public/uploads/'.date('Ymd',time()));
        preg_match('/<img.*?src="(.*?)".*?>/is',$temp,$array);
        $data['rec_img'] = $array[1];

        $cam_ids = '';
        foreach ($data['cam_ids'] as $key => $value) {
            $cam_ids .= $value.',';
        }
        $cam_ids = trim($cam_ids, ',');
        $data['cam_ids'] = $cam_ids;

        $pro_ids = '';
        foreach ($data['pro_ids'] as $key => $value) {
            $pro_ids .= $value.',';
        }
        $pro_ids = trim($pro_ids, ',');
        $data['pro_ids'] = $pro_ids;

        $data['brand_id'] = $this->brandId;

        $res = controller('Package', 'model')->addPackage($data);

        if ($res === false) {
            $returnData['code']= 101;
            $returnData['msg'] = '新增套系失败。';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '新增套系成功。';

            // action_log 日志
            action_log($data,[],0,session('staff_id'),session('staffname'));
        }
        return json($returnData);
    }

    /**
     * 编辑套系 页面
     * 
     * @param  
     * @return view
     * @author lilong
     */
    public function editPackage(){

        $id = (int)input('get.id');
        // 套系信息
        $param['id'] = $id;
        $package = controller('Package', 'model')->getOnePackage($param);
        $this->assign('package', $package);
        // 店面列表
        $param['brand_id'] = (int)$this->brandId;
        $shop_list = controller('vip/Package', 'lib')->getShopList($param);
        foreach ($shop_list as $key => $value) {
            if ($package['shop_code'] == $value['shop_code']) {
                $shop_list[$key]['select'] = 1;
            }
        }
        $this->assign('shop_list', $shop_list);

        //读取erp配置文件
        $erp = config('ext.app_config');
        $addr = $erp['sx_erp']['addr'];
        if (!$addr) {
            $returnData['code']= 101;
            $returnData['msg'] = '请配置ERP-API接口地址。';
            return json($returnData);
        }
        // 调erp获取店下的套系
        $param['addr'] = $addr;
        $param['shop_code'] = $package['shop_code'];
        $package_list = controller('vip/Package', 'lib')->getErpPackage($param);

        foreach ($package_list as $key => $value) {
            if ($package['shop_code'] == $value['shop_code'] && $package['erp_package_name'] == $value['package_name']) {
                $package_list[$key]['select'] = 1;
            }
        }
        $this->assign('package_list', $package_list);

        //调erp获取消费类型设定
        $consumptionType = controller('Package','lib')->getConsumptionType(['addr'=>$addr]);
        $this->assign('consumptionType', $consumptionType);

        // 获取套系分类列表
        $whereCat['brandclass_id'] = $this->brandId;
        $whereCat['is_delete'] = 1;
        $whereCat['status'] = 1;
        $cList = db('s_cat')->where($whereCat)->select();
        $this->assign('cList', $cList);
        // 获取摄影师列表
        $whereC['brandid'] = $this->brandId;
        $camList = db('cameraman')->where($whereC)->field('id,c_name')->select();
        $camArr = explode(',',$package['cam_ids']);
        foreach ($camList as $key => $value) {
            if (in_array($value['id'], $camArr)) {
                $camList[$key]['check'] = 1;
            }else{
                $camList[$key]['check'] = 0;
            }
        }
        $this->assign('camList', $camList);
        // 获取产品列表
        $whereP['brandid'] = $this->brandId;
        $proList = db('s_styleproduction')->where($whereP)->field('id,title')->select();
        $proArr = explode(',',$package['pro_ids']);    
        foreach ($proList as $key => $value) {        
            if (in_array($value['id'], $proArr)) {
                $proList[$key]['check'] = 1;
            }else{
                $proList[$key]['check'] = 0;
            }
        }
        $this->assign('proList', $proList);

        // 头部信息
        $headinfo['title'] = '编辑套系';
        $action = input('action');
        $this->assign('action',$action);//判断是否是 复制数据
        $this->assign('headinfo', $headinfo);
        return $this->fetch();
    }

    /**
     * 编辑套系 方法
     * 
     * @param  
     * @return view
     * @author lilong
     */
    public function editPackageAction(){
        // $auth = check_right('menu1539684609');
        // if (!$auth) {
        //     $returnData['code']= 100;
        //     $returnData['msg'] = '您没有相关权限，请确认。';
        //     return json($returnData);
        // }
        $data = input('post.');
        $temp = save_clips_to_file(trim($data['package_title_img']),'public/uploads/'.date('Ymd',time()));
        preg_match('/<img.*?src="(.*?)".*?>/is',$temp,$array);
        $data['package_title_img'] = $array[1];
        $data['package_contents'] = save_clips_to_file(trim($data['package_contents']),'/public/uploads/'.date('Ymd',time()));
        // 店长推荐封面
        $temp = save_clips_to_file(trim($data['rec_img']),'public/uploads/'.date('Ymd',time()));
        preg_match('/<img.*?src="(.*?)".*?>/is',$temp,$array);
        $data['rec_img'] = $array[1];

        $cam_ids = '';
        foreach ($data['cam_ids'] as $key => $value) {
            $cam_ids .= $value.',';
        }
        $cam_ids = trim($cam_ids, ',');
        $data['cam_ids'] = $cam_ids;

        $pro_ids = '';
        foreach ($data['pro_ids'] as $key => $value) {
            $pro_ids .= $value.',';
        }
        $pro_ids = trim($pro_ids, ',');
        $data['pro_ids'] = $pro_ids;
        
        $data['brand_id'] = $this->brandId;

        // 原数据
        $old = controller('Package', 'model')->getOnePackage($data);
        // 更新
        db()->startTrans();
        try{
            if($data['package_price'] != $old['package_price']){
                $cartData['price'] =  $data['package_price'];
                db('s_package_cart')->where(['price_type'=>1,'package_id'=>$data['id']])->where('pay_time is null')->update($cartData);
            }

            if($data['package_price_down'] != $old['package_price_down']){
                $cartData['price'] =  $data['package_price_down'];
                db('s_package_cart')->where(['price_type'=>2,'package_id'=>$data['id']])->where('pay_time is null')->update($cartData);
            }

            $res = controller('Package', 'model')->editPackage($data);

            if ($res === false) {
                $returnData['code']= 101;
                $returnData['msg'] = '编辑套系失败。';
                db()->rollback();
            }else{

                $returnData['code']= 200;
                $returnData['msg'] = '编辑套系成功。';
                action_log($data,$old,0,session('staff_id'),session('staffname'));
                db()->commit();
            }
            return json($returnData);


        }catch (Exception $e){

            db()->rollback();
            return json(['code'=>204,'msg'=>'编辑套系失败！']);
        }

    }

    /**
     * 删除套系
     * 
     * @param  套系id
     * @return json
     * @author lilong
     */
    public function delPackage(){   
        // $auth = check_right('menu1539674479');
        // if (!$auth) {
        //     $returnData['code']= 100;
        //     $returnData['msg'] = '您没有相关权限，请确认。';
        //     return json($returnData);
        // }

        $id = (int)input('post.id');

        if (empty($id)) {
            $returnData['code']= 101;
            $returnData['msg'] = '参数错误';
            return json($returnData);
        }
        $param['id'] = $id;
        // 原数据
        $old = controller('Package', 'model')->getOnePackage($param);
        // 更新
        $res = controller('Package', 'model')->delPackage($param);

        if ($res === false) {
            $returnData['code']= 102;
            $returnData['msg'] = '操作失败';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '操作成功';
            action_log($param,$old,0,session('staff_id'),session('staffname'));
        }
        return json($returnData);
    }

    // 根据shop_code  获取 套系信息 调erp接口
    public function getPackageList(){
        $data = input('post.');
        
        $shop_code = $data['shop_code'];

        // 读取erp配置文件
        $erp = config('ext.app_config');
        $addr = $erp['sx_erp']['addr'];
        if (!$addr) {
            $returnData['code']= 101;
            $returnData['msg'] = '请配置ERP-API接口地址。';
            return json($returnData);
        }
        // 调erp获取店下的套系  获取套系列表
        $param['addr'] = $addr;
        $param['shop_code'] = $shop_code;
        $package_list = controller('vip/Package', 'lib')->getErpPackage($param);

        return json($package_list);
    }

    // 分类列表
    public function indexCat(){
        // 查看显示权限
        $this->getTopMenu();

        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');

            $param['page']    = isset($page) ? ($page - 1) * $limit : 0;
            $param['limit']   = isset($limit) ? $limit : 10;
            $param['brand_id']= (int)$this->brandId;
            $data = controller('Package', 'model')->getLimitCat($param);

            foreach ($data as $k => $v) {
                $list['data'][] = $v;
                $list['data'][$k]['title'] = base64_decode($v['title']);
            }
            $list['data'] = $data;
            $list['count']= controller('Package', 'model')->getCountCat(['brand_id'=>(int)$this->brandId]);
            $list['msg']  = '';
            $list['code'] = 0;
            return json($list);
        }

        $headinfo['title'] = '分类列表';
        $this->assign('headinfo', $headinfo);
        $this->assign('all_enabled', url('Mcpost/allEnabled'));
        $this->assign('all_discontinuation', url('Mcpost/allDiscontinuation'));
        return $this->fetch();
    }

    // 新增分类页面
    public function addCat(){
        return $this->fetch();
    }

    // 新增分类 方法
    public function addCatActioin(){
        // $auth = check_right('menu1543209575');
        // if (!$auth) {
        //     $returnData['code']= 100;
        //     $returnData['msg'] = '您没有相关权限，请确认。';
        //     return json($returnData);
        // }
        $param = input('post.');
        
        $data['name'] = trim($param['name']);
        $data['sort'] = (int)$param['sort'];
        $data['brand_id'] = (int)$this->brandId;
        $res = controller('Package', 'model')->addCat($data);

        if ($res === false) {
            $returnData['code']= 101;
            $returnData['msg'] = '新增分类失败。';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '新增分类成功。';

            // action_log 日志
            action_log($data,[],0,session('staff_id'),session('staffname'));
        }
        return json($returnData);
    }
    // 编辑分类 页面
    public function editCat(){
        $id = (int)input('get.id');
        $param['id'] = $id;
        $catInfo = controller('Package', 'model')->getOneCat($param);
        $this->assign('catInfo', $catInfo);
        return $this->fetch();
    }

    // 编辑分类 方法
    public function editCatAction(){
       /*
        $auth = check_right('menu1543209553');
        if (!$auth) {
            $returnData['code']= 100;
            $returnData['msg'] = '您没有相关权限，请确认。';
            return json($returnData);
        }
       */

        $param = input('post.');

        // 原数据
        $old = controller('Package', 'model')->getOneCat($param);

        $data['id']   = (int)$param['id'];
        $data['name'] = trim($param['name']);
        $data['sort'] = (int)$param['sort'];
        $res = controller('Package', 'model')->editCat($data);

        if ($res === false) {
            $returnData['code']= 101;
            $returnData['msg'] = '编辑分类失败。';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '编辑分类成功。';

            // action_log 日志
            action_log($data,$old,0,session('staff_id'),session('staffname'));
        }
        return json($returnData);
    }

    // 删除分类
    public function delCat(){
//        $auth = check_right('menu1543209638');
//        if (!$auth) {
//            $returnData['code']= 100;
//            $returnData['msg'] = '您没有相关权限，请确认。';
//            return json($returnData);
//        }

        $id = (int)input('post.id');

        if (empty($id)) {
            $returnData['code']= 101;
            $returnData['msg'] = '参数错误';
            return json($returnData);
        }
        $param['id'] = $id;
        // 原数据
        $old = controller('Package', 'model')->getOneCat($param);
        // 更新
        $res = controller('Package', 'model')->delCat($param);

        if ($res === false) {
            $returnData['code']= 102;
            $returnData['msg'] = '操作失败';
        }else{
            $returnData['code']= 200;
            $returnData['msg'] = '操作成功';
            action_log($param,$old,0,session('staff_id'),session('staffname'));
        }
        return json($returnData);
    }

    // 显示权限
    private function getTopMenu(){
        $menuList = getAuth('auth');

        $index      = '/vip/index/index';
        $packageIndex = '/vip/package/index';
        $addPackage = '/vip/package/addpackage';
        $editPackage= '/vip/package/editpackage';
        $delPackage = '/vip/package/delpackage';
        $copyPackage = '/vip/package/copypackage';

        //分类
        $type = '/vip/package/indexcat';
        $addType = '/vip/package/addcat';
        $editType = '/vip/package/editcat';
        $delType = '/vip/package/delcat';

        //订单列表
        $order = '/vip/packageorder/index';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/', $this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k => $v) {
            $menuUrl = str_replace('\\', '/', $v['menu_url']);

            if ($menuUrl == $addPackage) {
                $this->assign('addPackage', 1);
            } else if ($menuUrl == $editPackage) {
                $this->assign('editPackage', 1);
            } else if ($menuUrl == $delPackage) {
                $this->assign('delPackage', 1);
            } else if ($menuUrl == $editType){
                $this->assign('editCat',1);
            } else if ($menuUrl == $delType){
                $this->assign('delCat',1);
            } else if ($menuUrl == $copyPackage){
                $this->assign('copyPackage',1);
            }

            if($currentUrl == $packageIndex){
                if ($menuUrl == $addPackage) {
                    $this->assign('addPackage', 1);
                    $topmenu .= '<a href="/vip/Package/addPackage"><div class="layui-btn  layui-btn-warm" lay-event="addlevelbtn" id="addlevelbtn"><i class="layui-icon"></i>添加套系</div></a>';
                }
            }

            if($currentUrl == $type){
                if($menuUrl == $addType){
                    $topmenu .= '<a href="/vip/Package/addCat"><div class="layui-btn  layui-btn-warm" style="margin-left:10px;" lay-event="addlevelbtn" id="addlevelbtn"><i class="layui-icon"></i>添加分类</div></a>';
                }
            }


        }
        $this->assign('topmenu', $topmenu);
    }
}