<?php
/**
 * 客片大少
 * User: Wangyining<Wangyining@suxuantech.cn>
 * Date: 2019/04/22
 */
namespace app\vip\controller;
use app\index\controller\Base;

class Photonotice extends Base{
	protected $libname = 'Photonotice';

    /*
     *  后台 拍摄需知列表
     */
    public function index(){

        if(request()->isAjax()){
            $params = input();

            $data = controller($this->libname,'lib')->photoList($params);
            $count = controller($this->libname,'lib')->photoCount($params);
            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }
        $this->getTopMenu();
        $this->assign([
            'headinfo'=>[
                'title'=>'须知管理'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 客片添加
     * @return [type] [description]
     */
    public function add(){
        if(request()->isAjax()){

            $params = request()->post();

            $res = controller($this->libname, 'lib')->photoAdd($params);

            return $res;
        }

        //分类
        $type = db('guest_photo_type')->where(['brand_id'=>$this->brandId])->select();
        //标签
        $tip = db('guest_photo_tip')->where(['brand_id'=>$this->brandId])->select();
        //套系
        $package = db('s_package_info')->where(['brand_id'=>$this->brandId,'is_del'=>1])->select();



        $this->assign(['type'=>$type,'tip'=>$tip,'package'=>$package]);

        return $this->fetch();
    }

    /*
     * 客片修改
     */
    public function edit(){
        if(request()->isAjax()){

            $params = request()->post();

            $res = controller($this->libname, 'lib')->photoEdit($params);

            return $res;
        }

        $id   = input('id');

        $data = controller($this->libname,'lib')->photoList(['id'=>$id]);

        $this->assign('data',$data);
        return $this->fetch();
    }

    //删除客片
    public function photoDel(){
        $id = input('id');
        $res = db('p_photo_notice')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }

    /**
     * 通用图片上传接口
     * @return \think\response\Json
     */
    public function upload()
    {
        $config = [
            'size' => 20971520,
            'ext'  => 'jpg,gif,png,bmp'
        ];
        $file        = $this->request->file('file');

        $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
        $save_path   = '/uploads/';
        $info        = $file->validate($config)->move($upload_path);
        if ($info) {
            $result = [
                'error' => 0,
                'url'   => str_replace('\\', '/', $save_path . $info->getSaveName())
            ];
        } else {
            $result = [
                'error'   => 1,
                'message' => $file->getError()
            ];
        }
        return json($result);
    }


    /**
     * 通用视频上传接口
     * @return \think\response\Json
     */
    public function uploadVideo()
    {
        $config = [
            'size' => 52428800,
            'ext'  => 'mp4'
        ];
        $file        = $this->request->file('file');
        $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
        $save_path   = '/uploads/';
        $info        = $file->validate($config)->move($upload_path);
        if ($info) {
            $result = [
                'error' => 0,
                'url'   => str_replace('\\', '/', $save_path . $info->getSaveName())
            ];
        } else {
            $result = [
                'error'   => 1,
                'message' => $file->getError()
            ];
        }
        return json($result);
    }





    /*
     * 获取用户可使用的页面顶部菜单和操作选项的设置
     */
    public function getTopMenu(){
        $menuList = getAuth('auth');

        $index = '/vip/photonotice/index';
        $photo_add   = '/vip/photonotice/add';
        $photo_edit  = '/vip/photonotice/edit';
        $photo_del   = '/vip/photonotice/del';

        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($currentUrl == $index){
                if($menuUrl == $photo_add){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$photo_add.'">添加须知内容</a></div>';
                    $this->assign('add',1);
                }elseif($menuUrl == $photo_edit){
                    $this->assign('edit',1);
                }elseif($menuUrl == $photo_del){
                    $this->assign('del',1);
                }
            }

            if($currentUrl == $user_photo){
                if($menuUrl == $photo_check){
                    $this->assign('check',1);
                }
            }
        }
        $this->assign('topmenu',$topmenu);
    }
}