<?php
/**
 * 推荐控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\SScoreDetail;
use think\Cache;
use think\image\Exception;
use think\Session;
class Recommend extends Base {
    //用于ajax返回的数据
    protected $msg     = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'recommends';
    /**
     * 方法描述: 获取列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];

            $c = input();

            $data['data']  = controller($this->libname,'lib')->getList($c);
            //print_r(db()->getLastSql());die;
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'转推荐管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }


    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $arrs = db('recommend')->where('id',$id)->find();
        $res = controller($this->libname,'lib')->del($id);
        if ($res) {
            action_log($arrs);      //写日志
            $arr = array('status'=>1,'msg'=>'信息删除成功');
            return json($arr);
        } else {
            $arr = array('status'=>0,'msg'=>'信息删除失败');
            return json($arr);
        }
    }

    /**
     * 方法描述     设置状态，是否启用
     * @param  int $id id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
//     public function setStatus(){
//         $id     = request()->post('id');
//         $status = 1;
//         $res = controller($this->libname,'lib')->setStatus($id,$status);
//         return json(['status'=>$res?1:0]);
//     }


    /**
     * 用户推荐列表页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Wangyining}<{Wangyining@suxuantech.cn}> 2019-04-16 $
     */

    public function setStatus () {
        $recommenId = input('post.id');
        if(!$recommenId){
            $arr = array('status'=>0,'msg'=>'无法获取您要审核的数据,请刷新页面重试！');
            return json($arr);
        }

        $memData = db('recommend')
            ->alias('a')
            ->field('a.*,b.id')
            ->join('m_users b','a.userid = b.id')
            ->where('a.id','=',$recommenId)
            ->find();
        if(!$memData){
            $arr = array('status'=>0,'msg'=>'无法获取您要审核的数据,请刷新页面重试！');
            return json($arr);
        }

        $memId   = $memData['userid'];  //推荐人id
        $staffId = Session::get('staffid'); //哪个员工更改的
        $status  =  input('post.status');


        /*******************************************************
         * 更改start   推荐人积分规则改为 在推荐人规则设置中
         * *****************************************************
         */

        $upData['status']       = $status;
        $upData['check_user']  = $this->staffName;
        $upData['update_time'] = date('Y-m-d H:i:s',time());

        db()->startTrans();
        try{
            if ($status == 2 ) {
                //推荐成功积分奖励
                $scoreRule = getRecommendRule(session::get('brandid'),'recommend');
                if($scoreRule>0){
                    //db('m_users')->where('id',$memId)->setInc('total_score',(int)$scoreRule);
                    //minuteDetailed("推荐用户",(int)$scoreRule,$memId,8);

                    $score = AddScore($memId,'',(int)$scoreRule,8,'推荐用户');
                    if($score === false){
                        db()->rollback();
                        $arr = array('status'=>0,'msg'=>'更改状态失败');
                        return json($arr);
                    }
                }
                $upData['recom_num'] = (int)$scoreRule;
            }
            db('recommend')->where('id','=',$recommenId)->update($upData);
            action_log($upData,'',$recommenId,$staffId,$this->staffName);

            db()->commit();
            return json(['status'=>1,'msg'=>'状态更改成功']);
        }catch (Exception $e){
            db()->rollback();
            return json(['status'=>0,'msg'=>'更改状态失败']);
        }

        /*******************************************************
         * 更改end
         * *****************************************************
         */

    }


    /*经纪人管理
     *
     */
    public function agent(){

        if(request()->isAjax()){

            //判断当前帐号是否为集团会员
            if($this->brandId != db_config('sx_brand')){
                $where['brandid'] = $this->brandId;
            }
            $limit    = (int)input('get.limit') ? (int)input('get.limit') : 10;
            $pagenum  = (int)input('get.page') ? (int)input('get.page') : 1;

            $data['data']  = db('m_users')
                            ->where('agent_status is not null')
                            ->where($where)
                            ->page($pagenum,$limit)
                            ->order('agent_status')
                            ->select();
            $data['count'] = db('m_users')
                            ->where('agent_status is not null')
                            ->where($where)
                            ->count();
            $data['msg']   = '';
            $data['code']  = 0;

            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'经纪人管理'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }

    /*
     * 审核经纪人
     */
    public function checkAgent(){
        $id = input('post.id');
        $agent_status = input('post.status');

        db()->startTrans();
        try{
            db('m_users')
                ->where('id',$id)
                ->update([
                    'agent_status'=>$agent_status,
                    'check_apply_time'=>date('Y-m-d H:i:s',time()),
                    'check_apply_user'=>$this->staffName
                ]);

            action_log(array('agent_status'=>$agent_status,'check_apply_time'=>date('Y-m-d H:i:s',time())));
            if($agent_status==2){
                //审核通过，发模板消息提醒已成为经纪人
            }
            db()->commit();
            return json(array('status'=>200,'msg'=>'状态更改成功'));
        }
        catch (\Exception $e){

            db()->rollback();
            return json(array('status'=>202,'msg'=>'状态更改失败'.$e->getMessage()));
        }
    }

    /*
     * 审核订单列表
     */
    public function orderList(){
        if(request()->isAjax()){

            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];
            $limit    = (int)input('get.limit')?(int)input('get.limit'):10;
            $pagenum  = (int)input('get.page')?(int)input('get.page'):1;


            //有搜索条件并且联表 order/recommend
/*            $sql = ' 1 =1 ';
            if(input('get.order_number'))   $sql .= ' and order_number like "%'.input('get.order_number').'%" ';
            if(input('get.tj_name'))         $sql .= ' and tj_name like "%'.input('get.tj_name').'%" ';
            if(input('get.phone'))           $sql .= ' and phone like "%'.input('get.phone').'%" ';
            $sql .= ' and o.recommend_id is not null ';

            $data['data'] = db('m_order')->where($sql)
                ->alias('o')
                ->join('recommend r','r.id=o.recommend_id','left')
                ->limit($pagenum,$limit)
                ->select();
            $data['count'] = db('m_order')->where($sql)
                ->alias('o')
                ->join('recommend r','r.id=o.recommend_id','left')
                ->count('o.id');
*/
            //通过介绍人成单&可进行审核、审核成功、失败的订单
            $data['data']  = db('m_order')
                ->where('recommend_id is not null')
                ->where('a.delete_time is null')
                //->where('is_check',['>',0])
                ->where('can_check',1)
                ->alias('a')
                ->join('c_coupon_list b','a.coupon_id = b.id','left')
                ->field('a.*,b.name')
                ->page($pagenum,$limit)
                ->select();
            $data['count'] = db('m_order')
                ->where('recommend_id is not null')
                ->where('delete_time is null')
                //->where('is_check',['>',0])
                ->where('can_check',1)
                ->count('id');
            $data['msg']   = '';
            $data['code']  = 0;

            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'订单审核'
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }

    /*
     * 查看订单详情
     */
    public function getOrderInfo(){
        $order_number = input('post.order_number');
        $phone = input('post.phone');
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url

        //$url = $addr.'/SX_VipApi/Vip_SelOrderInfo?Token=^******^&tel='.$phone.'&orderid='.$order_number; //定义拼接url
        $url = $addr . '/SX_ChildErpAppNew/SX_InquireCustomerInfoJQ?Token=^******^&orderid='.$order_number;
        $response = requestERP($url, ''); //调用erp接口

        if ($response['Code'] == 200) {
            $orderOneData = $response['Data'][0];
            $orderOneData['targetdate'] = date('Y-m-d',strtotime($orderOneData['targetdate']));
            $orderOneData['package_name'] = $orderOneData['package_name'] ? $orderOneData['package_name'] : $orderOneData['yxpackage_name'];

            $data = db('m_order')->where('order_number',$order_number)
                ->alias('o')
                ->join('recommend r','r.id=o.recommend_id','left')
                ->find();

            //erp直接下单 读取推荐人奖励规则
            $rule = db('recommend_rule')->where('brand_id',$data['brandid'])->find();

            $ruleData = json_decode($rule['rule'],true);

            $orderOneData['award_money'] = $ruleData['get_money'];
            $orderOneData['award_score'] = $ruleData['get_score'];

            //$orderOneData['award_money'] = ($ruleData['get_money']/$ruleData['cost_money'])*$orderOneData['payment_money'];
            //$orderOneData['proportion'] = $ruleData['get_money']/$ruleData['cost_money'];//比例
            $orderOneData['orderId'] = $order_number;
            return array('code'=>1,'data'=>$orderOneData);
        }
        return array('code'=>0,'msg'=>'没有获取到订单信息');

    }

    /*
     * 审核订单
     */
    public function checkOrder(){

        $order_number = input('post.order_number');
        $is_ok = input('post.is_ok');
        $award_money = input('post.award_money');
        $award_score = input('post.award_score');

        if($is_ok == 1){

            $edit['is_check'] = 1;
            $edit['award_money'] = $award_money;//应奖励金额
            $edit['award_score'] = $award_score;//应奖励积分
        }else{

            $edit['is_check'] = 2;
        }

        db()->startTrans();
        try{
            db('m_order')->where('order_number',$order_number)->update($edit);

            //标记为此推荐关系已订单
            $r_id = db('m_order')->where('order_number',$order_number)->value('recommend_id');
            db('recommend')->where('id',$r_id)->update(['is_ok'=>1]);

            db()->commit();
            return array('code'=>1,'msg'=>'审核操作成功');
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>0,'msg'=>'审核操作失败，请稍后重试'.$e->getMessage());
        }

    }

    /*
     * 推荐规则设置
     */
    public function configSet(){
        $rule = db('recommend_rule')->where('brand_id',session::get('brandid'))->find();
        $detail = json_decode($rule['rule'],true);

        $shopList = controller('Setting','lib')->get_shop(['brandclass_id'=>session::get('brandid')]);

        //$shop_code = $detail['shop_code'] ? $detail['shop_code'] : $shopList[0]['shop_code'];
        $shop_code = $detail['shop_code'];
        if($shop_code){

            $staff = sx_call('5a01766b4a3dd',['shop_code'=>$shop_code],'sx_mc');
            if($staff['code'] == 200){
                $staffList = $staff['data'];
            }


            //获取crm来源渠道
            $channelRes= sx_call('5d64ca8e6f540',['add_shop_code'=>$shop_code],'sx_crm');
            if($channelRes['code'] == 200){
                $channel = $channelRes['data'];
            }
        }

        //print_r($channel);die;
        $this->assign([
            'headinfo' => [
                'title'=> '转推荐规则设置'
            ],
            'detail'   => $detail,
            'shopList' => $shopList,
            'staffList'=> $staffList,
            'channel'  => $channel,
        ]);

        $this->getTopMenu();
        return view('configset');
    }

    public function getStaffAndChannel(){
        $shop_code = input('shop_code');
        if(!$shop_code){
            return ['code'=>201,'msg'=>'未获取到店面信息'];
        }

        $staff = sx_call('5a01766b4a3dd',['shop_code'=>$shop_code],'sx_mc');

        $channelRes= sx_call('5d64ca8e6f540',['add_shop_code'=>$shop_code],'sx_crm');

        return ['code'=>200,'data'=>['staff'=>$staff['data'],'channel'=>$channelRes['data']]];

    }

    /*
     * 修改规则
     */
    public function editConfig(){
        $data = input('post.');

        $jsonData['is_apply']   = isset($data['is_apply'])?1:2;
        $jsonData['is_check']   = isset($data['is_check'])?1:2;
        $jsonData['recommend']  = $data['recommend'];
        $jsonData['cost_money'] = $data['cost_money'];
        $jsonData['get_money']  = $data['get_money'];
        $jsonData['get_score']  = $data['get_score'];

        $jsonData['shop_code']  = $data['shop_code'];
        $jsonData['shop_name']  = $data['shop_name'];
        $jsonData['staff_id']  = $data['staff_id'];//客资提报人
        $jsonData['staff_name']  = $data['staff_name'];//客资提报人
        $jsonData['channel_id']  = $data['channel_id'];//渠道id
        $jsonData['channel_name']  = $data['channel_name'];//渠道
        $jsonData['xdwk_channel_id']  = $data['xdwk_channel_id'];//先睹为快渠道
        $jsonData['xdwk_channel_name']  = $data['xdwk_channel_name'];//先睹为快渠道
        $jsonData['rule_content']  = $data['rule_content'];//规则描述
        $jsonData['jjr_img']  = $data['jjr_img'];//经纪人规则图
        $jsonData['is_jyxm']  = isset($data['is_jyxm'])?1:2;//是否展示经营项目

        //$jsonData['is_shareholder'] = isset($data['is_shareholder'])?1:2;
        $insert['rule'] = json_encode($jsonData);
        $insert['brand_id'] = session::get('brandid');
        $insert['staff_id'] = session::get('staff_id');
        $insert['staff_name'] = session::get('staffname');
        $rule = db('recommend_rule')->where('brand_id',session::get('brandid'))->find();
        if(!empty($rule)){
            $insert['update_time'] = date('Y-m-d H:i:s',time());
            $res = db('recommend_rule')->where('id',$rule['id'])->update($insert);
        }else{
            $insert['create_time'] = date('Y-m-d H:i:s',time());
            $res = db('recommend_rule')->insert($insert);
        }

        if($res===false){
            return array('code'=>0,'msg'=>'设置失败');
        }else{
            return array('code'=>1,'msg'=>'设置成功');
        }
    }
    /**
     * 股东码
     * @return [type] [description]
     */
    public function shareholder(){
        if(request()->isAjax()){
            $c = [
                'limit'  => (int)input('get.limit'),
                'page'   => (int)input('get.page'),
            ];
            $data['data'] = controller($this->libname,'lib')->GetShareList($c);
            $data['count'] = controller($this->libname,'lib')->GetShareCount();
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'股东码管理',
            ]
        ]);
        $this->getTopMenu();
        return $this->fetch();
    }
    /**
     * 方法描述：添加股东码
     * @return [type] [description]
     */
    public function addshareholder(){
        if(request()->isAjax()){
            $acdata = request()->post('');
            $data['code'] = $acdata['code'];
            $data['quota'] = $acdata['quota'];
            $res = controller($this->libname,'lib')->AddShareHolder($data);
            if($res){
                return json(['code'=>200,'msg'=>'添加成功']);
            }else{
                return json(['code'=>202,'msg'=>'添加失败']);
            }
        }
        $shareData = controller($this->libname,'lib')->SetShareHolder();
        if($shareData){
            $this->assign('code',$shareData);
        }
        return $this->fetch();
    }
    /**
     * 生成股东码
     * @return [type] [description]
     */
    public function setshareholder(){
        $shareData = controller($this->libname,'lib')->SetShareHolder();
        if($shareData){
            return json(['code'=>200,'msg'=>'生成成功','data'=>$shareData]);
        }else{
            return json(['code'=>202,'msg'=>'生成失败']);
        }
    }
    /**
     * 方法描述   获取用户可使用的页面顶部菜单和操作选项的设置
     * @param string
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月16日 上午10:37:26
     */
    
    public function getTopMenu(){
    
        $menuList   = getAuth();
        $currentUrlStart = '/vip/recommend/';
        //print_r($menuList);
        $indexurl    = $currentUrlStart.'index';//推荐
        $agentUrl = $currentUrlStart.'agent';//经纪人
        $setting = $currentUrlStart.'configset';
        $order = $currentUrlStart.'orderlist';

        $setstatus   = $currentUrlStart.'setstatus';
        $del   = $currentUrlStart.'del';

        $checkAgent   = $currentUrlStart.'checkagent';
        $delAgent   = $currentUrlStart.'delagent';
        $checkOrder = $currentUrlStart.'checkorder';

        $shareindex = $currentUrlStart.'shareholder';
        $sharedel   = $currentUrlStart.'del';
        $addshareholder = $currentUrlStart.'addshareholder';

        //股东帐号
        $shareuserindex = '/vip/recommendusername/index';
        $shareuseradd   = '/vip/recommendusername/add';
        $shareuseredit  = '/vip/recommendusername/edit';
        $shareuserdel   = '/vip/recommendusername/del';

        //将客户信息转入crm
        $toCrm = '/vip/recommend/importcustomertocrm';

        // 当前的url地址
        $currentUrl = str_replace('\\', '/',$this->currentUrl);
       // print_r($currentUrl);echo '|';print_r(strtolower($setting));die;
        $topmenu = '';

        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($menuUrl == $agentUrl){
                $class = '';
                if($agentUrl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"  ><a href="'.$agentUrl.'">经纪人管理</a></div>';
            }else if($menuUrl == $indexurl){
                $class = '';
                if($indexurl == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"  ><a href="'.$indexurl.'">转介绍管理</a></div>';
            }else if($menuUrl == $order){
                $class = '';
                if($order == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"  ><a href="'.$order.'">订单审核</a></div>';
            }else if($menuUrl == $setting){
                $class = '';
                if($setting == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"  ><a href="'.$setting.'">规则设置</a></div>';
            }else if($menuUrl == $shareindex){
                $class = '';
                if($shareindex == $currentUrl){
                    $class = 'mactive';
                }
                // $topmenu .= '<div class="layui-btn '.$class.'"  ><a href="'.$shareindex.'">股东码管理</a></div>';
            }else if($menuUrl == $shareuserindex){
                $class = '';
                if($shareuserindex == $currentUrl){
                    $class = 'mactive';
                }
                $topmenu .= '<div class="layui-btn '.$class.'"  ><a href="'.$shareuserindex.'">股东账号管理</a></div>';
            }else if($menuUrl == $shareuseradd){                
                $this->assign('shareuseradd',$shareuseradd);
            }else if($menuUrl == $shareuseredit){
                $this->assign('shareuseredit',1);
            }else if($menuUrl == $shareuserdel){
                $this->assign('shareuserdel',1);
            }else if($menuUrl == $sharedel){
                $this->assign('sharedel',1);
            }else if($menuUrl == $addshareholder){
                $this->assign('addshareholder',$addshareholder);
            }else if($menuUrl == $setstatus){
                $this->assign('setstatus',1);
            }else if($menuUrl == $del){
                $this->assign('del',1);
            }else if($menuUrl == $checkAgent){
                $this->assign('checkAgent',1);
            }else if($menuUrl == $delAgent){
                $this->assign('delAgent',1);
            }else if($menuUrl == $checkOrder){
                $this->assign('checkOrder',1);
            }else if($menuUrl == $toCrm){
                $this->assign('tocrm',1);
            }
        }
        $this->assign('topmenu',$topmenu);
    }

    //获取推荐人拍照类型列表
    public function getType(){
        $device = db('recommend_photo_type')->where('brand_id',$this->brandId)->select();
        return array('code'=>'200','data'=>$device);
    }

    //新增推荐人拍照类型
    public function addType(){
        $id = input('id');
        $type_name = input('type_name');
        db()->startTrans();

        $updateInfo = [
            'type_name' => $type_name,
            'brand_id'  => $this->brandId,
            'staff_id'  => session('staff_id'),
            'staff_name'  => session('staffname'),
            'create_time' => date('Y-m-d H:i:s'),
        ];

        try{
            if($id){
                db('recommend_photo_type')->where('id',$id)->update($updateInfo);
            }else{
                $id = db('recommend_photo_type')->insertGetId($updateInfo);
            }
            db()->commit();
            return array('code'=>200,'data'=>$id);

        }catch (Exception $e){
            db()->rollback();
            return array('code'=>201,'msg'=>'操作拍照类型失败，请稍后重试！');
        }

    }

    //删除推荐人拍照类型
    public function delType(){
        $id = input('id');
        $res = db('recommend_photo_type')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }

    /*
     * 将客户信息接入crm
     */
    public function importCustomerToCrm(){
        $data = input('customerData/a');
        $brandId = $this->brandId;
        $brandClass = session('brandname');

        if($brandId && !$brandClass){
            $brandRes = sx_call('5a38840b15ba9',['id'=>$brandId],'sx_mc');
            if($brandRes['code'] == 200){
                $brandClass = $brandRes['data'][0]['brandclass'];
            }
        }

        //推荐设置
        $r_rule = db('recommend_rule')->where('brand_id',$brandId)->find();
        $rule = json_decode($r_rule['rule'],true);

        $access = 0;
        $error = 0;

        foreach($data as $k => $v){
            if($v['crm_status'] == 0 || $v['crm_status'] == 2){
                $new_order = db('m_order')->where('phone',$v['phone'])->order('order_time desc')->find();
                $order_number = $new_order['order_number'];

                $param = [
                    'introducer_ordernum' => $order_number ? $order_number : '',
                    'introducer_name' => $v['username'],//介绍人名字
                    'introducer_tel'  => $v['phone'],//介绍人手机
                    'dj_staff_id'   => $rule['staff_id'],
                    'dj_staff'      => $rule['staff_name'],
                    'brandclass_id' => $brandId ? $brandId : '',
                    'brandclass'    => $brandClass ? $brandClass : '',
                    'shop_code'     => $rule['shop_code'],
                    'shop_name'     => $rule['shop_name'],
                    'info'          => $v['r_username'].'-'.$v['r_phone'],
                    'customer_channel'    => $rule['channel_name'],
                    'customer_channel_id' => $rule['channel_id'],
                ];

                $kzRes = sx_call('5b286c6bbf298',$param,'sx_crm');

                if($kzRes['code'] != 200){
                    $error++;
                    $crm_status = 2;
                }else{
                    $access++;
                    $crm_status = 1;
                }

                db('recommend')->where('id',$v['id'])->update(['crm_status'=>$crm_status,'crm_error_msg'=>$kzRes['msg']]);
            }else{
                if($v['crm_status'] == 1){
                    $access++;
                }elseif($v['crm_status'] == 2){
                    $error++;
                }

            }

        }

        if(count($data) > 1){
            return ['code'=>200,'msg'=>'crm转介绍成功'.$access.'个，失败'.$error.'个。'];
        }else{
            return ['code'=>200,'msg'=>$kzRes['code'] == 200 ? 'crm转介绍成功！' : $kzRes['code'].'-'.$kzRes['msg']];
        }



    }
    
}