<?php
/**
 * 客片大少
 * User: Wangyining<Wangyining@suxuantech.cn>
 * Date: 2019/04/22
 */
namespace app\vip\controller;
use app\index\controller\Base;

class Shopinfo extends Base{
	protected $libname = 'Shopinfo';

    /*
     *  后台 店面列表
     */
    public function shopList(){

        if(request()->isAjax()){
            $params = input();
            $limit    = $params['limit']?$params['limit']:10;
            $page  = $params['page']?$params['page']:1;

            $data = db('s_shop_info')->where(['brand_id'=>session('brandid')])->page($page,$limit)->select();
            $count= db('s_shop_info')->where(['brand_id'=>session('brandid')])->count();

            foreach($data as $k => $v){
                $img = json_decode($v['shop_img'],true);
                $data[$k]['shop_photo'] = $img[0]['url'];
            }

            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }
        $this->getTopMenu();
        $this->assign([
            'headinfo'=>[
                'title'=>'店面详情'
            ]
        ]);
        return $this->fetch();
    }

    /*
     * 店面详情添加
     * @return [type] [description]
     */
    public function shopAdd(){
        if(request()->isAjax()){
            $params = request()->post();
            $data = [

                'shop_info_img'  => $params['shop_info_img'],
                'photo_notice' => $params['photo_notice'],
                'wx_qr_code' => $params['wx_qr_code'],
                'shop_img'   => json_encode($params['shop_img']),
                'shop_code'  => trim($params['shop_code']),
                'shop_name'  => trim($params['shop_name']),
                'shop_sn'  => trim($params['shop_sn']),
                'shop_tel'   => trim($params['shop_tel']),
                'is_show'   => intval($params['is_show']),
                'brand_id'   => $this->brandId,
                'sort'       => $params['sort']?$params['sort']:99,
                'create_time'=> date("Y-m-d H:i:s",time()),
                'add_staff'  => session('staffname'),
            ];
            if(!$data['shop_code']){
                return ['code'=>201,'msg'=>'未获取到店面信息，请确认MC有此店面信息'];
            }
            if(db('s_shop_info')->where('shop_code',$data['shop_code'])->find()){
                return ['code'=>201,'msg'=>'此店面信息已设置过！'];
            }

            $res = db('s_shop_info')->insert($data);
            if($res){
                cache('p_shop_list*',null);
                cache('shop_list_*',null);
                return ['code'=>200,'msg'=>'添加成功'];
            }else{
                return ['code'=>202,'msg'=>'添加失败'];
            }
        }

        //根据事业部获取店面
        $shop = config('brand_shops');//如果配置了对应关系，则按配置走。
        if(empty($shop[session('brandid')])){
            $shop = controller('vip/Setting','lib')->get_shop(array('brandclass_id'=>session('brandid')));
        }else{
            $shop = $shop[session('brandid')];
        }
        $editedShop = db('s_shop_info')->column('shop_code');
        foreach ($shop as $key=>$value) {
            if(in_array($value['shop_code'],$editedShop)){
                unset($shop[$key]);
            }
        }
        $this->assign(['shop'=>$shop]);

        return $this->fetch();
    }

    /*
     * 店面修改
     */
    public function shopEdit(){
        if(request()->isAjax()){

            $params = request()->post();

            $id = $params['id'];
            if(!$id){
                return ['code'=>201,'msg'=>'未获取到事业部id'];
            }

            $data = [
                'shop_info_img'  => $params['shop_info_img'],
                'photo_notice' => $params['photo_notice'],
                'wx_qr_code' => $params['wx_qr_code'],
                'shop_img'   => json_encode($params['shop_img']),
                'shop_code'  => trim($params['shop_code']),
                'shop_name'  => trim($params['shop_name']),
                'shop_sn'  => trim($params['shop_sn']),
                'shop_tel'   => trim($params['shop_tel']),
                'is_show'   => intval($params['is_show']),
                'brand_id'   => $this->brandId,
                'sort'       => $params['sort']?$params['sort']:99,
                'create_time'=> date("Y-m-d H:i:s",time()),
                'add_staff'  => session('staffname'),
            ];
            if(!$data['shop_code']){
                return ['code'=>201,'msg'=>'未获取到店面信息，请确认MC有此店面信息'];
            }
            $data = db('s_shop_info')->where('id',$id)->update($data);
            if($data!==false){
                cache('p_shop_list*',null);
                cache('shop_list_*',null);
                return ['code'=>200,'msg'=>'修改成功'];
            }else{
                return ['code'=>202,'msg'=>'添加失败'];
            }

        }

        $id   = input('id');

        $data = db('s_shop_info')->where('id',$id)->find();

        //根据事业部获取店面
        // $shop = controller('vip/Setting','lib')->get_shop(array('brandclass_id'=>session('brandid')));
        $shop = config('brand_shops');//如果配置了对应关系，则按配置走。
        if(empty($shop[session('brandid')])){
            $shop = controller('vip/Setting','lib')->get_shop(array('brandclass_id'=>session('brandid')));
        }else{
            $shop = $shop[session('brandid')];
        }
        $this->assign('detail',json_decode($data['shop_img'],true));
        $this->assign(['id'=>$id,'data'=>$data,'shop'=>$shop]);

        return $this->fetch();
    }
    /*
     * 店面删除
     */
    public function shopDel(){
        $id = input('id');
        $res = db('s_shop_info')->where('id',$id)->delete();
        if($res !== false){
            cache('p_shop_list*',null);
            cache('shop_list_*',null);
            return json(['code'=>200,'msg'=>'删除成功']);
        }else{
            return json(['code'=>202,'msg'=>'删除失败']);
        }
    }
    /**
     * 通用图片上传接口
     * @return \think\response\Json
     */
    public function upload()
    {
        $config = [
            'size' => 20971520,
            'ext'  => 'jpg,gif,png,bmp'
        ];
        $file        = $this->request->file('file');
        $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
        $save_path   = '/uploads/';
        $info        = $file->validate($config)->move($upload_path);
        if ($info) {
            $result = [
                'error' => 0,
                'url'   => str_replace('\\', '/', $save_path . $info->getSaveName())
            ];
        } else {
            $result = [
                'error'   => 1,
                'message' => $file->getError()
            ];
        }
        return json($result);
    }

    /*
     * 获取用户可使用的页面顶部菜单和操作选项的设置
     */
    public function getTopMenu(){
        $menuList = getAuth('auth');

        $shop_list = '/vip/shopinfo/shoplist';
        $shop_add  = '/vip/shopinfo/shopadd';
        $shop_edit = '/vip/shopinfo/shopedit';
        $shop_del = '/vip/shopinfo/shopdel';

        $currentUrl = str_replace('\\', '/',$this->currentUrl);
        $topmenu = '';
        foreach ($menuList as $k=>$v){
            $menuUrl = str_replace('\\', '/',$v['menu_url']);
            if($currentUrl == $shop_list){
                if($menuUrl == $shop_add){
                    $topmenu .= '<div class="layui-btn layui-btn-warm" ><i class="layui-icon">&#xe654;</i><a href="'.$shop_add.'">添加店面详情</a></div>';
                    $this->assign('add',1);
                }elseif($menuUrl == $shop_edit){
                    $this->assign('edit',1);
                }elseif($menuUrl == $shop_del){
                    $this->assign('del',1);
                }
            }
        }

        $this->assign('topmenu',$topmenu);
    }
}