<?php
/**
 * 活动报名和获取报价控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月24日 下午12:34:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use app\vip\model\AActivitySignUp;

class Signup extends Base{   
    
    //用于ajax返回的数据
    protected $msg = ['status'=>0,'msg'=>'操作失败'];
    protected $libname = 'activitysignup';
    /**
     * 方法描述: 获取报名列表
     * @return array
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:02:12
     */
    public function index(){
        $dataConfig = [
                    [
                        'name'=>'姓名',
                        'title'=>'请输入姓名',
                        'icon'=>'/public/front/img/reg_in1.png',
                        'key'=>'name',
                    ],
                ];
        $dbConfig = db_config('acitivity_data_config');
        if($dbConfig){
            $dataConfig = $dbConfig;
        }
        $linkcode = trim(request()->get('linkcode'));
        if(request()->isAjax()){
            $activityid = (int)request()->get('activityid');
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];
            if($activityid){
                $c['activityid'] = $activityid;
            }
            if($linkcode){
                $c['linkcode'] = $linkcode;
            }
            $data['data']  = controller($this->libname,'lib')->getList($c);
            foreach($data['data'] as $k =>$v){
                $extData = json_decode($v['ext_data'],true);
                foreach($dataConfig as $config){
                    $data['data'][$k]['ext_'.$config['key']] = $extData[$config['key']];

                }
            }
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCount($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'活动报名详情'
            ],
            'linkcode' => $linkcode,
            'dataConfig'=>$dataConfig,
        ]);
        controller('activity','controller')->getTopMenu();
        return $this->fetch();
    }

    /**
     * 方法描述     设置活动发布状态，是否启用
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function setStatus(){
        $id  = request()->post('id');
        $res = db('a_activity_sign_up')->where('id','=',$id)->update(['status'=>1,'check_userid'=>$this->staffId,'update_time'=>date('Y-m-d H:i:s',time()),'check_name'=>$this->staffName]);
//        $res =  controller($this->libname,'lib')->setStatus($id,1);
        if($res){
        	action_log(['status'=>1,'check_userid'=>$this->staffId,'update_time'=>date('Y-m-d H:i:s',time()),'check_name'=>$this->staffName]);
        }
        return json(['status'=>$res?1:0,'msg'=>'']);
    }

    /**
     * 方法描述: 删除假删除
     * @param  int $id 活动id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午1:08:57
     */
    public function del(){
        $id = request()->post('id');
        $arrs = db('a_activity_sign_up')->where('id',$id)->find();
        //$res = AActivitySignUp::destroy($id)->fetchSql();
        $res = db("a_activity_sign_up")->delete($id);
        if ($res) {
            action_log($arrs);      //写日志
            $arr = array('status' => 1, 'msg' => '删除成功');
            return json($arr);
        } else {
            $arr = array('status' => 0, 'msg' => '删除失败');
            return json($arr);
        }
    }
    public function sharedel(){
        $id = request()->post('id');
        $arrs = db('a_activity_share_qr')->where('id',$id)->find();
        //$res = AActivitySignUp::destroy($id)->fetchSql();
        $res = db("a_activity_share_qr")->delete($id);
        if ($res) {
            action_log($arrs);      //写日志
            $arr = array('status' => 1, 'msg' => '删除成功');
            return json($arr);
        } else {
            $arr = array('status' => 0, 'msg' => '删除失败');
            return json($arr);
        }
    }
    //新报名统计
    public function newindex(){
        $dataConfig = [
                    [
                        'name'=>'姓名',
                        'title'=>'请输入姓名',
                        'icon'=>'/public/front/img/reg_in1.png',
                        'key'=>'name',
                    ],
                ];
        $dbConfig = db_config('acitivity_data_config');
        if($dbConfig){
            $dataConfig = $dbConfig;
        }
        $linkcode = trim(request()->get('linkcode'));
        if(request()->isAjax()){
            
            $activityid = (int)request()->get('activityid');
            $type = request()->get('type');
            $share_userid = (int)request()->get('share_userid');
            $c = [
                'limit' => request()->get('limit'),
                'page'  => request()->get('page'),
            ];


            if($activityid){
                $c['activityid'] = $activityid;
            }
            if($linkcode){
                $c['linkcode'] = $linkcode;
            }
            if($type){
                $c['type'] = $type;
            }
            if($share_userid){
                $c['share_userid'] = $share_userid;
            }
            $data['data']  = controller($this->libname,'lib')->getListnew($c);
            foreach($data['data'] as $k =>$v){
                $extData = json_decode($v['ext_data'],true);
                foreach($dataConfig as $config){
                    $data['data'][$k]['ext_'.$config['key']] = $extData[$config['key']];

                }
            }
            unset($c['limit'],$c['page']);
            $data['count'] = controller($this->libname,'lib')->getCountnew($c);
            $data['msg']   = ''; 
            $data['code']  = 0;
            return json($data);
        }
        $activityData = db('a_activity_list')->where('brandid',$this->brandId)->where('delete_time',null)->field('id,title')->select();
        $this->assign([
            'headinfo'=>[
                'title'=>'活动报名详情'
            ],
            'activitydata'=>$activityData,
            'linkcode' => $linkcode,
            'dataConfig'=>$dataConfig,
        ]);
        controller('activity','controller')->getTopMenu();
        return $this->fetch();
    }


    //客资导出
    public function export(){
        $w['s.brandid'] = $this->brandId;
        $w['a.brandid'] = $this->brandId;
        $d = db("a_activity_sign_up")->alias('s')
            ->where($w)
            ->field('u.username,a.title,s.b_username,s.b_phone,s.site,s.create_time,s.parent_id,s.share_num,s.fission_num,s.status,s.check_name,s.update_time,s.parent_ids')
            ->join('__A_ACTIVITY_LIST__ a','a.id=s.activityid','left')
            ->join('__M_USERS__ u','u.id=s.userid','left')
            ->order('s.create_time desc')
            ->select();
        $data = db('a_activity_sign_up')->where('brandid',$this->brandId)->select();
        foreach($d as $k=>$v){
            if($v['parent_id'] != 0 && !empty($v['parent_ids'])){
                foreach($data as $k2=>$v2){
                    if(strpos($v['parent_ids'],',')){
                        if(explode(',',$v['parent_ids'])[1] == $v2['id']){
                            $d[$k]['parent_id'] = $v2['b_username'];
                        }
                    }else{
                        if($v['parent_ids'] == $v2['id']){
                            $d[$k]['parent_id'] = $v2['b_username'];
                        }
                    }
                }
            }
            unset($d[$k]['parent_ids']);
        }
        $title=array('会员昵称','报名活动','报名姓名','报名电话','意向店面','报名时间','推荐人','分享人数','裂变人数','处理状态','处理人员','处理时间');
        $file="signup.xlsx";
        controller($this->libname,"lib")->export($title,$d,$file);
    }
}