<?php
/**
 * 热门搜索
 * User: zhaibaoming
 * Date: 2018/8/14 0014
 * Time: 13:53
 */

namespace app\vip\controller;

use app\index\controller\Base;

class Totsearch extends Base
{
    public function index()
    {
        if (request()->isAjax()) {
            $limit = request()->get('limit');
            $page = request()->get('page');
            $limit = isset($limit) ? $limit : 20;
            $page = isset($page) ? ($page - 1) * $limit : 0;
            $list['data'] = model('McHotSearch')->getLimit($this->brandId, $page, $limit);
            $list['count'] = model('McHotSearch')->getCount($this->brandId);
            $list['msg'] = '';
            $list['code'] = 0;
            return json($list);
        }
        $this->assign([
                'headinfo'=>[
                    'title'=>'热门搜索'
                ]
            ]);
        return $this->fetch("Totsearch/index");
    }

    /**
     * 新增
     * @return mixed|\think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function add()
    {
        if (request()->isAjax()) {
            $resultData = ['code' => 0, 'msg' => ''];
            $data = [
                'name' => trim(input('post.name', 0)),
                'sort' => intval(input('post.sort', 0)),
                'is_show' => intval(input('post.is_show', 0)),
                'brand_id' => $this->brandId,
            ];

            $res = $this->checkData($data);
            if ($res['code'] != 200) {
                $resultData['msg'] = $res['msg'];
                return json($resultData);
            }

            // 处理数据
            $res = model('McHotSearch')->add($data);

            if ($res) {
                $resultData = ['code' => 200];
            } else {
                $resultData = ['code' => 501, 'msg' => '添加失败'];
            }
            return json($resultData);
        }

        $this->assign([
            'headinfo' => [
                'title' => '添加热门搜索'
            ],
        ]);
        return $this->fetch("Totsearch/add");
    }

    public function edit()
    {
        if (request()->isAjax()) {
            $resultData = ['code' => 0, 'msg' => ''];
            $data = [
                'id' => trim(input('post.id', 0)),
                'name' => trim(input('post.name', 0)),
                'sort' => intval(input('post.sort', 0)),
                'is_show' => intval(input('post.is_show', 0)),
                'brand_id' => $this->brandId,
            ];
            $res = $this->checkData($data, 1);
            if ($res['code'] != 200) {
                $resultData['msg'] = $res['msg'];
                return json($resultData);
            }
            // 处理数据
            $res = model('McHotSearch')->editData($data,$data['id']);
            if ($res === false) {
                $resultData = ['code' => 501, 'msg' => '修改失败'];
            } else {
                $resultData = ['code' => 200];
            }
            return json($resultData);
        }
        $id = intval(input('get.id', 0));
        if ($id < 1) {
            $this->error('参数错误');
        }
        $data = model('McHotSearch', 'model')->getIdData($id, $this->brandId);
        $this->assign('data', $data);
        return $this->fetch("Totsearch/edit");
    }
    /**
     * 验证参数
     * @param $paramData
     * @param $type
     * @return array
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function checkData($paramData, $type = 0)
    {
        $resultData = [
            'code' => 0,
            'msg' => '',
            'data'
        ];

        if (empty($paramData['name'])) {
            $resultData['msg'] = '名称不能为空';
            return $resultData;
        }

        if (mb_strlen($paramData['name'], 'utf-8') > 20) {
            $resultData['msg'] = '名称不能大于20个字';
            return $resultData;
        }

        if ($paramData['sort'] < 1) {
            $resultData['msg'] = '排序错误';
            return $resultData;
        }

        if ($paramData['is_show'] !== 1 && $paramData['is_show'] !== 0) {
            $resultData['msg'] = '启用错误';
            return $resultData;
        }

        if ($type == 1) {
            if ($paramData['id'] < 1) {
                $resultData['msg'] = '参数错误';
                return $resultData;
            }
        }

        $resultData['code'] = 200;
        $resultData['data'] = $paramData;
        return $resultData;
    }


    /**
     * 编辑状态
     * @return array|void
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function editStatus()
    {
        $id = intval(request()->post('id'));
        $status = intval(request()->post('status'));

        $reaultData = [
            'code' => 0,
            'msg' => '',
        ];

        if ($id < 1) {
            $reaultData['code'] = 301;
            $reaultData['msg'] = '参数错误_1';
            return json($reaultData);
        }

        if ($status > 1 || $status < 0) {
            $reaultData['code'] = 302;
            $reaultData['msg'] = '参数错误_2';
            return json($reaultData);
        }

        $status1 = $status ? 0 : 1;

        $res = model('McHotSearch')->editStatus($id, $status1,$this->brandId);
        if ($res !== false) {
            $reaultData['code'] = 200;
            return json($reaultData);
        }

        $reaultData['code'] = 401;
        $reaultData['msg'] = '操作失败';
        return json($reaultData);
    }


    public function del()
    {
        $id = intval(request()->post('id'));
        $reaultData = [
            'code' => 0,
            'msg' => '',
        ];
        if (empty($id)) {
            $reaultData['code'] = 301;
            $reaultData['msg'] = '参数错误';
            return json($reaultData);
        }
        $res = model('McHotSearch')->del($id,$this->brandId);
        if ($res) {
            $reaultData['code'] = 200;
            return json($reaultData);
        }

        $reaultData['code'] = 401;
        $reaultData['msg'] = '操作失败';
        return json($reaultData);
    }


    /**
     * 全部启用
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function allEnabled()
    {
        $data['msg'] = '';
        $data['code'] = 0;
        $idStr = input('post.idStr', 0);
        if (empty($idStr)) {
            $data['msg'] = '参数错误';
            $data['code'] = 301;
            return json($data);
        }

        $McTopicModel = model('McHotSearch');
        $res = $McTopicModel->allEnabled($idStr);
        if($res === false){
            $data['msg'] = '参数错误';
            $data['code'] = 302;
        }else{
            $data['code'] = 200;
        }

        return json($data);
    }


    /**
     * 全部停用
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function allDiscontinuation()
    {
        $data['msg'] = '';
        $data['code'] = 0;
        $idStr = input('post.idStr', 0);
        if (empty($idStr)) {
            $data['msg'] = '参数错误';
            $data['code'] = 301;
            return json($data);
        }

        $McTopicModel = model('McHotSearch');
        $res = $McTopicModel->allDiscontinuation($idStr);
        if($res === false){
            $data['msg'] = '参数错误';
            $data['code'] = 302;
        }else{
            $data['code'] = 200;
        }

        return json($data);
    }
}