<?php
/**
 * 微信助力管理
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: songdemei <songdemei@suxuantech.cn>  2018年02月27日 下午19:54:37
 */
namespace app\vip\controller;
use app\index\controller\Base;
use  think\Db;
use app\common\lib\upload;
class Wxhelp extends Base{
    /**
     * @return \think\response\Json
     */
    function index(){
        $postData =input();
        $starttime = $postData['starttime'];
        $endtime   = $postData['endtime'];
		$where = " ";
		$where1= " ";
		
        $data['count'] = db('wx_help')->where('brand_id',$this->brandId)->where('delete_time',null)->count();
        $limit = input('limit',30);
        $page  = input('page',1);
        $data['data'] = db('wx_help')->where('brand_id',$this->brandId)->where('delete_time',null)->limit($limit)->page($page)->select();
        if(request()->isAjax()){
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        $this->assign([
            'headinfo'=>[
                'title'=>'微信助力活动'
            ]
        ]);
        return $this->fetch();
    }
    public function add(){
        $isPost = request()->isPost();
        $templateId = input('template_id/d');
        if(!$isPost && $templateId){
            //添加一条助力
            $templateInfo = db('wx_help_templates')->find($templateId);
            if(!$templateInfo){
                $this->redirect(url('wxhelp/index'));
                exit();
            }
            $imgSrcArr = explode('.', $templateInfo['bg_image']);
            $imgSrcArr[0] .= '_bg';
            $imgSrc = $imgSrcArr[0].'.'.$imgSrcArr[1];
            $data = [
                'help_name'=>$templateInfo['title'],
                'share_title'=>$templateInfo['title'],
                'share_content'=>$templateInfo['title'],
                'help_img'=>$imgSrc,
                'params'=>$templateInfo['params'],
                'brand_id'=>$this->brandId,
                'staff_id'=>$this->staffId,
                'staff_name'=>$this->staffName,
                'create_time'=>date('Y-m-d H:i:s'),
                'template_code'=>$templateInfo['code'],
            ];
            $res = db('wx_help')->insert($data);
            if($res == false){
                $this->redirect(url('wxhelp/index'));
                exit();
            }
            $id = db('wx_help')->getLastInsID();
            if($id){
                $this->redirect(url('wxhelp/add',['id'=>$id,'step'=>2]));
                //echo '111';
                //exit();
            }
            $this->redirect(url('wxhelp/index'));
            exit();
        }
        $id = input('id/d');
        if($id){
            $step = input('step/d');
            $this->assign('step',$step);
            switch ($step) {
                case '1':
                    # code...
                    return $this->stepOne();
                    break;
                case '2':
                    return $this->stepTwo();
                    break;
                case '3':
                    return $this->stepThree();
                    break;
                case '4':
                    return $this->stepFour();
                    break;
                case '5':
                    return $this->stepFive();
                    break;
                case '6':
                    return $this->stepSix();
                    break;
                default:
                    return $this->stepOne();
                    break;
            }
        }else{
            //添加
            return $this->newHelp();
        }
        
        
    }

    private function newHelp(){
        $templates = db('wx_help_templates')->where('status',1)->select();
        $this->assign('templates',$templates);
        return $this->fetch();
    }
    private function stepOne(){
        $isPost = request()->isPost();
        $id = input('id/d');
        $templateId = input('template_id/d');
        if($isPost && $id && $templateId){
            $template = db('wx_help_templates')->where('status',1)->where('id',$templateId)->find();
            if($template){
                $imgSrcArr = explode('.', $template['bg_image']);
                $imgSrcArr[0] .= '_bg';
                $imgSrc = $imgSrcArr[0].'.'.$imgSrcArr[1];
                $data = [
                    'help_name'=>$template['title'],
                    'help_img'=>$imgSrc,
                    'template_code'=>$template['code'],
                    'award_top_image'=>$template['top_image'],
                    'award_foot_image'=>$template['foot_image'],
                ];
                $res = db('wx_help')->where('id',$id)->update($data);
                if($res === false){
                    $this->ajaxError('保存失败，请重试。');
                }else{
                    action_log($data);      //写日志
                    $this->ajaxSuccess();
                }
            }else{
                $this->ajaxError('无效的模板编号');
            }
            
        }
        $templates = db('wx_help_templates')->where('status',1)->select();
        $this->assign('templates',$templates);
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            $this->redirect(url('wxhelp/index'));
            exit();
        }
        $this->assign('info',$info);
        return $this->fetch('stepone');
    }
    private function stepTwo(){
        $id = input('id/d');
        $isPost = request()->isPost();
        if($isPost && $id){
            $data = [
                'help_name' => input("help_name"),
                'end_time' => date('Y-m-d H:i:s',strtotime(input("end_time"))),
                'status' => input('status'),
                'talk_code' => input("talk_code"),
                'subscribe_rule' => input("subscribe_rule"),
                'sale_rule' => input("sale_rule"),
                'share_title' => input("share_title"),
                'share_content' => input("share_content"),
                'share_score'=>input("share_score"),
            ];
            $res = db('wx_help')->where('id',$id)->update($data);
            if($res === false){
                $this->ajaxError('保存失败，请重试。');
            }else{
                action_log($data);      //写日志
                $this->ajaxSuccess();
            }
            exit();
        }
        $info = db('wx_help')->find($id);
        $info['end_time'] = $info['end_time']?$info['end_time']:date('Y-m-d H:i:s',time()+2592000);
        $this->assign('info',$info);
        return $this->fetch('steptwo');
        
    }
    private function stepThree(){
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            return $this->redirect(url('wxhelp/index'));
        }
        $isPost = request()->isPost();
        if($isPost && $id){
            $data = [
                'help_img'=>input('bg_image'),
                'params'=>input('post_params'),
            ];
            
            $res = db('wx_help')->where('id',$id)->update($data);
            if($res === false){
                $this->ajaxError('保存失败，请重试。');
            }else{
                action_log($data);          //写日志
                $this->ajaxSuccess();
            }

            exit();
        }
        $this->assign('info',$info);
        $size =  strtoupper(getMaxUploadSize());
        $this->assign('size',$size);
        return $this->fetch('stepthree');
    }
    private function stepFour(){
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            return $this->redirect(url('wxhelp/index'));
        }
        $this->assign('info',$info);

        $isPost = request()->isPost();
        if($isPost && $id){
            $existIds = db('wx_help_award')->where('help_id',$id)->column('id');
            /*
            $existList = db('wx_help_award')->where('help_id',$id)->select();
            foreach ($$existList as  $value) {
                # code...
                $existIds[] = $value['id'];
                $existImages[$value['id']] = $value['image'];
            }*/
            $req = request()->param();
            $updateIds = [];
            foreach($req['gifts'] as $k=>$v){
                $data = null;
                $data['award_id'] = (int)$v['award_id'];
                $data['award_type'] = (int)$v['award_type'];
                $data['award_value'] = urldecode($v['award_value']);
                $data['coupon_id'] = (int)$v['coupon_id'];
                $data['rule_type'] = (int)$v['rule_type'];
                $data['rule_value'] = (int)$v['rule_value'];
                $data['pay_amount'] = $v['pay_amount'];
                $data['image'] = $v['image'];
                $data['stock'] = (int)$v['stock'];
                $data['desc'] = urldecode($v['desc']);
                if($data['award_type'] == 1 && !$data['coupon_id']){
                    $this->ajaxError('无效的优惠券编号。');
                }
                if($data['award_id']){
                    if(!in_array($data['award_id'], $existIds)){
                        //如果有奖品ID，表示修改奖品信息，如果ID不在数据库，则报错。
                        $this->ajaxError('无效数据，请刷新页面后重试。');
                    }
                    if(in_array($data['award_id'], $updateIds)){
                        $this->ajaxError('编号重复，请刷新页面后重试。');
                    }
                    $updateIds[] = $data['award_id'];
                    $data['id'] = $data['award_id'];
                    unset($data['award_id']);
                    $updates[] = $data;
                }else{
                    unset($data['award_id']);
                    $data['help_id'] = $id;
                    $data['create_time'] = date('Y-m-d H:i:s');
                    $inserts[] = $data;
                }
            }

            if($req['award_top_image']){
                $dataHelp['award_top_image'] = $req['award_top_image'];
            }
            if($req['award_foot_image']){
                $dataHelp['award_foot_image'] = $req['award_foot_image'];
            }
            db()->startTrans();
            try{
                if($dataHelp){
                    db('wx_help')->where('id',$id)->update($dataHelp);
                }
                foreach((array)$updates as $up){
                    db('wx_help_award')->update($up);
                    unset($existIds[array_search($up['id'], $existIds)]);
                }
                if(!empty($existIds)){
                    db('wx_help_award')->where('id','in',$existIds)->delete();
                    /* //奖品图片不能删除，因为如果删除了，用户已领奖的界面看不到图片了。
                    foreach ($existIds as $delId) {
                        # 删除奖品图片
                        if($existImages[$delId] && file_exists(ROOT_PATH.$existImages[$delId])){
                            @unlink(ROOT_PATH.$existImages[$delId]);
                        }
                    }
                    */
                }
                if(!empty($inserts)){
                    db('wx_help_award')->insertAll($inserts);
                }
                db()->commit();
            }catch(\Exception $e){
                db()->rollback();
                var_dump($e->getMessage());
                $this->ajaxError('更新数据失败，请重试。'.db()->getLastSql());
            }
            action_log($data);      //写日志
            $this->ajaxSuccess('操作成功。');
        }
        
        //获取当前可用优惠券
        $this->assign('coupons',controller('coupon','lib')->getSmallList());
        $this->assign('awards',db('wx_help_award')->where('help_id',$id)->select());
        $size =  getMaxUploadSize();
        $this->assign('size',$size);

        return $this->fetch('stepfour');
    }
    private function stepFive(){
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            return $this->redirect(url('wxhelp/index'));
        }
        $keyword = urldecode(input('keyword'));
        $sort = input('sort_type/d');
        $sort = $sort==1?1:2;
        $pageParams['query']['sort_type'] = $sort;
        if($keyword){
            $pageParams['query']['keyword'] = $keyword;
        }
        $this->assign('sort_type',$sort);
        $this->assign('keyword',$keyword);
        $order = $sort==1?'add_time':'help_num';
        if($keyword){
            $result = Db::name('wx_help_user')->alias('a')
            ->field('a.*,b.rank')
            ->join('(SELECT
  id,
  @rank := @rank + (@prev <> (@prev := help_num)) Rank
FROM
  wx_help_user,
  (SELECT @rank := 0, @prev := -1) init
  where help_id = '.$id.'
  order by help_num desc) b ','b.id = a.id','left')
                ->where('help_id',$id)
                ->where(function($query) use ($keyword){
                    $query->where('phone',$keyword)
                        ->whereOr('nick_name','like','%'.$keyword.'%');
                })
                ->order($order.' desc')
                ->paginate(15,false,$pageParams);
        }else{
            $result = Db::name('wx_help_user')->alias('a')
            ->field('a.*,b.rank')
            ->join('(SELECT
  id,
  @rank := @rank + (@prev <> (@prev := help_num)) Rank
FROM
  wx_help_user,
  (SELECT @rank := 0, @prev := -1) init
  where help_id = '.$id.'
  order by help_num desc) b ','b.id = a.id','left')
                ->where('help_id',$id)
                ->order($order.' desc')
                ->paginate(15,false,$pageParams);
        }
                //$userList = collection($result)->toArray();
        
        foreach($result as $v){
            //var_dump($v);
            $users[] = $v['openid'];
        }
        $this->assign('userList',$result);
        $awardList = db('wx_help_award')->field('id,award_value,award_type')->where('help_id',$id)->select();
        $userAwardList  = db('wx_help_user_award')->where('openid','in',$users)->where('help_id',$id)->select();
        foreach((array)$userAwardList as $userAward){
            $resultWrard[$userAward['openid']][$userAward['award_id']] = $userAward;
        }
        if(input('act') == 'explode'){
            //导出
            
        }
        $this->assign('awardList',$awardList);
        $this->assign('userAwardList',$resultWrard);
        //$this->assign('page',$result->render());
        $this->assign('info',$info);
        return $this->fetch('stepfive');
    }
    private function stepSix(){
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            return $this->redirect(url('wxhelp/index'));
        }
        $qrExpire = time() - strtotime($info['end_time']);
        if($qrExpire > 2592000){
            $qrExpire = 2592000;
        }
        $isPost = request()->isPost();
        $type = input('type/d');
        if($isPost && $type){
            $qrdata = [
                'brandclass_id'=>$this->brandId,
                'type'=>2,//1临时二维码
                'scene'=>$type == 1?'ZL_'.$info['id']:'ZL_'.$info['id'].'_TEST',
                'expire'=>$qrExpire,
            ];
            $qrdata['scene'] = 'brandid'.$this->brandId.'-'.$qrdata['scene'];
            
            $res = sx_call('5a73d4f13a9eb',$qrdata);

            if(!$res['data']['ticket']){
                //var_dump($res);
                $this->ajaxError('生成二维码失败。');
            }else{
                $key = $type == 1?'root_ticket':'test_ticket';
                $data[$key] = $res['data']['ticket'];
            }
            $resDb = db('wx_help')->where('id',$id)->update($data);
            if(!$resDb){
                $this->ajaxError('二维码保存失败。');
            }else{
                $this->ajaxSuccess(array('ticket'=>$res['data']['ticket']));
            }
        }
        $this->assign('info',$info);
        return $this->fetch('stepsix');
    }
    

    /**
     * 更新助力表信息，用于AJAX更新部分字段使用。
     * 
     * @return [type] [description]
     */
    public function update (){
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            return $this->redirect(url('wxhelp/index'));
        }
        $helpImg = input('help_img');
        if(null !== input('help_img')){
            $data = [
            'help_img' => $helpImg,
            ];
            $info['help_img'] = $helpImg;
        }
        $deleteTime = (int)input('delete_time');
        if($deleteTime == 1){
            $data = [
            'delete_time' => date('Y-m-d H:i:s'),
            ];
            $info['delete_time'] = date('Y-m-d H:i:s');
        }
        $arr = db('wx_help')->where('id',$id)->find();
        $res = db('wx_help')->where('id',$id)->update($data);
        if($res === false){
            $this->ajaxError('更新数据失败，请重试。');
        }else{
            action_log($arr);    //写日志
            $this->ajaxSuccess($info);
        }

    }
    public function sendAward(){
        $id = input('id/d');
        $info = db('wx_help')->find($id);
        if(!$info){
            return $this->redirect(url('wxhelp/index'));
        }
        $awardId = input('award_id/d');
        $openId = input('openid');
        $userAward = db('wx_help_user_award')
                    ->where('help_id',$id)
                    ->where('award_id',$awardId)
                    ->where('openid',$openId)
                    ->find();
        if(!$userAward){
            $this->ajaxError('未找到此用户奖品');
        }
        if($userAward['status'] == 2){
            $this->ajaxError('此人奖品已发放');
        }elseif ($userAward['status'] == 3) {
                # code...
            $this->ajaxError('此用户还未完成支付， 不能发放奖品。');
        }else{
            $data = [
                'status'=>2,
                'send_time'=>date('Y-m-d H:i:s'),
            ];
            $res = db('wx_help_user_award')->where('id',$userAward['id'])->update($data);
            if($res === false){
                $this->ajaxError('发放失败，请重试。');
            }else{
                $this->ajaxSuccess(array('send_time'=>$data['send_time']));
            }
        }
    }
    public function showUserList(){
        $id = input('id/d');
        if(!$id){
            $this->redirect('/vip/wxextend/index');
        }
        $this->assign('id',$id);
        

        if(request()->isAjax()){
            $data['count'] = db('wx_extend_detail')->where('extend_id',$id)->count();
            $limit = input('limit',30);
            $page = input('page',1);
            $data['data']  =db('wx_extend_detail')->where('extend_id',$id)->limit($limit)->page($page)->select();
            foreach($data['data'] as $k=>$v){
                $data['data'][$k]['ticket'] = urlencode($v['ticket']);
            }
            $data['msg']   = '';
            $data['code']  = 0;
            return json($data);
        }
        //$this->assign('data',$data);



        return $this->fetch();

    }
    
    public function ajaxSuccess($data=[],$msg='操作成功'){
        $ret = [
            'code'=>200,
            'msg'=>$msg,
            'data'=>$data,
        ];
        exit(json_encode($ret));
    }

    public function ajaxError($msg='系统发生错误',$code=500){
        $ret = [
            'code'=>$code,
            'msg'=>$msg,
            'data'=>[],
        ];
        exit(json_encode($ret));
    }
    public function upFile(){
        //上传文件类型：1奖品图片2模板背景图片
        $type = input('type');
        $type = $type?$type:1;
        $config = [
            'module'=>'wxhelp',
            'sub_directory'=>'upfiles',
        ];
        if($type == 2){
            $config['sub_directory'] = 'templates';
        }
        if($type == 1){
            $config['sub_directory'] = 'gifts';
        }
        $upload = new upload($config);
        $res = $upload->upFile($_FILES,true);
        if($res === false){
            $this->ajaxError('上传失败，错误编号：'.$upload->errid.';错误信息：'.$upload->error);
        }else{
            $this->ajaxSuccess(array('src'=>$res));
        }
    }



}