<?php
/**
 * 活动报名和获取报价增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\AActivitySignUp;
use app\index\controller\Base;
use PHPExcel_IOFactory;
use PHPExcel;
class Activitysignup extends Base{

    /**
    * 方法描述: 所有数据
    * @param  string $c 是查询条件
    * @return mixed
    * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
    */
    public function getlistnew($c){
        $limit    = isset($c['limit'])?$c['limit']:10;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        //$w = ['s.b_type'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                // $w['q.brandid'] = $this->brandId;
                $ws['q.brandid'] = $this->brandId;
            }
        }
        if($c['activityid']){
            $w['q.activityid'] = $c['activityid'];
        }
        if($c['linkcode']){
            $w['s.activity_link'] = $c['linkcode'];
        }
        if($c['share_userid']){
            $w['s.share_userid'] = $c['share_userid'];
        }
        //$d = AActivitySignUp::alias('s')
        if($c['type'] == "step"){
            $d = db("a_activity_share_qr")->alias('q')
                ->where($w)
                ->where('a.brandid',$this->brandId)
                //->where($ws)
                ->field('s.userid,s.b_type,s.create_time,a.title,u.username,s.b_content,u.phone,q.id,s.check_name,s.activityid,s.b_username,s.b_phone,s.wename,s.photo_type,s.shopid,s.status,s.b_time,s.check_userid,s.check_time,s.update_time,s.ext_data,s.share_num,s.fission_num,s.parent_id,s.parent_ids,s.site,s.share_userid,q.staff_name,q.staff_id,count(s.id) as shares_num,q.userid as quserid,s.shop_name,s.baby_birthday')
                ->join('a_activity_sign_up s','s.share_userid=q.userid and s.activityid=q.activityid','left')
                ->join('__A_ACTIVITY_LIST__ a','a.id=q.activityid','left')
                ->join('__M_USERS__ u','u.id=q.userid','left')
                ->order("s.create_time desc")
                ->limit($pagenum,$limit)
                ->group('q.id')
                ->select();
        }else{
            $d = db("a_activity_sign_up")->alias('s')
                ->where($w)
                ->where('a.brandid',$this->brandId)
                ->field('s.userid,s.b_type,s.create_time,a.title,u.username,s.b_content,u.phone,s.id,s.check_name,s.activityid,s.b_username,s.b_phone,s.wename,s.photo_type,s.shopid,s.status,s.b_time,s.check_userid,s.check_time,s.update_time,s.ext_data,s.share_num as shares_num,s.fission_num,s.parent_id,s.parent_ids,s.site,s.share_userid,q.staff_name,q.staff_id,s.shop_name,s.baby_birthday')
                ->join('__A_ACTIVITY_LIST__ a','a.id=s.activityid','left')
                ->join('__M_USERS__ u','u.id=s.userid','left')
                ->join('a_activity_share_qr q','s.share_userid=q.userid and s.activityid=q.activityid','left')
                ->order("create_time desc")
                ->limit($pagenum,$limit)
                ->select();
        }
        $data = db('a_activity_sign_up')->where('brandid',$this->brandId)->select();
        foreach($d as $k=>$v){
            if($v['parent_id'] != 0 && !empty($v['parent_ids'] && empty($v['share_staffid']))){
                foreach($data as $k2=>$v2){
                    if(strpos($v['parent_ids'],',')){
                        if(explode(',',$v['parent_ids'])[0] == $v2['userid'] && $v['activityid'] == $v2['activityid']){
                            $d[$k]['parent_name'] = $v2['staff_name'];
                        }
                    }else{
                        if($v['parent_ids'] == $v2['userid'] && $v['activityid'] == $v2['activityid']){
                            $d[$k]['parent_name'] = $v2['staff_name'];
                        }
                    }
                    
                }
            }
        }
        return $d;
    }

    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:10;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = ['s.b_type'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        if($c['activityid']){
            $w['s.activityid'] = $c['activityid'];
        }
        if($c['linkcode']){
            $w['s.activity_link'] = $c['linkcode'];
        }
       
        //$d = AActivitySignUp::alias('s')
        $d = db("a_activity_sign_up")->alias('s')
            ->where($w)
            ->field('s.b_type,s.create_time,a.title,u.username,s.b_content,u.phone,s.id,s.check_name,s.activityid,s.b_username,s.b_phone,s.wename,s.photo_type,s.shopid,s.status,s.b_time,s.check_userid,s.check_time,s.update_time,s.ext_data,s.share_num,s.fission_num,s.parent_id,s.parent_ids,s.site')
            ->join('__A_ACTIVITY_LIST__ a','a.id=s.activityid','left')
            ->join('__M_USERS__ u','u.id=s.userid','left')
            ->order("create_time desc")
            ->limit($pagenum,$limit)
            ->select();
        $data = db('a_activity_sign_up')->where('brandid',$this->brandId)->select();
        foreach($d as $k=>$v){
            if($v['parent_id'] != 0 && !empty($v['parent_ids'])){
                foreach($data as $k2=>$v2){
                    if(strpos($v['parent_ids'],',')){
                        if(explode(',',$v['parent_ids'])[1] == $v2['id']){
                            $d[$k]['parent_name'] = $v2['b_username'];
                        }
                    }else{
                        if($v['parent_ids'] == $v2['id']){
                            $d[$k]['parent_name'] = $v2['b_username'];   
                        }
                    }
                    
                }
            }
        }
        return $d;
    }

    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getGetMoneyList($c){
        $limit    = isset($c['limit'])?$c['limit']:10;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['u.brandid'] = $this->brandId;
            }
        }
        
        $d = AActivitySignUp::alias('s')
            ->where($w)
            ->field('s.shop_name,s.b_type,s.create_time,u.username,u.phone,s.id,s.check_name,s.activityid,s.b_username,s.b_phone,s.wename,s.photo_type,s.shopid,s.status,s.b_time,s.check_userid,s.check_time,s.update_time')
            ->join('__M_USERS__ u','u.id=s.userid','left')
            ->where('s.b_type','=',2)
            ->select();
        return $d;
    }
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCountnew($c){
        //$w = ['s.b_type'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        
        if($c['share_userid']){
            $w['s.share_userid'] = $c['share_userid'];
        }
        if($c['type'] == "step"){
            if($c['activityid']){
                $w['q.activityid'] = $c['activityid'];
            }
            // $w['s.parent_ids'] = null;
            // $count = db("a_activity_share_qr")->alias('q')
            //     ->where($w)
            //     ->field('s.userid,s.b_type,s.create_time,a.title,u.username,s.b_content,u.phone,s.id,s.check_name,s.activityid,s.b_username,s.b_phone,s.wename,s.photo_type,s.shopid,s.status,s.b_time,s.check_userid,s.check_time,s.update_time,s.ext_data,s.share_num,s.fission_num,s.parent_id,s.parent_ids,s.site,s.share_userid,q.staff_name,q.staff_id,count(s.id) as shares_num,s.shop_name')
            //     ->join('a_activity_sign_up s','s.share_userid=q.userid and s.activityid=q.activityid','left')
            //     ->join('__A_ACTIVITY_LIST__ a','a.id=q.activityid','left')
            //     ->join('__M_USERS__ u','u.id=q.userid','left')
            //     ->order("create_time desc")
            //     ->limit($pagenum,$limit)
            //     ->group('q.id')
            //     ->count();

            $count = db("a_activity_share_qr")->alias('q')
                ->where($w)
                ->join('a_activity_sign_up s','s.share_userid=q.userid and s.activityid=q.activityid','left')
                ->join('__A_ACTIVITY_LIST__ a','a.id=q.activityid','left')
                ->join('__M_USERS__ u','u.id=q.userid','left')
                ->count();
        }else{
            if($c['activityid']){
                $w['s.activityid'] = $c['activityid'];
            }
            $count = AActivitySignUp::alias('s')
                ->where($w)
                ->join('a_activity_list a','a.id=s.activityid')
                ->count('s.id');
        }
        return  $count;
    }
    public function getCount($c){
        $w = ['s.b_type'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        if($c['activityid']){
            $w['s.activityid'] = $c['activityid'];
        }
        return  AActivitySignUp::alias('s')
                ->where($w)
                ->join('a_activity_list a','a.id=s.activityid')
                ->count('s.id');
    }

    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getGetMoneyCount($c){
        $w = ['s.b_type'=>2];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['u.brandid'] = $this->brandId;
            }
        }
        return  AActivitySignUp::alias('s')
            ->where($w)
            ->join('m_users u','u.id=s.userid')
            ->count('s.id');
    }
    /**
     * 获取一条信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
        if(!$id){
            return false;
        }else{
            $res = AActivitySignUp::alias('a')
            ->where('a.id='.$id)
            ->field('n.title as couponname,n.img,a.id,a.title,a.start_time,a.index_img,a.scontent,a.content,a.end_time,a.couponid,a.view_total,a.status,a.share_score,a.order_num')
            ->join('__C_COUPON_NUM__ n','n.id=a.couponid','left')
            ->find();
            if($res){
                return $res;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;  
        }else{
            $res = AActivitySignUp::update(['status'=>$status],['id'=>$id]);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $hasdata = AActivitySignUp::where('id='.$id)->count();
            if($hasdata){
                $res = AActivitySignUp::destroy($id);
                if($res){
                    return $this->success('恭喜：删除成功了');
                }else{
                    return $this->error('无法获取您要操作的数据');
                
                }
            }
        }
    }
    

    /**
     * 方法描述: 今天天的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTodayList($c){
        $currenttime = time();
        $starttime   = date('Y-m-d',$currenttime+86400);
        $endtime     = date('Y-m-d',$currenttime);
        $w = [
            's.create_time' => [
                ['<=',$starttime],
                ['>', $endtime],
            ]
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        $data = AActivitySignUp::alias('s')
                        ->where($w)
                        ->field('s.status,s.userid')
                        ->join('a_activity_list a','a.id=s.activityid')
                        ->select();
        return $data;
    }
    

    /**
     * 方法描述: 获取最近一周的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getWeekList($c){
       $w = [];
       if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['a.brandid'] = $this->brandId;
            }
        }
        $data = [];
        for($i=6;$i>=0;$i--){
            $currenttime = time();
            $starttime   = date('Y-m-d',$currenttime+86400-$i*86400);
            $endtime     = date('Y-m-d',$currenttime-$i*86400);
            $w['s.create_time'] = [
                    ['<=',$starttime],
                    ['>', $endtime],
            ];
            $data[$endtime] = AActivitySignUp::alias('s')->where($w)
            ->join('a_activity_list a','a.id=s.activityid')
            ->count();
        }
        return $data;
    }
    
    //导出
    public function export($title,$data,$file){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称
        $index = 1;
        for($i=0;$i<count($title);$i++){
            switch ($title[$i]) {
                case '报名活动':
                    $width = 32;
                    break;
                case '报名姓名':
                    $width = 20;
                    break;
                case '报名电话':
                    $width = 15;
                    break;
                case '报名时间':
                    $width = 20;
                    break;
                case '处理时间':
                    $width = 20;
                    break;
                case '推荐人':
                    $width = 15;
                    break;
                case '会员昵称':
                    $width = 30;
                    break;
                default:
                    $width = 10;
                    break;
            }
            $range[$i] = $this->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
            $PHPSheet->getColumnDimension($range[$i])->setWidth($width);
        }
        // var_dump($data);
        // exit;
        if(count($data)>0){
            foreach($data as $k=>$v){
                if($v['site']) {
                    $v['site'] = $v['site']==1?'朝阳店':'丰台店';
                }
                if($v['parent_id'] == "0"){
                   $v['parent_id'] = ''; 
                }
                if($v['status'] || $v['status'] == 0) {
                    $v['status'] = $v['status']==1?'已处理':'未处理';
                }
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }
        
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        //header("Content-type:text/html;charset=utf-8");
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$file);//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();

        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }

}