<?php
/**
 * 活动增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\AActivityList;
use app\vip\model\AActivityLink;
use app\vip\model\AActivityVisit;
use app\index\controller\Base;
use think\Model;

class Ai extends Base{

    /*
         * 获取配置信息及签名
         */
    public function getConfig(){
        $email = config('AI_email'); //系统设置
        $secretKey = config('AI_secretKey'); //系统设置

        if(!$email||!$secretKey){
            return array('code'=>501,'msg'=>'未设置AI配置文件信息，请联系管理员');
        }
        $timestamp = time();
        $sign = sha1($email.'&'.$secretKey.'&'.$timestamp);

        return ['code'=>200,'email'=>$email,'secretKey'=>$secretKey,'timestamp'=>$timestamp,'sign'=>$sign];
    }

    /*
     * 向AI外呼任务 导入客户信息
     */
    public function importCustomerToAi($customerData,$outboundTaskId){
        /*
         *## 请求地址
          POST /v1/autoCallTasks/syncNumber

         * ## 请求参数
        | 参数  | 类型 | 是否可空 | 描述
        |timestamp|Long|false|时间戳(例:当前秒数，1533092860)
        |sign|String|false|签名:身份认证签名(DigestUtils.sha1Hex(email&secretKey&timestamp))
        |email|String|false|邮箱
        |outboundTaskId|int|false|任务ID
        |numberList|Array|false|号码数组
        |numberList[].name|String|false|姓名
        |numberList[].mobile|String|false|号码
        |numberList[].remark|String|true|备注
        |numberList[].variates|Array|true|自定义变量(格式:[{"key":"weather","type":"string","value":"北京"}])
         */

        //获取配置信息
        $config = $this->getConfig();
        if($config['code'] !== 200){
            return $config;
        }

        //调用接口地址及参数
        $url = 'https://crm.udesk.cn/api/v1/autoCallTasks/syncNumber?email='.$config['email'].'&timestamp='.$config['timestamp'].'&sign='.$config['sign'];

        $params = [
            'outboundTaskId' => $outboundTaskId,
            'numberList' => $customerData
        ];

        $result=http_request($url,'POST',json_encode($params),array('Content-Type: application/json'));
        $res=json_decode($result['response'],true);

        if($res['code'] == 200){

            $successCount = $res['successCount'];//成功条数
            $failedCount  = $res['failedCount'];//成功条数
            $failedNumberList  = $res['failedNumberList'];//失败数据
            return array('code'=>200,'successCount'=>$successCount,'failedCount'=>$failedCount,'failedNumberList'=>$failedNumberList);
        }else{
            return array('code'=>201,'msg'=>'请求向AI外呼任务中导入客户接口失败');
        }

    }

    /*
     * 获取AI外呼任务列表接口
     */
    public function getTaskList(){
        $config = $this->getConfig();
        if($config['code'] !== 200){
            return $config;
        }

        $url = 'https://crm.udesk.cn/api/v1/autoCallTasks?email='.$config['email'].'&timestamp='.$config['timestamp'].'&sign='.$config['sign'];

        $params = [
            'pageNum' => 1,
            'pageSize' => 100,
            'name' => '时尚',
            'status' => 1,

        ];

        $result=http_request($url,'GET',json_encode($params));
        $res=json_decode($result['response'],true);

        if($res['code'] == 200){
            $list = $res['data'];
            return array('code'=>200,'data'=>$list);
        }else{
            return array('code'=>201,'msg'=>'请求AI外呼任务列表接口失败');
        }

    }
}