<?php
/**
 * 投诉建议的类控制器
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月23日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\UserCommend;
use app\index\controller\Base;

class Commend extends Base{
    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = ['c.typeid'=> $c['typeid']?$c['typeid']:1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['c.brandid'] = $this->brandId;
            }
        }
        return UserCommend::alias('c')->where($w)
        ->field('c.id,c.userid,c.title,c.content,c.status,c.check_user,c.create_time,c.update_time,c.imgs,m.username,m.phone')
        ->join('__M_USERS__ m','m.id=c.userid','left')
        ->limit($pagenum,$limit)
        ->order('status asc,c.create_time desc')
        ->select();
    }
    
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        $w = ['typeid'=> $c['typeid']?$c['typeid']:1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return UserCommend::where($w)->count('id');
    }
    
    /**
     * 方法描述: 获取今天的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTodayList($c){
        $w = [
            'create_time' => [
                ['>=',date('Y-m-d',time())],
                ['<', date('Y-m-d',time()+86400)],
            ]
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return UserCommend::where($w)->field('userid,typeid,status,id')->select();
    }
    
    /**
     * 方法描述: 获取最近一周的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getWeekList($c){
        $w    = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $data = [];
        for($i=6;$i>=0;$i--){
            $currenttime = time();
            $starttime   = date('Y-m-d',$currenttime+86400-$i*86400);
            $endtime     = date('Y-m-d',$currenttime-$i*86400);
            $w['create_time'] = [
                                    ['<=',$starttime],
                                    ['>', $endtime],
                                ];
            $w['typeid']  =  1;
            $data['complaint'][$endtime]  = UserCommend::where($w)->count();
            $w['typeid']  =  2;
            $data['proposal'][$endtime] = UserCommend::where($w)->count();
        }
        return $data;
    }
    
    /**
     * 获取一条信息处理方法
     * @param array $c 查询的条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
        if(!id){
            return false;
        }else{
            $w = ['c.id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['c.brandid'] = $this->brandId;
                }
            }
            $d = UserCommend::alias('c')
            ->where($w)
            ->field('u.username,u.phone,c.imgs,c.id,c.title,c.status,c.create_time,c.content,c.check_user,c.update_time')
            ->join('__M_USERS__ u','u.id=c.userid','left')
            ->find();
             $d['imgs'] = $d['imgs']?explode(',',$d['imgs']):'';
            return $d;
        }
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id 
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;  
        }else{
            $w = ['id' =>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $d = ['check_user'=>$this->staffName,'status'=>$status,'update_time'=>date('Y-m-d H:i:s',time())];
            $res = UserCommend::where($w)->update($d);
            return $res!==false?true:false;
        }
    }
    
    /**
     * 删除一条投诉建议记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $w = [];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $model   = new UserCommend();   
            $data = $model->where($w)->find($id);
            if($data){
                $res = $model->destroy($id);
                return $res!==false?true:false;
            }else{
                return false;
            }
        }
    }
}