<?php
/**
 * 优惠券增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\CCouponNum;
use app\vip\model\CCouponList;
use app\vip\model\CCouponType;
use think\Controller;
use app\index\controller\Base;


class Coupon extends Base{
    
    /**
     * 方法描述: 获取优惠券所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c,$type){
        // 获取优惠券
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['c.brandid'] = $this->brandId;
            }
        }
        if(!$type){
            $d = CCouponNum::alias('c')->where($w)
            ->field('t.name as typename,c.id,c.title,c.img,c.money,c.discount_type,c.expire_time,c.coupon_num,c.start_time,c.end_time,c.min_consume,c.status,c.total_num,c.receive_total,c.each_max_total,c.order_num')
            ->join('__C_COUPON_TYPE__ t','t.id=c.coupon_typeid','left')
            ->limit($pagenum,$limit)
            ->select();   
        }else{
            $d = db('c_coupon_num')->where("brandid",$this->brandId)
            ->select();    
        }
        
        return $d;
    }
    
    /**
     * 方法描述: 获取优惠券简单的所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月23日 下午3:04:46
     */
    public function getSmallList(){
        $w = ['status'=>1];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = CCouponNum::where($w)->field('id,title,img')->select();
        return $d;
    }
    
    
    /**
     * 方法描述: 获取优惠券数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCouponCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return CCouponNum::where($w)->count('id');
    }
    
    
    
    /**
     * 方法描述: 获取优惠券分类数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCouponType(){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return CCouponType::where($w)->select();
    }
    
    /**
     * 添加优惠券批次处理方法
     * @param array $d 数据数组
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $model = new CCouponNum;
           $d['brandid'] = $this->brandId;
           $d['create_user'] = $this->staffName;
           $res = $model->save($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 修改优惠券批次处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function edit($d){
        if(!$d || !$d['id']){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            unset($d['id']);
            $res = CCouponNum::where($w)->update($d);
            if($res!==false){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 获取一条优惠券批次信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = CCouponNum::where($w)->find();
            if($res){
                return $res;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 设置一个优惠券批次号状态处理方法
     * @param int $id 优惠券批次号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            $this->error("无法找到您要操作的数据");
            return;
        }else{
            $status = $status==1?0:1;
            
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $d = ['status'=>$status];
            $model = new CCouponNum;
            $res = $model->where($w)->save($d);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 设置一个优惠券批次号状态处理方法
     * @param int $id 优惠券批次号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            $this->error("无法找到您要操作的数据");
            return;
        }else{
            $w = ['coupon_num_id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $hasreceive = CCouponList::where($w)->count();
            if($hasreceive){
                return $this->error('此优惠券已经被领取了，不可删除');
            }else{
                $model = new CCouponNum;
                $res = $model->destroy($id);
                if($res){
                    return true;
                }else{
                    return false;
                
                }
            }

        }
    }

    /**
     * 方法描述： 获取优惠券领取的详情列表
     * @param array $c 条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:47:22
     */
    public function getReceiveDetailList($c){
        $page = $c['page'] ? $c['page'] : 1;
        $limit = $c['limit'] ? $c['limit'] : 10;


        if(!$c){
            return false;
        }

        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['n.brandid'] = $this->brandId;
            }
        }
        if($c['id']){
            $w['c.coupon_num_id'] = $c['id'];
        }
        if($c['searchtypeid'] && $c['searchkey']){
              if($c['searchtypeid']==1){
                  $w['u.username'] = $c['searchkey'];
              }else if($c['searchtypeid']==2){
                  $w['u.phone'] = $c['searchkey'];
              }else{
                  $w['c.coupon_code'] = $c['searchkey'];
              }
        }

        $sql = '1=1 ';
        if($c['expire_time_start']){
            $sql .= ' and c.expire_time >= "'.$c['expire_time_start'].'"';
        }

        if($c['expire_time_end']){
            $sql .= ' and c.expire_time < "'.$c['expire_time_end'].'"';
        }

        if($c['all'] == 1){
            $d = db("c_coupon_list")->alias('c')
                ->where($w)
                ->where($sql)
                ->field('n.title,c.coupon_code,c.discount_type,c.discount_value,u.username,u.phone,c.expire_time,c.create_time,c.update_time,c.check_user,c.userid,c.id,c.shopid,c.coupon_num_id,c.status,c.use_time')
                ->join('__M_USERS__ u','u.id=c.userid','left')
                ->join('__C_COUPON_NUM__ n','n.id=c.coupon_num_id','left')
                ->join('__C_COUPON_TYPE__ t','t.id=n.coupon_typeid','left')
                ->select();
        }else{
            $d = db("c_coupon_list")->alias('c')
                ->where($w)
                ->where($sql)
                ->field('n.title,c.coupon_code,c.discount_type,c.discount_value,u.username,u.phone,c.expire_time,c.create_time,c.update_time,c.check_user,c.userid,c.id,c.shopid,c.coupon_num_id,c.status,c.use_time')
                ->join('__M_USERS__ u','u.id=c.userid','left')
                ->join('__C_COUPON_NUM__ n','n.id=c.coupon_num_id','left')
                ->join('__C_COUPON_TYPE__ t','t.id=n.coupon_typeid','left')
                ->page($page,$limit)
                ->select();
        }

        return $d;
    }

    /**
     * 方法描述: 获取领取一个优惠券数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getReceiveCouponCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['n.brandid'] = $this->brandId;
            }
        }
        if($c['id']){
            $w['c.coupon_num_id'] = $c['id'];
        }
        if($c['searchtypeid'] && $c['searchkey']){
              if($c['searchtypeid']==1){
                  $w['u.username'] = $c['searchkey'];
              }else if($c['searchtypeid']==2){
                  $w['u.phone'] = $c['searchkey'];
              }else{
                  $w['c.coupon_code'] = $c['searchkey'];
              }
        }

        $sql = '1=1 ';
        if($c['expire_time_start']){
            $sql .= ' and c.expire_time >= "'.$c['expire_time_start'].'"';
        }

        if($c['expire_time_end']){
            $sql .= ' and c.expire_time < "'.$c['expire_time_end'].'"';
        }

        $d = db("c_coupon_list")->alias('c')
            ->where($w)
            ->where($sql)
            ->field('u.username,u.phone,n.title,c.discount_type,c.discount_value,c.expire_time,c.create_time,c.update_time,c.check_user,c.userid,c.id,c.shopid,c.coupon_num_id,c.coupon_code,c.status,c.use_time')
        ->join('__M_USERS__ u','u.id=c.userid','left')
        ->join('__C_COUPON_NUM__ n','n.id=c.coupon_num_id','left')
        ->count('c.id');
        return $d?$d:false;
    }
    
    /**
     * 方法描述： 领取优惠券，并生成优惠码入库
     * @param  array $d 数据userid和coupounum优惠券批次号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月17日 下午12:47:22
     */
    public function getReceive($d){
        $model = new CCouponNum();
        // 查询优惠券批次信息
        $data  = $model->where(['coupon_num'=>$d['coupon_num']])->find();
        if($data && ($data['total_num'] - $data['receive_total'])>0){
            
            // 判断每人可领取的数量
            if($data['each_max_total']!==0){
                // 查询用户是否已经领取
                $alreadyReceive  = CCouponList::where(['coupon_num'=>$d['coupon_num'],'userid'=>$d['userid']])->count();
                if($alreadyReceive && $alreadyReceive >= $data['each_max_total']){
                    return json(['status'=>0,'msg'=>'您已经领取过了,不可以在领取了,去使用吧']);
                }
            }
          
            // 生成优惠券码,随机取8位+时间戳后几位,去掉4和7的数据
            $str = 'ABCDEFGHJKMNPQRSTUVWXYZ0125689';
            $couponid = substr(str_shuffle($str),0,8).''.substr(time(),5);
            $couponid = preg_replace('/4|7/',8, $couponid);
            $newdata  = [
                'userid'     => $d['userid'],
                'coupon_num' => $d['coupon_num'],
                'coupon_code'   => $couponid,
                'create_time'=> date('Y-m-d H:i:s',time()),
            ];
            
            // 插入数据库，更新list表和couponnum表
            $res = CCouponList::create($newdata);
            $upcouponnum = $model->where('id='.$data['id'])->update(['receive_total'=> $data['receive_total']+1]);
            return $upcouponnum!==false && $res?json(['status'=>1,'msg'=>'成功','id'=>$couponid]):json(['status'=>0,'msg'=>'失败']);
        }
        return false;
    }

    /**
     * 方法描述     设置一个优惠券状态处理方法
     * @param  array $d 要修改的数据,必须有id,status,可有shopid单元
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setCouponStatus($d){
        if(!$d || !$d['id']){
            return false;
        }else{
            $model = new CCouponList;
            $d= [
                'id'          => $d['id'],
                'status'      => $d['status'],
                'check_user'  => $this->staffName,
                'update_time' => date('Y-m-d H:i:s',time()),
            ];
            $res = $model->update($d);
            return $res!==false?true:false;
        }
    }


}