<?php
/**
 * 优惠券类型增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月16日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\CCouponType;
use app\index\controller\Base;

class Coupontype extends Base{
    
    /**
     * 方法描述:获取优惠券类别列表
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = CCouponType::where($w)->limit($pagenum,$limit)->select();
        return $d;
    }
    
    /**
     * 方法描述     获取优惠券类别总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getTypeCount(){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return CCouponType::where($w)->count('id');
    }
    
    
    /**
     * 添加优惠券类别方法
     * @param array $d 数据
     * @return bool 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $d['brandid'] = $this->brandId;
           $model = new CCouponType;
           $res = $model->save($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 修改优惠券类型方法
     * @param array $d 数据数组
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function edit($d){
        if(!$d || !$d['id']){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $isdata = CCouponType::where($w)->find();
            if($isdata){
                $res = CCouponType::update($d);
                if($res!==false){
                    return true;
                }
                return false;
            }else{
                return false;
            }
        }
    }
 

    /**
     * 软删除优惠券类别
     * @param int $id 优惠券批次号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $model = new CCouponType;
            $res = $model->destroy($id);
            if($res){
                return true;
            }else{
                return false;
                
            }
        }
    }
    
    
    
}