<?php
/**
 * 活动增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Wangyining <wangyining@suxuantech.cn>  2018-5-21 13:14:21
 */
namespace app\vip\lib;
use app\index\controller\Base;
use think\Session;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;

class Disposemoney extends Base{
    public function getList($postData){
        /*
         * 获取提现列表
         */
        $brandId  = Session::get('brandid');
        $limit    = isset($postData['limit'])?$postData['limit']:5;
        $pagenum  = isset($postData['page'])?($postData['page']-1)*$limit:1;

        $sql = $this->getSql($postData);

        $data = db('m_withdraw_log')
            ->alias('a')
            ->join('m_withdraw b','a.userid = b.userid')
            ->where('a.brandid',$brandId)
            ->where($sql)
            ->field('a.get_time,a.money_status,a.get_money,a.error_state,a.staff_name,a.exe_time,b.bank_code,b.user_number,b.user_true_name')
            ->limit($pagenum,$limit)
            ->select();

        if($data){
            return $data;
        }
    }


    /*
     * 获取列表总数
     */
    public function getCount($postData){
        $brandId  = Session::get('brandid');
        $sql = $this->getSql($postData);
        $count = db('m_withdraw_log')
            ->alias('a')
            ->join('m_withdraw b','a.user_phone_id = b.user_phone_id')
            ->where('a.brandid',$brandId)
            ->where($sql)
            ->count();
        return $count;
    }

    public function getSql($postData){
        $start_time = $postData['start_time'];
        $endtime   = $postData['end_time'];
        $end_time   = date("Y-m-d",strtotime("$endtime +1 day"));
        $money_status = $postData['money_status'];

        $sql = ' 1 = 1 ';
        if($start_time)      $sql .= " and a.get_time >='".$start_time."' ";
        if($end_time)        $sql .= " and a.get_time <'".$end_time."' ";
        if($money_status)    $sql .= " and a.money_status = '".$money_status."' ";
        return $sql;
    }

    //导出
    function export($title,$data,$file){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }
        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称
        for($i=0;$i<count($title);$i++){
            $PHPSheet->setCellValueExplicitByColumnAndRow($i,1, $title[$i]);
        }
        if(count($data)>0){
            foreach($data as $k=>$v){
                switch ($v['money_status']) {
                    case 1:
                        $v['money_status'] = '提现成功';
                        break;
                    case 2:
                        $v['money_status'] = '处理中';
                        break;
                    case 3:
                        $v['money_status'] = '提现失败';
                        break;
                    default:
                        $v['money_status'] = '-';
                        break;
                }
                // if($v['bank_code']){
                //     $v['bank_code'] = ' '.$v['bank_code'];
                //     $v['user_number'] = ' '.$v['user_number'];
                // }
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValueExplicitByColumnAndRow($kk,$k+2,$vv);
                }
            }
            $PHPSheet->setCellValueExplicitByColumnAndRow(0,$k+3,"备注");
            $PHPSheet->setCellValueExplicitByColumnAndRow(1,$k+3,"1.打款完成后，请在最后一列：打款结果列，填上打款结果，打款成功请填写“成功”，打款错误请填其它。");
            $PHPSheet->setCellValueExplicitByColumnAndRow(1,$k+4,"2.导入打款结果时， 确保客户ID列不能缺失。");
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        //header("Content-type:text/html;charset=utf-8");
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$file);//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;

    }

    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();

        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }

    //上传excel文件
    function uploadExcel($file,$file_name){

        $info = $file->validate(['ext' => 'xlsx'])->move(ROOT_PATH . 'public' . DS . 'excel');//上传验证后缀名,以及上传之后移动的地址
        if ($info) {

            $exclePath = $info->getSaveName();  //获取文件名
            $file_url = ROOT_PATH . 'public' . DS . 'excel' . DS . $exclePath;   //上传文件的地址

            $dir='../public/excel/error';
            if (!is_dir($dir)){
                mkdir($dir);
            }

            $excel_file['file_name'] = $file_name;
            $excel_file['file_url']  = $file_url;
            $excel_file['brandid']   = session('brandid');
            $excel_file['staff_id']  = session('staff_id');
            $excel_file['staff_name'] = session('staffname');
            $excel_file['addtime']    = date('Y-m-d H:i:s',time());
            $excel_file['excel_type'] = 2;

            db()->startTrans();//开启事务
            try {
                $id=db('c_excel_import')->insertGetId($excel_file);
                db()->commit();
            } catch (Exception $e) {
                db()->rollback();
            }

            $message['body']['file_url']=$file_url;
            $message['body']['eid']=$id;
            $message['body']['staff']=array('staff_id'=>session('staff_id'),'staff_name'=>session('staff_name'),'staff_number'=>session('staff_number'),'shop_name'=>session('shop_name'),'shop_code'=>session('shop_code'),'brand_id'=>session('brand_id'),'brandclass'=>session('brandclass'));

            controller('RunImportMoney','lib')->importMoney($message['body']);
            //push_list("vip_excelImportMoney", $message);
            $this->success('文件上传成功',"/",$file_name);

        } else {
            echo $file->getError();
        }
    }


    //生成错误文件
    function cusFailFile($fail_file){
        $PHPExcel = new PHPExcel();
        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称

        $title=array('打款编号','会员卡号','提现人姓名','提现金额','银行卡号','提现时间', '是否打款','错误原因');

        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }
        if(count($fail_file['fail_array'])>0){
            foreach($fail_file['fail_array'] as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        $file_url = ROOT_PATH . 'public' . DS . 'excel';
        $file_name=$file_url."/error/".'error'.$fail_file['eid'].'.xlsx';
        $PHPWriter->save($file_name);
        return $file_name;
    }


}