<?php
/**
 * 用户推荐管理
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Zhaojiepeng<zhaojiepeng@suxuantech.cn>  2018年04月10日 10:36:38
 */
namespace app\vip\lib;
use app\vip\model\GGroupbuy;
use think\Db;
use app\index\controller\Base;


class Groupbuys extends Base{
    /**
     * 方法描述: 所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月10日 下午11:04:38
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $w['delete_time'] = null;
        $d = db('group_activity')
        ->where($w)
        ->limit($pagenum,$limit)
        ->order('ordernum desc')
        ->select();
        return $d;
    }
    /**
     * 方法描述：获取团购数据
     * @param 
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月11日 17:07:38
     */
    public function getgroupbuyList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('group_buy')
                ->where($w)
                ->limit($pagenum,$limit)
                ->order('create_time desc')
                ->select();                                 //团购表
        $user = db('group_user')->where($w)->select();      //参与团购人员
        foreach($d as $k2=>$v2){
            $num = 0;
            foreach($user as $k=>$v){
                if($v['groupbuy_id'] == $v2['id']){
                    $num++;
                }	
            }
            $d[$k2]['renshu'] = $num;
        }
        return $d;
    }
    /**
     * 方法描述：获取参团人员数据
     * @param unknown $c
     * @return boolean|Ambigous <\think\Collection, \think\db\false, PDOStatement, string, boolean, mixed, \think\mixed, \think\cache\mixed, \PDOStatement, \think\db\mixed, multitype:, unknown, multitype:Ambigous <PDOStatement, multitype:> , NULL>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04年11日 18:06:38
     */
    public function getgroupuserList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('group_user')
        ->where($w)
        ->limit($pagenum,$limit)
        ->order('join_time desc')
        ->select();
        return $d;
    }
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月11日 11:50:38
     */
    public function getCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('group_activity')
        ->where($w)
        ->count();
        return $d;
    }
    /**
     * 方法描述: 获取背景图片所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月11日 11:26:38
     */
    public function getVideolist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('video')->where($w)
        ->field('name,id,type')
        ->limit($pagenum,$limit)
        ->order('add_time desc')
        ->select();
        return $d;
    }
    /**
     * 方法描述: 获取背景图片所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月11日 11:20:38
     */
    public function getImglist($c){
        $limit    = isset($c['limit'])?$c['limit']:9;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('bg_imgs')->where($w)
        ->field('img,id')
        ->limit($pagenum,$limit)
        ->order('add_time desc')
        ->select();
        return $d;
    }
    /**
     * 方法描述：获取单条数据
     * @param unknown $id
     * @return boolean|Ambigous <multitype:, \think\db\false, PDOStatement, string, \think\Model, boolean, unknown, mixed, \think\mixed, \think\cache\mixed, \PDOStatement, \think\db\mixed, multitype:Ambigous <PDOStatement, multitype:> , NULL>
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月11日 10:04:38
     */
    public function getone($id){
    	if(!$id){
    		return false;
    	}else{
    	    $d = db('group_activity')
    	    ->where('id',$id)
    	    ->find();
    	    return $d;
    	}
    }
    /**
     * 方法描述：获取优惠券列表数据
     * @return Ambigous <\think\Collection, \think\db\false, PDOStatement, string, boolean, mixed, \think\mixed, \think\cache\mixed, \PDOStatement, \think\db\mixed, multitype:, unknown, multitype:Ambigous <PDOStatement, multitype:> , NULL>|boolean
     * @author Zhaojiepeng <zhaojiepeng@suxuantech.cn> 2018年04月11日 10:54:38
     */
    public function getcouponlist(){
        $w['brandid'] = $this->brandId;
        $w['is_show'] = 0;
        $coupons = db('c_coupon_num')->where($w)->field('id,title')->select();
        if($coupons){
        	return $coupons;
        }else{
        	return false;
        }
    }

    /**
     * 方法描述：添加团购活动
     * @param unknown $d
     * @author Zhaojiepeng <zhaojiepeng@suxuantech.cn> 2018年04月10日 10:54:38
     */
    public function add($d){
    	if(!$d){
    		return false;
    	}else{
    		//$res = db('group_activity')->insert($d);
            $res = Db::name('group_activity')->insertGetId($d);
    		if($res){
    			return $res;
    		}else{
    			return false;
    		}
    	}
    }
    /**
     * 方法描述：修改活动
     * @param unknown $data
     * @return boolean
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月11日 14:01:38
     */
    public function edit($data){
    	if(!$data['id']){
    		return false;
    	}else{
    		$res = db('group_activity')->where('id',$data['id'])->update($data);
    		if($res){
    			return true;
    		}else{
    			return false;
    		}
    	}
    }
    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月11日 14:49:38
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $w['delete_time'] = date('Y-m-d',time());
            $res = db("group_activity")->where('id='.$id)->update($w);
            if($res){
                return true;
            }else{
                return false;

            }
        }
    }
    /**
     * 方法描述: 获取今天推荐数据列表
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTodayList($c){
         
        $w = [
            'create_time' => [
                 ['>=',date('Y-m-d',time())],
                ['<', date('Y-m-d',time()+86400)],
            ],
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return Recommend::where($w)->field('status,userid')->select();
    }
    
    /**
     * 方法描述: 获取最近一周的数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getWeekList($c){
        $w    = [];
        // 判断当前的用户权限如果是root 选择全部
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $data = [];
        for($i=6;$i>=0;$i--){
            $currenttime = time();
            $starttime   = date('Y-m-d',$currenttime+86400-$i*86400);
            $endtime     = date('Y-m-d',$currenttime-$i*86400);
            $w['create_time'] = [
                        ['<=',$starttime],
                        ['>', $endtime],
            ];
            $data[$endtime] = Recommend::where($w)->count();
        }
        return $data;
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;  
        }else{
            $w = [];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $d = [
                'id'         => $id,
                'check_user' => $this->staffName,
                'status'     => $status,
                'update_time'=>date('Y-m-d H:i:s',time())
            ];
            $res = Recommend::where($w)->update($d);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    



}