<?php
/**
 * 客片大赏
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Wangyining <Wangyining@suxuantech.cn>  2019年04月22日
 */
namespace app\vip\lib;
use app\vip\model\MUsers;
use app\index\controller\Base;
use app\vip\model\MUsersPhone;

class Guestphoto extends Base{


    /*
     * 获取客片列表
     */
    public function photoList($params){
        $limit    = $params['limit']?$params['limit']:10;
        $page  = $params['page']?$params['page']:1;
        $where = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }

            $where['a.brand_id'] = $this->brandId;
        }

        if($params['title'])        $where['a.title'] = ['like','%'.$params['title'].'%'];
        if($params['content_text']) $where['a.content_text'] = $params['content_text'];
        if($params['type_id'])      $where['a.type_id'] = $params['type_id'];

        //上传类型，1后台上传，2用户前台上传
        if($params['upload_type'] == 1){
            $sql = 'a.staff_name is not null';

            $data = db("guest_photo")
                ->where('a.status','in',[1,2,3])
                ->where($where)
                ->where($sql)
                ->alias('a')
                ->join('guest_photo_type type','a.type_id = type.id','left')
                ->field('a.*,type.type_name')
                ->page($page,$limit)
                ->order("type_id asc,sort asc")
                ->select();

        }elseif($params['upload_type'] == 2){
            $sql = 'a.user_id is not null';

            $data = db("guest_photo")
                ->where('a.status','in',[1,2,3])
                ->where($where)
                ->where($sql)
                ->alias('a')
                ->join('guest_photo_type type','a.type_id = type.id','left')
                ->join('m_users user','a.user_id = user.id','left')
                ->field('a.*,type.type_name,user.username')
                ->page($page,$limit)
                ->order("type_id asc,sort asc")
                ->select();
        }

        return $data;
    }

    /*
     * 获取客片总数
     */
    public function photoCount($params){
        $where = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }

            $where['brand_id'] = $this->brandId;
        }

        if($params['title'])        $where['title'] = ['like','%'.$params['title'].'%'];
        if($params['content_text']) $where['content_text'] = $params['content_text'];
        if($params['type_id'])      $where['type_id'] = $params['type_id'];

        //上传类型，1后台上传，2用户前台上传
        if($params['upload_type'] == 1){
            $sql = 'staff_name is not null';
        }elseif($params['upload_type'] == 2){
            $sql = 'user_id is not null';
        }

        $count = db("guest_photo")
            ->where($where)
            ->where($sql)
            ->count();
        return $count;
    }


    /*
     * 添加作品
     */
    public function photoAdd($params){

        if(!$params || !$this->brandId){
            return ['code'=>201,'msg'=>'未获取到数据或没有事业部id'];
        }

        $data = [
            'title'       => $params['title'],
            'content_text'=> $params['content_text'],
            'cover_img'   => $params['cover_img'],
            'content_img' => json_encode($params['content_img']),
            'staff_name'  => session('staffname'),
            'type_id'     => $params['type_id'],
            'package_id'  => $params['package_id'],
            'package_name'=> $params['package_name'],
            'sort'        => $params['sort']?$params['sort']:99,
            'create_time' => date("Y-m-d H:i:s",time()),
            'status'      => $params['status'],
            'brand_id'    => $this->brandId
        ];

        $res = db('guest_photo')->insert($data);
        if($res){
            return ['code'=>200,'msg'=>'添加成功'];
        }else{
            return ['code'=>202,'msg'=>'添加失败'];
        }
    }

    /*
     * 修改客片
     */
    public function photoEdit($params){
        if(!$params['id'] || !$this->brandId){
            return ['code'=>201,'msg'=>'未获取到数据或没有事业部id'];
        }

        $id = $params['id'];

        $data = [
            'title'       => $params['title'],
            'content_text'=> $params['content_text'],
            'cover_img'   => $params['cover_img'],
            'content_img' => json_encode($params['content_img']),
            'staff_name'  => session('staffname'),
            'type_id'     => $params['type_id'],
            'package_id'  => $params['package_id'],
            'package_name'=> $params['package_name'],
            'sort'        => $params['sort']?$params['sort']:99,
            'create_time' => date("Y-m-d H:i:s",time()),
            'status'      => $params['status'],
        ];

        $data = db('guest_photo')->where('id',$id)->update($data);
        if($data!==false){
            return ['code'=>200,'msg'=>'添加成功'];
        }else{
            return ['code'=>202,'msg'=>'添加失败'];
        }
    }

    /*
     * 删除客片
     */
    public function ProductionDel($id){
        if(!$id){
            return false;
        }
        $data = db('s_styleproduction')->where('id',$id)->delete();
        if($data){
            return true;
        }else{
            return false;
        }       
    }


    /*
     * 审核客片
     */
    public function photoCheck($params){
        if(!$params['id'] || !$this->brandId){
            return ['code'=>201,'msg'=>'未获取到数据或没有事业部id'];
        }

        $id = $params['id'];

        $data = [

            'package_id'  => $params['package_id'],
            'package_name'=> $params['package_name'],
            'content_text'=> $params['content_text'],
            'sort'        => $params['sort']?$params['sort']:99,
            'status'      => $params['status'],
            'check_time'  => date('Y-m-d H:i:s'),
            'check_staff' => session('staffname'),
        ];

        $data = db('guest_photo')->where('id',$id)->update($data);
        if($data!==false){
            return ['code'=>200,'msg'=>'添加成功'];
        }else{
            return ['code'=>202,'msg'=>'添加失败'];
        }
    }

    /**
     * 获取摄影师列表
     * @param  
     * @author lilong
     */
    public function getCList(){
        $bid = (int)$this->brandId;
        if ($bid) {
            $where['brandid'] = $bid;
        }
        $cList = db('cameraman')->where($where)->field('c_name')->select();
        return $cList;
    }

}