<?php
/**
 * 积分分类操作方法
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月16日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\UserLevel;
use app\index\controller\Base;
use app\vip\model\GrowthRule;

class Level extends Base{
        
    /**
     * 方法描述     用户级别列表
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        /*
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }*/
        $d = db('user_level')->where($w)->limit($pagenum,$limit)->order('max_value asc')->select();
        return $d;
    }
    
    /**
     * 方法描述     用户级别列表总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getCount(array $c){
        $w = [];
        /*
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }*/
        return db('user_level')->where($w)->count('id');
    }
    /**
     * 方法描述     用户级别列表
     * @param  string $c 是查询条件
     * @return mixed
     * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月11日
     */
    public function getLevelData($params){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;

        $data = db('user_level')->where('delete_time is null')->page($page,$limit)->order('max_once_pay asc')->select();
        $count = db('user_level')->where('delete_time is null')->count();

        return ['code'=>0,'data'=>$data,'count'=>$count];
    }
    

    /**
     * 方法描述   添加级别方法
     * @param  array $d 数据
     * @return bool 
     * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月11日
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $model = new UserLevel();
           $d['brandid'] = $this->brandId;
           $d['create_staff'] = session('staffname');
           $res   = $model->create($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 方法描述    修改类型方法
     * @param  array $d 数据数组,id单元必须存在
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function edit($d){
        if(!$d || !$d['id']){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            /*
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }*/
            unset($d['id'],$d['brandid']);
            $d['create_staff'] = session('staffname');

            $isdata = UserLevel::where($w)->find();
            if($isdata){
              
                $res = UserLevel::where($w)->update($d);
            
                if($res!==false){
                    return true;
                }
                return false;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述    判断当前的值是否已经存在 
     * @param  int  $val 数据
     * @param  int  $noid 排除的id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function hasVal($val,$noid=false){


         $w['brandid']   = $this->brandId;
         if($noid){
             $w['id'] = ['not in',$noid];
         }
         //if($val){
             $w['max_value'] = (int)$val;
         //}
         $res = UserLevel::where($w)->find();
         return $res?true:false;
        
    }
    /**
     * 方法描述：  修改成长值时的 阶梯大小关系
     * @param  $id $max_value 修改的等级的id  成长值
     * @return $notarray
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年3月8日 19:03:38
     */
    public function Bind($id,$max_value){
    	if(!empty($id)){
    	    $w['id'] = $id;
    	}
    	$arr = db('user_level')->select();
    	$arr1 = array();   //贵宾卡
    	$arr2 = array();   //白金卡
        $arr3 = array();   //钻石卡
        for($i = 1;$i<=count($arr);$i++){
            foreach($arr as $k=>$v){
                if($v['sort'] == $i){                 
                    ${'arr'.$i} = $v; //赋值                                    
                }
             } 
        }
    	$res = UserLevel::where($w)->find();
    	if(!empty($res)){
    		if($res['sort'] == 1 && ($max_value >= $arr2['max_value'] || $max_value >= $arr3['max_value'])){
    			$notarray = ['status'=>0,'msg'=>$arr1['name']."的成长值，不能大于".$arr2['name']."、".$arr3['name']."的成长值"];
    		}
    		if($res['sort'] == 2 && $max_value <= $arr1['max_value']){
    			$notarray = ['status'=>0,'msg'=>$arr2['name'].'的成长值，不能小于'.$arr1['name'].'的成长值'];
    		}
    		if($res['sort'] == 2 && $max_value >= $arr3['max_value']){
    			$notarray = ['status'=>0,'msg'=>$arr2['name'].'的成长值,不能大于'.$arr3['name'].'的成长值'];
    		}
    		if($res['sort'] == 3 && ($max_value >= $arr1['max_value'] || $max_value >= $arr2['max_value'])){
    			$notarray = ['status'=>0,'msg'=>$arr3['name'].'的成长值,不能小于'.$arr1['name'].'、'.$arr3['name'].'的成长值']; 
    		}
    	}
    	return $notarray?$notarray:false;
    }
    

    /**
     * 方法描述    软删除用户等级
     * @param  int $id 积分类别删除
     * @return mixed
     * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月11日
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $res = db('user_level')->where('id',$id)->update(['delete_time'=>date('Y-m-d H:i:s')]);
            if($res !== false){
                return true;
            }else{
                return false;
                
            }
        }
    }
    
    /**
     * 获取一条信息处理方法
     * @param  int $id 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
        if(!$id){
            return false;
        }else{
            $w = ['u.id'=>$id];
            /*
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['u.brandid'] = $this->brandId;
                }
            }*/
            $res = GrowthRule::where($w)
                            ->alias('g')
                            ->field('u.name,g.id,g.detail,u.id as levelid')
                            ->join('user_level u','u.id=g.levelid','right')
                            ->find();
            
            //var_dump($res);die;
            if($res['detail']){
                $res['detail'] = json_decode($res['detail'],true);
            }
            if($res){
                return $res;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述    修改成长值类型方法
     * @param  array $d 数据数组 
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function setGrowthRule($d){
        if(!$d){
            return false;
        }else{
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            if($d['id']){
                $res = GrowthRule::where($w)->update($d);
            }else{
                $d['brandid'] = $this->brandId;
                $res = GrowthRule::insert($d);
            }
            
            if($res!==false){
                return true;
            }
            return false;

        }
    }
    
}