<?php
/**
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong $
 */
namespace app\vip\lib;
use app\index\controller\Base;
use think\Exception;
use think\Cache;
use think\Controller;
use think\db;

class Package extends Base{
    /*
     *  根据shop_code 获取套系信息  调erp接口
     * @param $shop_code
     */
    public function getErpPackage($param) {
        $shop_code = $param['shop_code'];

        //判断儿童婚纱
        $et_brand = db('c_sysconfig')->where('ckey','sx_ertong')->find();
        if($et_brand && $et_brand['cvalue'] == session('brandid')){
            $path = 'SX_ChildErpAppNew';
        }else{
            $path = 'SXWebErpAppStaff';//婚纱
        }

        $addr = $param['addr'];

        $url = $addr.'/'.$path.'/SX_PackageSet?Token=^******^&Code='.$shop_code;
        $response = requestERP($url, '');
        //print_r($response);die;
        if ($response['Code'] == 200) {
            $returnData = $response['Data'];
        }else{
            $returnData = [];
        }
        return $returnData;
    }

    /*
     * 获取erp消费类型接口
     */
    public function getConsumptionType($param){
        $addr = $param['addr'];

        $url = $addr.'/SX_ChildErpAppNew/SX_ConsumptiontypeSet?Token=^******^';
        $response = requestERP($url, '');

        //print_r($response);die;
        if ($response['Code'] == 200) {
            $returnData = $response['Data'];
        }else{
            $returnData = [];
        }

        return $returnData;
    }

    /*
     *  根据 brand_id 获取事业部下的店面列表
     * @param    $brand_id
     * @return   array
     */
    public function getShopList($param){
        $brand_id = (int)$param['brand_id'];

        $url = "5a005e0038270";
        $data['brandclass_id']= $brand_id;
        $data['is_marketing'] = 2;

        $res=sx_call($url,$data);
        if($res['code']==200){
            $shop_list = $res['data'];
        }else{
            $shop_list = [];
        }
        return $shop_list;
    }
}