<?php
/**
 * 客片大赏
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Wangyining <Wangyining@suxuantech.cn>  2019年04月22日
 */
namespace app\vip\lib;
use app\vip\model\MUsers;
use app\index\controller\Base;
use app\vip\model\MUsersPhone;

class Photonotice extends Base{
    /*
     * 获取需知信息
     */
    public function photoList($params){
        $limit = $params['limit']?$params['limit']:10;
        $page  = $params['page']?$params['page']:1;
        $where = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }
            $where['brandid'] = $this->brandId;
        }
        if($params['id']){
            $where['id'] = $params['id'];   
            $data = db('p_photo_notice')->where($where)->find();
        }else{
            $data = db('p_photo_notice')->where($where)->page($page,$limit)->select();
        }

        if($data){
            return $data;    
        }else{
            return false;
        }
        
    }

    /*
     * 获取客片总数
     */
    public function photoCount($params){
        $where = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }
            $where['brandid'] = $this->brandId;
        }
        
        $data = db('p_photo_notice')->where($where)->count();

        if($data){
            return $data;    
        }else{
            return false;
        }
    }


    /*
     * 添加作品
     */
    public function photoAdd($params){

        if(!$params || !$this->brandId){
            return ['code'=>201,'msg'=>'未获取到数据或没有事业部id'];
        }

        $data = [
            'name'       => $params['title'],
            'img'=> $params['cover_img'],
            'sort'        => $params['sort']?$params['sort']:0,
            'create_time' => date('Y-m-d H:i:s',time()),
            'brandid'    => $this->brandId
        ];

        $res = db('p_photo_notice')->insert($data);
        if($res){
            return ['code'=>200,'msg'=>'添加成功'];
        }else{
            return ['code'=>202,'msg'=>'添加失败'];
        }
    }

    /*
     * 修改客片
     */
    public function photoEdit($params){
        if(!$params['id'] || !$this->brandId){
            return ['code'=>201,'msg'=>'未获取到数据或没有事业部id'];
        }

        $id = $params['id'];

         $data = [
            'name'        => $params['title'],
            'img'         => $params['cover_img'],
            'sort'        => $params['sort']?$params['sort']:0,
            'update_time' =>date('Y-m-d H:i:s',time()),
        ];

        $data = db('p_photo_notice')->where('id',$id)->update($data);
        if($data!==false){
            return ['code'=>200,'msg'=>'添加成功'];
        }else{
            return ['code'=>202,'msg'=>'添加失败'];
        }
    }

    /*
     * 删除客片
     */
    public function ProductionDel($id){
        if(!$id){
            return false;
        }
        $data = db('s_styleproduction')->where('id',$id)->delete();
        if($data){
            return true;
        }else{
            return false;
        }       
    }


    /*
     * 审核客片
     */
    public function photoCheck($params){
        if(!$params['id'] || !$this->brandId){
            return ['code'=>201,'msg'=>'未获取到数据或没有事业部id'];
        }

        $id = $params['id'];

        $data = [

            'package_id'  => $params['package_id'],
            'package_name'=> $params['package_name'],
            'content_text'=> $params['content_text'],
            'sort'        => $params['sort']?$params['sort']:99,
            'status'      => $params['status'],
            'check_time'  => date('Y-m-d H:i:s'),
            'check_staff' => session('staffname'),
        ];

        $data = db('guest_photo')->where('id',$id)->update($data);
        if($data!==false){
            return ['code'=>200,'msg'=>'添加成功'];
        }else{
            return ['code'=>202,'msg'=>'添加失败'];
        }
    }

    /**
     * 获取摄影师列表
     * @param  
     * @author lilong
     */
    public function getCList(){
        $bid = (int)$this->brandId;
        if ($bid) {
            $where['brandid'] = $bid;
        }
        $cList = db('cameraman')->where($where)->field('c_name')->select();
        return $cList;
    }

}