<?php
/**
 * 用户推荐管理
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Zhao Jie Peng <Zhaojiepeng@suxuantech.cn>  2017年11月23日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\Recommend;
use app\index\controller\Base;

class Recommendusername extends Base{
    
    /**
     * 方法描述: 所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['u.brandid'] = $this->brandId;
            }
        }
        $w['u.is_del'] = 1;
        $d = db('recommend_user')->alias('u')
            ->join('c_coupon_bag b','u.b_id=b.id','left')
            ->where($w)
            ->field('u.*,b.name')
       		->order('sort desc')
       		->select();
        return $d;
    }
     
    /**
     * 方法描述: 获取数据的总数
     * @param  array $c 是查询条件
     * @return mixed
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $w['is_del'] = 1;
        return db('recommend_user')->where($w)->count('id');
    }
    /**
     * 方法描述：添加数据
     * @param [type] $data [description]
     */
    public function add($data){
        if(!$data){
            return false;
        }
        $data['create_time'] = date("Y-m-d H:i:s",time());
        $data['brandid']    = $this->brandId;
        $data['staff_id']   = session("staff_id");
        $data['staff_name'] = session("staffname");
        $data['is_del'] = 1;
        $data['is_get'] = 1;
        $res = db("recommend_user")->insert($data);
        if($res){
            return true;
        }else{
            return fasle;
        }
    }
    /**
     * 方法描述：修改数据
     * @param  [type] $id   [description]
     * @param  [type] $data [description]
     * @return [type]       [description]
     */
    public function update($id,$data){
        if(!$id || !$data){
            return false;
        }
        $res = db("recommend_user")->where("id",$id)->update($data);
        if($res || $res === 0){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 方法描述：删除数据
     * @param  [type] $id [description]
     * @return [type]     [description]
     */
    public function del($id){
        if(!$id){
            return false;
        }
        $data['is_del'] = 2;
        $res = db("recommend_user")->where('id',$id)->update($data);
        if($res){
            return true;
        }else{
            return false;
        }
    }
    /**
     * 方法描述：获取数据
     * @param  [type] $where [description]
     * @return [type]        [description]
     */
    public function getdata($where){
        if($where){
            $data = db("recommend_user")->where($where)->find();    
        }else{
            $data = db("recommend_user")->select();
        }
        if($data){
            return $data;
        }else{
            return false;
        }
    }

}