<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\vip\lib;
use think\Controller;
 
use think\db;
class RunExcelImport extends Controller {
    protected  $tableFiles = [
        'm_users_phone' => [
            'phone'=>'手机号',
            'money'=>'账户余额',
            'brandid'=>'品牌',
            'username'=>'用户名',
            'create_time'=>'注册日期',
            'total_score'=>'积分',
            'growth_value'=>'成长值',
            'sex'=>'性别',
            'brithday'=>'生日',
            'merryday'=>'结婚纪念日',
            'truename'=>'真实姓名'
        ],
    ];
    
    //  处理上传方法
    public function cus_import($data){
        if(!$data){
            $this->log('receive a empty data, ignore it.');
            return false;
        }
        $unikey    = $data['unikey'];
        $unikey2   = $data['unikey2'];
        $tablename = $data['table'];
        $importId = $data['id'];
        $this->log('receive a import data ='.var_dump($data));
        if(!$importId){
            $this->log('import id is empty.');
            return false;
        }
        $importInfo = db('c_excel_import')->find($importId);
        if(!$importInfo){
            $this->log('import table unfinded.please check table:c_excel_import.');
            return false;
        }
        
        $path = ROOT_PATH . 'public' . DS . 'uploads'. DS .'excel'. DS;
        $exceldata  = \PHPExcel_IOFactory::load($path.$importInfo['file_url']);
        $datas = $exceldata->getActiveSheet()->toArray();
        $userFiels = db()->getTableInfo($tablename,'fields');        
        // 去配置里的会员数据字段映射
        $userFiels = $this->tableFiles['m_users_phone'];
        // 查询出旧的会员数据
        //$oldusers = db($tablename)->field("$unikey,$unikey2")->select();
        // 记录数据库里存在的字段
        $keyArr    = [];
        if($datas && count($datas)>1){
            $this->log('start import process,all import num:'.count($datas));
            $addFields = $datas[0];
            unset($data[0]);
            $revUserFiels = array_flip($userFiels);

            for($i=0;$i<count($addFields);$i++){
                if($revUserFiels[trim($addFields[$i])]){
                    $keyArr[] = $i;
                }
            }
            $noInsertData   = [];
            $newTempData    = [];
            //$this->log('datas='.var_dump(array_filter($datas)));
 
            for($i=1;$i<count($datas);$i++){
                $one = array_filter($datas[$i]);
                if(!$one){
                    continue;
                }else{
                    $one = $datas[$i];
                }
                $tempData = [];
                for($k=0;$k<count($one);$k++){
                    if(in_array($k,$keyArr)){
                        
                        // 唯一值第一个字段
                        if($unikey && $unikey == $revUserFiels[$addFields[$k]]){
                            $unikeyValue  = $one[$k];
                        }
                        if($unikey2 && $unikey2==$revUserFiels[$addFields[$k]]){
                            // 唯一值第二个字段
                            $unikey2Value = $one[$k];
                        }
                        
                        if(!$one[$k]){
                            $tempData[$revUserFiels[$addFields[$k]]] = 0;
                        }else if($addFields[$k]=='真实姓名'){
                            // 过滤用户名非法字符
                            $truename = preg_replace('/[^_\d\w\x{4e00}-\x{9fa5}]/u','', $one[$k]);
                            $tempData[$revUserFiels[$addFields[$k]]] = $truename;
                            $one[$k] = $truename;
                        }else if($addFields[$k]=='用户名'){
                            // 过滤用户名非法字符
                            $username = preg_replace('/[^_\d\w\x{4e00}-\x{9fa5}]/u','',$one[$k]);
                            $tempData[$revUserFiels[$addFields[$k]]] = $username;
                            $one[$k] = $username;
                        }else if($addFields[$k]=='注册日期'){

                            // 判断时间是不是 09-10-12或者09-10-2012 
                            if(strpos($one[$k],'/')!==false){
                                $oldtimeArr  = explode(' ',$one[$k]);
                                $oldtimeDay  = explode('/',$oldtimeArr[0]);
                                $oldtimeHIS  = $oldtimeArr[1];
 
                                if(count($oldtimeDay)!=3 && (strlen($oldtimeDay['2'])!=2 || strlen($oldtimeDay['2'])!=4)){
                                    $newone = '';
                                }else{
                                    $newone = date("Y-m-d",mktime(0,0,0,$oldtimeDay[0],$oldtimeDay[1],$oldtimeDay[2])).' '.$oldtimeHIS;
                                    $one[$k] = $newone;
                                }
                                $tempData[$revUserFiels[$addFields[$k]]] = $newone;
                                
                            }else{
                                $afterTimeArr = array_filter(explode('-',$one[$k]));
                                if(count($afterTimeArr)!=3 && (strlen($afterTimeArr['2'])!=2 || strlen($afterTimeArr['2'])!=4)){
                                    $newone = '';
                                }else{
                                    $newone = date("Y-m-d",mktime(0,0,0,$afterTimeArr[0],$afterTimeArr[1],$afterTimeArr[2]));
                                    $one[$k] = $newone;
                                }
                                $tempData[$revUserFiels[$addFields[$k]]] = $newone;
                            }
                          
                         
                        }else if($addFields[$k]=='结婚纪念日' || $addFields[$k]=='生日'){
                            // 判断时间是不是 09-10-12或者09-10-2012；
                            $afterTimeArr = array_filter(explode('-',$one[$k]));
                            if(count($afterTimeArr)!=3 && (strlen($afterTimeArr['2'])!=2 || strlen($afterTimeArr['2'])!=4)){
                                $newone = '';
                            }else{
                                $newone = date("Ymd",mktime(0,0,0,$afterTimeArr[0],$afterTimeArr[1],$afterTimeArr[2]));
                                $one[$k] = $newone;
                            }
                            $tempData[$revUserFiels[$addFields[$k]]] = $newone;

                        }elseif($addFields[$k]=='性别'){
                            $sex = trim($one[$k])=='男'?1:0;
                            $tempData[$revUserFiels[$addFields[$k]]] = $sex;
                        }else{
                            $tempData[$revUserFiels[$addFields[$k]]] = $one[$k];
                        }
                        $tempData['brandid'] = $importInfo['brandid'];
                        $tempData['status']  = 1;
                        $tempData['c_excel_import_id']  = $importId;
                        $tempData['create_time']  = date('Y-m-d H:i:s');
                        
                    }
                  
                     
                }
                // 如果手机号不存在说明没有数据
                $fullUnikey = '';
                if($unikeyValue || $unikey2Value){
                    $pre = $unikeyValue && $unikey2Value?'_':'';
                    $fullUnikey .= $unikeyValue?$unikeyValue:'';
                    $fullUnikey .= $pre.''.($unikey2Value?$unikey2Value:'');
                    
                    //$this->log('newTempData'.$fullUnikey.'='.var_dump($newTempData));
                   
                    if($newTempData[$fullUnikey]){
                        $one[] = '导入的数据表里重复';
                        $noInsertData[] = $one;
                        unset($tempData);
                        continue;
                    } 

                    if($unikeyValue){
                        $where[$unikey] = $unikeyValue;
                    }
                    if($unikey2Value){
                        $where[$unikey2] = $unikey2Value;
                    }
                    $has = db($tablename)->where($where)->count('id');
                    if($has){
                        $one[] = '数据库里会员已存在';
                        $noInsertData[] = $one;
                        unset($tempData);
                        continue;
                    }
                } 
                $newTempData[$fullUnikey] = $tempData;
            }
            $this->log('need import to db num:'.count($newTempData));
            
           
            if($noInsertData){
                $this->log('error data num:'.count($noInsertData));
                $title   = $addFields;
                $title[] = '失败原因';
                array_unshift($noInsertData,$title);
            }

            try{
                db()->startTrans();//开启事务
                $failDataNum = $noInsertData?count($noInsertData)-1:0;
                $allDataNum  = count($newTempData)+$failDataNum;
                if(count($newTempData)>0){
                    db($tablename)->insertAll($newTempData);
                    db('c_excel_import')->where(array('id'=>$data['id']))->update(array('status'=>1,'all_number'=>$allDataNum,'import_number'=>count($newTempData),'fail_number'=>$failDataNum));
                }else{
                    $excel= db('c_excel_import')->where(array('id'=>$data['id']))->update(array('status'=>1,'all_number'=>$allDataNum,'import_number'=>0,'fail_number'=>$failDataNum));
                }
                if(count($noInsertData)>0){
                    $fail_url=$this->outExcel($noInsertData);
                    db('c_excel_import')->where(array('id'=>$data['id']))->update(array('fail_file_url'=>$fail_url,'all_number'=>$allDataNum));
                    
                }
                db()->commit();
            }catch (\EXCEPTION $e){
                $this->log('save to db error,error message:'.$e->getMessage());
                db()->rollback();
            }
        }else{
            $this->log('excel is empty,please check excel file:'.$path.$importInfo['file_url']);
        }
    }
    
    // 输出错误的数据到excel文件并返回，文件名
    public function outExcel($data){
        $objPHPExcel = new \PHPExcel();
        $path = ROOT_PATH . 'public' . DS . 'uploads'. DS .'excel'. DS;
        $objPHPExcel->getProperties()->setCreator("Maarten Balliauw")
        ->setLastModifiedBy("Suxuan System");
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
        ->setSize(10);
        
        $letters= ['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
        $num = 1;
        foreach ($data as $k=>$v){
            for($i=0;$i<count($v);$i++){
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($letters[$i].$num,$v[$i]);
            }
            $num++;
        }
        $savename = 'error_data_'.time().'.xlsx';
        $objPHPExcel->getActiveSheet()->setTitle('未导入的会员数据');
        $objPHPExcel->setActiveSheetIndex(0);
        // Save Excel 2007 file
        $callStartTime = microtime(true);
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save($path.$savename);
        return $savename;
        
    }
    
    // 调试用的log方法
    function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }
    

}  