<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\vip\lib;
use think\Controller;

use think\db;
use app\common\lib\redisQueue;
use think\image\Exception;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
class RunImportMoney extends Controller {

    //  处理上传方法
    public function importMoney($data){
        $money = [];
        $fail_array =[];
        //$this->log('begin--eid-'.$data['eid']);

        $file_url=$data['file_url'];
        if(!$file_url){
            $fileData=db('c_excel_import')->where('id',$data['eid'])->find();
            $file_url=$fileData['file_url'];
        }

        if(empty($file_url)){
            //$this->log('没有获取到文件地址');
            return false;
        }
        //$this->log('准备读取文件'.date('Y-m-d H:i:s',time()));
        $objReader =\PHPExcel_IOFactory::createReader('Excel2007');
        $obj_PHPExcel =$objReader->load($file_url, $encode = 'utf-8');  //加载文件内容,编码utf-8
        $excel_array = $obj_PHPExcel->getsheet(0)->toArray();   //转换为数组格式
        //$excel_array = $obj_PHPExcel->$obj_PHPExcel()->toArray();

        $first=reset($excel_array);
        array_shift($excel_array);
        $all_number=count($excel_array);
        //$this->log('总数据量'.$all_number);
        //$this->log('数据--》》'.json_encode($excel_array));
        if(!$excel_array){
            //$this->log('没有读取到文件数据');
            return false;
        }

        $title=import_header();//标准表头格式
        $header=array();
        foreach($title as $key => $val){
            foreach($first as $k => $v){
                if($first[$k]==$title[$key]){
                    $header[$key]=$k;
                }
            }
        }
        $del = 0;
        foreach($excel_array as $kt=>$vt) {
            $userid = $vt[$header['userid']];
            if ($userid == '备注') {
                //到备注后面的都不要了。
                $del = 1;
                break;
            }
            if($del == 1){
                unset($excel_array[$kt]);
            }
        }
        foreach($excel_array as $k=>$v) {
            $import=cache('vip_import_money_'.$data['eid']);//处理到第几行（从0开始）
            if($import&&$k<=$import){
                continue;
            }else{
                $money[$k]['userid']       = addslashes($v[$header['userid']]);
                $money[$k]['get_number']       = addslashes($v[$header['get_number']]);
                $money[$k]['user_number']      = addslashes($v[$header['user_number']]);
                $money[$k]['user_true_name']  = addslashes($v[$header['user_true_name']]);
                $money[$k]['get_money']        = addslashes($v[$header['get_money']]);
                $money[$k]['bank_code']        = addslashes($v[$header['bank_code']]);
                $money[$k]['get_time']         = addslashes($v[$header['get_time']]);
                $money[$k]['money_status']         = addslashes($v[$header['money_status']]);
                $money[$k]['is_ok']            = addslashes($v[$header['is_ok']]);

                if(empty($fileData)){
                    $fileData=db('c_excel_import')->where('id',$data['eid'])->find();
                }
                if(!$money[$k]){
                    unset($money[$k]);
                    if($k==count($excel_array)-1){
                        $this->editExcel($fail_array,$fileData['id'],$all_number,count($money));
                    }else{
                        continue;
                    }
                }

                if(empty($money[$k]['userid'])){
                    $money[$k]['bank_code'] = ' '.$money[$k]['bank_code'];
                    $money[$k]['user_number'] =' '.$money[$k]['user_number'];
                    $money[$k]['error']='用户ID列缺失';
                    array_push($fail_array,$money[$k]);
                    unset($money[$k]);
                    if($k==count($excel_array)-1){
                        $this->editExcel($fail_array,$fileData['id'],$all_number,count($money));
                    }else{
                        continue;
                    }
                }
                /*
                if(empty($money[$k]['user_number'])){
                    //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，没有‘来源渠道’。----文件第'.$k.'行');
                    $money[$k]['bank_code'] = ' '.$money[$k]['bank_code'];
                    $money[$k]['user_number'] =' '.$money[$k]['user_number'];
                    $money[$k]['error']='没有填写会员卡号';
                    array_push($fail_array,$money[$k]);
                    unset($money[$k]);
                    if($k==count($excel_array)-1){
                        $this->editExcel($fail_array,$fileData['id'],$all_number,count($money));
                    }else{
                        continue;
                    }

                }else{
                    $userData = db('m_users')->where('user_number',trim($money[$k]['user_number']))->find();

                    if(!$userData){
                        $money[$k]['bank_code'] = ' '.$money[$k]['bank_code'];
                        $money[$k]['user_number'] =' '.$money[$k]['user_number'];
                        $money[$k]['error']='会员编号填写错误';
                        array_push($fail_array,$money[$k]);
                        unset($money[$k]);
                        if($k==count($excel_array)-1){
                            $this->editExcel($fail_array,$fileData['id'],$all_number,count($money));
                        }else{
                            continue;
                        }
                    }
                }
                */
                $withdraw_log = db('m_withdraw_log')->where('get_number',$money[$k]['get_number'])->find();
                if($withdraw_log&&$withdraw_log['money_status']!=2){
                    $money[$k]['bank_code'] = ' '.$money[$k]['bank_code'];
                    $money[$k]['user_number'] =' '.$money[$k]['user_number'];
                    $money[$k]['error']='此提现记录已处理过';
                    array_push($fail_array,$money[$k]);
                    unset($money[$k]);
                    if($k==count($excel_array)-1){
                        $this->editExcel($fail_array,$fileData['id'],$all_number,count($money));
                    }else{
                        continue;
                    }
                }
                db()->startTrans();
                try{
                    $get_money = $money[$k]['get_money'];

                    if($money[$k]['is_ok']=='成功'){
                        db('m_users')->where('id',$money[$k]['userid'])->update(['money'=>['exp',"money - $get_money"],'freeze_money'=>['exp',"freeze_money - $get_money"]]);
                        db('money_log')->insert([
                            'money'=>-$get_money,
                            'm_type'=>2,
                            'm_type_name'=>'提现',
                            'user_id'=>$money[$k]['userid'],//$userData['id'],
                            //'user_phone_id'=>$userData['id'],
                            'create_time'=>date('Y-m-d H:i:s',time()),
                            'number'=>$money[$k]['get_number']
                        ]);
                        db('m_withdraw_log')->where('get_number',$money[$k]['get_number'])->update(['money_status'=>1,'exe_time'=>date('Y-m-d H:i:s'),'staff_name'=>session('staffname')]);
                    }else{
                        db('m_users')->where('user_number',$money[$k]['user_number'])->update(['freeze_money'=>['exp',"freeze_money - $get_money"]]);
                        db('m_withdraw_log')->where('get_number',$money[$k]['get_number'])->update(['money_status'=>3,'exe_time'=>date('Y-m-d H:i:s'),'staff_name'=>session('staffname')]);
                    }

                    if($k==count($excel_array)-1){
                        if(count($fail_array)>0){
                            $fail_file['fail_array']=$fail_array;
                            $fail_file['eid']=$fileData['id'];
                            $fail_url=$this->cusFailFile($fail_file);
                        }
                        //$this->log('生成错误文件'.$fail_url);
                        db('c_excel_import')->where(array('id'=>$fileData['id']))->update(array('all_number'=>$all_number,'import_number'=>count($money),'fail_number'=>count($fail_array),'status'=>1,'fail_file_url'=>$fail_url));
                    }

                    db()->commit();
                }catch (\Exception $e){
                    db('c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>3,'import_fail'=>$e->getMessage()));
                    db()->rollback();
                }


            }

        }
    }

    /*
     * 更改文件状态
     *   错误数据，eid,总数，成功数
     */
    public function editExcel($fail_array,$eid,$all_num,$access_num){

        if(count($fail_array)>0){
            $fail_file['fail_array']=$fail_array;
            $fail_file['eid']=$eid;
            $fail_url=$this->cusFailFile($fail_file);
        }
        //$this->log('生成错误文件'.$fail_url);
        db('c_excel_import')->where(array('id'=>$eid))->update(array('all_number'=>$all_num,'import_number'=>$access_num,'fail_number'=>count($fail_array),'status'=>1,'fail_file_url'=>$fail_url));

    }

    //生成错误文件
    function cusFailFile($fail_file){

        if(!file_exists(ROOT_PATH . 'public' . DS . 'excel' . DS .'error')){
            $mkres = @mkdir(ROOT_PATH . 'public' . DS . 'excel' . DS .'error',0777,true);
            if(!$mkres){
                return false;
            }
        }

        $PHPExcel = new PHPExcel();
        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称
        $title = export_header();
        $title[] = '错误原因';
        // $title=array('打款编号','会员卡号','提现人姓名','提现金额','银行卡号','提现时间', '是否打款','错误原因');

        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }
        if(count($fail_file['fail_array'])>0){
            foreach($fail_file['fail_array'] as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        $file_url = ROOT_PATH . 'public' . DS . 'excel';
        $file_name=$file_url."/error/".'error'.$fail_file['eid'].'.xlsx';
        $PHPWriter->save($file_name);
        return $file_name;
    }


    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();

        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }




    // 调试用的log方法
    function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }
    

}  