<?php
/**
 * 积分规则增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\SScoreRule;
use app\vip\model\UserLevel;
use app\index\controller\Base;


class Scorerule extends Base{
    
    /**
     * 方法描述     获取积分规则数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        $w = [];
        /*
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['v.brandid'] = $this->brandId;
            }
        }*/
        $d = SScoreRule::alias('r')->where($w)->field('v.name,r.id,r.levelid,r.detail')
        ->join('__USER_LEVEL__ v','v.id=r.levelid','left')
        ->limit($pagenum,$limit)
        ->select();
        foreach ($d as $k=>$v){
            $ndata[$k] = json_decode($d[$k]['detail'],true);
            $ndata[$k]['levelid'] = $v['levelid'];
            $ndata[$k]['name']    = $v['name'];
            $ndata[$k]['id']      = $v['id'];
        }
        return $ndata;
    }
    
    /**
     * 方法描述     获取积分规则总数
     * @return int 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount(){
        $w = [];
        /*
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }*/
        return SScoreRule::where($w)->count('id');
    }
    /**
     * 方法描述     获取用户级别分类数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getLevels(){
        $w = [];
        /*
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }*/
        return UserLevel::where($w)->select();
    }
    
    /**
     * 添加积分规则的方法
     * @param array $d 数据数组
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
            $model = new SScoreRule();
            $res = $model->create($d);
            if($res){
                return true;
            }else{
                return false;
            }
       }
    }
    
    /**
     * 修改积分规则处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function edit($d){
        if(!$d || !$d['id']){
            return false;
        }else{
            $w = ['id'=>$d['id']];
            unset($d['id']);
            $res = SScoreRule::where($w)->update($d);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 获取一条积分规则信息处理方法
     * @param array $levelid 级别id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($levelid){
        if(!$levelid){
            return false;
        }else{
            $w = ['levelid'=>$levelid];
            /*
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['u.brandid'] = $this->brandId;
                }
            }*/
            $res = SScoreRule::alias('s')->where($w)
            ->field('u.name as levelname,s.id,s.levelid,s.detail')
            ->join('user_level u','u.id=s.levelid')
            ->find();
            if($res){
                $ndata = json_decode($res['detail'],true);
                $ndata['levelid'] = $res['levelid'];
                $ndata['id']      = $res['id'];
                return $ndata;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述     删除一条积分规则
     * @param  int $id 积分规则id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $model = new SScoreRule();
            $res = $model->destroy($id);
            return $res?true:false;
        }
    }
    
    /**
     * 方法描述     数组排序
     * @param  array $d 要排序的数组，单元ordercolumn 字段必须有
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function orderArr($d){
        if(!$d || !is_array($d)){
            return false;
        }
        $ordertype = 'desc';
        if(isset($d['ordertype'])){
            $ordertype = $d['ordertype'];
        }
 
    }
    

}