<?php
/**
 * 用户签到表删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use think\Controller;
use think\Db;
use app\vip\model\AActivityList;
use app\index\controller\Base;

class Sign extends Base{
    
    /**
     * 方法描述: 所有数据
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $d = AActivityList::alias('a')->where()
        ->field('n.title as couponname,a.share_total,a.view_total,a.id,a.title,a.share_score,a.index_img,a.start_time,a.end_time,a.status')
        ->join('__C_COUPON_NUM__ n','n.id=a.couponid','left')
        ->limit($pagenum,$limit)
        ->select();
        return $d;
    }
    
    /**
     * 方法描述: 获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        return AActivityList::where($c)->count('id');
    }
 
    /**
     * 添加处理方法
     * @param array $d 数据数组
     * @return mixed 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function add($d){
       if(!$d){
           return false;
       }else{
           $model = new AActivityList();
           $res = $model->save($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 修改处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function edit($d){
        if(!$d){
            return false;
        }else{
            $res = AActivityList::update($d);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 获取一条信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
   
        if(!$id){
            return false;
        }else{
            $res = AActivityList::alias('a')
            ->where('a.id='.$id)
            ->field('n.title as couponname,n.img,a.id,a.title,a.start_time,a.index_img,a.scontent,a.content,a.end_time,a.couponid,a.view_total,a.status,a.share_score,a.order_num')
            ->join('__C_COUPON_NUM__ n','n.id=a.couponid','left')
            ->find();
            if($res){
                return $res;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id 活动id
     * @param int $status 状态值
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status){
        if(!$id){
            return false;  
        }else{
            $res = AActivityList::update(['status'=>$status],['id'=>$id]);
            if($res){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 删除一条活动记录处理方法
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id){
        if(!$id){
            return false;
        }else{
            $hasdata = AActivityList::where('id='.$id)->count();
            if($hasdata){
                $res = AActivityList::destroy($id);
                if($res){
                    return true;
                }else{
                    return false;
                
                }
            }
        }
    }
    
    
    /**
     * 获取今天签到总数
     * @param int $id 活动id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getTodayCount($c){
        $today= date("Ym",time());
        $tablename = 'sign_detail_'.$today;
        if(!checkTableExists($tablename)){
            $sql = "CREATE TABLE $tablename (
                id int NOT NULL AUTO_INCREMENT,
                PRIMARY KEY(id),
                userid int(11),
                sign_time datetime,
                sign_sum int(11),
                sign_create datetime
            )";
            $res = Db::execute($sql);
            if ($res === false) {
                return false;
            }
            cache('table_all_list',null);
        }
        $w = [
            'a.sign_time' => [
                ['>=',date('Y-m-d',time())],
                ['<', date('Y-m-d',time()+86400)],
            ]
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }
            $w['u.brandid'] = $this->brandId;
        }
        return db($tablename)
                ->alias('a')
                ->where($w)
                ->join('m_users u','u.id=a.userid')
                ->count('a.id');
    }
}