<?php
/**
 * 用户管理增删改查处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月14日 下午12:36:20
 */
namespace app\vip\lib;
use app\vip\model\MUsers;
use app\index\controller\Base;
use app\vip\model\MUsersPhone;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
class Users extends Base{
    /**
     * 方法描述: 所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getlist($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $pw = $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                //判断当前帐号是否为集团会员
                if($this->brandId != db_config('sx_brand')){
                    $pw['p.brandid'] = $this->brandId;
                }
                if ($c['phone']) $pw['p.phone'] = $c['phone'];
                if ($c['username']) $pw['p.username'] = $c['username'];$w['username']    = $c['username'];
                if ($c['order_number']) $pw['m.order_number'] = $c['order_number'];
                //判断当前帐号是否为集团会员
                if($this->brandId != db_config('sx_brand')){
                    $w['brandid']    = $this->brandId;
                }
            }
        }
        if(!$c['usertype']){
            $d = db('m_users_phone')->where($pw)
            ->alias('p')
            ->join('m_users u','u.id=p.userid','left')
            ->join('m_order m','m.order_userid=p.id','left')
            ->field('u.openid,
                    p.id as pid,p.username,p.phone,p.sex,p.status,
                    p.brithday,p.merryday,p.reg_time,p.create_time,
                    p.total_score,p.growth_value,p.user_number,
                    p.money,p.brandid,p.userid as id,p.total_sign,
                    m.order_time,m.order_number,m.one_money,m.two_money,m.one_detail,m.two_detail'
                )
            ->order('p.create_time desc')
            ->limit($pagenum,$limit)
            ->select();
        }else{
            // 获取已经成为会员的id
            $w['id'] = ['not in',db('m_users_phone')->where($w)->where(['userid'=>['>',0]])->column('userid')];
            $d = MUsers::where($w)
            ->field('id,username,openid,phone,sex,brithday,status,total_sign,simg,merryday,create_time,total_score,total_sign,level,growth_value,money,brandid,user_number')
            ->limit($pagenum,$limit)
            ->order('create_time desc')
            ->select();
            //echo db()->getLastSql();die;
        }
        //print_r($d);die;
        return $d;
    } 
    /**
     * 方法描述: 获取用户所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getAll(){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = MUsers::field(
                            'id,username,phone,sex,brithday,status,
                            merryday,create_time,total_score,total_sign,
                            last_land_time,growth_value,money,
                            brandid,user_number')
                    ->where($w)->select();
        return $d;
    }
    
    /**
     * 方法描述: 新会员规则取数据所有数据
     * @param  array $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月4日 下午3:04:46
     */
    public function getNewList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $pw = $w = [];
        $sql = " 1 = 1 ";

        if ($c['phone']){
            $pw['p.phone'] = $c['phone'];
            $w['u.phone']  = $c['phone'];
        }
        if ($c['username']){
            $pw['p.username']  = $c['username'];
            $w['u.username']   = ['like',$c['username']];
            //$addWhere = " u.username like '%".$c['username']."%' or p.username like '%".$c['username']."%' ";
        }
        if($c['user_number']){
            //$w['p.user_number']= $c['user_number'];
            $w['u.user_number']= ['like',$c['user_number']];
        }
        /*导入批次
        if ($c['importid']) {
            $pw['p.c_excel_import_id'] = $c['importid'];
            $w['p.c_excel_import_id']  = $c['importid'];
        }
        */
        if($c['total_score']){
            $u_total = ' p.total_score >= '.$c['total_score'];
            //$p_total = ' (p.total_score >= '.$c['total_score'].' or u.total_score >= '.$c['total_score'].') ';
            $w['u.total_score'] = ['>=',$c['total_score']];
        }

        if($c['level']){
            $w['u.level'] = $c['level'];
        }


        if($c['start_time']){
            $sql.= " and u.create_time >= '".$c['start_time']."'";
        }
        if($c['end_time']){
            $end_time = $c['end_time'];
            $end_time = date('Y-m-d',strtotime("$end_time +1 day"));
            $sql.= " and u.create_time <= '".$end_time."'";
        }

        if($c['phone_start_time'])  $sql .= " and u.reg_time >= '".$c['phone_start_time']."'";
        if($c['phone_end_time']){
            $phoe_end_time = $c['phone_end_time'];
            $phoe_end_time   = date("Y-m-d",strtotime("$phoe_end_time +1 day"));
            $sql .= " and u.reg_time < '".$phoe_end_time."'";
        }

        if($c['setphone'] == '1'){
            $sql .= " and u.phone is not null";
        }
        if($c['setphone'] == '2'){
            $sql .= " and u.phone is null";
        }
        /*
        if ($c['growthvalue']) {
            $nextvalueInfo = self::getNextLevel($this->brandId,$c['growthvalue']);
            $nextvalue = $nextvalueInfo?$nextvalueInfo['max_value']:'';
            $pw['p.growth_value'] = ['>=',$c['growthvalue']];
            if($nextvalue){
                $pw['p.growth_value'] =[['>=',$c['growthvalue']], ['<',$nextvalue]];
                $addWhereStrP  = " and p.growth_value < $nextvalue ";
                $addWhereStrU  = " and u.growth_value < $nextvalue ";
            }
            if($addWhere){
                $addWhere .= " and ((p.growth_value >=$c[growthvalue] $addWhereStrP) or (u.growth_value >=$c[growthvalue] $addWhereStrU))";
            }else{
                $addWhere = " ((p.growth_value >=$c[growthvalue] $addWhereStrP) or (u.growth_value >=$c[growthvalue] $addWhereStrP ))";
            }
        }
        */

        $w['u.delete_time'] = null;
        $pw['p.userid']     = ['<',1];

        //介绍人信息
        if($c['recommend']){
            $recommendSql = 'uuu.username like "%'.$c['recommend'].'%" or uuu.phone like "%'.$c['recommend'].'%"';
        }

        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{

                //判断当前帐号是否为集团会员
                if($this->brandId != db_config('sx_brand')){
                    //查看范围只是当前人事业部
                    $w['u.brandid']   = $this->brandId;
                    $pw['p.brandid']  = $this->brandId;
                }else{

                    //搜索条件
                    if($c['brandid']){
                        $w['u.brandid']   = $c['brandid'];
                    }

                    //若搜集团事业部的会员brandid转为0
                    if($c['brandid'] == db_config('sx_brand')){
                        $w['u.brandid'] = 0;
                    }
                }

            }
        }

        $phoneFileds = 'p.id as pid,p.username,p.phone,p.sex,p.status,p.brithday,p.merryday,p.reg_time,p.create_time,p.total_score,p.growth_value,p.user_number,p.money,p.brandid,p.userid as id,p.total_sign,m.order_time,m.order_number,m.one_money,m.two_money,m.one_detail,m.two_detail';
        $userFileds  = 'u.id,u.username,u.openid,u.sex,u.brithday,u.status,u.total_sign,u.merryday,u.create_time,u.total_score,u.total_sign,u.growth_value,u.money,u.brandid,p.id as pid,p.username as pusername,p.phone,p.sex as psex,p.brithday as pbrithday,p.status as pstatus,p.total_sign as ptotal_sign, p.merryday as pmerryday,p.create_time as pcreate_time,p.reg_time,p.total_score as ptotal_score,p.total_sign as ptotal_sign, p.growth_value as pgrowth_value,p.money,p.brandid as pbrandid,p.user_number,p.userid,u.share_userid,uuu.id as share_id,uuu.username as share_username,uuu.simg as share_simg,ppp.id as share_p_id,ppp.phone as share_phone';
        if($c['sendmsg']){
            $phoneFileds = $userFileds  = 'p.phone';
        }


        // 获取粉丝数量
        if($c['usertype']==1){

            if($c['data_type'] == 'all'){
                $d = db('m_users_phone')
                    ->where($pw)
                    ->where($u_total)
                    ->alias('p')
                    ->join('m_order m','m.order_userid=p.id','left')
                    ->field($phoneFileds)
                    ->order('p.create_time desc')
                    ->select();
            }else{
                $d = db('m_users_phone')
                    ->where($pw)
                    ->where($u_total)
                    ->alias('p')
                    ->join('m_order m','m.order_userid=p.id','left')
                    ->field($phoneFileds)
                    ->order('p.create_time desc')
                    ->limit($pagenum,$limit)
                    ->select();
            }
        }else{
            //会员
            if($c['data_type'] == 'all'){
                $d = db('m_users')
                    ->where($w)
                    ->where($sql)
                    ->where($recommendSql)
                    ->alias('u')
                    ->field('u.id,u.phone,u.username,u.user_number,u.openid,u.sex,u.brithday,u.status,u.total_sign,u.merryday,u.create_time,u.reg_time,u.total_score,u.total_sign,u.growth_value,u.money,u.brandid,u.level,u.share_userid,uuu.id as share_id,uuu.username as share_username,uuu.simg as share_simg,uuu.id as share_user_id,uuu.phone as share_phone')
                    ->join('m_users uuu','u.share_userid = uuu.id','left')
                    ->order('u.create_time desc')
                    ->select();
            }else{

                $d = db('m_users')
                    ->where($w)
                    ->where($sql)
                    ->where($recommendSql)
                    ->alias('u')
                    ->field('u.id,u.phone,u.username,u.user_number,u.openid,u.sex,u.brithday,u.status,u.total_sign,u.merryday,u.create_time,u.reg_time,u.total_score,u.total_sign,u.growth_value,u.money,u.brandid,u.level,u.share_userid,uuu.id as share_id,uuu.username as share_username,uuu.simg as share_simg,uuu.id as share_user_id,uuu.phone as share_phone')
                    ->join('m_users uuu','u.share_userid = uuu.id','left')
                    ->limit($pagenum,$limit)
                    ->order('u.create_time desc')
                    ->select();
            }

            // 读取所有等级
            if($d){
               $allLevel = db('user_level')->field('id,name,min_once_pay')->where('delete_time is null')->order('create_time asc')->select();

               $brandList = sx_call('5a38840b15ba9',array(),'sx_mc');
               if($brandList['code'] == 200){
                    $brandList = $brandList['data'];
               }
            }
            foreach ($d as $k=>$v){
                if($v['pid']){
                    $d[$k]['id']            = $v['userid'];
                    $d[$k]['username']      = $v['pusername'];
                    $d[$k]['sex']           = $v['psex'];
                    $d[$k]['brithday']      = $v['pbrithday'];
                    $d[$k]['status']        = $v['pstatus'];
                    $d[$k]['total_sign']    = $v['ptotal_sign'];
                    $d[$k]['merryday']      = $v['pmerryday'];
                    $d[$k]['create_time']   = $v['pcreate_time'];
                    $d[$k]['total_score']   = $v['ptotal_score'];
                    $d[$k]['total_sign']    = $v['ptotal_sign'];
                    $d[$k]['growth_value']  = $v['pgrowth_value'];
                    $d[$k]['brandid']       = $v['pbrandid'];
                }
                // 确认当前用户等级
                foreach ($allLevel as $lk => $lv){
                    if($lv['id'] == $d[$k]['level']){
                        $d[$k]['levelname'] = $lv['name'];
                    }
                }

                if($brandList){
                    foreach ($brandList as $key => $value) {
                        if($value['id'] == $v['brandid']){
                            $d[$k]['brandname'] = $value['brandclass'];
                        }
                        if($value['id'] == db_config('sx_brand') && $v['brandid'] == 0){
                            $d[$k]['brandname'] = $value['brandclass'];
                        }
                    }
                }
            }
        }
        return $d;
    }
    
    /**
     * 方法描述: 新规则获取数据用户的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getNewCount($c){
        $pw = $w = [];
        $sql = '1=1 ';
        if($c){
            $time      = date('Y-m-d',time());
            $nexttime  = date('Y-m-d',time()+86400);
            if($c['today']){
                $pw['p.reg_time'] =  [
                    ['>=',$time],
                    ['<',$nexttime]
                ];
                //$addWhere = "((p.reg_time >='$time') or (u.reg_time >='$time'))";
                $addWhere = "u.reg_time >='$time'";
            }
            if($c['todayland']){
                $wheretime = [
                    ['>=',$time],
                    ['<',$nexttime]
                ];
                $pw['p.last_land_time'] = $wheretime;
                //$addWhere = " ((p.last_land_time >='$time') or (u.last_land_time >='$time'))";
                $addWhere = " u.last_land_time >='$time'";

            }

        }

        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{


                //判断当前帐号是否为集团会员
                if($this->brandId != db_config('sx_brand')){
                    //查看范围只是当前人事业部
                    $w['u.brandid']   = $this->brandId;
                    $pw['p.brandid']  = $this->brandId;
                }else{

                    //搜索集团会员brandid为0
                    if($c['brandid']){
                        $w['u.brandid']   = $c['brandid'];
                    }

                    if($c['brandid'] == db_config('sx_brand')){
                        $w['u.brandid'] = 0;
                    }
                }

            }
        }
         if ($c['phone']){
                    $pw['p.phone'] = $c['phone'];
                    $w['u.phone']  = $c['phone'];
                }
                if ($c['username']){
                    $pw['p.username']  = $c['username'];
                    $w['u.username']   = ['like',$c['username']];
                    //$addWhere = " u.username like '%".$c['username']."%' or p.username like '%".$c['username']."%' ";
                }
                if($c['user_number']){
                    //$w['p.user_number']= $c['user_number'];
                    $w['u.user_number']= ['like',$c['user_number']];
                }
                /*
                if ($c['importid']) {
                    $w['p.c_excel_import_id']  = $c['importid'];
                }
                */
                if($c['total_score']){
                    $u_total = ' p.total_score >= '.$c['total_score'];
                    //$p_total = ' (p.total_score >= '.$c['total_score'].' or u.total_score >= '.$c['total_score'].') ';
                    $w['u.total_score'] = ['>=',$c['total_score']];
                }

                if($c['level']){
                    $w['u.level'] = $c['level'];
                }

               

                if($c['start_time']){
                    $sql.= " and u.create_time >= '".$c['start_time']."'";
                }
                if($c['end_time']){
                    $end_time = $c['end_time'];
                    $end_time = date('Y-m-d',strtotime("$end_time +1 day"));
                    $sql.= " and u.create_time <= '".$end_time."'";
                }

                if($c['phone_start_time'])  $sql .= " and u.reg_time >= '".$c['phone_start_time']."'";
                if($c['phone_end_time']){
                    $phoe_end_time = $c['phone_end_time'];
                    $phoe_end_time   = date("Y-m-d",strtotime("$phoe_end_time +1 day"));
                    $sql .= " and u.reg_time < '".$phoe_end_time."'";
                }
                if($c['setphone'] == '1'){
                    $sqlphone = "p.id is not null";
                }
                if($c['setphone'] == '2'){
                    $sqlphone = "p.id is null";
                }

                if($c['setphone'] == '1'){
                    $sql .= " and u.phone is not null";
                }
                if($c['setphone'] == '2'){
                    $sql .= " and u.phone is null";
                }

                $pw['p.userid'] = ['<',1];
                $w['u.delete_time'] = null;

        //介绍人信息
        if($c['recommend']){
            $recommendSql = 'uuu.username like "%'.$c['recommend'].'%" or uuu.phone like "%'.$c['recommend'].'%"';
        }


        if($c['usertype']==1){
            $count = db('m_users_phone')->where($pw)->where($u_total)
                ->alias('p')
                ->join('m_order m','m.order_userid=p.id','left')
                ->count('p.id');
        }else{
            /*
            $count = MUsers::where($w)
                ->where($addWhere)
                ->alias('u')
                ->join('m_users_phone p','p.userid=u.id','left')
                ->count('u.id');
                */
            $count = db('m_users')
                ->where($w)
                ->where($addWhere)
                ->where($u_total)
                ->where($sql)
                ->where($sqlphone)
                ->where($recommendSql)
                ->alias('u')
                ->join('m_users_phone p','u.id=p.userid','left')
                ->join('m_users uuu','u.share_userid = uuu.id','left')
                ->join('m_users_phone ppp','uuu.id = ppp.userid','left')
                ->count();

        }

        return $count;
    }
    
    /**
     * 方法描述: 获取数据用户的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getCount($c){
        $w = [];
        if($c){
            if($c['today']){
                $w['create_time'] = [
                    ['>=',date('Y-m-d',time())],
                    ['<', date('Y-m-d',time()+86400)]
                ];
            }
            if($c['todayland']){
                $w['last_land_time'] = [
                    ['>=',date('Y-m-d',time())],
                    ['<', date('Y-m-d',time()+86400)]
                ];
            }
        }
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                //判断当前帐号是否为集团会员
                if($this->brandId != db_config('sx_brand')){
                    $w['brandid'] = $this->brandId;
                }       
            }
        }
        if($c['usertype']!=1){
            $count = db('m_users_phone')->where($w)->count('id');
        }else{
            // 获取已经成为会员的id
            $w['id'] = ['not in',db('m_users_phone')->where($w)->where(['userid'=>['>',0]])->column('userid')];
            $count = MUsers::where($w)->count('id');
        }
        return $count;
    }
    
 
    /**
     * 方法描述: 当天用户获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTodayCount($c){
        return MUsers::wheretime('create_time','today')->count('id');
    }
    
    /**
     * 方法描述: 当天用户获取数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function  getTodayLandCount($c){
        $w = [
            'last_land_time' => [
                ['>=',date('Y-m-d',time())],
                ['<', date('Y-m-d',time()+86400)],
            ]
        ];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return MUsers::where($w)->count('id');
    }
    
    /**
     * 获取一条信息处理方法
     * @param array $d 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOne($id){
   
        if(!$id){
            return false;
        }else{
            $w = ['a.id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = MUsers::alias('a')
            ->where($w)
            ->field('n.title as couponname,n.img,a.id,a.title,a.start_time,a.index_img,a.scontent,a.content,a.end_time,a.couponid,a.view_total,a.status,a.share_score,a.order_num')
            ->join('__C_COUPON_NUM__ n','n.id=a.couponid','left')
            ->find();
            if($res){
                return $res;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 设置一条数据状态处理方法
     * @param int $id id
     * @param int $status 状态值
     * @param int $pid 手机表的id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function setStatus($id,$status,$pid){
        if(!$id && !$pid){
            return false;  
        }else{
            $w = [];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $d = ['status'=>$status];
            
            
            if(!$pid){
                $w['id'] = $id;
                $res = MUsers::where($w)->update($d);
            }else{
                $w['id'] = $pid;
                $res = MUsersPhone::where($w)->update($d);
            }
            //var_dump($res);
            //echo db()->getLastSql();die;
            return $res!==false?true:false;
        }
    }
    
    /**
     * 删除一条记录处理方法
     * @param int $id  用户id
     * @param int $pid 手机表的id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function del($id,$pid){
        if(!$id && !$pid){
            return false;
        }else{
            $w = [];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            if($pid){
                $w['id'] = $pid;
                $hasdata = MUsersPhone::where($w)->count();
                if($hasdata){
                    if(MUsersPhone::destroy($pid)){
                        return true;
                    }
                }
            }else{
                $w['id'] = $id;
                $hasdata = MUsers::where($w)->count();
                if($hasdata){
                    if(MUsers::destroy($id)){
                        return true;
                    }
                }
            }
            return false;
        }
    }
    
    /**
     * 获取导入列表
     * @param  array $c 查询条件
     * @return [type] [description]
     */
    public function getImportList($c){
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:1;
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid']    = $this->brandId;
            }
        }
        $d = db('c_excel_import')->where($w)->where('excel_type',1)
            ->field('id,file_name,fail_file_url,file_url,addtime,status,all_number,import_number,fail_number,brandid,staff_id,staff_name')
            ->order('addtime desc')
            ->limit($pagenum,$limit)
            ->select();
        return $d;
    }
    
    /**
     * 获取导入数据的总数
     * @param  array $c 查询条件
     * @return mixed
     */
    public function getImportCount($c){
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid']    = $this->brandId;
            }
        }
        return db('c_excel_import')->where($w)->where('excel_type',1)->count('id');
    }
    /**
     * 方法描述  获取下一个等级的数据
     * @param int $brandid 
     * @param int $value
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年2月4日 下午8:07:16
     */
    public function getNextLevel($brandid,$value){
        //判断当前帐号是否为集团会员
        if($this->brandId != db_config('sx_brand')){
            $w['brandid'] = $brandid;
        }
        $w['max_value'] = ['>',$value];
        $levels = db('user_level')->where($W)->field('id,max_value,name')->order('max_value asc')->find();
        return $levels?:null;
    }



    //导出
    function export($title,$data,$file){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('data1'); //给当前活动sheet设置名称
        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);

            //设置列宽
            $PHPExcel->setActiveSheetIndex(0);
            $PHPExcel->getActiveSheet()->getColumnDimension($range[$i])->setWidth(20);

            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$file);//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }

    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();

        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }
    
    
}