<?php
/**
 * 积分分类操作方法
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月16日 下午12:36:20
 */
namespace app\vip\lib;
use app\index\controller\Base;
use app\vip\model\WxMenu;
class WeixinConfig extends Base{
    
    /**
     * 方法描述     菜单列表
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getMenuList($c){
        if(!$c['pid']){
            $limit    = isset($c['limit'])?$c['limit']:5;
            $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        }
        $w = $w2 = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['m.brandid'] = $this->brandId;
                $w2['brandid']  = $this->brandId;
            }
        }
   
        if($c['pid']){
            $w2['parentid']=0;
            $d = WxMenu::where($w2)->field('id,name')->select();
            return $d;
        }else{
            $d = db('wx_menu')
            ->alias('m')
            ->where($w)
            ->join('wx_menu mp','mp.id=m.parentid','left')
            ->field('m.*,mp.name as mpname')
            ->limit($pagenum,$limit)
            ->order('parentid asc,id asc')->select();
            //var_dump($d);
            return $d;
           
        }
       
    }
    
    /**
     * 方法描述   获取自动回复信息列表
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getRelayList($c){
        if(!$c['pid']){
            $limit    = isset($c['limit'])?$c['limit']:5;
            $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        }
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        $d = db('wx_auto_relay')
        ->where($w)
        ->limit($pagenum,$limit)
        ->order('create_time desc')->select();
        return $d;

         
    }
    /**
     * 方法描述   获取自动回复信息的总条数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getRelayCount($c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
       return db('wx_auto_relay')->where($w)->count();

         
    } 
    
    
    
    /**
     * 方法描述     菜单总数
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午3:04:46
     */
    public function getMenuCount(array $c){
        $w = [];
        if(!$this->root){
            if(!$this->brandId){
                return false;
            }else{
                $w['brandid'] = $this->brandId;
            }
        }
        return WxMenu::where($w)->count('id');
    }
    /**
     * 方法描述   添加方法
     * @param  array $d 数据
     * @return bool 
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function add($d,$tablecode){
       if(!$d || !$tablecode){
           return false;
       }else{
           if($tablecode=='relay'){
               $table = 'wx_auto_relay';
           }else if($tablecode == 'menu'){
               $table = 'wx_menu';
           }
           if(!$table){
               return false;
           }
           $res   = db($table)->insertGetId($d);
           if($res){
                return true;
           }else{
                return false;
           }
       }
    }
    
    /**
     * 方法描述    修改方法
     * @param  array $d 数据数组,id单元必须存在
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function edit($d,$tablecode){
        if(!$d || !$d['id']){
            return false;
        }else{
            if($tablecode=='relay'){
                $table = 'wx_auto_relay';
            }else if($tablecode == 'menu'){
                $table = 'wx_menu';
            }
            if(!$table){
                return false;
            }
            $w = ['id'=>$d['id']];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            unset($d['id']);
            $isdata = db($table)->where($w)->find();
            if($isdata){
                $res = db($table)->where($w)->update($d);
                if($res!==false){
                    return true;
                }
                return false;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 方法描述    判断当前的值是否已经存在 
     * @param  int  $val  数据
     * @param  int  $pid  查询的父类id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function hasVal($name,$pid=0,$id=0){
        if(!$name){
            return false;
        }else{
             $w = [
                 'brandid'  => $this->brandId,
                 'parentid' => (int)$pid,
                 'name'     => $name,
            ];
             if($id){
                 $w['id'] =  ['neq',$id];
             }
             $res = WxMenu::where($w)->find();
             return $res?true:false;
        }
    }
    /**
     * 方法描述    判断当前的值是否已经存在
     * @param  int  $val  数据
     * @param  int  $pid  查询的父类id
     * @return bool
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function hasRelay($name,$id=0){
        if(!$name){
            return false;
        }else{
            $w = [
                'brandid'  => $this->brandId,
                'name'     => $name,
            ];
            if($id){
                $w['id'] =  ['neq',$id];
            }
            $res = db('wx_auto_relay')->where($w)->find();
            return $res?true:false;
        }
    }
    /**
     * 方法描述    软删除 
     * @param  int $id 
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午12:41:30
     */
    public function del($id,$tablecode){
        $id = (int)$id;
        if(!$id){
            return false;
        }else{
            $w = '';
            if($tablecode=='relay'){
                $table = 'wx_auto_relay';
                $w['id'] = $id;
            }else if($tablecode == 'menu'){
                $table = 'wx_menu';
                $w = "id=$id or parentid=$id";
            }
            if(!$table){
                return false;
            }

            $res = db($table)->where($w)->delete();
            if($res !== false){
                return true;
            }else{
                return false;
            }
        }
    }
    
    /**
     * 获取一条信息菜单详情
     * @param  int $id 数据数组
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月15日 下午12:41:30
     */
    public function getOneMenu($id){
        if(!$id){
            return false;
        }else{
            $w = ['id'=>$id];
            if(!$this->root){
                if(!$this->brandId){
                    return false;
                }else{
                    $w['brandid'] = $this->brandId;
                }
            }
            $res = WxMenu::where($w)
                    ->field('name,id,parentid,brandid,url')
                    ->find();
            return $res?$res:false;
        }
    }
 
}