<?php
/**
 * 广告Model控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\model;

use think\Model;
class AdverModel extends Model {
    /**
     * 广告数据入库处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function insert ($data) {
        $res = db('advertising')->insert($data);
        return $res;
    }
    /**
     * 广告列表数据查询
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function select () {
        //需要使用员工信息  待处理
        $advData = db('advertising')->paginate(2);
        return $advData;
    }
    /**
     * 广告修改数据查询
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function updates ($id) {
        $advData = db('advertising')->where('id','=',$id)->find();
        return $advData;
    }
    /**
     * 广告修改数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function advDispose ($id,$adv_name,$adv_img,$adv_count,$adv_status,$adv_seat) {
        $res = db('advertising')->where('id','=',$id)->update(
            [
                'adv_name' => $adv_name,
                'adv_img' => $adv_img,
                'adv_count' => $adv_count,
                'adv_status' => $adv_status,
                'adv_seat' => $adv_seat,
            ]
        );
        return $res;
    }
    /**
     * 广告数据删除
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function deletes ($id) {
        $res = db('advertising')->where('id','=',$id)->delete();
        return $res;
    }
}