<?php
/**
 * 评价问卷
 * User: zhaibaoming
 * Date: 2018/8/17 0017
 * Time: 9:15
 */

namespace app\vip\model;

use think\Model;

class McEvaluationQuestionnaire extends Model
{
    /**
     * 根据 部门id   typeid 分组 获取数据
     * @param $brandId
     * @return false|\PDOStatement|string|\think\Collection
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function getBrandIdData($brandId)
    {
        $where = [
            'brand_id' => $brandId,
            'is_del' => 1,
        ];
        $group = ' type_id ';
        return db('McEvaluationQuestionnaire')->where($where)->group($group)->select();
    }

    public function addData($param)
    {
        $user = new McEvaluationQuestionnaire;
        $user->title = $param['title'];
        $user->type_id = $param['type_id'];
        $user->brand_id = $param['brand_id'];
        $user->sort = $param['sort'];
        $user->is_del = 1;
        $user->create_time = time();
        $user->save();
        return $user->id;
    }

    public function addAllData($param)
    {
        $user = new McEvaluationQuestionnaire;
        $t = time();
        $list = [];
        foreach ($param as $k => $v) {
            $list[$k]['title'] = $v['title'];
            $list[$k]['type_id'] = $v['type_id'];
            $list[$k]['brand_id'] = $v['brand_id'];
            $list[$k]['is_del'] = 1;
            $list[$k]['create_time'] = $t;
        }
        $user->saveAll($list);
    }


    /**
     * 根据 部门id   typeid  获取数据
     * @param $brandId
     * @return false|\PDOStatement|string|\think\Collection
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function getBrandIdTypeIdData($brandId, $typeId)
    {
        $where = [
            'type_id' => $typeId,
            'brand_id' => $brandId,
            'is_del' => 1,
        ];
        $order = 'sort desc ,id asc ';
        return db('McEvaluationQuestionnaire')->where($where)->order($order)->select();
    }


    /**
     * 根据 id  部门id   typeid  获取数据
     * @param $brandId
     * @return false|\PDOStatement|string|\think\Collection
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function getIdBrandIdTypeIdData($id, $brandId, $typeId)
    {
        $where = [
            'id' => $id,
            'type_id' => $typeId,
            'brand_id' => $brandId,
            'is_del' => 1,
        ];
        return db('McEvaluationQuestionnaire')->where($where)->find();
    }


    /**
     * 删除
     * @param $id
     * @return int
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function del($id)
    {
        $where['id'] = $id;
        $saveData['is_del'] = 0;
        $user = new McEvaluationQuestionnaire;
        return $user->save($saveData, $where);
    }


    /**
     * 获取typeid 部门id 删除数据
     * @param $id
     * @return int
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function obtainTypeIdDel($typeId, $brandId)
    {
        $where['type_id'] = $typeId;
        $where['brand_id'] = $brandId;
        $saveData['is_del'] = 0;
        $user = new McEvaluationQuestionnaire;
        return $user->save($saveData, $where);
    }

    /**
     * 修改数据
     * @param $id
     * @return int
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function editData($param, $text)
    {
        $where['type_id'] = $param['type_id'];
        $where['brand_id'] = $param['brand_id'];
        $saveData['sort'] = $param['sort'];
        $where['id'] = $param['id'];
        $saveData['title'] = $text;
        $user = new McEvaluationQuestionnaire;
        return $user->save($saveData, $where);
    }
}