<?php


namespace app\vip\model;

class Package extends \think\Model {
        
    /**
     * 分类列表 数据
     * 
     * @param  page       页数
     * @param  limit      分页数量
     * @param  order      排序
     * @param  brand_id   事业部id
     *
     * @return array
     * @author lilong
     */
    public function getLimitCat($param) {
        $where = [
            'brandclass_id'=> $param['brand_id'],
            'is_delete'  => 1,
        ];
        $order = 'sort asc, id desc';
        $res = db('s_cat')->where($where)->order($order)->limit($param['page'], $param['limit'])->select();
        return $res;
    }

    /**
     * 分类列表 总数
     * 
     * @param  brand_id   事业部id
     *
     * @return int
     * @author lilong
     */
    public function getCountCat($param){
        $where = [
            'brandclass_id'=> $param['brand_id'],
            'is_delete'  => 1,
        ];

        $res = db('s_cat')->where($where)->count();
        return $res;
    }
    /**
     * 获取单个分类
     * 
     * @param  id   分类id
     *
     * @return int
     * @author lilong
     */
    public function getOneCat($param){
        $id = (int)$param['id'];

        $where = [
            'id'    => $id,
            'is_delete'=> 1,
        ];

        $res = db('s_cat')->where($where)->find();
        return $res;
    }

    /**
     * 新增分类
     * 
     * @param  brand_id   事业部id
     *
     * @return int
     * @author lilong
     */
    public function addCat($param){
        $data['name']  = trim($param['name']);
        $data['status']= $param['status'] ? (int)$param['status'] : 1;
        $data['sort']  = (int)$param['sort'];
        $data['is_delete']    = 1;
        $data['brandclass_id']= (int)$param['brand_id'];
        $data['create_time']  = date('Y-m-d H:i:s');
        $res = db('s_cat')->insert($data);
        return $res;
    }
    /**
     * 编辑分类
     * 
     * @param  id   套系id 及其他
     *
     * @return int
     * @author lilong
     */
    public function editCat($param){
        $id = (int)$param['id'];

        $data['name']  = trim($param['name']);
        $data['status']= $param['status'] ? (int)$param['status'] : 1;
        $data['sort']  = (int)$param['sort'];
        // $data['brandclass_id']= (int)$param['brand_id'];
        $data['update_time']  = date('Y-m-d H:i:s');
        
        $res = db('s_cat')->where('id', $id)->update($data);
        return $res;
    }
    /**
     * 删除分类
     * 
     * @param  id   套系id
     *
     * @return view
     * @author int
     */
    public function delCat($param){
        $id = (int)$param['id'];

        $data['is_delete'] = 2;
        $data['update_time'] = date('Y-m-d H:i:s');

        $res = db('s_cat')->where('id', $id)->update($data);
        return $res;
    }


    /*------------------------------------- 分类、套系分割线 -------------------------------------*/

    /**
     * 套系列表
     * 
     * @param  page       页数
     * @param  limit      分页数量
     * @param  order      排序
     * @param  brand_id   事业部id
     *
     * @return array
     * @author lilong
     */
    public function getLimit($param) {
        $where = [
            'brand_id'=> $param['brand_id'],
            'is_del'  => 1,
        ];

        if($param['shop_code'])     $where['shop_code'] = $param['shop_code'];
        if($param['package_name'])  $where['package_name'] = ['like','%'.$param['package_name'].'%'];

        $order = 'p_sort desc, id desc';
        $res = db('s_package_info')->alias('p')->join('s_cat c','p.cat_id=c.id','left')->field('p.*,c.name as cat_name')->where($where)->order($order)->limit($param['page'], $param['limit'])->select();
        //print_r(db()->getLastSql());die;
        return $res;
    }

    /**
     * 套系列表
     * 
     * @param  brand_id   事业部id
     *
     * @return int
     * @author lilong
     */
    public function getCount($param){
        $where = [
            'brand_id'=> $param['brand_id'],
            'is_del'  => 1,
        ];

        if($param['shop_code'])     $where['shop_code'] = $param['shop_code'];
        if($param['package_name'])  $where['package_name'] = ['like','%'.$param['package_name'].'%'];

        $res = db('s_package_info')->where($where)->count();
        return $res;
    }

    /**
     * 套系列表
     * 
     * @param  id   套系id
     *
     * @return int
     * @author lilong
     */
    public function getOnePackage($param){
        $id = (int)$param['id'];

        $where = [
            'id'=> $id,
            'is_del'  => 1,
        ];

        $res = db('s_package_info')->where($where)->find();
        return $res;
    }

    /**
     * 新增套系
     * 
     * @param  brand_id   事业部id
     *
     * @return int
     * @author lilong
     */
    public function addPackage($param){
        $data['package_name'] = trim($param['package_name']);
        $data['erp_package_name'] = trim($param['erp_package_name']);
        $data['erp_package_shop_code'] = trim(trim($param['erp_package_shop_code'],','));

        $data['package_price'] = number_format($param['package_price'],2,".","");
        $data['package_price_down'] = $param['package_price_down'] ? number_format($param['package_price_down'],2,".","") : 0;
        $data['erp_package_price'] = number_format($param['erp_package_price'],2,".","");

        $data['package_title_img']= trim($param['package_title_img']);
        $data['package_contents'] = trim($param['package_contents']);

        $data['consumption_type'] = trim($param['consumption_type']);//消费类型
        $data['use_coupon'] = trim($param['use_coupon']);//是否可使用优惠券

        $data['create_time'] = date('Y-m-d H:i:s');

        $data['shop_code'] = trim($param['shop_code']);
        $data['shop_name'] = trim($param['shop_name']);
        $data['shop_sn']   = trim($param['shop_sn']);
        $data['brand_id']= (int)$param['brand_id'];
        $data['p_sort']  = (int)$param['p_sort'];

        $data['cat_id'] = $param['c_id'] ? (int)$param['c_id'] : null;
        $data['is_recommend'] = $param['is_recommend'] ? (int)$param['is_recommend'] : 2;
        $data['rec_img'] = trim($param['rec_img']);
        $data['cam_ids'] = $param['cam_ids'];
        $data['pro_ids'] = $param['pro_ids'];
        $res = db('s_package_info')->insert($data);
        return $res;
    }

    /**
     * 删除套系
     * 
     * @param  id   套系id
     *
     * @return view
     * @author int
     */
    public function delPackage($param){
        $id = (int)$param['id'];

        $data['is_del'] = 2;
        $data['update_time'] = date('Y-m-d H:i:s');

        $res = db('s_package_info')->where('id', $id)->update($data);
        return $res;
    }

    /**
     * 编辑套系
     * 
     * @param  id   套系id 及其他
     *
     * @return int
     * @author lilong
     */
    public function editPackage($param){
        $id = (int)$param['id'];

        $data['package_name'] = trim($param['package_name']);
        $data['erp_package_name'] = trim($param['erp_package_name']);
        $data['erp_package_shop_code'] = trim(trim($param['erp_package_shop_code'],','));

        $data['package_price'] = number_format($param['package_price'],2,".","");
        $data['package_price_down'] = $param['package_price_down'] ? number_format($param['package_price_down'],2,".","") : 0;
        $data['erp_package_price'] = number_format($param['erp_package_price'],2,".","");

        $data['package_title_img']= trim($param['package_title_img']);
        $data['package_contents'] = trim($param['package_contents']);

        $data['consumption_type'] = trim($param['consumption_type']);//消费类型
        $data['use_coupon'] = trim($param['use_coupon']);//是否可使用优惠券

        $data['update_time'] = date('Y-m-d H:i:s');

        $data['shop_code'] = trim($param['shop_code']);
        $data['shop_name'] = trim($param['shop_name']);
        $data['shop_sn']   = trim($param['shop_sn']);
        $data['brand_id']= (int)$param['brand_id'];
        $data['p_sort']  = (int)$param['p_sort'];

        $data['cat_id'] = $param['c_id'] ? (int)$param['c_id'] : null;
        $data['is_recommend'] = $param['is_recommend'] ? (int)$param['is_recommend'] : 2;
        $data['rec_img'] = trim($param['rec_img']);
        $data['cam_ids'] = $param['cam_ids'];
        $data['pro_ids'] = $param['pro_ids'];
        
        $res = db('s_package_info')->where('id', $id)->update($data);
        return $res;
    }
}

