<?php
/**
* 推荐Model控制器。
*
*  * ============================================================================
* 版权所有 2017北京素玄科技，并保留所有权利。
*
* 网站地址: http://www.suxuantech.com
* ----------------------------------------------------------------------------
* 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
* 不允许对程序代码以任何形式任何目的的再发布。
* 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
* ============================================================================
* $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
*/
namespace app\vip\model;
use think\Model;
class RecommendModel extends Model {
    /**
     * 用户推荐列表数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function select () {
        $res = db('recommend')
            ->alias('a')
            ->join('m_users b','a.userid = b.id')
            ->paginate(3);
        return $res;
    }
    /**
     * 用户推荐列表搜索数据处理
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function search ($phone,$name) {
        $res = db('recommend')
            ->where('r_phone','like',"%$phone%")
            ->paginate(1,false,['query'=>['r_phone' => $phone]]);
        return $res;
    }
    /**
     * 前台用户推荐列表数据查询
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public static function MemSelect ($memId) {
        $data = db('recommend')
            ->where('userid','=',$memId)
            ->select();
        return $data;
    }
    protected function getStatusAttr($value) {
        $text = [1 => '未通过', 2 => '审核通过', 3 => '待处理'];
        return $text[$value];
    }
    /**
     * 前台用户推荐列表总人数查询
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public static function MemSum ($memId) {
        $data = db('recommend')
            ->where('userid','=',$memId)
            ->count();
        return $data;
    }
}