<?php
/**
 * 用户任务列表的处理。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<Yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\vip\model;
use think\Model;
use think\Session;

class TTaskList extends Model{
    /**
     * 任务添加
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function insert ($data) {
        $datas = db('t_task_list')->insert($data);
        return $datas;
    }
    /**
     * 前台用户查看任务详情页面数据查询
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function taskFrontPart ($id) {
        $data = db('t_task_list')
            ->alias('a')
            ->where('a.id','=',$id)
            ->join('t_task_user_list b','a.id = b.taskid')
            ->join('m_users c','b.userid = c.id')
            ->order('b.create_time desc')
            ->select();
        return $data;
    }
    /**
     * 任务数据分页查看
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function select () {
        $brandid = Session::get('brandid');
        $taskData = db('t_task_list')->where('brandid','=',$brandid)->order('order_num desc')->paginate(3);
        return $taskData;
    }
    /**
     * 前台任务数据查看
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public static function selectS () {
        $brandid = Session::get('brand_id');
        $taskData = db('t_task_list')->where('brandid','=',$brandid)->select();
        return $taskData;
    }
    /**
     * 前台任务根据人气查看
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public static function selectMoods () {
        $brandid = Session::get('brand_id');
        $taskData = db('t_task_list')->where('brandid','=',$brandid)->order('receive_total desc')->select();
        return $taskData;
    }
    /**
     * 后台任务数据查看
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function selectDa ($id) {
        $taskData = db('t_task_list')->where('id','=',$id)->find();
        return $taskData;
    }
    /**
     * 任务数据修改
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function updates ($id,$title,$card_img,$task_typeid,$reward_score,$share_score,$days,$scontent,$content) {
        $res = db('t_task_list')->where('id','=',$id)->update(
            [
                'card_name' => $title,
                'index_img' => $card_img,
                'task_typeid' => $task_typeid,
                'reward_score' => $reward_score,
                'share_score' => $share_score,
                'days' => $days,
                'scontent' => $scontent,
                'content' => $content,
            ]
        );
        return $res;
    }
    /**
     * 任务数据删除
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function delete ($id) {
       $res = db('t_task_list')->where('id','=',$id)->delete();
        return $res;
    }
    /**
     * 按照任务名称搜索
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function search ($title) {
        $taskData = db('t_task_list')->where('title','like',"%$title%")->paginate(1,false,['query'=>['title' => $title]]);
        return $taskData;
    }
    /**
     * 会员单条任务执行记录查询
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memTask ($taskId,$userId) {
        $res = db('t_task_user_list')
            ->alias('a')
            ->where('a.taskid','=',$taskId)
            ->whereOr('a.userid','=',$userId)
            ->join('t_task_detail b','a.userid = b.userid')
            ->join('m_users c',' a.userid = c.id')
            ->paginate(2);
        return $res;
    }
    /**
     * 会员任务详情执行记录查询
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function taskDetails ($taskId) {
        $res = db('t_task_user_list')
            ->alias('a')
            ->where('a.taskid','=',$taskId)
            ->join('t_task_detail b','a.userid = b.userid')
            ->join('m_users c',' a.userid = c.id')
            ->paginate(2);
        return $res;
    }
    /**
     * 会员任务详情执行记录统计次数查询
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function taskNeck ($taskId) {
        $sum = db('t_task_list')->where('id','=',$taskId)->select();
        return $sum;
    }

    /**
     * 会员单条任务执行记录搜索带分页查询
     * @param  String  $data   添加的数据
     * @return int $info 返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
//    public function memTaskSea ($phone,$title) {
//        $pageParm = ['query' => []];
//        $array =array();
//        if ($phone) {
//            $array['c.phone'] = $phone;
//            db('m_users')->where('phone','like',"%$phone%");
//            $pageParam['query']['phone'] = $phone;
//        }
//        if ($title) {
//            $array['d.title'] = $title;
//            db('m_users')->where('title','like',"%$title%");
//            $pageParam['query']['title'] = $title;
//        }
//        $res = db('t_task_user_list')
//            ->where('')
//            ->alias('a')
//            ->join('t_task_detail b','a.userid = b.userid')
//            ->join('m_users c',' a.userid = c.id')
//            ->join('t_task_list d','a.taskid = d.id ')
//            ->paginate(2,false,$pageParm);
//        return $res;
//    }

}