$(function() {
    var dataFall = [];
    var type_id = $('.mui-scroll-wrapper .mui-active').attr('data-type');
    var pageIndex = 1;
    var limit = 10;

    //获取初始第一页数据
    get(type_id,pageIndex,limit);

    //type_id  客片类型  page页数  limit每页条数
    function get(type_id,page,limit){

        $.ajax({
            dataType: "json",
            type: 'get',
            url: "/front/Guestphoto/getTypePhoto",
            data:{type_id:type_id,page:page,limit:limit},
            success: function(result) {
                console.log(result);

                dataFall = result.data;
                if(dataFall.length > 0){
                    setTimeout(function() {
                        appendFall();
                    }, 1000);
                }else{
                    // $('.more-a').css('display','none');
                    $('body .more-a').css('display','none');
                }

            },
            error: function(e) {
                console.log('请求失败')
            }
        });
    }

    /*瀑布流初始化设置*/
    var $grid = $('.grid').masonry({
        itemSelector: '.grid-item',
        gutter: 10
    });

    // layout Masonry after each image loads
    $grid.imagesLoaded().done(function() {
        $grid.masonry('layout');
    });

    $(window).scroll(function() {
        $grid.masonry('layout');
        var scrollTop = $(this).scrollTop();
        var scrollHeight = $(document).height();
        var windowHeight = $(this).height();

        if ((scrollTop + windowHeight) > (scrollHeight-1)) {
            pageIndex = pageIndex +1;

            get(type_id,pageIndex,limit);

        }
    });

    function appendFall() {

        $.each(dataFall, function(index, value) {

            var dataLength = dataFall.length;
            $grid.imagesLoaded().done(function() {
                $grid.masonry('layout');
            });
            var detailUrl;
            var $griDiv = $('<a href="/front/Guestphoto/detail?id='+value.id+'" class="grid-item item wyn">');
            var $img = $("<img class='item-img'>");
            $img.attr('src', value.cover_img).appendTo($griDiv);
            var $section = $('<section class="section-p">');
            $section.appendTo($griDiv);
            var $p1 = $("<p class='title-p'>");
            $p1.html(value.title).appendTo($section);
            var $p2 = $("<p class='name-p'>");
            $p2.html(value.content_text).appendTo($section);
            var $items = $griDiv;
            $items.imagesLoaded().done(function() {
                console.log(index)
                $grid.masonry('layout');
                $grid.append($items).masonry('appended', $items);
            });

        });
    }

    //切换分类
    mui(".mui-scroll-wrapper").on('tap','.mui-control-item',function(){
        //location.href = $(this).attr('data-url');
        type_id = $(this).attr('data-type');

        $('.wyn').remove();
        $('.more-a').css('display','block');
        $grid.masonry('reloadItems');

        pageIndex = 1;
        get(type_id,pageIndex,limit);
        $('.grid').html('');

    });

    //切换分类
    $('.kp-ul').on('click','.flex',function(){
        type_id = $(this).attr('data-type');

        ('.wyn').remove();
        $('.more-a').css('display','block');
        $grid.masonry('reloadItems');

        pageIndex = 1;
        get(type_id,pageIndex,limit);
    });
});