/*
Navicat MySQL Data Transfer

Source Server         : wamp
Source Server Version : 50719
Source Host           : localhost:3306
Source Database       : 99_sx_mc

Target Server Type    : MYSQL
Target Server Version : 50719
File Encoding         : 65001

Date: 2019-09-19 16:14:26
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for api_app
-- ----------------------------
DROP TABLE IF EXISTS `api_app`;
CREATE TABLE `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型1素玄系统应用，2第三方应用',
  `app_info` tinytext COLLATE utf8_unicode_ci COMMENT '应用说明',
  `app_prefix` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '应用前缀',
  `app_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='appId和appSecret表';

-- ----------------------------
-- Records of api_app
-- ----------------------------
INSERT INTO `api_app` VALUES ('3', '94201193', '8c20ef99bab7d7bedac8e97c79cabf8f', '管理中心APP', '1', '1', '', '', null);
INSERT INTO `api_app` VALUES ('4', '44793168', '8c20ef99bab7d7bedac8e97c79cabf8f', '客资系统', '1', '1', '客资CRM系统', '', null);
INSERT INTO `api_app` VALUES ('5', '48383736', '8c20ef99bab7d7bedac8e97c79cabf8f', '素玄ERP服务端', '1', '1', '', null, null);
INSERT INTO `api_app` VALUES ('6', 'sx_vip', '8c20ef99bab7d7bedac8e97c79cabf8f', '素玄会员系统', '1', '1', null, null, null);
INSERT INTO `api_app` VALUES ('8', '13675422', '8c20ef99bab7d7bedac8e97c79cabf8f', 'test', '1', '1', '', null, null);

-- ----------------------------
-- Table structure for api_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `api_auth_group`;
CREATE TABLE `api_auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '组名称',
  `description` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '组描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '组状态：为1正常，为0禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='权限组';

-- ----------------------------
-- Records of api_auth_group
-- ----------------------------
INSERT INTO `api_auth_group` VALUES ('1', '全部权限', 'xczv', '1');

-- ----------------------------
-- Table structure for api_auth_group_access
-- ----------------------------
DROP TABLE IF EXISTS `api_auth_group_access`;
CREATE TABLE `api_auth_group_access` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) unsigned NOT NULL,
  `groupId` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户和组的对应关系';

-- ----------------------------
-- Records of api_auth_group_access
-- ----------------------------
INSERT INTO `api_auth_group_access` VALUES ('1', '1', '1');

-- ----------------------------
-- Table structure for api_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `api_auth_rule`;
CREATE TABLE `api_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `url` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '规则唯一标识',
  `groupId` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限所属组的ID',
  `auth` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限数值',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：为1正常，为0禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=361 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='权限细节';

-- ----------------------------
-- Records of api_auth_rule
-- ----------------------------
INSERT INTO `api_auth_rule` VALUES ('1', 'Index/welcome', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('2', 'Index/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('3', 'System/getOpenid', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('4', 'System/serverValid', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('5', '2', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('6', 'Menu/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('7', 'Menu/add', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('8', 'Menu/edit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('9', 'Menu/close', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('10', 'Menu/open', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('11', 'Menu/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('12', 'System/passwordSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('13', 'User/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('14', 'User/add', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('15', 'User/close', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('16', 'User/open', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('17', 'User/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('18', 'System/acl', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('19', 'System/acladd', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('20', 'System/acldel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('21', 'System/acltoken', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('22', 'System/acltokenadd', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('23', 'System/acltokendel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('24', 'System/aclstatus', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('25', 'SmsLog/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('26', 'SmsLog/ajaxGetIndex', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('27', 'SmsLog/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('28', 'Permission/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('29', 'Permission/add', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('30', 'Permission/close', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('31', 'Permission/open', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('32', 'Permission/edit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('33', 'Permission/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('34', 'Permission/group', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('35', 'Permission/member', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('36', 'Permission/delMember', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('37', 'Permission/rule', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('38', 'Log/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('39', 'Log/ajaxGetIndex', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('40', 'Log/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('41', 'Log/showDetail', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('42', '7', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('43', 'App/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('44', 'App/edit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('45', 'App/add', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('46', 'App/open', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('47', 'App/close', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('48', 'App/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('49', 'ApiManage/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('50', 'ApiManage/add', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('51', 'ApiManage/open', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('52', 'ApiManage/close', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('53', 'ApiManage/edit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('54', 'ApiManage/del', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('55', 'FieldsManage/response', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('56', 'FieldsManage/request', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('57', 'FieldsManage/add', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('58', 'FieldsManage/edit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('59', 'FieldsManage/upload', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('60', 'FieldsInfoManage/index', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('61', '91', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('62', 'Sms/Sign', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('63', 'Sms/Signadd', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('64', 'Sms/Signedit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('65', 'Sms/Signdel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('66', 'Sms/Template', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('67', 'Sms/Templatedel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('68', 'Sms/Templateedit', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('69', 'Sms/Templateadd', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('70', 'System/consumptionType', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('71', 'System/addConsumptionType', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('72', 'System/editConsumptionType', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('73', 'System/delConsumptionType', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('74', 'personnel/address', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('75', 'personnel/addChildAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('76', 'personnel/delAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('77', 'personnel/editAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('78', 'personnel/addAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('79', 'personnel/address_search', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('80', 'Personnel/getAddressName', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('81', 'System/areaSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('82', 'System/addArea', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('83', 'System/editArea', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('84', 'System/delArea', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('85', 'System/cusSource', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('86', 'System/addCusSource', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('87', 'System/editCusSource', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('88', 'System/delCusSource', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('89', 'System/intentionSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('90', 'System/addIntention', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('91', 'System/editIntention', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('92', 'System/delIntention', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('93', 'System/accessModel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('94', 'System/addAccess', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('95', 'System/editAccess', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('96', 'System/delAccess', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('97', 'System/regionSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('98', 'System/addRegion', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('99', 'System/editRegion', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('100', 'System/delRegion', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('101', 'System/capacity', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('102', 'System/addCapacity', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('103', 'System/editCapacity', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('104', 'System/delCapacity', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('105', 'System/acceptorAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('106', 'System/addAcceptorAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('107', 'System/editAcceptorAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('108', 'System/delAcceptorAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('109', 'System/template', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('110', 'System/addTemplate', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('111', 'System/editTemplate', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('112', 'System/delTemplate', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('113', 'System/globalSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('114', 'System/searchContent', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('115', '50', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('116', 'Import/importStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('117', 'Import/uploadExcel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('118', 'Import/deleteImport', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('119', 'Import/doImport', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('120', 'Import/getImportPercent', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('121', 'Import/detailImport', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('122', 'Import/updateImportDetail', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('123', 'Personnel/GroupCompany', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('124', 'Personnel/GroupCompany', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('125', 'Personnel/brandClass', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('126', 'Personnel/addBrand', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('127', 'Personnel/editBrand', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('128', 'Personnel/delBrand', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('129', 'Personnel/shopSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('130', 'Personnel/editShop', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('131', 'Personnel/delShop', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('132', 'Personnel/addShop', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('133', 'Personnel/department', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('134', 'Personnel/addDepartment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('135', 'Personnel/editDepartment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('136', 'Personnel/delDepartment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('137', 'Personnel/brandShop', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('138', 'personnel/batchSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('139', 'personnel/doBatch', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('140', 'personnel/search_positon', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('141', 'Personnel/staffGroup', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('142', 'Personnel/addGroup', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('143', 'Personnel/editGroup', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('144', 'Personnel/delGroup', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('145', 'personnel/searchGroup', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('146', 'personnel/getNextAddress', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('147', 'Personnel/position', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('148', 'Personnel/addPosition', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('149', 'Personnel/editPosition', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('150', 'Personnel/delPosition', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('151', 'personnel/copyPosition', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('152', 'personnel/doCopy', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('153', 'Personnel/zhijiSet', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('154', 'Personnel/addZhiji', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('155', 'Personnel/editZhiji', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('156', 'Personnel/delZhiji', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('157', 'Personnel/staff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('158', 'Personnel/addStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('159', 'Personnel/editStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('160', 'Personnel/delStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('161', 'Personnel/searchShop', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('162', 'Personnel/searchDepartment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('163', 'personnel/exportStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('164', 'Personnel/delLeaveStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('165', 'Personnel/workTypeLevel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('166', 'Personnel/addWorkLevel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('167', 'Personnel/editWorkLevel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('168', 'personnel/leaveStaff', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('169', 'Register/leaveOffice', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('170', 'Register/addRecruitment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('171', 'Register/editRecruitment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('172', 'Register/delRecruitment', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('173', 'Register/positionChange', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('174', 'Register/recruitmentApply', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('175', '78', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('176', 'Channel/channelClass', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('177', 'Channel/addChannel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('178', 'Channel/editChannel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('179', 'Channel/delChannel', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('180', 'Channel/channelInfo', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('181', 'Channel/addChannelInfo', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('182', 'Channel/editChannelInfo', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('183', 'Channel/delChannelInfo', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('184', 'Reason/unValidReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('185', 'Reason/addUnValidReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('186', 'Reason/editUnValidReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('187', 'Reason/delUnValidReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('188', 'Reason/notOrderReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('189', 'Reason/addNotOrderReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('190', 'Reason/editNotOrderReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('191', 'Reason/delNotOrderReason', '1', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('256', 'Reason/unValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('257', 'Reason/addUnValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('258', 'Reason/editUnValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('259', 'Reason/delUnValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('260', 'Reason/notOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('261', 'Reason/addNotOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('262', 'Reason/editNotOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('263', 'Reason/delNotOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('316', 'Reason/unValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('317', 'Reason/addUnValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('318', 'Reason/editUnValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('319', 'Reason/delUnValidReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('320', 'Reason/notOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('321', 'Reason/addNotOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('322', 'Reason/editNotOrderReason', '3', '0', '1');
INSERT INTO `api_auth_rule` VALUES ('323', 'Reason/delNotOrderReason', '3', '0', '1');

-- ----------------------------
-- Table structure for api_fields
-- ----------------------------
DROP TABLE IF EXISTS `api_fields`;
CREATE TABLE `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=1852 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用于保存各个API的字段规则';

-- ----------------------------
-- Records of api_fields
-- ----------------------------
INSERT INTO `api_fields` VALUES ('1', 'aaa', '', '8', '123123', '1', 'fsdf', 'sf', '0', 'aaa');
INSERT INTO `api_fields` VALUES ('2', 'sdf', '', '1', 'asdf', '1', '', '', '0', 'sdf');
INSERT INTO `api_fields` VALUES ('3', '123', '', '1', '`12', '1', '`12', '', '0', '123');
INSERT INTO `api_fields` VALUES ('10', 'ergerger', '59ea0cd052201', '1', '324234', '0', '2342342', '34234', '1', 'ergerger');
INSERT INTO `api_fields` VALUES ('11', 'username', '59eb02fb401b1', '2', '', '1', 'test', '我是说明\n', '0', 'username');
INSERT INTO `api_fields` VALUES ('12', 'password', '59eb02fb401b1', '2', '', '1', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('13', 'username', '59eb2c9d9b723', '2', '', '1', '', '用于登录的用户名，可以是手机号，或staff表内的登录名。', '0', 'username');
INSERT INTO `api_fields` VALUES ('14', 'password', '59eb2c9d9b723', '2', '', '1', '', '登录密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('16', 'code', '59eb2c9d9b723', '1', '200', '1', '', '返回200表示成功。其他为失败', '1', 'code');
INSERT INTO `api_fields` VALUES ('17', 'staffid', '59eb382d6af16', '1', '', '1', '', '', '0', 'staffid');
INSERT INTO `api_fields` VALUES ('18', 'username', '59ec9360b6861', '2', '', '1', '', '用户名', '0', 'username');
INSERT INTO `api_fields` VALUES ('19', 'password', '59ec9360b6861', '2', '', '1', '', 'password', '0', 'password');
INSERT INTO `api_fields` VALUES ('20', 'username', '59f15d141e7e2', '2', '', '1', '', '', '0', 'username');
INSERT INTO `api_fields` VALUES ('21', 'oldpwd', '59f15d141e7e2', '2', '', '1', '', '', '0', 'oldpwd');
INSERT INTO `api_fields` VALUES ('22', 'newpwd', '59f15d141e7e2', '2', '', '1', '', '新密码', '0', 'newpwd');
INSERT INTO `api_fields` VALUES ('23', 'staffname', '59f2e9fb5f863', '2', '', '1', '', '员工名', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('24', 'password', '59f2e9fb5f863', '2', '', '1', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('26', 'staff_id', '59f424811d52f', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('28', 'staff_id', '59f44a14c3cae', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('29', 'oldPassword', '59f44a14c3cae', '2', '', '1', '', '旧密码', '0', 'oldPassword');
INSERT INTO `api_fields` VALUES ('30', 'newPassword', '59f44a14c3cae', '2', '', '1', '', '新密码', '0', 'newPassword');
INSERT INTO `api_fields` VALUES ('32', 'staff_id', '59f933a395abe', '1', '5', '1', '', '', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('33', 'group_name', '59f95e5ab44ef', '2', '重案六组', '1', '', '组名', '0', 'group_name');
INSERT INTO `api_fields` VALUES ('34', 'staff_id', '59f95e5ab44ef', '1', '5', '1', '', '自己的id，查询时排除此条', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('35', 'name', '59fad7a50fde8', '1', '', '1', '', '需查询的品牌名或者店面名', '0', 'name');
INSERT INTO `api_fields` VALUES ('36', 'type', '59fad7a50fde8', '1', '', '1', '', '1为品牌，2为店面', '0', 'type');
INSERT INTO `api_fields` VALUES ('37', 'id', '59fd885ed3628', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('38', 'id', '59fd5f0792e10', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('39', 'accessmodel', '59fd5f0792e10', '2', '', '0', '', '', '0', 'accessmodel');
INSERT INTO `api_fields` VALUES ('40', 'shop_name', '59fd5f0792e10', '2', '', '0', '', '', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('41', 'id', '59fd5e729e5a8', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('42', 'id', '59fd5f6c1d340', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('43', 'id', '59fd5fa926b98', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('44', 'id', '59fd5ec462c88', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('45', 'id', '59fd58574204a', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('46', 'id', '5a004e9c3e030', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('47', 'id', '5a00506445948', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('48', 'shop_name', '5a005e0038270', '2', '', '0', '', '店面名称', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('49', 'shop_code', '5a005e0038270', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('50', 'brandclass', '5a005e0038270', '2', '', '0', '', '所属品牌（事业部）', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('51', 'staffname', '5a01766b4a3dd', '2', '', '0', '', '员工名字', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('52', 'staffnumber', '5a01766b4a3dd', '2', '', '0', '', '员工编号', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('53', 'sex', '5a01766b4a3dd', '2', '', '0', '', '性别', '0', 'sex');
INSERT INTO `api_fields` VALUES ('54', 'shop_name', '5a01766b4a3dd', '2', '', '0', '', '所属店面，查询同一店面员工信息', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('55', 'shop_code', '5a01766b4a3dd', '2', '', '0', '', '所属店面编号', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('56', 'id', '5a01766b4a3dd', '1', '', '0', '', '员工id，若为批量查询，id之间以逗号隔开', '0', 'id');
INSERT INTO `api_fields` VALUES ('57', 'shop_code', '5a02666c9935d', '2', '5555555555', '1', '', '商铺编号', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('58', 'open_id', '5a0294f3f243e', '2', '5555', '1', '', '', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('59', 'staffname', '5a029ee140dba', '2', '王振亚', '1', '', '员工名', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('60', 'password', '5a029ee140dba', '2', '123456', '1', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('61', 'open_id', '5a029ee140dba', '2', '5555', '1', '', '', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('62', 'shop_code', '5a00506445948', '2', '', '0', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('63', 'shop_name', '5a00506445948', '2', '', '0', '', '', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('64', 'id', '5a08fbe736447', '1', '5', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('65', 'status', '5a08fbe736447', '1', '1', '1', '', '状态：1：在线；2：忙碌；3：离线', '0', 'status');
INSERT INTO `api_fields` VALUES ('66', 'five', '59f2e9fb5f863', '1', '0', '0', '', '5天自动登录', '0', 'five');
INSERT INTO `api_fields` VALUES ('70', 'shop_code', '5a0a7bc01da07', '2', '5555555555', '1', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('71', 'app_name', '5a0a9ddc8f9d9', '2', '', '1', '', '当前安装的应用名称', '0', 'app_name');
INSERT INTO `api_fields` VALUES ('72', 'app_id', '5a0a9ddc8f9d9', '2', '', '1', '', '应用的APP代码，即sx_crm sc_erp等。相同应用代码，只能安装一个。', '0', 'app_id');
INSERT INTO `api_fields` VALUES ('73', 'app_code', '5a0a9ddc8f9d9', '2', '', '1', '', '产品码，在应用安装时，录入的，应用需用此码云端验证完成后，再调用本接口进行安装注册', '0', 'app_code');
INSERT INTO `api_fields` VALUES ('74', 'app_prefix', '5a0a9ddc8f9d9', '2', '', '1', '', '应用访问前缀，用户调用时，只需要在此前缀后加接口hash值即可。', '0', 'app_prefix');
INSERT INTO `api_fields` VALUES ('75', 'app_info', '5a0a9ddc8f9d9', '2', '', '0', '', 'APP的备注信息，用于说明APP的使用范围及作用等。', '0', 'app_info');
INSERT INTO `api_fields` VALUES ('76', 'shop_code', '59fd58574204a', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('77', 'shop_code', '5a004e9c3e030', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('78', 'shop_code', '59fd5e729e5a8', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('79', 'shop_code', '59fd5ec462c88', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('80', 'shop_code', '59fd5f0792e10', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('81', 'shop_code', '59fd5f6c1d340', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('82', 'shop_code', '59fd5fa926b98', '2', '', '0', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('83', 'id', '5a0aef152b750', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('84', 'shop_code', '5a0aef152b750', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('85', 'id', '5a0b96b65c111', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('86', 'shop_code', '5a0b96b65c111', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('87', 'shop_code', '5a0a624728618', '1', '0', '1', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('88', 'shop_code', '5a0c42f43e986', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('89', 'shop_code', '5a0c43da3e99a', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('90', 'code', '5a0e5f4ced930', '2', '', '1', '', '跳转管理中心后，回跳时，传的code', '0', 'code');
INSERT INTO `api_fields` VALUES ('92', 'qr_code', '5a1027da4e9c1', '2', '', '0', '', '如果传入qr_code这个字段，则返回当前这个CODE的基本信息，\n其中：\nstate:\n空或init表示初始状态\nscaned:已扫码（需要扫码者预操作）\nlogined:已登录', '0', 'qr_code');
INSERT INTO `api_fields` VALUES ('93', 'code', '5a125fdfc4f6b', '2', '', '1', '', '', '0', 'code');
INSERT INTO `api_fields` VALUES ('94', 'shop_code', '5a14dd1d722a6', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('95', 'id', '5a14dd1d722a6', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('96', 'shop_code', '5a14de25a68f0', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('97', 'id', '5a14de25a68f0', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('98', 'shop_code', '5a14de993bb90', '2', '', '0', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('99', 'id', '5a14de993bb90', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('100', 'shop_code', '5a14dec689d91', '2', '', '0', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('101', 'id', '5a14dec689d91', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('102', 'shop_code', '5a14dfc86bf72', '2', '', '0', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('103', 'id', '5a14dfc86bf72', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('104', 'shop_code', '5a14e013b447a', '2', '', '0', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('105', 'id', '5a14e013b447a', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('106', 'shop_code', '5a1510583e3a5', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('107', 'work_type', '5a1510583e3a5', '1', '', '1', '', '1：门市 ，2：礼服，3：拍照，4：摄影助理，5：灯光师，6：选片，7：化妆，8：取件，9：美编，10：调色，11：设计，12：修片，13：沟通，14：收款，15：录影，16：司机，17：记录，18：邀约，19：推广，20：网销，21：电放', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('108', 'department_name', '5a18d69aefed1', '2', '电联部', '1', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('109', 'staff_id', '5a18e3fa516a1', '2', '1,5,6', '1', '', 'staff_id数组或字符串', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('110', 'group_id', '5a18f958756dc', '1', '1', '1', '', '分组id', '0', 'group_id');
INSERT INTO `api_fields` VALUES ('111', 'group_name', '5a18f958756dc', '2', '', '1', '', '小组名称', '0', 'group_name');
INSERT INTO `api_fields` VALUES ('112', 'id', '5a18f958756dc', '1', '', '1', '', '要修改的员工id字符串或数组', '0', 'id');
INSERT INTO `api_fields` VALUES ('113', 'staffid', '5a1911b6693e3', '2', '', '1', '', '', '0', 'staffid');
INSERT INTO `api_fields` VALUES ('114', 'staffname', '5a1911b6693e3', '2', '', '1', '', '', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('115', 'password', '5a1911b6693e3', '2', '', '1', '', '', '0', 'password');
INSERT INTO `api_fields` VALUES ('116', 'id', '5a19201a33c20', '1', '', '0', '', '员工编号', '0', 'id');
INSERT INTO `api_fields` VALUES ('117', 'staffname', '5a19201a33c20', '2', '', '0', '', '员工名字', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('118', 'staffnumber', '5a19201a33c20', '2', '', '0', '', '员工编号', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('119', 'brandclass', '5a19201a33c20', '2', '', '0', '', '品牌名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('120', 'shop_name', '5a19201a33c20', '2', '', '0', '', '店面名称', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('121', 'shop_code', '5a19201a33c20', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('122', 'department_name', '5a19201a33c20', '1', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('123', 'position_name', '5a19201a33c20', '2', '', '0', '', '岗位名称', '0', 'position_name');
INSERT INTO `api_fields` VALUES ('124', 'telephone', '5a01766b4a3dd', '2', '', '0', '', '手机号', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('125', 'brandclass', '5a01766b4a3dd', '2', '', '0', '', '品牌', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('126', 'department_name', '5a01766b4a3dd', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('127', 'position_name', '5a01766b4a3dd', '2', '', '0', '', '岗位名称', '0', 'position_name');
INSERT INTO `api_fields` VALUES ('128', 'department_id', '5a0a624728618', '2', '', '0', '', '店下的部门名称', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('129', 'position_id', '5a0a624728618', '2', '', '0', '', '店下的职位名称', '0', 'position_id');
INSERT INTO `api_fields` VALUES ('130', 'mobile', '5a17b86088f1a', '2', '', '1', '', '手机号，支持逗号分隔的多个手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('131', 'content', '5a17b86088f1a', '2', '', '1', '', '内容，必须符合模板要求，可以签名也可以不带签名。', '0', 'content');
INSERT INTO `api_fields` VALUES ('132', 'send_time', '5a17b86088f1a', '1', '', '0', '', '发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56', '0', 'send_time');
INSERT INTO `api_fields` VALUES ('133', 'shop_code', '5a17b86088f1a', '2', '', '0', '', '调用短信的门店CODE，如果不传，取配置内默认第一个配置进行发送。传的话，取门店，品牌，集团，任意一个有配置的', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('134', 'telephone', '5a1cb7e65cb5f', '1', '13515303738', '1', '', '手机号', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('135', 'password', '5a1cb7e65cb5f', '2', '', '1', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('136', 'department_id', '5a0e6f272bb38', '1', '', '1', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('137', 'department_id', '5a1fa8feacda0', '1', '', '1', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('138', 'staffname', '5a221a6621364', '2', '', '0', '', '员工登录名，与员工手机号选填一项即可。', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('139', 'telphone', '5a221a6621364', '2', '', '0', '', '员工手机号,与员工登录名选填一项即可。', '0', 'telphone');
INSERT INTO `api_fields` VALUES ('140', 'password', '5a221a6621364', '1', '', '1', '', '员工登录密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('141', 'staffname', '5a221c9548d47', '2', '', '0', '', '', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('142', 'telephone', '5a221c9548d47', '2', '', '0', '', '', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('143', 'password', '5a221c9548d47', '2', '', '1', '', '', '0', 'password');
INSERT INTO `api_fields` VALUES ('144', 'staffname', '5a22380ec9a63', '2', '', '0', '', '', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('145', 'telephone', '5a22380ec9a63', '2', '', '0', '', '', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('146', 'password', '5a22380ec9a63', '2', '', '1', '', '', '0', 'password');
INSERT INTO `api_fields` VALUES ('147', 'open_id', '5a22380ec9a63', '2', '', '1', '', '', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('148', 'staffname', '5a2239cf24883', '2', '', '0', '', '', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('149', 'telephone', '5a2239cf24883', '2', '', '0', '', '', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('150', 'password', '5a2239cf24883', '2', '', '1', '', '', '0', 'password');
INSERT INTO `api_fields` VALUES ('151', 'open_id', '5a2239cf24883', '2', '', '1', '', '', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('153', 'qr_code', '5a260b53c2907', '2', '', '0', '', '如果传入qr_code这个字段，则返回当前这个CODE的基本信息， 其中： state: 空或init表示初始状态 scaned:已扫码（需要扫码者预操作） logined:已登录', '0', 'qr_code');
INSERT INTO `api_fields` VALUES ('155', 'channelclass', '59fd5e729e5a8', '2', '微信', '0', '', '渠道类型', '0', 'channelclass');
INSERT INTO `api_fields` VALUES ('156', 'id', '5a2757c0a9810', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('157', 'channelclass', '5a2757c0a9810', '1', '', '0', '', '渠道类型名', '0', 'channelclass');
INSERT INTO `api_fields` VALUES ('158', 'staffname', '5a254b1208166', '2', '', '1', '', '', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('159', 'password', '5a254b1208166', '2', '', '1', '', '', '0', 'password');
INSERT INTO `api_fields` VALUES ('160', 'five', '5a254b1208166', '2', '0', '0', '', '', '0', 'five');
INSERT INTO `api_fields` VALUES ('161', 'open_id', '5a2a39421a636', '2', '', '1', '', '', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('162', 'shop_code', '5a2a5f948c9a5', '2', '', '0', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('163', 'is_dig', '5a005e0038270', '1', '', '0', '', '是否是接入店', '0', 'is_dig');
INSERT INTO `api_fields` VALUES ('164', 'openid', '5a2a39b803dc2', '2', '', '1', '', '获取到的员工的openid', '0', 'openid');
INSERT INTO `api_fields` VALUES ('165', 'shop_code', '5a574b13103b7', '2', '', '1', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('166', 'main_position_code', '5a19201a33c20', '2', '', '0', '', '主岗位编号,每个编号用英文单引号，如果多个编号需用英文逗号隔开', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('209', 'shop_code', '5a5c6626eef07', '2', '', '0', '', '交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('210', 'brand_id', '5a5c6626eef07', '1', '', '0', '', '事业部ID，会员系统或积分商城支付时需要。门店扫码支付不用传', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('211', 'staff_id', '5a5c6626eef07', '1', '', '0', '', '如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('212', 'body', '5a5c6626eef07', '2', '', '1', '', '交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付', '0', 'body');
INSERT INTO `api_fields` VALUES ('213', 'detail', '5a5c6626eef07', '2', '', '0', '', '交易商品描述', '0', 'detail');
INSERT INTO `api_fields` VALUES ('214', 'total_fee', '5a5c6626eef07', '1', '', '1', '', '交易总金额，传整型，一块钱，传：100', '0', 'total_fee');
INSERT INTO `api_fields` VALUES ('215', 'client_ip', '5a5c6626eef07', '1', '', '0', '', '客户端IP地址。', '0', 'client_ip');
INSERT INTO `api_fields` VALUES ('216', 'trade_type', '5a5c6626eef07', '2', '', '1', '', '扫码支付，传native,APP调用，传APP，网页调用，传JSAPI', '0', 'trade_type');
INSERT INTO `api_fields` VALUES ('217', 'order_no', '5a5c6626eef07', '2', '', '1', '', '交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('218', 'open_id', '5a5c6626eef07', '1', '', '0', '', 'JSAPI支付时，必须传open_id', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('219', 'limit_pay', '5a5c6626eef07', '2', '', '0', '', '限制支付种类，中果不允许信用卡，请传：no_credit', '0', 'limit_pay');
INSERT INTO `api_fields` VALUES ('220', 'order_no', '5a5ca00c81db4', '2', '', '1', '', '请求生成订单时的order_no', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('221', 'limit_pay', '5a5da9f70d56e', '2', '', '0', '', '限制支付种类，中果不允许信用卡，请传：no_credit', '0', 'limit_pay');
INSERT INTO `api_fields` VALUES ('222', 'order_no', '5a5da9f70d56e', '2', '', '1', '', '交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('223', 'auth_code', '5a5da9f70d56e', '1', '', '0', '', '扫到的授权码。', '0', 'auth_code');
INSERT INTO `api_fields` VALUES ('224', 'client_ip', '5a5da9f70d56e', '1', '', '0', '', '客户端IP地址。', '0', 'client_ip');
INSERT INTO `api_fields` VALUES ('225', 'total_fee', '5a5da9f70d56e', '1', '', '1', '', '交易总金额，传整型，一块钱，传：100', '0', 'total_fee');
INSERT INTO `api_fields` VALUES ('226', 'detail', '5a5da9f70d56e', '2', '', '0', '', '交易商品描述', '0', 'detail');
INSERT INTO `api_fields` VALUES ('227', 'body', '5a5da9f70d56e', '2', '', '1', '', '交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付', '0', 'body');
INSERT INTO `api_fields` VALUES ('228', 'staff_id', '5a5da9f70d56e', '1', '', '0', '', '如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('229', 'shop_id', '5a5da9f70d56e', '1', '', '0', '', '门店ID，门店扫码支付必传与shop_code选传一个即可', '0', 'shop_id');
INSERT INTO `api_fields` VALUES ('230', 'shop_code', '5a5da9f70d56e', '2', '', '0', '', '交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('231', 'shop_code', '5a5dbddc8fa64', '2', '', '0', '', '交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('232', 'brand_id', '5a5dbddc8fa64', '1', '', '0', '', '事业部ID，会员系统或积分商城支付时需要。门店扫码支付不用传', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('233', 'prepay_id', '5a5dbddc8fa64', '2', '', '1', '', '预支付ID，由创建订单接口生成', '0', 'prepay_id');
INSERT INTO `api_fields` VALUES ('234', 'product_id', '5a5c6626eef07', '2', '', '0', '', '商品ID，如果是NATIVE扫码支付，则为必传', '0', 'product_id');
INSERT INTO `api_fields` VALUES ('235', 'mobile', '5a5df0ae0fcd5', '2', '', '1', '', '手机号，支持逗号分隔的多个手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('236', 'content', '5a5df0ae0fcd5', '2', '', '1', '', '内容，必须符合模板要求，可以签名也可以不带签名。', '0', 'content');
INSERT INTO `api_fields` VALUES ('237', 'send_time', '5a5df0ae0fcd5', '1', '', '0', '', '发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56', '0', 'send_time');
INSERT INTO `api_fields` VALUES ('238', 'shop_code', '5a5df0ae0fcd5', '2', '', '1', '', '', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('239', 'product_id', '5a5f015c659ee', '2', '', '0', '', '商品ID，如果是NATIVE扫码支付，则为必传', '0', 'product_id');
INSERT INTO `api_fields` VALUES ('240', 'limit_pay', '5a5f015c659ee', '2', '', '0', '', '限制支付种类，中果不允许信用卡，请传：no_credit', '0', 'limit_pay');
INSERT INTO `api_fields` VALUES ('241', 'open_id', '5a5f015c659ee', '1', '', '0', '', 'JSAPI支付时，必须传open_id', '0', 'open_id');
INSERT INTO `api_fields` VALUES ('242', 'order_no', '5a5f015c659ee', '2', '', '1', '', '交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('243', 'trade_type', '5a5f015c659ee', '2', '', '1', '', '扫码支付，传native,APP调用，传APP，网页调用，传JSAPI', '0', 'trade_type');
INSERT INTO `api_fields` VALUES ('244', 'client_ip', '5a5f015c659ee', '1', '', '0', '', '客户端IP地址。', '0', 'client_ip');
INSERT INTO `api_fields` VALUES ('245', 'total_fee', '5a5f015c659ee', '1', '', '1', '', '交易总金额，传整型，一块钱，传：100', '0', 'total_fee');
INSERT INTO `api_fields` VALUES ('246', 'detail', '5a5f015c659ee', '2', '', '0', '', '交易商品描述', '0', 'detail');
INSERT INTO `api_fields` VALUES ('247', 'body', '5a5f015c659ee', '2', '', '1', '', '交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付', '0', 'body');
INSERT INTO `api_fields` VALUES ('248', 'staff_id', '5a5f015c659ee', '1', '', '0', '', '如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('249', 'brand_id', '5a5f015c659ee', '1', '', '0', '', '事业部ID，会员系统或积分商城支付时需要。门店扫码支付不用传', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('250', 'shop_code', '5a5f015c659ee', '2', '', '0', '', '交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('251', 'shop_code', '5a5f0252c9ae7', '2', '', '0', '', '交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('252', 'shop_id', '5a5f0252c9ae7', '1', '', '0', '', '门店ID，门店扫码支付必传与shop_code选传一个即可', '0', 'shop_id');
INSERT INTO `api_fields` VALUES ('253', 'staff_id', '5a5f0252c9ae7', '1', '', '0', '', '如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('254', 'body', '5a5f0252c9ae7', '2', '', '1', '', '交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付', '0', 'body');
INSERT INTO `api_fields` VALUES ('255', 'detail', '5a5f0252c9ae7', '2', '', '0', '', '交易商品描述', '0', 'detail');
INSERT INTO `api_fields` VALUES ('256', 'total_fee', '5a5f0252c9ae7', '1', '', '1', '', '交易总金额，传整型，一块钱，传：100', '0', 'total_fee');
INSERT INTO `api_fields` VALUES ('257', 'client_ip', '5a5f0252c9ae7', '1', '', '0', '', '客户端IP地址。', '0', 'client_ip');
INSERT INTO `api_fields` VALUES ('258', 'auth_code', '5a5f0252c9ae7', '1', '', '0', '', '扫到的授权码。', '0', 'auth_code');
INSERT INTO `api_fields` VALUES ('259', 'order_no', '5a5f0252c9ae7', '2', '', '1', '', '交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('260', 'limit_pay', '5a5f0252c9ae7', '2', '', '0', '', '限制支付种类，中果不允许信用卡，请传：no_credit', '0', 'limit_pay');
INSERT INTO `api_fields` VALUES ('261', 'order_no', '5a5f01acab982', '2', '', '1', '', '请求生成订单时的order_no（ERP 的唯一流水号+店面简码）', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('262', 'shop_code', '5a62dcd5c7e40', '2', '', '1', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('263', 'content', '5a4b81bc26160', '2', '', '0', '', '', '0', 'content');
INSERT INTO `api_fields` VALUES ('264', 'group_company_name', '5a6978bb82027', '2', '', '0', '', '集团名称', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('265', 'id', '5a6978bb82027', '1', '', '0', '', '集团id', '0', 'id');
INSERT INTO `api_fields` VALUES ('267', 'shop_code', '5a706286930ce', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('268', 'shop_code', '5a7076a6ccfaa', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('269', 'department_id', '5a01766b4a3dd', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('270', 'id', '5a704aa96e503', '1', '', '0', '', '省id', '0', 'id');
INSERT INTO `api_fields` VALUES ('271', 'name', '5a704aa96e503', '2', '', '0', '', '省份', '0', 'name');
INSERT INTO `api_fields` VALUES ('273', 'grade_type', '5a01766b4a3dd', '1', '', '0', '', '等级，1集团，2品牌，3店面，4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('274', 'main_position_code', '5a01766b4a3dd', '2', '', '0', '', '主岗位标识', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('275', 'is_photo', '5a39fd8c6c9f7', '1', '', '0', '', '是否为拍照店，1是2不是', '0', 'is_photo');
INSERT INTO `api_fields` VALUES ('276', 'shop_code', '5a7424f13aa54', '2', '', '0', '', '店面标识', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('277', 'shop_code', '5a73d4f13a9eb', '2', '', '0', '', '店面标识', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('278', 'brandclass_id', '5a73d4f13a9eb', '1', '', '0', '', '品牌编号', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('279', 'scene', '5a73d4f13a9eb', '2', '', '0', '', '场景编号，即参数，不重复', '0', 'scene');
INSERT INTO `api_fields` VALUES ('280', 'type', '5a73d4f13a9eb', '1', '', '0', '', '类型1永久，2临时，临时有效期为1个月', '0', 'type');
INSERT INTO `api_fields` VALUES ('281', 'mobile', '5a780e2613bb9', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('282', 'verify_code', '5a780e2613bb9', '2', '', '1', '', '验证码', '0', 'verify_code');
INSERT INTO `api_fields` VALUES ('283', 'shop_code', '5a780e2613bb9', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('284', 'mobile', '5a7bdbdaa5870', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('285', 'content', '5a7bdbdaa5870', '2', '', '1', '', '内容，必须符合模板要求，可以签名也可以不带签名。', '0', 'content');
INSERT INTO `api_fields` VALUES ('286', 'send_time', '5a7bdbdaa5870', '2', '', '0', '', '发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56 ', '0', 'send_time');
INSERT INTO `api_fields` VALUES ('287', 'shop_code', '5a7bdbdaa5870', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('291', 'staff_id', '5a8fd8296f3d3', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('292', 'vip_url', '5a38840b15ba9', '2', '', '0', '', '会员网址', '0', 'vip_url');
INSERT INTO `api_fields` VALUES ('293', 'belong_shop_code', '5a005e0038270', '2', '', '0', '', '归属店shop_code', '0', 'belong_shop_code');
INSERT INTO `api_fields` VALUES ('294', 'staff_id', '5aae44296a6bf', '2', '', '0', '', '门店识别码，与品牌编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('295', 'brand_id', '5aae44296a6bf', '1', '', '0', '', '品牌编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('296', 'send_config', '5aae44296a6bf', '2', '', '0', '', '配置号，与品牌编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('297', 'staff_id', '5aae46527269f', '2', '', '0', '', '门店识别码，与品牌编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('298', 'brand_id', '5aae46527269f', '1', '', '0', '', '品牌编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('299', 'send_config', '5aae46527269f', '2', '', '0', '', '配置号，与品牌编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('300', 'staff_id', '5aae460d2996e', '2', '', '0', '', '门店识别码，与品牌编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('301', 'brand_id', '5aae460d2996e', '1', '', '0', '', '品牌编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('302', 'send_config', '5aae460d2996e', '2', '', '0', '', '配置号，与品牌编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('303', 'staff_id', '5aae466ce7ddd', '2', '', '0', '', '门店识别码，与品牌编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('304', 'brand_id', '5aae466ce7ddd', '1', '', '0', '', '品牌编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('305', 'send_config', '5aae466ce7ddd', '2', '', '0', '', '配置号，与品牌编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('306', 'send_config', '5a5df0ae0fcd5', '2', '', '0', '', '配置号，使用指定配置发短信', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('307', 'send_config', '5a17b86088f1a', '2', '', '0', '', '配置号，使用指定配置发短信', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('309', 'shop_code', '5aafa4ac48058', '2', '', '0', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('310', 'brandclass_id', '5aafa4ac48058', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('311', 'mobile', '5ab88f1fd2f00', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('312', 'mobile', '5ab8b32fcc970', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('313', 'code', '5ab99d8594c78', '2', '', '1', '', '订单与签名的 唯一值', '0', 'code');
INSERT INTO `api_fields` VALUES ('314', 'data', '5ab99d8594c78', '2', '', '1', '', '订单主要数据内容有:订单编号、客户编号、会员卡号、选片张数、销售门市、网销门市、订单总额、化妆金额、已付金额、未付金额、礼服总金额、礼服加挑金额、礼服销售金额、礼服已付金额、礼服未付金额', '0', 'code');
INSERT INTO `api_fields` VALUES ('315', 'viewtype', '5ab99d8594c78', '1', '', '1', '', '模板名称', '0', 'code');
INSERT INTO `api_fields` VALUES ('316', 'type', '5ab99d8594c78', '1', '', '1', '', '执行操作的类型(1:添加,0:修改)', '0', 'code');
INSERT INTO `api_fields` VALUES ('317', 'code', '5ab9a901ee228', '1', '', '1', '', '订单对应的签名 唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('318', 'type', '5ab9a901ee228', '1', '', '1', '', '返回的签名类型(1:url,0:二进制)', '0', 'type');
INSERT INTO `api_fields` VALUES ('320', 'id', '5ae01abbbc263', '1', '', '0', '', 'id', '0', 'id');
INSERT INTO `api_fields` VALUES ('321', 'work_type', '5ae01abbbc263', '2', '', '0', '', '工作类型名称', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('323', 'brandclass_id', '5a004e9c3e030', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('324', 'code', '5ac3579d76bb8', '1', '', '1', '', '订单对应的签名 唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('325', 'staff_number', '5af2f899164f4', '2', '', '0', '', '员工number,多个用英文逗号隔开', '0', 'staff_number');
INSERT INTO `api_fields` VALUES ('326', 'content', '5af2f899164f4', '2', '', '0', '', '短信内容', '0', 'content');
INSERT INTO `api_fields` VALUES ('327', 'send_config', '5af2f899164f4', '2', '', '0', '', '短信配置', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('328', 'staffname', '5af3c003b4cae', '2', '', '0', '', '人员名字，与数据名字，编号模糊查询', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('329', 'staffnumber', '5af3c003b4cae', '2', '', '0', '', '人员编号 与数据名字，编号模糊查询', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('330', 'telephone', '5af3c003b4cae', '2', '', '0', '', '手机号', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('331', 'brandclass', '5af3c003b4cae', '2', '', '0', '', '事业部名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('332', 'brandclass_id', '5af3c003b4cae', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('333', 'shop_name', '5af3c003b4cae', '2', '', '0', '', '店', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('334', 'shop_code', '5af3c003b4cae', '2', '', '0', '', '店', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('335', 'department_name', '5af3c003b4cae', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('336', 'department_id', '5af3c003b4cae', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('337', 'id', '5af3fe7a0a668', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('338', 'brandclass_id', '5af3fe7a0a668', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('339', 'id', '5af40001983f0', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('340', 'brandclass_id', '5af40001983f0', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('344', 'grade_type', '5aff92c0762a0', '1', '', '1', '', '部门所属：1集团，2品牌，3店面', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('345', 'brandclass_id', '5aff92c0762a0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('346', 'shop_code', '5aff92c0762a0', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('347', 'shop_code', '5aec138a7bae9', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('348', 'key_words', '5aec138a7bae9', '2', '', '1', '', '手机号,员工名', '0', 'key_words');
INSERT INTO `api_fields` VALUES ('349', 'type', '5b20eb32badd8', '1', '', '1', '', '类型：1岗位code，2人员编号', '0', 'type');
INSERT INTO `api_fields` VALUES ('350', 'number', '5b20eb32badd8', '2', '', '1', '', '岗位code或人员编号', '0', 'number');
INSERT INTO `api_fields` VALUES ('352', 'staff_id', '5b33489a1ec30', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('353', 'staff_id', '5b3ae7a95f370', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('354', 'token', '5b3ae7a95f370', '2', '', '1', '', '要验证的token', '0', 'token');
INSERT INTO `api_fields` VALUES ('356', 'id', '5b3c3dc4ebca8', '1', '', '1', '', '事业部id', '0', 'id');
INSERT INTO `api_fields` VALUES ('357', 'brandclass', '5b3c3dc4ebca8', '2', '', '0', '', '事业部名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('358', 'group_company_name', '5b3c3dc4ebca8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('359', 'nickname', '5b3c3dc4ebca8', '2', '', '0', '', '简称', '0', 'nickname');
INSERT INTO `api_fields` VALUES ('360', 'wx_public', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_public', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('361', 'wx_appid', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('362', 'wx_secret', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('363', 'wx_mch_id', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_mch_id', '0', 'wx_mch_id');
INSERT INTO `api_fields` VALUES ('364', 'wx_pay_key', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_pay_key', '0', 'wx_pay_key');
INSERT INTO `api_fields` VALUES ('365', 'vip_url', '5b3c3dc4ebca8', '2', '', '0', '', 'vip_url', '0', 'vip_url');
INSERT INTO `api_fields` VALUES ('366', 'mall_url', '5b3c3dc4ebca8', '2', '', '0', '', 'mall_url', '0', 'mall_url');
INSERT INTO `api_fields` VALUES ('367', 'sms_config', '5b3c3dc4ebca8', '2', '', '0', '', '短信配置id', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('368', 'valid_date', '5b3c3dc4ebca8', '2', '', '0', '', '客资有效期（填写数字，例：30）', '0', 'valid_date');
INSERT INTO `api_fields` VALUES ('369', 'order_rule', '5b3c3dc4ebca8', '1', '', '0', '', '有效订单标准', '0', 'order_rule');
INSERT INTO `api_fields` VALUES ('370', 'proportion', '5b3c3dc4ebca8', '2', '', '0', '', '有效订单标准值，填写数字，如order_rule为1则为数值，order_rule为2则为数值/100（只填写数值不用处理百分比）', '0', 'proportion');
INSERT INTO `api_fields` VALUES ('371', 'brandclass_id', '5b3c5bec9ee30', '1', '', '1', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('372', 'id', '5b3c5ccadc2a8', '1', '', '1', '', '店id', '0', 'id');
INSERT INTO `api_fields` VALUES ('373', 'shop_name', '5b3c5ccadc2a8', '2', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('374', 'shop_code', '5b3c5ccadc2a8', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('375', 'sn', '5b3c5ccadc2a8', '2', '', '0', '', 'sn', '0', 'sn');
INSERT INTO `api_fields` VALUES ('376', 'group_company_name', '5b3c5ccadc2a8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('377', 'brandclass', '5b3c5ccadc2a8', '2', '', '0', '', 'brandclass', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('378', 'brandclass_id', '5b3c5ccadc2a8', '1', '', '0', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('379', 'shop_type', '5b3c5ccadc2a8', '1', '', '0', '', '店面类型，1婚纱，2儿童，3旅拍，4艺术，5其他', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('380', 'prefix_number', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则前缀', '0', 'prefix_number');
INSERT INTO `api_fields` VALUES ('381', 'numberorder', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则中间主要部分', '0', 'numberorder');
INSERT INTO `api_fields` VALUES ('382', 'serial_number', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则后缀', '0', 'serial_number');
INSERT INTO `api_fields` VALUES ('383', 'shopaddress', '5b3c5ccadc2a8', '2', '', '0', '', '店面地址', '0', 'shopaddress');
INSERT INTO `api_fields` VALUES ('384', 'wx_public', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_public', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('385', 'wx_appid', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('386', 'wx_secret', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('387', 'sms_config', '5b3c5ccadc2a8', '1', '', '0', '', '短信配置', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('388', 'belong_shop_code', '5b3c5ccadc2a8', '2', '', '0', '', '提报客资归属店', '0', 'belong_shop_code');
INSERT INTO `api_fields` VALUES ('389', 'belong_shop_name', '5b3c5ccadc2a8', '2', '', '0', '', '提报客资归属店', '0', 'belong_shop_name');
INSERT INTO `api_fields` VALUES ('390', 'is_marketing', '5b3c5ccadc2a8', '1', '', '0', '', '店面分类，1电商店，2实体店，3网销店，4渠道店', '0', 'is_marketing');
INSERT INTO `api_fields` VALUES ('391', 'is_dig', '5b3c5ccadc2a8', '1', '', '0', '', '是否深挖，1是，2否', '0', 'is_dig');
INSERT INTO `api_fields` VALUES ('392', 'is_sk', '5b3c5ccadc2a8', '1', '', '0', '', '是否深挖', '0', 'is_sk');
INSERT INTO `api_fields` VALUES ('393', 'is_group', '5b3c5ccadc2a8', '1', '', '0', '', '是否集团店，1是2不是', '0', 'is_group');
INSERT INTO `api_fields` VALUES ('394', 'is_photo', '5b3c5ccadc2a8', '1', '', '0', '', '是否拍照店，1是2不是', '0', 'is_photo');
INSERT INTO `api_fields` VALUES ('395', 'shop_code', '5b3dbce7c7da8', '2', '', '1', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('396', 'id', '5b3dbdd2964b0', '1', '', '1', '', '部门id', '0', 'id');
INSERT INTO `api_fields` VALUES ('397', 'department_name', '5b3dbdd2964b0', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('398', 'shop_name', '5b3dbdd2964b0', '2', '', '0', '', '店面名称', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('399', 'shop_code', '5b3dbdd2964b0', '2', '', '0', '', '店面code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('400', 'group_company_name', '5b3dbdd2964b0', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('401', 'brandclass', '5b3dbdd2964b0', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('402', 'brandclass_id', '5b3dbdd2964b0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('403', 'grade_type', '5b3dbdd2964b0', '1', '', '0', '', '1直属集团 2直属事业部 3直属店面', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('404', 'department_id', '5b3dc428987d8', '1', '', '1', '', 'department_id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('405', 'grade_type', '5b3dc4a1dc1e0', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('406', 'code', '5b3dc4a1dc1e0', '2', '', '1', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('407', 'oa_p_id', '5b3dc4a1dc1e0', '2', '', '1', '', 'oa中岗位的id', '0', 'content');
INSERT INTO `api_fields` VALUES ('408', 'grade_type', '5b3dc56a73de8', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('409', 'code', '5b3dc56a73de8', '2', '', '1', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('410', 'oa_p_id', '5b3dc56a73de8', '2', '', '1', '', 'oa岗位表中id，一维数组json_encode后', '0', 'oa_p_id');
INSERT INTO `api_fields` VALUES ('411', 'id', '5b3dc732048a8', '1', '', '1', '', '人员id', '0', 'id');
INSERT INTO `api_fields` VALUES ('412', 'staffnumber', '5b3dc732048a8', '2', '', '0', '', 'staffnumber', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('413', 'staffname', '5b3dc732048a8', '2', '', '0', '', 'staffname', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('414', 'password', '5b3dc732048a8', '2', '', '0', '', '密码（加密后）', '0', 'password');
INSERT INTO `api_fields` VALUES ('415', 'telephone', '5b3dc732048a8', '2', '', '0', '', '手机', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('416', 'main_position_name', '5b3dc732048a8', '2', '', '0', '', 'main_position_name', '0', 'main_position_name');
INSERT INTO `api_fields` VALUES ('417', 'main_position_code', '5b3dc732048a8', '2', '', '0', '', 'main_position_code', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('418', 'main_position_id', '5b3dc732048a8', '2', '', '0', '', 'main_position_id', '0', 'main_position_id');
INSERT INTO `api_fields` VALUES ('419', 'position_code', '5b3dc732048a8', '2', '', '0', '', '兼职岗位，多个用英文逗号隔开', '0', 'position_code');
INSERT INTO `api_fields` VALUES ('420', 'position_id', '5b3dc732048a8', '2', '', '0', '', '兼职岗位id，多个用英文逗号隔开', '0', 'position_id');
INSERT INTO `api_fields` VALUES ('421', 'department_id', '5b3dc732048a8', '1', '', '0', '', 'brandclass_id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('422', 'department_name', '5b3dc732048a8', '2', '', '0', '', 'brandclass_id', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('423', 'shop_name', '5b3dc732048a8', '2', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('424', 'shop_code', '5b3dc732048a8', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('425', 'group_company_name', '5b3dc732048a8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('426', 'brandclass', '5b3dc732048a8', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('427', 'brandclass_id', '5b3dc732048a8', '1', '', '0', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('428', 'grade_type', '5b3dc732048a8', '1', '', '0', '', '1直属集团 2直属事业部 3直属店面 4店下部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('429', 'work_shop', '5b3dc732048a8', '2', '', '0', '', '工作店面', '0', 'work_shop');
INSERT INTO `api_fields` VALUES ('430', 'work_types', '5b3dc732048a8', '2', '', '0', '', '工作类型', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('431', 'work_type_level', '5b3dc732048a8', '2', '', '0', '', '工作类型id +‘_’+ 工作类型等级名称，例:1_高级门市,若没有等级则为1_（多个用英文逗号隔开）', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('432', 'work_type_level_id', '5b3dc732048a8', '2', '', '0', '', '工作类型id +‘_’+ 工作类型等级id，例:1_22,若没有等级则为1_（多个用英文逗号隔开）', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('433', 'entry_date', '5b3dc732048a8', '2', '', '0', '', '入职时间', '0', 'entry_date');
INSERT INTO `api_fields` VALUES ('434', 'leave_date', '5b3dc732048a8', '2', '', '0', '', '离职时间', '0', 'leave_date');
INSERT INTO `api_fields` VALUES ('435', 'contract_endday', '5b3dc732048a8', '2', '', '0', '', '合同到期时间', '0', 'contract_endday');
INSERT INTO `api_fields` VALUES ('436', 'staff_id', '5b3dc87367e80', '1', '', '1', '', '人员id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('483', 'brandclass_id', '59fd58574204a', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('484', 'brandclass_id', '5a14dd1d722a6', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('486', 'grade_type', '5b4717ca97046', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('487', 'code', '5b4717ca97046', '2', '', '0', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('488', 'content', '5b4717ca97046', '2', '', '0', '', 'json格式,多个岗位详情，包括position_name、oa_p_id', '0', 'content');
INSERT INTO `api_fields` VALUES ('489', 'shop_type', '5a005e0038270', '1', '', '0', '', '店面类型，1,2,3  支持,分隔', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('490', 'brandclass_id', '5a00506445948', '2', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('491', 'brandclass_id', '5a14e013b447a', '2', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('493', 'staff_id', '5b6575a339c38', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('494', 'shop_code', '5b75341456d18', '2', '', '1', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('495', 'work_type', '5b75341456d18', '1', '', '1', '', '工作类型编码', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('497', 'id', '5b8630d8d21b8', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('498', 'staffnumber', '5b8630d8d21b8', '2', '', '0', '', '员工编号', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('499', 'staffname', '5b8630d8d21b8', '2', '', '0', '', '员工名称', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('500', 'password', '5b8630d8d21b8', '2', '', '0', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('501', 'grade_type', '5b8630d8d21b8', '1', '', '0', '', '1集团，2事业部，3店面，4店下部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('502', 'group_company_name', '5b8630d8d21b8', '2', '', '0', '', '集团名', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('503', 'brandclass', '5b8630d8d21b8', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('504', 'brandclass_id', '5b8630d8d21b8', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('505', 'shop_name', '5b8630d8d21b8', '2', '', '0', '', '店名', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('506', 'shop_code', '5b8630d8d21b8', '2', '', '0', '', '店唯一标识码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('507', 'sn', '5b8630d8d21b8', '2', '', '0', '', '店简码', '0', 'sn');
INSERT INTO `api_fields` VALUES ('508', 'department_id', '5b8630d8d21b8', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('509', 'department_name', '5b8630d8d21b8', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('510', 'main_position_name', '5b8630d8d21b8', '2', '', '0', '', '主岗位名称', '0', 'main_position_name');
INSERT INTO `api_fields` VALUES ('511', 'main_position_code', '5b8630d8d21b8', '2', '', '0', '', '主岗位标识码', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('512', 'position_code', '5b8630d8d21b8', '2', '', '0', '', '副岗位标识码，多个用英文逗号隔开', '0', 'position_code');
INSERT INTO `api_fields` VALUES ('513', 'leave_date', '5b8630d8d21b8', '2', '', '0', '', '离职日期', '0', 'leave_date');
INSERT INTO `api_fields` VALUES ('528', 'id', '5b876a32ca648', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('529', 'group_company_name', '5b876a32ca648', '2', '', '0', '', '集团名称', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('530', 'wx_public', '5b876a32ca648', '2', '', '0', '', '微信公众号名称', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('531', 'wx_appid', '5b876a32ca648', '2', '', '0', '', '微信公众号appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('532', 'wx_secret', '5b876a32ca648', '2', '', '0', '', '微信公众号secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('533', 'sms_config', '5b876a32ca648', '1', '', '0', '', '短息配置', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('534', 'wx_mch_id', '5b876a32ca648', '2', '', '0', '', '商户号', '0', 'wx_mch_id');
INSERT INTO `api_fields` VALUES ('535', 'wx_pay_key', '5b876a32ca648', '2', '', '0', '', '微信支付秘钥', '0', 'wx_pay_key');
INSERT INTO `api_fields` VALUES ('543', 'id', '5b8a64f1c39b0', '1', '', '1', '', '工作类型等级表主键id', '0', 'id');
INSERT INTO `api_fields` VALUES ('544', 'level_name', '5b8a64f1c39b0', '2', '', '0', '', '等级名称', '0', 'level_name');
INSERT INTO `api_fields` VALUES ('545', 'work_type_id', '5b8a64f1c39b0', '1', '', '0', '', '工作类型id', '0', 'work_type_id');
INSERT INTO `api_fields` VALUES ('546', 'work_type', '5b8a64f1c39b0', '2', '', '0', '', '工作类型名称', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('547', 'sort', '5b8a64f1c39b0', '2', '', '0', '', '排序', '0', 'sort');
INSERT INTO `api_fields` VALUES ('548', 'add_time', '5b8a64f1c39b0', '1', '', '0', '', '添加时间', '0', 'add_time');
INSERT INTO `api_fields` VALUES ('549', 'id', '5b8a655b5d4f8', '1', '', '1', '', '工作类型等级表主键id', '0', 'id');
INSERT INTO `api_fields` VALUES ('550', 'staff_id', '5b9cac8aa21c0', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('551', 'brandclass_id', '5b9cac8aa21c0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('552', 'shop_type', '5b9cac8aa21c0', '1', '', '0', '', '店面类型（儿童2，婚纱）', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('553', 'shop_code', '5bc58874c5828', '2', '', '1', '', '店面唯一识别码，多个用英文逗号隔开', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('554', 'work_type', '5bc58874c5828', '1', '', '1', '', '工作类型编码', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('556', 'type', '5bc8702e3e056', '2', '', '1', '', '类型', '0', 'type');
INSERT INTO `api_fields` VALUES ('557', 'msg', '5bc8702e3e056', '2', '', '1', '', '消息', '0', 'msg');
INSERT INTO `api_fields` VALUES ('558', 'type', '5bc870ff09178', '2', '', '1', '', '类型', '0', 'type');
INSERT INTO `api_fields` VALUES ('559', 'msg', '5bc870ff09178', '2', '', '1', '', '消息', '0', 'msg');
INSERT INTO `api_fields` VALUES ('560', 'staff_id', '5bc870ff09178', '2', '', '2', '', '员工id，json格式', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('561', 'rid', '5bc870ff09178', '2', '', '2', '', '极光id，json格式', '0', 'msg');
INSERT INTO `api_fields` VALUES ('562', 'staff_id', '5bc871078bcee', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('563', 'imgs', '5bc94272b051a', '6', '', '1', '', '图片文件信息', '0', 'imgs');
INSERT INTO `api_fields` VALUES ('564', 'is_cover', '5bc94272b051a', '1', '', '1', '', '同文件是否覆盖，1：覆盖；2：不覆盖', '0', 'is_cover');
INSERT INTO `api_fields` VALUES ('565', 'img_path', '5bc94294ae9c2', '2', '', '1', '', '删除图片，支持多图片删除，逗号分隔', '0', 'img_path');
INSERT INTO `api_fields` VALUES ('566', 'brandclass_id', '5bcd7a65e1d8c', '1', '', '1', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('567', 'grade_type', '5bcd7b190d812', '1', '', '1', '', '部门所属类型', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('568', 'brandclass_id', '5bcd7b190d812', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('569', 'shop_code', '5bcd7b190d812', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('570', 'grade_type', '5bcd7bf31b0c2', '1', '', '1', '', '人员类型id', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('571', 'brandclass_id', '5bcd7bf31b0c2', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('572', 'shop_code', '5bcd7bf31b0c2', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('573', 'department_id', '5bcd7bf31b0c2', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('574', 'key_words', '5bcd7c794bcbd', '2', '', '0', '', '要查询的字段', '0', 'key_words');
INSERT INTO `api_fields` VALUES ('581', 'department', '5bd27d0a93120', '2', '', '1', '', '部门信息，json格式', '0', 'department');
INSERT INTO `api_fields` VALUES ('582', 'position', '5bd27d0a93120', '2', '', '1', '', '岗位信息，json格式', '0', 'position');
INSERT INTO `api_fields` VALUES ('584', 'data', '5bdaed7e5e551', '2', '', '1', '', '事业部id', '0', 'data');
INSERT INTO `api_fields` VALUES ('585', 'data', '5bdaee20b646d', '2', '', '1', '', '部门所属类型', '0', 'data');
INSERT INTO `api_fields` VALUES ('586', 'data', '5bdaee2a462e6', '2', '', '1', '', '事业部id', '0', 'data');
INSERT INTO `api_fields` VALUES ('587', 'data', '5bdaee35ac5ad', '2', '', '1', '', '店面识别码', '0', 'data');
INSERT INTO `api_fields` VALUES ('588', 'get_main', '5a0e6f272bb38', '1', '', '0', '', '1:不查看兼职； 2:查看兼职；', '0', 'get_main');
INSERT INTO `api_fields` VALUES ('589', 'order_id', '5c9ae4289e598', '2', '', '1', '', '订单编号', '0', 'order_id');
INSERT INTO `api_fields` VALUES ('590', 'brand_id', '5c9ae4289e598', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('591', 'code', '5c9ae4289e598', '2', '', '1', '', '唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('592', 'openid', '5caf4eceb94bd', '2', '', '1', '', '订单编号', '0', 'openid');
INSERT INTO `api_fields` VALUES ('593', 'staff_number', '5cbe739c8d8d8', '2', '', '1', '', '员工编号', '0', 'staff_number');
INSERT INTO `api_fields` VALUES ('594', 'is_op', '5cbe739c8d8d8', '1', '', '0', '', '店面标识 1：拍照店； 2：接单店； 3：选片店； 4：取件店', '0', 'is_op');
INSERT INTO `api_fields` VALUES ('595', 'group_id', '5cc6ed5f19c60', '1', '', '0', '', '组id', '0', 'group_id');
INSERT INTO `api_fields` VALUES ('596', 'group_name', '5cc6ed5f19c60', '2', '', '0', '', '组名', '0', 'group_name');
INSERT INTO `api_fields` VALUES ('597', 'department_id', '5cc6ed5f19c60', '2', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('598', 'department_name', '5cc6ed5f19c60', '2', '', '0', '', '部门名', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('599', 'shop_code', '5cc6ed5f19c60', '1', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('600', 'shop_name', '5cc6ed5f19c60', '1', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('601', 'brandclass_id', '5cc6ed5f19c60', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('602', 'brandclass', '5cc6ed5f19c60', '1', '', '0', '', '事业部名', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('610', 'order_no', '5ccfccc905078', '2', '', '1', '', '商户订单号', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('611', 'refund_fee', '5ccfccc905078', '1', '', '0', '', '退款金额（单位为分,可以做部分退款）', '0', 'refund_fee');
INSERT INTO `api_fields` VALUES ('613', 'code', '5ce4f98fa25c3', '1', '', '0', '', 'code', '0', 'code');
INSERT INTO `api_fields` VALUES ('614', 'order_id', '5ce791a0e5268', '2', '', '1', '', '订单号', '0', 'order_id');
INSERT INTO `api_fields` VALUES ('615', 'fc_id', '5ce791a0e5268', '1', '', '0', '', '订单服次', '0', 'fc_id');
INSERT INTO `api_fields` VALUES ('616', 'file_name', '5ce791a0e5268', '1', '', '0', '', '文件名', '0', 'file_name');
INSERT INTO `api_fields` VALUES ('617', 'img', '5ce791a0e5268', '1', '', '0', '', '文件', '0', 'img');
INSERT INTO `api_fields` VALUES ('621', 'group_id', '5cf8d76edd1ca', '1', '', '1', '', '组ID', '0', 'group_id');
INSERT INTO `api_fields` VALUES ('622', 'shop_type', '5d75f7dcedd78', '1', '0', '1', '', '店面类型（0：全部；1：婚纱：2：儿童）', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('623', 'get_leave', '5d75f7dcedd78', '1', '2', '1', '', '是否获取离职人员（1：是，即包含离职人员；2：否，不包含离职人员，只取在职人员）', '0', 'get_leave');
INSERT INTO `api_fields` VALUES ('624', 'shop_code', '5a62dcd5c7e40', '2', '', '1', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('625', 'group_company_name', '5a6978bb82027', '2', '', '0', '', '集团名称', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('626', 'id', '5a6978bb82027', '1', '', '0', '', '集团id', '0', 'id');
INSERT INTO `api_fields` VALUES ('628', 'shop_code', '5a706286930ce', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('629', 'shop_code', '5a7076a6ccfaa', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('630', 'department_id', '5a01766b4a3dd', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('631', 'id', '5a704aa96e503', '1', '', '0', '', '省id', '0', 'id');
INSERT INTO `api_fields` VALUES ('632', 'name', '5a704aa96e503', '2', '', '0', '', '省份', '0', 'name');
INSERT INTO `api_fields` VALUES ('634', 'grade_type', '5a01766b4a3dd', '1', '', '0', '', '等级，1集团，2事业部，3店面，4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('635', 'main_position_code', '5a01766b4a3dd', '2', '', '0', '', '主岗位标识', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('636', 'is_photo', '5a39fd8c6c9f7', '1', '', '0', '', '是否为拍照店，1是2不是', '0', 'is_photo');
INSERT INTO `api_fields` VALUES ('637', 'shop_code', '5a7424f13aa54', '2', '', '0', '', '店面标识', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('638', 'shop_code', '5a73d4f13a9eb', '2', '', '0', '', '店面标识', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('639', 'brandclass_id', '5a73d4f13a9eb', '1', '', '0', '', '事业部编号', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('640', 'scene', '5a73d4f13a9eb', '2', '', '0', '', '场景编号，即参数，不重复', '0', 'scene');
INSERT INTO `api_fields` VALUES ('641', 'type', '5a73d4f13a9eb', '1', '', '0', '', '类型1永久，2临时，临时有效期为1个月', '0', 'type');
INSERT INTO `api_fields` VALUES ('645', 'mobile', '5a780e2613bb9', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('646', 'verify_code', '5a780e2613bb9', '2', '', '1', '', '验证码', '0', 'verify_code');
INSERT INTO `api_fields` VALUES ('647', 'shop_code', '5a780e2613bb9', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('648', 'mobile', '5a7bdbdaa5870', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('649', 'content', '5a7bdbdaa5870', '2', '', '1', '', '内容，必须符合模板要求，可以签名也可以不带签名。', '0', 'content');
INSERT INTO `api_fields` VALUES ('650', 'send_time', '5a7bdbdaa5870', '2', '', '0', '', '发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56 ', '0', 'send_time');
INSERT INTO `api_fields` VALUES ('651', 'shop_code', '5a7bdbdaa5870', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('655', 'staff_id', '5a8fd8296f3d3', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('656', 'vip_url', '5a38840b15ba9', '2', '', '0', '', '会员网址', '0', 'vip_url');
INSERT INTO `api_fields` VALUES ('657', 'belong_shop_code', '5a005e0038270', '2', '', '0', '', '归属店shop_code', '0', 'belong_shop_code');
INSERT INTO `api_fields` VALUES ('658', 'staff_id', '5aae44296a6bf', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('659', 'brand_id', '5aae44296a6bf', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('660', 'send_config', '5aae44296a6bf', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('661', 'staff_id', '5aae46527269f', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('662', 'brand_id', '5aae46527269f', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('663', 'send_config', '5aae46527269f', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('664', 'staff_id', '5aae460d2996e', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('665', 'brand_id', '5aae460d2996e', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('666', 'send_config', '5aae460d2996e', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('667', 'staff_id', '5aae466ce7ddd', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('668', 'brand_id', '5aae466ce7ddd', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('669', 'send_config', '5aae466ce7ddd', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('670', 'send_config', '5a5df0ae0fcd5', '2', '', '0', '', '配置号，使用指定配置发短信', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('671', 'send_config', '5a17b86088f1a', '2', '', '0', '', '配置号，使用指定配置发短信', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('673', 'shop_code', '5aafa4ac48058', '2', '', '0', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('674', 'brandclass_id', '5aafa4ac48058', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('675', 'brandclass_id', '5a005e0038270', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('676', 'is_marketing', '5a005e0038270', '1', '', '0', '', '是否是营销店', '0', 'is_marketing');
INSERT INTO `api_fields` VALUES ('678', 'mobile', '5ab88f1fd2f00', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('679', 'mobile', '5ab8b32fcc970', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('680', 'code', '5ab99d8594c78', '2', '', '1', '', '订单与签名的 唯一值', '0', 'code');
INSERT INTO `api_fields` VALUES ('681', 'data', '5ab99d8594c78', '2', '', '1', '', '订单主要数据内容有:订单编号、客户编号、会员卡号、选片张数、销售门市、网销门市、订单总额、化妆金额、已付金额、未付金额、礼服总金额、礼服加挑金额、礼服销售金额、礼服已付金额、礼服未付金额', '0', 'data');
INSERT INTO `api_fields` VALUES ('682', 'viewtype', '5ab99d8594c78', '1', '', '1', '', '模板名称', '0', 'viewtype');
INSERT INTO `api_fields` VALUES ('683', 'type', '5ab99d8594c78', '1', '', '1', '', '执行操作的类型(1:添加,0:修改)', '0', 'type');
INSERT INTO `api_fields` VALUES ('684', 'code', '5ab9a901ee228', '1', '', '1', '', '订单对应的签名 唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('685', 'type', '5ab9a901ee228', '1', '', '1', '', '返回的签名类型(1:url,0:二进制)', '0', 'type');
INSERT INTO `api_fields` VALUES ('687', 'id', '5ae01abbbc263', '1', '', '0', '', 'id', '0', 'id');
INSERT INTO `api_fields` VALUES ('688', 'work_type', '5ae01abbbc263', '2', '', '0', '', '工作类型名称', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('690', 'brandclass_id', '5a004e9c3e030', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('691', 'code', '5ac3579d76bb8', '1', '', '1', '', '订单对应的签名 唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('692', 'staff_number', '5af2f899164f4', '2', '', '0', '', '员工number,多个用英文逗号隔开', '0', 'staff_number');
INSERT INTO `api_fields` VALUES ('693', 'content', '5af2f899164f4', '2', '', '0', '', '短信内容', '0', 'content');
INSERT INTO `api_fields` VALUES ('694', 'send_config', '5af2f899164f4', '2', '', '0', '', '短信配置', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('695', 'staffname', '5af3c003b4cae', '2', '', '0', '', '人员名字，与数据名字，编号模糊查询', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('696', 'staffnumber', '5af3c003b4cae', '2', '', '0', '', '人员编号 与数据名字，编号模糊查询', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('697', 'telephone', '5af3c003b4cae', '2', '', '0', '', '手机号', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('698', 'brandclass', '5af3c003b4cae', '2', '', '0', '', '事业部名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('699', 'brandclass_id', '5af3c003b4cae', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('700', 'shop_name', '5af3c003b4cae', '2', '', '0', '', '店', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('701', 'shop_code', '5af3c003b4cae', '2', '', '0', '', '店', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('702', 'department_name', '5af3c003b4cae', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('703', 'department_id', '5af3c003b4cae', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('710', 'id', '5af3fe7a0a668', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('711', 'brandclass_id', '5af3fe7a0a668', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('712', 'id', '5af40001983f0', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('713', 'brandclass_id', '5af40001983f0', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('717', 'grade_type', '5aff92c0762a0', '1', '', '1', '', '部门所属：1集团，2事业部，3店面', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('718', 'brandclass_id', '5aff92c0762a0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('719', 'shop_code', '5aff92c0762a0', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('720', 'shop_code', '5aec138a7bae9', '2', '', '1', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('721', 'key_words', '5aec138a7bae9', '2', '', '1', '', '手机号,员工名', '0', 'key_words');
INSERT INTO `api_fields` VALUES ('722', 'type', '5b20eb32badd8', '1', '', '1', '', '类型：1岗位code，2人员编号', '0', 'type');
INSERT INTO `api_fields` VALUES ('723', 'number', '5b20eb32badd8', '2', '', '1', '', '岗位code或人员编号', '0', 'number');
INSERT INTO `api_fields` VALUES ('725', 'staff_id', '5b33489a1ec30', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('726', 'staff_id', '5b3ae7a95f370', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('727', 'token', '5b3ae7a95f370', '2', '', '1', '', '要验证的token', '0', 'token');
INSERT INTO `api_fields` VALUES ('729', 'id', '5b3c3dc4ebca8', '1', '', '1', '', '事业部id', '0', 'id');
INSERT INTO `api_fields` VALUES ('730', 'brandclass', '5b3c3dc4ebca8', '2', '', '0', '', '事业部名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('731', 'group_company_name', '5b3c3dc4ebca8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('732', 'nickname', '5b3c3dc4ebca8', '2', '', '0', '', '简称', '0', 'nickname');
INSERT INTO `api_fields` VALUES ('733', 'wx_public', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_public', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('734', 'wx_appid', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('735', 'wx_secret', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('736', 'wx_mch_id', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_mch_id', '0', 'wx_mch_id');
INSERT INTO `api_fields` VALUES ('737', 'wx_pay_key', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_pay_key', '0', 'wx_pay_key');
INSERT INTO `api_fields` VALUES ('738', 'vip_url', '5b3c3dc4ebca8', '2', '', '0', '', 'vip_url', '0', 'vip_url');
INSERT INTO `api_fields` VALUES ('739', 'mall_url', '5b3c3dc4ebca8', '2', '', '0', '', 'mall_url', '0', 'mall_url');
INSERT INTO `api_fields` VALUES ('740', 'sms_config', '5b3c3dc4ebca8', '2', '', '0', '', '短信配置id', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('741', 'valid_date', '5b3c3dc4ebca8', '2', '', '0', '', '客资有效期（填写数字，例：30）', '0', 'valid_date');
INSERT INTO `api_fields` VALUES ('742', 'order_rule', '5b3c3dc4ebca8', '1', '', '0', '', '有效订单标准', '0', 'order_rule');
INSERT INTO `api_fields` VALUES ('743', 'proportion', '5b3c3dc4ebca8', '2', '', '0', '', '有效订单标准值，填写数字，如order_rule为1则为数值，order_rule为2则为数值/100（只填写数值不用处理百分比）', '0', 'proportion');
INSERT INTO `api_fields` VALUES ('744', 'brandclass_id', '5b3c5bec9ee30', '1', '', '1', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('745', 'id', '5b3c5ccadc2a8', '1', '', '1', '', '店id', '0', 'id');
INSERT INTO `api_fields` VALUES ('746', 'shop_name', '5b3c5ccadc2a8', '2', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('747', 'shop_code', '5b3c5ccadc2a8', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('748', 'sn', '5b3c5ccadc2a8', '2', '', '0', '', 'sn', '0', 'sn');
INSERT INTO `api_fields` VALUES ('749', 'group_company_name', '5b3c5ccadc2a8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('750', 'brandclass', '5b3c5ccadc2a8', '2', '', '0', '', 'brandclass', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('751', 'brandclass_id', '5b3c5ccadc2a8', '1', '', '0', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('752', 'shop_type', '5b3c5ccadc2a8', '1', '', '0', '', '店面类型，1婚纱，2儿童，3旅拍，4艺术，5其他', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('753', 'prefix_number', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则前缀', '0', 'prefix_number');
INSERT INTO `api_fields` VALUES ('754', 'numberorder', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则中间主要部分', '0', 'numberorder');
INSERT INTO `api_fields` VALUES ('755', 'serial_number', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则后缀', '0', 'serial_number');
INSERT INTO `api_fields` VALUES ('756', 'shopaddress', '5b3c5ccadc2a8', '2', '', '0', '', '店面地址', '0', 'shopaddress');
INSERT INTO `api_fields` VALUES ('757', 'wx_public', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_public', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('758', 'wx_appid', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('759', 'wx_secret', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('760', 'sms_config', '5b3c5ccadc2a8', '1', '', '0', '', '短信配置', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('761', 'belong_shop_code', '5b3c5ccadc2a8', '2', '', '0', '', '提报客资归属店', '0', 'belong_shop_code');
INSERT INTO `api_fields` VALUES ('762', 'belong_shop_name', '5b3c5ccadc2a8', '2', '', '0', '', '提报客资归属店', '0', 'belong_shop_name');
INSERT INTO `api_fields` VALUES ('763', 'is_marketing', '5b3c5ccadc2a8', '1', '', '0', '', '店面分类，1电商店，2实体店，3网销店，4渠道店', '0', 'is_marketing');
INSERT INTO `api_fields` VALUES ('764', 'is_dig', '5b3c5ccadc2a8', '1', '', '0', '', '是否深挖，1是，2否', '0', 'is_dig');
INSERT INTO `api_fields` VALUES ('765', 'is_sk', '5b3c5ccadc2a8', '1', '', '0', '', '是否深挖', '0', 'is_sk');
INSERT INTO `api_fields` VALUES ('766', 'is_group', '5b3c5ccadc2a8', '1', '', '0', '', '是否集团店，1是2不是', '0', 'is_group');
INSERT INTO `api_fields` VALUES ('767', 'is_photo', '5b3c5ccadc2a8', '1', '', '0', '', '是否拍照店，1是2不是', '0', 'is_photo');
INSERT INTO `api_fields` VALUES ('768', 'shop_code', '5b3dbce7c7da8', '2', '', '1', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('769', 'id', '5b3dbdd2964b0', '1', '', '1', '', '部门id', '0', 'id');
INSERT INTO `api_fields` VALUES ('770', 'department_name', '5b3dbdd2964b0', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('771', 'shop_name', '5b3dbdd2964b0', '2', '', '0', '', '店面名称', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('772', 'shop_code', '5b3dbdd2964b0', '2', '', '0', '', '店面code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('773', 'group_company_name', '5b3dbdd2964b0', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('774', 'brandclass', '5b3dbdd2964b0', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('775', 'brandclass_id', '5b3dbdd2964b0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('776', 'grade_type', '5b3dbdd2964b0', '1', '', '0', '', '1直属集团 2直属事业部 3直属店面', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('777', 'department_id', '5b3dc428987d8', '1', '', '1', '', 'department_id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('778', 'grade_type', '5b3dc4a1dc1e0', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('779', 'code', '5b3dc4a1dc1e0', '2', '', '1', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('780', 'oa_p_id', '5b3dc4a1dc1e0', '2', '', '1', '', 'oa中岗位的id', '0', 'content');
INSERT INTO `api_fields` VALUES ('781', 'grade_type', '5b3dc56a73de8', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('782', 'code', '5b3dc56a73de8', '2', '', '1', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('783', 'oa_p_id', '5b3dc56a73de8', '2', '', '1', '', 'oa岗位表中id，一维数组json_encode后', '0', 'oa_p_id');
INSERT INTO `api_fields` VALUES ('784', 'id', '5b3dc732048a8', '1', '', '1', '', '人员id', '0', 'id');
INSERT INTO `api_fields` VALUES ('785', 'staffnumber', '5b3dc732048a8', '2', '', '0', '', 'staffnumber', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('786', 'staffname', '5b3dc732048a8', '2', '', '0', '', 'staffname', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('787', 'password', '5b3dc732048a8', '2', '', '0', '', '密码（加密后）', '0', 'password');
INSERT INTO `api_fields` VALUES ('788', 'telephone', '5b3dc732048a8', '2', '', '0', '', '手机', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('789', 'main_position_name', '5b3dc732048a8', '2', '', '0', '', 'main_position_name', '0', 'main_position_name');
INSERT INTO `api_fields` VALUES ('790', 'main_position_code', '5b3dc732048a8', '2', '', '0', '', 'main_position_code', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('791', 'main_position_id', '5b3dc732048a8', '2', '', '0', '', 'main_position_id', '0', 'main_position_id');
INSERT INTO `api_fields` VALUES ('792', 'position_code', '5b3dc732048a8', '2', '', '0', '', '兼职岗位，多个用英文逗号隔开', '0', 'position_code');
INSERT INTO `api_fields` VALUES ('793', 'position_id', '5b3dc732048a8', '2', '', '0', '', '兼职岗位id，多个用英文逗号隔开', '0', 'position_id');
INSERT INTO `api_fields` VALUES ('794', 'department_id', '5b3dc732048a8', '1', '', '0', '', 'brandclass_id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('795', 'department_name', '5b3dc732048a8', '2', '', '0', '', 'brandclass_id', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('796', 'shop_name', '5b3dc732048a8', '2', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('797', 'shop_code', '5b3dc732048a8', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('798', 'group_company_name', '5b3dc732048a8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('799', 'brandclass', '5b3dc732048a8', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('800', 'brandclass_id', '5b3dc732048a8', '1', '', '0', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('801', 'grade_type', '5b3dc732048a8', '1', '', '0', '', '1直属集团 2直属事业部 3直属店面 4店下部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('802', 'work_shop', '5b3dc732048a8', '2', '', '0', '', '工作店面', '0', 'work_shop');
INSERT INTO `api_fields` VALUES ('803', 'work_types', '5b3dc732048a8', '2', '', '0', '', '工作类型', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('804', 'work_type_level', '5b3dc732048a8', '2', '', '0', '', '工作类型id +‘_’+ 工作类型等级名称，例:1_高级门市,若没有等级则为1_（多个用英文逗号隔开）', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('805', 'work_type_level_id', '5b3dc732048a8', '2', '', '0', '', '工作类型id +‘_’+ 工作类型等级id，例:1_22,若没有等级则为1_（多个用英文逗号隔开）', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('806', 'entry_date', '5b3dc732048a8', '2', '', '0', '', '入职时间', '0', 'entry_date');
INSERT INTO `api_fields` VALUES ('807', 'leave_date', '5b3dc732048a8', '2', '', '0', '', '离职时间', '0', 'leave_date');
INSERT INTO `api_fields` VALUES ('808', 'contract_endday', '5b3dc732048a8', '2', '', '0', '', '合同到期时间', '0', 'contract_endday');
INSERT INTO `api_fields` VALUES ('809', 'staff_id', '5b3dc87367e80', '1', '', '1', '', '人员id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('856', 'brandclass_id', '59fd58574204a', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('857', 'brandclass_id', '5a14dd1d722a6', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('859', 'grade_type', '5b4717ca97046', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('860', 'code', '5b4717ca97046', '2', '', '0', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('861', 'content', '5b4717ca97046', '2', '', '0', '', 'json格式,多个岗位详情，包括position_name、oa_p_id', '0', 'content');
INSERT INTO `api_fields` VALUES ('862', 'shop_type', '5a005e0038270', '1', '', '0', '', '店面类型，1,2,3  支持,分隔', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('863', 'brandclass_id', '5a00506445948', '2', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('864', 'brandclass_id', '5a14e013b447a', '2', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('866', 'staff_id', '5b6575a339c38', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('867', 'shop_code', '5b75341456d18', '2', '', '1', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('868', 'work_type', '5b75341456d18', '1', '', '1', '', '工作类型编码', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('870', 'id', '5b8630d8d21b8', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('871', 'staffnumber', '5b8630d8d21b8', '2', '', '0', '', '员工编号', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('872', 'staffname', '5b8630d8d21b8', '2', '', '0', '', '员工名称', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('873', 'password', '5b8630d8d21b8', '2', '', '0', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('874', 'grade_type', '5b8630d8d21b8', '1', '', '0', '', '1集团，2事业部，3店面，4店下部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('875', 'group_company_name', '5b8630d8d21b8', '2', '', '0', '', '集团名', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('876', 'brandclass', '5b8630d8d21b8', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('877', 'brandclass_id', '5b8630d8d21b8', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('878', 'shop_name', '5b8630d8d21b8', '2', '', '0', '', '店名', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('879', 'shop_code', '5b8630d8d21b8', '2', '', '0', '', '店唯一标识码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('880', 'sn', '5b8630d8d21b8', '2', '', '0', '', '店简码', '0', 'sn');
INSERT INTO `api_fields` VALUES ('881', 'department_id', '5b8630d8d21b8', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('882', 'department_name', '5b8630d8d21b8', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('883', 'main_position_name', '5b8630d8d21b8', '2', '', '0', '', '主岗位名称', '0', 'main_position_name');
INSERT INTO `api_fields` VALUES ('884', 'main_position_code', '5b8630d8d21b8', '2', '', '0', '', '主岗位标识码', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('885', 'position_code', '5b8630d8d21b8', '2', '', '0', '', '副岗位标识码，多个用英文逗号隔开', '0', 'position_code');
INSERT INTO `api_fields` VALUES ('886', 'leave_date', '5b8630d8d21b8', '2', '', '0', '', '离职日期', '0', 'leave_date');
INSERT INTO `api_fields` VALUES ('901', 'id', '5b876a32ca648', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('902', 'group_company_name', '5b876a32ca648', '2', '', '0', '', '集团名称', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('903', 'wx_public', '5b876a32ca648', '2', '', '0', '', '微信公众号名称', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('904', 'wx_appid', '5b876a32ca648', '2', '', '0', '', '微信公众号appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('905', 'wx_secret', '5b876a32ca648', '2', '', '0', '', '微信公众号secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('906', 'sms_config', '5b876a32ca648', '1', '', '0', '', '短息配置', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('907', 'wx_mch_id', '5b876a32ca648', '2', '', '0', '', '商户号', '0', 'wx_mch_id');
INSERT INTO `api_fields` VALUES ('908', 'wx_pay_key', '5b876a32ca648', '2', '', '0', '', '微信支付秘钥', '0', 'wx_pay_key');
INSERT INTO `api_fields` VALUES ('916', 'id', '5b8a64f1c39b0', '1', '', '1', '', '工作类型等级表主键id', '0', 'id');
INSERT INTO `api_fields` VALUES ('917', 'level_name', '5b8a64f1c39b0', '2', '', '0', '', '等级名称', '0', 'level_name');
INSERT INTO `api_fields` VALUES ('918', 'work_type_id', '5b8a64f1c39b0', '1', '', '0', '', '工作类型id', '0', 'work_type_id');
INSERT INTO `api_fields` VALUES ('919', 'work_type', '5b8a64f1c39b0', '2', '', '0', '', '工作类型名称', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('920', 'sort', '5b8a64f1c39b0', '2', '', '0', '', '排序', '0', 'sort');
INSERT INTO `api_fields` VALUES ('921', 'add_time', '5b8a64f1c39b0', '1', '', '0', '', '添加时间', '0', 'add_time');
INSERT INTO `api_fields` VALUES ('922', 'id', '5b8a655b5d4f8', '1', '', '1', '', '工作类型等级表主键id', '0', 'id');
INSERT INTO `api_fields` VALUES ('923', 'staff_id', '5b9cac8aa21c0', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('924', 'brandclass_id', '5b9cac8aa21c0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('925', 'shop_type', '5b9cac8aa21c0', '1', '', '0', '', '店面类型（儿童2，婚纱）', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('926', 'shop_code', '5bc58874c5828', '2', '', '1', '', '店面唯一识别码，多个用英文逗号隔开', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('927', 'work_type', '5bc58874c5828', '1', '', '1', '', '工作类型编码', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('929', 'type', '5bc8702e3e056', '2', '', '1', '', '类型', '0', 'type');
INSERT INTO `api_fields` VALUES ('930', 'msg', '5bc8702e3e056', '2', '', '1', '', '消息', '0', 'msg');
INSERT INTO `api_fields` VALUES ('931', 'type', '5bc870ff09178', '2', '', '1', '', '类型', '0', 'type');
INSERT INTO `api_fields` VALUES ('932', 'msg', '5bc870ff09178', '2', '', '1', '', '消息', '0', 'msg');
INSERT INTO `api_fields` VALUES ('933', 'staff_id', '5bc870ff09178', '2', '', '2', '', '员工id，json格式', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('934', 'rid', '5bc870ff09178', '2', '', '2', '', '极光id，json格式', '0', 'msg');
INSERT INTO `api_fields` VALUES ('935', 'staff_id', '5bc871078bcee', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('936', 'imgs', '5bc94272b051a', '6', '', '1', '', '图片文件信息', '0', 'imgs');
INSERT INTO `api_fields` VALUES ('937', 'is_cover', '5bc94272b051a', '1', '', '1', '', '同文件是否覆盖，1：覆盖；2：不覆盖', '0', 'is_cover');
INSERT INTO `api_fields` VALUES ('938', 'img_path', '5bc94294ae9c2', '2', '', '1', '', '删除图片，支持多图片删除，逗号分隔', '0', 'img_path');
INSERT INTO `api_fields` VALUES ('939', 'brandclass_id', '5bcd7a65e1d8c', '1', '', '1', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('940', 'grade_type', '5bcd7b190d812', '1', '', '1', '', '部门所属类型', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('941', 'brandclass_id', '5bcd7b190d812', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('942', 'shop_code', '5bcd7b190d812', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('943', 'grade_type', '5bcd7bf31b0c2', '1', '', '1', '', '人员类型id', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('944', 'brandclass_id', '5bcd7bf31b0c2', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('945', 'shop_code', '5bcd7bf31b0c2', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('946', 'department_id', '5bcd7bf31b0c2', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('947', 'key_words', '5bcd7c794bcbd', '2', '', '0', '', '要查询的字段', '0', 'key_words');
INSERT INTO `api_fields` VALUES ('954', 'department', '5bd27d0a93120', '2', '', '1', '', '部门信息，json格式', '0', 'department');
INSERT INTO `api_fields` VALUES ('955', 'position', '5bd27d0a93120', '2', '', '1', '', '岗位信息，json格式', '0', 'position');
INSERT INTO `api_fields` VALUES ('957', 'data', '5bdaed7e5e551', '2', '', '1', '', '事业部id', '0', 'data');
INSERT INTO `api_fields` VALUES ('958', 'data', '5bdaee20b646d', '2', '', '1', '', '部门所属类型', '0', 'data');
INSERT INTO `api_fields` VALUES ('959', 'data', '5bdaee2a462e6', '2', '', '1', '', '事业部id', '0', 'data');
INSERT INTO `api_fields` VALUES ('960', 'data', '5bdaee35ac5ad', '2', '', '1', '', '店面识别码', '0', 'data');
INSERT INTO `api_fields` VALUES ('964', 'get_main', '5a0e6f272bb38', '1', '', '0', '', '1:不查看兼职； 2:查看兼职；', '0', 'get_main');
INSERT INTO `api_fields` VALUES ('965', 'order_id', '5c9ae4289e598', '2', '', '1', '', '订单编号', '0', 'order_id');
INSERT INTO `api_fields` VALUES ('966', 'brand_id', '5c9ae4289e598', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('967', 'code', '5c9ae4289e598', '2', '', '1', '', '唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('968', 'staff_number', '5cbe739c8d8d8', '2', '', '1', '', '员工编号', '0', 'staff_number');
INSERT INTO `api_fields` VALUES ('969', 'is_op', '5cbe739c8d8d8', '1', '', '0', '', '店面标识 1：拍照店； 2：接单店； 3：选片店； 4：取件店', '0', 'is_op');
INSERT INTO `api_fields` VALUES ('971', 'group_id', '5cc6ed5f19c60', '1', '', '0', '', '组id', '0', 'group_id');
INSERT INTO `api_fields` VALUES ('972', 'group_name', '5cc6ed5f19c60', '2', '', '0', '', '组名', '0', 'group_name');
INSERT INTO `api_fields` VALUES ('973', 'department_id', '5cc6ed5f19c60', '2', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('974', 'department_name', '5cc6ed5f19c60', '2', '', '0', '', '部门名', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('975', 'shop_code', '5cc6ed5f19c60', '1', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('976', 'shop_name', '5cc6ed5f19c60', '1', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('977', 'brandclass_id', '5cc6ed5f19c60', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('978', 'brandclass', '5cc6ed5f19c60', '1', '', '0', '', '事业部名', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('986', 'order_no', '5ccfccc905078', '2', '', '1', '', '商户订单号', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('987', 'refund_fee', '5ccfccc905078', '1', '', '0', '', '退款金额（单位为分,可以做部分退款）', '0', 'refund_fee');
INSERT INTO `api_fields` VALUES ('989', 'code', '5ce4f98fa25c3', '1', '', '0', '', 'code', '0', 'code');
INSERT INTO `api_fields` VALUES ('990', 'order_id', '5ce791a0e5268', '2', '', '1', '', '订单号', '0', 'order_id');
INSERT INTO `api_fields` VALUES ('991', 'fc_id', '5ce791a0e5268', '1', '', '0', '', '订单服次', '0', 'fc_id');
INSERT INTO `api_fields` VALUES ('992', 'file_name', '5ce791a0e5268', '1', '', '0', '', '文件名', '0', 'file_name');
INSERT INTO `api_fields` VALUES ('993', 'img', '5ce791a0e5268', '1', '', '0', '', '文件', '0', 'img');
INSERT INTO `api_fields` VALUES ('997', 'group_id', '5cf8d76edd1ca', '1', '', '1', '', '组ID', '0', 'group_id');
INSERT INTO `api_fields` VALUES ('1286', 'shop_code', '5a62dcd5c7e40', '2', '', '1', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1287', 'group_company_name', '5a6978bb82027', '2', '', '0', '', '集团名称', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1288', 'id', '5a6978bb82027', '1', '', '0', '', '集团id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1290', 'shop_code', '5a706286930ce', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1291', 'shop_code', '5a7076a6ccfaa', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1292', 'department_id', '5a01766b4a3dd', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1293', 'id', '5a704aa96e503', '1', '', '0', '', '省id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1294', 'name', '5a704aa96e503', '2', '', '0', '', '省份', '0', 'name');
INSERT INTO `api_fields` VALUES ('1296', 'grade_type', '5a01766b4a3dd', '1', '', '0', '', '等级，1集团，2事业部，3店面，4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1297', 'main_position_code', '5a01766b4a3dd', '2', '', '0', '', '主岗位标识', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('1298', 'is_photo', '5a39fd8c6c9f7', '1', '', '0', '', '是否为拍照店，1是2不是', '0', 'is_photo');
INSERT INTO `api_fields` VALUES ('1299', 'shop_code', '5a7424f13aa54', '2', '', '0', '', '店面标识', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1300', 'shop_code', '5a73d4f13a9eb', '2', '', '0', '', '店面标识', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1301', 'brandclass_id', '5a73d4f13a9eb', '1', '', '0', '', '事业部编号', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1302', 'scene', '5a73d4f13a9eb', '2', '', '0', '', '场景编号，即参数，不重复', '0', 'scene');
INSERT INTO `api_fields` VALUES ('1303', 'type', '5a73d4f13a9eb', '1', '', '0', '', '类型1永久，2临时，临时有效期为1个月', '0', 'type');
INSERT INTO `api_fields` VALUES ('1307', 'mobile', '5a780e2613bb9', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('1308', 'verify_code', '5a780e2613bb9', '2', '', '1', '', '验证码', '0', 'verify_code');
INSERT INTO `api_fields` VALUES ('1309', 'shop_code', '5a780e2613bb9', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1310', 'mobile', '5a7bdbdaa5870', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('1311', 'content', '5a7bdbdaa5870', '2', '', '1', '', '内容，必须符合模板要求，可以签名也可以不带签名。', '0', 'content');
INSERT INTO `api_fields` VALUES ('1312', 'send_time', '5a7bdbdaa5870', '2', '', '0', '', '发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56 ', '0', 'send_time');
INSERT INTO `api_fields` VALUES ('1313', 'shop_code', '5a7bdbdaa5870', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1317', 'staff_id', '5a8fd8296f3d3', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1318', 'vip_url', '5a38840b15ba9', '2', '', '0', '', '会员网址', '0', 'vip_url');
INSERT INTO `api_fields` VALUES ('1319', 'belong_shop_code', '5a005e0038270', '2', '', '0', '', '归属店shop_code', '0', 'belong_shop_code');
INSERT INTO `api_fields` VALUES ('1320', 'staff_id', '5aae44296a6bf', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1321', 'brand_id', '5aae44296a6bf', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('1322', 'send_config', '5aae44296a6bf', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1323', 'staff_id', '5aae46527269f', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1324', 'brand_id', '5aae46527269f', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('1325', 'send_config', '5aae46527269f', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1326', 'staff_id', '5aae460d2996e', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1327', 'brand_id', '5aae460d2996e', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('1328', 'send_config', '5aae460d2996e', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1329', 'staff_id', '5aae466ce7ddd', '2', '', '0', '', '门店识别码，与事业部编码和配置号传一个即可', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1330', 'brand_id', '5aae466ce7ddd', '1', '', '0', '', '事业部编码，与门店识别码和配置号传一个即可', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('1331', 'send_config', '5aae466ce7ddd', '2', '', '0', '', '配置号，与事业部编码和门店识别码传一个即可', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1332', 'send_config', '5a5df0ae0fcd5', '2', '', '0', '', '配置号，使用指定配置发短信', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1333', 'send_config', '5a17b86088f1a', '2', '', '0', '', '配置号，使用指定配置发短信', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1335', 'shop_code', '5aafa4ac48058', '2', '', '0', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1336', 'brandclass_id', '5aafa4ac48058', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1337', 'brandclass_id', '5a005e0038270', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1338', 'is_marketing', '5a005e0038270', '1', '', '0', '', '是否是营销店', '0', 'is_marketing');
INSERT INTO `api_fields` VALUES ('1340', 'mobile', '5ab88f1fd2f00', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('1341', 'mobile', '5ab8b32fcc970', '2', '', '1', '', '手机号', '0', 'mobile');
INSERT INTO `api_fields` VALUES ('1342', 'code', '5ab99d8594c78', '2', '', '1', '', '订单与签名的 唯一值', '0', 'code');
INSERT INTO `api_fields` VALUES ('1343', 'data', '5ab99d8594c78', '2', '', '1', '', '订单主要数据内容有:订单编号、客户编号、会员卡号、选片张数、销售门市、网销门市、订单总额、化妆金额、已付金额、未付金额、礼服总金额、礼服加挑金额、礼服销售金额、礼服已付金额、礼服未付金额', '0', 'data');
INSERT INTO `api_fields` VALUES ('1344', 'viewtype', '5ab99d8594c78', '1', '', '1', '', '模板名称', '0', 'viewtype');
INSERT INTO `api_fields` VALUES ('1345', 'type', '5ab99d8594c78', '1', '', '1', '', '执行操作的类型(1:添加,0:修改)', '0', 'type');
INSERT INTO `api_fields` VALUES ('1346', 'code', '5ab9a901ee228', '1', '', '1', '', '订单对应的签名 唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('1347', 'type', '5ab9a901ee228', '1', '', '1', '', '返回的签名类型(1:url,0:二进制)', '0', 'type');
INSERT INTO `api_fields` VALUES ('1349', 'id', '5ae01abbbc263', '1', '', '0', '', 'id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1350', 'work_type', '5ae01abbbc263', '2', '', '0', '', '工作类型名称', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('1352', 'brandclass_id', '5a004e9c3e030', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1353', 'code', '5ac3579d76bb8', '1', '', '1', '', '订单对应的签名 唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('1354', 'staff_number', '5af2f899164f4', '2', '', '0', '', '员工number,多个用英文逗号隔开', '0', 'staff_number');
INSERT INTO `api_fields` VALUES ('1355', 'content', '5af2f899164f4', '2', '', '0', '', '短信内容', '0', 'content');
INSERT INTO `api_fields` VALUES ('1356', 'send_config', '5af2f899164f4', '2', '', '0', '', '短信配置', '0', 'send_config');
INSERT INTO `api_fields` VALUES ('1357', 'staffname', '5af3c003b4cae', '2', '', '0', '', '人员名字，与数据名字，编号模糊查询', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('1358', 'staffnumber', '5af3c003b4cae', '2', '', '0', '', '人员编号 与数据名字，编号模糊查询', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('1359', 'telephone', '5af3c003b4cae', '2', '', '0', '', '手机号', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('1360', 'brandclass', '5af3c003b4cae', '2', '', '0', '', '事业部名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1361', 'brandclass_id', '5af3c003b4cae', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1362', 'shop_name', '5af3c003b4cae', '2', '', '0', '', '店', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('1363', 'shop_code', '5af3c003b4cae', '2', '', '0', '', '店', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1364', 'department_name', '5af3c003b4cae', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('1365', 'department_id', '5af3c003b4cae', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1372', 'id', '5af3fe7a0a668', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('1373', 'brandclass_id', '5af3fe7a0a668', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1374', 'id', '5af40001983f0', '1', '', '0', '', '', '0', 'id');
INSERT INTO `api_fields` VALUES ('1375', 'brandclass_id', '5af40001983f0', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1379', 'grade_type', '5aff92c0762a0', '1', '', '1', '', '部门所属：1集团，2事业部，3店面', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1380', 'brandclass_id', '5aff92c0762a0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1381', 'shop_code', '5aff92c0762a0', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1382', 'shop_code', '5aec138a7bae9', '2', '', '1', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1383', 'key_words', '5aec138a7bae9', '2', '', '1', '', '手机号,员工名', '0', 'key_words');
INSERT INTO `api_fields` VALUES ('1384', 'type', '5b20eb32badd8', '1', '', '1', '', '类型：1岗位code，2人员编号', '0', 'type');
INSERT INTO `api_fields` VALUES ('1385', 'number', '5b20eb32badd8', '2', '', '1', '', '岗位code或人员编号', '0', 'number');
INSERT INTO `api_fields` VALUES ('1387', 'staff_id', '5b33489a1ec30', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1388', 'staff_id', '5b3ae7a95f370', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1389', 'token', '5b3ae7a95f370', '2', '', '1', '', '要验证的token', '0', 'token');
INSERT INTO `api_fields` VALUES ('1391', 'id', '5b3c3dc4ebca8', '1', '', '1', '', '事业部id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1392', 'brandclass', '5b3c3dc4ebca8', '2', '', '0', '', '事业部名称', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1393', 'group_company_name', '5b3c3dc4ebca8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1394', 'nickname', '5b3c3dc4ebca8', '2', '', '0', '', '简称', '0', 'nickname');
INSERT INTO `api_fields` VALUES ('1395', 'wx_public', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_public', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('1396', 'wx_appid', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('1397', 'wx_secret', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('1398', 'wx_mch_id', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_mch_id', '0', 'wx_mch_id');
INSERT INTO `api_fields` VALUES ('1399', 'wx_pay_key', '5b3c3dc4ebca8', '2', '', '0', '', 'wx_pay_key', '0', 'wx_pay_key');
INSERT INTO `api_fields` VALUES ('1400', 'vip_url', '5b3c3dc4ebca8', '2', '', '0', '', 'vip_url', '0', 'vip_url');
INSERT INTO `api_fields` VALUES ('1401', 'mall_url', '5b3c3dc4ebca8', '2', '', '0', '', 'mall_url', '0', 'mall_url');
INSERT INTO `api_fields` VALUES ('1402', 'sms_config', '5b3c3dc4ebca8', '2', '', '0', '', '短信配置id', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('1403', 'valid_date', '5b3c3dc4ebca8', '2', '', '0', '', '客资有效期（填写数字，例：30）', '0', 'valid_date');
INSERT INTO `api_fields` VALUES ('1404', 'order_rule', '5b3c3dc4ebca8', '1', '', '0', '', '有效订单标准', '0', 'order_rule');
INSERT INTO `api_fields` VALUES ('1405', 'proportion', '5b3c3dc4ebca8', '2', '', '0', '', '有效订单标准值，填写数字，如order_rule为1则为数值，order_rule为2则为数值/100（只填写数值不用处理百分比）', '0', 'proportion');
INSERT INTO `api_fields` VALUES ('1406', 'brandclass_id', '5b3c5bec9ee30', '1', '', '1', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1407', 'id', '5b3c5ccadc2a8', '1', '', '1', '', '店id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1408', 'shop_name', '5b3c5ccadc2a8', '2', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('1409', 'shop_code', '5b3c5ccadc2a8', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1410', 'sn', '5b3c5ccadc2a8', '2', '', '0', '', 'sn', '0', 'sn');
INSERT INTO `api_fields` VALUES ('1411', 'group_company_name', '5b3c5ccadc2a8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1412', 'brandclass', '5b3c5ccadc2a8', '2', '', '0', '', 'brandclass', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1413', 'brandclass_id', '5b3c5ccadc2a8', '1', '', '0', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1414', 'shop_type', '5b3c5ccadc2a8', '1', '', '0', '', '店面类型，1婚纱，2儿童，3旅拍，4艺术，5其他', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('1415', 'prefix_number', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则前缀', '0', 'prefix_number');
INSERT INTO `api_fields` VALUES ('1416', 'numberorder', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则中间主要部分', '0', 'numberorder');
INSERT INTO `api_fields` VALUES ('1417', 'serial_number', '5b3c5ccadc2a8', '2', '', '0', '', '订单规则后缀', '0', 'serial_number');
INSERT INTO `api_fields` VALUES ('1418', 'shopaddress', '5b3c5ccadc2a8', '2', '', '0', '', '店面地址', '0', 'shopaddress');
INSERT INTO `api_fields` VALUES ('1419', 'wx_public', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_public', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('1420', 'wx_appid', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('1421', 'wx_secret', '5b3c5ccadc2a8', '2', '', '0', '', 'wx_secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('1422', 'sms_config', '5b3c5ccadc2a8', '1', '', '0', '', '短信配置', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('1423', 'belong_shop_code', '5b3c5ccadc2a8', '2', '', '0', '', '提报客资归属店', '0', 'belong_shop_code');
INSERT INTO `api_fields` VALUES ('1424', 'belong_shop_name', '5b3c5ccadc2a8', '2', '', '0', '', '提报客资归属店', '0', 'belong_shop_name');
INSERT INTO `api_fields` VALUES ('1425', 'is_marketing', '5b3c5ccadc2a8', '1', '', '0', '', '店面分类，1电商店，2实体店，3网销店，4渠道店', '0', 'is_marketing');
INSERT INTO `api_fields` VALUES ('1426', 'is_dig', '5b3c5ccadc2a8', '1', '', '0', '', '是否深挖，1是，2否', '0', 'is_dig');
INSERT INTO `api_fields` VALUES ('1427', 'is_sk', '5b3c5ccadc2a8', '1', '', '0', '', '是否深挖', '0', 'is_sk');
INSERT INTO `api_fields` VALUES ('1428', 'is_group', '5b3c5ccadc2a8', '1', '', '0', '', '是否集团店，1是2不是', '0', 'is_group');
INSERT INTO `api_fields` VALUES ('1429', 'is_photo', '5b3c5ccadc2a8', '1', '', '0', '', '是否拍照店，1是2不是', '0', 'is_photo');
INSERT INTO `api_fields` VALUES ('1430', 'shop_code', '5b3dbce7c7da8', '2', '', '1', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1431', 'id', '5b3dbdd2964b0', '1', '', '1', '', '部门id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1432', 'department_name', '5b3dbdd2964b0', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('1433', 'shop_name', '5b3dbdd2964b0', '2', '', '0', '', '店面名称', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('1434', 'shop_code', '5b3dbdd2964b0', '2', '', '0', '', '店面code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1435', 'group_company_name', '5b3dbdd2964b0', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1436', 'brandclass', '5b3dbdd2964b0', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1437', 'brandclass_id', '5b3dbdd2964b0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1438', 'grade_type', '5b3dbdd2964b0', '1', '', '0', '', '1直属集团 2直属事业部 3直属店面', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1439', 'department_id', '5b3dc428987d8', '1', '', '1', '', 'department_id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1440', 'grade_type', '5b3dc4a1dc1e0', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1441', 'code', '5b3dc4a1dc1e0', '2', '', '1', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('1442', 'oa_p_id', '5b3dc4a1dc1e0', '2', '', '1', '', 'oa中岗位的id', '0', 'content');
INSERT INTO `api_fields` VALUES ('1443', 'grade_type', '5b3dc56a73de8', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1444', 'code', '5b3dc56a73de8', '2', '', '1', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('1445', 'oa_p_id', '5b3dc56a73de8', '2', '', '1', '', 'oa岗位表中id，一维数组json_encode后', '0', 'oa_p_id');
INSERT INTO `api_fields` VALUES ('1446', 'id', '5b3dc732048a8', '1', '', '1', '', '人员id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1447', 'staffnumber', '5b3dc732048a8', '2', '', '0', '', 'staffnumber', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('1448', 'staffname', '5b3dc732048a8', '2', '', '0', '', 'staffname', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('1449', 'password', '5b3dc732048a8', '2', '', '0', '', '密码（加密后）', '0', 'password');
INSERT INTO `api_fields` VALUES ('1450', 'telephone', '5b3dc732048a8', '2', '', '0', '', '手机', '0', 'telephone');
INSERT INTO `api_fields` VALUES ('1451', 'main_position_name', '5b3dc732048a8', '2', '', '0', '', 'main_position_name', '0', 'main_position_name');
INSERT INTO `api_fields` VALUES ('1452', 'main_position_code', '5b3dc732048a8', '2', '', '0', '', 'main_position_code', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('1453', 'main_position_id', '5b3dc732048a8', '2', '', '0', '', 'main_position_id', '0', 'main_position_id');
INSERT INTO `api_fields` VALUES ('1454', 'position_code', '5b3dc732048a8', '2', '', '0', '', '兼职岗位，多个用英文逗号隔开', '0', 'position_code');
INSERT INTO `api_fields` VALUES ('1455', 'position_id', '5b3dc732048a8', '2', '', '0', '', '兼职岗位id，多个用英文逗号隔开', '0', 'position_id');
INSERT INTO `api_fields` VALUES ('1456', 'department_id', '5b3dc732048a8', '1', '', '0', '', 'brandclass_id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1457', 'department_name', '5b3dc732048a8', '2', '', '0', '', 'brandclass_id', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('1458', 'shop_name', '5b3dc732048a8', '2', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('1459', 'shop_code', '5b3dc732048a8', '2', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1460', 'group_company_name', '5b3dc732048a8', '2', '', '0', '', '集团', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1461', 'brandclass', '5b3dc732048a8', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1462', 'brandclass_id', '5b3dc732048a8', '1', '', '0', '', 'brandclass_id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1463', 'grade_type', '5b3dc732048a8', '1', '', '0', '', '1直属集团 2直属事业部 3直属店面 4店下部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1464', 'work_shop', '5b3dc732048a8', '2', '', '0', '', '工作店面', '0', 'work_shop');
INSERT INTO `api_fields` VALUES ('1465', 'work_types', '5b3dc732048a8', '2', '', '0', '', '工作类型', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('1466', 'work_type_level', '5b3dc732048a8', '2', '', '0', '', '工作类型id +‘_’+ 工作类型等级名称，例:1_高级门市,若没有等级则为1_（多个用英文逗号隔开）', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('1467', 'work_type_level_id', '5b3dc732048a8', '2', '', '0', '', '工作类型id +‘_’+ 工作类型等级id，例:1_22,若没有等级则为1_（多个用英文逗号隔开）', '0', 'work_types');
INSERT INTO `api_fields` VALUES ('1468', 'entry_date', '5b3dc732048a8', '2', '', '0', '', '入职时间', '0', 'entry_date');
INSERT INTO `api_fields` VALUES ('1469', 'leave_date', '5b3dc732048a8', '2', '', '0', '', '离职时间', '0', 'leave_date');
INSERT INTO `api_fields` VALUES ('1470', 'contract_endday', '5b3dc732048a8', '2', '', '0', '', '合同到期时间', '0', 'contract_endday');
INSERT INTO `api_fields` VALUES ('1471', 'staff_id', '5b3dc87367e80', '1', '', '1', '', '人员id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1518', 'brandclass_id', '59fd58574204a', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1519', 'brandclass_id', '5a14dd1d722a6', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1521', 'grade_type', '5b4717ca97046', '1', '', '1', '', '1直属集团 2直属事业部 3直属店面 4部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1522', 'code', '5b4717ca97046', '2', '', '0', '', 'grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id', '0', 'code');
INSERT INTO `api_fields` VALUES ('1523', 'content', '5b4717ca97046', '2', '', '0', '', 'json格式,多个岗位详情，包括position_name、oa_p_id', '0', 'content');
INSERT INTO `api_fields` VALUES ('1524', 'shop_type', '5a005e0038270', '1', '', '0', '', '店面类型，1,2,3  支持,分隔', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('1525', 'brandclass_id', '5a00506445948', '2', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1526', 'brandclass_id', '5a14e013b447a', '2', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1528', 'staff_id', '5b6575a339c38', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1529', 'shop_code', '5b75341456d18', '2', '', '1', '', '店面唯一识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1530', 'work_type', '5b75341456d18', '1', '', '1', '', '工作类型编码', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('1532', 'id', '5b8630d8d21b8', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1533', 'staffnumber', '5b8630d8d21b8', '2', '', '0', '', '员工编号', '0', 'staffnumber');
INSERT INTO `api_fields` VALUES ('1534', 'staffname', '5b8630d8d21b8', '2', '', '0', '', '员工名称', '0', 'staffname');
INSERT INTO `api_fields` VALUES ('1535', 'password', '5b8630d8d21b8', '2', '', '0', '', '密码', '0', 'password');
INSERT INTO `api_fields` VALUES ('1536', 'grade_type', '5b8630d8d21b8', '1', '', '0', '', '1集团，2事业部，3店面，4店下部门', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1537', 'group_company_name', '5b8630d8d21b8', '2', '', '0', '', '集团名', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1538', 'brandclass', '5b8630d8d21b8', '2', '', '0', '', '事业部', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1539', 'brandclass_id', '5b8630d8d21b8', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1540', 'shop_name', '5b8630d8d21b8', '2', '', '0', '', '店名', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('1541', 'shop_code', '5b8630d8d21b8', '2', '', '0', '', '店唯一标识码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1542', 'sn', '5b8630d8d21b8', '2', '', '0', '', '店简码', '0', 'sn');
INSERT INTO `api_fields` VALUES ('1543', 'department_id', '5b8630d8d21b8', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1544', 'department_name', '5b8630d8d21b8', '2', '', '0', '', '部门名称', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('1545', 'main_position_name', '5b8630d8d21b8', '2', '', '0', '', '主岗位名称', '0', 'main_position_name');
INSERT INTO `api_fields` VALUES ('1546', 'main_position_code', '5b8630d8d21b8', '2', '', '0', '', '主岗位标识码', '0', 'main_position_code');
INSERT INTO `api_fields` VALUES ('1547', 'position_code', '5b8630d8d21b8', '2', '', '0', '', '副岗位标识码，多个用英文逗号隔开', '0', 'position_code');
INSERT INTO `api_fields` VALUES ('1548', 'leave_date', '5b8630d8d21b8', '2', '', '0', '', '离职日期', '0', 'leave_date');
INSERT INTO `api_fields` VALUES ('1563', 'id', '5b876a32ca648', '1', '', '1', '', '员工id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1564', 'group_company_name', '5b876a32ca648', '2', '', '0', '', '集团名称', '0', 'group_company_name');
INSERT INTO `api_fields` VALUES ('1565', 'wx_public', '5b876a32ca648', '2', '', '0', '', '微信公众号名称', '0', 'wx_public');
INSERT INTO `api_fields` VALUES ('1566', 'wx_appid', '5b876a32ca648', '2', '', '0', '', '微信公众号appid', '0', 'wx_appid');
INSERT INTO `api_fields` VALUES ('1567', 'wx_secret', '5b876a32ca648', '2', '', '0', '', '微信公众号secret', '0', 'wx_secret');
INSERT INTO `api_fields` VALUES ('1568', 'sms_config', '5b876a32ca648', '1', '', '0', '', '短息配置', '0', 'sms_config');
INSERT INTO `api_fields` VALUES ('1569', 'wx_mch_id', '5b876a32ca648', '2', '', '0', '', '商户号', '0', 'wx_mch_id');
INSERT INTO `api_fields` VALUES ('1570', 'wx_pay_key', '5b876a32ca648', '2', '', '0', '', '微信支付秘钥', '0', 'wx_pay_key');
INSERT INTO `api_fields` VALUES ('1578', 'id', '5b8a64f1c39b0', '1', '', '1', '', '工作类型等级表主键id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1579', 'level_name', '5b8a64f1c39b0', '2', '', '0', '', '等级名称', '0', 'level_name');
INSERT INTO `api_fields` VALUES ('1580', 'work_type_id', '5b8a64f1c39b0', '1', '', '0', '', '工作类型id', '0', 'work_type_id');
INSERT INTO `api_fields` VALUES ('1581', 'work_type', '5b8a64f1c39b0', '2', '', '0', '', '工作类型名称', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('1582', 'sort', '5b8a64f1c39b0', '2', '', '0', '', '排序', '0', 'sort');
INSERT INTO `api_fields` VALUES ('1583', 'add_time', '5b8a64f1c39b0', '1', '', '0', '', '添加时间', '0', 'add_time');
INSERT INTO `api_fields` VALUES ('1584', 'id', '5b8a655b5d4f8', '1', '', '1', '', '工作类型等级表主键id', '0', 'id');
INSERT INTO `api_fields` VALUES ('1585', 'staff_id', '5b9cac8aa21c0', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1586', 'brandclass_id', '5b9cac8aa21c0', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1587', 'shop_type', '5b9cac8aa21c0', '1', '', '0', '', '店面类型（儿童2，婚纱）', '0', 'shop_type');
INSERT INTO `api_fields` VALUES ('1588', 'shop_code', '5bc58874c5828', '2', '', '1', '', '店面唯一识别码，多个用英文逗号隔开', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1589', 'work_type', '5bc58874c5828', '1', '', '1', '', '工作类型编码', '0', 'work_type');
INSERT INTO `api_fields` VALUES ('1591', 'type', '5bc8702e3e056', '2', '', '1', '', '类型', '0', 'type');
INSERT INTO `api_fields` VALUES ('1592', 'msg', '5bc8702e3e056', '2', '', '1', '', '消息', '0', 'msg');
INSERT INTO `api_fields` VALUES ('1593', 'type', '5bc870ff09178', '2', '', '1', '', '类型', '0', 'type');
INSERT INTO `api_fields` VALUES ('1594', 'msg', '5bc870ff09178', '2', '', '1', '', '消息', '0', 'msg');
INSERT INTO `api_fields` VALUES ('1595', 'staff_id', '5bc870ff09178', '2', '', '2', '', '员工id，json格式', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1596', 'rid', '5bc870ff09178', '2', '', '2', '', '极光id，json格式', '0', 'msg');
INSERT INTO `api_fields` VALUES ('1597', 'staff_id', '5bc871078bcee', '1', '', '1', '', '员工id', '0', 'staff_id');
INSERT INTO `api_fields` VALUES ('1598', 'imgs', '5bc94272b051a', '6', '', '1', '', '图片文件信息', '0', 'imgs');
INSERT INTO `api_fields` VALUES ('1599', 'is_cover', '5bc94272b051a', '1', '', '1', '', '同文件是否覆盖，1：覆盖；2：不覆盖', '0', 'is_cover');
INSERT INTO `api_fields` VALUES ('1600', 'img_path', '5bc94294ae9c2', '2', '', '1', '', '删除图片，支持多图片删除，逗号分隔', '0', 'img_path');
INSERT INTO `api_fields` VALUES ('1601', 'brandclass_id', '5bcd7a65e1d8c', '1', '', '1', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1602', 'grade_type', '5bcd7b190d812', '1', '', '1', '', '部门所属类型', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1603', 'brandclass_id', '5bcd7b190d812', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1604', 'shop_code', '5bcd7b190d812', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1605', 'grade_type', '5bcd7bf31b0c2', '1', '', '1', '', '人员类型id', '0', 'grade_type');
INSERT INTO `api_fields` VALUES ('1606', 'brandclass_id', '5bcd7bf31b0c2', '1', '', '0', '', '事业部id', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1607', 'shop_code', '5bcd7bf31b0c2', '2', '', '0', '', '店面识别码', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1608', 'department_id', '5bcd7bf31b0c2', '1', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1609', 'key_words', '5bcd7c794bcbd', '2', '', '0', '', '要查询的字段', '0', 'key_words');
INSERT INTO `api_fields` VALUES ('1616', 'department', '5bd27d0a93120', '2', '', '1', '', '部门信息，json格式', '0', 'department');
INSERT INTO `api_fields` VALUES ('1617', 'position', '5bd27d0a93120', '2', '', '1', '', '岗位信息，json格式', '0', 'position');
INSERT INTO `api_fields` VALUES ('1619', 'data', '5bdaed7e5e551', '2', '', '1', '', '事业部id', '0', 'data');
INSERT INTO `api_fields` VALUES ('1620', 'data', '5bdaee20b646d', '2', '', '1', '', '部门所属类型', '0', 'data');
INSERT INTO `api_fields` VALUES ('1621', 'data', '5bdaee2a462e6', '2', '', '1', '', '事业部id', '0', 'data');
INSERT INTO `api_fields` VALUES ('1622', 'data', '5bdaee35ac5ad', '2', '', '1', '', '店面识别码', '0', 'data');
INSERT INTO `api_fields` VALUES ('1626', 'get_main', '5a0e6f272bb38', '1', '', '0', '', '1:不查看兼职； 2:查看兼职；', '0', 'get_main');
INSERT INTO `api_fields` VALUES ('1627', 'order_id', '5c9ae4289e598', '2', '', '1', '', '订单编号', '0', 'order_id');
INSERT INTO `api_fields` VALUES ('1628', 'brand_id', '5c9ae4289e598', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO `api_fields` VALUES ('1629', 'code', '5c9ae4289e598', '2', '', '1', '', '唯一标识', '0', 'code');
INSERT INTO `api_fields` VALUES ('1630', 'staff_number', '5cbe739c8d8d8', '2', '', '1', '', '员工编号', '0', 'staff_number');
INSERT INTO `api_fields` VALUES ('1631', 'is_op', '5cbe739c8d8d8', '1', '', '0', '', '店面标识 1：拍照店； 2：接单店； 3：选片店； 4：取件店', '0', 'is_op');
INSERT INTO `api_fields` VALUES ('1633', 'group_id', '5cc6ed5f19c60', '1', '', '0', '', '组id', '0', 'group_id');
INSERT INTO `api_fields` VALUES ('1634', 'group_name', '5cc6ed5f19c60', '2', '', '0', '', '组名', '0', 'group_name');
INSERT INTO `api_fields` VALUES ('1635', 'department_id', '5cc6ed5f19c60', '2', '', '0', '', '部门id', '0', 'department_id');
INSERT INTO `api_fields` VALUES ('1636', 'department_name', '5cc6ed5f19c60', '2', '', '0', '', '部门名', '0', 'department_name');
INSERT INTO `api_fields` VALUES ('1637', 'shop_code', '5cc6ed5f19c60', '1', '', '0', '', 'shop_code', '0', 'shop_code');
INSERT INTO `api_fields` VALUES ('1638', 'shop_name', '5cc6ed5f19c60', '1', '', '0', '', 'shop_name', '0', 'shop_name');
INSERT INTO `api_fields` VALUES ('1639', 'brandclass_id', '5cc6ed5f19c60', '1', '', '0', '', '事业部ID', '0', 'brandclass_id');
INSERT INTO `api_fields` VALUES ('1640', 'brandclass', '5cc6ed5f19c60', '1', '', '0', '', '事业部名', '0', 'brandclass');
INSERT INTO `api_fields` VALUES ('1648', 'order_no', '5ccfccc905078', '2', '', '1', '', '商户订单号', '0', 'order_no');
INSERT INTO `api_fields` VALUES ('1649', 'refund_fee', '5ccfccc905078', '1', '', '0', '', '退款金额（单位为分,可以做部分退款）', '0', 'refund_fee');
INSERT INTO `api_fields` VALUES ('1651', 'code', '5ce4f98fa25c3', '1', '', '0', '', 'code', '0', 'code');
INSERT INTO `api_fields` VALUES ('1652', 'order_id', '5ce791a0e5268', '2', '', '1', '', '订单号', '0', 'order_id');
INSERT INTO `api_fields` VALUES ('1653', 'fc_id', '5ce791a0e5268', '1', '', '0', '', '订单服次', '0', 'fc_id');
INSERT INTO `api_fields` VALUES ('1654', 'file_name', '5ce791a0e5268', '1', '', '0', '', '文件名', '0', 'file_name');
INSERT INTO `api_fields` VALUES ('1655', 'img', '5ce791a0e5268', '1', '', '0', '', '文件', '0', 'img');
INSERT INTO `api_fields` VALUES ('1659', 'group_id', '5cf8d76edd1ca', '1', '', '1', '', '组ID', '0', 'group_id');

-- ----------------------------
-- Table structure for api_fields_info
-- ----------------------------
DROP TABLE IF EXISTS `api_fields_info`;
CREATE TABLE `api_fields_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '唯一主键',
  `field` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段名',
  `info` varchar(300) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `field` (`field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='字段说明对应关系';

-- ----------------------------
-- Records of api_fields_info
-- ----------------------------

-- ----------------------------
-- Table structure for api_list
-- ----------------------------
DROP TABLE IF EXISTS `api_list`;
CREATE TABLE `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COLLATE utf8_unicode_ci COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=532 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用于维护接口信息';

-- ----------------------------
-- Records of api_list
-- ----------------------------
INSERT INTO `api_list` VALUES ('7', '登录接口erp', 'Staff/login', '3', '59f2e9fb5f863', '1', '0', '1', '1', '登录接口', '1', null);
INSERT INTO `api_list` VALUES ('9', '退出登录', 'Staff/logOut', '3', '59f424811d52f', '0', '0', '1', '1', '退出登录', '1', null);
INSERT INTO `api_list` VALUES ('10', '修改密码', 'Staff/updatePassword', '3', '59f44a14c3cae', '0', '0', '1', '1', '修改密码', '1', null);
INSERT INTO `api_list` VALUES ('11', '获取员工信息', 'Staff/get_staff_info', '3', '59f933a395abe', '0', '0', '1', '1', '获取员工信息', '0', null);
INSERT INTO `api_list` VALUES ('12', '查询同分组下的小伙伴', 'Staff/group_info', '3', '59f95e5ab44ef', '0', '0', '1', '1', '查询同分组下的小伙伴', '0', null);
INSERT INTO `api_list` VALUES ('13', '公众号查询', 'Staff/wxPublic', '4', '59fad7a50fde8', '0', '0', '1', '1', '查询品牌或店面的公众号信息', '0', null);
INSERT INTO `api_list` VALUES ('14', '消费类型', 'System/consumptionType', '4', '59fd58574204a', '0', '0', '1', '1', '消费类型查询', '0', null);
INSERT INTO `api_list` VALUES ('15', '来源渠道', 'Channel/channelInfo', '4', '59fd5e729e5a8', '0', '0', '1', '1', '来源渠道查询', '0', null);
INSERT INTO `api_list` VALUES ('16', '客户来源', 'System/cusSource', '4', '59fd5ec462c88', '0', '0', '1', '1', '客户来源查询', '0', null);
INSERT INTO `api_list` VALUES ('17', '获取方式', 'System/accessModel', '4', '59fd5f0792e10', '0', '0', '1', '1', '或许方式查询', '0', null);
INSERT INTO `api_list` VALUES ('18', '客户意向', 'System/intentionSet', '4', '59fd5f6c1d340', '0', '0', '1', '1', '客户意向查询', '0', null);
INSERT INTO `api_list` VALUES ('19', '客资地域', 'System/regionSet', '4', '59fd5fa926b98', '0', '0', '1', '1', '客资地域查询', '0', null);
INSERT INTO `api_list` VALUES ('20', '客户地址字典', 'System/clientAddress', '4', '59fd885ed3628', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('21', '客户分区', 'System/areaSet', '4', '5a004e9c3e030', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('22', '接单点', 'System/acceptorAddress', '4', '5a00506445948', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('23', '店面详情查询', 'Staff/shopSet', '4', '5a005e0038270', '0', '0', '1', '1', '店面详情查询', '0', null);
INSERT INTO `api_list` VALUES ('24', '员工信息筛选', 'Staff/staffInfo', '4', '5a01766b4a3dd', '1', '0', '1', '1', '支持各条件员工信息筛选', '0', null);
INSERT INTO `api_list` VALUES ('25', '获取人员', 'Staff/getRenyuan', '3', '5a02666c9935d', '0', '0', '1', '1', 'shop_code相同的员工', '1', null);
INSERT INTO `api_list` VALUES ('28', '微信端登录接口', 'Staff/wx_login', '3', '5a029ee140dba', '0', '0', '1', '1', '微信端登录接口', '0', null);
INSERT INTO `api_list` VALUES ('29', '修改登录状态', 'Staff/update_status', '3', '5a08fbe736447', '1', '0', '1', '1', '修改登录状态', '0', null);
INSERT INTO `api_list` VALUES ('30', '获取员工id，name，number', 'Staff/getFpStaff', '3', '5a0a624728618', '1', '0', '1', '1', '根据  部门名，职位名，取员工id，name，number', '0', null);
INSERT INTO `api_list` VALUES ('32', '获取员工小组信息', 'Staff/getGroup', '3', '5a0a7bc01da07', '1', '0', '1', '1', '获取员工小组信息', '0', null);
INSERT INTO `api_list` VALUES ('33', '应用安装注册', 'app/installApp', '3', '5a0a9ddc8f9d9', '0', '0', '1', '1', '应用安装后，要调此接口进行安装注册，获取接口间通迅密钥。', '0', null);
INSERT INTO `api_list` VALUES ('34', '获取应用列表接口', 'app/getInstallApp', '3', '5a0aacca01925', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('35', '部门查询', 'Staff/department', '3', '5a0aef152b750', '0', '0', '1', '1', '部门查询', '0', null);
INSERT INTO `api_list` VALUES ('36', '岗位查询', 'Staff/position', '3', '5a0b96b65c111', '0', '0', '1', '1', '岗位信息查询，或同店面下岗位', '0', null);
INSERT INTO `api_list` VALUES ('37', '客资标记', 'System/markSet', '4', '5a0c42f43e986', '1', '0', '1', '1', '客资标记', '0', null);
INSERT INTO `api_list` VALUES ('38', '消费能力', 'System/capacity', '3', '5a0c43da3e99a', '1', '0', '1', '1', '消费能力', '0', null);
INSERT INTO `api_list` VALUES ('39', '根据code获取openid', 'staff/getWxUserInfo', '4', '5a0e5f4ced930', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('40', '部门下员工查询', 'Staff/getDepartmentStaffs', '3', '5a0e6f272bb38', '0', '0', '1', '1', '根据部门id，获取该部门下所有的员工', '0', null);
INSERT INTO `api_list` VALUES ('41', '获取已安装的所有APP', 'app/getInstallApp', '7', '5a10168c0809b', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('42', '获取已安装所有应用', 'app/getInstallApp', '8', '5a1016fe35c9c', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('43', '获取扫码登录二维码', 'staff/getLoginQrCode', '4', '5a1027da4e9c1', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('44', '根据openid获取微信会员信息', 'Staff/getWxUserInfo', '6', '5a125fdfc4f6b', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('45', '消费类型', 'System/erpConsumptionType', '5', '5a14dd1d722a6', '0', '0', '1', '1', 'erp查询店面下设定的消费类型', '0', null);
INSERT INTO `api_list` VALUES ('46', '客户分区', 'System/erpArea', '5', '5a14de25a68f0', '0', '0', '1', '1', 'erp查询店面下设定的客户分区', '0', null);
INSERT INTO `api_list` VALUES ('47', '客户来源', 'System/erpSource', '5', '5a14de993bb90', '0', '0', '1', '1', 'erp查询店面下设定的客户来源', '0', null);
INSERT INTO `api_list` VALUES ('48', '客户意向', 'System/erpIntention', '5', '5a14dec689d91', '0', '0', '1', '1', 'erp查询店面下设定的客户意向', '0', null);
INSERT INTO `api_list` VALUES ('49', '客户标记', 'System/erpMark', '5', '5a14dfc86bf72', '0', '0', '1', '1', 'erp查询店面下设定的客户标记', '0', null);
INSERT INTO `api_list` VALUES ('50', '接单点', 'System/erpAcceptorAddress', '5', '5a14e013b447a', '0', '0', '1', '1', 'erp查询店面下设定的接单点', '0', null);
INSERT INTO `api_list` VALUES ('51', '同一工作类型下人员', 'Staff/getWorkType', '5', '5a1510583e3a5', '0', '0', '1', '1', '查询一工作类型下所有人员信息', '0', null);
INSERT INTO `api_list` VALUES ('52', '发送短信', 'system/sendSms', '3', '5a17b86088f1a', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('53', '获取同部门下的无小组人员', 'Staff/getNogroupStaffInfo', '4', '5a18d69aefed1', '1', '0', '1', '1', '获取同部门下的无小组人员', '0', null);
INSERT INTO `api_list` VALUES ('54', '通过ids获取员工信息数组', 'Staff/getStaffInfos', '4', '5a18e3fa516a1', '0', '0', '1', '1', '通过ids获取员工信息数组', '0', null);
INSERT INTO `api_list` VALUES ('55', '修改员工分组', 'Staff/updateGroup', '4', '5a18f958756dc', '1', '0', '1', '1', '修改员工分组', '0', null);
INSERT INTO `api_list` VALUES ('56', 'ssss', 'Staff/updatePassword', '5', '5a1911b6693e3', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('57', '人员查询', 'Staff/erpStaff', '5', '5a19201a33c20', '0', '0', '1', '1', '支持各条件查询员工信息', '0', null);
INSERT INTO `api_list` VALUES ('58', '重置密码', 'Staff/resetPassword', '4', '5a1cb7e65cb5f', '1', '0', '1', '1', '重置密码', '0', null);
INSERT INTO `api_list` VALUES ('60', '检测用户密码是否正确', 'Staff/checkPassword', '3', '5a221a6621364', '1', '0', '1', '1', '此接口只检测用户名和密码是否正确，正确反回用户的基本信息，不做其他用途', '0', null);
INSERT INTO `api_list` VALUES ('61', '检测用户密码是否正确	', 'Staff/checkPassword', '4', '5a221c9548d47', '1', '0', '1', '1', '此接口只检测用户名和密码是否正确，正确反回用户的基本信息，不做其他用途	禁用', '0', null);
INSERT INTO `api_list` VALUES ('62', '更新用户openid用于绑定微信或微信登录', 'Staff/updateOpenid', '3', '5a22380ec9a63', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('63', '更新用户openid用于绑定微信或微信登录', 'Staff/updateOpenid', '4', '5a2239cf24883', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('64', '账号登录接口', 'Staff/login', '6', '5a254b1208166', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('65', '微信扫码登录', 'staff/getLoginQrCode', '6', '5a260b53c2907', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('66', '获取渠道类型', 'channel/channelClass', '4', '5a2757c0a9810', '1', '0', '1', '1', '获取渠道类型', '1', null);
INSERT INTO `api_list` VALUES ('67', '根据OPENID获取员工信息', 'Staff/getStaffInfoByOpenId', '3', '5a2a39421a636', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('68', '通过OPENID获取员工信息', 'Staff/getStaffInfoByOpenId', '4', '5a2a39b803dc2', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('69', '岗位查询', 'Staff/position', '5', '5a2a5f948c9a5', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('70', '获取事业部下某工作类型的人', 'Staff/positionStaff', '4', '5a3717909d178', '1', '0', '1', '1', '获取事业部下某工作类型的人', '0', null);
INSERT INTO `api_list` VALUES ('71', '根据品牌id获取品牌下店面', 'Staff/getBrandShop', '3', '5a37a11b05b75', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('72', '根据品牌id获取品牌下店面', 'Staff/getBrandShop', '6', '5a37a1503264d', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('73', '查询品牌信息', 'Staff/brandClass', '6', '5a38840b15ba9', '0', '0', '1', '1', '根据品牌id，查询品牌信息，或者查询所有品牌信息', '0', null);
INSERT INTO `api_list` VALUES ('74', '店面信息查询', 'Staff/shopSet', '5', '5a39fd8c6c9f7', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('75', '查询品牌信息', 'Staff/brandClass', '4', '5a3bbb5d0988d', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('76', '获取全部品牌店', 'Staff/getBrands', '5', '5a4216fe6b2b5', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('77', '发送模板消息', 'System/sendMsg', '3', '5a439c7e5b8e7', '0', '0', '1', '1', '发送模板消息', '0', null);
INSERT INTO `api_list` VALUES ('78', '品牌查询', 'Staff/brandClass', '3', '5a44c4782c1b6', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('79', 'crm给员工发送模板消息', 'System/crmSendMsg', '3', '5a4b81bc26160', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('80', '验证ERP会员等级', 'Port/popUserGrade', '3', '5a4cc93c0ea20', '1', '1', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('81', '验证ERP会员等级', 'front/Port/popUserGrade', '6', '5a4cca9127088', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('82', '订单用户默认成为会员', 'front/Port/defaultVip', '6', '5a4dceb477528', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('83', '登录扫码', 'staff/getLoginQrCode', '5', '5a54275fb256c', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('84', '店面下所有人员工作类型集合', 'Staff/getShopStaffWorkType', '5', '5a574b13103b7', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('85', '微信扫码支付，生成支付订单', 'order/newOrder', '3', '5a5c6626eef07', '1', '0', '1', '1', '统一下单支付接口', '0', null);
INSERT INTO `api_list` VALUES ('86', '微信扫码支付，查看支付状态', 'order/queryOrderPayStatus', '3', '5a5ca00c81db4', '1', '0', '1', '1', '微信扫码支付，查看支付状态，用户主动扫我们的码。', '0', null);
INSERT INTO `api_list` VALUES ('87', '微信被动扫码支付-生成支付', 'order/micropay', '3', '5a5da9f70d56e', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('88', '微信支付JSAPI签名	', 'order/jsapiSign', '3', '5a5dbddc8fa64', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('89', '发送短信', 'system/sendSms', '5', '5a5df0ae0fcd5', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('94', '微信扫码支付，生成支付订单', 'order/newOrder', '5', '5a5f015c659ee', '1', '0', '1', '1', '统一下单支付接口', '0', null);
INSERT INTO `api_list` VALUES ('95', '微信扫码支付，查看支付状态', 'order/queryOrderPayStatus', '5', '5a5f01acab982', '1', '0', '1', '1', '微信扫码支付，查看支付状态，用户主动扫我们的码。', '0', null);
INSERT INTO `api_list` VALUES ('96', '微信被动扫码支付-生成支付', 'order/micropay', '5', '5a5f0252c9ae7', '1', '0', '1', '1', '生成二维码扫码支付', '0', null);
INSERT INTO `api_list` VALUES ('97', '微信支付JSAPI签名', 'order/jsapiSign', '5', '5a5f02718e1d1', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('98', '获取微信access_token', 'System/getAccessToken', '3', '5a603e4ea5c0c', '0', '0', '1', '1', '根据品牌id,店面code 获取其微信公众号的接口调用凭证access_token', '0', null);
INSERT INTO `api_list` VALUES ('100', '获取微信access_token', 'System/getAccessToken', '6', '5a60436d631a4', '0', '0', '1', '1', '根据品牌id,店面code 获取其微信公众号的接口调用凭证access_token', '0', null);
INSERT INTO `api_list` VALUES ('101', '部门查询 ', 'Staff/department', '5', '5a62dcd5c7e40', '0', '0', '1', '1', '部门查询', '0', null);
INSERT INTO `api_list` VALUES ('112', '批量发送短信', 'System/batchSendSms', '6', '5a7bdbdaa5870', '0', '0', '1', '1', '批量发送短信，每200条请求一次接口发送', '0', null);
INSERT INTO `api_list` VALUES ('113', '获取某员工可查看店面', 'Staff/getPositionShop', '5', '5a8fd8296f3d3', '0', '0', '1', '1', '根据员工的岗位和兼职岗位，获取所有所属店。', '0', null);
INSERT INTO `api_list` VALUES ('121', '查询集团信息 ', 'Staff/groupCompany', '3', '5a6978bb82027', '0', '0', '1', '1', '获取集团信息', '0', null);
INSERT INTO `api_list` VALUES ('122', '获取某个店的所有客资提报店 ', 'Staff/getAddCustomerShop', '3', '5a706286930ce', '1', '0', '1', '1', '获取某个店的所有客资提报店', '0', null);
INSERT INTO `api_list` VALUES ('123', '获取某个店的所有客资提报店 ', 'Staff/getAddCustomerShop', '4', '5a7076a6ccfaa', '1', '0', '1', '1', '获取某个店的所有客资提报店', '0', null);
INSERT INTO `api_list` VALUES ('124', '通过省id获取地域 ', 'Staff/getRegionByProvinceId', '4', '5a704aa96e503', '1', '0', '1', '1', '通过省id获取地域', '0', null);
INSERT INTO `api_list` VALUES ('125', '某一店面下所有员工，包括兼职本店岗位的员工 ', 'Staff/getShopAllStaff', '4', '5a7424f13aa54', '0', '0', '1', '1', '通过省id获取地域', '0', null);
INSERT INTO `api_list` VALUES ('126', '获取公众号二维码', 'System/getExtendQrInfo', '4', '5a73d4f13a9eb', '0', '0', '1', '1', '通过参数获取品牌下公众号的二维码信息，返回ticket可以接显示二维码', '0', null);
INSERT INTO `api_list` VALUES ('127', '发送验证码', 'System/sendVerifySMS', '6', '5a780e2613bb9', '0', '0', '1', '1', '只用于发送验证码，参数只需传入手机号，验证码。', '0', null);
INSERT INTO `api_list` VALUES ('128', '会员支付统一下单接口', 'order/newOrder', '6', '5aa3fcd1050e0', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('129', '获取JSAPI支付数据', 'order/jsapiSign', '6', '5aa401fd2f740', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('130', '短信余额查询接口', 'System/smsBalance', '3', '5aae44296a6bf', '0', '0', '1', '1', '查询短信余额', '0', null);
INSERT INTO `api_list` VALUES ('131', '短信余额查询接口', 'System/smsBalance', '4', '5aae46527269f', '0', '0', '1', '1', '查询短信余额', '0', null);
INSERT INTO `api_list` VALUES ('132', '短信余额查询接口', 'System/smsBalance', '5', '5aae460d2996e', '0', '0', '1', '1', '查询短信余额', '0', null);
INSERT INTO `api_list` VALUES ('133', '短信余额查询接口', 'System/smsBalance', '6', '5aae466ce7ddd', '0', '0', '1', '1', '查询短信余额', '0', null);
INSERT INTO `api_list` VALUES ('137', '某店面下人员信息（包括工作类型的集合）', 'Staff/getShopStaffData', '5', '5aafa4ac48058', '0', '0', '1', '1', '某店面下人员信息（包括工作类型的集合）', '0', null);
INSERT INTO `api_list` VALUES ('138', '短信验证码登录', 'Staff/getLoginCode', '3', '5ab88f1fd2f00', '0', '0', '1', '1', '通过手机号获取验证码登录', '0', null);
INSERT INTO `api_list` VALUES ('139', '手机验证码登录', 'Staff/phoneLogin', '3', '5ab8b32fcc970', '0', '0', '1', '1', '通过手机号获取验证码登录', '0', null);
INSERT INTO `api_list` VALUES ('140', '签名', 'System/signature', '3', '5ab99d8594c78', '0', '0', '1', '1', '订单签名确认', '0', null);
INSERT INTO `api_list` VALUES ('141', '获取订单签名信息', 'System/getsignature', '3', '5ab9a901ee228', '0', '0', '1', '1', '获取订单签名的信息', '0', null);
INSERT INTO `api_list` VALUES ('161', '工作类型查询', 'Staff/workType', '3', '5ae01abbbc263', '0', '0', '1', '1', '工作类型查询', '0', null);
INSERT INTO `api_list` VALUES ('179', '添加、编辑事业部 ', 'Staff/editBrand', '3', '5b3c3dc4ebca8', '0', '0', '1', '1', '添加、编辑事业部信息', '0', null);
INSERT INTO `api_list` VALUES ('180', '删除事业部 ', 'Staff/delBrand', '3', '5b3c5bec9ee30', '0', '0', '1', '1', '删除事业部信息', '0', null);
INSERT INTO `api_list` VALUES ('181', '添加、编辑店面 ', 'Staff/editShop', '3', '5b3c5ccadc2a8', '0', '0', '1', '1', '添加、编辑事业店面', '0', null);
INSERT INTO `api_list` VALUES ('182', '删除店面 ', 'Staff/delShop', '3', '5b3dbce7c7da8', '0', '0', '1', '1', '删除店面', '0', null);
INSERT INTO `api_list` VALUES ('183', '添加、编辑部门 ', 'Staff/editDepartment', '3', '5b3dbdd2964b0', '0', '0', '1', '1', '添加、编辑部门', '0', null);
INSERT INTO `api_list` VALUES ('184', '删除部门 ', 'Staff/delDepartment', '3', '5b3dc428987d8', '0', '0', '1', '1', '删除部门', '0', null);
INSERT INTO `api_list` VALUES ('185', '编辑岗位 ', 'Staff/editPosition', '3', '5b3dc4a1dc1e0', '0', '0', '1', '1', '添加、编辑岗位', '0', null);
INSERT INTO `api_list` VALUES ('186', '删除岗位 ', 'Staff/delPosition', '3', '5b3dc56a73de8', '0', '0', '1', '1', '删除岗位', '0', null);
INSERT INTO `api_list` VALUES ('187', '添加、编辑人员 ', 'Staff/editStaff', '3', '5b3dc732048a8', '0', '0', '1', '1', '添加、编辑人员', '0', null);
INSERT INTO `api_list` VALUES ('188', '删除人员 ', 'Staff/delStaff', '3', '5b3dc87367e80', '0', '0', '1', '1', '删除人员', '0', null);
INSERT INTO `api_list` VALUES ('189', '获取所有未使用的门店的shop_code ', 'Staff/getShopCode', '3', '5b3dc8f4d1218', '0', '0', '1', '1', '获取所有未使用的门店的shop_code', '0', null);
INSERT INTO `api_list` VALUES ('194', '添加岗位 ', 'Staff/addPosition', '3', '5b4717ca97046', '0', '0', '1', '1', '添加岗位', '0', null);
INSERT INTO `api_list` VALUES ('195', '获取短信配置 ', 'Staff/getSmsConfig', '3', '5b484a585d5c0', '0', '0', '1', '1', '获取短信配置', '0', null);
INSERT INTO `api_list` VALUES ('432', '删除签名', 'System/delsignature', '3', '5ac3579d76bb8', '0', '0', '1', '1', '删除签名', '0', null);
INSERT INTO `api_list` VALUES ('439', '搜索员工 ', 'Staff/searchStaff', '3', '5aec138a7bae9', '0', '0', '1', '1', '根据 姓名或者手机号，模糊搜索', '0', null);
INSERT INTO `api_list` VALUES ('440', '根据员工编号发送短信', 'System/smsByStaffNumber', '3', '5af2f899164f4', '0', '0', '1', '1', '根据员工编号发送短信', '0', null);
INSERT INTO `api_list` VALUES ('441', 'erp获取实体店人员', 'Staff/erpStStaff', '5', '5af3c003b4cae', '0', '0', '1', '1', 'erp获取实体店人员', '0', null);
INSERT INTO `api_list` VALUES ('442', '查询客资无效原因', 'System/getUnValidReason', '4', '5af3fe7a0a668', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('443', '查询未成单原因', 'System/getNotOrderReason', '4', '5af40001983f0', '1', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('445', '获取集团或事业部的直属部门', 'Staff/getDepartment', '3', '5aff92c0762a0', '0', '0', '1', '1', '获取集团或事业部下的直属部门', '0', null);
INSERT INTO `api_list` VALUES ('451', '获取某岗位或员工的直属上级岗位对应的人', 'Staff/getTopStaff', '3', '5b20eb32badd8', '0', '0', '1', '1', '获取某岗位或员工的直属上级岗位对应的人', '0', null);
INSERT INTO `api_list` VALUES ('452', '修改极光账号密码 ', 'Staff/changeJgPwd', '3', '5b6575a339c38', '0', '0', '1', '1', '修改极光账号密码', '0', null);
INSERT INTO `api_list` VALUES ('453', '验证token接口', 'Staff/checkToken', '3', '5b3ae7a95f370', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('454', '查询店下所有的人 ', 'Staff/getStaffsByWorkType', '4', '5b75341456d18', '0', '0', '1', '1', '同一店面 ( 包含可操作店 ) 下某工作类型下所有员工 ( 包含但不限于岗位工作类型 ) ', '0', null);
INSERT INTO `api_list` VALUES ('455', '编辑员工表某几个字段 ', 'Staff/staffSpecialEdit', '4', '5b8630d8d21b8', '0', '0', '1', '1', '编辑员工表某几个字段，传参则改', '0', null);
INSERT INTO `api_list` VALUES ('456', '添加、编辑集团信息 ', 'Staff/editCompany', '4', '5b876a32ca648', '0', '0', '1', '1', '添加、编辑集团信息', '0', null);
INSERT INTO `api_list` VALUES ('457', '添加、编辑工作类型等级 ', 'Staff/addWorkLevel', '4', '5b8a64f1c39b0', '0', '0', '1', '1', '添加、编辑工作类型等级', '0', null);
INSERT INTO `api_list` VALUES ('458', '删除工作类型等级 ', 'Staff/delWorkLevel', '4', '5b8a655b5d4f8', '0', '0', '1', '1', '删除工作类型等级', '0', null);
INSERT INTO `api_list` VALUES ('459', '获取员工在某事业部下的客操作店 ', 'Staff/getWorkShop', '4', '5b9cac8aa21c0', '0', '0', '1', '1', '获取员工在某事业部下的客操作店', '0', null);
INSERT INTO `api_list` VALUES ('460', '可操作店包括某店的某个工作类型人员', 'Staff/getStaffsByWorkShopType', '5', '5bc58874c5828', '0', '0', '1', '1', '可操作店包括某店面的，某个工作类型（人员设定中勾选）的所有在职员工 ', '0', null);
INSERT INTO `api_list` VALUES ('461', '极光推送消息(全部人)', 'System/pushToAll', '3', '5bc8702e3e056', '0', '0', '1', '1', '极光推送消息(全部人)', '0', null);
INSERT INTO `api_list` VALUES ('462', '极光推送消息(指定人)', 'System/pushToStaff', '3', '5bc870ff09178', '0', '0', '1', '1', '极光推送消息(全部人)', '0', null);
INSERT INTO `api_list` VALUES ('463', '清空指定人极光id', 'System/pushToAll', '3', '5bc871078bcee', '0', '0', '1', '1', '极光推送消息(全部人)', '0', null);
INSERT INTO `api_list` VALUES ('464', '图片上传', 'System/uploadImg', '3', '5bc94272b051a', '0', '0', '1', '1', '图片上传', '1', null);
INSERT INTO `api_list` VALUES ('465', '图片删除', 'System/delImg', '3', '5bc94294ae9c2', '0', '0', '1', '1', '图片删除', '0', null);
INSERT INTO `api_list` VALUES ('467', 'oa获取集团下的事业部列表', 'Oa/getBrandList', '3', '5bcd6e7692511', '0', '0', '1', '1', 'oa获取集团下的事业部列表', '0', null);
INSERT INTO `api_list` VALUES ('468', 'oa获取事业部下的店面列表', 'Oa/getShopList', '3', '5bcd7a65e1d8c', '0', '0', '1', '1', 'oa获取事业部下的店面列表', '0', null);
INSERT INTO `api_list` VALUES ('469', 'oa获取部门', 'Oa/getDepartmentList', '3', '5bcd7b190d812', '0', '0', '1', '1', 'oa获取部门', '0', null);
INSERT INTO `api_list` VALUES ('470', 'oa获取集团下的获取人员', 'Oa/getStaffList', '3', '5bcd7bf31b0c2', '0', '0', '1', '1', 'oa获取集团下的获取人员', '0', null);
INSERT INTO `api_list` VALUES ('471', 'oa模糊搜索 人名 和 手机号', 'Oa/seacherStaff', '3', '5bcd7c794bcbd', '0', '0', '1', '1', 'oa模糊搜索 人名 和 手机号', '0', null);
INSERT INTO `api_list` VALUES ('474', 'oa复制店面下的部门岗位', 'Staff/copyPosition', '3', '5bd27d0a93120', '0', '0', '1', '1', 'oa复制店面下的部门岗位', '0', null);
INSERT INTO `api_list` VALUES ('475', '导入事业部信息', 'Staff/importBrand', '3', '5bdaed7e5e551', '0', '0', '1', '1', '导入事业部信息', '0', null);
INSERT INTO `api_list` VALUES ('476', '导入店面信息', 'Staff/importShop', '3', '5bdaee20b646d', '0', '0', '1', '1', '导入店面信息', '0', null);
INSERT INTO `api_list` VALUES ('477', '导入部门信息', 'Staff/importDept', '3', '5bdaee2a462e6', '0', '0', '1', '1', '导入部门信息', '0', null);
INSERT INTO `api_list` VALUES ('478', '导入人员信息', 'Staff/importStaff', '3', '5bdaee35ac5ad', '0', '0', '1', '1', '导入人员信息', '0', null);
INSERT INTO `api_list` VALUES ('487', 'erp线下订单支付', 'System/erpPaymentQrCode', '3', '5c9ae4289e598', '0', '0', '1', '1', 'erp线下订单支付', '0', null);
INSERT INTO `api_list` VALUES ('508', '获取openid下的订单 ', 'Order/getOrdersByOpenid', '3', '5caf4eceb94bd', '1', '0', '1', '1', '获取openid下的所有订单', '0', null);
INSERT INTO `api_list` VALUES ('509', '根据标识获取员工制定店面列表', 'Staff/getOpShoplist', '3', '5cbe739c8d8d8', '0', '0', '1', '1', '获取openid下的所有订单', '0', null);
INSERT INTO `api_list` VALUES ('510', '查询小组', 'Staff/getGroupInfo', '3', '5cc6ed5f19c60', '0', '0', '1', '1', '获取小组信息，不含成员', '0', '');
INSERT INTO `api_list` VALUES ('511', '微信退款', 'Order/wxRefund', '3', '5ccfccc905078', '0', '0', '1', '1', '微信退款', '0', null);
INSERT INTO `api_list` VALUES ('512', '获取电子合同单图片路径', 'System/getContractImg', '3', '5ce4f98fa25c3', '0', '0', '1', '1', '获取电子合同单图片路径', '0', null);
INSERT INTO `api_list` VALUES ('513', '先睹为快照片上传', 'System/uploadImgSneakPeek', '3', '5ce791a0e5268', '0', '0', '1', '1', '先睹为快照片上传', '0', null);
INSERT INTO `api_list` VALUES ('514', '根据组id查询小组人员', 'Staff/getGroupStaff', '3', '5cf8d76edd1ca', '0', '0', '1', '1', '', '0', null);
INSERT INTO `api_list` VALUES ('515', '根据手机号发送微信模板消息 ', 'System/sendMsgByMobile', '3', '5d00c53f80f8d', '1', '0', '1', '1', '根据手机号发送微信模板消息', '0', null);
INSERT INTO `api_list` VALUES ('516', '会员绑定微信 ', 'Vip/bindWeixin', '3', '5d02eb39af707', '1', '0', '1', '1', '会员系统绑定手机号时，将微信的openid与手机号进行绑定，以便后期发送模板消息.', '0', null);
INSERT INTO `api_list` VALUES ('518', 'NAS检测文件同步 ', 'Nas/getMvUploadFiles', '3', '5d0b3a67d0f22', '1', '0', '1', '1', 'NAS检测文件同步', '0', null);
INSERT INTO `api_list` VALUES ('519', '获取可删除的文件列表 ', 'Nas/getDelFiles', '3', '5d0b3a978cf2e', '1', '0', '1', '1', '获取可删除的文件列表', '0', null);
INSERT INTO `api_list` VALUES ('520', '出错时的报警消息发送 ', 'Nas/errSendMessage', '3', '5d0b3abf6627c', '1', '0', '1', '1', '出错时的报警消息发送', '0', null);
INSERT INTO `api_list` VALUES ('521', 'NAS心跳通知 ', 'Nas/active', '3', '5d0b3b32efba5', '1', '0', '1', '1', 'NAS心跳通知', '0', null);
INSERT INTO `api_list` VALUES ('525', '绑定微信接口', 'Staff/getBindWeixinCode', '3', '5d10431862ecb', '1', '0', '1', '1', '需要绑定微信时，获取绑定CODE和二维码URL，同时提交CODE后，可以获取绑定结果。', '0', null);
INSERT INTO `api_list` VALUES ('526', '获取服次完成的超期服次    ', 'Nas/getFcoverOrders', '3', '5d393b2045d29', '1', '0', '1', '1', '需要配置文件内增加clean_photo_day 设定超时天数   ', '0', null);
INSERT INTO `api_list` VALUES ('527', '获取员工主岗位及兼职岗位信息', 'Staff/getStaffByShopType', '5', '5d75f7dcedd78', '1', '0', '1', '1', '根据店面类型获取员工主岗位及兼职岗位信息', '1', null);
INSERT INTO `api_list` VALUES ('528', '获取短信模板列表', 'Sms/getTemplate', '5', '5d78e5b101c5c', '1', '0', '1', '1', '获取短信模板列表', '0', null);
INSERT INTO `api_list` VALUES ('529', '发送模板短信', 'Sms/sendTemplateSms', '5', '5d78e60eeb6a2', '1', '0', '1', '1', '发送模板短信', '0', null);
INSERT INTO `api_list` VALUES ('531', '注册极光账号 ', 'Staff/createJg', '3', '5b33489a1ec30', '0', '0', '1', '1', '注册极光账号', '0', null);

-- ----------------------------
-- Table structure for api_login_log
-- ----------------------------
DROP TABLE IF EXISTS `api_login_log`;
CREATE TABLE `api_login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `login_method` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `result` tinyint(1) DEFAULT '1',
  `error_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  `login_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of api_login_log
-- ----------------------------

-- ----------------------------
-- Table structure for api_menu
-- ----------------------------
DROP TABLE IF EXISTS `api_menu`;
CREATE TABLE `api_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '菜单名',
  `fid` int(11) NOT NULL COMMENT '父级菜单ID',
  `url` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '链接',
  `auth` tinyint(2) NOT NULL DEFAULT '0' COMMENT '访客权限',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `hide` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `icon` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '菜单图标',
  `level` tinyint(2) NOT NULL DEFAULT '0' COMMENT '菜单认证等级',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10071 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='目录信息';

-- ----------------------------
-- Records of api_menu
-- ----------------------------
INSERT INTO `api_menu` VALUES ('1', '欢迎页', '0', 'Index/welcome', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('2', '系统配置', '0', '', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('3', '菜单维护', '2', 'Menu/index', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('4', '用户管理', '2', 'User/index', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('5', '权限管理', '2', 'Permission/index', '0', '2', '0', '', '0');
INSERT INTO `api_menu` VALUES ('6', '操作日志', '2', 'Log/index', '0', '3', '0', '', '0');
INSERT INTO `api_menu` VALUES ('7', '应用管理', '0', '', '0', '2', '0', '', '0');
INSERT INTO `api_menu` VALUES ('8', '应用列表', '7', 'App/index', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('9', '接口列表', '7', 'ApiManage/index', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('10', '字段注解', '7', 'FieldsInfoManage/index', '0', '2', '1', '', '0');
INSERT INTO `api_menu` VALUES ('11', '首页', '0', 'Index/index', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('12', '新增菜单', '3', 'Menu/add', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('13', '编辑菜单', '3', 'Menu/edit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('14', '隐藏菜单', '3', 'Menu/close', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('15', '显示菜单', '3', 'Menu/open', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('16', '删除菜单', '3', 'Menu/del', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('17', '新增用户', '4', 'User/add', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('18', '账号封停', '4', 'User/close', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('19', '账号解封', '4', 'User/open', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('20', '账号删除', '4', 'User/del', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('21', '编辑应用', '8', 'App/edit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('22', '新增应用', '8', 'App/add', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('23', '启用应用', '8', 'App/open', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('24', '禁用应用', '8', 'App/close', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('25', '删除应用', '8', 'App/del', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('26', '新增接口', '9', 'ApiManage/add', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('27', '启用接口', '9', 'ApiManage/open', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('28', '禁用接口', '9', 'ApiManage/close', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('29', '编辑接口', '9', 'ApiManage/edit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('30', '删除接口', '9', 'ApiManage/del', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('31', '返回字段编辑', '9', 'FieldsManage/response', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('32', '请求字段编辑', '9', 'FieldsManage/request', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('33', '新增字段', '9', 'FieldsManage/add', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('34', '字段编辑', '9', 'FieldsManage/edit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('35', '批量上传返回字段', '9', 'FieldsManage/upload', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('36', 'Ajax查询Log列表', '6', 'Log/ajaxGetIndex', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('37', '日志删除', '6', 'Log/del', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('38', '日志详情查看', '6', 'Log/showDetail', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('39', '添加权限组', '5', 'Permission/add', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('40', '禁用权限组', '5', 'Permission/close', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('41', '启用权限组', '5', 'Permission/open', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('42', '编辑权限组', '5', 'Permission/edit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('43', '删除权限组', '5', 'Permission/del', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('44', '用户入组', '5', 'Permission/group', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('45', '组用户列表', '5', 'Permission/member', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('46', '踢出成员', '5', 'Permission/delMember', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('47', '权限组权限配置', '5', 'Permission/rule', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('49', '字段删除', '34', 'FieldsManage/del', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('50', '人事资料设定', '0', '', '0', '4', '0', '', '0');
INSERT INTO `api_menu` VALUES ('51', '集团设定', '50', 'Personnel/GroupCompany', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('52', '新增集团名称设定', '51', 'Personnel/GroupCompany', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('53', '事业部设定', '50', 'Personnel/brandClass', '0', '2', '0', '', '0');
INSERT INTO `api_menu` VALUES ('54', '新增品牌名称', '53', 'Personnel/addBrand', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('55', '编辑品牌名称', '53', 'Personnel/editBrand', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('56', '删除品牌', '53', 'Personnel/delBrand', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('57', '店面设定', '50', 'Personnel/shopSet', '0', '3', '0', '', '0');
INSERT INTO `api_menu` VALUES ('58', '编辑店面', '57', 'Personnel/editShop', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('59', '删除店面', '57', 'Personnel/delShop', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('60', '新增店面', '57', 'Personnel/addShop', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('61', '部门设定', '50', 'Personnel/department', '0', '4', '0', '', '0');
INSERT INTO `api_menu` VALUES ('62', '新增部门', '61', 'Personnel/addDepartment', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('64', '编辑部门', '61', 'Personnel/editDepartment', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('65', '分组设定', '50', 'Personnel/staffGroup', '0', '5', '0', '', '0');
INSERT INTO `api_menu` VALUES ('66', '新增分组', '65', 'Personnel/addGroup', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('67', '编辑分组', '65', 'Personnel/editGroup', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('69', '删除分组', '65', 'Personnel/delGroup', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('70', '岗位设定', '50', 'Personnel/position', '0', '6', '0', '', '0');
INSERT INTO `api_menu` VALUES ('71', '新增岗位', '70', 'Personnel/addPosition', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('72', '编辑岗位', '70', 'Personnel/editPosition', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('73', '删除岗位', '70', 'Personnel/delPosition', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('74', '人员设定', '50', 'Personnel/staff', '0', '8', '0', '', '0');
INSERT INTO `api_menu` VALUES ('75', '新增人员', '74', 'Personnel/addStaff', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('76', '编辑人员', '74', 'Personnel/editStaff', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('77', '删除人员', '74', 'Personnel/delStaff', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('78', 'CRM系统设定', '0', '', '0', '5', '0', '', '0');
INSERT INTO `api_menu` VALUES ('79', '渠道类型设置', '78', 'Channel/channelClass', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('80', '新增渠道类型', '79', 'Channel/addChannel', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('81', '编辑渠道类型', '79', 'Channel/editChannel', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('82', '删除渠道类型', '79', 'Channel/delChannel', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('83', '来源渠道设定', '78', 'Channel/channelInfo', '0', '2', '0', '', '0');
INSERT INTO `api_menu` VALUES ('84', '新增来源渠道', '83', 'Channel/addChannelInfo', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('85', '编辑来源渠道', '83', 'Channel/editChannelInfo', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('86', '删除来源渠道', '83', 'Channel/delChannelInfo', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('87', '职级设定', '50', 'Personnel/zhijiSet', '0', '7', '0', '', '0');
INSERT INTO `api_menu` VALUES ('88', '新增职级', '87', 'Personnel/addZhiji', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('89', '编辑职级', '87', 'Personnel/editZhiji', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('90', '删除职级', '87', 'Personnel/delZhiji', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('91', '系统资料设定', '0', '', '0', '3', '0', '', '0');
INSERT INTO `api_menu` VALUES ('92', '消费类型设定', '91', 'System/consumptionType', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('93', '新增消费类型', '92', 'System/addConsumptionType', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('94', '编辑消费类型', '92', 'System/editConsumptionType', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('95', '删除消费类型', '92', 'System/delConsumptionType', '0', '0', '1', '', '1');
INSERT INTO `api_menu` VALUES ('96', '客户分区设定', '91', 'System/areaSet', '0', '2', '0', '', '0');
INSERT INTO `api_menu` VALUES ('97', '新增客户分区', '96', 'System/addArea', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('98', '编辑客户分区', '96', 'System/editArea', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('99', '删除客户分区', '96', 'System/delArea', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('100', '客户来源设定', '91', 'System/cusSource', '0', '3', '0', '', '0');
INSERT INTO `api_menu` VALUES ('101', '新增客户来源', '100', 'System/addCusSource', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('102', '客户意向设定', '91', 'System/intentionSet', '0', '4', '0', '', '0');
INSERT INTO `api_menu` VALUES ('103', '新增客户意向', '102', 'System/addIntention', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('104', '编辑客户意向', '102', 'System/editIntention', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('105', '删除客户意向', '102', 'System/delIntention', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('106', '编辑客户来源', '100', 'System/editCusSource', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('107', '删除客户来源', '100', 'System/delCusSource', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('108', '获取方式设定', '91', 'System/accessModel', '0', '5', '0', '', '0');
INSERT INTO `api_menu` VALUES ('109', '新增获取方式', '108', 'System/addAccess', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('110', '编辑获取方式', '108', 'System/editAccess', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('111', '删除获取方式', '108', 'System/delAccess', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('112', '客户地域设定', '91', 'System/regionSet', '0', '6', '1', '', '0');
INSERT INTO `api_menu` VALUES ('113', '新增客户地域', '112', 'System/addRegion', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('114', '编辑客户地域', '112', 'System/editRegion', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('115', '删除客户地域', '112', 'System/delRegion', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('120', '消费能力设定', '91', 'System/capacity', '0', '8', '0', '', '0');
INSERT INTO `api_menu` VALUES ('121', '新增消费能力', '120', 'System/addCapacity', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('122', '编辑消费能力', '120', 'System/editCapacity', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('123', '删除消费能力', '120', 'System/delCapacity', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('124', '接单点设定', '91', 'System/acceptorAddress', '0', '9', '0', '', '0');
INSERT INTO `api_menu` VALUES ('125', '新增接单点', '124', 'System/addAcceptorAddress', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('126', '编辑接单点', '124', 'System/editAcceptorAddress', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('127', '删除接单点', '124', 'System/delAcceptorAddress', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('128', '系统全局设定', '0', 'System/globalSet', '0', '3', '0', '', '0');
INSERT INTO `api_menu` VALUES ('129', '所属查询', '62', 'Personnel/searchGrade', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('130', '查询短信配置信息', '128', 'System/searchContent', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('131', '模板设定', '91', 'System/template', '0', '9', '0', '', '0');
INSERT INTO `api_menu` VALUES ('132', '新增微信模板', '131', 'System/addTemplate', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('133', '编辑微信模板', '131', 'System/editTemplate', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('134', '删除微信模板', '131', 'System/delTemplate', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('135', '查询某一品牌下的店面', '74', 'Personnel/searchShop', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('136', '查询店面下的部门', '74', 'Personnel/searchDepartment', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('137', '删除部门', '61', 'Personnel/delDepartment', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('138', '查询部门下岗位', '75', 'Personnel/searchPosition', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('139', 'test', '12', 'sdfsdf', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('140', '联动查询品牌下的店面', '61', 'Personnel/brandShop', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('141', '获取品牌下营销店', '60', 'Personnel/getBrandMarketing', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('142', 'getOpenid', '0', 'System/getOpenid', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('143', '员工信息联动', '75', 'Personnel/link_search', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('144', '根据多个岗位id获取岗位名称', '76', 'Personnel/getPositionName', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('145', '复制岗位页面', '70', 'personnel/copyPosition', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('146', '复制岗位', '70', 'personnel/doCopy', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('147', '批量设置兼职岗位', '61', 'personnel/batchSet', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('148', '执行批量设置兼职岗位', '61', 'personnel/doBatch', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('152', '店下所有岗位', '61', 'personnel/search_positon', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('153', '无效原因设定', '78', 'Reason/unValidReason', '0', '2', '0', '', '0');
INSERT INTO `api_menu` VALUES ('154', '添加无效原因', '153', 'Reason/addUnValidReason', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('155', '修改无效原因', '153', 'Reason/editUnValidReason', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('156', '删除无效原因', '153', 'Reason/delUnValidReason', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('168', '添加子级分区', '96', 'System/addChildArea', '0', '4', '1', '', '0');
INSERT INTO `api_menu` VALUES ('174', '工作类型等级', '50', 'Personnel/workTypeLevel', '0', '8', '0', '', '0');
INSERT INTO `api_menu` VALUES ('175', '新增工作类型等级', '162', 'Personnel/addWorkLevel', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('176', '编辑工作类型等级', '162', 'Personnel/editWorkLevel', '0', '2', '1', '', '0');
INSERT INTO `api_menu` VALUES ('177', '获取工作类型等级', '75', 'Personnel/get_work_type_level', '0', '4', '1', '', '0');
INSERT INTO `api_menu` VALUES ('181', '人员离职登记', '50', 'Register/leaveOffice', '0', '10', '0', '', '0');
INSERT INTO `api_menu` VALUES ('184', '岗位异动', '50', 'Register/positionChange', '0', '11', '0', '', '0');
INSERT INTO `api_menu` VALUES ('185', '岗位异动登记', '166', 'Register/addChange', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('186', '获取员工详情', '167', 'Register/get_staff', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('187', '招聘申请', '50', 'Register/recruitmentApply', '0', '12', '1', '', '0');
INSERT INTO `api_menu` VALUES ('188', '新增招聘申请', '169', 'Register/addRecruitment', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('189', '编辑招聘申请', '169', 'Register/editRecruitment', '0', '2', '1', '', '0');
INSERT INTO `api_menu` VALUES ('190', '删除招聘申请', '169', 'Register/delRecruitment', '0', '3', '1', '', '0');
INSERT INTO `api_menu` VALUES ('191', '根据岗位id获取对应工作类型和等级', '167', 'Register/get_position_info', '0', '2', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1000', '访问控制', '2', 'System/acl', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('1001', '添加白名单', '1000', 'System/acladd', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1002', '删除白名单', '1000', 'System/acldel', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1003', '密钥管理', '1000', 'System/acltoken', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1004', '密钥添加', '1000', 'System/acltokenadd', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1005', '密钥删除', '1000', 'System/acltokendel', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1006', '白名单开关', '1000', 'System/aclstatus', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1007', '短信日志', '2', 'SmsLog/index', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('1008', '列表', '1007', 'SmsLog/ajaxGetIndex', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1009', '删除', '1007', 'SmsLog/del', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1010', '查看系统状态', '0', 'System/serverValid', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1011', '人员导出', '74', 'personnel/exportStaff', '0', '12', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1012', '员工密码设定', '2', 'System/passwordSet', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('1013', '新增密码设定', '1012', 'System/addPasswordSet', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1014', '编辑密码设定', '1012', 'System/editPasswordSet', '0', '3', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1015', '删除密码设定', '1012', 'System/delPasswordSet', '0', '3', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1016', 'ajax请求部门下小组', '65', 'personnel/searchGroup', '0', '4', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1017', 'ajax请求下级省市区', '65', 'personnel/getNextAddress', '0', '4', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1030', '地址设定', '91', 'personnel/address', '0', '1', '0', '', '0');
INSERT INTO `api_menu` VALUES ('1031', '添加子级地址', '1030', 'personnel/addChildAddress', '0', '1', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1032', '删除地址', '1030', 'personnel/delAddress', '0', '2', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1033', '编辑地址', '1030', 'personnel/editAddress', '0', '3', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1034', '新增地址', '1030', 'personnel/addAddress', '0', '4', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1035', 'ajax请求地址', '1030', 'personnel/address_search', '0', '6', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1036', '获取绑定的地址', '1030', 'Personnel/getAddressName', '0', '7', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1037', '员工导入', '50', 'Import/importStaff', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1038', '文件上传', '50', 'Import/uploadExcel', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1039', '删除导入记录', '50', 'Import/deleteImport', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1040', '执行导入', '50', 'Import/doImport', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1041', '导入进度', '50', 'Import/getImportPercent', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1042', '导入详情', '50', 'Import/detailImport', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1043', '修改明细', '50', 'Import/updateImportDetail', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1044', '离职人员删除', '10046', 'Personnel/delLeaveStaff', '0', '99', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1045', '短信签名管理', '91', 'Sms/Sign', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('1046', '短信模板管理', '91', 'Sms/Template', '0', '0', '0', '', '0');
INSERT INTO `api_menu` VALUES ('1047', '短信签名新增', '1045', 'Sms/Signadd', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1048', '短信签名编辑', '1045', 'Sms/Signedit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1049', '短信签名删除', '1045', 'Sms/Signdel', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1050', '短信模板删除', '1046', 'Sms/Templatedel', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1051', '短信模板编辑', '1046', 'Sms/Templateedit', '0', '0', '1', '', '0');
INSERT INTO `api_menu` VALUES ('1052', '短信模板新增', '1046', 'Sms/Templateadd', '0', '0', '1', '', '0');
-- ----------------------------
-- Table structure for api_user
-- ----------------------------
DROP TABLE IF EXISTS `api_user`;
CREATE TABLE `api_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户昵称',
  `password` char(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户密码',
  `regTime` int(10) NOT NULL DEFAULT '0' COMMENT '注册时间',
  `regIp` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '注册IP',
  `updateTime` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '账号状态 0封号 1正常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='管理员认证信息';

-- ----------------------------
-- Records of api_user
-- ----------------------------
INSERT INTO `api_user` VALUES ('1', 'root', 'root', '912601e4ad1b308c9ae41877cf6ca754', '1492004246', '3682992231', '1492236545', '1');

-- ----------------------------
-- Table structure for api_user_action
-- ----------------------------
DROP TABLE IF EXISTS `api_user_action`;
CREATE TABLE `api_user_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `actionName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '行为名称',
  `uid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '操作用户ID',
  `nickname` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户昵称',
  `addTime` int(11) NOT NULL DEFAULT '0' COMMENT '操作时间',
  `data` text COLLATE utf8_unicode_ci COMMENT '用户提交的数据',
  `url` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '操作URL',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=129 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户操作日志';

-- ----------------------------
-- Records of api_user_action
-- ----------------------------

-- ----------------------------
-- Table structure for api_user_data
-- ----------------------------
DROP TABLE IF EXISTS `api_user_data`;
CREATE TABLE `api_user_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `loginTimes` int(11) NOT NULL COMMENT '账号登录次数',
  `lastLoginIp` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '最后登录IP',
  `lastLoginTime` int(11) NOT NULL COMMENT '最后登录时间',
  `uid` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '用户ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='管理员数据表';

-- ----------------------------
-- Records of api_user_data
-- ----------------------------

-- ----------------------------
-- Table structure for app_version
-- ----------------------------
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- ----------------------------
-- Records of app_version
-- ----------------------------
INSERT INTO `app_version` VALUES ('1', '1.1.91', null, null);

-- ----------------------------
-- Table structure for c_sysconfig
-- ----------------------------
DROP TABLE IF EXISTS `c_sysconfig`;
CREATE TABLE `c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容，存JSON数据',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='相关的配置参数。';

-- ----------------------------
-- Records of c_sysconfig
-- ----------------------------
INSERT INTO `c_sysconfig` VALUES ('sign_sms', '{\"is_sign\":null}');
INSERT INTO `c_sysconfig` VALUES ('yx_sms', '{\"yx_user\":\"\",\"yx_psw\":\"\",\"yx_domain\":\"\",\"yx_sign\":\"\",\"yx_drive\":\"\"}');

-- ----------------------------
-- Table structure for o_pay_order
-- ----------------------------
DROP TABLE IF EXISTS `o_pay_order`;
CREATE TABLE `o_pay_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '公众帐号ID，非微信支付留空',
  `mch_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信商户号',
  `device_info` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设备号（门店CODE）',
  `nonce_str` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '随机字符串',
  `sign` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签名',
  `body` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商品描述',
  `detail` text COLLATE utf8_unicode_ci COMMENT '详情',
  `attach` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '符加参数',
  `out_trade_no` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商户订单号',
  `auth_code` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '扫码支付时，扫到的授权码',
  `fee_type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '币种',
  `total_fee` int(11) DEFAULT NULL COMMENT '总金额',
  `discount_fee` int(11) DEFAULT NULL COMMENT '总共优惠金额',
  `spbill_create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '请求端IP',
  `time_start` datetime DEFAULT NULL COMMENT '交易起始时间',
  `time_expire` datetime DEFAULT NULL COMMENT '交易过期时间',
  `goods_tag` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记（微信可用于优惠标记）',
  `notify_url` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回调地址',
  `trade_type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '交易类型',
  `product_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商品编号',
  `limit_pay` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '指定支付类型',
  `openid` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `other` text COLLATE utf8_unicode_ci COMMENT '其他信息',
  `prepay_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付网关返回支付会话标识',
  `code_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '如果是扫码支付，则返回扫码字符串',
  `gateway_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '网关返回状态',
  `pay_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付状态，INIT 初始，PAYED已支付。ERROR 错误',
  `transaction_id` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第三方支付的交易单号',
  `pay_fee` int(11) DEFAULT NULL COMMENT '支付金额',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店代码',
  `shop_id` int(11) DEFAULT NULL COMMENT '店ID',
  `brand_id` int(11) DEFAULT NULL COMMENT '品牌ID',
  PRIMARY KEY (`id`),
  KEY `out_trade_no` (`out_trade_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of o_pay_order
-- ----------------------------

-- ----------------------------
-- Table structure for o_pay_order_notify
-- ----------------------------
DROP TABLE IF EXISTS `o_pay_order_notify`;
CREATE TABLE `o_pay_order_notify` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8_unicode_ci COMMENT '消息主体',
  `create_time` datetime DEFAULT NULL COMMENT '接收到的时间',
  `request_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '请求者的IP地址',
  `check_result` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '检测结果验证结果，记录备查',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of o_pay_order_notify
-- ----------------------------

-- ----------------------------
-- Table structure for o_pay_refund
-- ----------------------------
DROP TABLE IF EXISTS `o_pay_refund`;
CREATE TABLE `o_pay_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `mch_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `nonce_str` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `out_refund_no` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `refund_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `out_trade_no` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total_fee` int(11) DEFAULT NULL,
  `refund_fee` int(11) DEFAULT NULL,
  `sign` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_id` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of o_pay_refund
-- ----------------------------

-- ----------------------------
-- Table structure for sms_sign
-- ----------------------------
DROP TABLE IF EXISTS `sms_sign`;
CREATE TABLE `sms_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sign` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `add_time` datetime DEFAULT NULL,
  `verify_time` datetime DEFAULT NULL,
  `state` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sms_sign
-- ----------------------------

-- ----------------------------
-- Table structure for sms_template
-- ----------------------------
DROP TABLE IF EXISTS `sms_template`;
CREATE TABLE `sms_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `params` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `add_time` datetime DEFAULT NULL,
  `verify_time` datetime DEFAULT NULL,
  `state` tinyint(4) DEFAULT '0',
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of sms_template
-- ----------------------------

-- ----------------------------
-- Table structure for staff_profile
-- ----------------------------
DROP TABLE IF EXISTS `staff_profile`;
CREATE TABLE `staff_profile` (
  `id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `birthday` datetime DEFAULT NULL COMMENT '员工生日',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='保存员工非必要信息';

-- ----------------------------
-- Records of staff_profile
-- ----------------------------

-- ----------------------------
-- Table structure for s_acceptoraddress
-- ----------------------------
DROP TABLE IF EXISTS `s_acceptoraddress`;
CREATE TABLE `s_acceptoraddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acceptoraddress_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_ids` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='接单点';

-- ----------------------------
-- Records of s_acceptoraddress
-- ----------------------------

-- ----------------------------
-- Table structure for s_accessmodel
-- ----------------------------
DROP TABLE IF EXISTS `s_accessmodel`;
CREATE TABLE `s_accessmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accessmodel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='获取方式';

-- ----------------------------
-- Records of s_accessmodel
-- ----------------------------

-- ----------------------------
-- Table structure for s_acl_list
-- ----------------------------
DROP TABLE IF EXISTS `s_acl_list`;
CREATE TABLE `s_acl_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `memo` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_type` tinyint(1) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_user_id` int(11) DEFAULT NULL,
  `create_user_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_acl_list
-- ----------------------------

-- ----------------------------
-- Table structure for s_acl_token
-- ----------------------------
DROP TABLE IF EXISTS `s_acl_token`;
CREATE TABLE `s_acl_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `memo` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_user_id` int(11) DEFAULT NULL,
  `create_user_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_acl_token
-- ----------------------------

-- ----------------------------
-- Table structure for s_acl_token_logs
-- ----------------------------
DROP TABLE IF EXISTS `s_acl_token_logs`;
CREATE TABLE `s_acl_token_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `result` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_acl_token_logs
-- ----------------------------

-- ----------------------------
-- Table structure for s_address
-- ----------------------------
DROP TABLE IF EXISTS `s_address`;
CREATE TABLE `s_address` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(120) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '2',
  `order_sort` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4044 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='地址字典表';

-- ----------------------------
-- Records of s_address
-- ----------------------------
INSERT INTO `s_address` VALUES ('1', '0', '中国', '0', '', null);
INSERT INTO `s_address` VALUES ('2', '1', '北京', '1', '', null);
INSERT INTO `s_address` VALUES ('3', '1', '天津', '1', '', null);
INSERT INTO `s_address` VALUES ('4', '1', '河北省', '1', '', null);
INSERT INTO `s_address` VALUES ('5', '1', '山西省', '1', '', null);
INSERT INTO `s_address` VALUES ('6', '1', '内蒙古自治区', '1', '', null);
INSERT INTO `s_address` VALUES ('7', '1', '辽宁省', '1', '', null);
INSERT INTO `s_address` VALUES ('8', '1', '吉林省', '1', '', null);
INSERT INTO `s_address` VALUES ('9', '1', '黑龙江省', '1', '', null);
INSERT INTO `s_address` VALUES ('10', '1', '上海', '1', '', null);
INSERT INTO `s_address` VALUES ('11', '1', '江苏省', '1', '', null);
INSERT INTO `s_address` VALUES ('12', '1', '浙江省', '1', '', null);
INSERT INTO `s_address` VALUES ('13', '1', '安徽省', '1', '', null);
INSERT INTO `s_address` VALUES ('14', '1', '福建省', '1', '', null);
INSERT INTO `s_address` VALUES ('15', '1', '江西省', '1', '', null);
INSERT INTO `s_address` VALUES ('16', '1', '山东省', '1', '', null);
INSERT INTO `s_address` VALUES ('17', '1', '河南省', '1', '', null);
INSERT INTO `s_address` VALUES ('18', '1', '湖北省', '1', '', null);
INSERT INTO `s_address` VALUES ('19', '1', '湖南省', '1', '', null);
INSERT INTO `s_address` VALUES ('20', '1', '广东省', '1', '', null);
INSERT INTO `s_address` VALUES ('21', '1', '广西壮族自治区', '1', '', null);
INSERT INTO `s_address` VALUES ('22', '1', '海南省', '1', '', null);
INSERT INTO `s_address` VALUES ('23', '1', '重庆', '1', '', null);
INSERT INTO `s_address` VALUES ('24', '1', '四川省', '1', '', null);
INSERT INTO `s_address` VALUES ('25', '1', '贵州省', '1', '', null);
INSERT INTO `s_address` VALUES ('26', '1', '云南省', '1', '', null);
INSERT INTO `s_address` VALUES ('27', '1', '西藏自治区', '1', '', null);
INSERT INTO `s_address` VALUES ('28', '1', '陕西省', '1', '', null);
INSERT INTO `s_address` VALUES ('29', '1', '甘肃省', '1', '', null);
INSERT INTO `s_address` VALUES ('30', '1', '青海省', '1', '', null);
INSERT INTO `s_address` VALUES ('31', '1', '宁夏回族自治区', '1', '', null);
INSERT INTO `s_address` VALUES ('32', '1', '新疆维吾尔自治区', '1', '', null);
INSERT INTO `s_address` VALUES ('33', '1', '台湾', '1', '', null);
INSERT INTO `s_address` VALUES ('34', '1', '香港特别行政区', '1', '', null);
INSERT INTO `s_address` VALUES ('35', '1', '澳门特别行政区', '1', '', null);
INSERT INTO `s_address` VALUES ('36', '1', '海外', '1', '', null);
INSERT INTO `s_address` VALUES ('37', '2', '北京市', '2', '', null);
INSERT INTO `s_address` VALUES ('38', '3', '天津市', '2', '', null);
INSERT INTO `s_address` VALUES ('39', '4', '石家庄市', '2', '', null);
INSERT INTO `s_address` VALUES ('40', '4', '唐山市', '2', '', null);
INSERT INTO `s_address` VALUES ('41', '4', '秦皇岛市', '2', '', null);
INSERT INTO `s_address` VALUES ('42', '4', '邯郸市', '2', '', null);
INSERT INTO `s_address` VALUES ('43', '4', '邢台市', '2', '', null);
INSERT INTO `s_address` VALUES ('44', '4', '保定市', '2', '', null);
INSERT INTO `s_address` VALUES ('45', '4', '张家口市', '2', '', null);
INSERT INTO `s_address` VALUES ('46', '4', '承德市', '2', '', null);
INSERT INTO `s_address` VALUES ('47', '4', '沧州市', '2', '', null);
INSERT INTO `s_address` VALUES ('48', '4', '廊坊市', '2', '', null);
INSERT INTO `s_address` VALUES ('49', '4', '衡水市', '2', '', null);
INSERT INTO `s_address` VALUES ('50', '5', '太原市', '2', '', null);
INSERT INTO `s_address` VALUES ('51', '5', '大同市', '2', '', null);
INSERT INTO `s_address` VALUES ('52', '5', '阳泉市', '2', '', null);
INSERT INTO `s_address` VALUES ('53', '5', '长治市', '2', '', null);
INSERT INTO `s_address` VALUES ('54', '5', '晋城市', '2', '', null);
INSERT INTO `s_address` VALUES ('55', '5', '朔州市', '2', '', null);
INSERT INTO `s_address` VALUES ('56', '5', '晋中市', '2', '', null);
INSERT INTO `s_address` VALUES ('57', '5', '运城市', '2', '', null);
INSERT INTO `s_address` VALUES ('58', '5', '忻州市', '2', '', null);
INSERT INTO `s_address` VALUES ('59', '5', '临汾市', '2', '', null);
INSERT INTO `s_address` VALUES ('60', '5', '吕梁市', '2', '', null);
INSERT INTO `s_address` VALUES ('61', '6', '呼和浩特市', '2', '', null);
INSERT INTO `s_address` VALUES ('62', '6', '包头市', '2', '', null);
INSERT INTO `s_address` VALUES ('63', '6', '乌海市', '2', '', null);
INSERT INTO `s_address` VALUES ('64', '6', '赤峰市', '2', '', null);
INSERT INTO `s_address` VALUES ('65', '6', '通辽市', '2', '', null);
INSERT INTO `s_address` VALUES ('66', '6', '鄂尔多斯市', '2', '', null);
INSERT INTO `s_address` VALUES ('67', '6', '呼伦贝尔市', '2', '', null);
INSERT INTO `s_address` VALUES ('68', '6', '巴彦淖尔市', '2', '', null);
INSERT INTO `s_address` VALUES ('69', '6', '乌兰察布市', '2', '', null);
INSERT INTO `s_address` VALUES ('70', '6', '兴安盟', '2', '', null);
INSERT INTO `s_address` VALUES ('71', '6', '锡林郭勒盟', '2', '', null);
INSERT INTO `s_address` VALUES ('72', '6', '阿拉善盟', '2', '', null);
INSERT INTO `s_address` VALUES ('73', '7', '沈阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('74', '7', '大连市', '2', '', null);
INSERT INTO `s_address` VALUES ('75', '7', '鞍山市', '2', '', null);
INSERT INTO `s_address` VALUES ('76', '7', '抚顺市', '2', '', null);
INSERT INTO `s_address` VALUES ('77', '7', '本溪市', '2', '', null);
INSERT INTO `s_address` VALUES ('78', '7', '丹东市', '2', '', null);
INSERT INTO `s_address` VALUES ('79', '7', '锦州市', '2', '', null);
INSERT INTO `s_address` VALUES ('80', '7', '营口市', '2', '', null);
INSERT INTO `s_address` VALUES ('81', '7', '阜新市', '2', '', null);
INSERT INTO `s_address` VALUES ('82', '7', '辽阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('83', '7', '盘锦市', '2', '', null);
INSERT INTO `s_address` VALUES ('84', '7', '铁岭市', '2', '', null);
INSERT INTO `s_address` VALUES ('85', '7', '朝阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('86', '7', '葫芦岛市', '2', '', null);
INSERT INTO `s_address` VALUES ('87', '8', '长春市', '2', '', null);
INSERT INTO `s_address` VALUES ('88', '8', '吉林市', '2', '', null);
INSERT INTO `s_address` VALUES ('89', '8', '四平市', '2', '', null);
INSERT INTO `s_address` VALUES ('90', '8', '辽源市', '2', '', null);
INSERT INTO `s_address` VALUES ('91', '8', '通化市', '2', '', null);
INSERT INTO `s_address` VALUES ('92', '8', '白山市', '2', '', null);
INSERT INTO `s_address` VALUES ('93', '8', '松原市', '2', '', null);
INSERT INTO `s_address` VALUES ('94', '8', '白城市', '2', '', null);
INSERT INTO `s_address` VALUES ('95', '8', '延边朝鲜族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('96', '9', '哈尔滨市', '2', '', null);
INSERT INTO `s_address` VALUES ('97', '9', '齐齐哈尔市', '2', '', null);
INSERT INTO `s_address` VALUES ('98', '9', '鸡西市', '2', '', null);
INSERT INTO `s_address` VALUES ('99', '9', '鹤岗市', '2', '', null);
INSERT INTO `s_address` VALUES ('100', '9', '双鸭山市', '2', '', null);
INSERT INTO `s_address` VALUES ('101', '9', '大庆市', '2', '', null);
INSERT INTO `s_address` VALUES ('102', '9', '伊春市', '2', '', null);
INSERT INTO `s_address` VALUES ('103', '9', '佳木斯市', '2', '', null);
INSERT INTO `s_address` VALUES ('104', '9', '七台河市', '2', '', null);
INSERT INTO `s_address` VALUES ('105', '9', '牡丹江市', '2', '', null);
INSERT INTO `s_address` VALUES ('106', '9', '黑河市', '2', '', null);
INSERT INTO `s_address` VALUES ('107', '9', '绥化市', '2', '', null);
INSERT INTO `s_address` VALUES ('108', '9', '大兴安岭地区', '2', '', null);
INSERT INTO `s_address` VALUES ('109', '10', '上海市', '2', '', null);
INSERT INTO `s_address` VALUES ('110', '11', '南京市', '2', '', null);
INSERT INTO `s_address` VALUES ('111', '11', '无锡市', '2', '', null);
INSERT INTO `s_address` VALUES ('112', '11', '徐州市', '2', '', null);
INSERT INTO `s_address` VALUES ('113', '11', '常州市', '2', '', null);
INSERT INTO `s_address` VALUES ('114', '11', '苏州市', '2', '', null);
INSERT INTO `s_address` VALUES ('115', '11', '南通市', '2', '', null);
INSERT INTO `s_address` VALUES ('116', '11', '连云港市', '2', '', null);
INSERT INTO `s_address` VALUES ('117', '11', '淮安市', '2', '', null);
INSERT INTO `s_address` VALUES ('118', '11', '盐城市', '2', '', null);
INSERT INTO `s_address` VALUES ('119', '11', '扬州市', '2', '', null);
INSERT INTO `s_address` VALUES ('120', '11', '镇江市', '2', '', null);
INSERT INTO `s_address` VALUES ('121', '11', '泰州市', '2', '', null);
INSERT INTO `s_address` VALUES ('122', '11', '宿迁市', '2', '', null);
INSERT INTO `s_address` VALUES ('123', '12', '杭州市', '2', '', null);
INSERT INTO `s_address` VALUES ('124', '12', '宁波市', '2', '', null);
INSERT INTO `s_address` VALUES ('125', '12', '温州市', '2', '', null);
INSERT INTO `s_address` VALUES ('126', '12', '嘉兴市', '2', '', null);
INSERT INTO `s_address` VALUES ('127', '12', '湖州市', '2', '', null);
INSERT INTO `s_address` VALUES ('128', '12', '绍兴市', '2', '', null);
INSERT INTO `s_address` VALUES ('129', '12', '金华市', '2', '', null);
INSERT INTO `s_address` VALUES ('130', '12', '衢州市', '2', '', null);
INSERT INTO `s_address` VALUES ('131', '12', '舟山市', '2', '', null);
INSERT INTO `s_address` VALUES ('132', '12', '台州市', '2', '', null);
INSERT INTO `s_address` VALUES ('133', '12', '丽水市', '2', '', null);
INSERT INTO `s_address` VALUES ('134', '13', '合肥市', '2', '', null);
INSERT INTO `s_address` VALUES ('135', '13', '芜湖市', '2', '', null);
INSERT INTO `s_address` VALUES ('136', '13', '蚌埠市', '2', '', null);
INSERT INTO `s_address` VALUES ('137', '13', '淮南市', '2', '', null);
INSERT INTO `s_address` VALUES ('138', '13', '马鞍山市', '2', '', null);
INSERT INTO `s_address` VALUES ('139', '13', '淮北市', '2', '', null);
INSERT INTO `s_address` VALUES ('140', '13', '铜陵市', '2', '', null);
INSERT INTO `s_address` VALUES ('141', '13', '安庆市', '2', '', null);
INSERT INTO `s_address` VALUES ('142', '13', '黄山市', '2', '', null);
INSERT INTO `s_address` VALUES ('143', '13', '滁州市', '2', '', null);
INSERT INTO `s_address` VALUES ('144', '13', '阜阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('145', '13', '宿州市', '2', '', null);
INSERT INTO `s_address` VALUES ('146', '13', '六安市', '2', '', null);
INSERT INTO `s_address` VALUES ('147', '13', '亳州市', '2', '', null);
INSERT INTO `s_address` VALUES ('148', '13', '池州市', '2', '', null);
INSERT INTO `s_address` VALUES ('149', '13', '宣城市', '2', '', null);
INSERT INTO `s_address` VALUES ('150', '14', '福州市', '2', '', null);
INSERT INTO `s_address` VALUES ('151', '14', '厦门市', '2', '', null);
INSERT INTO `s_address` VALUES ('152', '14', '莆田市', '2', '', null);
INSERT INTO `s_address` VALUES ('153', '14', '三明市', '2', '', null);
INSERT INTO `s_address` VALUES ('154', '14', '泉州市', '2', '', null);
INSERT INTO `s_address` VALUES ('155', '14', '漳州市', '2', '', null);
INSERT INTO `s_address` VALUES ('156', '14', '南平市', '2', '', null);
INSERT INTO `s_address` VALUES ('157', '14', '龙岩市', '2', '', null);
INSERT INTO `s_address` VALUES ('158', '14', '宁德市', '2', '', null);
INSERT INTO `s_address` VALUES ('159', '15', '南昌市', '2', '', null);
INSERT INTO `s_address` VALUES ('160', '15', '景德镇市', '2', '', null);
INSERT INTO `s_address` VALUES ('161', '15', '萍乡市', '2', '', null);
INSERT INTO `s_address` VALUES ('162', '15', '九江市', '2', '', null);
INSERT INTO `s_address` VALUES ('163', '15', '新余市', '2', '', null);
INSERT INTO `s_address` VALUES ('164', '15', '鹰潭市', '2', '', null);
INSERT INTO `s_address` VALUES ('165', '15', '赣州市', '2', '', null);
INSERT INTO `s_address` VALUES ('166', '15', '吉安市', '2', '', null);
INSERT INTO `s_address` VALUES ('167', '15', '宜春市', '2', '', null);
INSERT INTO `s_address` VALUES ('168', '15', '抚州市', '2', '', null);
INSERT INTO `s_address` VALUES ('169', '15', '上饶市', '2', '', null);
INSERT INTO `s_address` VALUES ('170', '16', '济南市', '2', '', null);
INSERT INTO `s_address` VALUES ('171', '16', '青岛市', '2', '', null);
INSERT INTO `s_address` VALUES ('172', '16', '淄博市', '2', '', null);
INSERT INTO `s_address` VALUES ('173', '16', '枣庄市', '2', '', null);
INSERT INTO `s_address` VALUES ('174', '16', '东营市', '2', '', null);
INSERT INTO `s_address` VALUES ('175', '16', '烟台市', '2', '', null);
INSERT INTO `s_address` VALUES ('176', '16', '潍坊市', '2', '', null);
INSERT INTO `s_address` VALUES ('177', '16', '济宁市', '2', '', null);
INSERT INTO `s_address` VALUES ('178', '16', '泰安市', '2', '', null);
INSERT INTO `s_address` VALUES ('179', '16', '威海市', '2', '', null);
INSERT INTO `s_address` VALUES ('180', '16', '日照市', '2', '', null);
INSERT INTO `s_address` VALUES ('181', '16', '莱芜市', '2', '', null);
INSERT INTO `s_address` VALUES ('182', '16', '临沂市', '2', '', null);
INSERT INTO `s_address` VALUES ('183', '16', '德州市', '2', '', null);
INSERT INTO `s_address` VALUES ('184', '16', '聊城市', '2', '', null);
INSERT INTO `s_address` VALUES ('185', '16', '滨州市', '2', '', null);
INSERT INTO `s_address` VALUES ('186', '16', '菏泽市', '2', '', null);
INSERT INTO `s_address` VALUES ('187', '17', '郑州市', '2', '', null);
INSERT INTO `s_address` VALUES ('188', '17', '开封市', '2', '', null);
INSERT INTO `s_address` VALUES ('189', '17', '洛阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('190', '17', '平顶山市', '2', '', null);
INSERT INTO `s_address` VALUES ('191', '17', '安阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('192', '17', '鹤壁市', '2', '', null);
INSERT INTO `s_address` VALUES ('193', '17', '新乡市', '2', '', null);
INSERT INTO `s_address` VALUES ('194', '17', '焦作市', '2', '', null);
INSERT INTO `s_address` VALUES ('195', '17', '濮阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('196', '17', '许昌市', '2', '', null);
INSERT INTO `s_address` VALUES ('197', '17', '漯河市', '2', '', null);
INSERT INTO `s_address` VALUES ('198', '17', '三门峡市', '2', '', null);
INSERT INTO `s_address` VALUES ('199', '17', '南阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('200', '17', '商丘市', '2', '', null);
INSERT INTO `s_address` VALUES ('201', '17', '信阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('202', '17', '周口市', '2', '', null);
INSERT INTO `s_address` VALUES ('203', '17', '驻马店市', '2', '', null);
INSERT INTO `s_address` VALUES ('204', '18', '武汉市', '2', '', null);
INSERT INTO `s_address` VALUES ('205', '18', '黄石市', '2', '', null);
INSERT INTO `s_address` VALUES ('206', '18', '十堰市', '2', '', null);
INSERT INTO `s_address` VALUES ('207', '18', '宜昌市', '2', '', null);
INSERT INTO `s_address` VALUES ('208', '18', '襄阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('209', '18', '鄂州市', '2', '', null);
INSERT INTO `s_address` VALUES ('210', '18', '荆门市', '2', '', null);
INSERT INTO `s_address` VALUES ('211', '18', '孝感市', '2', '', null);
INSERT INTO `s_address` VALUES ('212', '18', '荆州市', '2', '', null);
INSERT INTO `s_address` VALUES ('213', '18', '黄冈市', '2', '', null);
INSERT INTO `s_address` VALUES ('214', '18', '咸宁市', '2', '', null);
INSERT INTO `s_address` VALUES ('215', '18', '随州市', '2', '', null);
INSERT INTO `s_address` VALUES ('216', '18', '恩施土家族苗族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('217', '19', '长沙市', '2', '', null);
INSERT INTO `s_address` VALUES ('218', '19', '株洲市', '2', '', null);
INSERT INTO `s_address` VALUES ('219', '19', '湘潭市', '2', '', null);
INSERT INTO `s_address` VALUES ('220', '19', '衡阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('221', '19', '邵阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('222', '19', '岳阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('223', '19', '常德市', '2', '', null);
INSERT INTO `s_address` VALUES ('224', '19', '张家界市', '2', '', null);
INSERT INTO `s_address` VALUES ('225', '19', '益阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('226', '19', '郴州市', '2', '', null);
INSERT INTO `s_address` VALUES ('227', '19', '永州市', '2', '', null);
INSERT INTO `s_address` VALUES ('228', '19', '怀化市', '2', '', null);
INSERT INTO `s_address` VALUES ('229', '19', '娄底市', '2', '', null);
INSERT INTO `s_address` VALUES ('230', '19', '湘西土家族苗族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('231', '20', '广州市', '2', '', null);
INSERT INTO `s_address` VALUES ('232', '20', '韶关市', '2', '', null);
INSERT INTO `s_address` VALUES ('233', '20', '深圳市', '2', '', null);
INSERT INTO `s_address` VALUES ('234', '20', '珠海市', '2', '', null);
INSERT INTO `s_address` VALUES ('235', '20', '汕头市', '2', '', null);
INSERT INTO `s_address` VALUES ('236', '20', '佛山市', '2', '', null);
INSERT INTO `s_address` VALUES ('237', '20', '江门市', '2', '', null);
INSERT INTO `s_address` VALUES ('238', '20', '湛江市', '2', '', null);
INSERT INTO `s_address` VALUES ('239', '20', '茂名市', '2', '', null);
INSERT INTO `s_address` VALUES ('240', '20', '肇庆市', '2', '', null);
INSERT INTO `s_address` VALUES ('241', '20', '惠州市', '2', '', null);
INSERT INTO `s_address` VALUES ('242', '20', '梅州市', '2', '', null);
INSERT INTO `s_address` VALUES ('243', '20', '汕尾市', '2', '', null);
INSERT INTO `s_address` VALUES ('244', '20', '河源市', '2', '', null);
INSERT INTO `s_address` VALUES ('245', '20', '阳江市', '2', '', null);
INSERT INTO `s_address` VALUES ('246', '20', '清远市', '2', '', null);
INSERT INTO `s_address` VALUES ('247', '20', '东莞市', '2', '', null);
INSERT INTO `s_address` VALUES ('248', '20', '中山市', '2', '', null);
INSERT INTO `s_address` VALUES ('249', '20', '东沙群岛', '2', '', null);
INSERT INTO `s_address` VALUES ('250', '20', '潮州市', '2', '', null);
INSERT INTO `s_address` VALUES ('251', '20', '揭阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('252', '20', '云浮市', '2', '', null);
INSERT INTO `s_address` VALUES ('253', '21', '南宁市', '2', '', null);
INSERT INTO `s_address` VALUES ('254', '21', '柳州市', '2', '', null);
INSERT INTO `s_address` VALUES ('255', '21', '桂林市', '2', '', null);
INSERT INTO `s_address` VALUES ('256', '21', '梧州市', '2', '', null);
INSERT INTO `s_address` VALUES ('257', '21', '北海市', '2', '', null);
INSERT INTO `s_address` VALUES ('258', '21', '防城港市', '2', '', null);
INSERT INTO `s_address` VALUES ('259', '21', '钦州市', '2', '', null);
INSERT INTO `s_address` VALUES ('260', '21', '贵港市', '2', '', null);
INSERT INTO `s_address` VALUES ('261', '21', '玉林市', '2', '', null);
INSERT INTO `s_address` VALUES ('262', '21', '百色市', '2', '', null);
INSERT INTO `s_address` VALUES ('263', '21', '贺州市', '2', '', null);
INSERT INTO `s_address` VALUES ('264', '21', '河池市', '2', '', null);
INSERT INTO `s_address` VALUES ('265', '21', '来宾市', '2', '', null);
INSERT INTO `s_address` VALUES ('266', '21', '崇左市', '2', '', null);
INSERT INTO `s_address` VALUES ('267', '22', '海口市', '2', '', null);
INSERT INTO `s_address` VALUES ('268', '22', '三亚市', '2', '', null);
INSERT INTO `s_address` VALUES ('269', '22', '三沙市', '2', '', null);
INSERT INTO `s_address` VALUES ('270', '23', '重庆市', '2', '', null);
INSERT INTO `s_address` VALUES ('271', '24', '成都市', '2', '', null);
INSERT INTO `s_address` VALUES ('272', '24', '自贡市', '2', '', null);
INSERT INTO `s_address` VALUES ('273', '24', '攀枝花市', '2', '', null);
INSERT INTO `s_address` VALUES ('274', '24', '泸州市', '2', '', null);
INSERT INTO `s_address` VALUES ('275', '24', '德阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('276', '24', '绵阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('277', '24', '广元市', '2', '', null);
INSERT INTO `s_address` VALUES ('278', '24', '遂宁市', '2', '', null);
INSERT INTO `s_address` VALUES ('279', '24', '内江市', '2', '', null);
INSERT INTO `s_address` VALUES ('280', '24', '乐山市', '2', '', null);
INSERT INTO `s_address` VALUES ('281', '24', '南充市', '2', '', null);
INSERT INTO `s_address` VALUES ('282', '24', '眉山市', '2', '', null);
INSERT INTO `s_address` VALUES ('283', '24', '宜宾市', '2', '', null);
INSERT INTO `s_address` VALUES ('284', '24', '广安市', '2', '', null);
INSERT INTO `s_address` VALUES ('285', '24', '达州市', '2', '', null);
INSERT INTO `s_address` VALUES ('286', '24', '雅安市', '2', '', null);
INSERT INTO `s_address` VALUES ('287', '24', '巴中市', '2', '', null);
INSERT INTO `s_address` VALUES ('288', '24', '资阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('289', '24', '阿坝藏族羌族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('290', '24', '甘孜藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('291', '24', '凉山彝族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('292', '25', '贵阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('293', '25', '六盘水市', '2', '', null);
INSERT INTO `s_address` VALUES ('294', '25', '遵义市', '2', '', null);
INSERT INTO `s_address` VALUES ('295', '25', '安顺市', '2', '', null);
INSERT INTO `s_address` VALUES ('296', '25', '铜仁市', '2', '', null);
INSERT INTO `s_address` VALUES ('297', '25', '黔西南布依族苗族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('298', '25', '毕节市', '2', '', null);
INSERT INTO `s_address` VALUES ('299', '25', '黔东南苗族侗族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('300', '25', '黔南布依族苗族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('301', '26', '昆明市', '2', '', null);
INSERT INTO `s_address` VALUES ('302', '26', '曲靖市', '2', '', null);
INSERT INTO `s_address` VALUES ('303', '26', '玉溪市', '2', '', null);
INSERT INTO `s_address` VALUES ('304', '26', '保山市', '2', '', null);
INSERT INTO `s_address` VALUES ('305', '26', '昭通市', '2', '', null);
INSERT INTO `s_address` VALUES ('306', '26', '丽江市', '2', '', null);
INSERT INTO `s_address` VALUES ('307', '26', '普洱市', '2', '', null);
INSERT INTO `s_address` VALUES ('308', '26', '临沧市', '2', '', null);
INSERT INTO `s_address` VALUES ('309', '26', '楚雄彝族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('310', '26', '红河哈尼族彝族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('311', '26', '文山壮族苗族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('312', '26', '西双版纳傣族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('313', '26', '大理白族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('314', '26', '德宏傣族景颇族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('315', '26', '怒江傈僳族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('316', '26', '迪庆藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('317', '27', '拉萨市', '2', '', null);
INSERT INTO `s_address` VALUES ('318', '27', '昌都市', '2', '', null);
INSERT INTO `s_address` VALUES ('319', '27', '山南地区', '2', '', null);
INSERT INTO `s_address` VALUES ('320', '27', '日喀则市', '2', '', null);
INSERT INTO `s_address` VALUES ('321', '27', '那曲地区', '2', '', null);
INSERT INTO `s_address` VALUES ('322', '27', '阿里地区', '2', '', null);
INSERT INTO `s_address` VALUES ('323', '27', '林芝市', '2', '', null);
INSERT INTO `s_address` VALUES ('324', '28', '西安市', '2', '', null);
INSERT INTO `s_address` VALUES ('325', '28', '铜川市', '2', '', null);
INSERT INTO `s_address` VALUES ('326', '28', '宝鸡市', '2', '', null);
INSERT INTO `s_address` VALUES ('327', '28', '咸阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('328', '28', '渭南市', '2', '', null);
INSERT INTO `s_address` VALUES ('329', '28', '延安市', '2', '', null);
INSERT INTO `s_address` VALUES ('330', '28', '汉中市', '2', '', null);
INSERT INTO `s_address` VALUES ('331', '28', '榆林市', '2', '', null);
INSERT INTO `s_address` VALUES ('332', '28', '安康市', '2', '', null);
INSERT INTO `s_address` VALUES ('333', '28', '商洛市', '2', '', null);
INSERT INTO `s_address` VALUES ('334', '29', '兰州市', '2', '', null);
INSERT INTO `s_address` VALUES ('335', '29', '嘉峪关市', '2', '', null);
INSERT INTO `s_address` VALUES ('336', '29', '金昌市', '2', '', null);
INSERT INTO `s_address` VALUES ('337', '29', '白银市', '2', '', null);
INSERT INTO `s_address` VALUES ('338', '29', '天水市', '2', '', null);
INSERT INTO `s_address` VALUES ('339', '29', '武威市', '2', '', null);
INSERT INTO `s_address` VALUES ('340', '29', '张掖市', '2', '', null);
INSERT INTO `s_address` VALUES ('341', '29', '平凉市', '2', '', null);
INSERT INTO `s_address` VALUES ('342', '29', '酒泉市', '2', '', null);
INSERT INTO `s_address` VALUES ('343', '29', '庆阳市', '2', '', null);
INSERT INTO `s_address` VALUES ('344', '29', '定西市', '2', '', null);
INSERT INTO `s_address` VALUES ('345', '29', '陇南市', '2', '', null);
INSERT INTO `s_address` VALUES ('346', '29', '临夏回族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('347', '29', '甘南藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('348', '30', '西宁市', '2', '', null);
INSERT INTO `s_address` VALUES ('349', '30', '海东市', '2', '', null);
INSERT INTO `s_address` VALUES ('350', '30', '海北藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('351', '30', '黄南藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('352', '30', '海南藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('353', '30', '果洛藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('354', '30', '玉树藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('355', '30', '海西蒙古族藏族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('356', '31', '银川市', '2', '', null);
INSERT INTO `s_address` VALUES ('357', '31', '石嘴山市', '2', '', null);
INSERT INTO `s_address` VALUES ('358', '31', '吴忠市', '2', '', null);
INSERT INTO `s_address` VALUES ('359', '31', '固原市', '2', '', null);
INSERT INTO `s_address` VALUES ('360', '31', '中卫市', '2', '', null);
INSERT INTO `s_address` VALUES ('361', '32', '乌鲁木齐市', '2', '', null);
INSERT INTO `s_address` VALUES ('362', '32', '克拉玛依市', '2', '', null);
INSERT INTO `s_address` VALUES ('363', '32', '吐鲁番市', '2', '', null);
INSERT INTO `s_address` VALUES ('364', '32', '哈密地区', '2', '', null);
INSERT INTO `s_address` VALUES ('365', '32', '昌吉回族自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('366', '32', '博尔塔拉蒙古自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('367', '32', '巴音郭楞蒙古自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('368', '32', '阿克苏地区', '2', '', null);
INSERT INTO `s_address` VALUES ('369', '32', '克孜勒苏柯尔克孜自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('370', '32', '喀什地区', '2', '', null);
INSERT INTO `s_address` VALUES ('371', '32', '和田地区', '2', '', null);
INSERT INTO `s_address` VALUES ('372', '32', '伊犁哈萨克自治州', '2', '', null);
INSERT INTO `s_address` VALUES ('373', '32', '塔城地区', '2', '', null);
INSERT INTO `s_address` VALUES ('374', '32', '阿勒泰地区', '2', '', null);
INSERT INTO `s_address` VALUES ('375', '33', '台北市', '2', '', null);
INSERT INTO `s_address` VALUES ('376', '33', '高雄市', '2', '', null);
INSERT INTO `s_address` VALUES ('377', '33', '台南市', '2', '', null);
INSERT INTO `s_address` VALUES ('378', '33', '台中市', '2', '', null);
INSERT INTO `s_address` VALUES ('379', '33', '金门县', '2', '', null);
INSERT INTO `s_address` VALUES ('380', '33', '南投县', '2', '', null);
INSERT INTO `s_address` VALUES ('381', '33', '基隆市', '2', '', null);
INSERT INTO `s_address` VALUES ('382', '33', '新竹市', '2', '', null);
INSERT INTO `s_address` VALUES ('383', '33', '嘉义市', '2', '', null);
INSERT INTO `s_address` VALUES ('384', '33', '新北市', '2', '', null);
INSERT INTO `s_address` VALUES ('385', '33', '宜兰县', '2', '', null);
INSERT INTO `s_address` VALUES ('386', '33', '新竹县', '2', '', null);
INSERT INTO `s_address` VALUES ('387', '33', '桃园县', '2', '', null);
INSERT INTO `s_address` VALUES ('388', '33', '苗栗县', '2', '', null);
INSERT INTO `s_address` VALUES ('389', '33', '彰化县', '2', '', null);
INSERT INTO `s_address` VALUES ('390', '33', '嘉义县', '2', '', null);
INSERT INTO `s_address` VALUES ('391', '33', '云林县', '2', '', null);
INSERT INTO `s_address` VALUES ('392', '33', '屏东县', '2', '', null);
INSERT INTO `s_address` VALUES ('393', '33', '台东县', '2', '', null);
INSERT INTO `s_address` VALUES ('394', '33', '花莲县', '2', '', null);
INSERT INTO `s_address` VALUES ('395', '33', '澎湖县', '2', '', null);
INSERT INTO `s_address` VALUES ('396', '33', '连江县', '2', '', null);
INSERT INTO `s_address` VALUES ('397', '34', '香港岛', '2', '', null);
INSERT INTO `s_address` VALUES ('398', '34', '九龙', '2', '', null);
INSERT INTO `s_address` VALUES ('399', '34', '新界', '2', '', null);
INSERT INTO `s_address` VALUES ('400', '35', '澳门半岛', '2', '', null);
INSERT INTO `s_address` VALUES ('401', '35', '离岛', '2', '', null);
INSERT INTO `s_address` VALUES ('402', '36', '海外', '2', '', null);
INSERT INTO `s_address` VALUES ('403', '37', '东城区', '3', '', null);
INSERT INTO `s_address` VALUES ('404', '37', '西城区', '3', '', null);
INSERT INTO `s_address` VALUES ('405', '37', '崇文区', '3', '', null);
INSERT INTO `s_address` VALUES ('406', '37', '宣武区', '3', '', null);
INSERT INTO `s_address` VALUES ('407', '37', '朝阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('408', '37', '丰台区', '3', '', null);
INSERT INTO `s_address` VALUES ('409', '37', '石景山区', '3', '', null);
INSERT INTO `s_address` VALUES ('410', '37', '海淀区', '3', '', null);
INSERT INTO `s_address` VALUES ('411', '37', '门头沟区', '3', '', null);
INSERT INTO `s_address` VALUES ('412', '37', '房山区', '3', '', null);
INSERT INTO `s_address` VALUES ('413', '37', '通州区', '3', '', null);
INSERT INTO `s_address` VALUES ('414', '37', '顺义区', '3', '', null);
INSERT INTO `s_address` VALUES ('415', '37', '昌平区', '3', '', null);
INSERT INTO `s_address` VALUES ('416', '37', '大兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('417', '37', '怀柔区', '3', '', null);
INSERT INTO `s_address` VALUES ('418', '37', '平谷区', '3', '', null);
INSERT INTO `s_address` VALUES ('419', '37', '密云县', '3', '', null);
INSERT INTO `s_address` VALUES ('420', '37', '延庆县', '3', '', null);
INSERT INTO `s_address` VALUES ('421', '37', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('422', '38', '和平区', '3', '', null);
INSERT INTO `s_address` VALUES ('423', '38', '河东区', '3', '', null);
INSERT INTO `s_address` VALUES ('424', '38', '河西区', '3', '', null);
INSERT INTO `s_address` VALUES ('425', '38', '南开区', '3', '', null);
INSERT INTO `s_address` VALUES ('426', '38', '河北区', '3', '', null);
INSERT INTO `s_address` VALUES ('427', '38', '红桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('428', '38', '塘沽区', '3', '', null);
INSERT INTO `s_address` VALUES ('429', '38', '汉沽区', '3', '', null);
INSERT INTO `s_address` VALUES ('430', '38', '大港区', '3', '', null);
INSERT INTO `s_address` VALUES ('431', '38', '东丽区', '3', '', null);
INSERT INTO `s_address` VALUES ('432', '38', '西青区', '3', '', null);
INSERT INTO `s_address` VALUES ('433', '38', '津南区', '3', '', null);
INSERT INTO `s_address` VALUES ('434', '38', '北辰区', '3', '', null);
INSERT INTO `s_address` VALUES ('435', '38', '武清区', '3', '', null);
INSERT INTO `s_address` VALUES ('436', '38', '宝坻区', '3', '', null);
INSERT INTO `s_address` VALUES ('437', '38', '滨海新区', '3', '', null);
INSERT INTO `s_address` VALUES ('438', '38', '宁河县', '3', '', null);
INSERT INTO `s_address` VALUES ('439', '38', '静海县', '3', '', null);
INSERT INTO `s_address` VALUES ('440', '38', '蓟县', '3', '', null);
INSERT INTO `s_address` VALUES ('441', '38', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('442', '39', '长安区', '3', '', null);
INSERT INTO `s_address` VALUES ('443', '39', '桥东区', '3', '', null);
INSERT INTO `s_address` VALUES ('444', '39', '桥西区', '3', '', null);
INSERT INTO `s_address` VALUES ('445', '39', '新华区', '3', '', null);
INSERT INTO `s_address` VALUES ('446', '39', '井陉矿区', '3', '', null);
INSERT INTO `s_address` VALUES ('447', '39', '裕华区', '3', '', null);
INSERT INTO `s_address` VALUES ('448', '39', '井陉县', '3', '', null);
INSERT INTO `s_address` VALUES ('449', '39', '正定县', '3', '', null);
INSERT INTO `s_address` VALUES ('450', '39', '栾城区', '3', '', null);
INSERT INTO `s_address` VALUES ('451', '39', '行唐县', '3', '', null);
INSERT INTO `s_address` VALUES ('452', '39', '灵寿县', '3', '', null);
INSERT INTO `s_address` VALUES ('453', '39', '高邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('454', '39', '深泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('455', '39', '赞皇县', '3', '', null);
INSERT INTO `s_address` VALUES ('456', '39', '无极县', '3', '', null);
INSERT INTO `s_address` VALUES ('457', '39', '平山县', '3', '', null);
INSERT INTO `s_address` VALUES ('458', '39', '元氏县', '3', '', null);
INSERT INTO `s_address` VALUES ('459', '39', '赵县', '3', '', null);
INSERT INTO `s_address` VALUES ('460', '39', '辛集市', '3', '', null);
INSERT INTO `s_address` VALUES ('461', '39', '藁城区', '3', '', null);
INSERT INTO `s_address` VALUES ('462', '39', '晋州市', '3', '', null);
INSERT INTO `s_address` VALUES ('463', '39', '新乐市', '3', '', null);
INSERT INTO `s_address` VALUES ('464', '39', '鹿泉区', '3', '', null);
INSERT INTO `s_address` VALUES ('465', '39', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('466', '40', '路南区', '3', '', null);
INSERT INTO `s_address` VALUES ('467', '40', '路北区', '3', '', null);
INSERT INTO `s_address` VALUES ('468', '40', '古冶区', '3', '', null);
INSERT INTO `s_address` VALUES ('469', '40', '开平区', '3', '', null);
INSERT INTO `s_address` VALUES ('470', '40', '丰南区', '3', '', null);
INSERT INTO `s_address` VALUES ('471', '40', '丰润区', '3', '', null);
INSERT INTO `s_address` VALUES ('472', '40', '滦县', '3', '', null);
INSERT INTO `s_address` VALUES ('473', '40', '滦南县', '3', '', null);
INSERT INTO `s_address` VALUES ('474', '40', '乐亭县', '3', '', null);
INSERT INTO `s_address` VALUES ('475', '40', '迁西县', '3', '', null);
INSERT INTO `s_address` VALUES ('476', '40', '玉田县', '3', '', null);
INSERT INTO `s_address` VALUES ('477', '40', '曹妃甸区', '3', '', null);
INSERT INTO `s_address` VALUES ('478', '40', '遵化市', '3', '', null);
INSERT INTO `s_address` VALUES ('479', '40', '迁安市', '3', '', null);
INSERT INTO `s_address` VALUES ('480', '40', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('481', '41', '海港区', '3', '', null);
INSERT INTO `s_address` VALUES ('482', '41', '山海关区', '3', '', null);
INSERT INTO `s_address` VALUES ('483', '41', '北戴河区', '3', '', null);
INSERT INTO `s_address` VALUES ('484', '41', '青龙满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('485', '41', '昌黎县', '3', '', null);
INSERT INTO `s_address` VALUES ('486', '41', '抚宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('487', '41', '卢龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('488', '41', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('489', '41', '经济技术开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('490', '42', '邯山区', '3', '', null);
INSERT INTO `s_address` VALUES ('491', '42', '丛台区', '3', '', null);
INSERT INTO `s_address` VALUES ('492', '42', '复兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('493', '42', '峰峰矿区', '3', '', null);
INSERT INTO `s_address` VALUES ('494', '42', '邯郸县', '3', '', null);
INSERT INTO `s_address` VALUES ('495', '42', '临漳县', '3', '', null);
INSERT INTO `s_address` VALUES ('496', '42', '成安县', '3', '', null);
INSERT INTO `s_address` VALUES ('497', '42', '大名县', '3', '', null);
INSERT INTO `s_address` VALUES ('498', '42', '涉县', '3', '', null);
INSERT INTO `s_address` VALUES ('499', '42', '磁县', '3', '', null);
INSERT INTO `s_address` VALUES ('500', '42', '肥乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('501', '42', '永年县', '3', '', null);
INSERT INTO `s_address` VALUES ('502', '42', '邱县', '3', '', null);
INSERT INTO `s_address` VALUES ('503', '42', '鸡泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('504', '42', '广平县', '3', '', null);
INSERT INTO `s_address` VALUES ('505', '42', '馆陶县', '3', '', null);
INSERT INTO `s_address` VALUES ('506', '42', '魏县', '3', '', null);
INSERT INTO `s_address` VALUES ('507', '42', '曲周县', '3', '', null);
INSERT INTO `s_address` VALUES ('508', '42', '武安市', '3', '', null);
INSERT INTO `s_address` VALUES ('509', '42', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('510', '43', '桥东区', '3', '', null);
INSERT INTO `s_address` VALUES ('511', '43', '桥西区', '3', '', null);
INSERT INTO `s_address` VALUES ('512', '43', '邢台县', '3', '', null);
INSERT INTO `s_address` VALUES ('513', '43', '临城县', '3', '', null);
INSERT INTO `s_address` VALUES ('514', '43', '内丘县', '3', '', null);
INSERT INTO `s_address` VALUES ('515', '43', '柏乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('516', '43', '隆尧县', '3', '', null);
INSERT INTO `s_address` VALUES ('517', '43', '任县', '3', '', null);
INSERT INTO `s_address` VALUES ('518', '43', '南和县', '3', '', null);
INSERT INTO `s_address` VALUES ('519', '43', '宁晋县', '3', '', null);
INSERT INTO `s_address` VALUES ('520', '43', '巨鹿县', '3', '', null);
INSERT INTO `s_address` VALUES ('521', '43', '新河县', '3', '', null);
INSERT INTO `s_address` VALUES ('522', '43', '广宗县', '3', '', null);
INSERT INTO `s_address` VALUES ('523', '43', '平乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('524', '43', '威县', '3', '', null);
INSERT INTO `s_address` VALUES ('525', '43', '清河县', '3', '', null);
INSERT INTO `s_address` VALUES ('526', '43', '临西县', '3', '', null);
INSERT INTO `s_address` VALUES ('527', '43', '南宫市', '3', '', null);
INSERT INTO `s_address` VALUES ('528', '43', '沙河市', '3', '', null);
INSERT INTO `s_address` VALUES ('529', '43', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('530', '44', '新市区', '3', '', null);
INSERT INTO `s_address` VALUES ('531', '44', '北市区', '3', '', null);
INSERT INTO `s_address` VALUES ('532', '44', '南市区', '3', '', null);
INSERT INTO `s_address` VALUES ('533', '44', '满城县', '3', '', null);
INSERT INTO `s_address` VALUES ('534', '44', '清苑县', '3', '', null);
INSERT INTO `s_address` VALUES ('535', '44', '涞水县', '3', '', null);
INSERT INTO `s_address` VALUES ('536', '44', '阜平县', '3', '', null);
INSERT INTO `s_address` VALUES ('537', '44', '徐水县', '3', '', null);
INSERT INTO `s_address` VALUES ('538', '44', '定兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('539', '44', '唐县', '3', '', null);
INSERT INTO `s_address` VALUES ('540', '44', '高阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('541', '44', '容城县', '3', '', null);
INSERT INTO `s_address` VALUES ('542', '44', '涞源县', '3', '', null);
INSERT INTO `s_address` VALUES ('543', '44', '望都县', '3', '', null);
INSERT INTO `s_address` VALUES ('544', '44', '安新县', '3', '', null);
INSERT INTO `s_address` VALUES ('545', '44', '易县', '3', '', null);
INSERT INTO `s_address` VALUES ('546', '44', '曲阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('547', '44', '蠡县', '3', '', null);
INSERT INTO `s_address` VALUES ('548', '44', '顺平县', '3', '', null);
INSERT INTO `s_address` VALUES ('549', '44', '博野县', '3', '', null);
INSERT INTO `s_address` VALUES ('550', '44', '雄县', '3', '', null);
INSERT INTO `s_address` VALUES ('551', '44', '涿州市', '3', '', null);
INSERT INTO `s_address` VALUES ('552', '44', '定州市', '3', '', null);
INSERT INTO `s_address` VALUES ('553', '44', '安国市', '3', '', null);
INSERT INTO `s_address` VALUES ('554', '44', '高碑店市', '3', '', null);
INSERT INTO `s_address` VALUES ('555', '44', '高开区', '3', '', null);
INSERT INTO `s_address` VALUES ('556', '44', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('557', '45', '桥东区', '3', '', null);
INSERT INTO `s_address` VALUES ('558', '45', '桥西区', '3', '', null);
INSERT INTO `s_address` VALUES ('559', '45', '宣化区', '3', '', null);
INSERT INTO `s_address` VALUES ('560', '45', '下花园区', '3', '', null);
INSERT INTO `s_address` VALUES ('561', '45', '宣化县', '3', '', null);
INSERT INTO `s_address` VALUES ('562', '45', '张北县', '3', '', null);
INSERT INTO `s_address` VALUES ('563', '45', '康保县', '3', '', null);
INSERT INTO `s_address` VALUES ('564', '45', '沽源县', '3', '', null);
INSERT INTO `s_address` VALUES ('565', '45', '尚义县', '3', '', null);
INSERT INTO `s_address` VALUES ('566', '45', '蔚县', '3', '', null);
INSERT INTO `s_address` VALUES ('567', '45', '阳原县', '3', '', null);
INSERT INTO `s_address` VALUES ('568', '45', '怀安县', '3', '', null);
INSERT INTO `s_address` VALUES ('569', '45', '万全县', '3', '', null);
INSERT INTO `s_address` VALUES ('570', '45', '怀来县', '3', '', null);
INSERT INTO `s_address` VALUES ('571', '45', '涿鹿县', '3', '', null);
INSERT INTO `s_address` VALUES ('572', '45', '赤城县', '3', '', null);
INSERT INTO `s_address` VALUES ('573', '45', '崇礼县', '3', '', null);
INSERT INTO `s_address` VALUES ('574', '45', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('575', '46', '双桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('576', '46', '双滦区', '3', '', null);
INSERT INTO `s_address` VALUES ('577', '46', '鹰手营子矿区', '3', '', null);
INSERT INTO `s_address` VALUES ('578', '46', '承德县', '3', '', null);
INSERT INTO `s_address` VALUES ('579', '46', '兴隆县', '3', '', null);
INSERT INTO `s_address` VALUES ('580', '46', '平泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('581', '46', '滦平县', '3', '', null);
INSERT INTO `s_address` VALUES ('582', '46', '隆化县', '3', '', null);
INSERT INTO `s_address` VALUES ('583', '46', '丰宁满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('584', '46', '宽城满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('585', '46', '围场满族蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('586', '46', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('587', '47', '新华区', '3', '', null);
INSERT INTO `s_address` VALUES ('588', '47', '运河区', '3', '', null);
INSERT INTO `s_address` VALUES ('589', '47', '沧县', '3', '', null);
INSERT INTO `s_address` VALUES ('590', '47', '青县', '3', '', null);
INSERT INTO `s_address` VALUES ('591', '47', '东光县', '3', '', null);
INSERT INTO `s_address` VALUES ('592', '47', '海兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('593', '47', '盐山县', '3', '', null);
INSERT INTO `s_address` VALUES ('594', '47', '肃宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('595', '47', '南皮县', '3', '', null);
INSERT INTO `s_address` VALUES ('596', '47', '吴桥县', '3', '', null);
INSERT INTO `s_address` VALUES ('597', '47', '献县', '3', '', null);
INSERT INTO `s_address` VALUES ('598', '47', '孟村回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('599', '47', '泊头市', '3', '', null);
INSERT INTO `s_address` VALUES ('600', '47', '任丘市', '3', '', null);
INSERT INTO `s_address` VALUES ('601', '47', '黄骅市', '3', '', null);
INSERT INTO `s_address` VALUES ('602', '47', '河间市', '3', '', null);
INSERT INTO `s_address` VALUES ('603', '47', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('604', '48', '安次区', '3', '', null);
INSERT INTO `s_address` VALUES ('605', '48', '广阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('606', '48', '固安县', '3', '', null);
INSERT INTO `s_address` VALUES ('607', '48', '永清县', '3', '', null);
INSERT INTO `s_address` VALUES ('608', '48', '香河县', '3', '', null);
INSERT INTO `s_address` VALUES ('609', '48', '大城县', '3', '', null);
INSERT INTO `s_address` VALUES ('610', '48', '文安县', '3', '', null);
INSERT INTO `s_address` VALUES ('611', '48', '大厂回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('612', '48', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('613', '48', '燕郊经济技术开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('614', '48', '霸州市', '3', '', null);
INSERT INTO `s_address` VALUES ('615', '48', '三河市', '3', '', null);
INSERT INTO `s_address` VALUES ('616', '48', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('617', '49', '桃城区', '3', '', null);
INSERT INTO `s_address` VALUES ('618', '49', '枣强县', '3', '', null);
INSERT INTO `s_address` VALUES ('619', '49', '武邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('620', '49', '武强县', '3', '', null);
INSERT INTO `s_address` VALUES ('621', '49', '饶阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('622', '49', '安平县', '3', '', null);
INSERT INTO `s_address` VALUES ('623', '49', '故城县', '3', '', null);
INSERT INTO `s_address` VALUES ('624', '49', '景县', '3', '', null);
INSERT INTO `s_address` VALUES ('625', '49', '阜城县', '3', '', null);
INSERT INTO `s_address` VALUES ('626', '49', '冀州市', '3', '', null);
INSERT INTO `s_address` VALUES ('627', '49', '深州市', '3', '', null);
INSERT INTO `s_address` VALUES ('628', '49', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('629', '50', '小店区', '3', '', null);
INSERT INTO `s_address` VALUES ('630', '50', '迎泽区', '3', '', null);
INSERT INTO `s_address` VALUES ('631', '50', '杏花岭区', '3', '', null);
INSERT INTO `s_address` VALUES ('632', '50', '尖草坪区', '3', '', null);
INSERT INTO `s_address` VALUES ('633', '50', '万柏林区', '3', '', null);
INSERT INTO `s_address` VALUES ('634', '50', '晋源区', '3', '', null);
INSERT INTO `s_address` VALUES ('635', '50', '清徐县', '3', '', null);
INSERT INTO `s_address` VALUES ('636', '50', '阳曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('637', '50', '娄烦县', '3', '', null);
INSERT INTO `s_address` VALUES ('638', '50', '古交市', '3', '', null);
INSERT INTO `s_address` VALUES ('639', '50', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('640', '51', '城区', '3', '', null);
INSERT INTO `s_address` VALUES ('641', '51', '矿区', '3', '', null);
INSERT INTO `s_address` VALUES ('642', '51', '南郊区', '3', '', null);
INSERT INTO `s_address` VALUES ('643', '51', '新荣区', '3', '', null);
INSERT INTO `s_address` VALUES ('644', '51', '阳高县', '3', '', null);
INSERT INTO `s_address` VALUES ('645', '51', '天镇县', '3', '', null);
INSERT INTO `s_address` VALUES ('646', '51', '广灵县', '3', '', null);
INSERT INTO `s_address` VALUES ('647', '51', '灵丘县', '3', '', null);
INSERT INTO `s_address` VALUES ('648', '51', '浑源县', '3', '', null);
INSERT INTO `s_address` VALUES ('649', '51', '左云县', '3', '', null);
INSERT INTO `s_address` VALUES ('650', '51', '大同县', '3', '', null);
INSERT INTO `s_address` VALUES ('651', '51', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('652', '52', '城区', '3', '', null);
INSERT INTO `s_address` VALUES ('653', '52', '矿区', '3', '', null);
INSERT INTO `s_address` VALUES ('654', '52', '郊区', '3', '', null);
INSERT INTO `s_address` VALUES ('655', '52', '平定县', '3', '', null);
INSERT INTO `s_address` VALUES ('656', '52', '盂县', '3', '', null);
INSERT INTO `s_address` VALUES ('657', '52', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('658', '53', '长治县', '3', '', null);
INSERT INTO `s_address` VALUES ('659', '53', '襄垣县', '3', '', null);
INSERT INTO `s_address` VALUES ('660', '53', '屯留县', '3', '', null);
INSERT INTO `s_address` VALUES ('661', '53', '平顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('662', '53', '黎城县', '3', '', null);
INSERT INTO `s_address` VALUES ('663', '53', '壶关县', '3', '', null);
INSERT INTO `s_address` VALUES ('664', '53', '长子县', '3', '', null);
INSERT INTO `s_address` VALUES ('665', '53', '武乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('666', '53', '沁县', '3', '', null);
INSERT INTO `s_address` VALUES ('667', '53', '沁源县', '3', '', null);
INSERT INTO `s_address` VALUES ('668', '53', '潞城市', '3', '', null);
INSERT INTO `s_address` VALUES ('669', '53', '城区', '3', '', null);
INSERT INTO `s_address` VALUES ('670', '53', '郊区', '3', '', null);
INSERT INTO `s_address` VALUES ('671', '53', '高新区', '3', '', null);
INSERT INTO `s_address` VALUES ('672', '53', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('673', '54', '城区', '3', '', null);
INSERT INTO `s_address` VALUES ('674', '54', '沁水县', '3', '', null);
INSERT INTO `s_address` VALUES ('675', '54', '阳城县', '3', '', null);
INSERT INTO `s_address` VALUES ('676', '54', '陵川县', '3', '', null);
INSERT INTO `s_address` VALUES ('677', '54', '泽州县', '3', '', null);
INSERT INTO `s_address` VALUES ('678', '54', '高平市', '3', '', null);
INSERT INTO `s_address` VALUES ('679', '54', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('680', '55', '朔城区', '3', '', null);
INSERT INTO `s_address` VALUES ('681', '55', '平鲁区', '3', '', null);
INSERT INTO `s_address` VALUES ('682', '55', '山阴县', '3', '', null);
INSERT INTO `s_address` VALUES ('683', '55', '应县', '3', '', null);
INSERT INTO `s_address` VALUES ('684', '55', '右玉县', '3', '', null);
INSERT INTO `s_address` VALUES ('685', '55', '怀仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('686', '55', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('687', '56', '榆次区', '3', '', null);
INSERT INTO `s_address` VALUES ('688', '56', '榆社县', '3', '', null);
INSERT INTO `s_address` VALUES ('689', '56', '左权县', '3', '', null);
INSERT INTO `s_address` VALUES ('690', '56', '和顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('691', '56', '昔阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('692', '56', '寿阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('693', '56', '太谷县', '3', '', null);
INSERT INTO `s_address` VALUES ('694', '56', '祁县', '3', '', null);
INSERT INTO `s_address` VALUES ('695', '56', '平遥县', '3', '', null);
INSERT INTO `s_address` VALUES ('696', '56', '灵石县', '3', '', null);
INSERT INTO `s_address` VALUES ('697', '56', '介休市', '3', '', null);
INSERT INTO `s_address` VALUES ('698', '56', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('699', '57', '盐湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('700', '57', '临猗县', '3', '', null);
INSERT INTO `s_address` VALUES ('701', '57', '万荣县', '3', '', null);
INSERT INTO `s_address` VALUES ('702', '57', '闻喜县', '3', '', null);
INSERT INTO `s_address` VALUES ('703', '57', '稷山县', '3', '', null);
INSERT INTO `s_address` VALUES ('704', '57', '新绛县', '3', '', null);
INSERT INTO `s_address` VALUES ('705', '57', '绛县', '3', '', null);
INSERT INTO `s_address` VALUES ('706', '57', '垣曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('707', '57', '夏县', '3', '', null);
INSERT INTO `s_address` VALUES ('708', '57', '平陆县', '3', '', null);
INSERT INTO `s_address` VALUES ('709', '57', '芮城县', '3', '', null);
INSERT INTO `s_address` VALUES ('710', '57', '永济市', '3', '', null);
INSERT INTO `s_address` VALUES ('711', '57', '河津市', '3', '', null);
INSERT INTO `s_address` VALUES ('712', '57', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('713', '58', '忻府区', '3', '', null);
INSERT INTO `s_address` VALUES ('714', '58', '定襄县', '3', '', null);
INSERT INTO `s_address` VALUES ('715', '58', '五台县', '3', '', null);
INSERT INTO `s_address` VALUES ('716', '58', '代县', '3', '', null);
INSERT INTO `s_address` VALUES ('717', '58', '繁峙县', '3', '', null);
INSERT INTO `s_address` VALUES ('718', '58', '宁武县', '3', '', null);
INSERT INTO `s_address` VALUES ('719', '58', '静乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('720', '58', '神池县', '3', '', null);
INSERT INTO `s_address` VALUES ('721', '58', '五寨县', '3', '', null);
INSERT INTO `s_address` VALUES ('722', '58', '岢岚县', '3', '', null);
INSERT INTO `s_address` VALUES ('723', '58', '河曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('724', '58', '保德县', '3', '', null);
INSERT INTO `s_address` VALUES ('725', '58', '偏关县', '3', '', null);
INSERT INTO `s_address` VALUES ('726', '58', '原平市', '3', '', null);
INSERT INTO `s_address` VALUES ('727', '58', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('728', '59', '尧都区', '3', '', null);
INSERT INTO `s_address` VALUES ('729', '59', '曲沃县', '3', '', null);
INSERT INTO `s_address` VALUES ('730', '59', '翼城县', '3', '', null);
INSERT INTO `s_address` VALUES ('731', '59', '襄汾县', '3', '', null);
INSERT INTO `s_address` VALUES ('732', '59', '洪洞县', '3', '', null);
INSERT INTO `s_address` VALUES ('733', '59', '古县', '3', '', null);
INSERT INTO `s_address` VALUES ('734', '59', '安泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('735', '59', '浮山县', '3', '', null);
INSERT INTO `s_address` VALUES ('736', '59', '吉县', '3', '', null);
INSERT INTO `s_address` VALUES ('737', '59', '乡宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('738', '59', '大宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('739', '59', '隰县', '3', '', null);
INSERT INTO `s_address` VALUES ('740', '59', '永和县', '3', '', null);
INSERT INTO `s_address` VALUES ('741', '59', '蒲县', '3', '', null);
INSERT INTO `s_address` VALUES ('742', '59', '汾西县', '3', '', null);
INSERT INTO `s_address` VALUES ('743', '59', '侯马市', '3', '', null);
INSERT INTO `s_address` VALUES ('744', '59', '霍州市', '3', '', null);
INSERT INTO `s_address` VALUES ('745', '59', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('746', '60', '离石区', '3', '', null);
INSERT INTO `s_address` VALUES ('747', '60', '文水县', '3', '', null);
INSERT INTO `s_address` VALUES ('748', '60', '交城县', '3', '', null);
INSERT INTO `s_address` VALUES ('749', '60', '兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('750', '60', '临县', '3', '', null);
INSERT INTO `s_address` VALUES ('751', '60', '柳林县', '3', '', null);
INSERT INTO `s_address` VALUES ('752', '60', '石楼县', '3', '', null);
INSERT INTO `s_address` VALUES ('753', '60', '岚县', '3', '', null);
INSERT INTO `s_address` VALUES ('754', '60', '方山县', '3', '', null);
INSERT INTO `s_address` VALUES ('755', '60', '中阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('756', '60', '交口县', '3', '', null);
INSERT INTO `s_address` VALUES ('757', '60', '孝义市', '3', '', null);
INSERT INTO `s_address` VALUES ('758', '60', '汾阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('759', '60', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('760', '61', '新城区', '3', '', null);
INSERT INTO `s_address` VALUES ('761', '61', '回民区', '3', '', null);
INSERT INTO `s_address` VALUES ('762', '61', '玉泉区', '3', '', null);
INSERT INTO `s_address` VALUES ('763', '61', '赛罕区', '3', '', null);
INSERT INTO `s_address` VALUES ('764', '61', '土默特左旗', '3', '', null);
INSERT INTO `s_address` VALUES ('765', '61', '托克托县', '3', '', null);
INSERT INTO `s_address` VALUES ('766', '61', '和林格尔县', '3', '', null);
INSERT INTO `s_address` VALUES ('767', '61', '清水河县', '3', '', null);
INSERT INTO `s_address` VALUES ('768', '61', '武川县', '3', '', null);
INSERT INTO `s_address` VALUES ('769', '61', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('770', '62', '东河区', '3', '', null);
INSERT INTO `s_address` VALUES ('771', '62', '昆都仑区', '3', '', null);
INSERT INTO `s_address` VALUES ('772', '62', '青山区', '3', '', null);
INSERT INTO `s_address` VALUES ('773', '62', '石拐区', '3', '', null);
INSERT INTO `s_address` VALUES ('774', '62', '白云鄂博矿区', '3', '', null);
INSERT INTO `s_address` VALUES ('775', '62', '九原区', '3', '', null);
INSERT INTO `s_address` VALUES ('776', '62', '土默特右旗', '3', '', null);
INSERT INTO `s_address` VALUES ('777', '62', '固阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('778', '62', '达尔罕茂明安联合旗', '3', '', null);
INSERT INTO `s_address` VALUES ('779', '62', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('780', '63', '海勃湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('781', '63', '海南区', '3', '', null);
INSERT INTO `s_address` VALUES ('782', '63', '乌达区', '3', '', null);
INSERT INTO `s_address` VALUES ('783', '63', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('784', '64', '红山区', '3', '', null);
INSERT INTO `s_address` VALUES ('785', '64', '元宝山区', '3', '', null);
INSERT INTO `s_address` VALUES ('786', '64', '松山区', '3', '', null);
INSERT INTO `s_address` VALUES ('787', '64', '阿鲁科尔沁旗', '3', '', null);
INSERT INTO `s_address` VALUES ('788', '64', '巴林左旗', '3', '', null);
INSERT INTO `s_address` VALUES ('789', '64', '巴林右旗', '3', '', null);
INSERT INTO `s_address` VALUES ('790', '64', '林西县', '3', '', null);
INSERT INTO `s_address` VALUES ('791', '64', '克什克腾旗', '3', '', null);
INSERT INTO `s_address` VALUES ('792', '64', '翁牛特旗', '3', '', null);
INSERT INTO `s_address` VALUES ('793', '64', '喀喇沁旗', '3', '', null);
INSERT INTO `s_address` VALUES ('794', '64', '宁城县', '3', '', null);
INSERT INTO `s_address` VALUES ('795', '64', '敖汉旗', '3', '', null);
INSERT INTO `s_address` VALUES ('796', '64', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('797', '65', '科尔沁区', '3', '', null);
INSERT INTO `s_address` VALUES ('798', '65', '科尔沁左翼中旗', '3', '', null);
INSERT INTO `s_address` VALUES ('799', '65', '科尔沁左翼后旗', '3', '', null);
INSERT INTO `s_address` VALUES ('800', '65', '开鲁县', '3', '', null);
INSERT INTO `s_address` VALUES ('801', '65', '库伦旗', '3', '', null);
INSERT INTO `s_address` VALUES ('802', '65', '奈曼旗', '3', '', null);
INSERT INTO `s_address` VALUES ('803', '65', '扎鲁特旗', '3', '', null);
INSERT INTO `s_address` VALUES ('804', '65', '霍林郭勒市', '3', '', null);
INSERT INTO `s_address` VALUES ('805', '65', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('806', '66', '东胜区', '3', '', null);
INSERT INTO `s_address` VALUES ('807', '66', '达拉特旗', '3', '', null);
INSERT INTO `s_address` VALUES ('808', '66', '准格尔旗', '3', '', null);
INSERT INTO `s_address` VALUES ('809', '66', '鄂托克前旗', '3', '', null);
INSERT INTO `s_address` VALUES ('810', '66', '鄂托克旗', '3', '', null);
INSERT INTO `s_address` VALUES ('811', '66', '杭锦旗', '3', '', null);
INSERT INTO `s_address` VALUES ('812', '66', '乌审旗', '3', '', null);
INSERT INTO `s_address` VALUES ('813', '66', '伊金霍洛旗', '3', '', null);
INSERT INTO `s_address` VALUES ('814', '66', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('815', '67', '海拉尔区', '3', '', null);
INSERT INTO `s_address` VALUES ('816', '67', '扎赉诺尔区', '3', '', null);
INSERT INTO `s_address` VALUES ('817', '67', '阿荣旗', '3', '', null);
INSERT INTO `s_address` VALUES ('818', '67', '莫力达瓦达斡尔族自治旗', '3', '', null);
INSERT INTO `s_address` VALUES ('819', '67', '鄂伦春自治旗', '3', '', null);
INSERT INTO `s_address` VALUES ('820', '67', '鄂温克族自治旗', '3', '', null);
INSERT INTO `s_address` VALUES ('821', '67', '陈巴尔虎旗', '3', '', null);
INSERT INTO `s_address` VALUES ('822', '67', '新巴尔虎左旗', '3', '', null);
INSERT INTO `s_address` VALUES ('823', '67', '新巴尔虎右旗', '3', '', null);
INSERT INTO `s_address` VALUES ('824', '67', '满洲里市', '3', '', null);
INSERT INTO `s_address` VALUES ('825', '67', '牙克石市', '3', '', null);
INSERT INTO `s_address` VALUES ('826', '67', '扎兰屯市', '3', '', null);
INSERT INTO `s_address` VALUES ('827', '67', '额尔古纳市', '3', '', null);
INSERT INTO `s_address` VALUES ('828', '67', '根河市', '3', '', null);
INSERT INTO `s_address` VALUES ('829', '67', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('830', '68', '临河区', '3', '', null);
INSERT INTO `s_address` VALUES ('831', '68', '五原县', '3', '', null);
INSERT INTO `s_address` VALUES ('832', '68', '磴口县', '3', '', null);
INSERT INTO `s_address` VALUES ('833', '68', '乌拉特前旗', '3', '', null);
INSERT INTO `s_address` VALUES ('834', '68', '乌拉特中旗', '3', '', null);
INSERT INTO `s_address` VALUES ('835', '68', '乌拉特后旗', '3', '', null);
INSERT INTO `s_address` VALUES ('836', '68', '杭锦后旗', '3', '', null);
INSERT INTO `s_address` VALUES ('837', '68', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('838', '69', '集宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('839', '69', '卓资县', '3', '', null);
INSERT INTO `s_address` VALUES ('840', '69', '化德县', '3', '', null);
INSERT INTO `s_address` VALUES ('841', '69', '商都县', '3', '', null);
INSERT INTO `s_address` VALUES ('842', '69', '兴和县', '3', '', null);
INSERT INTO `s_address` VALUES ('843', '69', '凉城县', '3', '', null);
INSERT INTO `s_address` VALUES ('844', '69', '察哈尔右翼前旗', '3', '', null);
INSERT INTO `s_address` VALUES ('845', '69', '察哈尔右翼中旗', '3', '', null);
INSERT INTO `s_address` VALUES ('846', '69', '察哈尔右翼后旗', '3', '', null);
INSERT INTO `s_address` VALUES ('847', '69', '四子王旗', '3', '', null);
INSERT INTO `s_address` VALUES ('848', '69', '丰镇市', '3', '', null);
INSERT INTO `s_address` VALUES ('849', '69', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('850', '70', '乌兰浩特市', '3', '', null);
INSERT INTO `s_address` VALUES ('851', '70', '阿尔山市', '3', '', null);
INSERT INTO `s_address` VALUES ('852', '70', '科尔沁右翼前旗', '3', '', null);
INSERT INTO `s_address` VALUES ('853', '70', '科尔沁右翼中旗', '3', '', null);
INSERT INTO `s_address` VALUES ('854', '70', '扎赉特旗', '3', '', null);
INSERT INTO `s_address` VALUES ('855', '70', '突泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('856', '70', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('857', '71', '二连浩特市', '3', '', null);
INSERT INTO `s_address` VALUES ('858', '71', '锡林浩特市', '3', '', null);
INSERT INTO `s_address` VALUES ('859', '71', '阿巴嘎旗', '3', '', null);
INSERT INTO `s_address` VALUES ('860', '71', '苏尼特左旗', '3', '', null);
INSERT INTO `s_address` VALUES ('861', '71', '苏尼特右旗', '3', '', null);
INSERT INTO `s_address` VALUES ('862', '71', '东乌珠穆沁旗', '3', '', null);
INSERT INTO `s_address` VALUES ('863', '71', '西乌珠穆沁旗', '3', '', null);
INSERT INTO `s_address` VALUES ('864', '71', '太仆寺旗', '3', '', null);
INSERT INTO `s_address` VALUES ('865', '71', '镶黄旗', '3', '', null);
INSERT INTO `s_address` VALUES ('866', '71', '正镶白旗', '3', '', null);
INSERT INTO `s_address` VALUES ('867', '71', '正蓝旗', '3', '', null);
INSERT INTO `s_address` VALUES ('868', '71', '多伦县', '3', '', null);
INSERT INTO `s_address` VALUES ('869', '71', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('870', '72', '阿拉善左旗', '3', '', null);
INSERT INTO `s_address` VALUES ('871', '72', '阿拉善右旗', '3', '', null);
INSERT INTO `s_address` VALUES ('872', '72', '额济纳旗', '3', '', null);
INSERT INTO `s_address` VALUES ('873', '72', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('874', '73', '和平区', '3', '', null);
INSERT INTO `s_address` VALUES ('875', '73', '沈河区', '3', '', null);
INSERT INTO `s_address` VALUES ('876', '73', '大东区', '3', '', null);
INSERT INTO `s_address` VALUES ('877', '73', '皇姑区', '3', '', null);
INSERT INTO `s_address` VALUES ('878', '73', '铁西区', '3', '', null);
INSERT INTO `s_address` VALUES ('879', '73', '苏家屯区', '3', '', null);
INSERT INTO `s_address` VALUES ('880', '73', '浑南区', '3', '', null);
INSERT INTO `s_address` VALUES ('881', '73', '新城子区', '3', '', null);
INSERT INTO `s_address` VALUES ('882', '73', '于洪区', '3', '', null);
INSERT INTO `s_address` VALUES ('883', '73', '辽中县', '3', '', null);
INSERT INTO `s_address` VALUES ('884', '73', '康平县', '3', '', null);
INSERT INTO `s_address` VALUES ('885', '73', '法库县', '3', '', null);
INSERT INTO `s_address` VALUES ('886', '73', '新民市', '3', '', null);
INSERT INTO `s_address` VALUES ('887', '73', '浑南新区', '3', '', null);
INSERT INTO `s_address` VALUES ('888', '73', '张士开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('889', '73', '沈北新区', '3', '', null);
INSERT INTO `s_address` VALUES ('890', '73', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('891', '74', '中山区', '3', '', null);
INSERT INTO `s_address` VALUES ('892', '74', '西岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('893', '74', '沙河口区', '3', '', null);
INSERT INTO `s_address` VALUES ('894', '74', '甘井子区', '3', '', null);
INSERT INTO `s_address` VALUES ('895', '74', '旅顺口区', '3', '', null);
INSERT INTO `s_address` VALUES ('896', '74', '金州区', '3', '', null);
INSERT INTO `s_address` VALUES ('897', '74', '长海县', '3', '', null);
INSERT INTO `s_address` VALUES ('898', '74', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('899', '74', '瓦房店市', '3', '', null);
INSERT INTO `s_address` VALUES ('900', '74', '普兰店市', '3', '', null);
INSERT INTO `s_address` VALUES ('901', '74', '庄河市', '3', '', null);
INSERT INTO `s_address` VALUES ('902', '74', '岭前区', '3', '', null);
INSERT INTO `s_address` VALUES ('903', '74', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('904', '75', '铁东区', '3', '', null);
INSERT INTO `s_address` VALUES ('905', '75', '铁西区', '3', '', null);
INSERT INTO `s_address` VALUES ('906', '75', '立山区', '3', '', null);
INSERT INTO `s_address` VALUES ('907', '75', '千山区', '3', '', null);
INSERT INTO `s_address` VALUES ('908', '75', '台安县', '3', '', null);
INSERT INTO `s_address` VALUES ('909', '75', '岫岩满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('910', '75', '高新区', '3', '', null);
INSERT INTO `s_address` VALUES ('911', '75', '海城市', '3', '', null);
INSERT INTO `s_address` VALUES ('912', '75', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('913', '76', '新抚区', '3', '', null);
INSERT INTO `s_address` VALUES ('914', '76', '东洲区', '3', '', null);
INSERT INTO `s_address` VALUES ('915', '76', '望花区', '3', '', null);
INSERT INTO `s_address` VALUES ('916', '76', '顺城区', '3', '', null);
INSERT INTO `s_address` VALUES ('917', '76', '抚顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('918', '76', '新宾满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('919', '76', '清原满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('920', '76', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('921', '77', '平山区', '3', '', null);
INSERT INTO `s_address` VALUES ('922', '77', '溪湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('923', '77', '明山区', '3', '', null);
INSERT INTO `s_address` VALUES ('924', '77', '南芬区', '3', '', null);
INSERT INTO `s_address` VALUES ('925', '77', '本溪满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('926', '77', '桓仁满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('927', '77', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('928', '78', '元宝区', '3', '', null);
INSERT INTO `s_address` VALUES ('929', '78', '振兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('930', '78', '振安区', '3', '', null);
INSERT INTO `s_address` VALUES ('931', '78', '宽甸满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('932', '78', '东港市', '3', '', null);
INSERT INTO `s_address` VALUES ('933', '78', '凤城市', '3', '', null);
INSERT INTO `s_address` VALUES ('934', '78', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('935', '79', '古塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('936', '79', '凌河区', '3', '', null);
INSERT INTO `s_address` VALUES ('937', '79', '太和区', '3', '', null);
INSERT INTO `s_address` VALUES ('938', '79', '黑山县', '3', '', null);
INSERT INTO `s_address` VALUES ('939', '79', '义县', '3', '', null);
INSERT INTO `s_address` VALUES ('940', '79', '凌海市', '3', '', null);
INSERT INTO `s_address` VALUES ('941', '79', '北镇市', '3', '', null);
INSERT INTO `s_address` VALUES ('942', '79', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('943', '80', '站前区', '3', '', null);
INSERT INTO `s_address` VALUES ('944', '80', '西市区', '3', '', null);
INSERT INTO `s_address` VALUES ('945', '80', '鲅鱼圈区', '3', '', null);
INSERT INTO `s_address` VALUES ('946', '80', '老边区', '3', '', null);
INSERT INTO `s_address` VALUES ('947', '80', '盖州市', '3', '', null);
INSERT INTO `s_address` VALUES ('948', '80', '大石桥市', '3', '', null);
INSERT INTO `s_address` VALUES ('949', '80', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('950', '81', '海州区', '3', '', null);
INSERT INTO `s_address` VALUES ('951', '81', '新邱区', '3', '', null);
INSERT INTO `s_address` VALUES ('952', '81', '太平区', '3', '', null);
INSERT INTO `s_address` VALUES ('953', '81', '清河门区', '3', '', null);
INSERT INTO `s_address` VALUES ('954', '81', '细河区', '3', '', null);
INSERT INTO `s_address` VALUES ('955', '81', '阜新蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('956', '81', '彰武县', '3', '', null);
INSERT INTO `s_address` VALUES ('957', '81', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('958', '82', '白塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('959', '82', '文圣区', '3', '', null);
INSERT INTO `s_address` VALUES ('960', '82', '宏伟区', '3', '', null);
INSERT INTO `s_address` VALUES ('961', '82', '弓长岭区', '3', '', null);
INSERT INTO `s_address` VALUES ('962', '82', '太子河区', '3', '', null);
INSERT INTO `s_address` VALUES ('963', '82', '辽阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('964', '82', '灯塔市', '3', '', null);
INSERT INTO `s_address` VALUES ('965', '82', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('966', '83', '双台子区', '3', '', null);
INSERT INTO `s_address` VALUES ('967', '83', '兴隆台区', '3', '', null);
INSERT INTO `s_address` VALUES ('968', '83', '大洼县', '3', '', null);
INSERT INTO `s_address` VALUES ('969', '83', '盘山县', '3', '', null);
INSERT INTO `s_address` VALUES ('970', '83', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('971', '84', '银州区', '3', '', null);
INSERT INTO `s_address` VALUES ('972', '84', '清河区', '3', '', null);
INSERT INTO `s_address` VALUES ('973', '84', '铁岭县', '3', '', null);
INSERT INTO `s_address` VALUES ('974', '84', '西丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('975', '84', '昌图县', '3', '', null);
INSERT INTO `s_address` VALUES ('976', '84', '调兵山市', '3', '', null);
INSERT INTO `s_address` VALUES ('977', '84', '开原市', '3', '', null);
INSERT INTO `s_address` VALUES ('978', '84', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('979', '85', '双塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('980', '85', '龙城区', '3', '', null);
INSERT INTO `s_address` VALUES ('981', '85', '朝阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('982', '85', '建平县', '3', '', null);
INSERT INTO `s_address` VALUES ('983', '85', '喀喇沁左翼蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('984', '85', '北票市', '3', '', null);
INSERT INTO `s_address` VALUES ('985', '85', '凌源市', '3', '', null);
INSERT INTO `s_address` VALUES ('986', '85', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('987', '86', '连山区', '3', '', null);
INSERT INTO `s_address` VALUES ('988', '86', '龙港区', '3', '', null);
INSERT INTO `s_address` VALUES ('989', '86', '南票区', '3', '', null);
INSERT INTO `s_address` VALUES ('990', '86', '绥中县', '3', '', null);
INSERT INTO `s_address` VALUES ('991', '86', '建昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('992', '86', '兴城市', '3', '', null);
INSERT INTO `s_address` VALUES ('993', '86', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('994', '87', '南关区', '3', '', null);
INSERT INTO `s_address` VALUES ('995', '87', '宽城区', '3', '', null);
INSERT INTO `s_address` VALUES ('996', '87', '朝阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('997', '87', '二道区', '3', '', null);
INSERT INTO `s_address` VALUES ('998', '87', '绿园区', '3', '', null);
INSERT INTO `s_address` VALUES ('999', '87', '双阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1000', '87', '农安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1001', '87', '九台区', '3', '', null);
INSERT INTO `s_address` VALUES ('1002', '87', '榆树市', '3', '', null);
INSERT INTO `s_address` VALUES ('1003', '87', '德惠市', '3', '', null);
INSERT INTO `s_address` VALUES ('1004', '87', '高新技术产业开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1005', '87', '汽车产业开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1006', '87', '经济技术开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1007', '87', '净月旅游开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1008', '87', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1009', '88', '昌邑区', '3', '', null);
INSERT INTO `s_address` VALUES ('1010', '88', '龙潭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1011', '88', '船营区', '3', '', null);
INSERT INTO `s_address` VALUES ('1012', '88', '丰满区', '3', '', null);
INSERT INTO `s_address` VALUES ('1013', '88', '永吉县', '3', '', null);
INSERT INTO `s_address` VALUES ('1014', '88', '蛟河市', '3', '', null);
INSERT INTO `s_address` VALUES ('1015', '88', '桦甸市', '3', '', null);
INSERT INTO `s_address` VALUES ('1016', '88', '舒兰市', '3', '', null);
INSERT INTO `s_address` VALUES ('1017', '88', '磐石市', '3', '', null);
INSERT INTO `s_address` VALUES ('1018', '88', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1019', '89', '铁西区', '3', '', null);
INSERT INTO `s_address` VALUES ('1020', '89', '铁东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1021', '89', '梨树县', '3', '', null);
INSERT INTO `s_address` VALUES ('1022', '89', '伊通满族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('1023', '89', '公主岭市', '3', '', null);
INSERT INTO `s_address` VALUES ('1024', '89', '双辽市', '3', '', null);
INSERT INTO `s_address` VALUES ('1025', '89', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1026', '90', '龙山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1027', '90', '西安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1028', '90', '东丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1029', '90', '东辽县', '3', '', null);
INSERT INTO `s_address` VALUES ('1030', '90', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1031', '91', '东昌区', '3', '', null);
INSERT INTO `s_address` VALUES ('1032', '91', '二道江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1033', '91', '通化县', '3', '', null);
INSERT INTO `s_address` VALUES ('1034', '91', '辉南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1035', '91', '柳河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1036', '91', '梅河口市', '3', '', null);
INSERT INTO `s_address` VALUES ('1037', '91', '集安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1038', '91', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1039', '92', '浑江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1040', '92', '抚松县', '3', '', null);
INSERT INTO `s_address` VALUES ('1041', '92', '靖宇县', '3', '', null);
INSERT INTO `s_address` VALUES ('1042', '92', '长白朝鲜族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('1043', '92', '江源区', '3', '', null);
INSERT INTO `s_address` VALUES ('1044', '92', '临江市', '3', '', null);
INSERT INTO `s_address` VALUES ('1045', '92', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1046', '93', '宁江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1047', '93', '前郭尔罗斯蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('1048', '93', '长岭县', '3', '', null);
INSERT INTO `s_address` VALUES ('1049', '93', '乾安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1050', '93', '扶余市', '3', '', null);
INSERT INTO `s_address` VALUES ('1051', '93', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1052', '94', '洮北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1053', '94', '镇赉县', '3', '', null);
INSERT INTO `s_address` VALUES ('1054', '94', '通榆县', '3', '', null);
INSERT INTO `s_address` VALUES ('1055', '94', '洮南市', '3', '', null);
INSERT INTO `s_address` VALUES ('1056', '94', '大安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1057', '94', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1058', '95', '延吉市', '3', '', null);
INSERT INTO `s_address` VALUES ('1059', '95', '图们市', '3', '', null);
INSERT INTO `s_address` VALUES ('1060', '95', '敦化市', '3', '', null);
INSERT INTO `s_address` VALUES ('1061', '95', '珲春市', '3', '', null);
INSERT INTO `s_address` VALUES ('1062', '95', '龙井市', '3', '', null);
INSERT INTO `s_address` VALUES ('1063', '95', '和龙市', '3', '', null);
INSERT INTO `s_address` VALUES ('1064', '95', '汪清县', '3', '', null);
INSERT INTO `s_address` VALUES ('1065', '95', '安图县', '3', '', null);
INSERT INTO `s_address` VALUES ('1066', '95', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1067', '96', '道里区', '3', '', null);
INSERT INTO `s_address` VALUES ('1068', '96', '南岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('1069', '96', '道外区', '3', '', null);
INSERT INTO `s_address` VALUES ('1070', '96', '香坊区', '3', '', null);
INSERT INTO `s_address` VALUES ('1071', '96', '动力区', '3', '', null);
INSERT INTO `s_address` VALUES ('1072', '96', '平房区', '3', '', null);
INSERT INTO `s_address` VALUES ('1073', '96', '松北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1074', '96', '呼兰区', '3', '', null);
INSERT INTO `s_address` VALUES ('1075', '96', '依兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1076', '96', '方正县', '3', '', null);
INSERT INTO `s_address` VALUES ('1077', '96', '宾县', '3', '', null);
INSERT INTO `s_address` VALUES ('1078', '96', '巴彦县', '3', '', null);
INSERT INTO `s_address` VALUES ('1079', '96', '木兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1080', '96', '通河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1081', '96', '延寿县', '3', '', null);
INSERT INTO `s_address` VALUES ('1082', '96', '阿城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1083', '96', '双城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1084', '96', '尚志市', '3', '', null);
INSERT INTO `s_address` VALUES ('1085', '96', '五常市', '3', '', null);
INSERT INTO `s_address` VALUES ('1086', '96', '阿城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1087', '96', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1088', '97', '龙沙区', '3', '', null);
INSERT INTO `s_address` VALUES ('1089', '97', '建华区', '3', '', null);
INSERT INTO `s_address` VALUES ('1090', '97', '铁锋区', '3', '', null);
INSERT INTO `s_address` VALUES ('1091', '97', '昂昂溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('1092', '97', '富拉尔基区', '3', '', null);
INSERT INTO `s_address` VALUES ('1093', '97', '碾子山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1094', '97', '梅里斯达斡尔族区', '3', '', null);
INSERT INTO `s_address` VALUES ('1095', '97', '龙江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1096', '97', '依安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1097', '97', '泰来县', '3', '', null);
INSERT INTO `s_address` VALUES ('1098', '97', '甘南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1099', '97', '富裕县', '3', '', null);
INSERT INTO `s_address` VALUES ('1100', '97', '克山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1101', '97', '克东县', '3', '', null);
INSERT INTO `s_address` VALUES ('1102', '97', '拜泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('1103', '97', '讷河市', '3', '', null);
INSERT INTO `s_address` VALUES ('1104', '97', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1105', '98', '鸡冠区', '3', '', null);
INSERT INTO `s_address` VALUES ('1106', '98', '恒山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1107', '98', '滴道区', '3', '', null);
INSERT INTO `s_address` VALUES ('1108', '98', '梨树区', '3', '', null);
INSERT INTO `s_address` VALUES ('1109', '98', '城子河区', '3', '', null);
INSERT INTO `s_address` VALUES ('1110', '98', '麻山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1111', '98', '鸡东县', '3', '', null);
INSERT INTO `s_address` VALUES ('1112', '98', '虎林市', '3', '', null);
INSERT INTO `s_address` VALUES ('1113', '98', '密山市', '3', '', null);
INSERT INTO `s_address` VALUES ('1114', '98', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1115', '99', '向阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1116', '99', '工农区', '3', '', null);
INSERT INTO `s_address` VALUES ('1117', '99', '南山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1118', '99', '兴安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1119', '99', '东山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1120', '99', '兴山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1121', '99', '萝北县', '3', '', null);
INSERT INTO `s_address` VALUES ('1122', '99', '绥滨县', '3', '', null);
INSERT INTO `s_address` VALUES ('1123', '99', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1124', '100', '尖山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1125', '100', '岭东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1126', '100', '四方台区', '3', '', null);
INSERT INTO `s_address` VALUES ('1127', '100', '宝山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1128', '100', '集贤县', '3', '', null);
INSERT INTO `s_address` VALUES ('1129', '100', '友谊县', '3', '', null);
INSERT INTO `s_address` VALUES ('1130', '100', '宝清县', '3', '', null);
INSERT INTO `s_address` VALUES ('1131', '100', '饶河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1132', '100', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1133', '101', '萨尔图区', '3', '', null);
INSERT INTO `s_address` VALUES ('1134', '101', '龙凤区', '3', '', null);
INSERT INTO `s_address` VALUES ('1135', '101', '让胡路区', '3', '', null);
INSERT INTO `s_address` VALUES ('1136', '101', '红岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('1137', '101', '大同区', '3', '', null);
INSERT INTO `s_address` VALUES ('1138', '101', '肇州县', '3', '', null);
INSERT INTO `s_address` VALUES ('1139', '101', '肇源县', '3', '', null);
INSERT INTO `s_address` VALUES ('1140', '101', '林甸县', '3', '', null);
INSERT INTO `s_address` VALUES ('1141', '101', '杜尔伯特蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('1142', '101', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1143', '102', '伊春区', '3', '', null);
INSERT INTO `s_address` VALUES ('1144', '102', '南岔区', '3', '', null);
INSERT INTO `s_address` VALUES ('1145', '102', '友好区', '3', '', null);
INSERT INTO `s_address` VALUES ('1146', '102', '西林区', '3', '', null);
INSERT INTO `s_address` VALUES ('1147', '102', '翠峦区', '3', '', null);
INSERT INTO `s_address` VALUES ('1148', '102', '新青区', '3', '', null);
INSERT INTO `s_address` VALUES ('1149', '102', '美溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('1150', '102', '金山屯区', '3', '', null);
INSERT INTO `s_address` VALUES ('1151', '102', '五营区', '3', '', null);
INSERT INTO `s_address` VALUES ('1152', '102', '乌马河区', '3', '', null);
INSERT INTO `s_address` VALUES ('1153', '102', '汤旺河区', '3', '', null);
INSERT INTO `s_address` VALUES ('1154', '102', '带岭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1155', '102', '乌伊岭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1156', '102', '红星区', '3', '', null);
INSERT INTO `s_address` VALUES ('1157', '102', '上甘岭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1158', '102', '嘉荫县', '3', '', null);
INSERT INTO `s_address` VALUES ('1159', '102', '铁力市', '3', '', null);
INSERT INTO `s_address` VALUES ('1160', '102', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1161', '103', '永红区', '3', '', null);
INSERT INTO `s_address` VALUES ('1162', '103', '向阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1163', '103', '前进区', '3', '', null);
INSERT INTO `s_address` VALUES ('1164', '103', '东风区', '3', '', null);
INSERT INTO `s_address` VALUES ('1165', '103', '郊区', '3', '', null);
INSERT INTO `s_address` VALUES ('1166', '103', '桦南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1167', '103', '桦川县', '3', '', null);
INSERT INTO `s_address` VALUES ('1168', '103', '汤原县', '3', '', null);
INSERT INTO `s_address` VALUES ('1169', '103', '抚远县', '3', '', null);
INSERT INTO `s_address` VALUES ('1170', '103', '同江市', '3', '', null);
INSERT INTO `s_address` VALUES ('1171', '103', '富锦市', '3', '', null);
INSERT INTO `s_address` VALUES ('1172', '103', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1173', '104', '新兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('1174', '104', '桃山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1175', '104', '茄子河区', '3', '', null);
INSERT INTO `s_address` VALUES ('1176', '104', '勃利县', '3', '', null);
INSERT INTO `s_address` VALUES ('1177', '104', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1178', '105', '东安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1179', '105', '阳明区', '3', '', null);
INSERT INTO `s_address` VALUES ('1180', '105', '爱民区', '3', '', null);
INSERT INTO `s_address` VALUES ('1181', '105', '西安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1182', '105', '东宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1183', '105', '林口县', '3', '', null);
INSERT INTO `s_address` VALUES ('1184', '105', '绥芬河市', '3', '', null);
INSERT INTO `s_address` VALUES ('1185', '105', '海林市', '3', '', null);
INSERT INTO `s_address` VALUES ('1186', '105', '宁安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1187', '105', '穆棱市', '3', '', null);
INSERT INTO `s_address` VALUES ('1188', '105', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1189', '106', '爱辉区', '3', '', null);
INSERT INTO `s_address` VALUES ('1190', '106', '嫩江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1191', '106', '逊克县', '3', '', null);
INSERT INTO `s_address` VALUES ('1192', '106', '孙吴县', '3', '', null);
INSERT INTO `s_address` VALUES ('1193', '106', '北安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1194', '106', '五大连池市', '3', '', null);
INSERT INTO `s_address` VALUES ('1195', '106', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1196', '107', '北林区', '3', '', null);
INSERT INTO `s_address` VALUES ('1197', '107', '望奎县', '3', '', null);
INSERT INTO `s_address` VALUES ('1198', '107', '兰西县', '3', '', null);
INSERT INTO `s_address` VALUES ('1199', '107', '青冈县', '3', '', null);
INSERT INTO `s_address` VALUES ('1200', '107', '庆安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1201', '107', '明水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1202', '107', '绥棱县', '3', '', null);
INSERT INTO `s_address` VALUES ('1203', '107', '安达市', '3', '', null);
INSERT INTO `s_address` VALUES ('1204', '107', '肇东市', '3', '', null);
INSERT INTO `s_address` VALUES ('1205', '107', '海伦市', '3', '', null);
INSERT INTO `s_address` VALUES ('1206', '107', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1207', '108', '松岭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1208', '108', '新林区', '3', '', null);
INSERT INTO `s_address` VALUES ('1209', '108', '呼中区', '3', '', null);
INSERT INTO `s_address` VALUES ('1210', '108', '呼玛县', '3', '', null);
INSERT INTO `s_address` VALUES ('1211', '108', '塔河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1212', '108', '漠河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1213', '108', '加格达奇区', '3', '', null);
INSERT INTO `s_address` VALUES ('1214', '108', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1215', '109', '黄浦区', '3', '', null);
INSERT INTO `s_address` VALUES ('1216', '109', '卢湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('1217', '109', '徐汇区', '3', '', null);
INSERT INTO `s_address` VALUES ('1218', '109', '长宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('1219', '109', '静安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1220', '109', '普陀区', '3', '', null);
INSERT INTO `s_address` VALUES ('1221', '109', '闸北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1222', '109', '虹口区', '3', '', null);
INSERT INTO `s_address` VALUES ('1223', '109', '杨浦区', '3', '', null);
INSERT INTO `s_address` VALUES ('1224', '109', '闵行区', '3', '', null);
INSERT INTO `s_address` VALUES ('1225', '109', '宝山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1226', '109', '嘉定区', '3', '', null);
INSERT INTO `s_address` VALUES ('1227', '109', '浦东新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1228', '109', '金山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1229', '109', '松江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1230', '109', '青浦区', '3', '', null);
INSERT INTO `s_address` VALUES ('1231', '109', '南汇区', '3', '', null);
INSERT INTO `s_address` VALUES ('1232', '109', '奉贤区', '3', '', null);
INSERT INTO `s_address` VALUES ('1233', '109', '川沙区', '3', '', null);
INSERT INTO `s_address` VALUES ('1234', '109', '崇明县', '3', '', null);
INSERT INTO `s_address` VALUES ('1235', '109', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1236', '110', '玄武区', '3', '', null);
INSERT INTO `s_address` VALUES ('1237', '110', '白下区', '3', '', null);
INSERT INTO `s_address` VALUES ('1238', '110', '秦淮区', '3', '', null);
INSERT INTO `s_address` VALUES ('1239', '110', '建邺区', '3', '', null);
INSERT INTO `s_address` VALUES ('1240', '110', '鼓楼区', '3', '', null);
INSERT INTO `s_address` VALUES ('1241', '110', '下关区', '3', '', null);
INSERT INTO `s_address` VALUES ('1242', '110', '浦口区', '3', '', null);
INSERT INTO `s_address` VALUES ('1243', '110', '栖霞区', '3', '', null);
INSERT INTO `s_address` VALUES ('1244', '110', '雨花台区', '3', '', null);
INSERT INTO `s_address` VALUES ('1245', '110', '江宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('1246', '110', '六合区', '3', '', null);
INSERT INTO `s_address` VALUES ('1247', '110', '溧水区', '3', '', null);
INSERT INTO `s_address` VALUES ('1248', '110', '高淳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1249', '110', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1250', '111', '崇安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1251', '111', '南长区', '3', '', null);
INSERT INTO `s_address` VALUES ('1252', '111', '北塘区', '3', '', null);
INSERT INTO `s_address` VALUES ('1253', '111', '锡山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1254', '111', '惠山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1255', '111', '滨湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1256', '111', '江阴市', '3', '', null);
INSERT INTO `s_address` VALUES ('1257', '111', '宜兴市', '3', '', null);
INSERT INTO `s_address` VALUES ('1258', '111', '新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1259', '111', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1260', '112', '鼓楼区', '3', '', null);
INSERT INTO `s_address` VALUES ('1261', '112', '云龙区', '3', '', null);
INSERT INTO `s_address` VALUES ('1262', '112', '九里区', '3', '', null);
INSERT INTO `s_address` VALUES ('1263', '112', '贾汪区', '3', '', null);
INSERT INTO `s_address` VALUES ('1264', '112', '泉山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1265', '112', '丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1266', '112', '沛县', '3', '', null);
INSERT INTO `s_address` VALUES ('1267', '112', '铜山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1268', '112', '睢宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1269', '112', '新沂市', '3', '', null);
INSERT INTO `s_address` VALUES ('1270', '112', '邳州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1271', '112', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1272', '113', '天宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('1273', '113', '钟楼区', '3', '', null);
INSERT INTO `s_address` VALUES ('1274', '113', '戚墅堰区', '3', '', null);
INSERT INTO `s_address` VALUES ('1275', '113', '新北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1276', '113', '武进区', '3', '', null);
INSERT INTO `s_address` VALUES ('1277', '113', '溧阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('1278', '113', '金坛市', '3', '', null);
INSERT INTO `s_address` VALUES ('1279', '113', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1280', '114', '沧浪区', '3', '', null);
INSERT INTO `s_address` VALUES ('1281', '114', '平江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1282', '114', '金阊区', '3', '', null);
INSERT INTO `s_address` VALUES ('1283', '114', '虎丘区', '3', '', null);
INSERT INTO `s_address` VALUES ('1284', '114', '吴中区', '3', '', null);
INSERT INTO `s_address` VALUES ('1285', '114', '相城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1286', '114', '姑苏区', '3', '', null);
INSERT INTO `s_address` VALUES ('1287', '114', '常熟市', '3', '', null);
INSERT INTO `s_address` VALUES ('1288', '114', '张家港市', '3', '', null);
INSERT INTO `s_address` VALUES ('1289', '114', '昆山市', '3', '', null);
INSERT INTO `s_address` VALUES ('1290', '114', '吴江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1291', '114', '太仓市', '3', '', null);
INSERT INTO `s_address` VALUES ('1292', '114', '新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1293', '114', '园区', '3', '', null);
INSERT INTO `s_address` VALUES ('1294', '114', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1295', '115', '崇川区', '3', '', null);
INSERT INTO `s_address` VALUES ('1296', '115', '港闸区', '3', '', null);
INSERT INTO `s_address` VALUES ('1297', '115', '通州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1298', '115', '海安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1299', '115', '如东县', '3', '', null);
INSERT INTO `s_address` VALUES ('1300', '115', '启东市', '3', '', null);
INSERT INTO `s_address` VALUES ('1301', '115', '如皋市', '3', '', null);
INSERT INTO `s_address` VALUES ('1302', '115', '通州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1303', '115', '海门市', '3', '', null);
INSERT INTO `s_address` VALUES ('1304', '115', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1305', '115', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1306', '116', '连云区', '3', '', null);
INSERT INTO `s_address` VALUES ('1307', '116', '新浦区', '3', '', null);
INSERT INTO `s_address` VALUES ('1308', '116', '海州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1309', '116', '赣榆区', '3', '', null);
INSERT INTO `s_address` VALUES ('1310', '116', '东海县', '3', '', null);
INSERT INTO `s_address` VALUES ('1311', '116', '灌云县', '3', '', null);
INSERT INTO `s_address` VALUES ('1312', '116', '灌南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1313', '116', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1314', '117', '清河区', '3', '', null);
INSERT INTO `s_address` VALUES ('1315', '117', '淮安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1316', '117', '淮阴区', '3', '', null);
INSERT INTO `s_address` VALUES ('1317', '117', '清浦区', '3', '', null);
INSERT INTO `s_address` VALUES ('1318', '117', '涟水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1319', '117', '洪泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('1320', '117', '盱眙县', '3', '', null);
INSERT INTO `s_address` VALUES ('1321', '117', '金湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('1322', '117', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1323', '118', '亭湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1324', '118', '盐都区', '3', '', null);
INSERT INTO `s_address` VALUES ('1325', '118', '响水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1326', '118', '滨海县', '3', '', null);
INSERT INTO `s_address` VALUES ('1327', '118', '阜宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1328', '118', '射阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1329', '118', '建湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('1330', '118', '东台市', '3', '', null);
INSERT INTO `s_address` VALUES ('1331', '118', '大丰市', '3', '', null);
INSERT INTO `s_address` VALUES ('1332', '118', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1333', '119', '广陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('1334', '119', '邗江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1335', '119', '维扬区', '3', '', null);
INSERT INTO `s_address` VALUES ('1336', '119', '宝应县', '3', '', null);
INSERT INTO `s_address` VALUES ('1337', '119', '仪征市', '3', '', null);
INSERT INTO `s_address` VALUES ('1338', '119', '高邮市', '3', '', null);
INSERT INTO `s_address` VALUES ('1339', '119', '江都区', '3', '', null);
INSERT INTO `s_address` VALUES ('1340', '119', '经济开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1341', '119', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1342', '120', '京口区', '3', '', null);
INSERT INTO `s_address` VALUES ('1343', '120', '润州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1344', '120', '丹徒区', '3', '', null);
INSERT INTO `s_address` VALUES ('1345', '120', '丹阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('1346', '120', '扬中市', '3', '', null);
INSERT INTO `s_address` VALUES ('1347', '120', '句容市', '3', '', null);
INSERT INTO `s_address` VALUES ('1348', '120', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1349', '121', '海陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('1350', '121', '高港区', '3', '', null);
INSERT INTO `s_address` VALUES ('1351', '121', '兴化市', '3', '', null);
INSERT INTO `s_address` VALUES ('1352', '121', '靖江市', '3', '', null);
INSERT INTO `s_address` VALUES ('1353', '121', '泰兴市', '3', '', null);
INSERT INTO `s_address` VALUES ('1354', '121', '姜堰区', '3', '', null);
INSERT INTO `s_address` VALUES ('1355', '121', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1356', '122', '宿城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1357', '122', '宿豫区', '3', '', null);
INSERT INTO `s_address` VALUES ('1358', '122', '沭阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1359', '122', '泗阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1360', '122', '泗洪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1361', '122', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1362', '123', '上城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1363', '123', '下城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1364', '123', '江干区', '3', '', null);
INSERT INTO `s_address` VALUES ('1365', '123', '拱墅区', '3', '', null);
INSERT INTO `s_address` VALUES ('1366', '123', '西湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1367', '123', '滨江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1368', '123', '萧山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1369', '123', '余杭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1370', '123', '桐庐县', '3', '', null);
INSERT INTO `s_address` VALUES ('1371', '123', '淳安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1372', '123', '建德市', '3', '', null);
INSERT INTO `s_address` VALUES ('1373', '123', '富阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1374', '123', '临安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1375', '123', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1376', '124', '海曙区', '3', '', null);
INSERT INTO `s_address` VALUES ('1377', '124', '江东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1378', '124', '江北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1379', '124', '北仑区', '3', '', null);
INSERT INTO `s_address` VALUES ('1380', '124', '镇海区', '3', '', null);
INSERT INTO `s_address` VALUES ('1381', '124', '鄞州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1382', '124', '象山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1383', '124', '宁海县', '3', '', null);
INSERT INTO `s_address` VALUES ('1384', '124', '余姚市', '3', '', null);
INSERT INTO `s_address` VALUES ('1385', '124', '慈溪市', '3', '', null);
INSERT INTO `s_address` VALUES ('1386', '124', '奉化市', '3', '', null);
INSERT INTO `s_address` VALUES ('1387', '124', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1388', '125', '鹿城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1389', '125', '龙湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('1390', '125', '瓯海区', '3', '', null);
INSERT INTO `s_address` VALUES ('1391', '125', '洞头县', '3', '', null);
INSERT INTO `s_address` VALUES ('1392', '125', '永嘉县', '3', '', null);
INSERT INTO `s_address` VALUES ('1393', '125', '平阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1394', '125', '苍南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1395', '125', '文成县', '3', '', null);
INSERT INTO `s_address` VALUES ('1396', '125', '泰顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('1397', '125', '瑞安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1398', '125', '乐清市', '3', '', null);
INSERT INTO `s_address` VALUES ('1399', '125', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1400', '126', '南湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1401', '126', '秀洲区', '3', '', null);
INSERT INTO `s_address` VALUES ('1402', '126', '嘉善县', '3', '', null);
INSERT INTO `s_address` VALUES ('1403', '126', '海盐县', '3', '', null);
INSERT INTO `s_address` VALUES ('1404', '126', '海宁市', '3', '', null);
INSERT INTO `s_address` VALUES ('1405', '126', '平湖市', '3', '', null);
INSERT INTO `s_address` VALUES ('1406', '126', '桐乡市', '3', '', null);
INSERT INTO `s_address` VALUES ('1407', '126', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1408', '127', '吴兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('1409', '127', '南浔区', '3', '', null);
INSERT INTO `s_address` VALUES ('1410', '127', '德清县', '3', '', null);
INSERT INTO `s_address` VALUES ('1411', '127', '长兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('1412', '127', '安吉县', '3', '', null);
INSERT INTO `s_address` VALUES ('1413', '127', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1414', '128', '越城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1415', '128', '柯桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('1416', '128', '新昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1417', '128', '诸暨市', '3', '', null);
INSERT INTO `s_address` VALUES ('1418', '128', '上虞区', '3', '', null);
INSERT INTO `s_address` VALUES ('1419', '128', '嵊州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1420', '128', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1421', '129', '婺城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1422', '129', '金东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1423', '129', '武义县', '3', '', null);
INSERT INTO `s_address` VALUES ('1424', '129', '浦江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1425', '129', '磐安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1426', '129', '兰溪市', '3', '', null);
INSERT INTO `s_address` VALUES ('1427', '129', '义乌市', '3', '', null);
INSERT INTO `s_address` VALUES ('1428', '129', '东阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('1429', '129', '永康市', '3', '', null);
INSERT INTO `s_address` VALUES ('1430', '129', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1431', '130', '柯城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1432', '130', '衢江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1433', '130', '常山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1434', '130', '开化县', '3', '', null);
INSERT INTO `s_address` VALUES ('1435', '130', '龙游县', '3', '', null);
INSERT INTO `s_address` VALUES ('1436', '130', '江山市', '3', '', null);
INSERT INTO `s_address` VALUES ('1437', '130', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1438', '131', '定海区', '3', '', null);
INSERT INTO `s_address` VALUES ('1439', '131', '普陀区', '3', '', null);
INSERT INTO `s_address` VALUES ('1440', '131', '岱山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1441', '131', '嵊泗县', '3', '', null);
INSERT INTO `s_address` VALUES ('1442', '131', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1443', '132', '椒江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1444', '132', '黄岩区', '3', '', null);
INSERT INTO `s_address` VALUES ('1445', '132', '路桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('1446', '132', '玉环县', '3', '', null);
INSERT INTO `s_address` VALUES ('1447', '132', '三门县', '3', '', null);
INSERT INTO `s_address` VALUES ('1448', '132', '天台县', '3', '', null);
INSERT INTO `s_address` VALUES ('1449', '132', '仙居县', '3', '', null);
INSERT INTO `s_address` VALUES ('1450', '132', '温岭市', '3', '', null);
INSERT INTO `s_address` VALUES ('1451', '132', '临海市', '3', '', null);
INSERT INTO `s_address` VALUES ('1452', '132', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1453', '133', '莲都区', '3', '', null);
INSERT INTO `s_address` VALUES ('1454', '133', '青田县', '3', '', null);
INSERT INTO `s_address` VALUES ('1455', '133', '缙云县', '3', '', null);
INSERT INTO `s_address` VALUES ('1456', '133', '遂昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1457', '133', '松阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1458', '133', '云和县', '3', '', null);
INSERT INTO `s_address` VALUES ('1459', '133', '庆元县', '3', '', null);
INSERT INTO `s_address` VALUES ('1460', '133', '景宁畲族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('1461', '133', '龙泉市', '3', '', null);
INSERT INTO `s_address` VALUES ('1462', '133', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1463', '134', '瑶海区', '3', '', null);
INSERT INTO `s_address` VALUES ('1464', '134', '庐阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1465', '134', '蜀山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1466', '134', '包河区', '3', '', null);
INSERT INTO `s_address` VALUES ('1467', '134', '长丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1468', '134', '肥东县', '3', '', null);
INSERT INTO `s_address` VALUES ('1469', '134', '肥西县', '3', '', null);
INSERT INTO `s_address` VALUES ('1470', '134', '高新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1471', '134', '中区', '3', '', null);
INSERT INTO `s_address` VALUES ('1472', '134', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1473', '135', '镜湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1474', '135', '弋江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1475', '135', '鸠江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1476', '135', '三山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1477', '135', '芜湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('1478', '135', '繁昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1479', '135', '南陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('1480', '135', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1481', '136', '龙子湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1482', '136', '蚌山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1483', '136', '禹会区', '3', '', null);
INSERT INTO `s_address` VALUES ('1484', '136', '淮上区', '3', '', null);
INSERT INTO `s_address` VALUES ('1485', '136', '怀远县', '3', '', null);
INSERT INTO `s_address` VALUES ('1486', '136', '五河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1487', '136', '固镇县', '3', '', null);
INSERT INTO `s_address` VALUES ('1488', '136', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1489', '137', '大通区', '3', '', null);
INSERT INTO `s_address` VALUES ('1490', '137', '田家庵区', '3', '', null);
INSERT INTO `s_address` VALUES ('1491', '137', '谢家集区', '3', '', null);
INSERT INTO `s_address` VALUES ('1492', '137', '八公山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1493', '137', '潘集区', '3', '', null);
INSERT INTO `s_address` VALUES ('1494', '137', '凤台县', '3', '', null);
INSERT INTO `s_address` VALUES ('1495', '137', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1496', '138', '金家庄区', '3', '', null);
INSERT INTO `s_address` VALUES ('1497', '138', '花山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1498', '138', '雨山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1499', '138', '博望区', '3', '', null);
INSERT INTO `s_address` VALUES ('1500', '138', '当涂县', '3', '', null);
INSERT INTO `s_address` VALUES ('1501', '138', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1502', '139', '杜集区', '3', '', null);
INSERT INTO `s_address` VALUES ('1503', '139', '相山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1504', '139', '烈山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1505', '139', '濉溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1506', '139', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1507', '140', '铜官山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1508', '140', '狮子山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1509', '140', '郊区', '3', '', null);
INSERT INTO `s_address` VALUES ('1510', '140', '铜陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('1511', '140', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1512', '141', '迎江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1513', '141', '大观区', '3', '', null);
INSERT INTO `s_address` VALUES ('1514', '141', '宜秀区', '3', '', null);
INSERT INTO `s_address` VALUES ('1515', '141', '怀宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1516', '141', '枞阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1517', '141', '潜山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1518', '141', '太湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('1519', '141', '宿松县', '3', '', null);
INSERT INTO `s_address` VALUES ('1520', '141', '望江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1521', '141', '岳西县', '3', '', null);
INSERT INTO `s_address` VALUES ('1522', '141', '桐城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1523', '141', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1524', '142', '屯溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('1525', '142', '黄山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1526', '142', '徽州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1527', '142', '歙县', '3', '', null);
INSERT INTO `s_address` VALUES ('1528', '142', '休宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1529', '142', '黟县', '3', '', null);
INSERT INTO `s_address` VALUES ('1530', '142', '祁门县', '3', '', null);
INSERT INTO `s_address` VALUES ('1531', '142', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1532', '143', '琅琊区', '3', '', null);
INSERT INTO `s_address` VALUES ('1533', '143', '南谯区', '3', '', null);
INSERT INTO `s_address` VALUES ('1534', '143', '来安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1535', '143', '全椒县', '3', '', null);
INSERT INTO `s_address` VALUES ('1536', '143', '定远县', '3', '', null);
INSERT INTO `s_address` VALUES ('1537', '143', '凤阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1538', '143', '天长市', '3', '', null);
INSERT INTO `s_address` VALUES ('1539', '143', '明光市', '3', '', null);
INSERT INTO `s_address` VALUES ('1540', '143', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1541', '144', '颍州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1542', '144', '颍东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1543', '144', '颍泉区', '3', '', null);
INSERT INTO `s_address` VALUES ('1544', '144', '临泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('1545', '144', '太和县', '3', '', null);
INSERT INTO `s_address` VALUES ('1546', '144', '阜南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1547', '144', '颍上县', '3', '', null);
INSERT INTO `s_address` VALUES ('1548', '144', '界首市', '3', '', null);
INSERT INTO `s_address` VALUES ('1549', '144', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1550', '145', '埇桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('1551', '145', '砀山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1552', '145', '萧县', '3', '', null);
INSERT INTO `s_address` VALUES ('1553', '145', '灵璧县', '3', '', null);
INSERT INTO `s_address` VALUES ('1554', '145', '泗县', '3', '', null);
INSERT INTO `s_address` VALUES ('1555', '145', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1556', '134', '巢湖市', '3', '', null);
INSERT INTO `s_address` VALUES ('1557', '134', '居巢区', '3', '', null);
INSERT INTO `s_address` VALUES ('1558', '134', '庐江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1559', '135', '无为县', '3', '', null);
INSERT INTO `s_address` VALUES ('1560', '138', '含山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1561', '138', '和县', '3', '', null);
INSERT INTO `s_address` VALUES ('1562', '146', '金安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1563', '146', '裕安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1564', '146', '寿县', '3', '', null);
INSERT INTO `s_address` VALUES ('1565', '146', '霍邱县', '3', '', null);
INSERT INTO `s_address` VALUES ('1566', '146', '舒城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1567', '146', '金寨县', '3', '', null);
INSERT INTO `s_address` VALUES ('1568', '146', '霍山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1569', '146', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1570', '147', '谯城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1571', '147', '涡阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1572', '147', '蒙城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1573', '147', '利辛县', '3', '', null);
INSERT INTO `s_address` VALUES ('1574', '147', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1575', '148', '贵池区', '3', '', null);
INSERT INTO `s_address` VALUES ('1576', '148', '东至县', '3', '', null);
INSERT INTO `s_address` VALUES ('1577', '148', '石台县', '3', '', null);
INSERT INTO `s_address` VALUES ('1578', '148', '青阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1579', '148', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1580', '149', '宣州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1581', '149', '郎溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1582', '149', '广德县', '3', '', null);
INSERT INTO `s_address` VALUES ('1583', '149', '泾县', '3', '', null);
INSERT INTO `s_address` VALUES ('1584', '149', '绩溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1585', '149', '旌德县', '3', '', null);
INSERT INTO `s_address` VALUES ('1586', '149', '宁国市', '3', '', null);
INSERT INTO `s_address` VALUES ('1587', '149', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1588', '150', '鼓楼区', '3', '', null);
INSERT INTO `s_address` VALUES ('1589', '150', '台江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1590', '150', '仓山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1591', '150', '马尾区', '3', '', null);
INSERT INTO `s_address` VALUES ('1592', '150', '晋安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1593', '150', '闽侯县', '3', '', null);
INSERT INTO `s_address` VALUES ('1594', '150', '连江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1595', '150', '罗源县', '3', '', null);
INSERT INTO `s_address` VALUES ('1596', '150', '闽清县', '3', '', null);
INSERT INTO `s_address` VALUES ('1597', '150', '永泰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1598', '150', '平潭县', '3', '', null);
INSERT INTO `s_address` VALUES ('1599', '150', '福清市', '3', '', null);
INSERT INTO `s_address` VALUES ('1600', '150', '长乐市', '3', '', null);
INSERT INTO `s_address` VALUES ('1601', '150', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1602', '151', '思明区', '3', '', null);
INSERT INTO `s_address` VALUES ('1603', '151', '海沧区', '3', '', null);
INSERT INTO `s_address` VALUES ('1604', '151', '湖里区', '3', '', null);
INSERT INTO `s_address` VALUES ('1605', '151', '集美区', '3', '', null);
INSERT INTO `s_address` VALUES ('1606', '151', '同安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1607', '151', '翔安区', '3', '', null);
INSERT INTO `s_address` VALUES ('1608', '151', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1609', '152', '城厢区', '3', '', null);
INSERT INTO `s_address` VALUES ('1610', '152', '涵江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1611', '152', '荔城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1612', '152', '秀屿区', '3', '', null);
INSERT INTO `s_address` VALUES ('1613', '152', '仙游县', '3', '', null);
INSERT INTO `s_address` VALUES ('1614', '152', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1615', '153', '梅列区', '3', '', null);
INSERT INTO `s_address` VALUES ('1616', '153', '三元区', '3', '', null);
INSERT INTO `s_address` VALUES ('1617', '153', '明溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1618', '153', '清流县', '3', '', null);
INSERT INTO `s_address` VALUES ('1619', '153', '宁化县', '3', '', null);
INSERT INTO `s_address` VALUES ('1620', '153', '大田县', '3', '', null);
INSERT INTO `s_address` VALUES ('1621', '153', '尤溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1622', '153', '沙县', '3', '', null);
INSERT INTO `s_address` VALUES ('1623', '153', '将乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('1624', '153', '泰宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1625', '153', '建宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1626', '153', '永安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1627', '153', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1628', '154', '鲤城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1629', '154', '丰泽区', '3', '', null);
INSERT INTO `s_address` VALUES ('1630', '154', '洛江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1631', '154', '泉港区', '3', '', null);
INSERT INTO `s_address` VALUES ('1632', '154', '惠安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1633', '154', '安溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1634', '154', '永春县', '3', '', null);
INSERT INTO `s_address` VALUES ('1635', '154', '德化县', '3', '', null);
INSERT INTO `s_address` VALUES ('1636', '154', '金门县', '3', '', null);
INSERT INTO `s_address` VALUES ('1637', '154', '石狮市', '3', '', null);
INSERT INTO `s_address` VALUES ('1638', '154', '晋江市', '3', '', null);
INSERT INTO `s_address` VALUES ('1639', '154', '南安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1640', '154', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1641', '155', '芗城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1642', '155', '龙文区', '3', '', null);
INSERT INTO `s_address` VALUES ('1643', '155', '云霄县', '3', '', null);
INSERT INTO `s_address` VALUES ('1644', '155', '漳浦县', '3', '', null);
INSERT INTO `s_address` VALUES ('1645', '155', '诏安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1646', '155', '长泰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1647', '155', '东山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1648', '155', '南靖县', '3', '', null);
INSERT INTO `s_address` VALUES ('1649', '155', '平和县', '3', '', null);
INSERT INTO `s_address` VALUES ('1650', '155', '华安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1651', '155', '龙海市', '3', '', null);
INSERT INTO `s_address` VALUES ('1652', '155', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1653', '156', '延平区', '3', '', null);
INSERT INTO `s_address` VALUES ('1654', '156', '顺昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1655', '156', '浦城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1656', '156', '光泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('1657', '156', '松溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1658', '156', '政和县', '3', '', null);
INSERT INTO `s_address` VALUES ('1659', '156', '邵武市', '3', '', null);
INSERT INTO `s_address` VALUES ('1660', '156', '武夷山市', '3', '', null);
INSERT INTO `s_address` VALUES ('1661', '156', '建瓯市', '3', '', null);
INSERT INTO `s_address` VALUES ('1662', '156', '建阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1663', '156', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1664', '157', '新罗区', '3', '', null);
INSERT INTO `s_address` VALUES ('1665', '157', '长汀县', '3', '', null);
INSERT INTO `s_address` VALUES ('1666', '157', '永定区', '3', '', null);
INSERT INTO `s_address` VALUES ('1667', '157', '上杭县', '3', '', null);
INSERT INTO `s_address` VALUES ('1668', '157', '武平县', '3', '', null);
INSERT INTO `s_address` VALUES ('1669', '157', '连城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1670', '157', '漳平市', '3', '', null);
INSERT INTO `s_address` VALUES ('1671', '157', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1672', '158', '蕉城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1673', '158', '霞浦县', '3', '', null);
INSERT INTO `s_address` VALUES ('1674', '158', '古田县', '3', '', null);
INSERT INTO `s_address` VALUES ('1675', '158', '屏南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1676', '158', '寿宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1677', '158', '周宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1678', '158', '柘荣县', '3', '', null);
INSERT INTO `s_address` VALUES ('1679', '158', '福安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1680', '158', '福鼎市', '3', '', null);
INSERT INTO `s_address` VALUES ('1681', '158', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1682', '159', '东湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1683', '159', '西湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1684', '159', '青云谱区', '3', '', null);
INSERT INTO `s_address` VALUES ('1685', '159', '湾里区', '3', '', null);
INSERT INTO `s_address` VALUES ('1686', '159', '青山湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1687', '159', '南昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1688', '159', '新建县', '3', '', null);
INSERT INTO `s_address` VALUES ('1689', '159', '安义县', '3', '', null);
INSERT INTO `s_address` VALUES ('1690', '159', '进贤县', '3', '', null);
INSERT INTO `s_address` VALUES ('1691', '159', '红谷滩新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1692', '159', '经济技术开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1693', '159', '昌北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1694', '159', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1695', '160', '昌江区', '3', '', null);
INSERT INTO `s_address` VALUES ('1696', '160', '珠山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1697', '160', '浮梁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1698', '160', '乐平市', '3', '', null);
INSERT INTO `s_address` VALUES ('1699', '160', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1700', '161', '安源区', '3', '', null);
INSERT INTO `s_address` VALUES ('1701', '161', '湘东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1702', '161', '莲花县', '3', '', null);
INSERT INTO `s_address` VALUES ('1703', '161', '上栗县', '3', '', null);
INSERT INTO `s_address` VALUES ('1704', '161', '芦溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1705', '161', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1706', '162', '庐山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1707', '162', '浔阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1708', '162', '九江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1709', '162', '武宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1710', '162', '修水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1711', '162', '永修县', '3', '', null);
INSERT INTO `s_address` VALUES ('1712', '162', '德安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1713', '162', '星子县', '3', '', null);
INSERT INTO `s_address` VALUES ('1714', '162', '都昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1715', '162', '湖口县', '3', '', null);
INSERT INTO `s_address` VALUES ('1716', '162', '彭泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('1717', '162', '瑞昌市', '3', '', null);
INSERT INTO `s_address` VALUES ('1718', '162', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1719', '162', '共青城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1720', '163', '渝水区', '3', '', null);
INSERT INTO `s_address` VALUES ('1721', '163', '分宜县', '3', '', null);
INSERT INTO `s_address` VALUES ('1722', '163', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1723', '164', '月湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('1724', '164', '余江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1725', '164', '贵溪市', '3', '', null);
INSERT INTO `s_address` VALUES ('1726', '164', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1727', '165', '章贡区', '3', '', null);
INSERT INTO `s_address` VALUES ('1728', '165', '赣县', '3', '', null);
INSERT INTO `s_address` VALUES ('1729', '165', '信丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1730', '165', '大余县', '3', '', null);
INSERT INTO `s_address` VALUES ('1731', '165', '上犹县', '3', '', null);
INSERT INTO `s_address` VALUES ('1732', '165', '崇义县', '3', '', null);
INSERT INTO `s_address` VALUES ('1733', '165', '安远县', '3', '', null);
INSERT INTO `s_address` VALUES ('1734', '165', '龙南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1735', '165', '定南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1736', '165', '全南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1737', '165', '宁都县', '3', '', null);
INSERT INTO `s_address` VALUES ('1738', '165', '于都县', '3', '', null);
INSERT INTO `s_address` VALUES ('1739', '165', '兴国县', '3', '', null);
INSERT INTO `s_address` VALUES ('1740', '165', '会昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1741', '165', '寻乌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1742', '165', '石城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1743', '165', '黄金区', '3', '', null);
INSERT INTO `s_address` VALUES ('1744', '165', '瑞金市', '3', '', null);
INSERT INTO `s_address` VALUES ('1745', '165', '南康区', '3', '', null);
INSERT INTO `s_address` VALUES ('1746', '165', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1747', '166', '吉州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1748', '166', '青原区', '3', '', null);
INSERT INTO `s_address` VALUES ('1749', '166', '吉安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1750', '166', '吉水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1751', '166', '峡江县', '3', '', null);
INSERT INTO `s_address` VALUES ('1752', '166', '新干县', '3', '', null);
INSERT INTO `s_address` VALUES ('1753', '166', '永丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1754', '166', '泰和县', '3', '', null);
INSERT INTO `s_address` VALUES ('1755', '166', '遂川县', '3', '', null);
INSERT INTO `s_address` VALUES ('1756', '166', '万安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1757', '166', '安福县', '3', '', null);
INSERT INTO `s_address` VALUES ('1758', '166', '永新县', '3', '', null);
INSERT INTO `s_address` VALUES ('1759', '166', '井冈山市', '3', '', null);
INSERT INTO `s_address` VALUES ('1760', '166', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1761', '167', '袁州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1762', '167', '奉新县', '3', '', null);
INSERT INTO `s_address` VALUES ('1763', '167', '万载县', '3', '', null);
INSERT INTO `s_address` VALUES ('1764', '167', '上高县', '3', '', null);
INSERT INTO `s_address` VALUES ('1765', '167', '宜丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1766', '167', '靖安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1767', '167', '铜鼓县', '3', '', null);
INSERT INTO `s_address` VALUES ('1768', '167', '丰城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1769', '167', '樟树市', '3', '', null);
INSERT INTO `s_address` VALUES ('1770', '167', '高安市', '3', '', null);
INSERT INTO `s_address` VALUES ('1771', '167', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1772', '168', '临川区', '3', '', null);
INSERT INTO `s_address` VALUES ('1773', '168', '南城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1774', '168', '黎川县', '3', '', null);
INSERT INTO `s_address` VALUES ('1775', '168', '南丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1776', '168', '崇仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1777', '168', '乐安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1778', '168', '宜黄县', '3', '', null);
INSERT INTO `s_address` VALUES ('1779', '168', '金溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1780', '168', '资溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('1781', '168', '东乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('1782', '168', '广昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('1783', '168', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1784', '169', '信州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1785', '169', '上饶县', '3', '', null);
INSERT INTO `s_address` VALUES ('1786', '169', '广丰区', '3', '', null);
INSERT INTO `s_address` VALUES ('1787', '169', '玉山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1788', '169', '铅山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1789', '169', '横峰县', '3', '', null);
INSERT INTO `s_address` VALUES ('1790', '169', '弋阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1791', '169', '余干县', '3', '', null);
INSERT INTO `s_address` VALUES ('1792', '169', '鄱阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1793', '169', '万年县', '3', '', null);
INSERT INTO `s_address` VALUES ('1794', '169', '婺源县', '3', '', null);
INSERT INTO `s_address` VALUES ('1795', '169', '德兴市', '3', '', null);
INSERT INTO `s_address` VALUES ('1796', '169', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1797', '170', '历下区', '3', '', null);
INSERT INTO `s_address` VALUES ('1798', '170', '市中区', '3', '', null);
INSERT INTO `s_address` VALUES ('1799', '170', '槐荫区', '3', '', null);
INSERT INTO `s_address` VALUES ('1800', '170', '天桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('1801', '170', '历城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1802', '170', '长清区', '3', '', null);
INSERT INTO `s_address` VALUES ('1803', '170', '平阴县', '3', '', null);
INSERT INTO `s_address` VALUES ('1804', '170', '济阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1805', '170', '商河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1806', '170', '章丘市', '3', '', null);
INSERT INTO `s_address` VALUES ('1807', '170', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1808', '171', '市南区', '3', '', null);
INSERT INTO `s_address` VALUES ('1809', '171', '市北区', '3', '', null);
INSERT INTO `s_address` VALUES ('1810', '171', '四方区', '3', '', null);
INSERT INTO `s_address` VALUES ('1811', '171', '黄岛区', '3', '', null);
INSERT INTO `s_address` VALUES ('1812', '171', '崂山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1813', '171', '李沧区', '3', '', null);
INSERT INTO `s_address` VALUES ('1814', '171', '城阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1815', '171', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1816', '171', '胶州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1817', '171', '即墨市', '3', '', null);
INSERT INTO `s_address` VALUES ('1818', '171', '平度市', '3', '', null);
INSERT INTO `s_address` VALUES ('1819', '171', '胶南市', '3', '', null);
INSERT INTO `s_address` VALUES ('1820', '171', '莱西市', '3', '', null);
INSERT INTO `s_address` VALUES ('1821', '171', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1822', '172', '淄川区', '3', '', null);
INSERT INTO `s_address` VALUES ('1823', '172', '张店区', '3', '', null);
INSERT INTO `s_address` VALUES ('1824', '172', '博山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1825', '172', '临淄区', '3', '', null);
INSERT INTO `s_address` VALUES ('1826', '172', '周村区', '3', '', null);
INSERT INTO `s_address` VALUES ('1827', '172', '桓台县', '3', '', null);
INSERT INTO `s_address` VALUES ('1828', '172', '高青县', '3', '', null);
INSERT INTO `s_address` VALUES ('1829', '172', '沂源县', '3', '', null);
INSERT INTO `s_address` VALUES ('1830', '172', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1831', '173', '市中区', '3', '', null);
INSERT INTO `s_address` VALUES ('1832', '173', '薛城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1833', '173', '峄城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1834', '173', '台儿庄区', '3', '', null);
INSERT INTO `s_address` VALUES ('1835', '173', '山亭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1836', '173', '滕州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1837', '173', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1838', '174', '东营区', '3', '', null);
INSERT INTO `s_address` VALUES ('1839', '174', '河口区', '3', '', null);
INSERT INTO `s_address` VALUES ('1840', '174', '垦利县', '3', '', null);
INSERT INTO `s_address` VALUES ('1841', '174', '利津县', '3', '', null);
INSERT INTO `s_address` VALUES ('1842', '174', '广饶县', '3', '', null);
INSERT INTO `s_address` VALUES ('1843', '174', '西城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1844', '174', '东城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1845', '174', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1846', '175', '芝罘区', '3', '', null);
INSERT INTO `s_address` VALUES ('1847', '175', '福山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1848', '175', '牟平区', '3', '', null);
INSERT INTO `s_address` VALUES ('1849', '175', '莱山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1850', '175', '长岛县', '3', '', null);
INSERT INTO `s_address` VALUES ('1851', '175', '龙口市', '3', '', null);
INSERT INTO `s_address` VALUES ('1852', '175', '莱阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('1853', '175', '莱州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1854', '175', '蓬莱市', '3', '', null);
INSERT INTO `s_address` VALUES ('1855', '175', '招远市', '3', '', null);
INSERT INTO `s_address` VALUES ('1856', '175', '栖霞市', '3', '', null);
INSERT INTO `s_address` VALUES ('1857', '175', '海阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('1858', '175', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1859', '176', '潍城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1860', '176', '寒亭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1861', '176', '坊子区', '3', '', null);
INSERT INTO `s_address` VALUES ('1862', '176', '奎文区', '3', '', null);
INSERT INTO `s_address` VALUES ('1863', '176', '临朐县', '3', '', null);
INSERT INTO `s_address` VALUES ('1864', '176', '昌乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('1865', '176', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1866', '176', '青州市', '3', '', null);
INSERT INTO `s_address` VALUES ('1867', '176', '诸城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1868', '176', '寿光市', '3', '', null);
INSERT INTO `s_address` VALUES ('1869', '176', '安丘市', '3', '', null);
INSERT INTO `s_address` VALUES ('1870', '176', '高密市', '3', '', null);
INSERT INTO `s_address` VALUES ('1871', '176', '昌邑市', '3', '', null);
INSERT INTO `s_address` VALUES ('1872', '176', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1873', '177', '市中区', '3', '', null);
INSERT INTO `s_address` VALUES ('1874', '177', '任城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1875', '177', '微山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1876', '177', '鱼台县', '3', '', null);
INSERT INTO `s_address` VALUES ('1877', '177', '金乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('1878', '177', '嘉祥县', '3', '', null);
INSERT INTO `s_address` VALUES ('1879', '177', '汶上县', '3', '', null);
INSERT INTO `s_address` VALUES ('1880', '177', '泗水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1881', '177', '梁山县', '3', '', null);
INSERT INTO `s_address` VALUES ('1882', '177', '曲阜市', '3', '', null);
INSERT INTO `s_address` VALUES ('1883', '177', '兖州区', '3', '', null);
INSERT INTO `s_address` VALUES ('1884', '177', '邹城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1885', '177', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1886', '178', '泰山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1887', '178', '岱岳区', '3', '', null);
INSERT INTO `s_address` VALUES ('1888', '178', '宁阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1889', '178', '东平县', '3', '', null);
INSERT INTO `s_address` VALUES ('1890', '178', '新泰市', '3', '', null);
INSERT INTO `s_address` VALUES ('1891', '178', '肥城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1892', '178', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1893', '179', '环翠区', '3', '', null);
INSERT INTO `s_address` VALUES ('1894', '179', '文登区', '3', '', null);
INSERT INTO `s_address` VALUES ('1895', '179', '荣成市', '3', '', null);
INSERT INTO `s_address` VALUES ('1896', '179', '乳山市', '3', '', null);
INSERT INTO `s_address` VALUES ('1897', '179', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1898', '180', '东港区', '3', '', null);
INSERT INTO `s_address` VALUES ('1899', '180', '岚山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1900', '180', '五莲县', '3', '', null);
INSERT INTO `s_address` VALUES ('1901', '180', '莒县', '3', '', null);
INSERT INTO `s_address` VALUES ('1902', '180', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1903', '181', '莱城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1904', '181', '钢城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1905', '181', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1906', '182', '兰山区', '3', '', null);
INSERT INTO `s_address` VALUES ('1907', '182', '罗庄区', '3', '', null);
INSERT INTO `s_address` VALUES ('1908', '182', '河东区', '3', '', null);
INSERT INTO `s_address` VALUES ('1909', '182', '沂南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1910', '182', '郯城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1911', '182', '沂水县', '3', '', null);
INSERT INTO `s_address` VALUES ('1912', '182', '兰陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('1913', '182', '费县', '3', '', null);
INSERT INTO `s_address` VALUES ('1914', '182', '平邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('1915', '182', '莒南县', '3', '', null);
INSERT INTO `s_address` VALUES ('1916', '182', '蒙阴县', '3', '', null);
INSERT INTO `s_address` VALUES ('1917', '182', '临沭县', '3', '', null);
INSERT INTO `s_address` VALUES ('1918', '182', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1919', '183', '德城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1920', '183', '陵城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1921', '183', '宁津县', '3', '', null);
INSERT INTO `s_address` VALUES ('1922', '183', '庆云县', '3', '', null);
INSERT INTO `s_address` VALUES ('1923', '183', '临邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('1924', '183', '齐河县', '3', '', null);
INSERT INTO `s_address` VALUES ('1925', '183', '平原县', '3', '', null);
INSERT INTO `s_address` VALUES ('1926', '183', '夏津县', '3', '', null);
INSERT INTO `s_address` VALUES ('1927', '183', '武城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1928', '183', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('1929', '183', '乐陵市', '3', '', null);
INSERT INTO `s_address` VALUES ('1930', '183', '禹城市', '3', '', null);
INSERT INTO `s_address` VALUES ('1931', '183', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1932', '184', '东昌府区', '3', '', null);
INSERT INTO `s_address` VALUES ('1933', '184', '阳谷县', '3', '', null);
INSERT INTO `s_address` VALUES ('1934', '184', '莘县', '3', '', null);
INSERT INTO `s_address` VALUES ('1935', '184', '茌平县', '3', '', null);
INSERT INTO `s_address` VALUES ('1936', '184', '东阿县', '3', '', null);
INSERT INTO `s_address` VALUES ('1937', '184', '冠县', '3', '', null);
INSERT INTO `s_address` VALUES ('1938', '184', '高唐县', '3', '', null);
INSERT INTO `s_address` VALUES ('1939', '184', '临清市', '3', '', null);
INSERT INTO `s_address` VALUES ('1940', '184', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1941', '185', '滨城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1942', '185', '惠民县', '3', '', null);
INSERT INTO `s_address` VALUES ('1943', '185', '阳信县', '3', '', null);
INSERT INTO `s_address` VALUES ('1944', '185', '无棣县', '3', '', null);
INSERT INTO `s_address` VALUES ('1945', '185', '沾化区', '3', '', null);
INSERT INTO `s_address` VALUES ('1946', '185', '博兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('1947', '185', '邹平县', '3', '', null);
INSERT INTO `s_address` VALUES ('1948', '185', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1949', '186', '牡丹区', '3', '', null);
INSERT INTO `s_address` VALUES ('1950', '186', '曹县', '3', '', null);
INSERT INTO `s_address` VALUES ('1951', '186', '单县', '3', '', null);
INSERT INTO `s_address` VALUES ('1952', '186', '成武县', '3', '', null);
INSERT INTO `s_address` VALUES ('1953', '186', '巨野县', '3', '', null);
INSERT INTO `s_address` VALUES ('1954', '186', '郓城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1955', '186', '鄄城县', '3', '', null);
INSERT INTO `s_address` VALUES ('1956', '186', '定陶县', '3', '', null);
INSERT INTO `s_address` VALUES ('1957', '186', '东明县', '3', '', null);
INSERT INTO `s_address` VALUES ('1958', '186', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1959', '187', '中原区', '3', '', null);
INSERT INTO `s_address` VALUES ('1960', '187', '二七区', '3', '', null);
INSERT INTO `s_address` VALUES ('1961', '187', '管城回族区', '3', '', null);
INSERT INTO `s_address` VALUES ('1962', '187', '金水区', '3', '', null);
INSERT INTO `s_address` VALUES ('1963', '187', '上街区', '3', '', null);
INSERT INTO `s_address` VALUES ('1964', '187', '惠济区', '3', '', null);
INSERT INTO `s_address` VALUES ('1965', '187', '中牟县', '3', '', null);
INSERT INTO `s_address` VALUES ('1966', '187', '巩义市', '3', '', null);
INSERT INTO `s_address` VALUES ('1967', '187', '荥阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('1968', '187', '新密市', '3', '', null);
INSERT INTO `s_address` VALUES ('1969', '187', '新郑市', '3', '', null);
INSERT INTO `s_address` VALUES ('1970', '187', '登封市', '3', '', null);
INSERT INTO `s_address` VALUES ('1971', '187', '郑东新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1972', '187', '高新区', '3', '', null);
INSERT INTO `s_address` VALUES ('1973', '187', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1974', '188', '龙亭区', '3', '', null);
INSERT INTO `s_address` VALUES ('1975', '188', '顺河回族区', '3', '', null);
INSERT INTO `s_address` VALUES ('1976', '188', '鼓楼区', '3', '', null);
INSERT INTO `s_address` VALUES ('1977', '188', '禹王台区', '3', '', null);
INSERT INTO `s_address` VALUES ('1978', '188', '金明区', '3', '', null);
INSERT INTO `s_address` VALUES ('1979', '188', '杞县', '3', '', null);
INSERT INTO `s_address` VALUES ('1980', '188', '通许县', '3', '', null);
INSERT INTO `s_address` VALUES ('1981', '188', '尉氏县', '3', '', null);
INSERT INTO `s_address` VALUES ('1982', '188', '祥符区', '3', '', null);
INSERT INTO `s_address` VALUES ('1983', '188', '兰考县', '3', '', null);
INSERT INTO `s_address` VALUES ('1984', '188', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('1985', '189', '老城区', '3', '', null);
INSERT INTO `s_address` VALUES ('1986', '189', '西工区', '3', '', null);
INSERT INTO `s_address` VALUES ('1987', '189', '瀍河回族区', '3', '', null);
INSERT INTO `s_address` VALUES ('1988', '189', '涧西区', '3', '', null);
INSERT INTO `s_address` VALUES ('1989', '189', '吉利区', '3', '', null);
INSERT INTO `s_address` VALUES ('1990', '189', '洛龙区', '3', '', null);
INSERT INTO `s_address` VALUES ('1991', '189', '孟津县', '3', '', null);
INSERT INTO `s_address` VALUES ('1992', '189', '新安县', '3', '', null);
INSERT INTO `s_address` VALUES ('1993', '189', '栾川县', '3', '', null);
INSERT INTO `s_address` VALUES ('1994', '189', '嵩县', '3', '', null);
INSERT INTO `s_address` VALUES ('1995', '189', '汝阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1996', '189', '宜阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('1997', '189', '洛宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('1998', '189', '伊川县', '3', '', null);
INSERT INTO `s_address` VALUES ('1999', '189', '偃师市', '3', '', null);
INSERT INTO `s_address` VALUES ('2000', '190', '新华区', '3', '', null);
INSERT INTO `s_address` VALUES ('2001', '190', '卫东区', '3', '', null);
INSERT INTO `s_address` VALUES ('2002', '190', '石龙区', '3', '', null);
INSERT INTO `s_address` VALUES ('2003', '190', '湛河区', '3', '', null);
INSERT INTO `s_address` VALUES ('2004', '190', '宝丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2005', '190', '叶县', '3', '', null);
INSERT INTO `s_address` VALUES ('2006', '190', '鲁山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2007', '190', '郏县', '3', '', null);
INSERT INTO `s_address` VALUES ('2008', '190', '舞钢市', '3', '', null);
INSERT INTO `s_address` VALUES ('2009', '190', '汝州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2010', '190', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2011', '191', '文峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('2012', '191', '北关区', '3', '', null);
INSERT INTO `s_address` VALUES ('2013', '191', '殷都区', '3', '', null);
INSERT INTO `s_address` VALUES ('2014', '191', '龙安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2015', '191', '安阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2016', '191', '汤阴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2017', '191', '滑县', '3', '', null);
INSERT INTO `s_address` VALUES ('2018', '191', '内黄县', '3', '', null);
INSERT INTO `s_address` VALUES ('2019', '191', '林州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2020', '191', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2021', '192', '鹤山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2022', '192', '山城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2023', '192', '淇滨区', '3', '', null);
INSERT INTO `s_address` VALUES ('2024', '192', '浚县', '3', '', null);
INSERT INTO `s_address` VALUES ('2025', '192', '淇县', '3', '', null);
INSERT INTO `s_address` VALUES ('2026', '192', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2027', '193', '红旗区', '3', '', null);
INSERT INTO `s_address` VALUES ('2028', '193', '卫滨区', '3', '', null);
INSERT INTO `s_address` VALUES ('2029', '193', '凤泉区', '3', '', null);
INSERT INTO `s_address` VALUES ('2030', '193', '牧野区', '3', '', null);
INSERT INTO `s_address` VALUES ('2031', '193', '新乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2032', '193', '获嘉县', '3', '', null);
INSERT INTO `s_address` VALUES ('2033', '193', '原阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2034', '193', '延津县', '3', '', null);
INSERT INTO `s_address` VALUES ('2035', '193', '封丘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2036', '193', '长垣县', '3', '', null);
INSERT INTO `s_address` VALUES ('2037', '193', '卫辉市', '3', '', null);
INSERT INTO `s_address` VALUES ('2038', '193', '辉县市', '3', '', null);
INSERT INTO `s_address` VALUES ('2039', '193', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2040', '194', '解放区', '3', '', null);
INSERT INTO `s_address` VALUES ('2041', '194', '中站区', '3', '', null);
INSERT INTO `s_address` VALUES ('2042', '194', '马村区', '3', '', null);
INSERT INTO `s_address` VALUES ('2043', '194', '山阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2044', '194', '修武县', '3', '', null);
INSERT INTO `s_address` VALUES ('2045', '194', '博爱县', '3', '', null);
INSERT INTO `s_address` VALUES ('2046', '194', '武陟县', '3', '', null);
INSERT INTO `s_address` VALUES ('2047', '194', '温县', '3', '', null);
INSERT INTO `s_address` VALUES ('2048', '194', '沁阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('2049', '194', '孟州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2050', '194', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2051', '195', '华龙区', '3', '', null);
INSERT INTO `s_address` VALUES ('2052', '195', '清丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2053', '195', '南乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('2054', '195', '范县', '3', '', null);
INSERT INTO `s_address` VALUES ('2055', '195', '台前县', '3', '', null);
INSERT INTO `s_address` VALUES ('2056', '195', '濮阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2057', '195', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2058', '196', '魏都区', '3', '', null);
INSERT INTO `s_address` VALUES ('2059', '196', '许昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2060', '196', '鄢陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2061', '196', '襄城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2062', '196', '禹州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2063', '196', '长葛市', '3', '', null);
INSERT INTO `s_address` VALUES ('2064', '196', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2065', '197', '源汇区', '3', '', null);
INSERT INTO `s_address` VALUES ('2066', '197', '郾城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2067', '197', '召陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2068', '197', '舞阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2069', '197', '临颍县', '3', '', null);
INSERT INTO `s_address` VALUES ('2070', '197', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2071', '198', '湖滨区', '3', '', null);
INSERT INTO `s_address` VALUES ('2072', '198', '渑池县', '3', '', null);
INSERT INTO `s_address` VALUES ('2073', '198', '陕州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2074', '198', '卢氏县', '3', '', null);
INSERT INTO `s_address` VALUES ('2075', '198', '义马市', '3', '', null);
INSERT INTO `s_address` VALUES ('2076', '198', '灵宝市', '3', '', null);
INSERT INTO `s_address` VALUES ('2077', '198', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2078', '199', '宛城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2079', '199', '卧龙区', '3', '', null);
INSERT INTO `s_address` VALUES ('2080', '199', '南召县', '3', '', null);
INSERT INTO `s_address` VALUES ('2081', '199', '方城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2082', '199', '西峡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2083', '199', '镇平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2084', '199', '内乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2085', '199', '淅川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2086', '199', '社旗县', '3', '', null);
INSERT INTO `s_address` VALUES ('2087', '199', '唐河县', '3', '', null);
INSERT INTO `s_address` VALUES ('2088', '199', '新野县', '3', '', null);
INSERT INTO `s_address` VALUES ('2089', '199', '桐柏县', '3', '', null);
INSERT INTO `s_address` VALUES ('2090', '199', '邓州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2091', '199', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2092', '200', '梁园区', '3', '', null);
INSERT INTO `s_address` VALUES ('2093', '200', '睢阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2094', '200', '民权县', '3', '', null);
INSERT INTO `s_address` VALUES ('2095', '200', '睢县', '3', '', null);
INSERT INTO `s_address` VALUES ('2096', '200', '宁陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2097', '200', '柘城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2098', '200', '虞城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2099', '200', '夏邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('2100', '200', '永城市', '3', '', null);
INSERT INTO `s_address` VALUES ('2101', '200', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2102', '201', '浉河区', '3', '', null);
INSERT INTO `s_address` VALUES ('2103', '201', '平桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('2104', '201', '罗山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2105', '201', '光山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2106', '201', '新县', '3', '', null);
INSERT INTO `s_address` VALUES ('2107', '201', '商城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2108', '201', '固始县', '3', '', null);
INSERT INTO `s_address` VALUES ('2109', '201', '潢川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2110', '201', '淮滨县', '3', '', null);
INSERT INTO `s_address` VALUES ('2111', '201', '息县', '3', '', null);
INSERT INTO `s_address` VALUES ('2112', '201', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2113', '202', '川汇区', '3', '', null);
INSERT INTO `s_address` VALUES ('2114', '202', '扶沟县', '3', '', null);
INSERT INTO `s_address` VALUES ('2115', '202', '西华县', '3', '', null);
INSERT INTO `s_address` VALUES ('2116', '202', '商水县', '3', '', null);
INSERT INTO `s_address` VALUES ('2117', '202', '沈丘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2118', '202', '郸城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2119', '202', '淮阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2120', '202', '太康县', '3', '', null);
INSERT INTO `s_address` VALUES ('2121', '202', '鹿邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('2122', '202', '项城市', '3', '', null);
INSERT INTO `s_address` VALUES ('2123', '202', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2124', '203', '驿城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2125', '203', '西平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2126', '203', '上蔡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2127', '203', '平舆县', '3', '', null);
INSERT INTO `s_address` VALUES ('2128', '203', '正阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2129', '203', '确山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2130', '203', '泌阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2131', '203', '汝南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2132', '203', '遂平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2133', '203', '新蔡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2134', '203', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2135', '204', '江岸区', '3', '', null);
INSERT INTO `s_address` VALUES ('2136', '204', '江汉区', '3', '', null);
INSERT INTO `s_address` VALUES ('2137', '204', '硚口区', '3', '', null);
INSERT INTO `s_address` VALUES ('2138', '204', '汉阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2139', '204', '武昌区', '3', '', null);
INSERT INTO `s_address` VALUES ('2140', '204', '青山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2141', '204', '洪山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2142', '204', '东西湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2143', '204', '汉南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2144', '204', '蔡甸区', '3', '', null);
INSERT INTO `s_address` VALUES ('2145', '204', '江夏区', '3', '', null);
INSERT INTO `s_address` VALUES ('2146', '204', '黄陂区', '3', '', null);
INSERT INTO `s_address` VALUES ('2147', '204', '新洲区', '3', '', null);
INSERT INTO `s_address` VALUES ('2148', '204', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2149', '205', '黄石港区', '3', '', null);
INSERT INTO `s_address` VALUES ('2150', '205', '西塞山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2151', '205', '下陆区', '3', '', null);
INSERT INTO `s_address` VALUES ('2152', '205', '铁山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2153', '205', '阳新县', '3', '', null);
INSERT INTO `s_address` VALUES ('2154', '205', '大冶市', '3', '', null);
INSERT INTO `s_address` VALUES ('2155', '205', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2156', '206', '茅箭区', '3', '', null);
INSERT INTO `s_address` VALUES ('2157', '206', '张湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('2158', '206', '郧阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2159', '206', '郧西县', '3', '', null);
INSERT INTO `s_address` VALUES ('2160', '206', '竹山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2161', '206', '竹溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2162', '206', '房县', '3', '', null);
INSERT INTO `s_address` VALUES ('2163', '206', '丹江口市', '3', '', null);
INSERT INTO `s_address` VALUES ('2164', '206', '城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2165', '206', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2166', '207', '西陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2167', '207', '伍家岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('2168', '207', '点军区', '3', '', null);
INSERT INTO `s_address` VALUES ('2169', '207', '猇亭区', '3', '', null);
INSERT INTO `s_address` VALUES ('2170', '207', '夷陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2171', '207', '远安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2172', '207', '兴山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2173', '207', '秭归县', '3', '', null);
INSERT INTO `s_address` VALUES ('2174', '207', '长阳土家族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2175', '207', '五峰土家族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2176', '207', '葛洲坝区', '3', '', null);
INSERT INTO `s_address` VALUES ('2177', '207', '开发区', '3', '', null);
INSERT INTO `s_address` VALUES ('2178', '207', '宜都市', '3', '', null);
INSERT INTO `s_address` VALUES ('2179', '207', '当阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('2180', '207', '枝江市', '3', '', null);
INSERT INTO `s_address` VALUES ('2181', '207', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2182', '208', '襄城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2183', '208', '樊城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2184', '208', '襄州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2185', '208', '南漳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2186', '208', '谷城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2187', '208', '保康县', '3', '', null);
INSERT INTO `s_address` VALUES ('2188', '208', '老河口市', '3', '', null);
INSERT INTO `s_address` VALUES ('2189', '208', '枣阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('2190', '208', '宜城市', '3', '', null);
INSERT INTO `s_address` VALUES ('2191', '208', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2192', '209', '梁子湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2193', '209', '华容区', '3', '', null);
INSERT INTO `s_address` VALUES ('2194', '209', '鄂城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2195', '209', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2196', '210', '东宝区', '3', '', null);
INSERT INTO `s_address` VALUES ('2197', '210', '掇刀区', '3', '', null);
INSERT INTO `s_address` VALUES ('2198', '210', '京山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2199', '210', '沙洋县', '3', '', null);
INSERT INTO `s_address` VALUES ('2200', '210', '钟祥市', '3', '', null);
INSERT INTO `s_address` VALUES ('2201', '210', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2202', '211', '孝南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2203', '211', '孝昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2204', '211', '大悟县', '3', '', null);
INSERT INTO `s_address` VALUES ('2205', '211', '云梦县', '3', '', null);
INSERT INTO `s_address` VALUES ('2206', '211', '应城市', '3', '', null);
INSERT INTO `s_address` VALUES ('2207', '211', '安陆市', '3', '', null);
INSERT INTO `s_address` VALUES ('2208', '211', '汉川市', '3', '', null);
INSERT INTO `s_address` VALUES ('2209', '211', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2210', '212', '沙市区', '3', '', null);
INSERT INTO `s_address` VALUES ('2211', '212', '荆州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2212', '212', '公安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2213', '212', '监利县', '3', '', null);
INSERT INTO `s_address` VALUES ('2214', '212', '江陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2215', '212', '石首市', '3', '', null);
INSERT INTO `s_address` VALUES ('2216', '212', '洪湖市', '3', '', null);
INSERT INTO `s_address` VALUES ('2217', '212', '松滋市', '3', '', null);
INSERT INTO `s_address` VALUES ('2218', '212', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2219', '213', '黄州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2220', '213', '团风县', '3', '', null);
INSERT INTO `s_address` VALUES ('2221', '213', '红安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2222', '213', '罗田县', '3', '', null);
INSERT INTO `s_address` VALUES ('2223', '213', '英山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2224', '213', '浠水县', '3', '', null);
INSERT INTO `s_address` VALUES ('2225', '213', '蕲春县', '3', '', null);
INSERT INTO `s_address` VALUES ('2226', '213', '黄梅县', '3', '', null);
INSERT INTO `s_address` VALUES ('2227', '213', '麻城市', '3', '', null);
INSERT INTO `s_address` VALUES ('2228', '213', '武穴市', '3', '', null);
INSERT INTO `s_address` VALUES ('2229', '213', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2230', '214', '咸安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2231', '214', '嘉鱼县', '3', '', null);
INSERT INTO `s_address` VALUES ('2232', '214', '通城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2233', '214', '崇阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2234', '214', '通山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2235', '214', '赤壁市', '3', '', null);
INSERT INTO `s_address` VALUES ('2236', '214', '温泉城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2237', '214', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2238', '215', '曾都区', '3', '', null);
INSERT INTO `s_address` VALUES ('2239', '215', '随县', '3', '', null);
INSERT INTO `s_address` VALUES ('2240', '215', '广水市', '3', '', null);
INSERT INTO `s_address` VALUES ('2241', '215', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2242', '216', '恩施市', '3', '', null);
INSERT INTO `s_address` VALUES ('2243', '216', '利川市', '3', '', null);
INSERT INTO `s_address` VALUES ('2244', '216', '建始县', '3', '', null);
INSERT INTO `s_address` VALUES ('2245', '216', '巴东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2246', '216', '宣恩县', '3', '', null);
INSERT INTO `s_address` VALUES ('2247', '216', '咸丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2248', '216', '来凤县', '3', '', null);
INSERT INTO `s_address` VALUES ('2249', '216', '鹤峰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2250', '216', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2251', '217', '芙蓉区', '3', '', null);
INSERT INTO `s_address` VALUES ('2252', '217', '天心区', '3', '', null);
INSERT INTO `s_address` VALUES ('2253', '217', '岳麓区', '3', '', null);
INSERT INTO `s_address` VALUES ('2254', '217', '开福区', '3', '', null);
INSERT INTO `s_address` VALUES ('2255', '217', '雨花区', '3', '', null);
INSERT INTO `s_address` VALUES ('2256', '217', '长沙县', '3', '', null);
INSERT INTO `s_address` VALUES ('2257', '217', '望城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2258', '217', '宁乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2259', '217', '浏阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('2260', '217', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2261', '218', '荷塘区', '3', '', null);
INSERT INTO `s_address` VALUES ('2262', '218', '芦淞区', '3', '', null);
INSERT INTO `s_address` VALUES ('2263', '218', '石峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('2264', '218', '天元区', '3', '', null);
INSERT INTO `s_address` VALUES ('2265', '218', '株洲县', '3', '', null);
INSERT INTO `s_address` VALUES ('2266', '218', '攸县', '3', '', null);
INSERT INTO `s_address` VALUES ('2267', '218', '茶陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2268', '218', '炎陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2269', '218', '醴陵市', '3', '', null);
INSERT INTO `s_address` VALUES ('2270', '218', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2271', '219', '雨湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2272', '219', '岳塘区', '3', '', null);
INSERT INTO `s_address` VALUES ('2273', '219', '湘潭县', '3', '', null);
INSERT INTO `s_address` VALUES ('2274', '219', '湘乡市', '3', '', null);
INSERT INTO `s_address` VALUES ('2275', '219', '韶山市', '3', '', null);
INSERT INTO `s_address` VALUES ('2276', '219', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2277', '220', '珠晖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2278', '220', '雁峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('2279', '220', '石鼓区', '3', '', null);
INSERT INTO `s_address` VALUES ('2280', '220', '蒸湘区', '3', '', null);
INSERT INTO `s_address` VALUES ('2281', '220', '南岳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2282', '220', '衡阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2283', '220', '衡南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2284', '220', '衡山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2285', '220', '衡东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2286', '220', '祁东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2287', '220', '耒阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('2288', '220', '常宁市', '3', '', null);
INSERT INTO `s_address` VALUES ('2289', '220', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2290', '221', '双清区', '3', '', null);
INSERT INTO `s_address` VALUES ('2291', '221', '大祥区', '3', '', null);
INSERT INTO `s_address` VALUES ('2292', '221', '北塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('2293', '221', '邵东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2294', '221', '新邵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2295', '221', '邵阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2296', '221', '隆回县', '3', '', null);
INSERT INTO `s_address` VALUES ('2297', '221', '洞口县', '3', '', null);
INSERT INTO `s_address` VALUES ('2298', '221', '绥宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2299', '221', '新宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2300', '221', '城步苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2301', '221', '武冈市', '3', '', null);
INSERT INTO `s_address` VALUES ('2302', '221', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2303', '222', '岳阳楼区', '3', '', null);
INSERT INTO `s_address` VALUES ('2304', '222', '云溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('2305', '222', '君山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2306', '222', '岳阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2307', '222', '华容县', '3', '', null);
INSERT INTO `s_address` VALUES ('2308', '222', '湘阴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2309', '222', '平江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2310', '222', '汨罗市', '3', '', null);
INSERT INTO `s_address` VALUES ('2311', '222', '临湘市', '3', '', null);
INSERT INTO `s_address` VALUES ('2312', '222', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2313', '223', '武陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2314', '223', '鼎城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2315', '223', '安乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2316', '223', '汉寿县', '3', '', null);
INSERT INTO `s_address` VALUES ('2317', '223', '澧县', '3', '', null);
INSERT INTO `s_address` VALUES ('2318', '223', '临澧县', '3', '', null);
INSERT INTO `s_address` VALUES ('2319', '223', '桃源县', '3', '', null);
INSERT INTO `s_address` VALUES ('2320', '223', '石门县', '3', '', null);
INSERT INTO `s_address` VALUES ('2321', '223', '津市市', '3', '', null);
INSERT INTO `s_address` VALUES ('2322', '223', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2323', '224', '永定区', '3', '', null);
INSERT INTO `s_address` VALUES ('2324', '224', '武陵源区', '3', '', null);
INSERT INTO `s_address` VALUES ('2325', '224', '慈利县', '3', '', null);
INSERT INTO `s_address` VALUES ('2326', '224', '桑植县', '3', '', null);
INSERT INTO `s_address` VALUES ('2327', '224', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2328', '225', '资阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2329', '225', '赫山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2330', '225', '南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2331', '225', '桃江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2332', '225', '安化县', '3', '', null);
INSERT INTO `s_address` VALUES ('2333', '225', '沅江市', '3', '', null);
INSERT INTO `s_address` VALUES ('2334', '225', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2335', '226', '北湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2336', '226', '苏仙区', '3', '', null);
INSERT INTO `s_address` VALUES ('2337', '226', '桂阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2338', '226', '宜章县', '3', '', null);
INSERT INTO `s_address` VALUES ('2339', '226', '永兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2340', '226', '嘉禾县', '3', '', null);
INSERT INTO `s_address` VALUES ('2341', '226', '临武县', '3', '', null);
INSERT INTO `s_address` VALUES ('2342', '226', '汝城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2343', '226', '桂东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2344', '226', '安仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2345', '226', '资兴市', '3', '', null);
INSERT INTO `s_address` VALUES ('2346', '226', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2347', '227', '零陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2348', '227', '冷水滩区', '3', '', null);
INSERT INTO `s_address` VALUES ('2349', '227', '祁阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2350', '227', '东安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2351', '227', '双牌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2352', '227', '道县', '3', '', null);
INSERT INTO `s_address` VALUES ('2353', '227', '江永县', '3', '', null);
INSERT INTO `s_address` VALUES ('2354', '227', '宁远县', '3', '', null);
INSERT INTO `s_address` VALUES ('2355', '227', '蓝山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2356', '227', '新田县', '3', '', null);
INSERT INTO `s_address` VALUES ('2357', '227', '江华瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2358', '227', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2359', '228', '鹤城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2360', '228', '中方县', '3', '', null);
INSERT INTO `s_address` VALUES ('2361', '228', '沅陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('2362', '228', '辰溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2363', '228', '溆浦县', '3', '', null);
INSERT INTO `s_address` VALUES ('2364', '228', '会同县', '3', '', null);
INSERT INTO `s_address` VALUES ('2365', '228', '麻阳苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2366', '228', '新晃侗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2367', '228', '芷江侗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2368', '228', '靖州苗族侗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2369', '228', '通道侗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2370', '228', '洪江市', '3', '', null);
INSERT INTO `s_address` VALUES ('2371', '228', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2372', '229', '娄星区', '3', '', null);
INSERT INTO `s_address` VALUES ('2373', '229', '双峰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2374', '229', '新化县', '3', '', null);
INSERT INTO `s_address` VALUES ('2375', '229', '冷水江市', '3', '', null);
INSERT INTO `s_address` VALUES ('2376', '229', '涟源市', '3', '', null);
INSERT INTO `s_address` VALUES ('2377', '229', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2378', '230', '吉首市', '3', '', null);
INSERT INTO `s_address` VALUES ('2379', '230', '泸溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2380', '230', '凤凰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2381', '230', '花垣县', '3', '', null);
INSERT INTO `s_address` VALUES ('2382', '230', '保靖县', '3', '', null);
INSERT INTO `s_address` VALUES ('2383', '230', '古丈县', '3', '', null);
INSERT INTO `s_address` VALUES ('2384', '230', '永顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('2385', '230', '龙山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2386', '230', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2387', '231', '荔湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('2388', '231', '越秀区', '3', '', null);
INSERT INTO `s_address` VALUES ('2389', '231', '海珠区', '3', '', null);
INSERT INTO `s_address` VALUES ('2390', '231', '天河区', '3', '', null);
INSERT INTO `s_address` VALUES ('2391', '231', '白云区', '3', '', null);
INSERT INTO `s_address` VALUES ('2392', '231', '黄埔区', '3', '', null);
INSERT INTO `s_address` VALUES ('2393', '231', '番禺区', '3', '', null);
INSERT INTO `s_address` VALUES ('2394', '231', '花都区', '3', '', null);
INSERT INTO `s_address` VALUES ('2395', '231', '南沙区', '3', '', null);
INSERT INTO `s_address` VALUES ('2396', '231', '萝岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('2397', '231', '增城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2398', '231', '从化区', '3', '', null);
INSERT INTO `s_address` VALUES ('2399', '231', '东山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2400', '231', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2401', '232', '武江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2402', '232', '浈江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2403', '232', '曲江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2404', '232', '始兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2405', '232', '仁化县', '3', '', null);
INSERT INTO `s_address` VALUES ('2406', '232', '翁源县', '3', '', null);
INSERT INTO `s_address` VALUES ('2407', '232', '乳源瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2408', '232', '新丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2409', '232', '乐昌市', '3', '', null);
INSERT INTO `s_address` VALUES ('2410', '232', '南雄市', '3', '', null);
INSERT INTO `s_address` VALUES ('2411', '232', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2412', '233', '罗湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2413', '233', '福田区', '3', '', null);
INSERT INTO `s_address` VALUES ('2414', '233', '南山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2415', '233', '宝安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2416', '233', '龙岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('2417', '233', '盐田区', '3', '', null);
INSERT INTO `s_address` VALUES ('2418', '233', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2419', '233', '光明新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2420', '233', '坪山新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2421', '233', '大鹏新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2422', '233', '龙华新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2423', '234', '香洲区', '3', '', null);
INSERT INTO `s_address` VALUES ('2424', '234', '斗门区', '3', '', null);
INSERT INTO `s_address` VALUES ('2425', '234', '金湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('2426', '234', '金唐区', '3', '', null);
INSERT INTO `s_address` VALUES ('2427', '234', '南湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('2428', '234', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2429', '235', '龙湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2430', '235', '金平区', '3', '', null);
INSERT INTO `s_address` VALUES ('2431', '235', '濠江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2432', '235', '潮阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2433', '235', '潮南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2434', '235', '澄海区', '3', '', null);
INSERT INTO `s_address` VALUES ('2435', '235', '南澳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2436', '235', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2437', '236', '禅城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2438', '236', '南海区', '3', '', null);
INSERT INTO `s_address` VALUES ('2439', '236', '顺德区', '3', '', null);
INSERT INTO `s_address` VALUES ('2440', '236', '三水区', '3', '', null);
INSERT INTO `s_address` VALUES ('2441', '236', '高明区', '3', '', null);
INSERT INTO `s_address` VALUES ('2442', '236', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2443', '237', '蓬江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2444', '237', '江海区', '3', '', null);
INSERT INTO `s_address` VALUES ('2445', '237', '新会区', '3', '', null);
INSERT INTO `s_address` VALUES ('2446', '237', '台山市', '3', '', null);
INSERT INTO `s_address` VALUES ('2447', '237', '开平市', '3', '', null);
INSERT INTO `s_address` VALUES ('2448', '237', '鹤山市', '3', '', null);
INSERT INTO `s_address` VALUES ('2449', '237', '恩平市', '3', '', null);
INSERT INTO `s_address` VALUES ('2450', '237', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2451', '238', '赤坎区', '3', '', null);
INSERT INTO `s_address` VALUES ('2452', '238', '霞山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2453', '238', '坡头区', '3', '', null);
INSERT INTO `s_address` VALUES ('2454', '238', '麻章区', '3', '', null);
INSERT INTO `s_address` VALUES ('2455', '238', '遂溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2456', '238', '徐闻县', '3', '', null);
INSERT INTO `s_address` VALUES ('2457', '238', '廉江市', '3', '', null);
INSERT INTO `s_address` VALUES ('2458', '238', '雷州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2459', '238', '吴川市', '3', '', null);
INSERT INTO `s_address` VALUES ('2460', '238', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2461', '239', '茂南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2462', '239', '电白区', '3', '', null);
INSERT INTO `s_address` VALUES ('2463', '239', '电白县', '3', '', null);
INSERT INTO `s_address` VALUES ('2464', '239', '高州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2465', '239', '化州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2466', '239', '信宜市', '3', '', null);
INSERT INTO `s_address` VALUES ('2467', '239', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2468', '240', '端州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2469', '240', '鼎湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2470', '240', '广宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2471', '240', '怀集县', '3', '', null);
INSERT INTO `s_address` VALUES ('2472', '240', '封开县', '3', '', null);
INSERT INTO `s_address` VALUES ('2473', '240', '德庆县', '3', '', null);
INSERT INTO `s_address` VALUES ('2474', '240', '高要市', '3', '', null);
INSERT INTO `s_address` VALUES ('2475', '240', '四会市', '3', '', null);
INSERT INTO `s_address` VALUES ('2476', '240', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2477', '241', '惠城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2478', '241', '惠阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2479', '241', '博罗县', '3', '', null);
INSERT INTO `s_address` VALUES ('2480', '241', '惠东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2481', '241', '龙门县', '3', '', null);
INSERT INTO `s_address` VALUES ('2482', '241', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2483', '242', '梅江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2484', '242', '梅县区', '3', '', null);
INSERT INTO `s_address` VALUES ('2485', '242', '大埔县', '3', '', null);
INSERT INTO `s_address` VALUES ('2486', '242', '丰顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('2487', '242', '五华县', '3', '', null);
INSERT INTO `s_address` VALUES ('2488', '242', '平远县', '3', '', null);
INSERT INTO `s_address` VALUES ('2489', '242', '蕉岭县', '3', '', null);
INSERT INTO `s_address` VALUES ('2490', '242', '兴宁市', '3', '', null);
INSERT INTO `s_address` VALUES ('2491', '242', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2492', '243', '城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2493', '243', '海丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2494', '243', '陆河县', '3', '', null);
INSERT INTO `s_address` VALUES ('2495', '243', '陆丰市', '3', '', null);
INSERT INTO `s_address` VALUES ('2496', '243', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2497', '244', '源城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2498', '244', '紫金县', '3', '', null);
INSERT INTO `s_address` VALUES ('2499', '244', '龙川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2500', '244', '连平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2501', '244', '和平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2502', '244', '东源县', '3', '', null);
INSERT INTO `s_address` VALUES ('2503', '244', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2504', '245', '江城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2505', '245', '阳西县', '3', '', null);
INSERT INTO `s_address` VALUES ('2506', '245', '阳东区', '3', '', null);
INSERT INTO `s_address` VALUES ('2507', '245', '阳春市', '3', '', null);
INSERT INTO `s_address` VALUES ('2508', '245', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2509', '246', '清城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2510', '246', '佛冈县', '3', '', null);
INSERT INTO `s_address` VALUES ('2511', '246', '阳山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2512', '246', '连山壮族瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2513', '246', '连南瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2514', '246', '清新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2515', '246', '英德市', '3', '', null);
INSERT INTO `s_address` VALUES ('2516', '246', '连州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2517', '246', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2518', '250', '湘桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('2519', '250', '潮安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2520', '250', '饶平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2521', '250', '枫溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('2522', '250', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2523', '251', '榕城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2524', '251', '揭东区', '3', '', null);
INSERT INTO `s_address` VALUES ('2525', '251', '揭西县', '3', '', null);
INSERT INTO `s_address` VALUES ('2526', '251', '惠来县', '3', '', null);
INSERT INTO `s_address` VALUES ('2527', '251', '普宁市', '3', '', null);
INSERT INTO `s_address` VALUES ('2528', '251', '东山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2529', '251', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2530', '252', '云城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2531', '252', '新兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2532', '252', '郁南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2533', '252', '云安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2534', '252', '罗定市', '3', '', null);
INSERT INTO `s_address` VALUES ('2535', '252', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2536', '253', '兴宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('2537', '253', '青秀区', '3', '', null);
INSERT INTO `s_address` VALUES ('2538', '253', '江南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2539', '253', '西乡塘区', '3', '', null);
INSERT INTO `s_address` VALUES ('2540', '253', '良庆区', '3', '', null);
INSERT INTO `s_address` VALUES ('2541', '253', '邕宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('2542', '253', '武鸣区', '3', '', null);
INSERT INTO `s_address` VALUES ('2543', '253', '隆安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2544', '253', '马山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2545', '253', '上林县', '3', '', null);
INSERT INTO `s_address` VALUES ('2546', '253', '宾阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2547', '253', '横县', '3', '', null);
INSERT INTO `s_address` VALUES ('2548', '253', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2549', '254', '城中区', '3', '', null);
INSERT INTO `s_address` VALUES ('2550', '254', '鱼峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('2551', '254', '柳南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2552', '254', '柳北区', '3', '', null);
INSERT INTO `s_address` VALUES ('2553', '254', '柳江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2554', '254', '柳城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2555', '254', '鹿寨县', '3', '', null);
INSERT INTO `s_address` VALUES ('2556', '254', '融安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2557', '254', '融水苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2558', '254', '三江侗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2559', '254', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2560', '255', '秀峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('2561', '255', '叠彩区', '3', '', null);
INSERT INTO `s_address` VALUES ('2562', '255', '象山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2563', '255', '七星区', '3', '', null);
INSERT INTO `s_address` VALUES ('2564', '255', '雁山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2565', '255', '阳朔县', '3', '', null);
INSERT INTO `s_address` VALUES ('2566', '255', '临桂区', '3', '', null);
INSERT INTO `s_address` VALUES ('2567', '255', '灵川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2568', '255', '全州县', '3', '', null);
INSERT INTO `s_address` VALUES ('2569', '255', '兴安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2570', '255', '永福县', '3', '', null);
INSERT INTO `s_address` VALUES ('2571', '255', '灌阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2572', '255', '龙胜各族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2573', '255', '资源县', '3', '', null);
INSERT INTO `s_address` VALUES ('2574', '255', '平乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('2575', '255', '荔浦县', '3', '', null);
INSERT INTO `s_address` VALUES ('2576', '255', '恭城瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2577', '255', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2578', '256', '万秀区', '3', '', null);
INSERT INTO `s_address` VALUES ('2579', '256', '蝶山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2580', '256', '长洲区', '3', '', null);
INSERT INTO `s_address` VALUES ('2581', '256', '龙圩区', '3', '', null);
INSERT INTO `s_address` VALUES ('2582', '256', '苍梧县', '3', '', null);
INSERT INTO `s_address` VALUES ('2583', '256', '藤县', '3', '', null);
INSERT INTO `s_address` VALUES ('2584', '256', '蒙山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2585', '256', '岑溪市', '3', '', null);
INSERT INTO `s_address` VALUES ('2586', '256', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2587', '257', '海城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2588', '257', '银海区', '3', '', null);
INSERT INTO `s_address` VALUES ('2589', '257', '铁山港区', '3', '', null);
INSERT INTO `s_address` VALUES ('2590', '257', '合浦县', '3', '', null);
INSERT INTO `s_address` VALUES ('2591', '257', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2592', '258', '港口区', '3', '', null);
INSERT INTO `s_address` VALUES ('2593', '258', '防城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2594', '258', '上思县', '3', '', null);
INSERT INTO `s_address` VALUES ('2595', '258', '东兴市', '3', '', null);
INSERT INTO `s_address` VALUES ('2596', '258', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2597', '259', '钦南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2598', '259', '钦北区', '3', '', null);
INSERT INTO `s_address` VALUES ('2599', '259', '灵山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2600', '259', '浦北县', '3', '', null);
INSERT INTO `s_address` VALUES ('2601', '259', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2602', '260', '港北区', '3', '', null);
INSERT INTO `s_address` VALUES ('2603', '260', '港南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2604', '260', '覃塘区', '3', '', null);
INSERT INTO `s_address` VALUES ('2605', '260', '平南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2606', '260', '桂平市', '3', '', null);
INSERT INTO `s_address` VALUES ('2607', '260', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2608', '261', '玉州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2609', '261', '福绵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2610', '261', '容县', '3', '', null);
INSERT INTO `s_address` VALUES ('2611', '261', '陆川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2612', '261', '博白县', '3', '', null);
INSERT INTO `s_address` VALUES ('2613', '261', '兴业县', '3', '', null);
INSERT INTO `s_address` VALUES ('2614', '261', '北流市', '3', '', null);
INSERT INTO `s_address` VALUES ('2615', '261', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2616', '262', '右江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2617', '262', '田阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2618', '262', '田东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2619', '262', '平果县', '3', '', null);
INSERT INTO `s_address` VALUES ('2620', '262', '德保县', '3', '', null);
INSERT INTO `s_address` VALUES ('2621', '262', '靖西县', '3', '', null);
INSERT INTO `s_address` VALUES ('2622', '262', '那坡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2623', '262', '凌云县', '3', '', null);
INSERT INTO `s_address` VALUES ('2624', '262', '乐业县', '3', '', null);
INSERT INTO `s_address` VALUES ('2625', '262', '田林县', '3', '', null);
INSERT INTO `s_address` VALUES ('2626', '262', '西林县', '3', '', null);
INSERT INTO `s_address` VALUES ('2627', '262', '隆林各族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2628', '262', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2629', '263', '八步区', '3', '', null);
INSERT INTO `s_address` VALUES ('2630', '263', '平桂管理区', '3', '', null);
INSERT INTO `s_address` VALUES ('2631', '263', '昭平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2632', '263', '钟山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2633', '263', '富川瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2634', '263', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2635', '264', '金城江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2636', '264', '南丹县', '3', '', null);
INSERT INTO `s_address` VALUES ('2637', '264', '天峨县', '3', '', null);
INSERT INTO `s_address` VALUES ('2638', '264', '凤山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2639', '264', '东兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2640', '264', '罗城仫佬族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2641', '264', '环江毛南族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2642', '264', '巴马瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2643', '264', '都安瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2644', '264', '大化瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2645', '264', '宜州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2646', '264', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2647', '265', '兴宾区', '3', '', null);
INSERT INTO `s_address` VALUES ('2648', '265', '忻城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2649', '265', '象州县', '3', '', null);
INSERT INTO `s_address` VALUES ('2650', '265', '武宣县', '3', '', null);
INSERT INTO `s_address` VALUES ('2651', '265', '金秀瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2652', '265', '合山市', '3', '', null);
INSERT INTO `s_address` VALUES ('2653', '265', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2654', '266', '江州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2655', '266', '扶绥县', '3', '', null);
INSERT INTO `s_address` VALUES ('2656', '266', '宁明县', '3', '', null);
INSERT INTO `s_address` VALUES ('2657', '266', '龙州县', '3', '', null);
INSERT INTO `s_address` VALUES ('2658', '266', '大新县', '3', '', null);
INSERT INTO `s_address` VALUES ('2659', '266', '天等县', '3', '', null);
INSERT INTO `s_address` VALUES ('2660', '266', '凭祥市', '3', '', null);
INSERT INTO `s_address` VALUES ('2661', '266', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2662', '267', '秀英区', '3', '', null);
INSERT INTO `s_address` VALUES ('2663', '267', '龙华区', '3', '', null);
INSERT INTO `s_address` VALUES ('2664', '267', '琼山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2665', '267', '美兰区', '3', '', null);
INSERT INTO `s_address` VALUES ('2666', '267', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2667', '269', '西沙群岛', '3', '', null);
INSERT INTO `s_address` VALUES ('2668', '269', '南沙群岛', '3', '', null);
INSERT INTO `s_address` VALUES ('2669', '269', '中沙群岛的岛礁及其海域', '3', '', null);
INSERT INTO `s_address` VALUES ('2670', '189', '高新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2671', '189', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2672', '270', '万州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2673', '270', '涪陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2674', '270', '渝中区', '3', '', null);
INSERT INTO `s_address` VALUES ('2675', '270', '大渡口区', '3', '', null);
INSERT INTO `s_address` VALUES ('2676', '270', '江北区', '3', '', null);
INSERT INTO `s_address` VALUES ('2677', '270', '沙坪坝区', '3', '', null);
INSERT INTO `s_address` VALUES ('2678', '270', '九龙坡区', '3', '', null);
INSERT INTO `s_address` VALUES ('2679', '270', '南岸区', '3', '', null);
INSERT INTO `s_address` VALUES ('2680', '270', '北碚区', '3', '', null);
INSERT INTO `s_address` VALUES ('2681', '270', '万盛区', '3', '', null);
INSERT INTO `s_address` VALUES ('2682', '270', '双桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('2683', '270', '渝北区', '3', '', null);
INSERT INTO `s_address` VALUES ('2684', '270', '巴南区', '3', '', null);
INSERT INTO `s_address` VALUES ('2685', '270', '黔江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2686', '270', '长寿区', '3', '', null);
INSERT INTO `s_address` VALUES ('2687', '270', '綦江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2688', '270', '潼南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2689', '270', '铜梁区', '3', '', null);
INSERT INTO `s_address` VALUES ('2690', '270', '大足区', '3', '', null);
INSERT INTO `s_address` VALUES ('2691', '270', '荣昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2692', '270', '璧山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2693', '270', '梁平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2694', '270', '城口县', '3', '', null);
INSERT INTO `s_address` VALUES ('2695', '270', '丰都县', '3', '', null);
INSERT INTO `s_address` VALUES ('2696', '270', '垫江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2697', '270', '武隆县', '3', '', null);
INSERT INTO `s_address` VALUES ('2698', '270', '忠县', '3', '', null);
INSERT INTO `s_address` VALUES ('2699', '270', '开县', '3', '', null);
INSERT INTO `s_address` VALUES ('2700', '270', '云阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2701', '270', '奉节县', '3', '', null);
INSERT INTO `s_address` VALUES ('2702', '270', '巫山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2703', '270', '巫溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2704', '270', '石柱土家族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2705', '270', '秀山土家族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2706', '270', '酉阳土家族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2707', '270', '彭水苗族土家族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2708', '270', '江津区', '3', '', null);
INSERT INTO `s_address` VALUES ('2709', '270', '合川区', '3', '', null);
INSERT INTO `s_address` VALUES ('2710', '270', '永川区', '3', '', null);
INSERT INTO `s_address` VALUES ('2711', '270', '南川区', '3', '', null);
INSERT INTO `s_address` VALUES ('2712', '270', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2713', '271', '锦江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2714', '271', '青羊区', '3', '', null);
INSERT INTO `s_address` VALUES ('2715', '271', '金牛区', '3', '', null);
INSERT INTO `s_address` VALUES ('2716', '271', '武侯区', '3', '', null);
INSERT INTO `s_address` VALUES ('2717', '271', '成华区', '3', '', null);
INSERT INTO `s_address` VALUES ('2718', '271', '龙泉驿区', '3', '', null);
INSERT INTO `s_address` VALUES ('2719', '271', '青白江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2720', '271', '新都区', '3', '', null);
INSERT INTO `s_address` VALUES ('2721', '271', '温江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2722', '271', '金堂县', '3', '', null);
INSERT INTO `s_address` VALUES ('2723', '271', '双流县', '3', '', null);
INSERT INTO `s_address` VALUES ('2724', '271', '郫县', '3', '', null);
INSERT INTO `s_address` VALUES ('2725', '271', '大邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('2726', '271', '蒲江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2727', '271', '新津县', '3', '', null);
INSERT INTO `s_address` VALUES ('2728', '271', '都江堰市', '3', '', null);
INSERT INTO `s_address` VALUES ('2729', '271', '彭州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2730', '271', '邛崃市', '3', '', null);
INSERT INTO `s_address` VALUES ('2731', '271', '崇州市', '3', '', null);
INSERT INTO `s_address` VALUES ('2732', '271', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2733', '272', '自流井区', '3', '', null);
INSERT INTO `s_address` VALUES ('2734', '272', '贡井区', '3', '', null);
INSERT INTO `s_address` VALUES ('2735', '272', '大安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2736', '272', '沿滩区', '3', '', null);
INSERT INTO `s_address` VALUES ('2737', '272', '荣县', '3', '', null);
INSERT INTO `s_address` VALUES ('2738', '272', '富顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('2739', '272', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2740', '273', '东区', '3', '', null);
INSERT INTO `s_address` VALUES ('2741', '273', '西区', '3', '', null);
INSERT INTO `s_address` VALUES ('2742', '273', '仁和区', '3', '', null);
INSERT INTO `s_address` VALUES ('2743', '273', '米易县', '3', '', null);
INSERT INTO `s_address` VALUES ('2744', '273', '盐边县', '3', '', null);
INSERT INTO `s_address` VALUES ('2745', '273', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2746', '274', '江阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2747', '274', '纳溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('2748', '274', '龙马潭区', '3', '', null);
INSERT INTO `s_address` VALUES ('2749', '274', '泸县', '3', '', null);
INSERT INTO `s_address` VALUES ('2750', '274', '合江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2751', '274', '叙永县', '3', '', null);
INSERT INTO `s_address` VALUES ('2752', '274', '古蔺县', '3', '', null);
INSERT INTO `s_address` VALUES ('2753', '274', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2754', '275', '旌阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2755', '275', '中江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2756', '275', '罗江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2757', '275', '广汉市', '3', '', null);
INSERT INTO `s_address` VALUES ('2758', '275', '什邡市', '3', '', null);
INSERT INTO `s_address` VALUES ('2759', '275', '绵竹市', '3', '', null);
INSERT INTO `s_address` VALUES ('2760', '275', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2761', '276', '涪城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2762', '276', '游仙区', '3', '', null);
INSERT INTO `s_address` VALUES ('2763', '276', '三台县', '3', '', null);
INSERT INTO `s_address` VALUES ('2764', '276', '盐亭县', '3', '', null);
INSERT INTO `s_address` VALUES ('2765', '276', '安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2766', '276', '梓潼县', '3', '', null);
INSERT INTO `s_address` VALUES ('2767', '276', '北川羌族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2768', '276', '平武县', '3', '', null);
INSERT INTO `s_address` VALUES ('2769', '276', '高新区', '3', '', null);
INSERT INTO `s_address` VALUES ('2770', '276', '江油市', '3', '', null);
INSERT INTO `s_address` VALUES ('2771', '276', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2772', '277', '利州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2773', '277', '昭化区', '3', '', null);
INSERT INTO `s_address` VALUES ('2774', '277', '朝天区', '3', '', null);
INSERT INTO `s_address` VALUES ('2775', '277', '旺苍县', '3', '', null);
INSERT INTO `s_address` VALUES ('2776', '277', '青川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2777', '277', '剑阁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2778', '277', '苍溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2779', '277', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2780', '278', '船山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2781', '278', '安居区', '3', '', null);
INSERT INTO `s_address` VALUES ('2782', '278', '蓬溪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2783', '278', '射洪县', '3', '', null);
INSERT INTO `s_address` VALUES ('2784', '278', '大英县', '3', '', null);
INSERT INTO `s_address` VALUES ('2785', '278', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2786', '279', '市中区', '3', '', null);
INSERT INTO `s_address` VALUES ('2787', '279', '东兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('2788', '279', '威远县', '3', '', null);
INSERT INTO `s_address` VALUES ('2789', '279', '资中县', '3', '', null);
INSERT INTO `s_address` VALUES ('2790', '279', '隆昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2791', '279', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2792', '280', '市中区', '3', '', null);
INSERT INTO `s_address` VALUES ('2793', '280', '沙湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('2794', '280', '五通桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('2795', '280', '金口河区', '3', '', null);
INSERT INTO `s_address` VALUES ('2796', '280', '犍为县', '3', '', null);
INSERT INTO `s_address` VALUES ('2797', '280', '井研县', '3', '', null);
INSERT INTO `s_address` VALUES ('2798', '280', '夹江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2799', '280', '沐川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2800', '280', '峨边彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2801', '280', '马边彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2802', '280', '峨眉山市', '3', '', null);
INSERT INTO `s_address` VALUES ('2803', '280', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2804', '281', '顺庆区', '3', '', null);
INSERT INTO `s_address` VALUES ('2805', '281', '高坪区', '3', '', null);
INSERT INTO `s_address` VALUES ('2806', '281', '嘉陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('2807', '281', '南部县', '3', '', null);
INSERT INTO `s_address` VALUES ('2808', '281', '营山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2809', '281', '蓬安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2810', '281', '仪陇县', '3', '', null);
INSERT INTO `s_address` VALUES ('2811', '281', '西充县', '3', '', null);
INSERT INTO `s_address` VALUES ('2812', '281', '阆中市', '3', '', null);
INSERT INTO `s_address` VALUES ('2813', '281', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2814', '282', '东坡区', '3', '', null);
INSERT INTO `s_address` VALUES ('2815', '282', '仁寿县', '3', '', null);
INSERT INTO `s_address` VALUES ('2816', '282', '彭山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2817', '282', '洪雅县', '3', '', null);
INSERT INTO `s_address` VALUES ('2818', '282', '丹棱县', '3', '', null);
INSERT INTO `s_address` VALUES ('2819', '282', '青神县', '3', '', null);
INSERT INTO `s_address` VALUES ('2820', '282', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2821', '283', '翠屏区', '3', '', null);
INSERT INTO `s_address` VALUES ('2822', '283', '宜宾县', '3', '', null);
INSERT INTO `s_address` VALUES ('2823', '283', '南溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('2824', '283', '江安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2825', '283', '长宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2826', '283', '高县', '3', '', null);
INSERT INTO `s_address` VALUES ('2827', '283', '珙县', '3', '', null);
INSERT INTO `s_address` VALUES ('2828', '283', '筠连县', '3', '', null);
INSERT INTO `s_address` VALUES ('2829', '283', '兴文县', '3', '', null);
INSERT INTO `s_address` VALUES ('2830', '283', '屏山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2831', '283', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2832', '284', '广安区', '3', '', null);
INSERT INTO `s_address` VALUES ('2833', '284', '前锋区', '3', '', null);
INSERT INTO `s_address` VALUES ('2834', '284', '岳池县', '3', '', null);
INSERT INTO `s_address` VALUES ('2835', '284', '武胜县', '3', '', null);
INSERT INTO `s_address` VALUES ('2836', '284', '邻水县', '3', '', null);
INSERT INTO `s_address` VALUES ('2837', '284', '华蓥市', '3', '', null);
INSERT INTO `s_address` VALUES ('2838', '284', '市辖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2839', '284', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2840', '285', '通川区', '3', '', null);
INSERT INTO `s_address` VALUES ('2841', '285', '达川区', '3', '', null);
INSERT INTO `s_address` VALUES ('2842', '285', '宣汉县', '3', '', null);
INSERT INTO `s_address` VALUES ('2843', '285', '开江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2844', '285', '大竹县', '3', '', null);
INSERT INTO `s_address` VALUES ('2845', '285', '渠县', '3', '', null);
INSERT INTO `s_address` VALUES ('2846', '285', '万源市', '3', '', null);
INSERT INTO `s_address` VALUES ('2847', '285', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2848', '286', '雨城区', '3', '', null);
INSERT INTO `s_address` VALUES ('2849', '286', '名山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2850', '286', '荥经县', '3', '', null);
INSERT INTO `s_address` VALUES ('2851', '286', '汉源县', '3', '', null);
INSERT INTO `s_address` VALUES ('2852', '286', '石棉县', '3', '', null);
INSERT INTO `s_address` VALUES ('2853', '286', '天全县', '3', '', null);
INSERT INTO `s_address` VALUES ('2854', '286', '芦山县', '3', '', null);
INSERT INTO `s_address` VALUES ('2855', '286', '宝兴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2856', '286', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2857', '287', '巴州区', '3', '', null);
INSERT INTO `s_address` VALUES ('2858', '287', '恩阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('2859', '287', '通江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2860', '287', '南江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2861', '287', '平昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2862', '287', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2863', '288', '雁江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2864', '288', '安岳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2865', '288', '乐至县', '3', '', null);
INSERT INTO `s_address` VALUES ('2866', '288', '简阳市', '3', '', null);
INSERT INTO `s_address` VALUES ('2867', '288', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2868', '289', '汶川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2869', '289', '理县', '3', '', null);
INSERT INTO `s_address` VALUES ('2870', '289', '茂县', '3', '', null);
INSERT INTO `s_address` VALUES ('2871', '289', '松潘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2872', '289', '九寨沟县', '3', '', null);
INSERT INTO `s_address` VALUES ('2873', '289', '金川县', '3', '', null);
INSERT INTO `s_address` VALUES ('2874', '289', '小金县', '3', '', null);
INSERT INTO `s_address` VALUES ('2875', '289', '黑水县', '3', '', null);
INSERT INTO `s_address` VALUES ('2876', '289', '马尔康县', '3', '', null);
INSERT INTO `s_address` VALUES ('2877', '289', '壤塘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2878', '289', '阿坝县', '3', '', null);
INSERT INTO `s_address` VALUES ('2879', '289', '若尔盖县', '3', '', null);
INSERT INTO `s_address` VALUES ('2880', '289', '红原县', '3', '', null);
INSERT INTO `s_address` VALUES ('2881', '289', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2882', '290', '康定市', '3', '', null);
INSERT INTO `s_address` VALUES ('2883', '290', '泸定县', '3', '', null);
INSERT INTO `s_address` VALUES ('2884', '290', '丹巴县', '3', '', null);
INSERT INTO `s_address` VALUES ('2885', '290', '九龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('2886', '290', '雅江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2887', '290', '道孚县', '3', '', null);
INSERT INTO `s_address` VALUES ('2888', '290', '炉霍县', '3', '', null);
INSERT INTO `s_address` VALUES ('2889', '290', '甘孜县', '3', '', null);
INSERT INTO `s_address` VALUES ('2890', '290', '新龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('2891', '290', '德格县', '3', '', null);
INSERT INTO `s_address` VALUES ('2892', '290', '白玉县', '3', '', null);
INSERT INTO `s_address` VALUES ('2893', '290', '石渠县', '3', '', null);
INSERT INTO `s_address` VALUES ('2894', '290', '色达县', '3', '', null);
INSERT INTO `s_address` VALUES ('2895', '290', '理塘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2896', '290', '巴塘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2897', '290', '乡城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2898', '290', '稻城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2899', '290', '得荣县', '3', '', null);
INSERT INTO `s_address` VALUES ('2900', '290', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2901', '291', '西昌市', '3', '', null);
INSERT INTO `s_address` VALUES ('2902', '291', '木里藏族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2903', '291', '盐源县', '3', '', null);
INSERT INTO `s_address` VALUES ('2904', '291', '德昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('2905', '291', '会理县', '3', '', null);
INSERT INTO `s_address` VALUES ('2906', '291', '会东县', '3', '', null);
INSERT INTO `s_address` VALUES ('2907', '291', '宁南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2908', '291', '普格县', '3', '', null);
INSERT INTO `s_address` VALUES ('2909', '291', '布拖县', '3', '', null);
INSERT INTO `s_address` VALUES ('2910', '291', '金阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2911', '291', '昭觉县', '3', '', null);
INSERT INTO `s_address` VALUES ('2912', '291', '喜德县', '3', '', null);
INSERT INTO `s_address` VALUES ('2913', '291', '冕宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2914', '291', '越西县', '3', '', null);
INSERT INTO `s_address` VALUES ('2915', '291', '甘洛县', '3', '', null);
INSERT INTO `s_address` VALUES ('2916', '291', '美姑县', '3', '', null);
INSERT INTO `s_address` VALUES ('2917', '291', '雷波县', '3', '', null);
INSERT INTO `s_address` VALUES ('2918', '291', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2919', '292', '南明区', '3', '', null);
INSERT INTO `s_address` VALUES ('2920', '292', '云岩区', '3', '', null);
INSERT INTO `s_address` VALUES ('2921', '292', '花溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('2922', '292', '乌当区', '3', '', null);
INSERT INTO `s_address` VALUES ('2923', '292', '白云区', '3', '', null);
INSERT INTO `s_address` VALUES ('2924', '292', '小河区', '3', '', null);
INSERT INTO `s_address` VALUES ('2925', '292', '开阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2926', '292', '息烽县', '3', '', null);
INSERT INTO `s_address` VALUES ('2927', '292', '修文县', '3', '', null);
INSERT INTO `s_address` VALUES ('2928', '292', '观山湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('2929', '292', '清镇市', '3', '', null);
INSERT INTO `s_address` VALUES ('2930', '292', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2931', '293', '钟山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2932', '293', '六枝特区', '3', '', null);
INSERT INTO `s_address` VALUES ('2933', '293', '水城县', '3', '', null);
INSERT INTO `s_address` VALUES ('2934', '293', '盘县', '3', '', null);
INSERT INTO `s_address` VALUES ('2935', '293', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2936', '294', '红花岗区', '3', '', null);
INSERT INTO `s_address` VALUES ('2937', '294', '汇川区', '3', '', null);
INSERT INTO `s_address` VALUES ('2938', '294', '遵义县', '3', '', null);
INSERT INTO `s_address` VALUES ('2939', '294', '桐梓县', '3', '', null);
INSERT INTO `s_address` VALUES ('2940', '294', '绥阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('2941', '294', '正安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2942', '294', '道真仡佬族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2943', '294', '务川仡佬族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2944', '294', '凤冈县', '3', '', null);
INSERT INTO `s_address` VALUES ('2945', '294', '湄潭县', '3', '', null);
INSERT INTO `s_address` VALUES ('2946', '294', '余庆县', '3', '', null);
INSERT INTO `s_address` VALUES ('2947', '294', '习水县', '3', '', null);
INSERT INTO `s_address` VALUES ('2948', '294', '赤水市', '3', '', null);
INSERT INTO `s_address` VALUES ('2949', '294', '仁怀市', '3', '', null);
INSERT INTO `s_address` VALUES ('2950', '294', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2951', '295', '西秀区', '3', '', null);
INSERT INTO `s_address` VALUES ('2952', '295', '平坝区', '3', '', null);
INSERT INTO `s_address` VALUES ('2953', '295', '普定县', '3', '', null);
INSERT INTO `s_address` VALUES ('2954', '295', '镇宁布依族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2955', '295', '关岭布依族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2956', '295', '紫云苗族布依族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2957', '295', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2958', '296', '碧江区', '3', '', null);
INSERT INTO `s_address` VALUES ('2959', '296', '江口县', '3', '', null);
INSERT INTO `s_address` VALUES ('2960', '296', '玉屏侗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2961', '296', '石阡县', '3', '', null);
INSERT INTO `s_address` VALUES ('2962', '296', '思南县', '3', '', null);
INSERT INTO `s_address` VALUES ('2963', '296', '印江土家族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2964', '296', '德江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2965', '296', '沿河土家族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2966', '296', '松桃苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2967', '296', '万山区', '3', '', null);
INSERT INTO `s_address` VALUES ('2968', '296', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2969', '297', '兴义市', '3', '', null);
INSERT INTO `s_address` VALUES ('2970', '297', '兴仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('2971', '297', '普安县', '3', '', null);
INSERT INTO `s_address` VALUES ('2972', '297', '晴隆县', '3', '', null);
INSERT INTO `s_address` VALUES ('2973', '297', '贞丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('2974', '297', '望谟县', '3', '', null);
INSERT INTO `s_address` VALUES ('2975', '297', '册亨县', '3', '', null);
INSERT INTO `s_address` VALUES ('2976', '297', '安龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('2977', '297', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2978', '298', '七星关区', '3', '', null);
INSERT INTO `s_address` VALUES ('2979', '298', '大方县', '3', '', null);
INSERT INTO `s_address` VALUES ('2980', '298', '黔西县', '3', '', null);
INSERT INTO `s_address` VALUES ('2981', '298', '金沙县', '3', '', null);
INSERT INTO `s_address` VALUES ('2982', '298', '织金县', '3', '', null);
INSERT INTO `s_address` VALUES ('2983', '298', '纳雍县', '3', '', null);
INSERT INTO `s_address` VALUES ('2984', '298', '威宁彝族回族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('2985', '298', '赫章县', '3', '', null);
INSERT INTO `s_address` VALUES ('2986', '298', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('2987', '299', '凯里市', '3', '', null);
INSERT INTO `s_address` VALUES ('2988', '299', '黄平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2989', '299', '施秉县', '3', '', null);
INSERT INTO `s_address` VALUES ('2990', '299', '三穗县', '3', '', null);
INSERT INTO `s_address` VALUES ('2991', '299', '镇远县', '3', '', null);
INSERT INTO `s_address` VALUES ('2992', '299', '岑巩县', '3', '', null);
INSERT INTO `s_address` VALUES ('2993', '299', '天柱县', '3', '', null);
INSERT INTO `s_address` VALUES ('2994', '299', '锦屏县', '3', '', null);
INSERT INTO `s_address` VALUES ('2995', '299', '剑河县', '3', '', null);
INSERT INTO `s_address` VALUES ('2996', '299', '台江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2997', '299', '黎平县', '3', '', null);
INSERT INTO `s_address` VALUES ('2998', '299', '榕江县', '3', '', null);
INSERT INTO `s_address` VALUES ('2999', '299', '从江县', '3', '', null);
INSERT INTO `s_address` VALUES ('3000', '299', '雷山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3001', '299', '麻江县', '3', '', null);
INSERT INTO `s_address` VALUES ('3002', '299', '丹寨县', '3', '', null);
INSERT INTO `s_address` VALUES ('3003', '299', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3004', '300', '都匀市', '3', '', null);
INSERT INTO `s_address` VALUES ('3005', '300', '福泉市', '3', '', null);
INSERT INTO `s_address` VALUES ('3006', '300', '荔波县', '3', '', null);
INSERT INTO `s_address` VALUES ('3007', '300', '贵定县', '3', '', null);
INSERT INTO `s_address` VALUES ('3008', '300', '瓮安县', '3', '', null);
INSERT INTO `s_address` VALUES ('3009', '300', '独山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3010', '300', '平塘县', '3', '', null);
INSERT INTO `s_address` VALUES ('3011', '300', '罗甸县', '3', '', null);
INSERT INTO `s_address` VALUES ('3012', '300', '长顺县', '3', '', null);
INSERT INTO `s_address` VALUES ('3013', '300', '龙里县', '3', '', null);
INSERT INTO `s_address` VALUES ('3014', '300', '惠水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3015', '300', '三都水族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3016', '300', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3017', '301', '五华区', '3', '', null);
INSERT INTO `s_address` VALUES ('3018', '301', '盘龙区', '3', '', null);
INSERT INTO `s_address` VALUES ('3019', '301', '官渡区', '3', '', null);
INSERT INTO `s_address` VALUES ('3020', '301', '西山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3021', '301', '东川区', '3', '', null);
INSERT INTO `s_address` VALUES ('3022', '301', '呈贡区', '3', '', null);
INSERT INTO `s_address` VALUES ('3023', '301', '晋宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3024', '301', '富民县', '3', '', null);
INSERT INTO `s_address` VALUES ('3025', '301', '宜良县', '3', '', null);
INSERT INTO `s_address` VALUES ('3026', '301', '石林彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3027', '301', '嵩明县', '3', '', null);
INSERT INTO `s_address` VALUES ('3028', '301', '禄劝彝族苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3029', '301', '寻甸回族彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3030', '301', '安宁市', '3', '', null);
INSERT INTO `s_address` VALUES ('3031', '301', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3032', '302', '麒麟区', '3', '', null);
INSERT INTO `s_address` VALUES ('3033', '302', '马龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('3034', '302', '陆良县', '3', '', null);
INSERT INTO `s_address` VALUES ('3035', '302', '师宗县', '3', '', null);
INSERT INTO `s_address` VALUES ('3036', '302', '罗平县', '3', '', null);
INSERT INTO `s_address` VALUES ('3037', '302', '富源县', '3', '', null);
INSERT INTO `s_address` VALUES ('3038', '302', '会泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('3039', '302', '沾益县', '3', '', null);
INSERT INTO `s_address` VALUES ('3040', '302', '宣威市', '3', '', null);
INSERT INTO `s_address` VALUES ('3041', '302', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3042', '303', '红塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('3043', '303', '江川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3044', '303', '澄江县', '3', '', null);
INSERT INTO `s_address` VALUES ('3045', '303', '通海县', '3', '', null);
INSERT INTO `s_address` VALUES ('3046', '303', '华宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3047', '303', '易门县', '3', '', null);
INSERT INTO `s_address` VALUES ('3048', '303', '峨山彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3049', '303', '新平彝族傣族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3050', '303', '元江哈尼族彝族傣族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3051', '303', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3052', '304', '隆阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('3053', '304', '施甸县', '3', '', null);
INSERT INTO `s_address` VALUES ('3054', '304', '腾冲县', '3', '', null);
INSERT INTO `s_address` VALUES ('3055', '304', '龙陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('3056', '304', '昌宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3057', '304', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3058', '305', '昭阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('3059', '305', '鲁甸县', '3', '', null);
INSERT INTO `s_address` VALUES ('3060', '305', '巧家县', '3', '', null);
INSERT INTO `s_address` VALUES ('3061', '305', '盐津县', '3', '', null);
INSERT INTO `s_address` VALUES ('3062', '305', '大关县', '3', '', null);
INSERT INTO `s_address` VALUES ('3063', '305', '永善县', '3', '', null);
INSERT INTO `s_address` VALUES ('3064', '305', '绥江县', '3', '', null);
INSERT INTO `s_address` VALUES ('3065', '305', '镇雄县', '3', '', null);
INSERT INTO `s_address` VALUES ('3066', '305', '彝良县', '3', '', null);
INSERT INTO `s_address` VALUES ('3067', '305', '威信县', '3', '', null);
INSERT INTO `s_address` VALUES ('3068', '305', '水富县', '3', '', null);
INSERT INTO `s_address` VALUES ('3069', '305', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3070', '306', '古城区', '3', '', null);
INSERT INTO `s_address` VALUES ('3071', '306', '玉龙纳西族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3072', '306', '永胜县', '3', '', null);
INSERT INTO `s_address` VALUES ('3073', '306', '华坪县', '3', '', null);
INSERT INTO `s_address` VALUES ('3074', '306', '宁蒗彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3075', '306', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3076', '307', '思茅区', '3', '', null);
INSERT INTO `s_address` VALUES ('3077', '307', '宁洱哈尼族彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3078', '307', '墨江哈尼族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3079', '307', '景东彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3080', '307', '景谷傣族彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3081', '307', '镇沅彝族哈尼族拉祜族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3082', '307', '江城哈尼族彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3083', '307', '孟连傣族拉祜族佤族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3084', '307', '澜沧拉祜族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3085', '307', '西盟佤族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3086', '307', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3087', '308', '临翔区', '3', '', null);
INSERT INTO `s_address` VALUES ('3088', '308', '凤庆县', '3', '', null);
INSERT INTO `s_address` VALUES ('3089', '308', '云县', '3', '', null);
INSERT INTO `s_address` VALUES ('3090', '308', '永德县', '3', '', null);
INSERT INTO `s_address` VALUES ('3091', '308', '镇康县', '3', '', null);
INSERT INTO `s_address` VALUES ('3092', '308', '双江拉祜族佤族布朗族傣族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3093', '308', '耿马傣族佤族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3094', '308', '沧源佤族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3095', '308', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3096', '309', '楚雄市', '3', '', null);
INSERT INTO `s_address` VALUES ('3097', '309', '双柏县', '3', '', null);
INSERT INTO `s_address` VALUES ('3098', '309', '牟定县', '3', '', null);
INSERT INTO `s_address` VALUES ('3099', '309', '南华县', '3', '', null);
INSERT INTO `s_address` VALUES ('3100', '309', '姚安县', '3', '', null);
INSERT INTO `s_address` VALUES ('3101', '309', '大姚县', '3', '', null);
INSERT INTO `s_address` VALUES ('3102', '309', '永仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3103', '309', '元谋县', '3', '', null);
INSERT INTO `s_address` VALUES ('3104', '309', '武定县', '3', '', null);
INSERT INTO `s_address` VALUES ('3105', '309', '禄丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3106', '309', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3107', '310', '个旧市', '3', '', null);
INSERT INTO `s_address` VALUES ('3108', '310', '开远市', '3', '', null);
INSERT INTO `s_address` VALUES ('3109', '310', '蒙自市', '3', '', null);
INSERT INTO `s_address` VALUES ('3110', '310', '屏边苗族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3111', '310', '建水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3112', '310', '石屏县', '3', '', null);
INSERT INTO `s_address` VALUES ('3113', '310', '弥勒市', '3', '', null);
INSERT INTO `s_address` VALUES ('3114', '310', '泸西县', '3', '', null);
INSERT INTO `s_address` VALUES ('3115', '310', '元阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3116', '310', '红河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3117', '310', '金平苗族瑶族傣族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3118', '310', '绿春县', '3', '', null);
INSERT INTO `s_address` VALUES ('3119', '310', '河口瑶族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3120', '310', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3121', '311', '文山市', '3', '', null);
INSERT INTO `s_address` VALUES ('3122', '311', '砚山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3123', '311', '西畴县', '3', '', null);
INSERT INTO `s_address` VALUES ('3124', '311', '麻栗坡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3125', '311', '马关县', '3', '', null);
INSERT INTO `s_address` VALUES ('3126', '311', '丘北县', '3', '', null);
INSERT INTO `s_address` VALUES ('3127', '311', '广南县', '3', '', null);
INSERT INTO `s_address` VALUES ('3128', '311', '富宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3129', '311', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3130', '312', '景洪市', '3', '', null);
INSERT INTO `s_address` VALUES ('3131', '312', '勐海县', '3', '', null);
INSERT INTO `s_address` VALUES ('3132', '312', '勐腊县', '3', '', null);
INSERT INTO `s_address` VALUES ('3133', '312', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3134', '313', '大理市', '3', '', null);
INSERT INTO `s_address` VALUES ('3135', '313', '漾濞彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3136', '313', '祥云县', '3', '', null);
INSERT INTO `s_address` VALUES ('3137', '313', '宾川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3138', '313', '弥渡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3139', '313', '南涧彝族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3140', '313', '巍山彝族回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3141', '313', '永平县', '3', '', null);
INSERT INTO `s_address` VALUES ('3142', '313', '云龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('3143', '313', '洱源县', '3', '', null);
INSERT INTO `s_address` VALUES ('3144', '313', '剑川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3145', '313', '鹤庆县', '3', '', null);
INSERT INTO `s_address` VALUES ('3146', '313', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3147', '314', '瑞丽市', '3', '', null);
INSERT INTO `s_address` VALUES ('3148', '314', '芒市', '3', '', null);
INSERT INTO `s_address` VALUES ('3149', '314', '梁河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3150', '314', '盈江县', '3', '', null);
INSERT INTO `s_address` VALUES ('3151', '314', '陇川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3152', '314', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3153', '315', '泸水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3154', '315', '福贡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3155', '315', '贡山独龙族怒族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3156', '315', '兰坪白族普米族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3157', '315', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3158', '316', '香格里拉市', '3', '', null);
INSERT INTO `s_address` VALUES ('3159', '316', '德钦县', '3', '', null);
INSERT INTO `s_address` VALUES ('3160', '316', '维西傈僳族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3161', '316', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3162', '317', '城关区', '3', '', null);
INSERT INTO `s_address` VALUES ('3163', '317', '林周县', '3', '', null);
INSERT INTO `s_address` VALUES ('3164', '317', '当雄县', '3', '', null);
INSERT INTO `s_address` VALUES ('3165', '317', '尼木县', '3', '', null);
INSERT INTO `s_address` VALUES ('3166', '317', '曲水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3167', '317', '堆龙德庆县', '3', '', null);
INSERT INTO `s_address` VALUES ('3168', '317', '达孜县', '3', '', null);
INSERT INTO `s_address` VALUES ('3169', '317', '墨竹工卡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3170', '317', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3171', '318', '卡若区', '3', '', null);
INSERT INTO `s_address` VALUES ('3172', '318', '江达县', '3', '', null);
INSERT INTO `s_address` VALUES ('3173', '318', '贡觉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3174', '318', '类乌齐县', '3', '', null);
INSERT INTO `s_address` VALUES ('3175', '318', '丁青县', '3', '', null);
INSERT INTO `s_address` VALUES ('3176', '318', '察雅县', '3', '', null);
INSERT INTO `s_address` VALUES ('3177', '318', '八宿县', '3', '', null);
INSERT INTO `s_address` VALUES ('3178', '318', '左贡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3179', '318', '芒康县', '3', '', null);
INSERT INTO `s_address` VALUES ('3180', '318', '洛隆县', '3', '', null);
INSERT INTO `s_address` VALUES ('3181', '318', '边坝县', '3', '', null);
INSERT INTO `s_address` VALUES ('3182', '318', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3183', '319', '乃东县', '3', '', null);
INSERT INTO `s_address` VALUES ('3184', '319', '扎囊县', '3', '', null);
INSERT INTO `s_address` VALUES ('3185', '319', '贡嘎县', '3', '', null);
INSERT INTO `s_address` VALUES ('3186', '319', '桑日县', '3', '', null);
INSERT INTO `s_address` VALUES ('3187', '319', '琼结县', '3', '', null);
INSERT INTO `s_address` VALUES ('3188', '319', '曲松县', '3', '', null);
INSERT INTO `s_address` VALUES ('3189', '319', '措美县', '3', '', null);
INSERT INTO `s_address` VALUES ('3190', '319', '洛扎县', '3', '', null);
INSERT INTO `s_address` VALUES ('3191', '319', '加查县', '3', '', null);
INSERT INTO `s_address` VALUES ('3192', '319', '隆子县', '3', '', null);
INSERT INTO `s_address` VALUES ('3193', '319', '错那县', '3', '', null);
INSERT INTO `s_address` VALUES ('3194', '319', '浪卡子县', '3', '', null);
INSERT INTO `s_address` VALUES ('3195', '319', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3196', '320', '桑珠孜区', '3', '', null);
INSERT INTO `s_address` VALUES ('3197', '320', '南木林县', '3', '', null);
INSERT INTO `s_address` VALUES ('3198', '320', '江孜县', '3', '', null);
INSERT INTO `s_address` VALUES ('3199', '320', '定日县', '3', '', null);
INSERT INTO `s_address` VALUES ('3200', '320', '萨迦县', '3', '', null);
INSERT INTO `s_address` VALUES ('3201', '320', '拉孜县', '3', '', null);
INSERT INTO `s_address` VALUES ('3202', '320', '昂仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3203', '320', '谢通门县', '3', '', null);
INSERT INTO `s_address` VALUES ('3204', '320', '白朗县', '3', '', null);
INSERT INTO `s_address` VALUES ('3205', '320', '仁布县', '3', '', null);
INSERT INTO `s_address` VALUES ('3206', '320', '康马县', '3', '', null);
INSERT INTO `s_address` VALUES ('3207', '320', '定结县', '3', '', null);
INSERT INTO `s_address` VALUES ('3208', '320', '仲巴县', '3', '', null);
INSERT INTO `s_address` VALUES ('3209', '320', '亚东县', '3', '', null);
INSERT INTO `s_address` VALUES ('3210', '320', '吉隆县', '3', '', null);
INSERT INTO `s_address` VALUES ('3211', '320', '聂拉木县', '3', '', null);
INSERT INTO `s_address` VALUES ('3212', '320', '萨嘎县', '3', '', null);
INSERT INTO `s_address` VALUES ('3213', '320', '岗巴县', '3', '', null);
INSERT INTO `s_address` VALUES ('3214', '320', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3215', '321', '那曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('3216', '321', '嘉黎县', '3', '', null);
INSERT INTO `s_address` VALUES ('3217', '321', '比如县', '3', '', null);
INSERT INTO `s_address` VALUES ('3218', '321', '聂荣县', '3', '', null);
INSERT INTO `s_address` VALUES ('3219', '321', '安多县', '3', '', null);
INSERT INTO `s_address` VALUES ('3220', '321', '申扎县', '3', '', null);
INSERT INTO `s_address` VALUES ('3221', '321', '索县', '3', '', null);
INSERT INTO `s_address` VALUES ('3222', '321', '班戈县', '3', '', null);
INSERT INTO `s_address` VALUES ('3223', '321', '巴青县', '3', '', null);
INSERT INTO `s_address` VALUES ('3224', '321', '尼玛县', '3', '', null);
INSERT INTO `s_address` VALUES ('3225', '321', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3226', '321', '双湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('3227', '322', '普兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3228', '322', '札达县', '3', '', null);
INSERT INTO `s_address` VALUES ('3229', '322', '噶尔县', '3', '', null);
INSERT INTO `s_address` VALUES ('3230', '322', '日土县', '3', '', null);
INSERT INTO `s_address` VALUES ('3231', '322', '革吉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3232', '322', '改则县', '3', '', null);
INSERT INTO `s_address` VALUES ('3233', '322', '措勤县', '3', '', null);
INSERT INTO `s_address` VALUES ('3234', '322', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3235', '323', '巴宜区', '3', '', null);
INSERT INTO `s_address` VALUES ('3236', '323', '工布江达县', '3', '', null);
INSERT INTO `s_address` VALUES ('3237', '323', '米林县', '3', '', null);
INSERT INTO `s_address` VALUES ('3238', '323', '墨脱县', '3', '', null);
INSERT INTO `s_address` VALUES ('3239', '323', '波密县', '3', '', null);
INSERT INTO `s_address` VALUES ('3240', '323', '察隅县', '3', '', null);
INSERT INTO `s_address` VALUES ('3241', '323', '朗县', '3', '', null);
INSERT INTO `s_address` VALUES ('3242', '323', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3243', '324', '新城区', '3', '', null);
INSERT INTO `s_address` VALUES ('3244', '324', '碑林区', '3', '', null);
INSERT INTO `s_address` VALUES ('3245', '324', '莲湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('3246', '324', '灞桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('3247', '324', '未央区', '3', '', null);
INSERT INTO `s_address` VALUES ('3248', '324', '雁塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('3249', '324', '阎良区', '3', '', null);
INSERT INTO `s_address` VALUES ('3250', '324', '临潼区', '3', '', null);
INSERT INTO `s_address` VALUES ('3251', '324', '长安区', '3', '', null);
INSERT INTO `s_address` VALUES ('3252', '324', '蓝田县', '3', '', null);
INSERT INTO `s_address` VALUES ('3253', '324', '周至县', '3', '', null);
INSERT INTO `s_address` VALUES ('3254', '324', '户县', '3', '', null);
INSERT INTO `s_address` VALUES ('3255', '324', '高陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('3256', '324', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3257', '325', '王益区', '3', '', null);
INSERT INTO `s_address` VALUES ('3258', '325', '印台区', '3', '', null);
INSERT INTO `s_address` VALUES ('3259', '325', '耀州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3260', '325', '宜君县', '3', '', null);
INSERT INTO `s_address` VALUES ('3261', '325', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3262', '326', '渭滨区', '3', '', null);
INSERT INTO `s_address` VALUES ('3263', '326', '金台区', '3', '', null);
INSERT INTO `s_address` VALUES ('3264', '326', '陈仓区', '3', '', null);
INSERT INTO `s_address` VALUES ('3265', '326', '凤翔县', '3', '', null);
INSERT INTO `s_address` VALUES ('3266', '326', '岐山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3267', '326', '扶风县', '3', '', null);
INSERT INTO `s_address` VALUES ('3268', '326', '眉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3269', '326', '陇县', '3', '', null);
INSERT INTO `s_address` VALUES ('3270', '326', '千阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3271', '326', '麟游县', '3', '', null);
INSERT INTO `s_address` VALUES ('3272', '326', '凤县', '3', '', null);
INSERT INTO `s_address` VALUES ('3273', '326', '太白县', '3', '', null);
INSERT INTO `s_address` VALUES ('3274', '326', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3275', '327', '秦都区', '3', '', null);
INSERT INTO `s_address` VALUES ('3276', '327', '杨陵区', '3', '', null);
INSERT INTO `s_address` VALUES ('3277', '327', '渭城区', '3', '', null);
INSERT INTO `s_address` VALUES ('3278', '327', '三原县', '3', '', null);
INSERT INTO `s_address` VALUES ('3279', '327', '泾阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3280', '327', '乾县', '3', '', null);
INSERT INTO `s_address` VALUES ('3281', '327', '礼泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3282', '327', '永寿县', '3', '', null);
INSERT INTO `s_address` VALUES ('3283', '327', '彬县', '3', '', null);
INSERT INTO `s_address` VALUES ('3284', '327', '长武县', '3', '', null);
INSERT INTO `s_address` VALUES ('3285', '327', '旬邑县', '3', '', null);
INSERT INTO `s_address` VALUES ('3286', '327', '淳化县', '3', '', null);
INSERT INTO `s_address` VALUES ('3287', '327', '武功县', '3', '', null);
INSERT INTO `s_address` VALUES ('3288', '327', '兴平市', '3', '', null);
INSERT INTO `s_address` VALUES ('3289', '327', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3290', '328', '临渭区', '3', '', null);
INSERT INTO `s_address` VALUES ('3291', '328', '华县', '3', '', null);
INSERT INTO `s_address` VALUES ('3292', '328', '潼关县', '3', '', null);
INSERT INTO `s_address` VALUES ('3293', '328', '大荔县', '3', '', null);
INSERT INTO `s_address` VALUES ('3294', '328', '合阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3295', '328', '澄城县', '3', '', null);
INSERT INTO `s_address` VALUES ('3296', '328', '蒲城县', '3', '', null);
INSERT INTO `s_address` VALUES ('3297', '328', '白水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3298', '328', '富平县', '3', '', null);
INSERT INTO `s_address` VALUES ('3299', '328', '韩城市', '3', '', null);
INSERT INTO `s_address` VALUES ('3300', '328', '华阴市', '3', '', null);
INSERT INTO `s_address` VALUES ('3301', '328', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3302', '329', '宝塔区', '3', '', null);
INSERT INTO `s_address` VALUES ('3303', '329', '延长县', '3', '', null);
INSERT INTO `s_address` VALUES ('3304', '329', '延川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3305', '329', '子长县', '3', '', null);
INSERT INTO `s_address` VALUES ('3306', '329', '安塞县', '3', '', null);
INSERT INTO `s_address` VALUES ('3307', '329', '志丹县', '3', '', null);
INSERT INTO `s_address` VALUES ('3308', '329', '吴起县', '3', '', null);
INSERT INTO `s_address` VALUES ('3309', '329', '甘泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3310', '329', '富县', '3', '', null);
INSERT INTO `s_address` VALUES ('3311', '329', '洛川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3312', '329', '宜川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3313', '329', '黄龙县', '3', '', null);
INSERT INTO `s_address` VALUES ('3314', '329', '黄陵县', '3', '', null);
INSERT INTO `s_address` VALUES ('3315', '329', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3316', '330', '汉台区', '3', '', null);
INSERT INTO `s_address` VALUES ('3317', '330', '南郑县', '3', '', null);
INSERT INTO `s_address` VALUES ('3318', '330', '城固县', '3', '', null);
INSERT INTO `s_address` VALUES ('3319', '330', '洋县', '3', '', null);
INSERT INTO `s_address` VALUES ('3320', '330', '西乡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3321', '330', '勉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3322', '330', '宁强县', '3', '', null);
INSERT INTO `s_address` VALUES ('3323', '330', '略阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3324', '330', '镇巴县', '3', '', null);
INSERT INTO `s_address` VALUES ('3325', '330', '留坝县', '3', '', null);
INSERT INTO `s_address` VALUES ('3326', '330', '佛坪县', '3', '', null);
INSERT INTO `s_address` VALUES ('3327', '330', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3328', '331', '榆阳区', '3', '', null);
INSERT INTO `s_address` VALUES ('3329', '331', '神木县', '3', '', null);
INSERT INTO `s_address` VALUES ('3330', '331', '府谷县', '3', '', null);
INSERT INTO `s_address` VALUES ('3331', '331', '横山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3332', '331', '靖边县', '3', '', null);
INSERT INTO `s_address` VALUES ('3333', '331', '定边县', '3', '', null);
INSERT INTO `s_address` VALUES ('3334', '331', '绥德县', '3', '', null);
INSERT INTO `s_address` VALUES ('3335', '331', '米脂县', '3', '', null);
INSERT INTO `s_address` VALUES ('3336', '331', '佳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3337', '331', '吴堡县', '3', '', null);
INSERT INTO `s_address` VALUES ('3338', '331', '清涧县', '3', '', null);
INSERT INTO `s_address` VALUES ('3339', '331', '子洲县', '3', '', null);
INSERT INTO `s_address` VALUES ('3340', '331', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3341', '332', '汉滨区', '3', '', null);
INSERT INTO `s_address` VALUES ('3342', '332', '汉阴县', '3', '', null);
INSERT INTO `s_address` VALUES ('3343', '332', '石泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3344', '332', '宁陕县', '3', '', null);
INSERT INTO `s_address` VALUES ('3345', '332', '紫阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3346', '332', '岚皋县', '3', '', null);
INSERT INTO `s_address` VALUES ('3347', '332', '平利县', '3', '', null);
INSERT INTO `s_address` VALUES ('3348', '332', '镇坪县', '3', '', null);
INSERT INTO `s_address` VALUES ('3349', '332', '旬阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3350', '332', '白河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3351', '332', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3352', '333', '商州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3353', '333', '洛南县', '3', '', null);
INSERT INTO `s_address` VALUES ('3354', '333', '丹凤县', '3', '', null);
INSERT INTO `s_address` VALUES ('3355', '333', '商南县', '3', '', null);
INSERT INTO `s_address` VALUES ('3356', '333', '山阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3357', '333', '镇安县', '3', '', null);
INSERT INTO `s_address` VALUES ('3358', '333', '柞水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3359', '333', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3360', '334', '城关区', '3', '', null);
INSERT INTO `s_address` VALUES ('3361', '334', '七里河区', '3', '', null);
INSERT INTO `s_address` VALUES ('3362', '334', '西固区', '3', '', null);
INSERT INTO `s_address` VALUES ('3363', '334', '安宁区', '3', '', null);
INSERT INTO `s_address` VALUES ('3364', '334', '红古区', '3', '', null);
INSERT INTO `s_address` VALUES ('3365', '334', '永登县', '3', '', null);
INSERT INTO `s_address` VALUES ('3366', '334', '皋兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3367', '334', '榆中县', '3', '', null);
INSERT INTO `s_address` VALUES ('3368', '334', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3369', '336', '金川区', '3', '', null);
INSERT INTO `s_address` VALUES ('3370', '336', '永昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('3371', '336', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3372', '337', '白银区', '3', '', null);
INSERT INTO `s_address` VALUES ('3373', '337', '平川区', '3', '', null);
INSERT INTO `s_address` VALUES ('3374', '337', '靖远县', '3', '', null);
INSERT INTO `s_address` VALUES ('3375', '337', '会宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3376', '337', '景泰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3377', '337', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3378', '338', '秦州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3379', '338', '麦积区', '3', '', null);
INSERT INTO `s_address` VALUES ('3380', '338', '清水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3381', '338', '秦安县', '3', '', null);
INSERT INTO `s_address` VALUES ('3382', '338', '甘谷县', '3', '', null);
INSERT INTO `s_address` VALUES ('3383', '338', '武山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3384', '338', '张家川回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3385', '338', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3386', '339', '凉州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3387', '339', '民勤县', '3', '', null);
INSERT INTO `s_address` VALUES ('3388', '339', '古浪县', '3', '', null);
INSERT INTO `s_address` VALUES ('3389', '339', '天祝藏族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3390', '339', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3391', '340', '甘州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3392', '340', '肃南裕固族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3393', '340', '民乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('3394', '340', '临泽县', '3', '', null);
INSERT INTO `s_address` VALUES ('3395', '340', '高台县', '3', '', null);
INSERT INTO `s_address` VALUES ('3396', '340', '山丹县', '3', '', null);
INSERT INTO `s_address` VALUES ('3397', '340', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3398', '341', '崆峒区', '3', '', null);
INSERT INTO `s_address` VALUES ('3399', '341', '泾川县', '3', '', null);
INSERT INTO `s_address` VALUES ('3400', '341', '灵台县', '3', '', null);
INSERT INTO `s_address` VALUES ('3401', '341', '崇信县', '3', '', null);
INSERT INTO `s_address` VALUES ('3402', '341', '华亭县', '3', '', null);
INSERT INTO `s_address` VALUES ('3403', '341', '庄浪县', '3', '', null);
INSERT INTO `s_address` VALUES ('3404', '341', '静宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3405', '341', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3406', '342', '肃州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3407', '342', '金塔县', '3', '', null);
INSERT INTO `s_address` VALUES ('3408', '342', '瓜州县', '3', '', null);
INSERT INTO `s_address` VALUES ('3409', '342', '肃北蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3410', '342', '阿克塞哈萨克族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3411', '342', '玉门市', '3', '', null);
INSERT INTO `s_address` VALUES ('3412', '342', '敦煌市', '3', '', null);
INSERT INTO `s_address` VALUES ('3413', '342', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3414', '343', '西峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('3415', '343', '庆城县', '3', '', null);
INSERT INTO `s_address` VALUES ('3416', '343', '环县', '3', '', null);
INSERT INTO `s_address` VALUES ('3417', '343', '华池县', '3', '', null);
INSERT INTO `s_address` VALUES ('3418', '343', '合水县', '3', '', null);
INSERT INTO `s_address` VALUES ('3419', '343', '正宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3420', '343', '宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3421', '343', '镇原县', '3', '', null);
INSERT INTO `s_address` VALUES ('3422', '343', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3423', '344', '安定区', '3', '', null);
INSERT INTO `s_address` VALUES ('3424', '344', '通渭县', '3', '', null);
INSERT INTO `s_address` VALUES ('3425', '344', '陇西县', '3', '', null);
INSERT INTO `s_address` VALUES ('3426', '344', '渭源县', '3', '', null);
INSERT INTO `s_address` VALUES ('3427', '344', '临洮县', '3', '', null);
INSERT INTO `s_address` VALUES ('3428', '344', '漳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3429', '344', '岷县', '3', '', null);
INSERT INTO `s_address` VALUES ('3430', '344', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3431', '345', '武都区', '3', '', null);
INSERT INTO `s_address` VALUES ('3432', '345', '成县', '3', '', null);
INSERT INTO `s_address` VALUES ('3433', '345', '文县', '3', '', null);
INSERT INTO `s_address` VALUES ('3434', '345', '宕昌县', '3', '', null);
INSERT INTO `s_address` VALUES ('3435', '345', '康县', '3', '', null);
INSERT INTO `s_address` VALUES ('3436', '345', '西和县', '3', '', null);
INSERT INTO `s_address` VALUES ('3437', '345', '礼县', '3', '', null);
INSERT INTO `s_address` VALUES ('3438', '345', '徽县', '3', '', null);
INSERT INTO `s_address` VALUES ('3439', '345', '两当县', '3', '', null);
INSERT INTO `s_address` VALUES ('3440', '345', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3441', '346', '临夏市', '3', '', null);
INSERT INTO `s_address` VALUES ('3442', '346', '临夏县', '3', '', null);
INSERT INTO `s_address` VALUES ('3443', '346', '康乐县', '3', '', null);
INSERT INTO `s_address` VALUES ('3444', '346', '永靖县', '3', '', null);
INSERT INTO `s_address` VALUES ('3445', '346', '广河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3446', '346', '和政县', '3', '', null);
INSERT INTO `s_address` VALUES ('3447', '346', '东乡族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3448', '346', '积石山保安族东乡族撒拉族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3449', '346', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3450', '347', '合作市', '3', '', null);
INSERT INTO `s_address` VALUES ('3451', '347', '临潭县', '3', '', null);
INSERT INTO `s_address` VALUES ('3452', '347', '卓尼县', '3', '', null);
INSERT INTO `s_address` VALUES ('3453', '347', '舟曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('3454', '347', '迭部县', '3', '', null);
INSERT INTO `s_address` VALUES ('3455', '347', '玛曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('3456', '347', '碌曲县', '3', '', null);
INSERT INTO `s_address` VALUES ('3457', '347', '夏河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3458', '347', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3459', '348', '城东区', '3', '', null);
INSERT INTO `s_address` VALUES ('3460', '348', '城中区', '3', '', null);
INSERT INTO `s_address` VALUES ('3461', '348', '城西区', '3', '', null);
INSERT INTO `s_address` VALUES ('3462', '348', '城北区', '3', '', null);
INSERT INTO `s_address` VALUES ('3463', '348', '大通回族土族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3464', '348', '湟中县', '3', '', null);
INSERT INTO `s_address` VALUES ('3465', '348', '湟源县', '3', '', null);
INSERT INTO `s_address` VALUES ('3466', '348', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3467', '349', '平安区', '3', '', null);
INSERT INTO `s_address` VALUES ('3468', '349', '民和回族土族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3469', '349', '乐都区', '3', '', null);
INSERT INTO `s_address` VALUES ('3470', '349', '互助土族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3471', '349', '化隆回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3472', '349', '循化撒拉族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3473', '349', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3474', '350', '门源回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3475', '350', '祁连县', '3', '', null);
INSERT INTO `s_address` VALUES ('3476', '350', '海晏县', '3', '', null);
INSERT INTO `s_address` VALUES ('3477', '350', '刚察县', '3', '', null);
INSERT INTO `s_address` VALUES ('3478', '350', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3479', '351', '同仁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3480', '351', '尖扎县', '3', '', null);
INSERT INTO `s_address` VALUES ('3481', '351', '泽库县', '3', '', null);
INSERT INTO `s_address` VALUES ('3482', '351', '河南蒙古族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3483', '351', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3484', '352', '共和县', '3', '', null);
INSERT INTO `s_address` VALUES ('3485', '352', '同德县', '3', '', null);
INSERT INTO `s_address` VALUES ('3486', '352', '贵德县', '3', '', null);
INSERT INTO `s_address` VALUES ('3487', '352', '兴海县', '3', '', null);
INSERT INTO `s_address` VALUES ('3488', '352', '贵南县', '3', '', null);
INSERT INTO `s_address` VALUES ('3489', '352', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3490', '353', '玛沁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3491', '353', '班玛县', '3', '', null);
INSERT INTO `s_address` VALUES ('3492', '353', '甘德县', '3', '', null);
INSERT INTO `s_address` VALUES ('3493', '353', '达日县', '3', '', null);
INSERT INTO `s_address` VALUES ('3494', '353', '久治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3495', '353', '玛多县', '3', '', null);
INSERT INTO `s_address` VALUES ('3496', '353', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3497', '354', '玉树市', '3', '', null);
INSERT INTO `s_address` VALUES ('3498', '354', '杂多县', '3', '', null);
INSERT INTO `s_address` VALUES ('3499', '354', '称多县', '3', '', null);
INSERT INTO `s_address` VALUES ('3500', '354', '治多县', '3', '', null);
INSERT INTO `s_address` VALUES ('3501', '354', '囊谦县', '3', '', null);
INSERT INTO `s_address` VALUES ('3502', '354', '曲麻莱县', '3', '', null);
INSERT INTO `s_address` VALUES ('3503', '354', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3504', '355', '格尔木市', '3', '', null);
INSERT INTO `s_address` VALUES ('3505', '355', '德令哈市', '3', '', null);
INSERT INTO `s_address` VALUES ('3506', '355', '乌兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3507', '355', '都兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3508', '355', '天峻县', '3', '', null);
INSERT INTO `s_address` VALUES ('3509', '355', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3510', '356', '兴庆区', '3', '', null);
INSERT INTO `s_address` VALUES ('3511', '356', '西夏区', '3', '', null);
INSERT INTO `s_address` VALUES ('3512', '356', '金凤区', '3', '', null);
INSERT INTO `s_address` VALUES ('3513', '356', '永宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3514', '356', '贺兰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3515', '356', '灵武市', '3', '', null);
INSERT INTO `s_address` VALUES ('3516', '356', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3517', '357', '大武口区', '3', '', null);
INSERT INTO `s_address` VALUES ('3518', '357', '惠农区', '3', '', null);
INSERT INTO `s_address` VALUES ('3519', '357', '平罗县', '3', '', null);
INSERT INTO `s_address` VALUES ('3520', '357', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3521', '358', '利通区', '3', '', null);
INSERT INTO `s_address` VALUES ('3522', '358', '红寺堡区', '3', '', null);
INSERT INTO `s_address` VALUES ('3523', '358', '盐池县', '3', '', null);
INSERT INTO `s_address` VALUES ('3524', '358', '同心县', '3', '', null);
INSERT INTO `s_address` VALUES ('3525', '358', '青铜峡市', '3', '', null);
INSERT INTO `s_address` VALUES ('3526', '358', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3527', '359', '原州区', '3', '', null);
INSERT INTO `s_address` VALUES ('3528', '359', '西吉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3529', '359', '隆德县', '3', '', null);
INSERT INTO `s_address` VALUES ('3530', '359', '泾源县', '3', '', null);
INSERT INTO `s_address` VALUES ('3531', '359', '彭阳县', '3', '', null);
INSERT INTO `s_address` VALUES ('3532', '359', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3533', '360', '沙坡头区', '3', '', null);
INSERT INTO `s_address` VALUES ('3534', '360', '中宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3535', '360', '海原县', '3', '', null);
INSERT INTO `s_address` VALUES ('3536', '360', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3537', '361', '天山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3538', '361', '沙依巴克区', '3', '', null);
INSERT INTO `s_address` VALUES ('3539', '361', '新市区', '3', '', null);
INSERT INTO `s_address` VALUES ('3540', '361', '水磨沟区', '3', '', null);
INSERT INTO `s_address` VALUES ('3541', '361', '头屯河区', '3', '', null);
INSERT INTO `s_address` VALUES ('3542', '361', '达坂城区', '3', '', null);
INSERT INTO `s_address` VALUES ('3543', '361', '东山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3544', '361', '米东区', '3', '', null);
INSERT INTO `s_address` VALUES ('3545', '361', '乌鲁木齐县', '3', '', null);
INSERT INTO `s_address` VALUES ('3546', '361', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3547', '362', '独山子区', '3', '', null);
INSERT INTO `s_address` VALUES ('3548', '362', '克拉玛依区', '3', '', null);
INSERT INTO `s_address` VALUES ('3549', '362', '白碱滩区', '3', '', null);
INSERT INTO `s_address` VALUES ('3550', '362', '乌尔禾区', '3', '', null);
INSERT INTO `s_address` VALUES ('3551', '362', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3552', '363', '高昌区', '3', '', null);
INSERT INTO `s_address` VALUES ('3553', '363', '鄯善县', '3', '', null);
INSERT INTO `s_address` VALUES ('3554', '363', '托克逊县', '3', '', null);
INSERT INTO `s_address` VALUES ('3555', '363', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3556', '364', '哈密市', '3', '', null);
INSERT INTO `s_address` VALUES ('3557', '364', '巴里坤哈萨克自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3558', '364', '伊吾县', '3', '', null);
INSERT INTO `s_address` VALUES ('3559', '364', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3560', '365', '昌吉市', '3', '', null);
INSERT INTO `s_address` VALUES ('3561', '365', '阜康市', '3', '', null);
INSERT INTO `s_address` VALUES ('3562', '365', '米泉市', '3', '', null);
INSERT INTO `s_address` VALUES ('3563', '365', '呼图壁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3564', '365', '玛纳斯县', '3', '', null);
INSERT INTO `s_address` VALUES ('3565', '365', '奇台县', '3', '', null);
INSERT INTO `s_address` VALUES ('3566', '365', '吉木萨尔县', '3', '', null);
INSERT INTO `s_address` VALUES ('3567', '365', '木垒哈萨克自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3568', '365', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3569', '366', '博乐市', '3', '', null);
INSERT INTO `s_address` VALUES ('3570', '366', '阿拉山口市', '3', '', null);
INSERT INTO `s_address` VALUES ('3571', '366', '精河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3572', '366', '温泉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3573', '366', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3574', '367', '库尔勒市', '3', '', null);
INSERT INTO `s_address` VALUES ('3575', '367', '轮台县', '3', '', null);
INSERT INTO `s_address` VALUES ('3576', '367', '尉犁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3577', '367', '若羌县', '3', '', null);
INSERT INTO `s_address` VALUES ('3578', '367', '且末县', '3', '', null);
INSERT INTO `s_address` VALUES ('3579', '367', '焉耆回族自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3580', '367', '和静县', '3', '', null);
INSERT INTO `s_address` VALUES ('3581', '367', '和硕县', '3', '', null);
INSERT INTO `s_address` VALUES ('3582', '367', '博湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('3583', '367', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3584', '368', '阿克苏市', '3', '', null);
INSERT INTO `s_address` VALUES ('3585', '368', '温宿县', '3', '', null);
INSERT INTO `s_address` VALUES ('3586', '368', '库车县', '3', '', null);
INSERT INTO `s_address` VALUES ('3587', '368', '沙雅县', '3', '', null);
INSERT INTO `s_address` VALUES ('3588', '368', '新和县', '3', '', null);
INSERT INTO `s_address` VALUES ('3589', '368', '拜城县', '3', '', null);
INSERT INTO `s_address` VALUES ('3590', '368', '乌什县', '3', '', null);
INSERT INTO `s_address` VALUES ('3591', '368', '阿瓦提县', '3', '', null);
INSERT INTO `s_address` VALUES ('3592', '368', '柯坪县', '3', '', null);
INSERT INTO `s_address` VALUES ('3593', '368', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3594', '369', '阿图什市', '3', '', null);
INSERT INTO `s_address` VALUES ('3595', '369', '阿克陶县', '3', '', null);
INSERT INTO `s_address` VALUES ('3596', '369', '阿合奇县', '3', '', null);
INSERT INTO `s_address` VALUES ('3597', '369', '乌恰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3598', '369', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3599', '370', '喀什市', '3', '', null);
INSERT INTO `s_address` VALUES ('3600', '370', '疏附县', '3', '', null);
INSERT INTO `s_address` VALUES ('3601', '370', '疏勒县', '3', '', null);
INSERT INTO `s_address` VALUES ('3602', '370', '英吉沙县', '3', '', null);
INSERT INTO `s_address` VALUES ('3603', '370', '泽普县', '3', '', null);
INSERT INTO `s_address` VALUES ('3604', '370', '莎车县', '3', '', null);
INSERT INTO `s_address` VALUES ('3605', '370', '叶城县', '3', '', null);
INSERT INTO `s_address` VALUES ('3606', '370', '麦盖提县', '3', '', null);
INSERT INTO `s_address` VALUES ('3607', '370', '岳普湖县', '3', '', null);
INSERT INTO `s_address` VALUES ('3608', '370', '伽师县', '3', '', null);
INSERT INTO `s_address` VALUES ('3609', '370', '巴楚县', '3', '', null);
INSERT INTO `s_address` VALUES ('3610', '370', '塔什库尔干塔吉克自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3611', '370', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3612', '371', '和田市', '3', '', null);
INSERT INTO `s_address` VALUES ('3613', '371', '和田县', '3', '', null);
INSERT INTO `s_address` VALUES ('3614', '371', '墨玉县', '3', '', null);
INSERT INTO `s_address` VALUES ('3615', '371', '皮山县', '3', '', null);
INSERT INTO `s_address` VALUES ('3616', '371', '洛浦县', '3', '', null);
INSERT INTO `s_address` VALUES ('3617', '371', '策勒县', '3', '', null);
INSERT INTO `s_address` VALUES ('3618', '371', '于田县', '3', '', null);
INSERT INTO `s_address` VALUES ('3619', '371', '民丰县', '3', '', null);
INSERT INTO `s_address` VALUES ('3620', '371', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3621', '372', '伊宁市', '3', '', null);
INSERT INTO `s_address` VALUES ('3622', '372', '奎屯市', '3', '', null);
INSERT INTO `s_address` VALUES ('3623', '372', '伊宁县', '3', '', null);
INSERT INTO `s_address` VALUES ('3624', '372', '察布查尔锡伯自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3625', '372', '霍城县', '3', '', null);
INSERT INTO `s_address` VALUES ('3626', '372', '巩留县', '3', '', null);
INSERT INTO `s_address` VALUES ('3627', '372', '新源县', '3', '', null);
INSERT INTO `s_address` VALUES ('3628', '372', '昭苏县', '3', '', null);
INSERT INTO `s_address` VALUES ('3629', '372', '特克斯县', '3', '', null);
INSERT INTO `s_address` VALUES ('3630', '372', '尼勒克县', '3', '', null);
INSERT INTO `s_address` VALUES ('3631', '372', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3632', '373', '塔城市', '3', '', null);
INSERT INTO `s_address` VALUES ('3633', '373', '乌苏市', '3', '', null);
INSERT INTO `s_address` VALUES ('3634', '373', '额敏县', '3', '', null);
INSERT INTO `s_address` VALUES ('3635', '373', '沙湾县', '3', '', null);
INSERT INTO `s_address` VALUES ('3636', '373', '托里县', '3', '', null);
INSERT INTO `s_address` VALUES ('3637', '373', '裕民县', '3', '', null);
INSERT INTO `s_address` VALUES ('3638', '373', '和布克赛尔蒙古自治县', '3', '', null);
INSERT INTO `s_address` VALUES ('3639', '373', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3640', '374', '阿勒泰市', '3', '', null);
INSERT INTO `s_address` VALUES ('3641', '374', '布尔津县', '3', '', null);
INSERT INTO `s_address` VALUES ('3642', '374', '富蕴县', '3', '', null);
INSERT INTO `s_address` VALUES ('3643', '374', '福海县', '3', '', null);
INSERT INTO `s_address` VALUES ('3644', '374', '哈巴河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3645', '374', '青河县', '3', '', null);
INSERT INTO `s_address` VALUES ('3646', '374', '吉木乃县', '3', '', null);
INSERT INTO `s_address` VALUES ('3647', '374', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3648', '375', '中正区', '3', '', null);
INSERT INTO `s_address` VALUES ('3649', '375', '大同区', '3', '', null);
INSERT INTO `s_address` VALUES ('3650', '375', '中山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3651', '375', '松山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3652', '375', '大安区', '3', '', null);
INSERT INTO `s_address` VALUES ('3653', '375', '万华区', '3', '', null);
INSERT INTO `s_address` VALUES ('3654', '375', '信义区', '3', '', null);
INSERT INTO `s_address` VALUES ('3655', '375', '士林区', '3', '', null);
INSERT INTO `s_address` VALUES ('3656', '375', '北投区', '3', '', null);
INSERT INTO `s_address` VALUES ('3657', '375', '内湖区', '3', '', null);
INSERT INTO `s_address` VALUES ('3658', '375', '南港区', '3', '', null);
INSERT INTO `s_address` VALUES ('3659', '375', '文山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3660', '375', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3661', '376', '新兴区', '3', '', null);
INSERT INTO `s_address` VALUES ('3662', '376', '前金区', '3', '', null);
INSERT INTO `s_address` VALUES ('3663', '376', '芩雅区', '3', '', null);
INSERT INTO `s_address` VALUES ('3664', '376', '盐埕区', '3', '', null);
INSERT INTO `s_address` VALUES ('3665', '376', '鼓山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3666', '376', '旗津区', '3', '', null);
INSERT INTO `s_address` VALUES ('3667', '376', '前镇区', '3', '', null);
INSERT INTO `s_address` VALUES ('3668', '376', '三民区', '3', '', null);
INSERT INTO `s_address` VALUES ('3669', '376', '左营区', '3', '', null);
INSERT INTO `s_address` VALUES ('3670', '376', '楠梓区', '3', '', null);
INSERT INTO `s_address` VALUES ('3671', '376', '小港区', '3', '', null);
INSERT INTO `s_address` VALUES ('3672', '376', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3673', '376', '苓雅区', '3', '', null);
INSERT INTO `s_address` VALUES ('3674', '376', '仁武区', '3', '', null);
INSERT INTO `s_address` VALUES ('3675', '376', '大社区', '3', '', null);
INSERT INTO `s_address` VALUES ('3676', '376', '冈山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3677', '376', '路竹区', '3', '', null);
INSERT INTO `s_address` VALUES ('3678', '376', '阿莲区', '3', '', null);
INSERT INTO `s_address` VALUES ('3679', '376', '田寮区', '3', '', null);
INSERT INTO `s_address` VALUES ('3680', '376', '燕巢区', '3', '', null);
INSERT INTO `s_address` VALUES ('3681', '376', '桥头区', '3', '', null);
INSERT INTO `s_address` VALUES ('3682', '376', '梓官区', '3', '', null);
INSERT INTO `s_address` VALUES ('3683', '376', '弥陀区', '3', '', null);
INSERT INTO `s_address` VALUES ('3684', '376', '永安区', '3', '', null);
INSERT INTO `s_address` VALUES ('3685', '376', '湖内区', '3', '', null);
INSERT INTO `s_address` VALUES ('3686', '376', '凤山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3687', '376', '大寮区', '3', '', null);
INSERT INTO `s_address` VALUES ('3688', '376', '林园区', '3', '', null);
INSERT INTO `s_address` VALUES ('3689', '376', '鸟松区', '3', '', null);
INSERT INTO `s_address` VALUES ('3690', '376', '大树区', '3', '', null);
INSERT INTO `s_address` VALUES ('3691', '376', '旗山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3692', '376', '美浓区', '3', '', null);
INSERT INTO `s_address` VALUES ('3693', '376', '六龟区', '3', '', null);
INSERT INTO `s_address` VALUES ('3694', '376', '内门区', '3', '', null);
INSERT INTO `s_address` VALUES ('3695', '376', '杉林区', '3', '', null);
INSERT INTO `s_address` VALUES ('3696', '376', '甲仙区', '3', '', null);
INSERT INTO `s_address` VALUES ('3697', '376', '桃源区', '3', '', null);
INSERT INTO `s_address` VALUES ('3698', '376', '那玛夏区', '3', '', null);
INSERT INTO `s_address` VALUES ('3699', '376', '茂林区', '3', '', null);
INSERT INTO `s_address` VALUES ('3700', '376', '茄萣区', '3', '', null);
INSERT INTO `s_address` VALUES ('3701', '377', '中西区', '3', '', null);
INSERT INTO `s_address` VALUES ('3702', '377', '东区', '3', '', null);
INSERT INTO `s_address` VALUES ('3703', '377', '南区', '3', '', null);
INSERT INTO `s_address` VALUES ('3704', '377', '北区', '3', '', null);
INSERT INTO `s_address` VALUES ('3705', '377', '安平区', '3', '', null);
INSERT INTO `s_address` VALUES ('3706', '377', '安南区', '3', '', null);
INSERT INTO `s_address` VALUES ('3707', '377', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3708', '377', '永康区', '3', '', null);
INSERT INTO `s_address` VALUES ('3709', '377', '归仁区', '3', '', null);
INSERT INTO `s_address` VALUES ('3710', '377', '新化区', '3', '', null);
INSERT INTO `s_address` VALUES ('3711', '377', '左镇区', '3', '', null);
INSERT INTO `s_address` VALUES ('3712', '377', '玉井区', '3', '', null);
INSERT INTO `s_address` VALUES ('3713', '377', '楠西区', '3', '', null);
INSERT INTO `s_address` VALUES ('3714', '377', '南化区', '3', '', null);
INSERT INTO `s_address` VALUES ('3715', '377', '仁德区', '3', '', null);
INSERT INTO `s_address` VALUES ('3716', '377', '关庙区', '3', '', null);
INSERT INTO `s_address` VALUES ('3717', '377', '龙崎区', '3', '', null);
INSERT INTO `s_address` VALUES ('3718', '377', '官田区', '3', '', null);
INSERT INTO `s_address` VALUES ('3719', '377', '麻豆区', '3', '', null);
INSERT INTO `s_address` VALUES ('3720', '377', '佳里区', '3', '', null);
INSERT INTO `s_address` VALUES ('3721', '377', '西港区', '3', '', null);
INSERT INTO `s_address` VALUES ('3722', '377', '七股区', '3', '', null);
INSERT INTO `s_address` VALUES ('3723', '377', '将军区', '3', '', null);
INSERT INTO `s_address` VALUES ('3724', '377', '学甲区', '3', '', null);
INSERT INTO `s_address` VALUES ('3725', '377', '北门区', '3', '', null);
INSERT INTO `s_address` VALUES ('3726', '377', '新营区', '3', '', null);
INSERT INTO `s_address` VALUES ('3727', '377', '后壁区', '3', '', null);
INSERT INTO `s_address` VALUES ('3728', '377', '白河区', '3', '', null);
INSERT INTO `s_address` VALUES ('3729', '377', '东山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3730', '377', '六甲区', '3', '', null);
INSERT INTO `s_address` VALUES ('3731', '377', '下营区', '3', '', null);
INSERT INTO `s_address` VALUES ('3732', '377', '柳营区', '3', '', null);
INSERT INTO `s_address` VALUES ('3733', '377', '盐水区', '3', '', null);
INSERT INTO `s_address` VALUES ('3734', '377', '善化区', '3', '', null);
INSERT INTO `s_address` VALUES ('3735', '377', '大内区', '3', '', null);
INSERT INTO `s_address` VALUES ('3736', '377', '山上区', '3', '', null);
INSERT INTO `s_address` VALUES ('3737', '377', '新市区', '3', '', null);
INSERT INTO `s_address` VALUES ('3738', '377', '安定区', '3', '', null);
INSERT INTO `s_address` VALUES ('3739', '378', '中区', '3', '', null);
INSERT INTO `s_address` VALUES ('3740', '378', '东区', '3', '', null);
INSERT INTO `s_address` VALUES ('3741', '378', '南区', '3', '', null);
INSERT INTO `s_address` VALUES ('3742', '378', '西区', '3', '', null);
INSERT INTO `s_address` VALUES ('3743', '378', '北区', '3', '', null);
INSERT INTO `s_address` VALUES ('3744', '378', '北屯区', '3', '', null);
INSERT INTO `s_address` VALUES ('3745', '378', '西屯区', '3', '', null);
INSERT INTO `s_address` VALUES ('3746', '378', '南屯区', '3', '', null);
INSERT INTO `s_address` VALUES ('3747', '378', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3748', '378', '太平区', '3', '', null);
INSERT INTO `s_address` VALUES ('3749', '378', '大里区', '3', '', null);
INSERT INTO `s_address` VALUES ('3750', '378', '雾峰区', '3', '', null);
INSERT INTO `s_address` VALUES ('3751', '378', '乌日区', '3', '', null);
INSERT INTO `s_address` VALUES ('3752', '378', '丰原区', '3', '', null);
INSERT INTO `s_address` VALUES ('3753', '378', '后里区', '3', '', null);
INSERT INTO `s_address` VALUES ('3754', '378', '石冈区', '3', '', null);
INSERT INTO `s_address` VALUES ('3755', '378', '东势区', '3', '', null);
INSERT INTO `s_address` VALUES ('3756', '378', '和平区', '3', '', null);
INSERT INTO `s_address` VALUES ('3757', '378', '新社区', '3', '', null);
INSERT INTO `s_address` VALUES ('3758', '378', '潭子区', '3', '', null);
INSERT INTO `s_address` VALUES ('3759', '378', '大雅区', '3', '', null);
INSERT INTO `s_address` VALUES ('3760', '378', '神冈区', '3', '', null);
INSERT INTO `s_address` VALUES ('3761', '378', '大肚区', '3', '', null);
INSERT INTO `s_address` VALUES ('3762', '378', '沙鹿区', '3', '', null);
INSERT INTO `s_address` VALUES ('3763', '378', '龙井区', '3', '', null);
INSERT INTO `s_address` VALUES ('3764', '378', '梧栖区', '3', '', null);
INSERT INTO `s_address` VALUES ('3765', '378', '清水区', '3', '', null);
INSERT INTO `s_address` VALUES ('3766', '378', '大甲区', '3', '', null);
INSERT INTO `s_address` VALUES ('3767', '378', '外埔区', '3', '', null);
INSERT INTO `s_address` VALUES ('3768', '378', '大安区', '3', '', null);
INSERT INTO `s_address` VALUES ('3769', '379', '金沙镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3770', '379', '金湖镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3771', '379', '金宁乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3772', '379', '金城镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3773', '379', '烈屿乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3774', '379', '乌坵乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3775', '380', '南投市', '3', '', null);
INSERT INTO `s_address` VALUES ('3776', '380', '中寮乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3777', '380', '草屯镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3778', '380', '国姓乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3779', '380', '埔里镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3780', '380', '仁爱乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3781', '380', '名间乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3782', '380', '集集镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3783', '380', '水里乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3784', '380', '鱼池乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3785', '380', '信义乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3786', '380', '竹山镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3787', '380', '鹿谷乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3788', '381', '仁爱区', '3', '', null);
INSERT INTO `s_address` VALUES ('3789', '381', '信义区', '3', '', null);
INSERT INTO `s_address` VALUES ('3790', '381', '中正区', '3', '', null);
INSERT INTO `s_address` VALUES ('3791', '381', '中山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3792', '381', '安乐区', '3', '', null);
INSERT INTO `s_address` VALUES ('3793', '381', '暖暖区', '3', '', null);
INSERT INTO `s_address` VALUES ('3794', '381', '七堵区', '3', '', null);
INSERT INTO `s_address` VALUES ('3795', '381', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3796', '382', '东区', '3', '', null);
INSERT INTO `s_address` VALUES ('3797', '382', '北区', '3', '', null);
INSERT INTO `s_address` VALUES ('3798', '382', '香山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3799', '382', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3800', '383', '东区', '3', '', null);
INSERT INTO `s_address` VALUES ('3801', '383', '西区', '3', '', null);
INSERT INTO `s_address` VALUES ('3802', '383', '其它区', '3', '', null);
INSERT INTO `s_address` VALUES ('3803', '384', '万里区', '3', '', null);
INSERT INTO `s_address` VALUES ('3804', '384', '金山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3805', '384', '板桥区', '3', '', null);
INSERT INTO `s_address` VALUES ('3806', '384', '汐止区', '3', '', null);
INSERT INTO `s_address` VALUES ('3807', '384', '深坑区', '3', '', null);
INSERT INTO `s_address` VALUES ('3808', '384', '石碇区', '3', '', null);
INSERT INTO `s_address` VALUES ('3809', '384', '瑞芳区', '3', '', null);
INSERT INTO `s_address` VALUES ('3810', '384', '平溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('3811', '384', '双溪区', '3', '', null);
INSERT INTO `s_address` VALUES ('3812', '384', '贡寮区', '3', '', null);
INSERT INTO `s_address` VALUES ('3813', '384', '新店区', '3', '', null);
INSERT INTO `s_address` VALUES ('3814', '384', '坪林区', '3', '', null);
INSERT INTO `s_address` VALUES ('3815', '384', '乌来区', '3', '', null);
INSERT INTO `s_address` VALUES ('3816', '384', '永和区', '3', '', null);
INSERT INTO `s_address` VALUES ('3817', '384', '中和区', '3', '', null);
INSERT INTO `s_address` VALUES ('3818', '384', '土城区', '3', '', null);
INSERT INTO `s_address` VALUES ('3819', '384', '三峡区', '3', '', null);
INSERT INTO `s_address` VALUES ('3820', '384', '树林区', '3', '', null);
INSERT INTO `s_address` VALUES ('3821', '384', '莺歌区', '3', '', null);
INSERT INTO `s_address` VALUES ('3822', '384', '三重区', '3', '', null);
INSERT INTO `s_address` VALUES ('3823', '384', '新庄区', '3', '', null);
INSERT INTO `s_address` VALUES ('3824', '384', '泰山区', '3', '', null);
INSERT INTO `s_address` VALUES ('3825', '384', '林口区', '3', '', null);
INSERT INTO `s_address` VALUES ('3826', '384', '芦洲区', '3', '', null);
INSERT INTO `s_address` VALUES ('3827', '384', '五股区', '3', '', null);
INSERT INTO `s_address` VALUES ('3828', '384', '八里区', '3', '', null);
INSERT INTO `s_address` VALUES ('3829', '384', '淡水区', '3', '', null);
INSERT INTO `s_address` VALUES ('3830', '384', '三芝区', '3', '', null);
INSERT INTO `s_address` VALUES ('3831', '384', '石门区', '3', '', null);
INSERT INTO `s_address` VALUES ('3832', '385', '宜兰市', '3', '', null);
INSERT INTO `s_address` VALUES ('3833', '385', '头城镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3834', '385', '礁溪乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3835', '385', '壮围乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3836', '385', '员山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3837', '385', '罗东镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3838', '385', '三星乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3839', '385', '大同乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3840', '385', '五结乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3841', '385', '冬山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3842', '385', '苏澳镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3843', '385', '南澳乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3844', '385', '钓鱼台', '3', '', null);
INSERT INTO `s_address` VALUES ('3845', '386', '竹北市', '3', '', null);
INSERT INTO `s_address` VALUES ('3846', '386', '湖口乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3847', '386', '新丰乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3848', '386', '新埔镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3849', '386', '关西镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3850', '386', '芎林乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3851', '386', '宝山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3852', '386', '竹东镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3853', '386', '五峰乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3854', '386', '横山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3855', '386', '尖石乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3856', '386', '北埔乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3857', '386', '峨眉乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3858', '387', '中坜市', '3', '', null);
INSERT INTO `s_address` VALUES ('3859', '387', '平镇市', '3', '', null);
INSERT INTO `s_address` VALUES ('3860', '387', '龙潭乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3861', '387', '杨梅市', '3', '', null);
INSERT INTO `s_address` VALUES ('3862', '387', '新屋乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3863', '387', '观音乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3864', '387', '桃园市', '3', '', null);
INSERT INTO `s_address` VALUES ('3865', '387', '龟山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3866', '387', '八德市', '3', '', null);
INSERT INTO `s_address` VALUES ('3867', '387', '大溪镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3868', '387', '复兴乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3869', '387', '大园乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3870', '387', '芦竹乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3871', '388', '竹南镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3872', '388', '头份镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3873', '388', '三湾乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3874', '388', '南庄乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3875', '388', '狮潭乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3876', '388', '后龙镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3877', '388', '通霄镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3878', '388', '苑里镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3879', '388', '苗栗市', '3', '', null);
INSERT INTO `s_address` VALUES ('3880', '388', '造桥乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3881', '388', '头屋乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3882', '388', '公馆乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3883', '388', '大湖乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3884', '388', '泰安乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3885', '388', '铜锣乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3886', '388', '三义乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3887', '388', '西湖乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3888', '388', '卓兰镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3889', '389', '彰化市', '3', '', null);
INSERT INTO `s_address` VALUES ('3890', '389', '芬园乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3891', '389', '花坛乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3892', '389', '秀水乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3893', '389', '鹿港镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3894', '389', '福兴乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3895', '389', '线西乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3896', '389', '和美镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3897', '389', '伸港乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3898', '389', '员林镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3899', '389', '社头乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3900', '389', '永靖乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3901', '389', '埔心乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3902', '389', '溪湖镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3903', '389', '大村乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3904', '389', '埔盐乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3905', '389', '田中镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3906', '389', '北斗镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3907', '389', '田尾乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3908', '389', '埤头乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3909', '389', '溪州乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3910', '389', '竹塘乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3911', '389', '二林镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3912', '389', '大城乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3913', '389', '芳苑乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3914', '389', '二水乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3915', '390', '番路乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3916', '390', '梅山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3917', '390', '竹崎乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3918', '390', '阿里山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3919', '390', '中埔乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3920', '390', '大埔乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3921', '390', '水上乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3922', '390', '鹿草乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3923', '390', '太保市', '3', '', null);
INSERT INTO `s_address` VALUES ('3924', '390', '朴子市', '3', '', null);
INSERT INTO `s_address` VALUES ('3925', '390', '东石乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3926', '390', '六脚乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3927', '390', '新港乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3928', '390', '民雄乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3929', '390', '大林镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3930', '390', '溪口乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3931', '390', '义竹乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3932', '390', '布袋镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3933', '391', '斗南镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3934', '391', '大埤乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3935', '391', '虎尾镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3936', '391', '土库镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3937', '391', '褒忠乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3938', '391', '东势乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3939', '391', '台西乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3940', '391', '仑背乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3941', '391', '麦寮乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3942', '391', '斗六市', '3', '', null);
INSERT INTO `s_address` VALUES ('3943', '391', '林内乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3944', '391', '古坑乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3945', '391', '莿桐乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3946', '391', '西螺镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3947', '391', '二仑乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3948', '391', '北港镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3949', '391', '水林乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3950', '391', '口湖乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3951', '391', '四湖乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3952', '391', '元长乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3953', '392', '屏东市', '3', '', null);
INSERT INTO `s_address` VALUES ('3954', '392', '三地门乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3955', '392', '雾台乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3956', '392', '玛家乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3957', '392', '九如乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3958', '392', '里港乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3959', '392', '高树乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3960', '392', '盐埔乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3961', '392', '长治乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3962', '392', '麟洛乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3963', '392', '竹田乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3964', '392', '内埔乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3965', '392', '万丹乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3966', '392', '潮州镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3967', '392', '泰武乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3968', '392', '来义乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3969', '392', '万峦乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3970', '392', '崁顶乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3971', '392', '新埤乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3972', '392', '南州乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3973', '392', '林边乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3974', '392', '东港镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3975', '392', '琉球乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3976', '392', '佳冬乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3977', '392', '新园乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3978', '392', '枋寮乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3979', '392', '枋山乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3980', '392', '春日乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3981', '392', '狮子乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3982', '392', '车城乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3983', '392', '牡丹乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3984', '392', '恒春镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3985', '392', '满州乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3986', '393', '台东市', '3', '', null);
INSERT INTO `s_address` VALUES ('3987', '393', '绿岛乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3988', '393', '兰屿乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3989', '393', '延平乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3990', '393', '卑南乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3991', '393', '鹿野乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3992', '393', '关山镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3993', '393', '海端乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3994', '393', '池上乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3995', '393', '东河乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3996', '393', '成功镇', '3', '', null);
INSERT INTO `s_address` VALUES ('3997', '393', '长滨乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3998', '393', '金峰乡', '3', '', null);
INSERT INTO `s_address` VALUES ('3999', '393', '大武乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4000', '393', '达仁乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4001', '393', '太麻里乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4002', '394', '花莲市', '3', '', null);
INSERT INTO `s_address` VALUES ('4003', '394', '新城乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4004', '394', '太鲁阁', '3', '', null);
INSERT INTO `s_address` VALUES ('4005', '394', '秀林乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4006', '394', '吉安乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4007', '394', '寿丰乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4008', '394', '凤林镇', '3', '', null);
INSERT INTO `s_address` VALUES ('4009', '394', '光复乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4010', '394', '丰滨乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4011', '394', '瑞穗乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4012', '394', '万荣乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4013', '394', '玉里镇', '3', '', null);
INSERT INTO `s_address` VALUES ('4014', '394', '卓溪乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4015', '394', '富里乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4016', '395', '马公市', '3', '', null);
INSERT INTO `s_address` VALUES ('4017', '395', '西屿乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4018', '395', '望安乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4019', '395', '七美乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4020', '395', '白沙乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4021', '395', '湖西乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4022', '396', '南竿乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4023', '396', '北竿乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4024', '396', '莒光乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4025', '396', '东引乡', '3', '', null);
INSERT INTO `s_address` VALUES ('4026', '397', '中西区', '3', '', null);
INSERT INTO `s_address` VALUES ('4027', '397', '湾仔', '3', '', null);
INSERT INTO `s_address` VALUES ('4028', '397', '东区', '3', '', null);
INSERT INTO `s_address` VALUES ('4029', '397', '南区', '3', '', null);
INSERT INTO `s_address` VALUES ('4030', '398', '九龙城区', '3', '', null);
INSERT INTO `s_address` VALUES ('4031', '398', '油尖旺区', '3', '', null);
INSERT INTO `s_address` VALUES ('4032', '398', '深水埗区', '3', '', null);
INSERT INTO `s_address` VALUES ('4033', '398', '黄大仙区', '3', '', null);
INSERT INTO `s_address` VALUES ('4034', '398', '观塘区', '3', '', null);
INSERT INTO `s_address` VALUES ('4035', '399', '北区', '3', '', null);
INSERT INTO `s_address` VALUES ('4036', '399', '大埔区', '3', '', null);
INSERT INTO `s_address` VALUES ('4037', '399', '沙田区', '3', '', null);
INSERT INTO `s_address` VALUES ('4038', '399', '西贡区', '3', '', null);
INSERT INTO `s_address` VALUES ('4039', '399', '元朗区', '3', '', null);
INSERT INTO `s_address` VALUES ('4040', '399', '屯门区', '3', '', null);
INSERT INTO `s_address` VALUES ('4041', '399', '荃湾区', '3', '', null);
INSERT INTO `s_address` VALUES ('4042', '399', '葵青区', '3', '', null);
INSERT INTO `s_address` VALUES ('4043', '399', '离岛区', '3', '', null);

-- ----------------------------
-- Table structure for s_appid_template
-- ----------------------------
DROP TABLE IF EXISTS `s_appid_template`;
CREATE TABLE `s_appid_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `secret` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `template_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_appid_template
-- ----------------------------

-- ----------------------------
-- Table structure for s_areaset
-- ----------------------------
DROP TABLE IF EXISTS `s_areaset`;
CREATE TABLE `s_areaset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `area_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_ids` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户分区表';

-- ----------------------------
-- Records of s_areaset
-- ----------------------------

-- ----------------------------
-- Table structure for s_brandclass
-- ----------------------------
DROP TABLE IF EXISTS `s_brandclass`;
CREATE TABLE `s_brandclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团品牌名称',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `wx_public` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信公众号',
  `wx_appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_secret` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第三方用户唯一凭证密钥，即appsecret',
  `sms_config` int(11) DEFAULT NULL COMMENT '短信配置，存sms内的JSONkey值',
  `nickname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_rule` tinyint(2) DEFAULT NULL,
  `proportion` int(11) DEFAULT NULL,
  `mall_url` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_mch_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_pay_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `vip_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `valid_date` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='集团品牌设定';

-- ----------------------------
-- Records of s_brandclass
-- ----------------------------

-- ----------------------------
-- Table structure for s_channelclass
-- ----------------------------
DROP TABLE IF EXISTS `s_channelclass`;
CREATE TABLE `s_channelclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channelclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_channelclass
-- ----------------------------

-- ----------------------------
-- Table structure for s_channelinfo
-- ----------------------------
DROP TABLE IF EXISTS `s_channelinfo`;
CREATE TABLE `s_channelinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channelclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_channelinfo
-- ----------------------------

-- ----------------------------
-- Table structure for s_city
-- ----------------------------
DROP TABLE IF EXISTS `s_city`;
CREATE TABLE `s_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `city_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `f_id` int(11) DEFAULT NULL,
  `city_type` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_city
-- ----------------------------

-- ----------------------------
-- Table structure for s_consumptiontype
-- ----------------------------
DROP TABLE IF EXISTS `s_consumptiontype`;
CREATE TABLE `s_consumptiontype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consumption_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_ids` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消费类型设定';

-- ----------------------------
-- Records of s_consumptiontype
-- ----------------------------

-- ----------------------------
-- Table structure for s_consumption_capacity
-- ----------------------------
DROP TABLE IF EXISTS `s_consumption_capacity`;
CREATE TABLE `s_consumption_capacity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `capacity` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消费能力';

-- ----------------------------
-- Records of s_consumption_capacity
-- ----------------------------

-- ----------------------------
-- Table structure for s_cussource
-- ----------------------------
DROP TABLE IF EXISTS `s_cussource`;
CREATE TABLE `s_cussource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type_id` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户来源表';

-- ----------------------------
-- Records of s_cussource
-- ----------------------------

-- ----------------------------
-- Table structure for s_departmentinfo
-- ----------------------------
DROP TABLE IF EXISTS `s_departmentinfo`;
CREATE TABLE `s_departmentinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门名称',
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `channel_list` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '管理渠道',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='部门设定';

-- ----------------------------
-- Records of s_departmentinfo
-- ----------------------------

-- ----------------------------
-- Table structure for s_functioninfo
-- ----------------------------
DROP TABLE IF EXISTS `s_functioninfo`;
CREATE TABLE `s_functioninfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_fid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_functioninfo
-- ----------------------------

-- ----------------------------
-- Table structure for s_functionset
-- ----------------------------
DROP TABLE IF EXISTS `s_functionset`;
CREATE TABLE `s_functionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `A` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Aid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `B` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Bid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `C` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Cid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `D` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Did` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `E` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Eid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coderkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_functionset
-- ----------------------------

-- ----------------------------
-- Table structure for s_function_staff
-- ----------------------------
DROP TABLE IF EXISTS `s_function_staff`;
CREATE TABLE `s_function_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_fid` int(11) DEFAULT NULL,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_function_staff
-- ----------------------------

-- ----------------------------
-- Table structure for s_groupcompany
-- ----------------------------
DROP TABLE IF EXISTS `s_groupcompany`;
CREATE TABLE `s_groupcompany` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `wx_public` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信配置名',
  `wx_appid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_secret` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sms_config` int(11) DEFAULT NULL COMMENT '短信配置',
  `wx_mch_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_pay_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='集团名称设定';

-- ----------------------------
-- Records of s_groupcompany
-- ----------------------------

-- ----------------------------
-- Table structure for s_intentionset
-- ----------------------------
DROP TABLE IF EXISTS `s_intentionset`;
CREATE TABLE `s_intentionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `intention_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户意向';

-- ----------------------------
-- Records of s_intentionset
-- ----------------------------

-- ----------------------------
-- Table structure for s_leave
-- ----------------------------
DROP TABLE IF EXISTS `s_leave`;
CREATE TABLE `s_leave` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL,
  `contract_end_day` datetime DEFAULT NULL,
  `apply_leave` datetime DEFAULT NULL,
  `check_leave` datetime DEFAULT NULL,
  `leave_type` int(11) DEFAULT NULL,
  `leave_reason` text COLLATE utf8_unicode_ci,
  `advice` text COLLATE utf8_unicode_ci,
  `department_advice` text COLLATE utf8_unicode_ci,
  `personnel_advice` text COLLATE utf8_unicode_ci,
  `manager_advice` text COLLATE utf8_unicode_ci,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_leave
-- ----------------------------

-- ----------------------------
-- Table structure for s_losssignitem
-- ----------------------------
DROP TABLE IF EXISTS `s_losssignitem`;
CREATE TABLE `s_losssignitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lossname` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_losssignitem
-- ----------------------------

-- ----------------------------
-- Table structure for s_markset
-- ----------------------------
DROP TABLE IF EXISTS `s_markset`;
CREATE TABLE `s_markset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mark_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记名',
  `mark_color` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_markset
-- ----------------------------

-- ----------------------------
-- Table structure for s_message_templateinfo
-- ----------------------------
DROP TABLE IF EXISTS `s_message_templateinfo`;
CREATE TABLE `s_message_templateinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mtempalte_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mtempalte_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `outsex` int(11) DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_message_templateinfo
-- ----------------------------

-- ----------------------------
-- Table structure for s_not_order_reason
-- ----------------------------
DROP TABLE IF EXISTS `s_not_order_reason`;
CREATE TABLE `s_not_order_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_delete` tinyint(1) DEFAULT '2',
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_not_order_reason
-- ----------------------------

-- ----------------------------
-- Table structure for s_passwordset
-- ----------------------------
DROP TABLE IF EXISTS `s_passwordset`;
CREATE TABLE `s_passwordset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `default_pwd` varchar(100) COLLATE utf8_unicode_ci DEFAULT '8888',
  `letter` tinyint(1) DEFAULT '1',
  `num` tinyint(1) DEFAULT '1',
  `special_char` tinyint(1) DEFAULT '1',
  `length` int(11) DEFAULT NULL,
  `error_num` int(5) DEFAULT NULL,
  `invalid_time` int(5) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_passwordset
-- ----------------------------

-- ----------------------------
-- Table structure for s_photo_address
-- ----------------------------
DROP TABLE IF EXISTS `s_photo_address`;
CREATE TABLE `s_photo_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photoAddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_photo_address
-- ----------------------------

-- ----------------------------
-- Table structure for s_positionset
-- ----------------------------
DROP TABLE IF EXISTS `s_positionset`;
CREATE TABLE `s_positionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位名称',
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门名称',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  `work_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作类型，用逗号隔开',
  `department_id` int(11) DEFAULT '0',
  `groupId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `superior_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `superior_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='岗位设定';

-- ----------------------------
-- Records of s_positionset
-- ----------------------------

-- ----------------------------
-- Table structure for s_position_change
-- ----------------------------
DROP TABLE IF EXISTS `s_position_change`;
CREATE TABLE `s_position_change` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_brandclass_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_department_id` int(11) DEFAULT NULL,
  `before_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_zhiji_id` int(11) DEFAULT NULL,
  `before_zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_basic_pay` decimal(10,2) DEFAULT NULL,
  `before_merit_pay` decimal(10,2) DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `basic_pay` decimal(10,2) DEFAULT NULL,
  `merit_pay` decimal(10,2) DEFAULT NULL,
  `reason` text COLLATE utf8_unicode_ci,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_position_change
-- ----------------------------

-- ----------------------------
-- Table structure for s_position_menu
-- ----------------------------
DROP TABLE IF EXISTS `s_position_menu`;
CREATE TABLE `s_position_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单url',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_position_menu
-- ----------------------------

-- ----------------------------
-- Table structure for s_qr_login
-- ----------------------------
DROP TABLE IF EXISTS `s_qr_login`;
CREATE TABLE `s_qr_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `qr_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生成的二维码唯一编码',
  `qr_expire` datetime DEFAULT NULL COMMENT '生成的二维码过期时间，二维码过期后，需要重新获取',
  `staff_id` int(11) DEFAULT NULL COMMENT '对应是哪个员工',
  `login_time` datetime DEFAULT NULL COMMENT '确认登录时间',
  `login_system` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '从哪个系统请求的登录',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='二唯码登录表';

-- ----------------------------
-- Records of s_qr_login
-- ----------------------------

-- ----------------------------
-- Table structure for s_recruitment_apply
-- ----------------------------
DROP TABLE IF EXISTS `s_recruitment_apply`;
CREATE TABLE `s_recruitment_apply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` tinyint(4) DEFAULT NULL,
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_check` tinyint(4) DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_recruitment_apply
-- ----------------------------

-- ----------------------------
-- Table structure for s_regionset
-- ----------------------------
DROP TABLE IF EXISTS `s_regionset`;
CREATE TABLE `s_regionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户地域';

-- ----------------------------
-- Records of s_regionset
-- ----------------------------
INSERT INTO `s_regionset` VALUES ('1', '东北', '', '', '');
INSERT INTO `s_regionset` VALUES ('2', '华东', '', '', '');
INSERT INTO `s_regionset` VALUES ('3', '华北', '', '', '');
INSERT INTO `s_regionset` VALUES ('4', '华中', '', '', '');
INSERT INTO `s_regionset` VALUES ('5', '华南', '', '', '');
INSERT INTO `s_regionset` VALUES ('6', '西南', '', '', '');
INSERT INTO `s_regionset` VALUES ('7', '西北', '', '', '');

-- ----------------------------
-- Table structure for s_roleset
-- ----------------------------
DROP TABLE IF EXISTS `s_roleset`;
CREATE TABLE `s_roleset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rolename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `functionId` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coderkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_roleset
-- ----------------------------

-- ----------------------------
-- Table structure for s_sales_routines
-- ----------------------------
DROP TABLE IF EXISTS `s_sales_routines`;
CREATE TABLE `s_sales_routines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `step_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `step_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `step_stage` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_sales_routines
-- ----------------------------

-- ----------------------------
-- Table structure for s_shopset
-- ----------------------------
DROP TABLE IF EXISTS `s_shopset`;
CREATE TABLE `s_shopset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团品牌',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面简码',
  `numberorder` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号规则',
  `shopaddress` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面地址',
  `receiv_shop_code` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '可收款店面码',
  `is_dig` tinyint(4) DEFAULT '2' COMMENT '是否深挖,1是，2否，默认为2',
  `is_marketing` tinyint(4) DEFAULT '2' COMMENT '是否为营销店，1是，2否，默认为2',
  `is_manage` tinyint(4) DEFAULT '2' COMMENT '是否管理产品，1是 2否，默认为2',
  `is_synch` tinyint(4) DEFAULT '2' COMMENT '是否同步产品，1是 2否，默认为2',
  `is_switch` tinyint(4) DEFAULT '2' COMMENT '是否开启自动分配，1开启，2关闭，默认为2',
  `wx_public` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信公众号',
  `wx_appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_secret` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第三方用户唯一凭证密钥，即appsecret',
  `sms_config` int(11) DEFAULT NULL COMMENT '短信配置key(JSON内的一维KEY)',
  `is_op1` int(11) DEFAULT NULL,
  `is_op2` int(11) DEFAULT '1',
  `is_op3` int(11) DEFAULT NULL,
  `is_op4` int(11) DEFAULT NULL,
  `number_rule` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_type` tinyint(2) DEFAULT NULL,
  `is_sk` tinyint(2) DEFAULT NULL,
  `is_group` tinyint(2) DEFAULT NULL,
  `weight` decimal(5,0) NOT NULL DEFAULT '1',
  `end_date` datetime DEFAULT NULL,
  `wx_mch_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_pay_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `is_photo` tinyint(4) DEFAULT '2',
  `brandclass_id` int(11) DEFAULT NULL,
  `group_company_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `prefix_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `province` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='公司店面设定';

-- ----------------------------
-- Records of s_shopset
-- ----------------------------

-- ----------------------------
-- Table structure for s_signature
-- ----------------------------
DROP TABLE IF EXISTS `s_signature`;
CREATE TABLE `s_signature` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  `viewtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updatetime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deletetime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `apipathname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contract_img` text COLLATE utf8_unicode_ci,
  `contract_pdf` text COLLATE utf8_unicode_ci,
  `user_data` text COLLATE utf8_unicode_ci,
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_signature
-- ----------------------------

-- ----------------------------
-- Table structure for s_staffgroup
-- ----------------------------
DROP TABLE IF EXISTS `s_staffgroup`;
CREATE TABLE `s_staffgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组别名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分组名称设定';

-- ----------------------------
-- Records of s_staffgroup
-- ----------------------------

-- ----------------------------
-- Table structure for s_staffinfo
-- ----------------------------
DROP TABLE IF EXISTS `s_staffinfo`;
CREATE TABLE `s_staffinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名',
  `password` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `main_position_id` int(11) DEFAULT NULL COMMENT '主岗位',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位唯一标识',
  `position_id` text COLLATE utf8_unicode_ci,
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级',
  `turestaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '真实姓名',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT '0' COMMENT '小组id',
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `is_group_admin` text COLLATE utf8_unicode_ci,
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别',
  `entry_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '入职时间',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职时间',
  `birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生日',
  `IDcard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '身份证',
  `nation` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '国家',
  `place_origin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生地',
  `political` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '政治身份',
  `education` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '教育程度',
  `graduation_school` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '毕业学校',
  `marital_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '婚姻状况',
  `contract_endday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '合同结束时间',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '电话号',
  `QQ` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `a_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期折扣',
  `b_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期折扣',
  `a_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期成本',
  `b_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期成本',
  `liaison_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人',
  `liaison_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系电话',
  `salary_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '薪水',
  `social_security` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '社会保险',
  `bank_cardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行卡号',
  `addressinfo` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '住址',
  `remarkinfo` text COLLATE utf8_unicode_ci COMMENT '备注信息',
  `work_type` int(11) DEFAULT NULL COMMENT '工作类型',
  `work_shop` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作店面',
  `open_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定微信',
  `open_id_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当前绑定微信者名字，用于显示当前已绑定微信号',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '在线状态：1：在线；2：忙碌；3：离线',
  `Popedom1` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom2` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom3` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom4` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom5` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom6` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom7` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom8` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom9` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom10` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom11` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom12` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom13` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom14` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom15` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom16` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom17` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Popedom18` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `vice_work_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `add_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` tinyint(2) DEFAULT NULL,
  `last_login_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `is_jiguang` tinyint(2) DEFAULT '2',
  `work_type_level_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_level` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `working_status` tinyint(2) DEFAULT '1',
  `visa_number` int(11) DEFAULT NULL,
  `fingerprint1` text COLLATE utf8_unicode_ci,
  `fingerprint2` text COLLATE utf8_unicode_ci,
  `fingerprint3` text COLLATE utf8_unicode_ci,
  `fingerprint4` text COLLATE utf8_unicode_ci,
  `fingerprint5` text COLLATE utf8_unicode_ci,
  `minzu` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_lock` tinyint(1) DEFAULT '2',
  `update_pwd_time` datetime DEFAULT NULL,
  `fingerprint6` text COLLATE utf8_unicode_ci,
  `fingerprint7` text COLLATE utf8_unicode_ci,
  `fingerprint8` text COLLATE utf8_unicode_ci,
  `fingerprint9` text COLLATE utf8_unicode_ci,
  `fingerprint10` text COLLATE utf8_unicode_ci,
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address_id` text COLLATE utf8_unicode_ci,
  `leaders` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_staffinfo
-- ----------------------------

-- ----------------------------
-- Table structure for s_staffinfo_del
-- ----------------------------
DROP TABLE IF EXISTS `s_staffinfo_del`;
CREATE TABLE `s_staffinfo_del` (
  `id` int(11) NOT NULL,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名',
  `password` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `main_position_id` int(11) DEFAULT NULL COMMENT '主岗位',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位唯一标识',
  `position_id` text COLLATE utf8_unicode_ci,
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级',
  `turestaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '真实姓名',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT '0' COMMENT '小组id',
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `is_group_admin` text COLLATE utf8_unicode_ci,
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别',
  `entry_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '入职时间',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职时间',
  `birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生日',
  `IDcard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '身份证',
  `nation` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '国家',
  `place_origin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生地',
  `political` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '政治身份',
  `education` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '教育程度',
  `graduation_school` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '毕业学校',
  `marital_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '婚姻状况',
  `contract_endday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '合同结束时间',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '电话号',
  `QQ` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `a_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期折扣',
  `b_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期折扣',
  `a_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期成本',
  `b_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期成本',
  `liaison_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人',
  `liaison_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系电话',
  `salary_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '薪水',
  `social_security` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '社会保险',
  `bank_cardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行卡号',
  `addressinfo` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '住址',
  `remarkinfo` text COLLATE utf8_unicode_ci COMMENT '备注信息',
  `vice_work_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '副工作类型，兼职工作类型',
  `work_shop` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作店面',
  `open_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定微信',
  `open_id_name` varchar(200) CHARACTER SET latin1 DEFAULT NULL COMMENT '绑定的微信号名字，用于显示当前绑定者',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '在线状态：1：在线；2：忙碌；3：离线',
  `zhiji_id` int(11) DEFAULT NULL,
  `add_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` tinyint(2) DEFAULT NULL,
  `last_login_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `is_jiguang` tinyint(2) DEFAULT '2',
  `start_holiday` datetime DEFAULT NULL,
  `end_holiday` datetime DEFAULT NULL,
  `work_type_level_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_level` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `working_status` tinyint(2) DEFAULT '1',
  `visa_number` int(11) DEFAULT NULL,
  `minzu` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_lock` tinyint(1) DEFAULT '2',
  `update_pwd_time` datetime DEFAULT NULL,
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address_id` text COLLATE utf8_unicode_ci,
  `leaders` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_staffinfo_del
-- ----------------------------

-- ----------------------------
-- Table structure for s_staff_login
-- ----------------------------
DROP TABLE IF EXISTS `s_staff_login`;
CREATE TABLE `s_staff_login` (
  `staff_id` int(11) DEFAULT NULL,
  `session_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `expire_time` datetime DEFAULT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_staff_login
-- ----------------------------

-- ----------------------------
-- Table structure for s_staff_session
-- ----------------------------
DROP TABLE IF EXISTS `s_staff_session`;
CREATE TABLE `s_staff_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌',
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jpush_rid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='mc session表';

-- ----------------------------
-- Records of s_staff_session
-- ----------------------------

-- ----------------------------
-- Table structure for s_telremark
-- ----------------------------
DROP TABLE IF EXISTS `s_telremark`;
CREATE TABLE `s_telremark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telremark` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_telremark
-- ----------------------------

-- ----------------------------
-- Table structure for s_templateset
-- ----------------------------
DROP TABLE IF EXISTS `s_templateset`;
CREATE TABLE `s_templateset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` int(11) DEFAULT NULL COMMENT '应用id',
  `template_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板名称',
  `template_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板编号',
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信返回的模板id',
  `is_use` tinyint(2) NOT NULL DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_templateset
-- ----------------------------
INSERT INTO `s_templateset` VALUES ('1', null, '用户登录提醒 ', 'TM00181', null, '0');
INSERT INTO `s_templateset` VALUES ('2', null, '会员充值通知', 'OPENTM201378330', null, '0');
INSERT INTO `s_templateset` VALUES ('3', null, '待办任务提醒', 'OPENTM213512088', null, '0');
INSERT INTO `s_templateset` VALUES ('4', null, '积分兑换成功通知', 'OPENTM201014137', null, '0');
INSERT INTO `s_templateset` VALUES ('5', null, '帐户推广概况通知', 'TM00200', null, '0');
INSERT INTO `s_templateset` VALUES ('6', null, '会员消费通知', 'OPENTM201378279', null, '0');
INSERT INTO `s_templateset` VALUES ('7', null, '服务器恢复通知', 'TM00180', null, '0');
INSERT INTO `s_templateset` VALUES ('8', null, '付款通知', 'OPENTM208029645', null, '0');
INSERT INTO `s_templateset` VALUES ('9', null, '选片通知', 'OPENTM208029189', null, '0');
INSERT INTO `s_templateset` VALUES ('10', null, '取件通知', 'OPENTM208029181', null, '0');
INSERT INTO `s_templateset` VALUES ('11', null, '会员拍照通知', 'OPENTM400074760', null, '0');
INSERT INTO `s_templateset` VALUES ('12', null, '订单通知', 'OPENTM208029195', null, '0');
INSERT INTO `s_templateset` VALUES ('13', null, '看版通知', 'OPENTM208023746', null, '0');
INSERT INTO `s_templateset` VALUES ('14', null, '预约提醒', 'OPENTM405733202', null, '0');
INSERT INTO `s_templateset` VALUES ('15', null, '客户驳回通知', 'OPENTM414173928', null, '0');
INSERT INTO `s_templateset` VALUES ('16', null, '信息冲突通知', 'OPENTM414173940', null, '0');
INSERT INTO `s_templateset` VALUES ('17', null, '客户分配通知', 'OPENTM414174098', null, '0');
INSERT INTO `s_templateset` VALUES ('18', null, '预约进店提醒', 'OPENTM405765901', null, '0');
INSERT INTO `s_templateset` VALUES ('19', null, '再约提醒', 'OPENTM416748201', null, '0');
INSERT INTO `s_templateset` VALUES ('20', null, '签字通知', 'OPENTM410972039', '', '0');
INSERT INTO `s_templateset` VALUES ('21', null, '事项审核提醒', 'OPENTM412499555', '', '0');
INSERT INTO `s_templateset` VALUES ('22', null, '消费成功通知 ', 'OPENTM406121400', null, '0');
INSERT INTO `s_templateset` VALUES ('23', null, '待办任务通知 ', 'OPENTM206831895', null, '0');
INSERT INTO `s_templateset` VALUES ('24', null, '客户跟踪提醒 ', 'OPENTM416747652', null, '0');
INSERT INTO `s_templateset` VALUES ('25', null, '流程操作通知', 'OPENTM207793577', null, '0');
INSERT INTO `s_templateset` VALUES ('26', null, '验证码通知', 'OPENTM203026900', null, '0');
INSERT INTO `s_templateset` VALUES ('27', null, '故障通报通知', 'TM00204', null, '0');

-- ----------------------------
-- Table structure for s_tracksign
-- ----------------------------
DROP TABLE IF EXISTS `s_tracksign`;
CREATE TABLE `s_tracksign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Tracksign` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_tracksign
-- ----------------------------

-- ----------------------------
-- Table structure for s_unvalid_reason
-- ----------------------------
DROP TABLE IF EXISTS `s_unvalid_reason`;
CREATE TABLE `s_unvalid_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `is_delete` tinyint(1) DEFAULT '2',
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_unvalid_reason
-- ----------------------------

-- ----------------------------
-- Table structure for s_worktype
-- ----------------------------
DROP TABLE IF EXISTS `s_worktype`;
CREATE TABLE `s_worktype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `work_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_worktype
-- ----------------------------
INSERT INTO `s_worktype` VALUES ('1', '门市');
INSERT INTO `s_worktype` VALUES ('2', '礼服');
INSERT INTO `s_worktype` VALUES ('3', '拍照');
INSERT INTO `s_worktype` VALUES ('4', '摄影助理');
INSERT INTO `s_worktype` VALUES ('5', '灯光师');
INSERT INTO `s_worktype` VALUES ('6', '选片');
INSERT INTO `s_worktype` VALUES ('7', '化妆');
INSERT INTO `s_worktype` VALUES ('8', '取件');
INSERT INTO `s_worktype` VALUES ('9', '美编');
INSERT INTO `s_worktype` VALUES ('10', '调色');
INSERT INTO `s_worktype` VALUES ('11', '设计');
INSERT INTO `s_worktype` VALUES ('12', '修片');
INSERT INTO `s_worktype` VALUES ('13', '沟通');
INSERT INTO `s_worktype` VALUES ('14', '收款');
INSERT INTO `s_worktype` VALUES ('15', '录影');
INSERT INTO `s_worktype` VALUES ('16', '司机');
INSERT INTO `s_worktype` VALUES ('17', '记录');
INSERT INTO `s_worktype` VALUES ('21', '话务');
INSERT INTO `s_worktype` VALUES ('22', '系统管理员');
INSERT INTO `s_worktype` VALUES ('23', '客资提报');
INSERT INTO `s_worktype` VALUES ('24', '筛客人');
INSERT INTO `s_worktype` VALUES ('25', '导师');
INSERT INTO `s_worktype` VALUES ('26', '其他');
INSERT INTO `s_worktype` VALUES ('27', '液化');
INSERT INTO `s_worktype` VALUES ('28', '育婴师');
INSERT INTO `s_worktype` VALUES ('29', '客服');
INSERT INTO `s_worktype` VALUES ('30', '市场');
-- ----------------------------
-- Table structure for s_work_type_level
-- ----------------------------
DROP TABLE IF EXISTS `s_work_type_level`;
CREATE TABLE `s_work_type_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_id` int(11) DEFAULT NULL,
  `work_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_work_type_level
-- ----------------------------

-- ----------------------------
-- Table structure for s_wx_template
-- ----------------------------
DROP TABLE IF EXISTS `s_wx_template`;
CREATE TABLE `s_wx_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wtempalte_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wtempalte_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_wx_template
-- ----------------------------

-- ----------------------------
-- Table structure for s_zhijiset
-- ----------------------------
DROP TABLE IF EXISTS `s_zhijiset`;
CREATE TABLE `s_zhijiset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fatid` int(11) DEFAULT NULL,
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade` int(11) DEFAULT '1',
  `fatname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_zhijiset
-- ----------------------------

-- ----------------------------
-- Table structure for vip_users
-- ----------------------------
DROP TABLE IF EXISTS `vip_users`;
CREATE TABLE `vip_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `nickname` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `unionid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `headimgurl` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sign_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT '0',
  `update_time` datetime DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8_unicode_ci DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of vip_users
-- ----------------------------

-- ----------------------------
-- Table structure for vip_users_order
-- ----------------------------
DROP TABLE IF EXISTS `vip_users_order`;
CREATE TABLE `vip_users_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `order_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of vip_users_order
-- ----------------------------
