/*
 * Decompiled with CFR 0.152.
 */
package org.soler.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soler.common.util.SolerUtil;

public class SolerConfig {
    private static Logger log = LoggerFactory.getLogger(SolerConfig.class);
    private static SolerConfig config = null;
    private Properties holerConf = new Properties();

    public static SolerConfig getConfig() {
        if (null == config) {
            config = new SolerConfig();
        }
        return config;
    }

    public SolerConfig() {
        this.initConfig("org/holer/conf/holer.conf");
        this.initConfig(this.getOutSavePath() + File.separatorChar + "holer.conf");
        try {
            String configFilePath = this.getOutSavePath() + File.separatorChar + "holer.conf";
            FileInputStream inputStream = new FileInputStream(new File(configFilePath));
            if (inputStream != null) {
                this.holerConf.load(inputStream);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initConfig(String confFile) {
        InputStream is;
        block5: {
            is = null;
            is = SolerConfig.class.getClassLoader().getResourceAsStream(confFile);
            if (null != is) break block5;
            log.warn("Can not find configuration file: " + confFile);
            SolerUtil.close(is);
            return;
        }
        try {
            this.holerConf.load(is);
        }
        catch (IOException e) {
            try {
                log.error("Failed to load configuration file.");
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SolerUtil.close(is);
                throw throwable;
            }
        }
        SolerUtil.close(is);
    }

    public String strValue(String key) {
        return this.holerConf.getProperty(key);
    }

    public String strValue(String key, String defaultValue) {
        String value = this.strValue(key);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public Integer intValue(String key) {
        String value = this.holerConf.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if (StringUtils.isNumeric((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public int intValue(String key, int defaultValue) {
        Integer value = this.intValue(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public Boolean boolValue(String key) {
        String value = this.holerConf.getProperty(key);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (!value.equals(Boolean.toString(false)) && !value.equals(Boolean.toString(true))) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public boolean boolValue(String key, Boolean defaultValue) {
        Boolean value = this.boolValue(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public void saveValue(String key, String value) {
        this.holerConf.setProperty(key, value);
    }

    public boolean save() {
        File file = this.getOutSaveFile(null);
        if (file != null) {
            return this.sevePropertice(file.getAbsolutePath());
        }
        return false;
    }

    public String getOutSavePath() {
        String filePath = System.getProperty("user.dir");
        String confPath = filePath + File.separatorChar + "conf";
        return confPath;
    }

    public File getOutSaveFile(NMB nm) {
        File f = new File(this.getOutSavePath());
        System.out.print("\u914d\u7f6e\u4fdd\u5b58\u4f4d\u7f6e:" + this.getOutSavePath());
        if (nm != null) {
            nm.String(f.getAbsolutePath());
        }
        File file = new File(f.getAbsolutePath() + File.separator + "holer.conf");
        if (nm != null) {
            nm.String(file.getAbsolutePath());
        }
        if (!file.exists()) {
            if (nm != null) {
                nm.String("\u4e0d\u5b58\u5728");
            }
            this.createFile(file);
        }
        return file;
    }

    private Boolean sevePropertice(String fileName) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            this.holerConf.store(fos, "the primary key of article table");
            return true;
        }
        catch (IOException var7) {
            log.error("Failed to load configuration file.");
            return false;
        }
    }

    void createFile(File file) {
        if (file != null) {
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                String ms = e.getMessage();
                if (ms == null || ms.length() < 1) {
                    ms = e.getCause().getMessage();
                }
                JOptionPane.showMessageDialog(null, "\u6807\u9898\u3010\u51fa\u9519\u5566\u3011", "IOException" + ms, 0);
            }
        }
    }

    public static interface NMB {
        public void String(String var1);
    }
}

